/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DataBus;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.console.AbstractEngine;
import com.intellij.database.console.DatabaseAccessController;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.SuppressUserStackTrace;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.ConnectionRequestor;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.audit.AuditService;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementData;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatementMark;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.SmartStatementsUtil;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.PreparedStatementContext;
import com.intellij.database.datagrid.RawStatementContext;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.datagrid.mutating.QueryData;
import com.intellij.database.datagrid.mutating.RowMutation;
import com.intellij.database.datagrid.mutating.RowQueryData;
import com.intellij.database.datagrid.mutating.RowUpdateData;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.remote.jdbc.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.actions.TransactionAction;
import com.intellij.database.run.audit.MeasuringDataAuditor;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

public class JdbcEngine
extends AbstractEngine
implements DataProducer,
ConnectionRequestor {
    public static final Key<Boolean> SUPPORTS_SAVEPOINTS_KEY = Key.create((String)"SUPPORTS_SAVEPOINTS");
    private static final Logger LOG = Logger.getInstance(JdbcEngine.class);
    private static final TObjectHashingStrategy<RowQueryData> QUERY_DATA_HASHING_STRATEGY = new TObjectHashingStrategy<RowQueryData>(){

        public int computeHashCode(RowQueryData object) {
            return Comparing.hashcode(object.getColumnsData());
        }

        public boolean equals(RowQueryData o1, RowQueryData o2) {
            return Comparing.equal(o1.getColumnsData(), o2.getColumnsData());
        }
    };
    private final DatabaseAccessController myDatabaseAccessController;
    private final JdbcDriverManager myDriverManager;
    private final List<SmartStatementMark> myCurrentStatements;
    private final LocalDataSource myDataSource;
    private final EngineAuditService myAuditService;
    private final ThrowableComputable<GuardedRef<DatabaseConnection>, Exception> myConnectionFactory;
    private volatile GuardedRef<DatabaseConnection> myConnection;
    private final DatabaseDepartment myDepartment;
    private DataRequest.TxMarker myTxMarker;
    private ConsoleRunConfiguration myConfiguration;
    private final AtomicReference<State> myState;
    private boolean mySupportsSavepoints;
    private volatile SearchPath mySearchPath;
    private DatabaseDialectEx myDialect;
    private DatabaseFamilyId myFamilyId;

    public JdbcEngine(@NotNull Project project, @NotNull DataBus.Producing messageBus, @NotNull LocalDataSource dataSource, @Nullable ConsoleRunConfiguration configuration, @NotNull DatabaseDepartment department) {
        if (project == null) {
            JdbcEngine.$$$reportNull$$$0(0);
        }
        if (messageBus == null) {
            JdbcEngine.$$$reportNull$$$0(1);
        }
        if (dataSource == null) {
            JdbcEngine.$$$reportNull$$$0(2);
        }
        if (department == null) {
            JdbcEngine.$$$reportNull$$$0(3);
        }
        this(project, messageBus, dataSource, configuration, department, dataSource.isAutoCommit());
    }

    public JdbcEngine(@NotNull Project project, @NotNull DataBus.Producing messageBus, @NotNull LocalDataSource dataSource, @Nullable ConsoleRunConfiguration configuration, @NotNull DatabaseDepartment department, boolean autoCommit) {
        if (project == null) {
            JdbcEngine.$$$reportNull$$$0(4);
        }
        if (messageBus == null) {
            JdbcEngine.$$$reportNull$$$0(5);
        }
        if (dataSource == null) {
            JdbcEngine.$$$reportNull$$$0(6);
        }
        if (department == null) {
            JdbcEngine.$$$reportNull$$$0(7);
        }
        super(project, messageBus);
        this.myCurrentStatements = ContainerUtil.createConcurrentList();
        this.myState = new AtomicReference<State>(State.IDLE);
        this.myDataSource = dataSource;
        this.myDriverManager = JdbcDriverManager.getDriverManager(project);
        this.myConfiguration = configuration;
        this.myConnectionFactory = configuration == null ? () -> {
            this.myConfiguration = this.myDriverManager.getDefaultRunConfiguration(this.myDataSource);
            return this.createConnection();
        } : this::createConnection;
        this.myDepartment = department;
        this.myTxMarker = DataRequest.getInitialTxMarker(autoCommit);
        this.myDatabaseAccessController = this.createAccessController();
        this.myAuditService = new EngineAuditService();
    }

    @NotNull
    private DatabaseAccessController createAccessController() {
        Project project = this.getProject();
        DbDataSource dataSource = DbImplUtil.getDbDataSource(project, this.myDataSource);
        if (dataSource == null) {
            DatabaseAccessController databaseAccessController = DatabaseAccessController.alwaysSuccess();
            if (databaseAccessController == null) {
                JdbcEngine.$$$reportNull$$$0(8);
            }
            return databaseAccessController;
        }
        DatabaseAccessController.PsiBasedReadOnly psiBased = new DatabaseAccessController.PsiBasedReadOnly(project, DbSqlUtil.getSqlDialect(this.myDataSource), dataSource, () -> this.mySearchPath);
        DatabaseAccessController.DataSourceBased dataSourceBased = new DatabaseAccessController.DataSourceBased(dataSource, psiBased);
        if (dataSourceBased == null) {
            JdbcEngine.$$$reportNull$$$0(9);
        }
        return dataSourceBased;
    }

    @Nullable
    private GuardedRef<DatabaseConnection> createConnection() throws SQLException {
        ObjectPath currentNamespace = this.getCurrentNamespace();
        GuardedRef<DatabaseConnection> connection = DatabaseConnectionManager.getInstance().build(this.getProject(), this.myDataSource).setRequestor(this).setRunConfiguration(this.myConfiguration).setDestination(currentNamespace).create();
        if (connection != null) {
            String dest = "";
            if (connection.get().getConnectionPoint() != this.myDataSource) {
                String bounded;
                DatabaseDriver driver = this.myDataSource.getDatabaseDriver();
                DatabaseDriver.Bounds bounds = driver == null ? null : driver.getConnectionBounds();
                String string = bounded = bounds != null ? JdbcUrlParserUtil.getObjectItem(currentNamespace, bounds.boundTo) : null;
                if (StringUtil.isNotEmpty((String)bounded)) {
                    dest = " to " + bounded;
                }
            }
            this.getDataAuditor().print(this.getRequestContext(), "Connected" + dest);
        }
        return connection;
    }

    @Nullable
    public DatabaseConnection getCurrentConnection() {
        return this.myConnection == null ? null : this.myConnection.get();
    }

    @Nullable
    public DatabaseConnection getConnection() throws Exception {
        return this.getConnection(true);
    }

    @Nullable
    private SearchPath getSearchPath() {
        return this.mySearchPath;
    }

    private void requestSearchPath(@NotNull DatabaseConnection connection) {
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(10);
        }
        try {
            this.setSearchPath(this.myDialect.tryToLoadSearchPath(this.myDataSource, connection));
        }
        catch (Exception e) {
            LOG.warn(JdbcEngine.getErrorMessage(e, this.myDataSource.getName(), this.myDataSource.getFamilyId()));
        }
    }

    private void requestSearchPathTransparent(@NotNull DatabaseConnection connection) throws Exception {
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(11);
        }
        new PotentiallyAtomicOperation(new PotentiallyTransparentOperation(){

            @Override
            boolean transparent(@NotNull DatabaseConnection connection) {
                if (connection == null) {
                    2.$$$reportNull$$$0(0);
                }
                JdbcEngine.this.requestSearchPath(connection);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine$2", "transparent"));
            }
        }, this.isTransactionStarted()).perform(connection);
    }

    private void setSearchPath(@Nullable SearchPath searchPath) {
        this.mySearchPath = searchPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private DatabaseConnection getConnection(boolean setCurrentSchema) throws Exception {
        DatabaseConnection connection = this.getCurrentConnection();
        boolean freshConnection = false;
        if (!this.isConnectionReady(connection)) {
            ThrowableComputable<GuardedRef<DatabaseConnection>, Exception> throwableComputable = this.myConnectionFactory;
            synchronized (throwableComputable) {
                GuardedRef ref;
                this.releaseConnection();
                this.myConnection = ref = (GuardedRef)this.myConnectionFactory.compute();
                connection = ref == null ? null : (DatabaseConnection)ref.get();
                freshConnection = true;
            }
            this.myFamilyId = this.myDataSource.getFamilyId();
            this.myDialect = (DatabaseDialectEx)ObjectUtils.notNull((Object)DbImplUtil.guessDatabaseDialect(this.myFamilyId), (Object)GenericDialect.INSTANCE);
        }
        if (!this.isConnectionReady(connection)) {
            this.releaseConnection();
            this.myConnection = null;
            connection = null;
        }
        if (connection == null) {
            this.getDataAuditor().error(this.getRequestContext(), "Connection failed", null);
        } else {
            this.prepareConnection(connection, setCurrentSchema && freshConnection);
        }
        return connection;
    }

    @Override
    public boolean cancelPendingRequests() {
        super.cancelPendingRequests();
        DataRequest.Context context = this.getRequestContextIfAny();
        if (context == null) {
            return false;
        }
        if (this.myState.compareAndSet(State.STREAMING, State.CANCELED)) {
            this.getDataAuditor().print(context, "Cancelling...");
            return true;
        }
        if (this.myState.compareAndSet(State.RUNNING, State.CANCELED)) {
            ArrayList marks = ContainerUtil.newArrayList(this.myCurrentStatements);
            if (marks.isEmpty()) {
                return true;
            }
            AppExecutorUtil.getAppExecutorService().submit(() -> {
                if (this.getRequestContextIfAny() == context) {
                    TimeoutUtil.sleep((long)500L);
                    if (this.getRequestContextIfAny() == context) {
                        this.getDataAuditor().print(context, "Cancelling...");
                        for (SmartStatementMark mark2 : marks) {
                            try {
                                mark2.cancel();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
            });
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public DatabaseDepartment getDepartment() {
        DatabaseDepartment databaseDepartment = this.myDepartment;
        if (databaseDepartment == null) {
            JdbcEngine.$$$reportNull$$$0(12);
        }
        return databaseDepartment;
    }

    @NotNull
    public LocalDataSource getDataSource() {
        LocalDataSource localDataSource = this.myDataSource;
        if (localDataSource == null) {
            JdbcEngine.$$$reportNull$$$0(13);
        }
        return localDataSource;
    }

    public boolean isStarted() {
        return this.myDriverManager.getActiveConfigurations(this.myDataSource).contains((Object)this.myConfiguration);
    }

    @Override
    public void terminate() {
        super.terminate();
        GuardedRef<DatabaseConnection> connection = this.myConnection;
        ConsoleRunConfiguration configuration = this.myConfiguration;
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (connection != null) {
                connection.close();
            }
            this.myDriverManager.releaseDriver(this.myDataSource, configuration);
        });
        this.myConnection = null;
    }

    @Override
    public void visitQuery(@NotNull DataRequest.QueryRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(14);
        }
        this.submitRequest(r, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> {
            Executor executor;
            if (r == null) {
                JdbcEngine.$$$reportNull$$$0(94);
            }
            if ((executor = this.createExecutor(r)) == null) {
                return false;
            }
            DatabaseConnection connection = this.getConnection();
            QueryExecutionOperation operation2 = new QueryExecutionOperation(executor, r);
            return connection != null && new SilentOperation(operation2, this.myFamilyId.isRedshift() || this.isTransactionStarted()).perform(connection);
        }));
    }

    @Override
    public void visitCall(DataRequest.CallRequest r) {
        this.submitRequest(r, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> {
            DatabaseConnection connection = this.getConnection();
            if (connection == null) {
                return false;
            }
            CallOperation call = new CallOperation(r);
            return new TransactionOperation(call, this.isTransactionStarted()).perform(connection);
        }));
    }

    @Override
    public void visitUpdate(@NotNull DataRequest.UpdateRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(15);
        }
        this.executeUpdateStatement(r, ContainerUtil.list((Object[])new QueryData[]{this.buildDataForUpdate(r)}));
    }

    @Override
    public void visitInsert(@NotNull DataRequest.InsertRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(16);
        }
        this.executeUpdateStatement(r, ContainerUtil.list((Object[])new QueryData[]{this.buildDataForInsert(r)}));
    }

    @Override
    public void visitDelete(@NotNull DataRequest.DeleteRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(17);
        }
        this.executeUpdateStatement(r, ContainerUtil.list((Object[])new QueryData[]{this.buildDataForDelete(r)}));
    }

    @Override
    public void visitComposite(DataRequest.CompositeRequest r) {
        final ArrayList infos = ContainerUtil.newArrayList();
        for (DataRequest.DmlRequest request : r.requests) {
            request.accept(new DataRequest.Visitor(){

                @Override
                public void visitInsert(DataRequest.InsertRequest r) {
                    infos.add(JdbcEngine.this.buildDataForInsert(r));
                }

                @Override
                public void visitUpdate(DataRequest.UpdateRequest r) {
                    infos.add(JdbcEngine.this.buildDataForUpdate(r));
                }

                @Override
                public void visitDelete(DataRequest.DeleteRequest r) {
                    infos.add(JdbcEngine.this.buildDataForDelete(r));
                }
            });
        }
        this.executeUpdateStatement(r, infos);
    }

    @Override
    public void visitTx(DataRequest.TxRequest r) {
        this.submitRequest(r, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> {
            if (this.myTxMarker.getOwner() == null || this.getCurrentConnection() == null) {
                this.suppressAudit();
                return true;
            }
            DatabaseConnection connection = this.getConnection();
            if (connection == null || !this.isConnectionReady(connection)) {
                this.suppressAudit();
                return false;
            }
            boolean autoCommit = connection.getAutoCommit();
            try {
                if (!autoCommit && this.myTxMarker.getOwner() != null) {
                    if (r.command == DataRequest.TxCommand.COMMIT) {
                        connection.commit();
                    } else {
                        connection.rollback();
                    }
                    this.getDataAuditor().txCompleted(this.getRequestContext(), r.command == DataRequest.TxCommand.COMMIT);
                    this.suppressAudit();
                }
            }
            finally {
                this.myTxMarker = DataRequest.NONE;
            }
            return true;
        }));
    }

    @Override
    public void visitSchemaSwitch(@NotNull DataRequest.SchemaSwitchRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(18);
        }
        this.submitRequest(r, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> {
            DatabaseConnection connection;
            if (r == null) {
                JdbcEngine.$$$reportNull$$$0(93);
            }
            DatabaseConnection prevConnection = connection = this.getCurrentConnection();
            boolean reconnect = this.willReconnect(r.pathToSwitch.getCurrent());
            if (!r.forced && reconnect && connection != null) {
                this.suppressAudit();
                return Boolean.FALSE;
            }
            if (reconnect && connection != null) {
                this.releaseConnection();
            }
            if (connection == null && !r.forced) {
                this.setSearchPath(r.pathToSwitch);
                this.suppressAudit();
                return Boolean.TRUE;
            }
            if (reconnect) {
                this.setSearchPath(r.pathToSwitch);
                connection = this.getConnection(true);
                return connection != null;
            }
            connection = this.getConnection(false);
            return connection != null && this.performSchemaSwitch(connection, r.pathToSwitch, prevConnection == connection);
        }));
    }

    @Override
    public void visitRaw(DataRequest.RawRequest r) {
        this.submitRequest(r, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> {
            DatabaseConnection connection = this.getConnection();
            if (connection == null) {
                return false;
            }
            try {
                r.processRaw(this.getRequestContext(), connection);
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable ex) {
                this.getRequestContext().reportException(ex, null);
            }
            return true;
        }));
    }

    @Override
    @NotNull
    protected DataRequest.Context createRequestContext(@NotNull DataRequest request) {
        boolean ownerFailed;
        if (request == null) {
            JdbcEngine.$$$reportNull$$$0(19);
        }
        boolean startedTransaction = false;
        if (!this.isConnectionReady(this.getCurrentConnection()) || this.myTxMarker == DataRequest.NONE) {
            this.myTxMarker = DataRequest.getInitialTxMarker(this.myTxMarker == DataRequest.AUTO_COMMIT || this.myTxMarker == DataRequest.NONE);
        }
        boolean bl = ownerFailed = this.myTxMarker.getOwner() != null && this.myTxMarker != request.txMarker;
        if (!(ownerFailed || request instanceof DataRequest.TxRequest || request.txMarker != DataRequest.START_NEW && this.myTxMarker != DataRequest.START_NEW)) {
            startedTransaction = true;
            this.myTxMarker = DataRequest.newTxMarker("@" + request.owner.getDisplayName(), request.owner);
            final DataRequest.TxMarker marker = this.myTxMarker;
            if (marker.getOwner() instanceof Disposable) {
                Disposer.register((Disposable)((Disposable)request.owner), (Disposable)new Disposable(){

                    public void dispose() {
                        if (JdbcEngine.this.isDisposed()) {
                            return;
                        }
                        JdbcEngine.this.processRequest(DataRequest.newTxRollback(marker));
                    }
                });
            }
        }
        MyContext context = new MyContext(this, request, this.mySearchPath, startedTransaction);
        if (ownerFailed) {
            JdbcEngine.reportError(context, "locked by transaction: " + this.myTxMarker);
        }
        context.putUserData(SUPPORTS_SAVEPOINTS_KEY, this.mySupportsSavepoints);
        MyContext myContext = context;
        if (myContext == null) {
            JdbcEngine.$$$reportNull$$$0(20);
        }
        return myContext;
    }

    @Override
    @NotNull
    public AuditService getAuditService() {
        EngineAuditService engineAuditService = this.myAuditService;
        if (engineAuditService == null) {
            JdbcEngine.$$$reportNull$$$0(21);
        }
        return engineAuditService;
    }

    private static void reportError(@NotNull DataRequest.Context context, @NotNull String message) {
        if (context == null) {
            JdbcEngine.$$$reportNull$$$0(22);
        }
        if (message == null) {
            JdbcEngine.$$$reportNull$$$0(23);
        }
        ExecutionException th = new ExecutionException(message);
        context.reportException(th, null);
        throw new ProcessCanceledException((Throwable)th);
    }

    @Nullable
    private Object getQueryType(@NotNull String queryText, @NotNull DataRequest r) {
        if (queryText == null) {
            JdbcEngine.$$$reportNull$$$0(24);
        }
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(25);
        }
        try {
            if (r instanceof ConsoleDataRequest) {
                return ((ConsoleDataRequest)r).resultType;
            }
            LocalDataSource dataSource = this.getDataSource();
            return DbSqlUtil.parseQueryType(this.getProject(), DbSqlUtil.getSqlDialect(dataSource), DbSqlUtil.getDbDataSource(this.getProject(), dataSource), this.getSearchPath(), queryText, null);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Nullable
    public ObjectPath getCurrentNamespace() {
        return SearchPath.getCurrent((SearchPath)this.mySearchPath);
    }

    private boolean isConnectionReady(@Nullable DatabaseConnection connection) {
        if (connection == null) {
            return false;
        }
        try {
            if (this.myFamilyId.isMysql()) {
                return connection.getJdbcConnection().isValid(20);
            }
            return !connection.getJdbcConnection().isClosed();
        }
        catch (Exception e) {
            return false;
        }
    }

    private void prepareConnection(@NotNull DatabaseConnection connection, boolean setCurrentSchema) throws Exception {
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(26);
        }
        boolean autoCommit = this.myTxMarker == DataRequest.AUTO_COMMIT;
        DatabaseMetaData metaData = connection.getMetaData();
        boolean bl = this.mySupportsSavepoints = metaData != null && metaData.supportsSavepoints();
        if (connection.getAutoCommit() != autoCommit) {
            connection.setAutoCommit(autoCommit);
        }
        this.setTxIsolation(connection);
        try {
            if ((autoCommit || DbImplUtil.supportsReadOnlyChangeDuringTx(this.myFamilyId)) && DbImplUtil.supportsReadOnlyChangeOnTheFly(this.myFamilyId)) {
                connection.setReadOnly(this.myDataSource.isReadOnly());
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        SearchPath schema = this.mySearchPath;
        if (setCurrentSchema && schema != null) {
            if (DbImplUtil.supportsDynamicSchemaSwitching(this.myDataSource)) {
                this.performSchemaSwitch(connection, schema, false);
            }
        } else if (schema == null) {
            this.requestSearchPathTransparent(connection);
        }
    }

    private void setTxIsolation(@NotNull DatabaseConnection dbConnection) throws SQLException {
        if (dbConnection == null) {
            JdbcEngine.$$$reportNull$$$0(27);
        }
        DataRequest.Context context = this.getRequestContextIfAny();
        if (!TransactionAction.TxIsolation.levelsSupported(this.myFamilyId) || context == null) {
            return;
        }
        DataRequest.TxIsolationOwner owner = (DataRequest.TxIsolationOwner)ObjectUtils.tryCast((Object)context.request.owner, DataRequest.TxIsolationOwner.class);
        if (owner == null || !this.shouldChangeIsolation(dbConnection, owner, context)) {
            return;
        }
        dbConnection.getJdbcConnection().setTransactionIsolation(owner.getTxIsolation());
    }

    private void storeTxIsolation(@NotNull DataRequest.Context context, @NotNull DatabaseConnection connection) {
        if (context == null) {
            JdbcEngine.$$$reportNull$$$0(28);
        }
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(29);
        }
        if (!TransactionAction.TxIsolation.levelsSupported(this.myFamilyId)) {
            return;
        }
        Connection jdbcConnection = connection.getJdbcConnection();
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            if (metaData == null || !metaData.supportsTransactions()) {
                return;
            }
            int isolation = jdbcConnection.getTransactionIsolation();
            ObjectUtils.consumeIfCast((Object)((Object)context), DataRequest.TxContext.class, ex -> ex.setIsolation(isolation));
        }
        catch (SQLException e) {
            LOG.warn((Throwable)e);
        }
    }

    private boolean shouldChangeIsolation(@NotNull DatabaseConnection connection, @NotNull DataRequest.TxIsolationOwner owner, @NotNull DataRequest.Context context) {
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(30);
        }
        if (owner == null) {
            JdbcEngine.$$$reportNull$$$0(31);
        }
        if (context == null) {
            JdbcEngine.$$$reportNull$$$0(32);
        }
        try {
            DatabaseMetaData data = connection.getMetaData();
            Connection jdbcConnection = connection.getJdbcConnection();
            int ownerIsolation = owner.getTxIsolation();
            return !(data == null || !data.supportsTransactions() || context.request.txMarker != DataRequest.AUTO_COMMIT && context.request.txMarker != DataRequest.START_NEW || ownerIsolation == TransactionAction.TxIsolation.DEFAULT.getIsolation() || !this.myFamilyId.isSybase() && !data.supportsTransactionIsolationLevel(ownerIsolation) || jdbcConnection.getTransactionIsolation() == ownerIsolation);
        }
        catch (SQLException e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    private boolean performSchemaSwitch(@NotNull DatabaseConnection connection, @NotNull SearchPath searchPath, boolean allowReset) {
        if (connection == null) {
            JdbcEngine.$$$reportNull$$$0(33);
        }
        if (searchPath == null) {
            JdbcEngine.$$$reportNull$$$0(34);
        }
        try {
            if (DbImplUtil.switchSchemaThroughJdbc(searchPath, connection, this.myDataSource)) {
                this.setSearchPath(searchPath);
                return true;
            }
        }
        catch (SQLException e) {
            this.getRequestContext().reportException(e, null);
            return false;
        }
        String setSchemaSql = DbImplUtil.getSearchPathSql(searchPath, this.myDataSource, this.myDialect);
        String sql = setSchemaSql == null && allowReset && searchPath.getCurrent().kind == ObjectKind.DATABASE && JdbcUrlParserUtil.isDatabaseBounded(connection.getConnectionPoint()) ? this.myDialect.sqlResetSearchPath() : setSchemaSql;
        if (sql == null) {
            return false;
        }
        boolean requestSearchPath = sql != setSchemaSql;
        return SmartStatements.poweredBy(connection).simple().execute(sql, __ -> {
            if (connection == null) {
                JdbcEngine.$$$reportNull$$$0(91);
            }
            if (searchPath == null) {
                JdbcEngine.$$$reportNull$$$0(92);
            }
            if (requestSearchPath) {
                this.requestSearchPath(connection);
            } else {
                this.setSearchPath(searchPath);
            }
            return true;
        }).rightOr(false);
    }

    private void suppressAudit() {
        MeasuringDataAuditor.SILENT_KEY.set((UserDataHolder)this.getRequestContext(), (Object)true);
    }

    @Nullable
    private RowQueryData buildDataForSelect(@NotNull DataRequest.ConditionQueryRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(35);
        }
        RowQueryData data = r.rowQueryData;
        String sql = data.getSql();
        String alias = r.table == null ? DbImplUtil.findFreeAlias(this.getProject(), this.myDialect, sql, "a") : "t";
        DdlBuilder builder = this.getConditionRequestQuery(r, alias);
        if (builder == null) {
            return null;
        }
        OffsetSavingBuilder offsetSavingBuilder = new OffsetSavingBuilder(builder);
        offsetSavingBuilder.space().keyword("WHERE").space();
        List<ColumnQueryData> newData = DbImplUtil.composeWhereConditionWithParameters(offsetSavingBuilder, data, alias, this.myDialect);
        return new RowQueryData(newData, offsetSavingBuilder.getOffsets(), offsetSavingBuilder.getStatement());
    }

    @Nullable
    private DdlBuilder getConditionRequestQuery(@NotNull DataRequest.ConditionQueryRequest r, @NotNull String alias) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(36);
        }
        if (alias == null) {
            JdbcEngine.$$$reportNull$$$0(37);
        }
        if (r.table != null) {
            return DbImplUtil.createSelectAllQuery(r.table, this.myDialect, this.myDataSource);
        }
        String sql = r.rowQueryData.getSql();
        return DbImplUtil.wrapSelectQuery(this.getProject(), this.myDialect, sql, alias);
    }

    @NotNull
    public QueryData buildDataForDelete(@NotNull DataRequest.DeleteRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(38);
        }
        QueryData queryData = JdbcEngine.mergedQueryData(r.context.getMutations(), (Function<RowMutation, RowQueryData>)((Function)mutation -> {
            if (r == null) {
                JdbcEngine.$$$reportNull$$$0(90);
            }
            String alias = this.myFamilyId.isDb2() ? "t" : null;
            OffsetSavingBuilder builder = new OffsetSavingBuilder(DbImplUtil.createBuilderForExec(this.myDialect));
            List<ColumnQueryData> filtered = DbImplUtil.getWhereClauseColumns(r.context.getTable(), mutation.getData(), this.myDialect);
            if (this.myFamilyId.isClickHouse()) {
                builder.keyword("ALTER").space().keyword("TABLE").space().qualifiedRef((DasObject)r.context.getTable()).space().keyword("DELETE").space();
            } else {
                builder.keyword("DELETE").space().keyword("FROM").space().qualifiedRef((DasObject)r.context.getTable()).space();
            }
            if (alias != null) {
                builder.alias(alias).space();
            }
            builder.keyword("WHERE").space();
            List<ColumnQueryData> whereData = DbImplUtil.composeWhereConditionWithParameters(builder, filtered, alias, this.myDialect);
            String sql = builder.getStatement();
            return new RowQueryData(whereData, builder.getOffsets(), sql);
        }), QueryData.Operation.DELETE);
        if (queryData == null) {
            JdbcEngine.$$$reportNull$$$0(39);
        }
        return queryData;
    }

    @NotNull
    public QueryData buildDataForUpdate(@NotNull DataRequest.UpdateRequest r) {
        DatabaseFamilyId familyId;
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(40);
        }
        String alias = (familyId = this.myDataSource.getFamilyId()).isSqlite() || familyId.isPostgres() || familyId.isTransactSql() || familyId == DatabaseFamilyId.VERTICA || familyId == DatabaseFamilyId.FRONTBASE ? null : "t";
        QueryData queryData = JdbcEngine.mergedQueryData(r.context.getMutations(), (Function<RowMutation, RowQueryData>)((Function)mutation -> {
            if (r == null) {
                JdbcEngine.$$$reportNull$$$0(89);
            }
            DataConsumer.Row row = mutation.getRow();
            List keyColumns = DbImplUtil.getWhereClauseColumns(r.context.getTable(), (List)ObjectUtils.assertNotNull(r.context.getColumns()), this.myDialect);
            OffsetSavingBuilder builder = new OffsetSavingBuilder(DbImplUtil.createBuilderForExec(this.myDialect));
            builder.keyword("UPDATE").space().qualifiedRef((DasObject)r.context.getTable()).space();
            if (alias != null) {
                builder.alias(alias).space();
            }
            builder.keyword("SET").space();
            boolean first = true;
            ArrayList columnsData = ContainerUtil.newArrayList();
            for (ColumnQueryData data : mutation.getData()) {
                DataConsumer.Column targetColumn = data.getColumn();
                if (!first) {
                    builder.symbol(",").space();
                } else {
                    first = false;
                }
                if (alias != null) {
                    builder.alias(alias).symbol(".");
                }
                builder.identifier(targetColumn.name).space().symbol("=").space();
                Object value = data.getObject();
                if (value == ReservedCellValue.DEFAULT) {
                    builder.keyword("DEFAULT");
                    continue;
                }
                builder.placeholder();
                columnsData.add(data);
            }
            int escapingIndex = columnsData.size();
            builder.space().keyword("WHERE").space();
            List keyData = ContainerUtil.map(keyColumns, column2 -> new ColumnQueryData((DataConsumer.Column)column2, column2.getValue(row)));
            List<ColumnQueryData> whereData = DbImplUtil.composeWhereConditionWithParameters(builder, keyData, alias, this.myDialect);
            String sql = builder.getStatement();
            columnsData.addAll(whereData);
            return new RowQueryData(columnsData, builder.getOffsets(), sql, escapingIndex);
        }), QueryData.Operation.UPDATE);
        if (queryData == null) {
            JdbcEngine.$$$reportNull$$$0(41);
        }
        return queryData;
    }

    @NotNull
    public QueryData buildDataForInsert(@NotNull DataRequest.InsertRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(42);
        }
        DatabaseDialectEx dialect = (DatabaseDialectEx)ObjectUtils.notNull((Object)DbImplUtil.guessDatabaseDialect(this.myDataSource), (Object)GenericDialect.INSTANCE);
        ArrayList params = ContainerUtil.newArrayList();
        List<RowMutation> mutations = r.context.getMutations();
        OffsetSavingBuilder builder = new OffsetSavingBuilder(DbImplUtil.createBuilderForExec(dialect));
        for (RowMutation mutation : mutations) {
            List<AutoValueDescriptor.DelegateDescriptor<ColumnQueryData>> delegateDescriptors = JdbcEngine.createDescriptors(mutation);
            Condition isDefault = d -> !d.isComputed() && !d.isAutogenerated() && !d.hasDefault();
            List forInsert = ContainerUtil.filter(delegateDescriptors, (Condition)isDefault);
            List<Consumer<DdlBuilder>> placeholders = JdbcEngine.getPlaceholdersForInsert(delegateDescriptors, dialect);
            List<String> colNames = JdbcEngine.getColumnNamesForInsert(delegateDescriptors, dialect);
            dialect.sqlInsertInto(builder, r.context.getTable(), colNames, placeholders);
            String sql = builder.getStatement();
            int[] offsets = builder.getOffsets();
            int size = forInsert.size();
            List delegates = ContainerUtil.map((Collection)forInsert, AutoValueDescriptor.DelegateDescriptor::getDelegate);
            RowQueryData qData = new RowQueryData(delegates, offsets, sql, size);
            params.add(new RowUpdateData(qData, 1));
            builder.clear();
        }
        QueryData queryData = new QueryData(params, QueryData.Operation.INSERT);
        if (queryData == null) {
            JdbcEngine.$$$reportNull$$$0(43);
        }
        return queryData;
    }

    @NotNull
    private static List<AutoValueDescriptor.DelegateDescriptor<ColumnQueryData>> createDescriptors(@NotNull RowMutation mutation) {
        if (mutation == null) {
            JdbcEngine.$$$reportNull$$$0(44);
        }
        DataConsumer.Row row = mutation.getRow();
        List list = JBIterable.from(mutation.getData()).map(data -> {
            DataConsumer.Column column2 = data.getColumn();
            Object value = column2.getValue(row);
            boolean autogenerated = value == ReservedCellValue.GENERATED;
            boolean isDefault = value == ReservedCellValue.DEFAULT;
            boolean isComputed = value == ReservedCellValue.COMPUTED;
            return new AutoValueDescriptor.DelegateDescriptor<ColumnQueryData>((ColumnQueryData)data, autogenerated, isDefault, isComputed);
        }).toList();
        if (list == null) {
            JdbcEngine.$$$reportNull$$$0(45);
        }
        return list;
    }

    private void executeUpdateStatement(@NotNull DataRequest request, @NotNull List<QueryData> infos) {
        if (request == null) {
            JdbcEngine.$$$reportNull$$$0(46);
        }
        if (infos == null) {
            JdbcEngine.$$$reportNull$$$0(47);
        }
        this.submitRequest(request, (ThrowableComputable<Boolean, Exception>)((ThrowableComputable)() -> {
            QueryData unsupported;
            if (infos == null) {
                JdbcEngine.$$$reportNull$$$0(88);
            }
            if ((unsupported = (QueryData)ContainerUtil.find((Iterable)infos, i2 -> !i2.getOperation().isSupported(this.myFamilyId))) != null) {
                throw new StackTraceFreeException(String.format("%s is not supported by %s tables", unsupported.getOperation().displayName(), this.myFamilyId.getDisplayName()));
            }
            DatabaseConnection connection = this.getConnection();
            if (connection == null) {
                return false;
            }
            return new TransactionOperation(new UpdateOperation(infos), this.isTransactionStarted()).perform(connection);
        }));
    }

    @Nullable
    private Executor createExecutor(@NotNull DataRequest.QueryRequest r) {
        if (r == null) {
            JdbcEngine.$$$reportNull$$$0(48);
        }
        if (r instanceof DataRequest.ConditionQueryRequest) {
            RowQueryData data = this.buildDataForSelect((DataRequest.ConditionQueryRequest)r);
            return data == null ? null : new ParameterizedExecutor(data);
        }
        return new RegularExecutor(r);
    }

    @NotNull
    public static String getErrorMessage(Throwable th, String sourceName, DatabaseFamilyId familyId) {
        StringBuilder sb = new StringBuilder();
        String string = JdbcEngine.appendErrorMessage(sb, th, sourceName, familyId).toString().trim();
        if (string == null) {
            JdbcEngine.$$$reportNull$$$0(49);
        }
        return string;
    }

    @NotNull
    public static <T extends AutoValueDescriptor> List<String> getColumnNamesForInsert(@NotNull Collection<T> descriptors, @NotNull DatabaseDialectEx dialect) {
        if (descriptors == null) {
            JdbcEngine.$$$reportNull$$$0(50);
        }
        if (dialect == null) {
            JdbcEngine.$$$reportNull$$$0(51);
        }
        List list = JdbcEngine.shouldParticipateInInsert(descriptors, dialect).map(ColumnDescriptor::getName).toList();
        if (list == null) {
            JdbcEngine.$$$reportNull$$$0(52);
        }
        return list;
    }

    @NotNull
    public static <T extends AutoValueDescriptor> List<Consumer<DdlBuilder>> getPlaceholdersForInsert(@NotNull Collection<T> descriptors, @NotNull DatabaseDialectEx dialect) {
        if (descriptors == null) {
            JdbcEngine.$$$reportNull$$$0(53);
        }
        if (dialect == null) {
            JdbcEngine.$$$reportNull$$$0(54);
        }
        List list = JdbcEngine.shouldParticipateInInsert(descriptors, dialect).map(d -> d.isAutogenerated() || d.hasDefault() ? builder -> builder.plain("DEFAULT") : builder -> builder.placeholder()).toList();
        if (list == null) {
            JdbcEngine.$$$reportNull$$$0(55);
        }
        return list;
    }

    @NotNull
    private static <T extends AutoValueDescriptor> JBIterable<T> shouldParticipateInInsert(@NotNull Collection<T> descriptors, @NotNull DatabaseDialectEx dialect) {
        if (descriptors == null) {
            JdbcEngine.$$$reportNull$$$0(56);
        }
        if (dialect == null) {
            JdbcEngine.$$$reportNull$$$0(57);
        }
        JBIterable jBIterable = JBIterable.from(descriptors).filter(d -> {
            if (dialect == null) {
                JdbcEngine.$$$reportNull$$$0(87);
            }
            return !(d.isComputed() || d.isAutogenerated() && !dialect.supportsInsertDefaultIntoAutoVal() || d.hasDefault() && dialect.getFamilyId().isSqlite());
        });
        if (jBIterable == null) {
            JdbcEngine.$$$reportNull$$$0(58);
        }
        return jBIterable;
    }

    @NotNull
    private static QueryData mergedQueryData(@NotNull List<RowMutation> mutations, @NotNull Function<RowMutation, RowQueryData> converter, @NotNull QueryData.Operation operation2) {
        if (mutations == null) {
            JdbcEngine.$$$reportNull$$$0(59);
        }
        if (converter == null) {
            JdbcEngine.$$$reportNull$$$0(60);
        }
        if (operation2 == null) {
            JdbcEngine.$$$reportNull$$$0(61);
        }
        TObjectIntHashMap map = new TObjectIntHashMap(QUERY_DATA_HASHING_STRATEGY);
        for (RowMutation mutation : mutations) {
            RowQueryData qData = (RowQueryData)converter.fun((Object)mutation);
            if (map.increment((Object)qData)) continue;
            map.put((Object)qData, 1);
        }
        QueryData queryData = new QueryData(Arrays.stream(map.keys()).map(o -> new RowUpdateData((RowQueryData)o, map.get((Object)((RowQueryData)o)))).collect(Collectors.toList()), operation2);
        if (queryData == null) {
            JdbcEngine.$$$reportNull$$$0(62);
        }
        return queryData;
    }

    private static StringBuilder appendErrorMessage(@NotNull StringBuilder sb, @NotNull Throwable e, @NotNull String processName, @NotNull DatabaseFamilyId familyId) {
        String message;
        boolean isClickHouseException;
        if (sb == null) {
            JdbcEngine.$$$reportNull$$$0(63);
        }
        if (e == null) {
            JdbcEngine.$$$reportNull$$$0(64);
        }
        if (processName == null) {
            JdbcEngine.$$$reportNull$$$0(65);
        }
        if (familyId == null) {
            JdbcEngine.$$$reportNull$$$0(66);
        }
        Throwable t = ExceptionUtil.getRootCause((Throwable)e);
        String exceptionMessage = e.getMessage();
        boolean bl = isClickHouseException = exceptionMessage != null && StringUtil.startsWithIgnoreCase((String)exceptionMessage, (String)"ClickHouse exception");
        if (e != t && e instanceof SQLException && !isClickHouseException && StringUtil.indexOf((CharSequence)sb, (CharSequence)(message = JdbcUtil.getMessage((Throwable)e))) == -1) {
            sb.append(JdbcUtil.getMessagePrefix((Throwable)e)).append(message).append("\n");
        }
        if (t instanceof UnsupportedOperationException) {
            sb.append(JdbcUtil.getMessage((Throwable)t));
        } else if (t instanceof SQLException || isClickHouseException) {
            SQLException next;
            message = JdbcUtil.getMessage((Throwable)t);
            if (StringUtil.indexOf((CharSequence)sb, (CharSequence)message) == -1) {
                sb.append(JdbcUtil.getMessagePrefix((Throwable)t)).append(message);
            }
            ExceptionUtil.getUserStackTrace((Throwable)t, (Logger)LOG);
            if (StringUtil.contains((CharSequence)sb, (CharSequence)"ORA-12705:")) {
                sb.append("\n").append(DatabaseMessages.message((String)"error.message.ora.nls", (Object[])new Object[]{processName}));
            }
            if ((next = (SQLException)ObjectUtils.doIfCast((Object)t, SQLException.class, ex -> ex.getNextException())) != null && next != t) {
                JdbcEngine.appendErrorMessage(sb.append("\n"), next, processName, familyId);
            }
        } else if (t instanceof RemoteException) {
            sb.append(t.toString());
            ExceptionUtil.getUserStackTrace((Throwable)t, (Logger)LOG);
        } else if (t instanceof EOFException && e instanceof RemoteException) {
            sb.append(processName).append(": process exited");
        } else if (t instanceof FileNotFoundException && JdbcEngine.isRedshiftDriverFailure(t)) {
            sb.append(DatabaseMessages.message((String)"error.message.redshift.file.not.found", (Object[])new Object[0]));
        } else if (t instanceof IOException) {
            sb.append(t.toString());
        } else if (t instanceof ExecutionException) {
            sb.append(JdbcUtil.getMessage((Throwable)t));
        } else if (t instanceof SuppressUserStackTrace) {
            sb.append(JdbcUtil.getMessage((Throwable)t));
            ExceptionUtil.getUserStackTrace((Throwable)t, (Logger)LOG);
        } else if (t instanceof UnsafeUpdateRolledBackException) {
            sb.append(t.getMessage());
        } else if (t instanceof OutOfMemoryError) {
            sb.append(DatabaseMessages.message((String)"error.message.remote.oomerror", (Object[])new Object[]{processName}));
            LOG.info(t);
        } else if (t instanceof RuntimeException && familyId.isDerby() && sb.length() > 0) {
            ExceptionUtil.getUserStackTrace((Throwable)t, (Logger)LOG);
        } else {
            sb.append(ExceptionUtil.getUserStackTrace((Throwable)t, (Logger)LOG));
        }
        return sb;
    }

    private static boolean isRedshiftDriverFailure(@NotNull Throwable t) {
        if (t == null) {
            JdbcEngine.$$$reportNull$$$0(67);
        }
        return ContainerUtil.find((Object[])t.getStackTrace(), element -> StringUtil.contains((CharSequence)element.getClassName(), (CharSequence)"com.amazon.redshift.jdbc")) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printResultSet(@NotNull ResultSet resultSet, int resultSetIndex, int start, int pageSize, int chunkSize, int[] rowCount) throws Exception {
        if (resultSet == null) {
            JdbcEngine.$$$reportNull$$$0(68);
        }
        this.checkCanceled();
        DataRequest request = this.getRequestContext().request;
        DataConsumer handler = this.getDataConsumer();
        if (request instanceof DataRequest.IsolatedQueryRequest) {
            handler = (DataConsumer)((Object)request);
        }
        if (start < 0) {
            handler = new LastPageHandler(handler, start, pageSize);
            pageSize = -1;
        }
        RemoteResultSet remoteResultSet = (RemoteResultSet)RemoteUtil.castToRemoteNotNull((Object)resultSet, RemoteResultSet.class);
        DataConsumer.Column[] columnsDescr = JdbcEngine.getColumnDescriptors(resultSet, this.myDialect);
        handler.setColumns(this.getRequestContext(), resultSetIndex, columnsDescr, Math.max(1, start));
        rowCount[0] = 0;
        int rowNum = 0;
        boolean hasNext = true;
        ArrayList<DataConsumer.Row> rows = ContainerUtil.newArrayListWithCapacity((int)chunkSize);
        try {
            rowNum = remoteResultSet.scrollToPosition(0, start - 1);
            if (request instanceof DataRequest.RawQueryRequest) {
                List<Object[]> rowObjects;
                while (!(rowObjects = JdbcEngine.getObjects(resultSet, this.myDialect, this, -1, 1, true)).isEmpty()) {
                    this.checkCanceled();
                    DataConsumer.Row row = DataConsumer.Row.create(rowNum++, (Object[])ContainerUtil.getFirstItem(rowObjects));
                    handler.addRows(this.getRequestContext(), Collections.singletonList(row));
                    rowCount[0] = rowCount[0] + 1;
                    if (DbImplUtil.isPageSizeUnlimited(pageSize) || rowCount[0] < pageSize) continue;
                    break;
                }
                hasNext = !rowObjects.isEmpty() && resultSet.next();
            } else {
                int maxLobLength = DatabaseSettings.getSettings().getMaxLobLength();
                while (hasNext) {
                    int rowsToLoad;
                    this.checkCanceled();
                    int n = rowsToLoad = DbImplUtil.isPageSizeUnlimited(pageSize) ? chunkSize : Math.min(chunkSize, pageSize - rowCount[0]);
                    if (rowsToLoad == 0) break;
                    List<Object[]> data = JdbcEngine.getObjects(resultSet, this.myDialect, this, maxLobLength, rowsToLoad);
                    hasNext = data.size() == rowsToLoad;
                    rowCount[0] = rowCount[0] + data.size();
                    for (Object[] rowData : data) {
                        rows.add(DataConsumer.Row.create(rowNum++, rowData));
                        if (rows.size() != chunkSize) continue;
                        handler.addRows(this.getRequestContext(), (List<DataConsumer.Row>)rows);
                        rows = new ArrayList<DataConsumer.Row>(chunkSize);
                    }
                }
                if (hasNext) {
                    hasNext = remoteResultSet.next();
                }
            }
        }
        finally {
            if (!rows.isEmpty()) {
                handler.addRows(this.getRequestContext(), (List<DataConsumer.Row>)rows);
            }
            if (start < 0) {
                rowCount[0] = ((LastPageHandler)handler).getRowCount();
            }
            try {
                if (hasNext && rowCount[0] != 0) {
                    ++rowNum;
                }
            }
            finally {
                handler.afterLastRowAdded(this.getRequestContext(), rowNum);
            }
        }
    }

    @NotNull
    public static List<Object[]> getObjects(@NotNull ResultSet resultSet, @NotNull DatabaseDialect dialect, @NotNull Object requestor, int maxLobLength, int rowsToLoad) throws Exception {
        if (resultSet == null) {
            JdbcEngine.$$$reportNull$$$0(69);
        }
        if (dialect == null) {
            JdbcEngine.$$$reportNull$$$0(70);
        }
        if (requestor == null) {
            JdbcEngine.$$$reportNull$$$0(71);
        }
        List<Object[]> list = JdbcEngine.getObjects(resultSet, dialect, requestor, maxLobLength, rowsToLoad, false);
        if (list == null) {
            JdbcEngine.$$$reportNull$$$0(72);
        }
        return list;
    }

    @NotNull
    public static List<Object[]> getObjects(@NotNull ResultSet resultSet, @NotNull DatabaseDialect dialect, @NotNull Object requestor, int maxLobLength, int rowsToLoad, boolean raw) throws Exception {
        if (resultSet == null) {
            JdbcEngine.$$$reportNull$$$0(73);
        }
        if (dialect == null) {
            JdbcEngine.$$$reportNull$$$0(74);
        }
        if (requestor == null) {
            JdbcEngine.$$$reportNull$$$0(75);
        }
        RemoteResultSet remoteResultSet = (RemoteResultSet)RemoteUtil.castToRemoteNotNull((Object)resultSet, RemoteResultSet.class);
        Rdbms rdbms = DbImplUtil.getRdbms(dialect);
        RemoteResultSet.DataRetrievingOptions options = new RemoteResultSet.DataRetrievingOptions(rdbms, Calendar.getInstance(), rowsToLoad, maxLobLength, raw);
        List list = (List)RemoteUtil.handleRemoteResult((Object)remoteResultSet.getObjects(options), List.class, (Object)requestor);
        if (list == null) {
            JdbcEngine.$$$reportNull$$$0(76);
        }
        return list;
    }

    public static DataConsumer.Column[] getColumnDescriptors(@NotNull ResultSet resultSet, @NotNull DatabaseDialect dialect) throws SQLException {
        if (resultSet == null) {
            JdbcEngine.$$$reportNull$$$0(77);
        }
        if (dialect == null) {
            JdbcEngine.$$$reportNull$$$0(78);
        }
        ResultSetMetaData metaData = resultSet.getMetaData();
        int count2 = metaData.getColumnCount();
        DataConsumer.Column[] columnsDescr = new DataConsumer.Column[count2];
        int columnNum = 0;
        for (int i2 = 1; i2 <= count2; ++i2) {
            String name = null;
            try {
                name = metaData.getColumnLabel(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String typeName = null;
            try {
                typeName = metaData.getColumnTypeName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int type = 1111;
            try {
                type = metaData.getColumnType(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String clazz = null;
            try {
                clazz = metaData.getColumnClassName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String catalog = null;
            try {
                catalog = metaData.getCatalogName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String schema = null;
            try {
                schema = metaData.getSchemaName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String table = null;
            try {
                table = metaData.getTableName(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int precision = -1;
            try {
                precision = metaData.getPrecision(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int scale = -1;
            try {
                scale = metaData.getScale(i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            type = JdbcNativeUtil.fixJdbcType((Rdbms)DbImplUtil.getRdbms(dialect), (String)typeName, (String)clazz, (int)type);
            if (dialect.getFamilyId().isClickHouse()) {
                if (table != null) {
                    table = StringUtil.trimEnd((String)table, (char)';');
                }
            } else if (dialect.getFamilyId().isSqlite()) {
                catalog = "";
            } else if (dialect.getFamilyId().isDb2()) {
                schema = schema == null ? null : StringUtil.trimTrailing((String)schema);
            }
            columnsDescr[i2 - 1] = new DataConsumer.Column(columnNum++, name, type, typeName, clazz, precision, scale, catalog, schema, table);
        }
        return columnsDescr;
    }

    private void checkCanceled() {
        if (this.myState.get() == State.CANCELED) {
            throw new ProcessCanceledException();
        }
    }

    @Override
    protected void releaseConnection() {
        if (this.myConnection == null) {
            return;
        }
        boolean inTran = this.myTxMarker.getOwner() != null;
        try (GuardedRef<DatabaseConnection> connection = this.myConnection;){
            MyContext requestContext;
            this.myConnection = null;
            if (!connection.get().getAutoCommit()) {
                connection.get().rollback();
            }
            if ((requestContext = (MyContext)((Object)ObjectUtils.tryCast((Object)((Object)this.getRequestContextIfAny()), MyContext.class))) != null) {
                if (inTran && !this.isTransactionStarted()) {
                    this.getDataAuditor().txCompleted(requestContext, false);
                }
                this.getDataAuditor().print(requestContext, "Disconnected");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isTransactionStarted() {
        DataRequest.Context context = this.getRequestContextIfAny();
        return context instanceof MyContext && ((MyContext)context).startedTransaction;
    }

    @Override
    protected void onRequestStarted(@NotNull DataRequest.Context context) throws Exception {
        if (context == null) {
            JdbcEngine.$$$reportNull$$$0(79);
        }
        try {
            this.changeSearchPathIfNeeded(context, true);
        }
        finally {
            super.onRequestStarted(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onRequestFinished(@NotNull DataRequest.Context context) throws Exception {
        if (context == null) {
            JdbcEngine.$$$reportNull$$$0(80);
        }
        try {
            try {
                this.changeSearchPathIfNeeded(context, false);
            }
            finally {
                DatabaseConnection connection = this.getCurrentConnection();
                if (connection != null) {
                    this.storeTxIsolation(context, connection);
                }
            }
        }
        finally {
            super.onRequestFinished(context);
        }
    }

    private void changeSearchPathIfNeeded(@NotNull DataRequest.Context context, boolean requestStarted2) {
        SearchPath targetPath;
        if (context == null) {
            JdbcEngine.$$$reportNull$$$0(81);
        }
        DataRequest request = context.request;
        SearchPath requestPath = request.path;
        MyContext myContext = (MyContext)context;
        SearchPath persistentPath = myContext.startPath;
        SearchPath searchPath = targetPath = requestStarted2 ? request.path : myContext.startPath;
        if (requestPath == null || targetPath == null || Comparing.equal((Object)requestPath, (Object)persistentPath)) {
            return;
        }
        DatabaseConnection connection = this.getCurrentConnection();
        if (connection == null) {
            this.setSearchPath(targetPath);
            return;
        }
        if (requestStarted2 && !this.canSwitchSchemaForRequest(myContext, requestPath)) {
            JdbcEngine.reportError(context, "Can't execute request in context of: " + requestPath);
        }
        if (this.willReconnect(targetPath.getCurrent())) {
            this.releaseConnection();
            this.setSearchPath(targetPath);
            return;
        }
        this.performSchemaSwitch(connection, targetPath, false);
    }

    private boolean canSwitchSchemaForRequest(@NotNull MyContext context, @NotNull SearchPath path) {
        if (context == null) {
            JdbcEngine.$$$reportNull$$$0(82);
        }
        if (path == null) {
            JdbcEngine.$$$reportNull$$$0(83);
        }
        return !this.willReconnect(path.getCurrent()) || context.startedTransaction || this.myTxMarker.getOwner() == null;
    }

    private boolean willReconnect(@NotNull ObjectPath needed) {
        if (needed == null) {
            JdbcEngine.$$$reportNull$$$0(84);
        }
        ObjectPath current = this.getCurrentNamespace();
        DatabaseConnection connection = this.getCurrentConnection();
        return current == null ? JdbcUrlParserUtil.outOfBounds(connection == null ? this.myDataSource : connection.getConnectionPoint(), needed) : JdbcUrlParserUtil.outOfBounds(this.myDataSource, current, needed);
    }

    private void addStatement(@NotNull SmartStatementMark mark2) {
        if (mark2 == null) {
            JdbcEngine.$$$reportNull$$$0(85);
        }
        this.myCurrentStatements.add(mark2);
        this.myState.set(State.RUNNING);
    }

    private void removeStatement(@NotNull SmartStatementMark mark2) {
        if (mark2 == null) {
            JdbcEngine.$$$reportNull$$$0(86);
        }
        this.myCurrentStatements.remove(mark2);
        if (this.myCurrentStatements.isEmpty()) {
            this.myState.set(State.IDLE);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 49: 
            case 52: 
            case 55: 
            case 58: 
            case 62: 
            case 72: 
            case 76: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 49: 
            case 52: 
            case 55: 
            case 58: 
            case 62: 
            case 72: 
            case 76: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "department";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 49: 
            case 52: 
            case 55: 
            case 58: 
            case 62: 
            case 72: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/JdbcEngine";
                break;
            }
            case 10: 
            case 11: 
            case 26: 
            case 29: 
            case 30: 
            case 33: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 25: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 48: 
            case 89: 
            case 90: 
            case 93: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 19: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 22: 
            case 28: 
            case 32: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbConnection";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 34: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPath";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutation";
                break;
            }
            case 47: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 50: 
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 51: 
            case 54: 
            case 57: 
            case 70: 
            case 74: 
            case 78: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutations";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processName";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "familyId";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 68: 
            case 69: 
            case 73: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 71: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "needed";
                break;
            }
            case 85: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mark";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/JdbcEngine";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createAccessController";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDepartment";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequestContext";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuditService";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDataForDelete";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDataForUpdate";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDataForInsert";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptors";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnNamesForInsert";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholdersForInsert";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldParticipateInInsert";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "mergedQueryData";
                break;
            }
            case 72: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 49: 
            case 52: 
            case 55: 
            case 58: 
            case 62: 
            case 72: 
            case 76: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "requestSearchPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "requestSearchPathTransparent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitQuery";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitUpdate";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitInsert";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitDelete";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitSchemaSwitch";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createRequestContext";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getQueryType";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "prepareConnection";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setTxIsolation";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "storeTxIsolation";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "shouldChangeIsolation";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "performSchemaSwitch";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "buildDataForSelect";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getConditionRequestQuery";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "buildDataForDelete";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "buildDataForUpdate";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "buildDataForInsert";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptors";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "executeUpdateStatement";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createExecutor";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getColumnNamesForInsert";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholdersForInsert";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "shouldParticipateInInsert";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "mergedQueryData";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "appendErrorMessage";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isRedshiftDriverFailure";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "printResultSet";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getObjects";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getColumnDescriptors";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "onRequestStarted";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "onRequestFinished";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "changeSearchPathIfNeeded";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "canSwitchSchemaForRequest";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "willReconnect";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "addStatement";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "removeStatement";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "lambda$shouldParticipateInInsert$21";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "lambda$executeUpdateStatement$17";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildDataForUpdate$13";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildDataForDelete$11";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "lambda$performSchemaSwitch$10";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "lambda$visitSchemaSwitch$7";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "lambda$visitQuery$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 49: 
            case 52: 
            case 55: 
            case 58: 
            case 62: 
            case 72: 
            case 76: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StackTraceFreeException
    extends RuntimeException
    implements SuppressUserStackTrace {
        StackTraceFreeException(@NotNull String message) {
            if (message == null) {
                StackTraceFreeException.$$$reportNull$$$0(0);
            }
            super(message);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/console/JdbcEngine$StackTraceFreeException", "<init>"));
        }
    }

    private static enum State {
        IDLE,
        RUNNING,
        STREAMING,
        CANCELED;

    }

    public static class OffsetSavingBuilder
    extends DdlBuilder {
        private final TIntArrayList myOffsets;

        public OffsetSavingBuilder(@NotNull DdlBuilder builder) {
            if (builder == null) {
                OffsetSavingBuilder.$$$reportNull$$$0(0);
            }
            super(new StringBuilder(builder.getStatement()));
            this.myOffsets = new TIntArrayList();
            this.configureFrom(builder);
        }

        @Override
        @NotNull
        public DdlBuilder placeholder() {
            this.myOffsets.add(this.length());
            DdlBuilder ddlBuilder = super.placeholder();
            if (ddlBuilder == null) {
                OffsetSavingBuilder.$$$reportNull$$$0(1);
            }
            return ddlBuilder;
        }

        public int[] getOffsets() {
            return this.myOffsets.toNativeArray();
        }

        @Override
        @NotNull
        public DdlBuilder clear() {
            this.myOffsets.clear();
            DdlBuilder ddlBuilder = super.clear();
            if (ddlBuilder == null) {
                OffsetSavingBuilder.$$$reportNull$$$0(2);
            }
            return ddlBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcEngine$OffsetSavingBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcEngine$OffsetSavingBuilder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "placeholder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clear";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class EngineWarningException
    extends SQLException {
        private final String myLogMessage;

        EngineWarningException(@NotNull String message, @NotNull String logMessage) {
            if (message == null) {
                EngineWarningException.$$$reportNull$$$0(0);
            }
            if (logMessage == null) {
                EngineWarningException.$$$reportNull$$$0(1);
            }
            super(message);
            this.myLogMessage = logMessage;
            this.setStackTrace(new StackTraceElement[0]);
        }

        @NotNull
        public String getLogMessage() {
            String string = this.myLogMessage;
            if (string == null) {
                EngineWarningException.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logMessage";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcEngine$EngineWarningException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcEngine$EngineWarningException";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLogMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class QueryExecutionOperation
    implements AtomicOperation {
        private final Executor myHolder;
        private final DataRequest.Constraints myConstraints;
        private final DataRequest myRequest;
        private final boolean myFromConsole;
        private final boolean myRequestSearchPath;
        private boolean mySearchPathRequested;

        public QueryExecutionOperation(@NotNull Executor holder, DataRequest request) {
            if (JdbcEngine.this == null) {
                QueryExecutionOperation.$$$reportNull$$$0(0);
            }
            if (holder == null) {
                QueryExecutionOperation.$$$reportNull$$$0(1);
            }
            if (request == null) {
                QueryExecutionOperation.$$$reportNull$$$0(2);
            }
            this.myHolder = holder;
            this.myRequest = request;
            this.myConstraints = this.myRequest instanceof DataRequest.QueryRequest ? ((DataRequest.QueryRequest)this.myRequest).constraints : DataRequest.newConstraints();
            this.myFromConsole = request instanceof ConsoleDataRequest;
            this.myRequestSearchPath = this.myFromConsole && ((ConsoleDataRequest)request).isExecutionStopper();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean perform(@NotNull DatabaseConnection connection, boolean isAtomic) throws SQLException {
            if (connection == null) {
                QueryExecutionOperation.$$$reportNull$$$0(3);
            }
            boolean suppressReadOnly = JdbcEngine.this.myFamilyId == DatabaseFamilyId.MYSQL && connection.isReadOnly();
            try {
                if (suppressReadOnly) {
                    connection.setReadOnly(false);
                }
                boolean bl = this.execute(connection);
                return bl;
            }
            catch (EngineWarningException e) {
                JdbcEngine.this.getRequestContext().reportException(e, null);
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                boolean bl = false;
                return bl;
            }
            catch (Throwable e) {
                JdbcEngine.this.getRequestContext().reportException(e, null);
                boolean bl = false;
                return bl;
            }
            finally {
                if (suppressReadOnly) {
                    connection.setReadOnly(true);
                }
                if (!this.mySearchPathRequested && this.myFromConsole && this.myRequestSearchPath) {
                    JdbcEngine.this.requestSearchPath(connection);
                }
            }
        }

        private boolean execute(@NotNull DatabaseConnection connection) throws Exception {
            if (connection == null) {
                QueryExecutionOperation.$$$reportNull$$$0(4);
            }
            String statement = this.myHolder.getStatement();
            this.requestWriteAccess(statement);
            Integer maxRows = null;
            Object type = JdbcEngine.this.getQueryType(statement, this.myRequest);
            if (type instanceof SqlTableType) {
                if (this.myConstraints.offset >= 0 && !DbImplUtil.isPageSizeUnlimited(this.myConstraints.limit)) {
                    maxRows = this.myConstraints.offset + this.myConstraints.limit + 1;
                }
                JdbcEngine.this.requestSearchPath(connection);
                this.mySearchPathRequested = true;
            }
            int maxAllowedChunkSize = maxRows == null || maxRows < 0 ? Integer.MAX_VALUE : maxRows;
            int defaultPrefetchSize = DatabaseSettings.getSettings().getPrefetchSize();
            final int chunkSize = Math.min(maxAllowedChunkSize, Math.max(this.myConstraints.limit / 10, defaultPrefetchSize <= 0 ? 100 : defaultPrefetchSize));
            Configuration configuration = new Configuration(false, JdbcEngine.this.myFamilyId.isClickHouse() ? null : maxRows, this.myConstraints.resultSetNumber, JdbcEngine.this.myFamilyId.isMysql() ? Integer.MIN_VALUE : chunkSize);
            final Ref lastResultsIndex = Ref.create((Object)-1);
            final int[] rowCount = new int[]{0};
            this.myHolder.execute(connection, configuration, (Consumer<ResultsProducer>)((Consumer)producer -> {
                JdbcEngine.this.myState.compareAndSet(State.RUNNING, State.STREAMING);
                producer.processRemaining(new ResultsProducer.Processor<Unit>(){

                    @Override
                    @NotNull
                    public Unit results(@NotNull ResultSet resultSet, int index2) throws Exception {
                        if (resultSet == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        lastResultsIndex.set((Object)index2);
                        try {
                            JdbcEngine.this.checkCanceled();
                            JdbcEngine.this.getDataAuditor().fetchStarted(JdbcEngine.this.getRequestContext(), index2);
                            JdbcEngine.this.printResultSet(resultSet, index2, ((QueryExecutionOperation)QueryExecutionOperation.this).myConstraints.offset, ((QueryExecutionOperation)QueryExecutionOperation.this).myConstraints.limit, chunkSize, rowCount);
                        }
                        finally {
                            JdbcEngine.this.getDataAuditor().fetchFinished(JdbcEngine.this.getRequestContext(), index2, rowCount[0]);
                        }
                        Unit unit = Unit.INSTANCE;
                        if (unit == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return unit;
                    }

                    @Override
                    @NotNull
                    public Unit updateCount(int count2, int index2) {
                        Unit unit = Unit.INSTANCE;
                        if (unit == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return unit;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 1: 
                            case 2: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 1: 
                            case 2: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "resultSet";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/database/console/JdbcEngine$QueryExecutionOperation$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/database/console/JdbcEngine$QueryExecutionOperation$1";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "results";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "updateCount";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "results";
                                break;
                            }
                            case 1: 
                            case 2: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 1: 
                            case 2: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                });
            }));
            Integer resultSetIndex = (Integer)lastResultsIndex.get();
            int maxResultSetIndex = SmartStatements.Companion.getMaxResults();
            if (resultSetIndex > maxResultSetIndex) {
                JdbcEngine.this.getDataAuditor().warn(JdbcEngine.this.getRequestContext(), "The query yielded " + resultSetIndex + " result sets, only " + maxResultSetIndex + " were retrieved.");
            }
            return true;
        }

        private void requestWriteAccess(@NotNull String sql) throws EngineWarningException {
            if (sql == null) {
                QueryExecutionOperation.$$$reportNull$$$0(5);
            }
            if (this.myRequest instanceof ConsoleDataRequest && ((ConsoleDataRequest)this.myRequest).force) {
                return;
            }
            DatabaseAccessController.Token token = JdbcEngine.this.myDatabaseAccessController.requestAccess(sql);
            if (!token.success) {
                throw new EngineWarningException(token.message, token.logMessage);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            String string;
            switch (n) {
                default: {
                    string = "Argument %s for @NotNull parameter of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "0";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sql";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcEngine$QueryExecutionOperation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestWriteAccess";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
    }

    private class CallOperation
    implements AtomicOperation {
        private final DataRequest.CallRequest myRequest;

        CallOperation(DataRequest.CallRequest request) {
            if (JdbcEngine.this == null) {
                CallOperation.$$$reportNull$$$0(0);
            }
            if (request == null) {
                CallOperation.$$$reportNull$$$0(1);
            }
            this.myRequest = request;
        }

        @Override
        public boolean perform(@NotNull DatabaseConnection connection, boolean isAtomic) throws SQLException {
            if (connection == null) {
                CallOperation.$$$reportNull$$$0(2);
            }
            for (DataRequest.CallRequest.Statement statement : this.myRequest.queries) {
                Executor executor = this.createExecutor(statement);
                if (new QueryExecutionOperation(executor, this.myRequest).perform(connection, isAtomic)) continue;
                return false;
            }
            return true;
        }

        @NotNull
        private Executor createExecutor(@NotNull DataRequest.CallRequest.Statement statement) {
            if (statement == null) {
                CallOperation.$$$reportNull$$$0(3);
            }
            SimpleExecutor simpleExecutor = statement.parameterTypes.isEmpty() ? new SimpleExecutor(statement.statement) : new CallExecutor(statement.statement, statement.parameterTypes);
            if (simpleExecutor == null) {
                CallOperation.$$$reportNull$$$0(4);
            }
            return simpleExecutor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument %s for @NotNull parameter of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "0";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcEngine$CallOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcEngine$CallOperation";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createExecutor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createExecutor";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class UpdateOperation
    implements AtomicOperation {
        private final List<QueryData> myQueryData;
        private final UnexpectedUpdatesGuard myGuard;

        UpdateOperation(List<QueryData> queryData) {
            if (queryData == null) {
                UpdateOperation.$$$reportNull$$$0(0);
            }
            this.myQueryData = queryData;
            this.myGuard = new UnexpectedUpdatesGuard();
        }

        @Override
        public boolean perform(@NotNull DatabaseConnection connection, boolean isAtomic) {
            if (connection == null) {
                UpdateOperation.$$$reportNull$$$0(1);
            }
            for (QueryData data : this.myQueryData) {
                if (this.executeUpdateStatementAndGetUpdateCounts(connection, data, isAtomic)) continue;
                return false;
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean executeUpdateStatementAndGetUpdateCounts(@NotNull DatabaseConnection connection, @NotNull QueryData data, boolean isAtomic) {
            if (connection == null) {
                UpdateOperation.$$$reportNull$$$0(2);
            }
            if (data == null) {
                UpdateOperation.$$$reportNull$$$0(3);
            }
            try {
                Iterator<RowUpdateData> iterator2 = data.iterator();
                while (iterator2.hasNext()) {
                    RowUpdateData rowInfo = iterator2.next();
                    RowQueryData qData = rowInfo.getQueryData();
                    ClosableResultsProducer producer = SmartStatements.poweredBy(connection).parameterized().noisy().execute(qData.asParameterizedStatementData(), StandardExecutionMode.UPDATE);
                    Throwable throwable = null;
                    try {
                        int updateCount2 = producer.advanceSafe() ? producer.processCurrent(StandardResultsProcessors.updateCount(-1)) : -1;
                        if (this.myGuard.updateSuccessful(updateCount2, rowInfo.getUpdateCount(), isAtomic)) continue;
                        boolean bl = false;
                        return bl;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (producer == null) continue;
                        if (throwable != null) {
                            try {
                                producer.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        producer.close();
                    }
                }
                return true;
            }
            catch (SQLException e) {
                return false;
            }
            catch (Exception e) {
                JdbcEngine.this.getRequestContext().reportException(e, null);
                return false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "queryData";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcEngine$UpdateOperation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executeUpdateStatementAndGetUpdateCounts";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class UnexpectedUpdatesGuard {
            private UnexpectedUpdatesGuard() {
            }

            public boolean updateSuccessful(int actual, int expected, boolean atomic) {
                boolean unexpectedUpdateCount;
                boolean bl = unexpectedUpdateCount = expected != actual;
                if (unexpectedUpdateCount) {
                    if (atomic) {
                        this.reportChangesWillBeRolledBack(actual, expected);
                    } else {
                        this.reportUnexpectedUpdateCount(actual, expected);
                    }
                }
                return !unexpectedUpdateCount;
            }

            private void reportUnexpectedUpdateCount(int actual, int expected) {
                String message = DatabaseMessages.message((String)"message.text.error.unexpected.update.count", (Object[])new Object[0]) + this.getDiffString(actual, expected) + "Rollback the current transaction to undo changes.";
                JdbcEngine.this.getDataAuditor().print(JdbcEngine.this.getRequestContext(), message);
            }

            protected final void reportChangesWillBeRolledBack(int actual, int expected) {
                String message = DatabaseMessages.message((String)"message.text.error.unexpected.update.count", (Object[])new Object[0]) + this.getDiffString(actual, expected) + "All changes will be rolled back.";
                JdbcEngine.this.getRequestContext().reportException(new UnsafeUpdateRolledBackException(message), null);
            }

            @NotNull
            protected final String getDiffString(int actual, int expected) {
                String diffString = " (Actual: %s, Expected: %s). ";
                String string = String.format(diffString, actual, expected);
                if (string == null) {
                    UnexpectedUpdatesGuard.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcEngine$UpdateOperation$UnexpectedUpdatesGuard", "getDiffString"));
            }
        }
    }

    private static abstract class PotentiallyTransparentOperation
    implements AtomicOperation {
        private PotentiallyTransparentOperation() {
        }

        @Override
        public boolean perform(@NotNull DatabaseConnection connection, boolean isAtomic) throws Exception {
            if (connection == null) {
                PotentiallyTransparentOperation.$$$reportNull$$$0(0);
            }
            return this.transparent(connection) && !isAtomic;
        }

        abstract boolean transparent(@NotNull DatabaseConnection var1) throws Exception;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine$PotentiallyTransparentOperation", "perform"));
        }
    }

    private static class TransactionOperation
    extends PotentiallyAtomicOperation {
        private boolean myAuto;

        TransactionOperation(@NotNull AtomicOperation operation2, boolean transactionStarted) {
            if (operation2 == null) {
                TransactionOperation.$$$reportNull$$$0(0);
            }
            super(operation2, transactionStarted);
        }

        @Override
        public boolean perform(@NotNull DatabaseConnection connection) throws Exception {
            if (connection == null) {
                TransactionOperation.$$$reportNull$$$0(1);
            }
            this.myAuto = connection.getAutoCommit();
            if (this.myAuto) {
                connection.setAutoCommit(false);
            }
            try {
                boolean bl = super.perform(connection);
                return bl;
            }
            finally {
                if (this.myAuto) {
                    connection.setAutoCommit(true);
                }
            }
        }

        @Override
        @NotNull
        protected PotentiallyAtomicOperation.AtomicHelper createHelper(@NotNull DatabaseConnection connection) {
            if (connection == null) {
                TransactionOperation.$$$reportNull$$$0(2);
            }
            PotentiallyAtomicOperation.AtomicHelper atomicHelper = this.myAuto ? new PotentiallyAtomicOperation.CommitOrRollback(connection) : new PotentiallyAtomicOperation.RollbackToSavepoint(connection);
            if (atomicHelper == null) {
                TransactionOperation.$$$reportNull$$$0(3);
            }
            return atomicHelper;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operation";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcEngine$TransactionOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcEngine$TransactionOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createHelper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createHelper";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SilentOperation
    extends PotentiallyAtomicOperation {
        SilentOperation(@NotNull AtomicOperation delegate, boolean transactionStarted) {
            if (delegate == null) {
                SilentOperation.$$$reportNull$$$0(0);
            }
            super(delegate, transactionStarted);
        }

        @Override
        @NotNull
        protected PotentiallyAtomicOperation.AtomicHelper createHelper(@NotNull DatabaseConnection connection) throws SQLException {
            if (connection == null) {
                SilentOperation.$$$reportNull$$$0(1);
            }
            SilentHelper silentHelper = new SilentHelper(super.createHelper(connection));
            if (silentHelper == null) {
                SilentOperation.$$$reportNull$$$0(2);
            }
            return silentHelper;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcEngine$SilentOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcEngine$SilentOperation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createHelper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createHelper";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class SilentHelper
        implements PotentiallyAtomicOperation.AtomicHelper {
            private final PotentiallyAtomicOperation.AtomicHelper myDelegate;

            SilentHelper(@NotNull PotentiallyAtomicOperation.AtomicHelper delegate) {
                if (delegate == null) {
                    SilentHelper.$$$reportNull$$$0(0);
                }
                this.myDelegate = delegate;
            }

            @Override
            public void free(boolean success) {
                JdbcNativeUtil.performSafe(() -> this.myDelegate.free(success));
            }

            @Override
            public boolean isAvailable() {
                return this.myDelegate.isAvailable();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/console/JdbcEngine$SilentOperation$SilentHelper", "<init>"));
            }
        }
    }

    private static class PotentiallyAtomicOperation
    implements Operation {
        private final AtomicOperation myDelegate;
        private final boolean myTransactionStarted;

        PotentiallyAtomicOperation(@NotNull AtomicOperation delegate, boolean transactionStarted) {
            if (delegate == null) {
                PotentiallyAtomicOperation.$$$reportNull$$$0(0);
            }
            this.myDelegate = delegate;
            this.myTransactionStarted = transactionStarted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean perform(@NotNull DatabaseConnection connection) throws Exception {
            if (connection == null) {
                PotentiallyAtomicOperation.$$$reportNull$$$0(1);
            }
            AtomicHelper helper = this.createHelper(connection);
            boolean result2 = false;
            try {
                result2 = this.myDelegate.perform(connection, helper.isAvailable());
            }
            finally {
                helper.free(result2);
            }
            return result2;
        }

        @NotNull
        protected AtomicHelper createHelper(@NotNull DatabaseConnection connection) throws SQLException {
            if (connection == null) {
                PotentiallyAtomicOperation.$$$reportNull$$$0(2);
            }
            AtomicHelper atomicHelper = connection.getAutoCommit() ? new Inactive() : (this.myTransactionStarted ? new Rollback(connection) : new RollbackToSavepoint(connection));
            if (atomicHelper == null) {
                PotentiallyAtomicOperation.$$$reportNull$$$0(3);
            }
            return atomicHelper;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcEngine$PotentiallyAtomicOperation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcEngine$PotentiallyAtomicOperation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createHelper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createHelper";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        static class RollbackToSavepoint
        implements AtomicHelper {
            private final Savepoint mySavepoint;
            private final DatabaseConnection myGuardedConnection;

            RollbackToSavepoint(@NotNull DatabaseConnection connection) {
                if (connection == null) {
                    RollbackToSavepoint.$$$reportNull$$$0(0);
                }
                this.myGuardedConnection = connection;
                this.mySavepoint = this.createSavepoint();
            }

            @Override
            public boolean isAvailable() {
                return this.mySavepoint != null;
            }

            @Override
            public void free(boolean success) throws SQLException {
                if (this.mySavepoint == null) {
                    return;
                }
                try {
                    if (!success) {
                        this.myGuardedConnection.rollback(this.mySavepoint);
                    }
                }
                catch (SQLException e) {
                    throw new SQLException(DatabaseMessages.message((String)"message.text.error.failed.to.rollback.to.a.savepoint", (Object[])new Object[0]), e);
                }
                finally {
                    JdbcNativeUtil.performSafe(() -> this.myGuardedConnection.releaseSavepoint(this.mySavepoint));
                }
            }

            @Nullable
            private Savepoint createSavepoint() {
                try {
                    DatabaseMetaData metaData = this.myGuardedConnection.getMetaData();
                    return metaData != null && metaData.supportsSavepoints() ? this.myGuardedConnection.setSavepoint() : null;
                }
                catch (Exception e) {
                    LOG.info("Exception while setting an unnamed savepoint", (Throwable)e);
                    return null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine$PotentiallyAtomicOperation$RollbackToSavepoint", "<init>"));
            }
        }

        static class CommitOrRollback
        implements AtomicHelper {
            private final DatabaseConnection myConnection;

            CommitOrRollback(@NotNull DatabaseConnection connection) {
                if (connection == null) {
                    CommitOrRollback.$$$reportNull$$$0(0);
                }
                this.myConnection = connection;
            }

            @Override
            public void free(boolean success) throws SQLException {
                if (success) {
                    this.myConnection.commit();
                } else {
                    this.myConnection.rollback();
                }
            }

            @Override
            public boolean isAvailable() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine$PotentiallyAtomicOperation$CommitOrRollback", "<init>"));
            }
        }

        static class Rollback
        implements AtomicHelper {
            private final DatabaseConnection myConnection;

            Rollback(@NotNull DatabaseConnection connection) {
                if (connection == null) {
                    Rollback.$$$reportNull$$$0(0);
                }
                this.myConnection = connection;
            }

            @Override
            public void free(boolean success) throws SQLException {
                if (!success) {
                    this.myConnection.rollback();
                }
            }

            @Override
            public boolean isAvailable() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/console/JdbcEngine$PotentiallyAtomicOperation$Rollback", "<init>"));
            }
        }

        static class Inactive
        implements AtomicHelper {
            Inactive() {
            }

            @Override
            public void free(boolean success) {
            }

            @Override
            public boolean isAvailable() {
                return true;
            }
        }

        static interface AtomicHelper {
            public void free(boolean var1) throws SQLException;

            public boolean isAvailable();
        }
    }

    private class EngineAuditService
    implements AuditService {
        private EngineAuditService() {
        }

        @Override
        public void error(@NotNull String message) {
            DataRequest.Context context;
            if (message == null) {
                EngineAuditService.$$$reportNull$$$0(0);
            }
            if ((context = JdbcEngine.this.getRequestContextIfAny()) != null) {
                JdbcEngine.this.getDataAuditor().error(context, message, null);
            }
        }

        @Override
        public void warning(@NotNull String message) {
            DataRequest.Context context;
            if (message == null) {
                EngineAuditService.$$$reportNull$$$0(1);
            }
            if ((context = JdbcEngine.this.getRequestContextIfAny()) != null) {
                JdbcEngine.this.getDataAuditor().warn(context, message);
            }
        }

        @Override
        public void afterStatement(@NotNull SmartStatementMark mark2) {
            if (mark2 == null) {
                EngineAuditService.$$$reportNull$$$0(2);
            }
        }

        @Override
        public void beforeCallableStatement(@NotNull CallableStatementData data, @NotNull SmartStatementMark mark2) {
            if (data == null) {
                EngineAuditService.$$$reportNull$$$0(3);
            }
            if (mark2 == null) {
                EngineAuditService.$$$reportNull$$$0(4);
            }
            this.beforeParameterizedStatement(data, mark2);
        }

        @Override
        public void beforeParameterizedStatement(@NotNull ParameterizedStatementData data, @NotNull SmartStatementMark mark2) {
            if (data == null) {
                EngineAuditService.$$$reportNull$$$0(5);
            }
            if (mark2 == null) {
                EngineAuditService.$$$reportNull$$$0(6);
            }
            JdbcEngine.this.addStatement(mark2);
            if (data.getBasis().getOffsets() != null) {
                this.parameterizedAudit(data);
                return;
            }
            this.plainAudit(data.getBasis().getSql());
        }

        @Override
        public void beforeSimpleStatement(@NotNull String sql, @NotNull SmartStatementMark mark2) {
            if (sql == null) {
                EngineAuditService.$$$reportNull$$$0(7);
            }
            if (mark2 == null) {
                EngineAuditService.$$$reportNull$$$0(8);
            }
            JdbcEngine.this.addStatement(mark2);
            this.plainAudit(sql);
        }

        private void plainAudit(@NotNull String sql) {
            if (sql == null) {
                EngineAuditService.$$$reportNull$$$0(9);
            }
            DataRequest.Context context = JdbcEngine.this.getRequestContext();
            context.statementContext.push(new RawStatementContext(sql));
            JdbcEngine.this.getDataAuditor().beforeStatement(context);
        }

        private void parameterizedAudit(@NotNull ParameterizedStatementData data) {
            if (data == null) {
                EngineAuditService.$$$reportNull$$$0(10);
            }
            DataRequest.Context context = JdbcEngine.this.getRequestContext();
            int[] offsets = (int[])ObjectUtils.notNull((Object)data.getBasis().getOffsets());
            List<ColumnQueryData> infos = data.getDecoration().getInfos();
            String sql = data.getBasis().getSql();
            context.statementContext.push(new PreparedStatementContext(new RowQueryData(infos, offsets, sql), JdbcEngine.this.myDialect));
            JdbcEngine.this.getDataAuditor().beforeStatement(context);
        }

        @Override
        public void message(@NotNull String message) {
            DataRequest.Context context;
            if (message == null) {
                EngineAuditService.$$$reportNull$$$0(11);
            }
            if ((context = JdbcEngine.this.getRequestContextIfAny()) != null) {
                JdbcEngine.this.getDataAuditor().print(context, message);
            }
        }

        @Override
        public void updateCount(int count2, @NotNull SmartStatementMark mark2) {
            if (mark2 == null) {
                EngineAuditService.$$$reportNull$$$0(12);
            }
            JdbcEngine.this.getDataAuditor().updateCountReceived(JdbcEngine.this.getRequestContext(), count2);
        }

        @Override
        public void error(@NotNull String message, @NotNull SmartStatementMark mark2) {
            if (message == null) {
                EngineAuditService.$$$reportNull$$$0(13);
            }
            if (mark2 == null) {
                EngineAuditService.$$$reportNull$$$0(14);
            }
            JdbcEngine.this.getDataAuditor().error(JdbcEngine.this.getRequestContext(), message, null);
        }

        @Override
        public void warning(@NotNull String message, @NotNull SmartStatementMark mark2) {
            if (message == null) {
                EngineAuditService.$$$reportNull$$$0(15);
            }
            if (mark2 == null) {
                EngineAuditService.$$$reportNull$$$0(16);
            }
            JdbcEngine.this.getDataAuditor().warn(JdbcEngine.this.getRequestContext(), message);
        }

        @Override
        public void message(@NotNull String message, @NotNull SmartStatementMark mark2) {
            if (message == null) {
                EngineAuditService.$$$reportNull$$$0(17);
            }
            if (mark2 == null) {
                EngineAuditService.$$$reportNull$$$0(18);
            }
            JdbcEngine.this.getDataAuditor().print(JdbcEngine.this.getRequestContext(), message);
        }

        @Override
        public void resultsProcessed(@NotNull SmartStatementMark mark2) {
            if (mark2 == null) {
                EngineAuditService.$$$reportNull$$$0(19);
            }
            DataRequest.Context context = JdbcEngine.this.getRequestContext();
            try {
                JdbcEngine.this.getDataAuditor().afterStatement(context);
            }
            finally {
                context.statementContext.pollFirst();
                JdbcEngine.this.removeStatement(mark2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 12: 
                case 14: 
                case 16: 
                case 18: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mark";
                    break;
                }
                case 3: 
                case 5: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sql";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcEngine$EngineAuditService";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 1: 
                case 15: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "warning";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterStatement";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeCallableStatement";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeParameterizedStatement";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeSimpleStatement";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "plainAudit";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parameterizedAudit";
                    break;
                }
                case 11: 
                case 17: 
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[2] = "message";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateCount";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resultsProcessed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface AtomicOperation {
        public boolean perform(@NotNull DatabaseConnection var1, boolean var2) throws Exception;
    }

    private static interface Operation {
        public boolean perform(@NotNull DatabaseConnection var1) throws Exception;
    }

    private static class ParameterizedExecutor
    implements Executor {
        private final RowQueryData myData;

        ParameterizedExecutor(@NotNull RowQueryData data) {
            if (data == null) {
                ParameterizedExecutor.$$$reportNull$$$0(0);
            }
            this.myData = data;
        }

        @Override
        public void execute(@NotNull DatabaseConnection connection, @NotNull Configuration configuration, @NotNull Consumer<ResultsProducer> consumer2) throws Exception {
            if (connection == null) {
                ParameterizedExecutor.$$$reportNull$$$0(1);
            }
            if (configuration == null) {
                ParameterizedExecutor.$$$reportNull$$$0(2);
            }
            if (consumer2 == null) {
                ParameterizedExecutor.$$$reportNull$$$0(3);
            }
            SmartStatements.poweredBy(connection).parameterized(configuration).noisy().execute(this.myData.asParameterizedStatementData(), (ExecutionMode)StandardExecutionMode.QUERY, SmartStatementsUtil.consumer(consumer2));
        }

        @Override
        @NotNull
        public String getStatement() {
            String string = this.myData.getSql();
            if (string == null) {
                ParameterizedExecutor.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcEngine$ParameterizedExecutor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcEngine$ParameterizedExecutor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RegularExecutor
    implements Executor {
        private final DataRequest.QueryRequest myRequest;

        RegularExecutor(@NotNull DataRequest.QueryRequest request) {
            if (request == null) {
                RegularExecutor.$$$reportNull$$$0(0);
            }
            this.myRequest = request;
        }

        @Override
        public void execute(@NotNull DatabaseConnection connection, @NotNull Configuration configuration, @NotNull Consumer<ResultsProducer> consumer2) throws SQLException {
            if (connection == null) {
                RegularExecutor.$$$reportNull$$$0(1);
            }
            if (configuration == null) {
                RegularExecutor.$$$reportNull$$$0(2);
            }
            if (consumer2 == null) {
                RegularExecutor.$$$reportNull$$$0(3);
            }
            boolean asQuery = this.myRequest instanceof ConsoleDataRequest && ((ConsoleDataRequest)this.myRequest).resultType instanceof SqlTableType;
            SmartStatements.poweredBy(connection).simple(configuration.scrollable(RegularExecutor.isScrollable(this.myRequest.constraints))).noisy().execute(this.myRequest.query, (ExecutionMode)(asQuery ? StandardExecutionMode.QUERY : StandardExecutionMode.GENERIC), SmartStatementsUtil.consumer(consumer2));
        }

        @Override
        @NotNull
        public String getStatement() {
            String string = this.myRequest.query;
            if (string == null) {
                RegularExecutor.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static boolean isScrollable(@NotNull DataRequest.Constraints constraints) {
            if (constraints == null) {
                RegularExecutor.$$$reportNull$$$0(5);
            }
            return constraints.offset != 0 && constraints.offset != 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcEngine$RegularExecutor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constraints";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcEngine$RegularExecutor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isScrollable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CallExecutor
    extends SimpleExecutor {
        private final TIntArrayList myParameterTypes;

        CallExecutor(@NotNull String statement, @NotNull TIntArrayList parameterTypes) {
            if (statement == null) {
                CallExecutor.$$$reportNull$$$0(0);
            }
            if (parameterTypes == null) {
                CallExecutor.$$$reportNull$$$0(1);
            }
            super(statement);
            this.myParameterTypes = parameterTypes;
        }

        @Override
        public void execute(@NotNull DatabaseConnection connection, @NotNull Configuration configuration, @NotNull Consumer<ResultsProducer> consumer2) throws Exception {
            if (connection == null) {
                CallExecutor.$$$reportNull$$$0(2);
            }
            if (configuration == null) {
                CallExecutor.$$$reportNull$$$0(3);
            }
            if (consumer2 == null) {
                CallExecutor.$$$reportNull$$$0(4);
            }
            StatementParameters parameters = new StatementParameters();
            int[] array = this.myParameterTypes.toNativeArray();
            for (int i2 = 0; i2 < array.length; ++i2) {
                int type = array[i2];
                parameters = parameters.parameter(i2 + 1, type);
            }
            SmartStatements.poweredBy(connection).call(configuration).noisy().execute(parameters.asCallData(this.myStatement), SmartStatementsUtil.consumer(consumer2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterTypes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcEngine$CallExecutor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SimpleExecutor
    implements Executor {
        protected final String myStatement;

        SimpleExecutor(@NotNull String statement) {
            if (statement == null) {
                SimpleExecutor.$$$reportNull$$$0(0);
            }
            this.myStatement = statement;
        }

        @Override
        public void execute(@NotNull DatabaseConnection connection, @NotNull Configuration configuration, @NotNull Consumer<ResultsProducer> consumer2) throws Exception {
            if (connection == null) {
                SimpleExecutor.$$$reportNull$$$0(1);
            }
            if (configuration == null) {
                SimpleExecutor.$$$reportNull$$$0(2);
            }
            if (consumer2 == null) {
                SimpleExecutor.$$$reportNull$$$0(3);
            }
            SmartStatements.poweredBy(connection).simple(configuration).noisy().execute(this.myStatement, SmartStatementsUtil.consumer(consumer2));
        }

        @Override
        @NotNull
        public String getStatement() {
            String string = this.myStatement;
            if (string == null) {
                SimpleExecutor.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcEngine$SimpleExecutor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcEngine$SimpleExecutor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface Executor {
        public void execute(@NotNull DatabaseConnection var1, @NotNull Configuration var2, @NotNull Consumer<ResultsProducer> var3) throws Exception;

        @NotNull
        public String getStatement();
    }

    private static class MyContext
    extends DataRequest.TxContext {
        private final JdbcEngine myEngine;
        final SearchPath startPath;
        final boolean startedTransaction;

        MyContext(@NotNull JdbcEngine engine, @NotNull DataRequest request, SearchPath startPath, boolean startedTransaction) {
            if (engine == null) {
                MyContext.$$$reportNull$$$0(0);
            }
            if (request == null) {
                MyContext.$$$reportNull$$$0(1);
            }
            super(engine, request, engine.myTxMarker);
            this.myEngine = engine;
            this.startPath = startPath;
            this.startedTransaction = startedTransaction;
        }

        @Override
        public void reportException(@NotNull Throwable th, Object parameter) {
            if (th == null) {
                MyContext.$$$reportNull$$$0(2);
            }
            LocalDataSource dataSource = this.myEngine.getDataSource();
            if (th instanceof ProcessCanceledException) {
                return;
            }
            String message = JdbcEngine.getErrorMessage(th, dataSource.getName(), dataSource.getFamilyId());
            this.myEngine.getDataAuditor().error(this, message, th instanceof EngineWarningException ? th : null);
        }

        @Override
        @Nullable
        public SearchPath getSearchPath() {
            return this.myEngine.getSearchPath();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "engine";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "th";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcEngine$MyContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reportException";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class UnsafeUpdateRolledBackException
    extends Exception {
        public UnsafeUpdateRolledBackException(String message) {
            super(message);
        }
    }

    private static class LastPageHandler
    implements DataConsumer {
        private final DataConsumer delegate;
        private int resultSetIndex;
        private DataConsumer.Column[] columnInfos;
        private final RowsCyclicBuffer myBuffer;

        public LastPageHandler(DataConsumer handler, int start, int size) {
            this.delegate = handler;
            this.myBuffer = new RowsCyclicBuffer(Math.max(size, -start));
        }

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column[] infos, int firstRowNum) {
            if (context == null) {
                LastPageHandler.$$$reportNull$$$0(0);
            }
            this.resultSetIndex = resultSetIndex;
            this.columnInfos = infos;
        }

        @Override
        public void addRows(@NotNull DataRequest.Context context, List<DataConsumer.Row> rows) {
            if (context == null) {
                LastPageHandler.$$$reportNull$$$0(1);
            }
            this.myBuffer.addRows(rows);
        }

        @Override
        public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
            List<DataConsumer.Row> rows;
            if (context == null) {
                LastPageHandler.$$$reportNull$$$0(2);
            }
            if ((rows = this.myBuffer.getRows()).isEmpty()) {
                this.delegate.setColumns(context, this.resultSetIndex, this.columnInfos, 0);
                this.delegate.afterLastRowAdded(context, 0);
                return;
            }
            this.delegate.setColumns(context, this.resultSetIndex, this.columnInfos, rows.get((int)0).rowNum);
            this.delegate.addRows(context, rows);
            this.delegate.afterLastRowAdded(context, total);
        }

        public int getRowCount() {
            return this.myBuffer.getRows().size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "context";
            objectArray2[1] = "com/intellij/database/console/JdbcEngine$LastPageHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setColumns";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRows";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLastRowAdded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class RowsCyclicBuffer {
            private final DataConsumer.Row[] myBuffer;
            private int myFirstIdx = 0;
            private int myLastIdx = -1;

            public RowsCyclicBuffer(int bufferSize) {
                this.myBuffer = new DataConsumer.Row[bufferSize];
            }

            public void addRows(@NotNull Iterable<DataConsumer.Row> rows) {
                if (rows == null) {
                    RowsCyclicBuffer.$$$reportNull$$$0(0);
                }
                for (DataConsumer.Row row : rows) {
                    if (this.myLastIdx != -1 && this.nextIdx(this.myLastIdx) == this.myFirstIdx) {
                        this.myFirstIdx = this.nextIdx(this.myFirstIdx);
                    }
                    this.myLastIdx = this.nextIdx(this.myLastIdx);
                    this.myBuffer[this.myLastIdx] = row;
                }
            }

            @NotNull
            public List<DataConsumer.Row> getRows() {
                if (this.myLastIdx == -1) {
                    List list = ContainerUtil.emptyList();
                    if (list == null) {
                        RowsCyclicBuffer.$$$reportNull$$$0(1);
                    }
                    return list;
                }
                if (this.myFirstIdx == 0) {
                    List list = ContainerUtil.newArrayList((Object[])this.myBuffer, (int)0, (int)(this.myLastIdx + 1));
                    if (list == null) {
                        RowsCyclicBuffer.$$$reportNull$$$0(2);
                    }
                    return list;
                }
                ArrayList rows = ContainerUtil.newArrayListWithCapacity((int)this.myBuffer.length);
                ImmutableList bufferAsList = ContainerUtil.immutableList((Object[])this.myBuffer);
                rows.addAll(bufferAsList.subList(this.myFirstIdx, this.myBuffer.length));
                rows.addAll(bufferAsList.subList(0, this.myLastIdx + 1));
                ArrayList arrayList = rows;
                if (arrayList == null) {
                    RowsCyclicBuffer.$$$reportNull$$$0(3);
                }
                return arrayList;
            }

            private int nextIdx(int idx) {
                return (idx + 1) % this.myBuffer.length;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rows";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/console/JdbcEngine$LastPageHandler$RowsCyclicBuffer";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/console/JdbcEngine$LastPageHandler$RowsCyclicBuffer";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRows";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "addRows";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

