/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DataBus;
import com.intellij.database.console.BaseJdbcSessionView;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.ParametersHolder;
import com.intellij.database.run.ScriptingSessionDataConsumer;
import com.intellij.database.run.audit.JdbcScriptingSessionLogger;
import com.intellij.database.run.audit.SessionLogger;
import com.intellij.database.run.session.ScriptingSessionView;
import com.intellij.database.script.ScriptModel;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class JdbcScriptingSessionView
extends BaseJdbcSessionView<JdbcConsole>
implements ScriptingSessionView<JdbcConsole> {
    private final ScriptingSessionDataConsumer myDataConsumer;
    private final ParametersHolder myParametersHolder;

    public JdbcScriptingSessionView(@NotNull JdbcConsole session, @NotNull DataBus.Consuming messageBus, @NotNull LanguageConsoleView consoleView, @NotNull ScriptModel<?> scriptModel) {
        if (session == null) {
            JdbcScriptingSessionView.$$$reportNull$$$0(0);
        }
        if (messageBus == null) {
            JdbcScriptingSessionView.$$$reportNull$$$0(1);
        }
        if (consoleView == null) {
            JdbcScriptingSessionView.$$$reportNull$$$0(2);
        }
        if (scriptModel == null) {
            JdbcScriptingSessionView.$$$reportNull$$$0(3);
        }
        super(consoleView, session, messageBus);
        this.myDataConsumer = ScriptingSessionDataConsumer.install(this.getProject(), this);
        this.myParametersHolder = new ParametersHolder(this.getProject(), this, scriptModel);
        this.myParametersHolder.initParameterView();
    }

    @Override
    @NotNull
    public Promise<Void> show(boolean activate, boolean requestFocus) {
        if (!activate) {
            this.ensureContentInitialized(false);
            Promise promise = Promises.resolvedPromise();
            if (promise == null) {
                JdbcScriptingSessionView.$$$reportNull$$$0(4);
            }
            return promise;
        }
        Promise<Void> promise = super.show(true, requestFocus);
        if (promise == null) {
            JdbcScriptingSessionView.$$$reportNull$$$0(5);
        }
        return promise;
    }

    @Override
    public void addRequestToHistory(@NotNull DataRequest.Context context) {
        boolean isRequestedQuery;
        String query;
        if (context == null) {
            JdbcScriptingSessionView.$$$reportNull$$$0(6);
        }
        boolean isNotEmpty = !StringUtil.isEmpty((String)(query = context.getQuery()));
        boolean isConsoleRequest = isNotEmpty && context.request instanceof ConsoleDataRequest;
        boolean bl = isRequestedQuery = isConsoleRequest && StringUtil.equalsIgnoreWhitespaces((CharSequence)query, (CharSequence)((ConsoleDataRequest)context.request).query);
        if (isRequestedQuery) {
            String text2 = ((JdbcConsole)this.getSession()).getDataSource().getFamilyId().isTransactSql() ? query : query + ";";
            ConsoleHistoryController.addToHistory((LanguageConsoleView)this.getConsoleView(), (String)text2);
        }
        super.addRequestToHistory(context);
    }

    @Override
    @NotNull
    public PlaceInGrid getResultsPlaceInView() {
        PlaceInGrid placeInGrid = PlaceInGrid.center;
        if (placeInGrid == null) {
            JdbcScriptingSessionView.$$$reportNull$$$0(7);
        }
        return placeInGrid;
    }

    @Override
    @NotNull
    public ParametersHolder getParametersHolder() {
        ParametersHolder parametersHolder = this.myParametersHolder;
        if (parametersHolder == null) {
            JdbcScriptingSessionView.$$$reportNull$$$0(8);
        }
        return parametersHolder;
    }

    @Override
    public void startLoading() {
        super.startLoading();
        this.updateFilePresentation();
    }

    @Override
    public void stopLoading() {
        super.stopLoading();
        this.updateFilePresentation();
    }

    @Override
    @NotNull
    public GridDataHookUp<DataConsumer.Row, DataConsumer.Column> createGridDataHookUp(@NotNull Disposable parent) {
        if (parent == null) {
            JdbcScriptingSessionView.$$$reportNull$$$0(9);
        }
        JdbcConsole session = (JdbcConsole)this.getSession();
        PersistentLoggingBus bus = new PersistentLoggingBus(session.getMessageBus(), this.getSessionLogger());
        DatabaseGridDataHookUp databaseGridDataHookUp = GridDataHookUpManager.getInstance(this.getProject()).createDatabaseHookUp(bus, new Sender(session), parent);
        if (databaseGridDataHookUp == null) {
            JdbcScriptingSessionView.$$$reportNull$$$0(10);
        }
        return databaseGridDataHookUp;
    }

    public void updateFilePresentation() {
        FileEditorManagerEx.getInstanceEx((Project)this.getProject()).updateFilePresentation(this.getConsoleView().getVirtualFile());
    }

    @Override
    @NotNull
    protected SessionLogger createAuditor() {
        JdbcScriptingSessionLogger jdbcScriptingSessionLogger = new JdbcScriptingSessionLogger(this);
        if (jdbcScriptingSessionLogger == null) {
            JdbcScriptingSessionView.$$$reportNull$$$0(11);
        }
        return jdbcScriptingSessionLogger;
    }

    @Override
    protected void buildConsoleUi(boolean focused) {
        this.myDataConsumer.resetOutputTabCounter();
        super.buildConsoleUi(focused);
    }

    @Override
    protected void populateActionGroup(@NotNull DefaultActionGroup group2) {
        ActionManager actionManager;
        AnAction specificActionGroup;
        if (group2 == null) {
            JdbcScriptingSessionView.$$$reportNull$$$0(12);
        }
        if ((specificActionGroup = (actionManager = ActionManager.getInstance()).getAction("Console.Dialect.SpecificGroup")) != null) {
            group2.add(specificActionGroup);
        }
        group2.addSeparator();
        group2.add(actionManager.getAction("Database.Settings"));
        group2.add(actionManager.getAction("Console.Jdbc.ToggleParameters"));
        group2.add(ConsoleHistoryController.getController((LanguageConsoleView)this.getConsoleView()).getBrowseHistory());
        group2.add(this.getUi().getOptions().getLayoutActions());
        group2.addSeparator();
        super.populateActionGroup(group2);
    }

    @Override
    protected boolean readyToDie() {
        return DatabaseEditorHelper.getDeadSession(((JdbcConsole)this.getSession()).getVirtualFile(), FileEditorManager.getInstance((Project)this.getProject())) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptModel";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/JdbcScriptingSessionView";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/JdbcScriptingSessionView";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "show";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultsPlaceInView";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersHolder";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createGridDataHookUp";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createAuditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addRequestToHistory";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createGridDataHookUp";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "populateActionGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Sender
    implements JdbcConsole.SearchPathSender {
        private final JdbcConsole mySession;

        Sender(@NotNull JdbcConsole session) {
            if (session == null) {
                Sender.$$$reportNull$$$0(0);
            }
            this.mySession = session;
        }

        @Override
        public void subscribe(@NotNull JdbcConsole.SearchPathReceiver receiver) {
            if (receiver == null) {
                Sender.$$$reportNull$$$0(1);
            }
            this.mySession.addReceiver(receiver, receiver);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiver";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcScriptingSessionView$Sender";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "subscribe";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PersistentLoggingBus
    implements DataBus.Consuming {
        private final DataBus.Consuming myParent;
        private final DataAuditor myLoggingAuditor;

        PersistentLoggingBus(@NotNull DataBus.Consuming parent, @NotNull DataAuditor auditor) {
            if (parent == null) {
                PersistentLoggingBus.$$$reportNull$$$0(0);
            }
            if (auditor == null) {
                PersistentLoggingBus.$$$reportNull$$$0(1);
            }
            this.myParent = parent;
            this.myLoggingAuditor = auditor;
        }

        @Override
        public DataBus.Consuming filterFor(@NotNull DataRequest.OwnerEx owner) {
            if (owner == null) {
                PersistentLoggingBus.$$$reportNull$$$0(2);
            }
            DataBus.Consuming filteredBus = this.myParent.filterFor(owner);
            filteredBus.addAuditor(this.myLoggingAuditor);
            return filteredBus;
        }

        @Override
        public DataProducer getDataProducer() {
            return this.myParent.getDataProducer();
        }

        @Override
        public void addConsumer(@NotNull DataConsumer dataConsumer) {
            if (dataConsumer == null) {
                PersistentLoggingBus.$$$reportNull$$$0(3);
            }
            this.myParent.addConsumer(dataConsumer);
        }

        @Override
        public void addAuditor(@NotNull DataAuditor dataAuditor) {
            if (dataAuditor == null) {
                PersistentLoggingBus.$$$reportNull$$$0(4);
            }
            this.myParent.addAuditor(dataAuditor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "auditor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataConsumer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataAuditor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/JdbcScriptingSessionView$PersistentLoggingBus";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "filterFor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addConsumer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addAuditor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

