/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.registry;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dialects.CHouseDialect;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class CHouseDomains
extends DomainRegistry {
    public CHouseDomains() {
        super(CHouseDialect.INSTANCE);
        this.add(new SimpleDomain("Date", ConversionPoint.DATE, PhysicalDomainType.DATE));
        this.add(new SimpleDomain("DateTime", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP));
        this.add(new TextDomain("FixedString", ConversionPoint.CHAR, Integer.MAX_VALUE, -1L, true){

            @Override
            public boolean isSuitable(@NotNull ColumnDescriptor descriptor) {
                String typeName;
                if (descriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (typeName = descriptor.getTypeName()) != null && StringUtil.startsWithIgnoreCase((String)typeName, (String)"FixedString");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/registry/CHouseDomains$1", "isSuitable"));
            }
        });
        this.add(new FloatDomain("Float32", ConversionPoint.SINGLE_PRECISION, -3.4028234663852886E38, 3.4028234663852886E38));
        this.add(new FloatDomain("Float64", ConversionPoint.SINGLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add(new IntegerDomain("Int8", ConversionPoint.NUMBER, -128.0, 127.0));
        this.add(new IntegerDomain("Int16", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add(new IntegerDomain("Int32", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("Int64", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new IntegerDomain("UInt8", ConversionPoint.UNSIGNED_NUMBER, 0.0, 255.0));
        this.add(new IntegerDomain("UInt16", ConversionPoint.UNSIGNED_NUMBER, 0.0, 65535.0));
        this.add(new IntegerDomain("UInt32", ConversionPoint.UNSIGNED_NUMBER, 0.0, 4.294967295E9));
        this.add(new IntegerDomain("UInt64", ConversionPoint.UNSIGNED_NUMBER, 0.0, 1.8446744073709552E19));
        this.add(new TextDomain("String", ConversionPoint.TEXT, Long.MAX_VALUE, -1L, false));
    }
}

