/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDataSource
extends SimpleModificationTracker
implements DasDataSource,
DatabaseSystem {
    private String myUniqueId;
    private String myName = "";
    private String myComment;
    private String myGroupName;

    public void init() {
        if (this.getUniqueId() == null) {
            this.myUniqueId = UUID.randomUUID().toString();
        }
    }

    protected void setUniqueId(String uniqueId) {
        this.myUniqueId = uniqueId;
    }

    public String getUniqueId() {
        return this.myUniqueId;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            AbstractDataSource.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            AbstractDataSource.$$$reportNull$$$0(1);
        }
        this.myName = name;
    }

    @Nullable
    public String getComment() {
        return this.myComment;
    }

    public void setComment(@Nullable String comment) {
        this.myComment = comment;
    }

    @Nullable
    public String getGroupName() {
        return this.myGroupName;
    }

    public void setGroupName(@Nullable String groupName) {
        this.myGroupName = AbstractDataSource.sanitizeGroupName(groupName);
    }

    public boolean isGlobal() {
        return false;
    }

    public final boolean equals(Object o) {
        return this == o;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    @NotNull
    public String toString() {
        String string = ((Object)((Object)this)).getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + ": " + this.getName();
        if (string == null) {
            AbstractDataSource.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    static String sanitizeGroupName(@Nullable String groupName) {
        return groupName == null ? null : StringUtil.nullize((String)StringUtil.trimStart((String)StringUtil.trimEnd((String)groupName.replaceAll("(?:/\\s*)+", "/"), (String)"/"), (String)"/"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/AbstractDataSource";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/AbstractDataSource";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

