/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.AuditFacade;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.ConnectionRequestor;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.remote.jdba.RemoteFacade;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.util.GuardedRef;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.project.Project;
import java.rmi.RemoteException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.BaseFacade;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.intermediate.AdaptIntermediateFacade;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateFacade;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateFacade;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J4\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u0017H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/dataSource/DBFacadeProvider;", "", "()V", "connectionManager", "Lcom/intellij/database/dataSource/DatabaseConnectionManager;", "createFacadeWithSingleLeasedConnection", "Lorg/jetbrains/dekaf/core/DBFacade;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "rdbms", "Lorg/jetbrains/dekaf/Rdbms;", "getRemoteIntermediateFacade", "Lorg/jetbrains/dekaf/intermediate/PrimeIntermediateFacade;", "wrappedConnection", "withFacade", "", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "operation", "Lkotlin/Function1;", "ProjectDBFacade", "intellij.database.impl"})
public final class DBFacadeProvider {
    private static final DatabaseConnectionManager connectionManager;
    public static final DBFacadeProvider INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void withFacade(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull DatabaseDepartment department, @NotNull Function1<? super DBFacade, Unit> operation2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)department, (String)"department");
        Intrinsics.checkParameterIsNotNull(operation2, (String)"operation");
        Rdbms rdbms = DataSourceUiUtil.getRdbmsForIntrospection(dataSource.getFamilyId());
        if (rdbms == null) {
            rdbms = UnknownDatabase.RDBMS;
        }
        Rdbms rdbms2 = rdbms;
        GuardedRef<DatabaseConnection> guardedRef = connectionManager.build(project, dataSource).setRequestor(new ConnectionRequestor.Anonymous(department)).create();
        if (guardedRef == null) {
            throw (Throwable)new RuntimeException("Failed to obtain connection");
        }
        GuardedRef<DatabaseConnection> connectionRef = guardedRef;
        AutoCloseable autoCloseable = connectionRef;
        Throwable throwable = null;
        try {
            GuardedRef c = (GuardedRef)autoCloseable;
            Object t = c.get();
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"c.get()");
            DatabaseConnection databaseConnection = (DatabaseConnection)t;
            Rdbms rdbms3 = rdbms2;
            Intrinsics.checkExpressionValueIsNotNull((Object)rdbms3, (String)"rdbms");
            DBFacade facade = DBFacadeProvider.createFacadeWithSingleLeasedConnection(databaseConnection, rdbms3);
            try {
                operation2.invoke((Object)facade);
            }
            finally {
                facade.disconnect();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @JvmStatic
    @NotNull
    public static final DBFacade createFacadeWithSingleLeasedConnection(@NotNull DatabaseConnection connection, @NotNull Rdbms rdbms) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)rdbms, (String)"rdbms");
        PrimeIntermediateFacade primeIntermediateFacade = INSTANCE.getRemoteIntermediateFacade(connection, rdbms);
        AdaptIntermediateFacade integralIntermediateFacade = new AdaptIntermediateFacade((PrimeIntermediateFacade)new AuditFacade(primeIntermediateFacade, connection));
        ProjectDBFacade facade = new ProjectDBFacade(connection.getAuditService().getProject(), (IntegralIntermediateFacade)integralIntermediateFacade);
        facade.connect();
        return (DBFacade)facade;
    }

    private final PrimeIntermediateFacade getRemoteIntermediateFacade(DatabaseConnection wrappedConnection, Rdbms rdbms) {
        PrimeIntermediateFacade remoteFacade;
        RemoteConnection remoteConnection = (RemoteConnection)RemoteUtil.castToRemoteNotNull((Object)wrappedConnection.getJdbcConnection(), RemoteConnection.class);
        try {
            RemoteFacade jpdaFacade = remoteConnection.jpdaFacade(rdbms.code);
            Object object = RemoteUtil.castToLocal((Object)jpdaFacade, PrimeIntermediateFacade.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"RemoteUtil.castToLocal(j\u2026ediateFacade::class.java)");
            remoteFacade = (PrimeIntermediateFacade)object;
            boolean bl = Intrinsics.areEqual((Object)remoteFacade.rdbms().code, (Object)rdbms.code);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
        catch (RemoteException e) {
            throw (Throwable)new RuntimeException(e);
        }
        return remoteFacade;
    }

    private DBFacadeProvider() {
    }

    static {
        DBFacadeProvider dBFacadeProvider;
        INSTANCE = dBFacadeProvider = new DBFacadeProvider();
        DatabaseConnectionManager databaseConnectionManager = DatabaseConnectionManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)databaseConnectionManager, (String)"DatabaseConnectionManager.getInstance()");
        connectionManager = databaseConnectionManager;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dataSource/DBFacadeProvider$ProjectDBFacade;", "Lorg/jetbrains/dekaf/core/BaseFacade;", "project", "Lcom/intellij/openapi/project/Project;", "facade", "Lorg/jetbrains/dekaf/intermediate/IntegralIntermediateFacade;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/dekaf/intermediate/IntegralIntermediateFacade;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "intellij.database.impl"})
    public static final class ProjectDBFacade
    extends BaseFacade {
        @Nullable
        private final Project project;

        @Nullable
        public final Project getProject() {
            return this.project;
        }

        public ProjectDBFacade(@Nullable Project project, @NotNull IntegralIntermediateFacade facade) {
            Intrinsics.checkParameterIsNotNull((Object)facade, (String)"facade");
            super(facade);
            this.project = project;
        }
    }
}

