/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DBFacadeProvider;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.introspection.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.NameVersion;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;
import org.jetbrains.dekaf.util.Version;

public class DataSourceInfo {
    @NotNull
    NameVersion databaseVersion = NameVersion.UNKNOWN;
    @NotNull
    NameVersion driverVersion = NameVersion.UNKNOWN;
    @NotNull
    String jdbcVersion = DasUtil.NO_NAME;
    @Nullable
    String identifierQuoteString;
    @Nullable
    String extraNameCharacters;
    @NotNull
    Casing casing = DasUtil.CASING_MIXED;
    DatabaseFamilyId familyId;
    Version exactVersion;

    DataSourceInfo() {
    }

    void copyFrom(@NotNull DataSourceInfo info) {
        if (info == null) {
            DataSourceInfo.$$$reportNull$$$0(0);
        }
        this.databaseVersion = info.databaseVersion;
        this.driverVersion = info.driverVersion;
        this.jdbcVersion = info.jdbcVersion;
        this.identifierQuoteString = info.identifierQuoteString;
        this.extraNameCharacters = info.extraNameCharacters;
        this.casing = info.casing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshDatabaseInfo(@NotNull LocalDataSource dataSource, @Nullable DatabaseConnection connection) throws SQLException {
        if (dataSource == null) {
            DataSourceInfo.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            return;
        }
        DataSourceInfo.refreshDatabaseInfoCoarse(dataSource, connection.getMetaData());
        Rdbms rdbms = DataSourceUiUtil.getRdbmsForIntrospection(dataSource.getInfo().familyId);
        if (rdbms == null) {
            rdbms = UnknownDatabase.RDBMS;
        }
        DBFacade facade = DBFacadeProvider.createFacadeWithSingleLeasedConnection(connection, rdbms);
        try {
            DataSourceInfo.refreshDatabaseInfoFine(dataSource, facade);
        }
        finally {
            facade.disconnect();
        }
    }

    public static void refreshDatabaseInfo(@NotNull LocalDataSource dataSource, @NotNull DBFacade facade) throws SQLException {
        if (dataSource == null) {
            DataSourceInfo.$$$reportNull$$$0(2);
        }
        if (facade == null) {
            DataSourceInfo.$$$reportNull$$$0(3);
        }
        Ref md = Ref.create();
        facade.inSession(s -> md.set(s.getSpecificService(DatabaseMetaData.class, "jdbc-metadata")));
        DataSourceInfo.refreshDatabaseInfoCoarse(dataSource, (DatabaseMetaData)ObjectUtils.assertNotNull((Object)md.get()));
        DataSourceInfo.refreshDatabaseInfoFine(dataSource, facade);
    }

    private static void refreshDatabaseInfoFine(@NotNull LocalDataSource dataSource, @NotNull DBFacade facade) {
        if (dataSource == null) {
            DataSourceInfo.$$$reportNull$$$0(4);
        }
        if (facade == null) {
            DataSourceInfo.$$$reportNull$$$0(5);
        }
        DataSourceInfo info = dataSource.getInfo();
        ConnectionInfo connectionInfo = facade.getConnectionInfo();
        String rdbmsName = connectionInfo.rdbmsName;
        if (info.familyId.isMysql()) {
            info.familyId = "MemSQL".equals(rdbmsName) ? DatabaseFamilyId.MEMSQL : ("MariaDB".equals(rdbmsName) ? DatabaseFamilyId.MARIADB : DatabaseFamilyId.MYSQL);
        } else if (info.familyId.isMicrosoft()) {
            info.familyId = "Azure".equals(rdbmsName) ? DatabaseFamilyId.AZURE : DatabaseFamilyId.MSSQL;
        }
        info.exactVersion = connectionInfo.serverVersion;
    }

    private static void refreshDatabaseInfoCoarse(@NotNull LocalDataSource dataSource, @Nullable DatabaseMetaData metaData) throws SQLException {
        if (dataSource == null) {
            DataSourceInfo.$$$reportNull$$$0(6);
        }
        DataSourceInfo info = dataSource.getInfo();
        if (metaData == null) {
            info.copyFrom(new DataSourceInfo());
            return;
        }
        info.databaseVersion = new NameVersion(metaData.getDatabaseProductName(), metaData.getDatabaseProductVersion());
        info.driverVersion = new NameVersion(metaData.getDriverName(), metaData.getDriverVersion());
        try {
            info.jdbcVersion = metaData.getJDBCMajorVersion() + "." + metaData.getJDBCMinorVersion();
        }
        catch (Throwable e) {
            try {
                metaData.getConnection();
                info.jdbcVersion = "2.1";
            }
            catch (Throwable e1) {
                info.jdbcVersion = "1.2";
            }
        }
        try {
            info.identifierQuoteString = metaData.getIdentifierQuoteString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            info.extraNameCharacters = metaData.getExtraNameCharacters();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (StringUtil.isEmptyOrSpaces((String)info.identifierQuoteString)) {
            info.identifierQuoteString = null;
        }
        if (StringUtil.isEmptyOrSpaces((String)info.extraNameCharacters)) {
            info.extraNameCharacters = null;
        }
        DataSourceInfo.initFamilyFromJdbc(dataSource, info);
        try {
            info.casing = DatabaseMetaDataWrapper.getCasing(info.familyId, metaData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void initFamilyFromJdbc(@NotNull LocalDataSource dataSource, @NotNull DataSourceInfo info) {
        if (dataSource == null) {
            DataSourceInfo.$$$reportNull$$$0(7);
        }
        if (info == null) {
            DataSourceInfo.$$$reportNull$$$0(8);
        }
        info.familyId = DatabaseFamilyId.forDataSource((DasDataSource)dataSource);
        DatabaseDialectEx.VersionParser parser = (DatabaseDialectEx.VersionParser)ObjectUtils.chooseNotNull((Object)DbImplUtil.getDatabaseDialect(info.familyId).getVersionParser(), com.intellij.openapi.util.Version::parseVersion);
        com.intellij.openapi.util.Version v = null;
        try {
            v = parser.parseVersion(info.databaseVersion.version);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        info.exactVersion = v == null ? Version.ZERO : Version.of((int[])new int[]{v.major, v.minor, v.bugfix});
    }

    public static void reset(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DataSourceInfo.$$$reportNull$$$0(9);
        }
        dataSource.getInfo().copyFrom(new DataSourceInfo());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/DataSourceInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "copyFrom";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshDatabaseInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshDatabaseInfoFine";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshDatabaseInfoCoarse";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "initFamilyFromJdbc";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

