/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceScopeEditor;
import com.intellij.database.dataSource.DataSourceScopeEditorTree;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorage;
import com.intellij.database.introspection.IntrospectionScope;
import com.intellij.database.introspection.IntrospectionScopes;
import com.intellij.database.model.BasicMetaUtils;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.view.ui.DbCheckBoxTree;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTreeAdapter;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSchemasPanel {
    private static final String INTROSPECTION_ERROR = "INTROSPECTION_ERROR";
    private final DataSourceConfigurable myDialog;
    private final MyScopeEditor myScopeEditor;
    private static final List<List<String>> ESCAPES = Arrays.asList(Arrays.asList("\\", ":", ",", "|"), Arrays.asList("\\\\", "\\:", "\\,", "\\|"));

    public DataSourceSchemasPanel(DataSourceConfigurable dialog) {
        this.myDialog = dialog;
        this.myScopeEditor = new MyScopeEditor(dialog);
        this.reset((LocalDataSource)this.myDialog.getDataSource());
        new UiNotifyConnector((Component)this.myScopeEditor.getComponent(), new Activatable(){

            public void showNotify() {
                DataSourceSchemasPanel.this.introspectIfNeeded();
            }

            public void hideNotify() {
            }
        });
    }

    private void introspectIfNeeded() {
        this.myScopeEditor.introspectIfEmpty();
    }

    public JComponent getComponent() {
        return this.myScopeEditor.getComponent();
    }

    public void saveSettings(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DataSourceSchemasPanel.$$$reportNull$$$0(0);
        }
        dataSource.setIntrospectionScope(this.myScopeEditor.getScope());
        dataSource.setFakeCurrentSchema(this.myScopeEditor.getFakeCurrentSchema());
    }

    public void reset(LocalDataSource source) {
        this.myScopeEditor.setInitialModel((LocalDataSource)this.myDialog.getDataSource(), DataSourceSchemasPanel.tryCopy((BasicModel)ObjectUtils.tryCast((Object)((LocalDataSource)this.myDialog.getDataSource()).getModel(), BasicModel.class)));
        this.myScopeEditor.resetFieldScope(source.getIntrospectionScope());
        this.myScopeEditor.setFakeCurrentSchema(source.getFakeCurrentSchema());
    }

    @Nullable
    private static BasicModel tryCopy(final @Nullable BasicModel basicModel) {
        if (basicModel == null) {
            return null;
        }
        BasicModModel modModel = DbSrcModelStorage.createFactory(null, (String)null).createModel(basicModel.getRdbms());
        modModel.modify(BasicModRoot.class, new ModelModifier<BasicModRoot>(){

            @Override
            public void perform(BasicModRoot element) {
                this.copy(element, basicModel.getRoot());
            }

            void copy(BasicModElement to, BasicElement from) {
                BasicMetaUtils.copyProperties(from, to, false);
                this.copy((ModFamily<?>)to.familyOf(ObjectKind.DATABASE), from.familyOf(ObjectKind.DATABASE));
                this.copy((ModFamily<?>)to.familyOf(ObjectKind.SCHEMA), from.familyOf(ObjectKind.SCHEMA));
            }

            void copy(ModFamily<?> to, Family<?> from) {
                if (to == null || from == null) {
                    return;
                }
                for (BasicElement element : from) {
                    this.copy((BasicModElement)to.createNewOne(), element);
                }
            }
        });
        return modModel;
    }

    private static String escape(String s) {
        return StringUtil.replace((String)s, ESCAPES.get(0), ESCAPES.get(1));
    }

    private static String unescape(String s) {
        return StringUtil.replace((String)s, ESCAPES.get(1), ESCAPES.get(0));
    }

    public static IntrospectionScope parse(String s) {
        ArrayList dbs = ContainerUtil.newArrayList();
        ArrayList schs = ContainerUtil.newArrayList();
        int dbPos = s.length();
        while (dbPos > 0) {
            int dbEnd2;
            int curDbPos = DataSourceSchemasPanel.lastIndexOf(s, '|', dbPos - 1) + 1;
            int dbEnd = DataSourceSchemasPanel.lastIndexOf(s, ':', dbPos - 1, curDbPos);
            int n = dbEnd2 = dbEnd == -1 ? -1 : DataSourceSchemasPanel.lastIndexOf(s, ':', dbEnd - 1, curDbPos);
            if (dbEnd != -1 && dbEnd2 == -1) {
                dbs.add(DataSourceSchemasPanel.unescape(s.substring(curDbPos, dbEnd)));
                LinkedHashSet ss = ContainerUtil.newLinkedHashSet();
                schs.add(ss);
                int schPos = dbPos;
                while (schPos > 0) {
                    int curSchPos = DataSourceSchemasPanel.lastIndexOf(s, ',', schPos - 1, dbEnd);
                    String sch = DataSourceSchemasPanel.unescape(s.substring(Math.max(dbEnd, curSchPos) + 1, schPos));
                    if (!sch.isEmpty()) {
                        ss.add(sch);
                    }
                    schPos = curSchPos;
                }
            }
            dbPos = curDbPos - 1;
        }
        MultiMap state = MultiMap.create();
        for (int i2 = dbs.size() - 1; i2 >= 0; --i2) {
            state.putValues(dbs.get(i2), (Collection)schs.get(i2));
        }
        return IntrospectionScopes.scopeOf((MultiMap<String, String>)state);
    }

    public static String serialize(IntrospectionScope scope) {
        StringBuilder res = new StringBuilder();
        for (String db : scope.databases()) {
            if (res.length() != 0) {
                res.append('|');
            }
            res.append(DataSourceSchemasPanel.escape(db)).append(':');
            int l = res.length();
            for (String sch : scope.schemas(db)) {
                if (res.length() != l) {
                    res.append(',');
                }
                res.append(DataSourceSchemasPanel.escape(sch));
            }
        }
        return res.toString();
    }

    private static int lastIndexOf(String s, char c, int from) {
        return DataSourceSchemasPanel.lastIndexOf(s, c, from, 0);
    }

    private static int lastIndexOf(String s, char c, int from, int to) {
        while (from >= to) {
            char cur = s.charAt(from);
            --from;
            if (cur != c) continue;
            int pos = from + 1;
            int slashes = 0;
            while (from >= to && (cur = s.charAt(from)) == '\\') {
                ++slashes;
                --from;
            }
            if (slashes % 2 != 0) continue;
            return pos;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceSchemasPanel", "saveSettings"));
    }

    private class MyScopeEditor
    extends DataSourceScopeEditor {
        private MultiMap<String, String> myEditorState;
        private IntrospectionScope myFieldScope;
        private final TextFieldWithAutoCompletion<Pair<String, ObjectKind>> myField;
        private boolean myUpdatingField;
        private boolean myUpdatingTree;
        private boolean myTreeDirty;
        private boolean myScopeFromField;

        public MyScopeEditor(DataSourceConfigurable dialog) {
            super(dialog.getProject());
            this.myFieldScope = IntrospectionScope.EMPTY_SCOPE;
            this.myUpdatingField = false;
            this.myUpdatingTree = false;
            this.myTreeDirty = false;
            this.myScopeFromField = true;
            this.myEditorState = MultiMap.empty();
            this.myField = new TextFieldWithAutoCompletion(dialog.getProject(), (TextFieldWithAutoCompletionListProvider)new MyCompletion(), false, "");
            Shortcut[] shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)"QuickJavaDoc").getShortcuts();
            this.myField.addSettingsProvider(e -> e.getContentComponent().setToolTipText(shortcuts.length == 0 ? "" : KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + " for help"));
            new AnAction("Help"){

                public void actionPerformed(AnActionEvent e) {
                    MyScopeEditor.this.showHint();
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), this.myField);
            this.myField.getDocument().addDocumentListener(new DocumentListener(){

                public void documentChanged(DocumentEvent e) {
                    if (!MyScopeEditor.this.myUpdatingTree && !MyScopeEditor.this.myUpdatingField) {
                        MyScopeEditor.this.myScopeFromField = true;
                    }
                    if (!MyScopeEditor.this.myUpdatingField) {
                        MyScopeEditor.this.setFieldScope(DataSourceSchemasPanel.parse(e.getDocument().getText()), false);
                    }
                }
            });
            JPanel southComponent = new JPanel(new BorderLayout());
            southComponent.add((Component)this.myField, "Center");
            southComponent.add((Component)new JBLabel("Pattern: "), "West");
            southComponent.setBorder(JBUI.Borders.merge((Border)DsUiDefaults.DEFAULT_PANEL_BORDER, (Border)JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)1, (int)0, (int)0, (int)0), (boolean)true));
            this.getComponent().add((Component)southComponent, "South");
            ((DataSourceScopeEditorTree)this.getTree()).addCheckboxTreeListener((CheckboxTreeListener)new CheckboxTreeAdapter(){

                public void beforeNodeStateChanged(@NotNull CheckedTreeNode node) {
                    if (node == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    MyScopeEditor.this.beforeStateChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/DataSourceSchemasPanel$MyScopeEditor$3", "beforeNodeStateChanged"));
                }
            });
        }

        private void showHint() {
            JBPopupFactory.getInstance().createBalloonBuilder(HintUtil.createInformationLabel((String)"Syntax is <strong>db1:sc1,sc2|db2:sc3</strong><br>\n<table cellpadding=0> \n<tr><td><strong>@</strong></td><td>&mdash; current database/schema</td></tr>\n<tr><td><strong>*</strong></td><td>&mdash; every database/schema</td></tr>\n</table>\nIf only schemas supported, list them after <strong>*</strong><br>\nExamples:<table cellpadding=0>\n<tr><td><strong>*:*</strong></td><td>&mdash; everything</td></tr>\n<tr><td><strong>@:*</strong></td><td>&mdash; everything from current database</td></tr>\n<tr><td><strong>@:@</strong></td><td>&mdash; current schema</td></tr>\n</table><strong>*:dbo|@:@|db1:s1,s2,s3</strong> &mdash; schema <strong>dbo</strong> from all databases,<br> current schema and three schemas from <strong>db1</strong> database\n")).setFillColor(HintUtil.getInformationColor()).setHideOnClickOutside(true).setHideOnAction(true).setClickHandler(new ActionListener(){

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/DataSourceSchemasPanel$MyScopeEditor$4", "actionPerformed"));
                }
            }, true).createBalloon().show(RelativePoint.getNorthWestOf(this.myField), Balloon.Position.above);
        }

        @Override
        protected void handleIntrospectionError(@Nullable String msg) {
            if (msg == null) {
                DataSourceSchemasPanel.this.myDialog.getController().showErrorNotification(DataSourceSchemasPanel.this.myDialog, DataSourceSchemasPanel.INTROSPECTION_ERROR, null);
            } else {
                DataSourceSchemasPanel.this.myDialog.getController().showErrorNotification(DataSourceSchemasPanel.this.myDialog, DataSourceSchemasPanel.INTROSPECTION_ERROR, "Error", msg, new Object[0]);
            }
        }

        @Override
        @Nullable
        protected LocalDataSource getDataSource(boolean withCredentials) {
            if (!withCredentials) {
                return DataSourceSchemasPanel.this.myDialog.getTempDataSource();
            }
            LocalDataSource dataSource = DataSourceSchemasPanel.this.myDialog.getTempDataSourceForConnection();
            if (this.myModel != ((LocalDataSource)DataSourceSchemasPanel.this.myDialog.getDataSource()).getModel() && this.myModel != null) {
                dataSource.setModel(this.myModel);
            }
            return dataSource;
        }

        @Override
        protected void onStateChanged() {
            if (this.myTreeDirty) {
                this.updateTreeScope();
            }
        }

        @Override
        @NotNull
        protected JComponent createNorthPanel() {
            JPanel northPanel = new JPanel(new BorderLayout());
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("DbSourceSchemas", (ActionGroup)this.createTreeActions(), true);
            toolbar.setTargetComponent((JComponent)this.getTree());
            northPanel.add((Component)toolbar.getComponent(), "West");
            northPanel.add((Component)this.getFilteringTree().installSearchField(), "East");
            JPanel jPanel = northPanel;
            if (jPanel == null) {
                MyScopeEditor.$$$reportNull$$$0(0);
            }
            return jPanel;
        }

        @Override
        protected void beforeStateChanged() {
            if (!this.myUpdatingTree && !this.myUpdatingField) {
                this.myScopeFromField = false;
            }
            this.myTreeDirty = true;
        }

        @Override
        protected void onSetScopeReady() {
            this.updateTreeScope();
        }

        public IntrospectionScope getScope() {
            if (this.myScopeFromField) {
                return this.myFieldScope;
            }
            if (this.myTreeDirty) {
                this.updateTreeScope();
            }
            return this.mySelectedScope;
        }

        private void updateTreeScope() {
            this.myTreeDirty = false;
            MultiMap<String, String> state = this.getEditorState();
            if (state.equals(this.myEditorState)) {
                return;
            }
            this.myEditorState = state;
            IntrospectionScope scope = IntrospectionScopes.scopeOf(this.myEditorState);
            if (scope.equals(this.mySelectedScope)) {
                return;
            }
            this.mySelectedScope = scope;
            if (!this.myScopeFromField) {
                this.setFieldScope(scope, true);
            }
        }

        private void resetFieldScope(IntrospectionScope scope) {
            this.myScopeFromField = true;
            this.setFieldScope(scope, true);
        }

        private void setFieldScope(IntrospectionScope scope, boolean updateText) {
            if (this.myUpdatingField) {
                return;
            }
            this.myUpdatingField = true;
            try {
                this.myFieldScope = scope;
                if (updateText) {
                    this.myField.setText(DataSourceSchemasPanel.serialize(scope));
                }
                if (this.myScopeFromField) {
                    this.setTreeScope(scope);
                }
            }
            finally {
                this.myUpdatingField = false;
            }
        }

        private void setTreeScope(IntrospectionScope scope) {
            if (this.myUpdatingTree) {
                return;
            }
            this.myUpdatingTree = true;
            try {
                this.setScopes(scope, this.myUpdatingField ? scope : null);
            }
            finally {
                this.myUpdatingTree = false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSchemasPanel$MyScopeEditor", "createNorthPanel"));
        }

        private class MyCompletion
        extends TextFieldWithAutoCompletionListProvider<Pair<String, ObjectKind>> {
            protected MyCompletion() {
                super(null);
            }

            @Nullable
            public String getPrefix(@NotNull String text2, int offset) {
                if (text2 == null) {
                    MyCompletion.$$$reportNull$$$0(0);
                }
                int last = Math.max(DataSourceSchemasPanel.lastIndexOf(text2, '|', offset - 1), Math.max(DataSourceSchemasPanel.lastIndexOf(text2, ':', offset - 1), DataSourceSchemasPanel.lastIndexOf(text2, ',', offset - 1)));
                return text2.substring(Math.max(0, last + 1), offset);
            }

            @Nullable
            protected String getTailText(@NotNull Pair<String, ObjectKind> item) {
                if (item == null) {
                    MyCompletion.$$$reportNull$$$0(1);
                }
                return "*".equals(item.first) ? "  All " + StringUtil.pluralize((String)((ObjectKind)item.second).code()) : ("@".equals(item.first) ? "  Current " + ((ObjectKind)item.second).code() : null);
            }

            @Nullable
            protected Icon getIcon(@NotNull Pair<String, ObjectKind> item) {
                if (item == null) {
                    MyCompletion.$$$reportNull$$$0(2);
                }
                return DbPresentation.getIcon((ObjectKind)item.second);
            }

            @NotNull
            protected String getLookupString(@NotNull Pair<String, ObjectKind> item) {
                if (item == null) {
                    MyCompletion.$$$reportNull$$$0(3);
                }
                String string = (String)item.first;
                if (string == null) {
                    MyCompletion.$$$reportNull$$$0(4);
                }
                return string;
            }

            @NotNull
            public Collection<Pair<String, ObjectKind>> getItems(String prefix, boolean cached, CompletionParameters parameters) {
                JBIterable schs;
                int offset = parameters.getOffset();
                String text2 = parameters.getEditor().getDocument().getText();
                int dbPos = DataSourceSchemasPanel.lastIndexOf(text2, '|', offset - 1);
                int scPos = Math.max(DataSourceSchemasPanel.lastIndexOf(text2, ':', offset - 1), DataSourceSchemasPanel.lastIndexOf(text2, ',', offset - 1));
                boolean isDb = scPos == -1 || scPos < dbPos;
                DataSourceScopeEditorTree.MyNode root2 = MyScopeEditor.this.getRoot();
                if (isDb) {
                    JBIterable dbs = MyScopeEditor.this.isSchemaRoot() ? JBIterable.empty() : JBIterable.from(root2.getChildNodes()).transform(db -> DataSourceScopeEditor.getNodeName(db)).filter(Conditions.notNull());
                    Set set = JBIterable.of((Object[])new String[]{"*", "@"}).append((Iterable)dbs).transform(n -> Pair.create((Object)n, (Object)ObjectKind.DATABASE)).toSet();
                    if (set == null) {
                        MyCompletion.$$$reportNull$$$0(5);
                    }
                    return set;
                }
                String dbName = text2.substring(0, scPos);
                if (MyScopeEditor.this.isSchemaRoot()) {
                    schs = JBIterable.from(root2.getChildNodes()).transform(sc -> DataSourceScopeEditor.getNodeName(sc));
                } else {
                    DbCheckBoxTree.MyNode db2 = "*".equals(dbName) || "@".equals(dbName) ? null : (DataSourceScopeEditorTree.MyNode)JBIterable.from(root2.getChildNodes()).find(n -> dbName.equals(DataSourceScopeEditor.getNodeName(n)));
                    schs = (db2 == null ? JBIterable.from(root2.getChildNodes()).flatten(n -> n.getChildNodes()) : JBIterable.from(db2.getChildNodes())).transform(sc -> DataSourceScopeEditor.getNodeName(sc));
                }
                Set set = JBIterable.of((Object[])new String[]{"*", "@"}).append((Iterable)schs).transform(n -> Pair.create((Object)n, (Object)ObjectKind.SCHEMA)).toSet();
                if (set == null) {
                    MyCompletion.$$$reportNull$$$0(6);
                }
                return set;
            }

            @NotNull
            public LookupElementBuilder createLookupBuilder(@NotNull Pair<String, ObjectKind> item) {
                if (item == null) {
                    MyCompletion.$$$reportNull$$$0(7);
                }
                String text2 = this.getLookupString(item);
                LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create(item, (String)DataSourceSchemasPanel.escape(text2)).withLookupString(text2).withPresentableText(text2).withIcon(this.getIcon(item)).withTailText(this.getTailText(item), true);
                if (lookupElementBuilder == null) {
                    MyCompletion.$$$reportNull$$$0(8);
                }
                return lookupElementBuilder;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dataSource/DataSourceSchemasPanel$MyScopeEditor$MyCompletion";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dataSource/DataSourceSchemasPanel$MyScopeEditor$MyCompletion";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLookupString";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getItems";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createLookupBuilder";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getPrefix";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getTailText";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getIcon";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getLookupString";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: {
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "createLookupBuilder";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

