/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.ConnectionRequestor;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.audit.AdvancedAuditService;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.JdbcUtil;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseConnection {
    private final Connection myJdbcConnection;
    private final ConsoleRunConfiguration myConfiguration;
    private final DatabaseConnectionPoint myConnectionPoint;
    private final AdvancedAuditService myAuditService;
    private final ConnectionRequestor myRequestor;

    public DatabaseConnection(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull Connection jdbcConnection, @NotNull ConsoleRunConfiguration configuration, @NotNull ConnectionRequestor requestor, @NotNull Project project) {
        if (connectionPoint == null) {
            DatabaseConnection.$$$reportNull$$$0(0);
        }
        if (jdbcConnection == null) {
            DatabaseConnection.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            DatabaseConnection.$$$reportNull$$$0(2);
        }
        if (requestor == null) {
            DatabaseConnection.$$$reportNull$$$0(3);
        }
        if (project == null) {
            DatabaseConnection.$$$reportNull$$$0(4);
        }
        this.myJdbcConnection = jdbcConnection;
        this.myConnectionPoint = connectionPoint;
        this.myConfiguration = configuration;
        this.myRequestor = requestor;
        this.myAuditService = new AdvancedAuditService(this, requestor, project);
    }

    private DatabaseConnection(@Nullable Project project, @NotNull Connection jdbcConnection, @NotNull DatabaseDepartment subsystem) {
        if (jdbcConnection == null) {
            DatabaseConnection.$$$reportNull$$$0(5);
        }
        if (subsystem == null) {
            DatabaseConnection.$$$reportNull$$$0(6);
        }
        this.myJdbcConnection = jdbcConnection;
        this.myConnectionPoint = new LocalDataSource();
        this.myConfiguration = null;
        this.myRequestor = new ConnectionRequestor.Anonymous(subsystem);
        this.myAuditService = new AdvancedAuditService(this, this.myRequestor, project);
    }

    @NotNull
    public static GuardedRef<DatabaseConnection> wrap(@Nullable Project project, @NotNull Connection jdbcConnection, @NotNull DatabaseDepartment subsystem) {
        if (jdbcConnection == null) {
            DatabaseConnection.$$$reportNull$$$0(7);
        }
        if (subsystem == null) {
            DatabaseConnection.$$$reportNull$$$0(8);
        }
        GuardedRef<DatabaseConnection> guardedRef = new GuardedRef<DatabaseConnection>(new DatabaseConnection(project, jdbcConnection, subsystem)){

            @Override
            protected void close(@NotNull DatabaseConnection ref) {
                if (ref == null) {
                    1.$$$reportNull$$$0(0);
                }
                ref.release();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/database/dataSource/DatabaseConnection$1", "close"));
            }
        };
        if (guardedRef == null) {
            DatabaseConnection.$$$reportNull$$$0(9);
        }
        return guardedRef;
    }

    @NotNull
    public ConnectionRequestor getRequestor() {
        ConnectionRequestor connectionRequestor = this.myRequestor;
        if (connectionRequestor == null) {
            DatabaseConnection.$$$reportNull$$$0(10);
        }
        return connectionRequestor;
    }

    @NotNull
    public AdvancedAuditService getAuditService() {
        AdvancedAuditService advancedAuditService = this.myAuditService;
        if (advancedAuditService == null) {
            DatabaseConnection.$$$reportNull$$$0(11);
        }
        return advancedAuditService;
    }

    @NotNull
    public DatabaseConnectionPoint getConnectionPoint() {
        DatabaseConnectionPoint databaseConnectionPoint = this.myConnectionPoint;
        if (databaseConnectionPoint == null) {
            DatabaseConnection.$$$reportNull$$$0(12);
        }
        return databaseConnectionPoint;
    }

    @Nullable
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.myJdbcConnection.getMetaData();
    }

    @NotNull
    Connection release() {
        JdbcUtil.closeSafe((AutoCloseable)this.myAuditService);
        Connection connection = this.myJdbcConnection;
        if (connection == null) {
            DatabaseConnection.$$$reportNull$$$0(13);
        }
        return connection;
    }

    @NotNull
    public Connection getJdbcConnection() {
        Connection connection = this.myJdbcConnection;
        if (connection == null) {
            DatabaseConnection.$$$reportNull$$$0(14);
        }
        return connection;
    }

    @NotNull
    public ConsoleRunConfiguration getConfiguration() {
        ConsoleRunConfiguration consoleRunConfiguration = (ConsoleRunConfiguration)((Object)ObjectUtils.assertNotNull((Object)((Object)this.myConfiguration)));
        if (consoleRunConfiguration == null) {
            DatabaseConnection.$$$reportNull$$$0(15);
        }
        return consoleRunConfiguration;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.myJdbcConnection.setAutoCommit(autoCommit);
        this.myAuditService.getWarningsListener().printConnectionWarnings();
    }

    public boolean getAutoCommit() throws SQLException {
        return this.myJdbcConnection.getAutoCommit();
    }

    public void setReadOnly(boolean only) throws SQLException {
        this.myJdbcConnection.setReadOnly(only);
        this.myAuditService.getWarningsListener().printConnectionWarnings();
    }

    public boolean isReadOnly() throws SQLException {
        return this.myJdbcConnection.isReadOnly();
    }

    public void rollback() throws SQLException {
        this.myJdbcConnection.rollback();
        this.myAuditService.getWarningsListener().printConnectionWarnings();
    }

    public void rollback(@NotNull Savepoint savepoint) throws SQLException {
        if (savepoint == null) {
            DatabaseConnection.$$$reportNull$$$0(16);
        }
        this.myJdbcConnection.rollback(savepoint);
        this.myAuditService.getWarningsListener().printConnectionWarnings();
    }

    public void releaseSavepoint(@NotNull Savepoint savepoint) throws SQLException {
        if (savepoint == null) {
            DatabaseConnection.$$$reportNull$$$0(17);
        }
        this.myJdbcConnection.releaseSavepoint(savepoint);
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.myJdbcConnection.setSavepoint();
    }

    public void commit() throws SQLException {
        this.myJdbcConnection.commit();
        this.myAuditService.getWarningsListener().printConnectionWarnings();
    }

    void cancelAll() {
        try {
            ((RemoteConnection)RemoteUtil.castToRemoteNotNull((Object)this.myJdbcConnection, RemoteConnection.class)).cancelAll();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionPoint";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdbcConnection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subsystem";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseConnection";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "savepoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseConnection";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "wrap";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuditService";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionPoint";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "release";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdbcConnection";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "rollback";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "releaseSavepoint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

