/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.connection.statements;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.audit.ListenerAuditService;
import com.intellij.database.dataSource.connection.statements.BatchesContainer;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.JdbcBasedSmartStatement;
import com.intellij.database.dataSource.connection.statements.OneShotSmartStatement;
import com.intellij.database.dataSource.connection.statements.ReusableNoisyStatement;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementsUtil;
import com.intellij.database.dataSource.connection.statements.StatementHolder;
import com.intellij.database.util.JdbcUtil;
import java.sql.Statement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00030\u0002:\u0001\u0018B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u000eH\u0014J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016J\u001b\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00162\u0006\u0010\u0013\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0017R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/dataSource/connection/statements/SimpleSmartStatement;", "Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Simple;", "Lcom/intellij/database/dataSource/connection/statements/OneShotSmartStatement;", "", "", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "configuration", "Lcom/intellij/database/dataSource/connection/statements/Configuration;", "(Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;Lcom/intellij/database/dataSource/connection/statements/Configuration;)V", "statementHolder", "Lcom/intellij/database/dataSource/connection/statements/StatementHolder$OneShot;", "Ljava/sql/Statement;", "getStatementHolder", "()Lcom/intellij/database/dataSource/connection/statements/StatementHolder$OneShot;", "before", "Lcom/intellij/database/dataSource/connection/Either;", "input", "statement", "reuse", "Lcom/intellij/database/dataSource/connection/statements/ReusableSmartStatement;", "(Lkotlin/Unit;)Lcom/intellij/database/dataSource/connection/statements/ReusableSmartStatement;", "Reusable", "intellij.database.impl"})
public final class SimpleSmartStatement
extends JdbcBasedSmartStatement.Simple
implements OneShotSmartStatement<String, Unit, String> {
    @NotNull
    private final StatementHolder.OneShot<Statement> statementHolder;

    @Override
    @NotNull
    protected StatementHolder.OneShot<Statement> getStatementHolder() {
        return this.statementHolder;
    }

    @NotNull
    public final ReusableSmartStatement<String> reuse() {
        return new Reusable(this.getConnection(), this.getAuditService(), this.getConfiguration());
    }

    @Override
    @NotNull
    protected Either<Unit> before(@NotNull String input, @NotNull Statement statement) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
        this.getAuditService().beforeSimpleStatement(input, this);
        return super.before(input, statement);
    }

    @Override
    @NotNull
    public ReusableSmartStatement<String> reuse(@NotNull Unit input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.reuse();
    }

    public SimpleSmartStatement(@NotNull DatabaseConnection connection, @NotNull ListenerAuditService auditService, @NotNull Configuration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)auditService, (String)"auditService");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        super(connection, auditService, configuration);
        this.statementHolder = new StatementHolder.OneShot(auditService, this);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u00162\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u000fH\u0014J\b\u0010\u0018\u001a\u00020\u0013H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0016H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/dataSource/connection/statements/SimpleSmartStatement$Reusable;", "Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Simple;", "Lcom/intellij/database/dataSource/connection/statements/ReusableSmartStatement;", "", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "configuration", "Lcom/intellij/database/dataSource/connection/statements/Configuration;", "(Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;Lcom/intellij/database/dataSource/connection/statements/Configuration;)V", "batches", "Lcom/intellij/database/dataSource/connection/statements/BatchesContainer;", "statementHolder", "Lcom/intellij/database/dataSource/connection/statements/StatementHolder$Reusable;", "Ljava/sql/Statement;", "getStatementHolder", "()Lcom/intellij/database/dataSource/connection/statements/StatementHolder$Reusable;", "addBatch", "", "input", "before", "Lcom/intellij/database/dataSource/connection/Either;", "statement", "close", "executeBatch", "Lcom/intellij/database/dataSource/connection/statements/ClosableResultsProducer;", "intellij.database.impl"})
    private static final class Reusable
    extends JdbcBasedSmartStatement.Simple
    implements ReusableSmartStatement<String> {
        @NotNull
        private final StatementHolder.Reusable<Statement> statementHolder;
        private final BatchesContainer batches;

        @Override
        @NotNull
        protected StatementHolder.Reusable<Statement> getStatementHolder() {
            return this.statementHolder;
        }

        @Override
        public void addBatch(@NotNull String input) {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            ((Statement)this.getCurrentStatement(input).tryGet().getValue()).addBatch(input);
            this.batches.add(input);
        }

        @Override
        @NotNull
        protected Either<Unit> before(@NotNull String input, @NotNull Statement statement) {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
            this.getAuditService().beforeSimpleStatement(input, this);
            return super.before(input, statement);
        }

        @Override
        @NotNull
        public Either<ClosableResultsProducer> executeBatch() {
            Object s = ((StatementHolder.Reusable)this.getStatementHolder()).getStatement();
            if (s == null) {
                Intrinsics.throwNpe();
            }
            return SmartStatementsUtil.executeBatch(s, this.getConnection(), this, this.batches);
        }

        @Override
        public void close() {
            if (((StatementHolder.Reusable)this.getStatementHolder()).getStatement() != null) {
                ListenerAuditService listenerAuditService = this.getAuditService();
                Object s = ((StatementHolder.Reusable)this.getStatementHolder()).getStatement();
                if (s == null) {
                    Intrinsics.throwNpe();
                }
                listenerAuditService.beforeStatementClosing((Statement)s, this);
            }
            JdbcUtil.closeSafe((AutoCloseable)((AutoCloseable)((StatementHolder.Reusable)this.getStatementHolder()).getStatement()));
            this.batches.clear();
        }

        public Reusable(@NotNull DatabaseConnection connection, @NotNull ListenerAuditService auditService, @NotNull Configuration configuration) {
            Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
            Intrinsics.checkParameterIsNotNull((Object)auditService, (String)"auditService");
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            super(connection, auditService, configuration);
            this.statementHolder = new StatementHolder.Reusable();
            this.batches = new BatchesContainer();
        }

        @Override
        @NotNull
        public ReusableNoisyStatement<String> noisy() {
            return ReusableSmartStatement.DefaultImpls.noisy(this);
        }
    }
}

