/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorage;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorageManager;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

public class DbSrcUtils {
    private static final String EMPTY = "&empty;";
    private static final List<List<String>> ESCAPES = Arrays.asList(Arrays.asList("/", "\\", "&", "@"), Arrays.asList("&eslash;", "&slash;", "&amp;", "&at;"));

    private DbSrcUtils() {
    }

    public static boolean isDbSrcFile(@Nullable VirtualFile file) {
        return file != null && file.getFileSystem() instanceof DbSrcFileSystem;
    }

    @NotNull
    public static String getProjectId(Project project) {
        String string = project == null ? "app" : project.getLocationHash();
        if (string == null) {
            DbSrcUtils.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public static ObjectPath getFullPath(@NotNull String path) {
        if (path == null) {
            DbSrcUtils.$$$reportNull$$$0(1);
        }
        return DbSrcFileSystem.processPath(path, new DbSrcFileSystem.ItemProcessor<ObjectPath>(){

            @Override
            public ObjectPath processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, ObjectKind group2) {
                if (dataSourceId == null) {
                    1.$$$reportNull$$$0(0);
                }
                return group2 == null ? path : null;
            }

            @Override
            public ObjectPath processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, boolean original) {
                if (dataSourceId == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (path == null) {
                    1.$$$reportNull$$$0(2);
                }
                return path;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceId";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcUtils$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFolder";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFile";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    public static ObjectKind getKind(@NotNull String path) {
        ObjectPath obj;
        if (path == null) {
            DbSrcUtils.$$$reportNull$$$0(2);
        }
        return (obj = DbSrcUtils.getFullPath(path)) == null ? null : obj.kind;
    }

    @NotNull
    public static Rdbms getRdbms(@Nullable Project project, @NotNull String dataSourceId) {
        LocalDataSource dataSource;
        if (dataSourceId == null) {
            DbSrcUtils.$$$reportNull$$$0(3);
        }
        Rdbms rdbms = (dataSource = DbSrcUtils.findDataSource(project, dataSourceId)) == null ? UnknownDatabase.RDBMS : DbImplUtil.getRdbms(dataSource.getFamilyId());
        if (rdbms == null) {
            DbSrcUtils.$$$reportNull$$$0(4);
        }
        return rdbms;
    }

    @Nullable
    public static <T extends DasObject> T findObject(final @Nullable Project hint, @NotNull String file, final @NotNull Class<? extends T> clazz) {
        if (file == null) {
            DbSrcUtils.$$$reportNull$$$0(5);
        }
        if (clazz == null) {
            DbSrcUtils.$$$reportNull$$$0(6);
        }
        return (T)((DasObject)DbSrcFileSystem.processPath(file, new DbSrcFileSystem.ItemProcessor<T>(){

            @Override
            public T processFile(@Nullable Project p, @NotNull String dataSourceId, @NotNull ObjectPath path, boolean original) {
                if (dataSourceId == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    2.$$$reportNull$$$0(1);
                }
                DbDataSource dataSource = null;
                if (p == null && hint != null) {
                    p = hint;
                }
                if (p == null) {
                    for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                        if (project.isDefault() || !project.isOpen()) break;
                        dataSource = DbPsiFacade.getInstance((Project)project).findDataSource(dataSourceId);
                    }
                } else {
                    dataSource = DbPsiFacade.getInstance((Project)p).findDataSource(dataSourceId);
                }
                if (dataSource == null) {
                    return null;
                }
                return (DasObject)DbSqlUtil.findObjects(dataSource, path).filter(clazz).first();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dataSource/srcStorage/DbSrcUtils$2";
                objectArray[2] = "processFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
    }

    @Nullable
    public static <T extends DbElement> T findDbElement(final @NotNull Project project, @NotNull String file, final @NotNull Class<T> clazz) {
        if (project == null) {
            DbSrcUtils.$$$reportNull$$$0(7);
        }
        if (file == null) {
            DbSrcUtils.$$$reportNull$$$0(8);
        }
        if (clazz == null) {
            DbSrcUtils.$$$reportNull$$$0(9);
        }
        return (T)((DbElement)DbSrcFileSystem.processPath(file, new DbSrcFileSystem.ItemProcessor<T>(){

            @Override
            public T processFile(@Nullable Project p, @NotNull String dataSourceId, @NotNull ObjectPath path, boolean original) {
                if (dataSourceId == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (p != null && p != project) {
                    return null;
                }
                DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource(dataSourceId);
                if (dataSource == null) {
                    return null;
                }
                DbElement result2 = DbSqlUtil.findElement(dataSource, path);
                return (DbElement)ObjectUtils.tryCast((Object)result2, (Class)clazz);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dataSource/srcStorage/DbSrcUtils$3";
                objectArray[2] = "processFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
    }

    @Nullable
    public static LocalDataSource findDataSource(@Nullable Project project, @NotNull String id) {
        if (id == null) {
            DbSrcUtils.$$$reportNull$$$0(10);
        }
        List<? extends LocalDataSource> sources = DbSrcUtils.getDataSources(project);
        for (LocalDataSource localDataSource : sources) {
            if (localDataSource.isGlobal() != (project == null) || !id.equals(localDataSource.getUniqueId())) continue;
            return localDataSource;
        }
        return null;
    }

    @Nullable
    public static LocalDataSource findDataSource(@NotNull String id) {
        LocalDataSource res;
        if (id == null) {
            DbSrcUtils.$$$reportNull$$$0(11);
        }
        if ((res = DbSrcUtils.findDataSource(null, id)) != null) {
            return res;
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            res = DbSrcUtils.findDataSource(project, id);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    @Nullable
    public static LocalDataSource findDataSource(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        return DbSrcFileSystem.processPath(file, new DbSrcFileSystem.ItemProcessor<LocalDataSource>(){

            @Override
            public LocalDataSource processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                if (dataSourceId == null) {
                    4.$$$reportNull$$$0(0);
                }
                return DbSrcUtils.findDataSource(project, dataSourceId);
            }

            @Override
            public LocalDataSource processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group2) {
                if (dataSourceId == null) {
                    4.$$$reportNull$$$0(1);
                }
                return DbSrcUtils.findDataSource(project, dataSourceId);
            }

            @Override
            public LocalDataSource processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, boolean original) {
                if (dataSourceId == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (path == null) {
                    4.$$$reportNull$$$0(3);
                }
                return DbSrcUtils.findDataSource(project, dataSourceId);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceId";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcUtils$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processDataSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFolder";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFile";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public static List<? extends LocalDataSource> getDataSources(@Nullable Project project) {
        List<LocalDataSource> list = project == null ? DataSourceStorage.getStorage().getDataSources() : DataSourceStorage.getProjectStorage(project).getDataSources();
        if (list == null) {
            DbSrcUtils.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    public static VirtualFile findDbSrcFile(@NotNull DbDataSource dataSource, @Nullable DbElement object, boolean refresh) {
        LocalDataSource source;
        if (dataSource == null) {
            DbSrcUtils.$$$reportNull$$$0(13);
        }
        return (source = (LocalDataSource)ObjectUtils.tryCast((Object)dataSource.getDelegate(), LocalDataSource.class)) == null ? null : DbSrcUtils.findDbSrcFile(dataSource.getProject(), source, object, refresh);
    }

    @Nullable
    public static VirtualFile findDbSrcFile(@NotNull Project project, @NotNull LocalDataSource dataSource, @Nullable DbElement object, boolean refresh) {
        if (project == null) {
            DbSrcUtils.$$$reportNull$$$0(14);
        }
        if (dataSource == null) {
            DbSrcUtils.$$$reportNull$$$0(15);
        }
        DasModel casingProvider = object == null ? null : object.getDataSource().getModel();
        String filePath = DbSrcFileSystem.getPath(dataSource.isGlobal() ? null : project, dataSource.getUniqueId(), (DasObject)object, (CasingProvider)casingProvider, DbSrcFileSystem.ItemType.SRC);
        return refresh ? DbSrcFileSystem.getInstance().refreshAndFindFileByPath(filePath) : DbSrcFileSystem.getInstance().findFileByPath(filePath);
    }

    @Nullable
    public static Ref<Project> getProject(@NotNull String file) {
        if (file == null) {
            DbSrcUtils.$$$reportNull$$$0(16);
        }
        return DbSrcFileSystem.processPath(file, new DbSrcFileSystem.ItemProcessor<Ref<Project>>(){

            @Override
            public Ref<Project> processProject(@Nullable Project project) {
                return Ref.create((Object)project);
            }

            @Override
            public Ref<Project> processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                if (dataSourceId == null) {
                    5.$$$reportNull$$$0(0);
                }
                return Ref.create((Object)project);
            }

            @Override
            public Ref<Project> processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group2) {
                if (dataSourceId == null) {
                    5.$$$reportNull$$$0(1);
                }
                return Ref.create((Object)project);
            }

            @Override
            public Ref<Project> processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, boolean original) {
                if (dataSourceId == null) {
                    5.$$$reportNull$$$0(2);
                }
                if (path == null) {
                    5.$$$reportNull$$$0(3);
                }
                return Ref.create((Object)project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceId";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcUtils$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processDataSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFolder";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFile";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    public static String getDataSource(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcUtils.$$$reportNull$$$0(17);
        }
        return DbSrcFileSystem.processPath(file, new DbSrcFileSystem.ItemProcessor<String>(){

            @Override
            public String processDataSource(@Nullable Project project, @NotNull String dataSourceId) {
                if (dataSourceId == null) {
                    6.$$$reportNull$$$0(0);
                }
                return dataSourceId;
            }

            @Override
            public String processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group2) {
                if (dataSourceId == null) {
                    6.$$$reportNull$$$0(1);
                }
                return dataSourceId;
            }

            @Override
            public String processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, boolean original) {
                if (dataSourceId == null) {
                    6.$$$reportNull$$$0(2);
                }
                if (path == null) {
                    6.$$$reportNull$$$0(3);
                }
                return dataSourceId;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataSourceId";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcUtils$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processDataSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFolder";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processFile";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static void refresh() {
        DbSrcFileSystem.getInstance().refresh(true);
    }

    public static void revert(@NotNull Iterable<VirtualFile> files) throws IOException {
        if (files == null) {
            DbSrcUtils.$$$reportNull$$$0(18);
        }
        final MultiMap items = MultiMap.createLinked();
        ArrayList affected = ContainerUtil.newArrayList();
        for (VirtualFile file : files) {
            DbSrcFileSystem.processPath(file, new DbSrcFileSystem.ItemProcessor<Void>(){

                @Override
                public Void processFile(@Nullable Project project, @NotNull String dataSourceId, @NotNull ObjectPath path, boolean original) {
                    if (dataSourceId == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    if (path == null) {
                        7.$$$reportNull$$$0(1);
                    }
                    if (original) {
                        return null;
                    }
                    DbSrcStorage storage = DbSrcStorageManager.getInstance(project).getStorage(dataSourceId, true);
                    items.putValue((Object)storage, (Object)path);
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "dataSourceId";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "path";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/database/dataSource/srcStorage/DbSrcUtils$7";
                    objectArray[2] = "processFile";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        for (Map.Entry entry : items.entrySet()) {
            DbSrcStorage storage = (DbSrcStorage)entry.getKey();
            for (ObjectPath path : (Collection)entry.getValue()) {
                storage.putContent(path, null);
            }
        }
        ContainerUtil.addAll((Collection)affected, files);
        fileDocumentManager.reloadFiles(VfsUtilCore.toVirtualFileArray((Collection)affected));
        DbSrcUtils.refresh();
    }

    public static Icon getIcon(@Nullable Project hint, String path) {
        DasObject object = DbSrcUtils.findObject(hint, path, DasObject.class);
        if (object != null) {
            return DbPresentation.getIcon(object);
        }
        ObjectKind kind = DbSrcUtils.getKind(path);
        return kind == null ? null : DbPresentation.getIcon(kind);
    }

    private static int readMaximum(InputStream is, byte[] buffer) throws IOException {
        int offs = 0;
        int read2;
        while ((read2 = is.read(buffer, offs, buffer.length - offs)) != -1) {
            offs += read2;
        }
        return offs == 0 ? -1 : offs;
    }

    public static void moveStorage(@NotNull LocalDataSource dataSource, @Nullable Project from, @Nullable Project to) throws IOException {
        DbSrcModelStorage storage;
        String id;
        if (dataSource == null) {
            DbSrcUtils.$$$reportNull$$$0(19);
        }
        if ((id = dataSource.getUniqueId()) == null) {
            return;
        }
        DbSrcUtils.moveStorage(id, from, to);
        BasicModModel model = (BasicModModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BasicModModel.class);
        DbSrcModelStorage dbSrcModelStorage = storage = model == null ? null : (DbSrcModelStorage)ObjectUtils.tryCast((Object)model.getTextStorage(), DbSrcModelStorage.class);
        if (storage != null) {
            model.setTextStorage(DbSrcModelStorage.createStorage(to, id));
        }
    }

    public static void moveStorage(@NotNull String dataSourceId, @Nullable Project from, @Nullable Project to) throws IOException {
        if (dataSourceId == null) {
            DbSrcUtils.$$$reportNull$$$0(20);
        }
        if (from == to) {
            return;
        }
        DbSrcStorageManager srcManager = DbSrcStorageManager.getInstance(from);
        DbSrcStorage src = srcManager.getStorage(dataSourceId, false);
        if (src == null) {
            return;
        }
        DbSrcStorage tgt = DbSrcStorageManager.getInstance(to).getStorage(dataSourceId, true);
        tgt.consume(src);
        src.flushToFs(true);
        tgt.flushToFs(true);
        srcManager.removeBackend(dataSourceId);
    }

    public static boolean contentDiffers(InputStream is1, InputStream is2) throws IOException {
        int r1;
        boolean differs;
        byte[] buffer1 = new byte[0x100000];
        byte[] buffer2 = new byte[0x100000];
        do {
            int r2;
            differs = (r1 = DbSrcUtils.readMaximum(is1, buffer1)) != (r2 = DbSrcUtils.readMaximum(is2, buffer2));
            for (int i2 = 0; i2 < r1 && !differs; ++i2) {
                differs = buffer1[i2] != buffer2[i2];
            }
        } while (!differs && r1 != -1);
        return differs;
    }

    public static boolean contentDiffers(InputStream is, byte[] data) throws IOException {
        byte[] buffer = new byte[0x100000];
        int offset = 0;
        int r1;
        while ((r1 = DbSrcUtils.readMaximum(is, buffer)) != -1) {
            int end = offset + r1;
            if (end > data.length) {
                return true;
            }
            for (int i2 = 0; i2 < r1; ++i2) {
                if (data[offset + i2] == buffer[i2]) continue;
                return true;
            }
            offset = end;
        }
        return offset != data.length;
    }

    public static boolean isOriginal(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcUtils.$$$reportNull$$$0(21);
        }
        return file.getName().endsWith(".orig.sql");
    }

    @Nullable
    public static ObjectKind findKind(@Nullable String code) {
        return code == null ? null : (ObjectKind)ObjectKind.ourKinds.get(code);
    }

    public static String escapeChars(String s) {
        if (s == null) {
            return null;
        }
        if (s.isEmpty()) {
            return EMPTY;
        }
        return StringUtil.replace((String)s, ESCAPES.get(0), ESCAPES.get(1));
    }

    public static String unescapeChars(String s) {
        if (s == null) {
            return null;
        }
        if (s.equals(EMPTY)) {
            return "";
        }
        return StringUtil.replace((String)s, ESCAPES.get(1), ESCAPES.get(0));
    }

    public static Iterable<String> splitPath(@NotNull String path) {
        if (path == null) {
            DbSrcUtils.$$$reportNull$$$0(22);
        }
        return StringUtil.tokenize((String)path, (String)String.valueOf('/'));
    }

    public static int hashCode(CharSequence cs) {
        int res = 0;
        if (cs != null) {
            for (int i2 = 0; i2 < cs.length(); ++i2) {
                res = StringHashBuilder.hashStep(res, cs.charAt(i2));
            }
        }
        return res;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcUtils";
                break;
            }
            case 1: 
            case 2: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceId";
                break;
            }
            case 5: 
            case 8: 
            case 16: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 13: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRdbms";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSources";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFullPath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getKind";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRdbms";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findObject";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findDbElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findDataSource";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findDbSrcFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getProject";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDataSource";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "revert";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "moveStorage";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isOriginal";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "splitPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class StringHashBuilder {
        private int h = 0;

        public void consume(int c) {
            this.h = StringHashBuilder.hashStep(this.h, c);
        }

        public void consume(byte[] a, int s, int f) {
            while (s < f) {
                this.consume(a[s]);
                ++s;
            }
        }

        public void consume(byte[] a) {
            this.consume(a, 0, a.length);
        }

        public static int hashStep(int h, int c) {
            return 31 * h + c;
        }

        public static int hashStep(int h, byte[] a, int s, int f) {
            if (a == null) {
                return h;
            }
            while (s < f) {
                h = StringHashBuilder.hashStep(h, a[s]);
                ++s;
            }
            return h;
        }

        public static int hashStep(int h, byte[] a) {
            return a == null ? h : StringHashBuilder.hashStep(h, a, 0, a.length);
        }

        public int get() {
            return this.h;
        }
    }
}

