/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorageManager;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.ScriptingCapabilities;
import com.intellij.database.scripting.ScriptingFactory;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.io.IOException;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcValidator {
    private final ScriptingFactory myScripting = (ScriptingFactory)ServiceManager.getService(ScriptingFactory.class);

    public static boolean isEnabled() {
        return ApplicationManager.getApplication().isInternal();
    }

    @NotNull
    public Couple<List<LocalDataSource>> collect(@Nullable Project project, @NotNull Iterable<LocalDataSource> dataSources2) {
        if (dataSources2 == null) {
            DbSrcValidator.$$$reportNull$$$0(0);
        }
        Couple res = Couple.of((Object)ContainerUtil.newArrayList(), (Object)ContainerUtil.newArrayList());
        for (LocalDataSource source : dataSources2) {
            Result result2;
            assert (source.isGlobal() || project != null);
            if (project != null && project.isDisposed()) break;
            DbSrcStorage storage = DbSrcStorageManager.getInstance(source.isGlobal() ? null : project).getStorage(source.getUniqueId(), true);
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)source.getModel(), BasicModel.class);
            if (model == null || (result2 = this.isValid(storage, model)) == Result.VALID) continue;
            if (result2 == Result.GENERATE || result2 == Result.GENERATE_AND_INTROSPECT) {
                ((List)res.first).add(source);
            }
            if (result2 != Result.INTROSPECT && result2 != Result.GENERATE_AND_INTROSPECT) continue;
            ((List)res.second).add(source);
        }
        Couple couple = res;
        if (couple == null) {
            DbSrcValidator.$$$reportNull$$$0(1);
        }
        return couple;
    }

    @NotNull
    public Result isValid(@NotNull DbSrcStorage storage, @NotNull BasicModel model) {
        if (storage == null) {
            DbSrcValidator.$$$reportNull$$$0(2);
        }
        if (model == null) {
            DbSrcValidator.$$$reportNull$$$0(3);
        }
        Result result2 = Result.VALID;
        for (BasicSchema schema : DbSrcValidator.getSchemas(model)) {
            Result cur = this.isValid(storage, model, schema);
            if (result2 == Result.GENERATE && cur == Result.INTROSPECT || result2 == Result.INTROSPECT && cur == Result.GENERATE) {
                Result result3 = Result.GENERATE_AND_INTROSPECT;
                if (result3 == null) {
                    DbSrcValidator.$$$reportNull$$$0(4);
                }
                return result3;
            }
            if (cur.ordinal() <= result2.ordinal()) continue;
            result2 = cur;
        }
        Result result4 = result2;
        if (result4 == null) {
            DbSrcValidator.$$$reportNull$$$0(5);
        }
        return result4;
    }

    @NotNull
    public Result isValid(@NotNull DbSrcStorage storage, @NotNull BasicModel model, @NotNull BasicSchema schema) {
        Result result2;
        if (storage == null) {
            DbSrcValidator.$$$reportNull$$$0(6);
        }
        if (model == null) {
            DbSrcValidator.$$$reportNull$$$0(7);
        }
        if (schema == null) {
            DbSrcValidator.$$$reportNull$$$0(8);
        }
        if ((result2 = this.checkVersions(storage, model, schema)) != null) {
            Result result3 = result2;
            if (result3 == null) {
                DbSrcValidator.$$$reportNull$$$0(9);
            }
            return result3;
        }
        result2 = Result.VALID;
        for (BasicSourceAware object : DbSrcValidator.getSources(model, schema)) {
            Result cur = (Result)((Object)ObjectUtils.chooseNotNull((Object)((Object)this.checkVersions(storage, model, object)), (Object)((Object)Result.VALID)));
            if (cur.ordinal() > result2.ordinal()) {
                result2 = cur;
            }
            if (result2 != Result.INTROSPECT) continue;
            break;
        }
        this.updateSchemaValidness(storage, model, schema, result2);
        Result result4 = result2;
        if (result4 == null) {
            DbSrcValidator.$$$reportNull$$$0(10);
        }
        return result4;
    }

    @NotNull
    private static JBIterable<BasicSchema> getSchemas(@NotNull BasicModel model) {
        if (model == null) {
            DbSrcValidator.$$$reportNull$$$0(11);
        }
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)model.traverser().withRoots(model.getModelRoots())).expand(n -> n.getKind() != ObjectKind.SCHEMA)).filter(BasicSchema.class).filter(BasicMateNamespace::isVisible);
        if (jBIterable == null) {
            DbSrcValidator.$$$reportNull$$$0(12);
        }
        return jBIterable;
    }

    private static JBIterable<BasicSourceAware> getSources(@NotNull BasicModel model, @Nullable BasicSchema schema) {
        if (model == null) {
            DbSrcValidator.$$$reportNull$$$0(13);
        }
        JBTreeTraverser traverser2 = model.traverser();
        traverser2 = schema != null ? (JBTreeTraverser)((JBTreeTraverser)traverser2.withRoot((Object)schema)).expand(Conditions.alwaysTrue()) : (JBTreeTraverser)((JBTreeTraverser)traverser2.withRoot((Object)model.getRoot())).expand(o -> !(o instanceof DasNamespace) || ((DasNamespace)o).isVisible());
        return traverser2.filter(BasicSourceAware.class);
    }

    @Nullable
    private Result checkVersions(@NotNull DbSrcStorage storage, @NotNull BasicModel model, @NotNull BasicElement object) {
        if (storage == null) {
            DbSrcValidator.$$$reportNull$$$0(14);
        }
        if (model == null) {
            DbSrcValidator.$$$reportNull$$$0(15);
        }
        if (object == null) {
            DbSrcValidator.$$$reportNull$$$0(16);
        }
        ObjectPath path = ObjectPaths.of(object);
        ScriptingService service = this.myScripting.getScriptingService(model.getRdbms());
        DbSrcStorageDsMetadata.MetaData metaData = storage.getMetaData(path);
        if (metaData == null) {
            return null;
        }
        ScriptingCapabilities caps = service.capabilities(object);
        if (object.getKind() == ObjectKind.SCHEMA) {
            if (metaData.introContentVersion < 0 && metaData.introContentVersion != DbSrcStorageDsMetadata.MetaData.EMPTY.introContentVersion) {
                return Result.INTROSPECT;
            }
            if (metaData.genContentVersion < 0 && metaData.genContentVersion != DbSrcStorageDsMetadata.MetaData.EMPTY.genContentVersion) {
                return Result.GENERATE;
            }
            int genVersion = caps.getCreateVersion();
            int introVersion = DBIntrospectorFactory.getCurrentSrcIntrospectionVersion(model.getRdbms(), object.getKind());
            boolean match = introVersion == metaData.introContentVersion && genVersion == metaData.genContentVersion;
            return match ? Result.VALID : null;
        }
        int genVersion = caps.getCreateVersion();
        int introVersion = DBIntrospectorFactory.getCurrentSrcIntrospectionVersion(model.getRdbms(), object.getKind());
        if (introVersion != metaData.introContentVersion) {
            return Result.INTROSPECT;
        }
        if (genVersion != metaData.genContentVersion) {
            return Result.GENERATE;
        }
        return Result.VALID;
    }

    private void updateSchemaValidness(@NotNull DbSrcStorage storage, @NotNull BasicModel model, @NotNull BasicSchema object, @NotNull Result result2) {
        if (storage == null) {
            DbSrcValidator.$$$reportNull$$$0(17);
        }
        if (model == null) {
            DbSrcValidator.$$$reportNull$$$0(18);
        }
        if (object == null) {
            DbSrcValidator.$$$reportNull$$$0(19);
        }
        if (result2 == null) {
            DbSrcValidator.$$$reportNull$$$0(20);
        }
        ObjectPath path = ObjectPaths.of(object);
        ScriptingCapabilities caps = this.myScripting.getScriptingService(model.getRdbms()).capabilities(object);
        DbSrcStorageDsMetadata.MetaData metaData = (DbSrcStorageDsMetadata.MetaData)ObjectUtils.chooseNotNull((Object)storage.getMetaData(path), (Object)DbSrcStorageDsMetadata.MetaData.EMPTY);
        int introVersion = DBIntrospectorFactory.getCurrentSrcIntrospectionVersion(model.getRdbms(), object.getKind());
        int genVersion = caps.getCreateVersion();
        metaData = DbSrcStorageDsMetadata.MetaData.modContentVersion(metaData, result2 == Result.INTROSPECT ? -introVersion : introVersion, result2 != Result.VALID ? -genVersion : genVersion);
        try {
            storage.putMetaData(path, metaData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void invalidate(@NotNull DbSrcStorage storage, @NotNull ObjectPath path) {
        DbSrcStorageDsMetadata.MetaData metaData;
        if (storage == null) {
            DbSrcValidator.$$$reportNull$$$0(21);
        }
        if (path == null) {
            DbSrcValidator.$$$reportNull$$$0(22);
        }
        if ((metaData = (DbSrcStorageDsMetadata.MetaData)ObjectUtils.chooseNotNull((Object)storage.getMetaData(path), (Object)DbSrcStorageDsMetadata.MetaData.EMPTY)) == null) {
            return;
        }
        try {
            storage.putMetaData(path, DbSrcStorageDsMetadata.MetaData.modContentVersion(metaData, DbSrcStorageDsMetadata.MetaData.EMPTY.introContentVersion, DbSrcStorageDsMetadata.MetaData.EMPTY.genContentVersion));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void suggestIntrospecting(@NotNull Project project, @NotNull List<LocalDataSource> dataSources2) {
        if (project == null) {
            DbSrcValidator.$$$reportNull$$$0(23);
        }
        if (dataSources2 == null) {
            DbSrcValidator.$$$reportNull$$$0(24);
        }
        String names = StringUtil.join(dataSources2, AbstractDataSource::getName, (String)", ");
        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification("Invalid source code of database objects", names + " must be <a href=\"introspect\">synchronized</a>", NotificationType.WARNING, (notification, event) -> {
            if (dataSources2 == null) {
                DbSrcValidator.$$$reportNull$$$0(33);
            }
            if (project == null) {
                DbSrcValidator.$$$reportNull$$$0(34);
            }
            if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            if (!event.getDescription().equals("introspect")) {
                return;
            }
            for (LocalDataSource dataSource : dataSources2) {
                DataSourceUiUtil.performManualSyncTask(LoaderContext.loadAll(project, dataSource));
            }
        }).notify(project);
    }

    public static void suggestRegenerating(final @NotNull Project project, final @NotNull List<LocalDataSource> dataSources2) {
        if (project == null) {
            DbSrcValidator.$$$reportNull$$$0(25);
        }
        if (dataSources2 == null) {
            DbSrcValidator.$$$reportNull$$$0(26);
        }
        String names = StringUtil.join(dataSources2, AbstractDataSource::getName, (String)", ");
        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification("Invalid source code of database objects", names + " must be <a href=\"regenerate\">regenerated</a>", NotificationType.WARNING, (notification, event) -> {
            if (project == null) {
                DbSrcValidator.$$$reportNull$$$0(31);
            }
            if (dataSources2 == null) {
                DbSrcValidator.$$$reportNull$$$0(32);
            }
            if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            if (!event.getDescription().equals("regenerate")) {
                return;
            }
            new Task.Backgroundable(project, "Regenerating DB Objects Source Code", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    DbSrcValidator.regenerateSources(project, dataSources2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/srcStorage/DbSrcValidator$1", "run"));
                }
            }.queue();
        }).notify(project);
    }

    public static void regenerateSources(@NotNull Project project, @NotNull List<LocalDataSource> dataSources2) {
        ProgressIndicator indicator;
        if (project == null) {
            DbSrcValidator.$$$reportNull$$$0(27);
        }
        if (dataSources2 == null) {
            DbSrcValidator.$$$reportNull$$$0(28);
        }
        if ((indicator = ProgressIndicatorProvider.getGlobalProgressIndicator()) != null) {
            indicator.setText("Regenerating DB objects source code");
        }
        for (LocalDataSource dataSource : dataSources2) {
            DbSrcValidator.regenerateSources(project, dataSource);
        }
    }

    public static void regenerateSources(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        DbSrcModelStorage modelStorage;
        if (project == null) {
            DbSrcValidator.$$$reportNull$$$0(29);
        }
        if (dataSource == null) {
            DbSrcValidator.$$$reportNull$$$0(30);
        }
        ScriptingFactory scripting = (ScriptingFactory)ServiceManager.getService(ScriptingFactory.class);
        BasicModModel model = (BasicModModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BasicModModel.class);
        DbSrcModelStorage dbSrcModelStorage = modelStorage = model == null ? null : (DbSrcModelStorage)ObjectUtils.tryCast((Object)model.getTextStorage(), DbSrcModelStorage.class);
        if (modelStorage == null) {
            return;
        }
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (indicator != null) {
            indicator.setText2("Processing " + dataSource.getName());
        }
        ScriptingService service = scripting.getScriptingService(model.getRdbms());
        DbSrcStorage storage = DbSrcStorageManager.getInstance(dataSource.isGlobal() ? null : project).getStorage(dataSource.getUniqueId(), true);
        DbImplUtil.performSrcOperation(model, TransactionGuard.getInstance().getContextTransaction(), true, () -> modelStorage.writeSession(() -> {
            for (BasicSourceAware aware : DbSrcValidator.getSources(model, null)) {
                CompositeText compositeText;
                int version = service.capabilities(aware).getCreateVersion();
                DbSrcStorageDsMetadata.MetaData metaData = storage.getMetaData(ObjectPaths.of(aware));
                if (metaData == null || metaData.genContentVersion == version || (compositeText = modelStorage.load(aware)) == null) continue;
                modelStorage.save(aware, compositeText);
            }
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcValidator";
                break;
            }
            case 2: 
            case 6: 
            case 14: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcValidator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "isValid";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemas";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSchemas";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSources";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkVersions";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "updateSchemaValidness";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "invalidate";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "suggestIntrospecting";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "suggestRegenerating";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "regenerateSources";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$suggestRegenerating$3";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$suggestIntrospecting$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Result {
        VALID,
        GENERATE,
        INTROSPECT,
        GENERATE_AND_INTROSPECT;

    }
}

