/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.ui.ParamEditorBase;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.WindowsRegistryUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalDbParamEditor
extends ParamEditorBase<ComboBox> {
    public static final String LOCAL_DB_INSTANCE = "LOCAL_DB_INSTANCE";
    public static final String LOCAL_DB_EXECUTABLE = "LOCAL_DB_EXECUTABLE";
    public static final String PLACEHOLDER = "<pipe name>";
    private static final Pattern PIPE_PATTERN = Pattern.compile("np:[\\\\][\\\\].+[\\\\]pipe[\\\\](.*)[\\\\]tsql[\\\\]query");
    private String myText;

    @NotNull
    private static Collection<String> getInstancesList(@NotNull String executable, @NotNull ProgressIndicator progress) throws ExecutionException {
        if (executable == null) {
            LocalDbParamEditor.$$$reportNull$$$0(0);
        }
        if (progress == null) {
            LocalDbParamEditor.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmpty((String)executable)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                LocalDbParamEditor.$$$reportNull$$$0(2);
            }
            return list;
        }
        CapturingProcessHandler handler = new CapturingProcessHandler(new GeneralCommandLine(new String[]{executable, "info"}));
        ProcessOutput output = handler.runProcessWithProgressIndicator(progress);
        List list = ContainerUtil.notNullize((List)(output.getExitCode() != 0 ? null : output.getStdoutLines()));
        if (list == null) {
            LocalDbParamEditor.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private static LocalDbInstance getInstance(@NotNull String executable, @NotNull String instanceName, @NotNull ProgressIndicator progress) throws ExecutionException {
        CapturingProcessHandler handler;
        ProcessOutput output;
        Matcher matcher;
        boolean matched;
        if (executable == null) {
            LocalDbParamEditor.$$$reportNull$$$0(4);
        }
        if (instanceName == null) {
            LocalDbParamEditor.$$$reportNull$$$0(5);
        }
        if (progress == null) {
            LocalDbParamEditor.$$$reportNull$$$0(6);
        }
        LocalDbInstance localDbInstance = new LocalDbInstance(instanceName, (matched = (matcher = PIPE_PATTERN.matcher((output = (handler = new CapturingProcessHandler(new GeneralCommandLine(new String[]{executable, "info", instanceName}))).runProcessWithProgressIndicator(progress)).getStdout())).find()) ? matcher.group(1) : PLACEHOLDER, matched);
        if (localDbInstance == null) {
            LocalDbParamEditor.$$$reportNull$$$0(7);
        }
        return localDbInstance;
    }

    private static Collection<LocalDbInstance> getInstances(@NotNull String executable, @NotNull ProgressIndicator progress) throws ExecutionException {
        if (executable == null) {
            LocalDbParamEditor.$$$reportNull$$$0(8);
        }
        if (progress == null) {
            LocalDbParamEditor.$$$reportNull$$$0(9);
        }
        Ref ex = Ref.create();
        ArrayList instances = ContainerUtil.newArrayList((Iterable)JBIterable.from(LocalDbParamEditor.getInstancesList(executable, progress)).filterMap(s -> {
            if (executable == null) {
                LocalDbParamEditor.$$$reportNull$$$0(19);
            }
            if (progress == null) {
                LocalDbParamEditor.$$$reportNull$$$0(20);
            }
            try {
                return LocalDbParamEditor.getInstance(executable, s, progress);
            }
            catch (ExecutionException e) {
                ex.set((Object)e);
                return null;
            }
        }));
        if (ex.get() != null) {
            throw (ExecutionException)((Object)ex.get());
        }
        return instances;
    }

    @Nullable
    public static String getPipeForInstance(@NotNull String instance, @NotNull String executable, @NotNull ProgressIndicator progress) {
        if (instance == null) {
            LocalDbParamEditor.$$$reportNull$$$0(10);
        }
        if (executable == null) {
            LocalDbParamEditor.$$$reportNull$$$0(11);
        }
        if (progress == null) {
            LocalDbParamEditor.$$$reportNull$$$0(12);
        }
        try {
            LocalDbInstance inst = (LocalDbInstance)ContainerUtil.find(LocalDbParamEditor.getInstances(executable, progress), LocalDbParamEditor.byInstance(instance));
            return inst == null ? null : inst.pipe;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public LocalDbParamEditor(@NotNull String label, @NotNull DataInterchange interchange) {
        if (label == null) {
            LocalDbParamEditor.$$$reportNull$$$0(13);
        }
        if (interchange == null) {
            LocalDbParamEditor.$$$reportNull$$$0(14);
        }
        super(new ComboBox(), interchange, TypesRegistry.ParamEditor.FieldSize.LARGE, label, new AnAction[0]);
        interchange.addPersistentProperty(LOCAL_DB_INSTANCE);
        ((ComboBox)this.getEditorComponent()).addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                LocalDbInstance inst = (LocalDbInstance)ObjectUtils.tryCast((Object)e.getItem(), LocalDbInstance.class);
                if (inst != null) {
                    LocalDbParamEditor.this.setText(LocalDbParamEditor.PLACEHOLDER);
                    LocalDbParamEditor.this.getInterchange().putProperty(LocalDbParamEditor.LOCAL_DB_INSTANCE, StringUtil.nullize((String)inst.instance));
                }
                LocalDbParamEditor.this.fireChanged();
            }
        });
        this.getInterchange().addPropertyChangeListener(LOCAL_DB_INSTANCE, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String newVal = StringUtil.notNullize((String)((String)evt.getNewValue()));
                ((ComboBox)LocalDbParamEditor.this.getEditorComponent()).setSelectedItem((Object)LocalDbParamEditor.byInstance(newVal));
            }
        }, this);
        this.getInterchange().addPropertyChangeListener(LOCAL_DB_EXECUTABLE, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LocalDbParamEditor.this.updateInstances();
            }
        }, this);
        this.myText = PLACEHOLDER;
        ((ComboBox)this.getEditorComponent()).setRenderer((ListCellRenderer)new ColoredListCellRenderer<LocalDbInstance>(){
            {
                this.setIconTextGap(0);
                this.setIpad((Insets)JBUI.emptyInsets());
            }

            protected void customizeCellRenderer(@NotNull JList list, LocalDbInstance value, int index2, boolean selected, boolean hasFocus) {
                if (list == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (value == null) {
                    return;
                }
                this.append(value.instance);
                if (!value.running) {
                    this.append(" (stopped)", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/dataSource/url/ui/LocalDbParamEditor$4", "customizeCellRenderer"));
            }
        });
        new UiNotifyConnector(this.getEditorComponent(), new Activatable(){

            public void showNotify() {
                LocalDbParamEditor.this.updateInstances();
            }

            public void hideNotify() {
            }
        });
    }

    private void updateInstances() {
        new Task.Backgroundable(this.getInterchange().getProject(), "Fetching LocalDB Instances", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    6.$$$reportNull$$$0(0);
                }
                try {
                    Collection instances = LocalDbParamEditor.getInstances(StringUtil.notNullize((String)LocalDbParamEditor.this.getInterchange().getProperty(LocalDbParamEditor.LOCAL_DB_EXECUTABLE)), indicator);
                    GuiUtils.invokeLaterIfNeeded(() -> LocalDbParamEditor.this.setInstances(instances), (ModalityState)ModalityState.defaultModalityState());
                }
                catch (ExecutionException e1) {
                    UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)this.myProject, (String)e1.getMessage(), (String)"Failed to Update LocalDB Instances"));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/url/ui/LocalDbParamEditor$6", "run"));
            }
        }.queue();
    }

    @NotNull
    private static Condition<LocalDbInstance> byInstance(@Nullable String instance) {
        Condition condition = inst -> inst.instance.equals(instance);
        if (condition == null) {
            LocalDbParamEditor.$$$reportNull$$$0(15);
        }
        return condition;
    }

    private void setInstances(@NotNull Collection<LocalDbInstance> instances) {
        if (instances == null) {
            LocalDbParamEditor.$$$reportNull$$$0(16);
        }
        ((ComboBox)this.getEditorComponent()).setModel(new DefaultComboBoxModel<Object>(ArrayUtil.toObjectArray(instances)));
        LocalDbInstance instance = (LocalDbInstance)ContainerUtil.find(instances, LocalDbParamEditor.byInstance(this.getInterchange().getProperty(LOCAL_DB_INSTANCE)));
        ((ComboBox)this.getEditorComponent()).setSelectedItem((Object)instance);
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            LocalDbParamEditor.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Override
    public void setText(@NotNull String text2) {
        if (text2 == null) {
            LocalDbParamEditor.$$$reportNull$$$0(18);
        }
        this.myText = text2;
    }

    @Override
    public void setActive(boolean active) {
        ((ComboBox)this.getEditorComponent()).setBackground(LocalDbParamEditor.getBackground(active));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/ui/LocalDbParamEditor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interchange";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instances";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/ui/LocalDbParamEditor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstancesList";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "byInstance";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstancesList";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 15: 
            case 17: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInstances";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPipeForInstance";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setInstances";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getInstances$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LocalDbExecParamEditor
    extends ParamEditorBase<JBTextField> {
        public LocalDbExecParamEditor(final @NotNull DataInterchange interchange) {
            if (interchange == null) {
                LocalDbExecParamEditor.$$$reportNull$$$0(0);
            }
            super(new JBTextField(), interchange, TypesRegistry.ParamEditor.FieldSize.LARGE, "LocalDB executable:", new AnAction[]{new ParamEditorBase.FMChooseAction(new FileChooserDescriptor(true, false, false, false, false, false).withTitle("Select LocalDB Executable"))});
            this.addButton((AnAction)new DumbAwareAction("Refresh", "Rediscover LoclaDB.exe location", AllIcons.Actions.Refresh){

                public void actionPerformed(AnActionEvent e) {
                    this.updateLocalDBPath();
                }
            });
            interchange.addPersistentProperty(LocalDbParamEditor.LOCAL_DB_EXECUTABLE);
            ((JBTextField)this.getEditorComponent()).addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    interchange.putProperty(LocalDbParamEditor.LOCAL_DB_EXECUTABLE, StringUtil.nullize((String)((JBTextField)this.getEditorComponent()).getText()));
                }
            });
            ((JBTextField)this.getEditorComponent()).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    if (!((JBTextField)this.getEditorComponent()).isFocusOwner()) {
                        interchange.putProperty(LocalDbParamEditor.LOCAL_DB_EXECUTABLE, StringUtil.nullize((String)((JBTextField)this.getEditorComponent()).getText()));
                    }
                    this.fireChanged();
                }
            });
            interchange.addPropertyChangeListener(LocalDbParamEditor.LOCAL_DB_EXECUTABLE, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!((JBTextField)this.getEditorComponent()).getText().equals(evt.getNewValue())) {
                        ((JBTextField)this.getEditorComponent()).setText(StringUtil.notNullize((String)((String)evt.getNewValue())));
                    }
                }
            }, this);
            this.updateLocalDBPath();
        }

        void updateLocalDBPath() {
            String val = this.getInterchange().getProperty(LocalDbParamEditor.LOCAL_DB_EXECUTABLE);
            boolean newVal = false;
            if (StringUtil.isEmpty((String)val)) {
                val = LocalDbExecParamEditor.detectLocalDB();
                boolean bl = newVal = !StringUtil.isEmpty((String)val);
            }
            if (newVal) {
                this.getInterchange().putProperty(LocalDbParamEditor.LOCAL_DB_EXECUTABLE, val);
            } else {
                this.getInterchange().forceUpdateProperty(LocalDbParamEditor.LOCAL_DB_EXECUTABLE);
            }
        }

        @Nullable
        private static String detectLocalDB() {
            if (SystemInfo.isWindows) {
                String LOCAL_DB_ROOT = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Microsoft SQL Server";
                for (String ver : WindowsRegistryUtil.readRegistryBranch((String)"HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Microsoft SQL Server")) {
                    File file;
                    String path = WindowsRegistryUtil.readRegistryValue((String)("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Microsoft SQL Server\\" + ver + "\\Tools\\ClientSetup"), (String)"Path");
                    if (path == null || !(file = new File(path, "SqlLocalDB.exe")).exists()) continue;
                    return file.getAbsolutePath();
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getText() {
            String string = ((JBTextField)this.getEditorComponent()).getText();
            if (string == null) {
                LocalDbExecParamEditor.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void setText(@NotNull String text2) {
            if (text2 == null) {
                LocalDbExecParamEditor.$$$reportNull$$$0(2);
            }
            ((JBTextField)this.getEditorComponent()).setText(StringUtil.nullize((String)text2));
        }

        @Override
        public void setActive(boolean active) {
            ((JBTextField)this.getEditorComponent()).setBackground(LocalDbExecParamEditor.getBackground(active));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interchange";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/ui/LocalDbParamEditor$LocalDbExecParamEditor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/ui/LocalDbParamEditor$LocalDbExecParamEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LocalDbInstance {
        public final String instance;
        public final String pipe;
        public final boolean running;

        private LocalDbInstance(String instance, String pipe, boolean running) {
            this.instance = instance;
            this.pipe = pipe;
            this.running = running;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalDbInstance instance1 = (LocalDbInstance)o;
            if (this.running != instance1.running) {
                return false;
            }
            if (!this.instance.equals(instance1.instance)) {
                return false;
            }
            return this.pipe.equals(instance1.pipe);
        }

        public int hashCode() {
            int result2 = this.instance.hashCode();
            result2 = 31 * result2 + this.pipe.hashCode();
            result2 = 31 * result2 + (this.running ? 1 : 0);
            return result2;
        }
    }
}

