/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dbimport.DatabaseImportTarget;
import com.intellij.database.dbimport.ImportHead;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.ImportTarget;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.AbstractDatabaseModifier;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class ImportDatabaseModifier
extends AbstractDatabaseModifier {
    private static final String INDICATOR_TITLE = "Importing Data...";
    private final AbstractDatabaseModifier.QueryExecutor myExecutor;

    public ImportDatabaseModifier(@NotNull DbDataSource dataSource, @NotNull ImportInfo info, @NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull ReaderTask.Input reader, @Nullable SearchPath searchPath) {
        if (dataSource == null) {
            ImportDatabaseModifier.$$$reportNull$$$0(0);
        }
        if (info == null) {
            ImportDatabaseModifier.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ImportDatabaseModifier.$$$reportNull$$$0(2);
        }
        if (dialect == null) {
            ImportDatabaseModifier.$$$reportNull$$$0(3);
        }
        if (reader == null) {
            ImportDatabaseModifier.$$$reportNull$$$0(4);
        }
        super(DGDepartment.DATA_IMPORT, dataSource, searchPath, INDICATOR_TITLE);
        this.myExecutor = new ImportQueryExecutor(project, info, dialect, (DasDataSource)dataSource, reader);
    }

    @Override
    @NotNull
    protected AbstractDatabaseModifier.QueryExecutor getExecutor() {
        AbstractDatabaseModifier.QueryExecutor queryExecutor = this.myExecutor;
        if (queryExecutor == null) {
            ImportDatabaseModifier.$$$reportNull$$$0(5);
        }
        return queryExecutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ImportDatabaseModifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ImportDatabaseModifier";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ImportQueryExecutor
    implements AbstractDatabaseModifier.QueryExecutor {
        private final ImportHead myHead;
        private final ImportManager myManager;

        ImportQueryExecutor(@NotNull Project project, @NotNull ImportInfo info, @NotNull DatabaseDialectEx dialect, @NotNull DasDataSource system, @NotNull ReaderTask.Input input) {
            if (project == null) {
                ImportQueryExecutor.$$$reportNull$$$0(0);
            }
            if (info == null) {
                ImportQueryExecutor.$$$reportNull$$$0(1);
            }
            if (dialect == null) {
                ImportQueryExecutor.$$$reportNull$$$0(2);
            }
            if (system == null) {
                ImportQueryExecutor.$$$reportNull$$$0(3);
            }
            if (input == null) {
                ImportQueryExecutor.$$$reportNull$$$0(4);
            }
            this.myManager = ImportManager.of(dialect, system.getDatabaseVersion());
            this.myHead = new ImportHead(project, info, input);
        }

        @Override
        public Promise<Void> execute(final @NotNull ProgressIndicator indicator, @NotNull DataRequest.OwnerEx owner, @NotNull DataProducer producer, final @NotNull ErrorHandler errorHandler) {
            if (indicator == null) {
                ImportQueryExecutor.$$$reportNull$$$0(5);
            }
            if (owner == null) {
                ImportQueryExecutor.$$$reportNull$$$0(6);
            }
            if (producer == null) {
                ImportQueryExecutor.$$$reportNull$$$0(7);
            }
            if (errorHandler == null) {
                ImportQueryExecutor.$$$reportNull$$$0(8);
            }
            DataRequest.RawRequest request = new DataRequest.RawRequest(owner){

                @Override
                public void processRaw(DataRequest.Context context, DatabaseConnection connection) throws Exception {
                    indicator.setText("Updating database...");
                    DatabaseImportTarget target = new DatabaseImportTarget(connection, myManager);
                    this.execute(indicator, target, errorHandler);
                }
            };
            producer.processRequest(request);
            return request.getPromise();
        }

        public boolean execute(@NotNull ProgressIndicator indicator, @NotNull ImportTarget target, @NotNull ErrorHandler errorHandler) throws Exception {
            if (indicator == null) {
                ImportQueryExecutor.$$$reportNull$$$0(9);
            }
            if (target == null) {
                ImportQueryExecutor.$$$reportNull$$$0(10);
            }
            if (errorHandler == null) {
                ImportQueryExecutor.$$$reportNull$$$0(11);
            }
            return this.myHead.start(indicator, target, errorHandler);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialect";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "system";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "producer";
                    break;
                }
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorHandler";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dbimport/ImportDatabaseModifier$ImportQueryExecutor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

