/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.dbimport.HandleErrorTask;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportSettings;
import com.intellij.database.dbimport.graph.GraphObservable;
import com.intellij.database.dbimport.ui.component.ImportComponent;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.roots.ui.componentsList.layout.VerticalStackLayout;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportSettingsComponent
implements ImportComponent<Object, Object> {
    protected static final int GAP = JBUI.scale((int)5);
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH_mm_ss");
    private static final String HANDLE_ERROR_TEXT = "Write errors to file: ";
    private static final String INSERT_AS_NULL = "Insert inconvertible values as null";
    private static final String DISABLE_STATE_TEXT = String.format("Disable %s and triggers, lock table (may be faster)", StringUtil.pluralize((String)"index"));
    protected final ImportAction.ImportEditorContext myContext;
    protected final JCheckBox myHandleErrorCheckBox;
    protected final TextFieldWithBrowseButton myErrorOutput;
    private final JCheckBox myModalityStateCheckBox;
    private final JCheckBox myInsertAsNullCheckBox;
    private final String myTableName;
    private final JPanel myPanel;

    public ImportSettingsComponent(@NotNull ImportAction.ImportEditorContext context) {
        if (context == null) {
            ImportSettingsComponent.$$$reportNull$$$0(0);
        }
        this.myContext = context;
        this.myPanel = new JPanel((LayoutManager)new VerticalStackLayout());
        this.myHandleErrorCheckBox = new JBCheckBox(HANDLE_ERROR_TEXT);
        this.myModalityStateCheckBox = new JBCheckBox(DISABLE_STATE_TEXT);
        this.myInsertAsNullCheckBox = new JBCheckBox(INSERT_AS_NULL);
        this.myErrorOutput = new TextFieldWithBrowseButton();
        this.myTableName = this.myContext.getTableName();
        this.myModalityStateCheckBox.setVisible(this.myContext.getBuilder().getImportType().isTableCreated() && this.myContext.getManager().isSupportFastMode());
        this.configureComponents();
        this.addComponents();
    }

    @Nullable
    public String getErrorOutputFilePath() {
        return this.myErrorOutput.isEnabled() ? ImportSettingsComponent.sanitize(this.myErrorOutput.getText()) : null;
    }

    protected void addComponents() {
        ImportSettingsComponent.addStrut(this.myPanel);
        JPanel errorOutputPanel = this.createErrorOutputSettingsPanel();
        this.myPanel.add(errorOutputPanel);
        ImportSettingsComponent.addStrut(this.myPanel);
        this.myPanel.add(this.myInsertAsNullCheckBox);
        ImportSettingsComponent.addStrut(this.myPanel);
        this.myPanel.add(this.myModalityStateCheckBox);
    }

    @NotNull
    protected JPanel createErrorOutputSettingsPanel() {
        JPanel errorOutputPanel = new JPanel(new BorderLayout());
        errorOutputPanel.add((Component)this.myHandleErrorCheckBox, "West");
        errorOutputPanel.add((Component)this.myErrorOutput, "Center");
        JPanel jPanel = errorOutputPanel;
        if (jPanel == null) {
            ImportSettingsComponent.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            ImportSettingsComponent.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Override
    public void build(@NotNull ImportInfo.Builder builder) {
        if (builder == null) {
            ImportSettingsComponent.$$$reportNull$$$0(3);
        }
        String path = this.getErrorOutputFilePath();
        builder.errorTaskInfo(new HandleErrorTask.ErrorTaskInfo((ThrowableComputable<Writer, IOException>)((ThrowableComputable)() -> path == null ? null : new FileWriter(path)), path)).insertAsNull(this.myInsertAsNullCheckBox.isSelected()).lockTable(this.myModalityStateCheckBox.isSelected());
    }

    @Override
    public boolean isVisible(@NotNull ImportInfo.Builder builder) {
        if (builder == null) {
            ImportSettingsComponent.$$$reportNull$$$0(4);
        }
        return true;
    }

    @Override
    public void addListener(@NotNull GraphObservable.ObserverListener<?> listener) {
        if (listener == null) {
            ImportSettingsComponent.$$$reportNull$$$0(5);
        }
    }

    @Override
    @NotNull
    public CompletionStage<Object> notifyChanged(@Nullable Object object) {
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        if (completableFuture == null) {
            ImportSettingsComponent.$$$reportNull$$$0(6);
        }
        return completableFuture;
    }

    @Override
    public boolean dependsOn(@NotNull GraphObservable.GraphObserver<?, ?> observer) {
        if (observer == null) {
            ImportSettingsComponent.$$$reportNull$$$0(7);
        }
        return false;
    }

    public static void addStrut(@NotNull JPanel panel) {
        if (panel == null) {
            ImportSettingsComponent.$$$reportNull$$$0(8);
        }
        panel.add(Box.createVerticalStrut(GAP));
    }

    protected void configureComponents() {
        boolean errors = ImportSettings.getWriteErrors();
        String directory = ImportSettings.getErrorDirectory();
        this.myErrorOutput.setEnabled(errors);
        this.myErrorOutput.setText(this.getDefaultText((String)ObjectUtils.chooseNotNull((Object)directory, (Object)SystemProperties.getUserHome())));
        this.myErrorOutput.addBrowseFolderListener(new TextBrowseFolderListener(new FileChooserDescriptor(true, true, false, false, false, false)){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (chosenFile.isDirectory()) {
                    ImportSettingsComponent.this.myErrorOutput.setText(ImportSettingsComponent.this.getDefaultText(chosenFile.getPath()));
                    return;
                }
                ImportSettingsComponent.this.myErrorOutput.setText(chosenFile.getPath());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/intellij/database/dbimport/ui/ImportSettingsComponent$1", "onFileChosen"));
            }
        });
        this.myHandleErrorCheckBox.setSelected(errors);
        this.myModalityStateCheckBox.setSelected(this.myModalityStateCheckBox.isVisible() && ImportSettings.getImportModality());
        this.myInsertAsNullCheckBox.setSelected(ImportSettings.getInsertAsNull());
        this.myHandleErrorCheckBox.addItemListener(e -> this.myErrorOutput.setEnabled(this.myHandleErrorCheckBox.isSelected()));
    }

    @NotNull
    private String getDefaultText(@NotNull String directory) {
        if (directory == null) {
            ImportSettingsComponent.$$$reportNull$$$0(9);
        }
        String string = directory + File.separator + this.myTableName + "_" + DATE_FORMAT.format(LocalDateTime.now()) + ".txt";
        if (string == null) {
            ImportSettingsComponent.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    private static String sanitize(@Nullable String path) {
        if (path == null) {
            return null;
        }
        String parent = PathUtil.getParentPath((String)path);
        String fileName = PathUtil.getFileName((String)path);
        String extension = FileUtilRt.getExtension((String)fileName);
        String nameWithoutExtension = FileUtil.getNameWithoutExtension((String)fileName);
        return parent + File.separator + FileUtil.sanitizeFileName((String)nameWithoutExtension) + (StringUtil.isEmpty((String)extension) ? "" : "." + FileUtil.sanitizeFileName((String)extension));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ui/ImportSettingsComponent";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "observer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ui/ImportSettingsComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorOutputSettingsPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyChanged";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "dependsOn";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addStrut";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

