/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagram.plan;

import com.intellij.database.diagram.plan.QueryPlanEdge;
import com.intellij.database.diagram.plan.QueryPlanNode;
import com.intellij.database.plan.PlanModel;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramRelationshipInfoAdapter;
import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import java.awt.Shape;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueryPlanDataModel
extends DiagramDataModel<PlanModel.GenericNode> {
    @Nullable
    private final PlanModel myModel;
    private final Collection<DiagramNode<PlanModel.GenericNode>> myNodes = ContainerUtil.newTroveSet();
    private final Collection<DiagramEdge<PlanModel.GenericNode>> myEdges = ContainerUtil.newTroveSet();

    public QueryPlanDataModel(Project project, PlanModel.GenericNode node, DiagramProvider<PlanModel.GenericNode> provider) {
        super(project, provider);
        this.myModel = node == null ? null : node.getModel();
    }

    @NotNull
    public Collection<DiagramNode<PlanModel.GenericNode>> getNodes() {
        Collection<DiagramNode<PlanModel.GenericNode>> collection = this.myNodes;
        if (collection == null) {
            QueryPlanDataModel.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @NotNull
    public Collection<DiagramEdge<PlanModel.GenericNode>> getEdges() {
        Collection<DiagramEdge<PlanModel.GenericNode>> collection = this.myEdges;
        if (collection == null) {
            QueryPlanDataModel.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    @NonNls
    public String getNodeName(DiagramNode<PlanModel.GenericNode> node) {
        PlanModel.GenericNode element = (PlanModel.GenericNode)node.getIdentifyingElement();
        String string = element.getFullTitle();
        if (string == null) {
            QueryPlanDataModel.$$$reportNull$$$0(2);
        }
        return string;
    }

    public DiagramNode<PlanModel.GenericNode> addElement(PlanModel.GenericNode element) {
        return null;
    }

    public void refreshDataModel() {
        this.clearAll();
        this.updateDataModel();
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        ModificationTracker modificationTracker = NEVER_CHANGED;
        if (modificationTracker == null) {
            QueryPlanDataModel.$$$reportNull$$$0(3);
        }
        return modificationTracker;
    }

    private void clearAll() {
        this.myEdges.clear();
        this.myNodes.clear();
    }

    public synchronized void updateDataModel() {
        if (this.myModel == null) {
            return;
        }
        TreeTraversal.TracingIt it = (TreeTraversal.TracingIt)((JBTreeTraverser)new JBTreeTraverser(n -> this.newChildNodes(n.getIdentifyingElement())).withRoots(this.newChildNodes(this.myModel.getRoot()))).postOrderDfsTraversal().typedIterator();
        while (it.advance()) {
            this.myNodes.add((DiagramNode<PlanModel.GenericNode>)it.current());
            QueryPlanNode parent = (QueryPlanNode)((Object)it.parent());
            if (parent == null) continue;
            this.myEdges.add(this.newEdge((QueryPlanNode)((Object)it.current()), parent));
        }
    }

    private DiagramEdge<PlanModel.GenericNode> newEdge(QueryPlanNode node, QueryPlanNode parent) {
        Double maxCoast = null;
        Double minCoast = null;
        for (PlanModel.GenericNode child : parent.getIdentifyingElement().getChildren()) {
            Double c = child.getTotalCost();
            if (c == null) continue;
            if (minCoast == null || minCoast > c) {
                minCoast = c;
            }
            if (maxCoast != null && !(maxCoast < c)) continue;
            maxCoast = c;
        }
        if (minCoast == null) {
            minCoast = 0.0;
        }
        if (maxCoast == null) {
            maxCoast = 0.0;
        }
        double d = maxCoast - minCoast;
        Double c = node.getIdentifyingElement().getTotalCost();
        final int w = d < 0.1 || c == null ? 1 : 1 + (int)Math.round((c - minCoast) * 20.0 / d);
        return new QueryPlanEdge((DiagramNode<PlanModel.GenericNode>)node, (DiagramNode<PlanModel.GenericNode>)parent, (DiagramRelationshipInfo)new DiagramRelationshipInfoAdapter("REFERENCES", DiagramLineType.SOLID){

            public Shape getStartArrow() {
                return DELTA;
            }

            public int getWidth() {
                return w;
            }
        });
    }

    @NotNull
    private JBIterable<QueryPlanNode> newChildNodes(@NotNull PlanModel.GenericNode n) {
        if (n == null) {
            QueryPlanDataModel.$$$reportNull$$$0(4);
        }
        JBIterable jBIterable = JBIterable.of((Object[])n.getChildren()).transform(this::newNode);
        if (jBIterable == null) {
            QueryPlanDataModel.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    @NotNull
    private QueryPlanNode newNode(@NotNull PlanModel.GenericNode n) {
        if (n == null) {
            QueryPlanDataModel.$$$reportNull$$$0(6);
        }
        QueryPlanNode queryPlanNode = new QueryPlanNode(n, (DiagramProvider<PlanModel.GenericNode>)this.getProvider());
        if (queryPlanNode == null) {
            QueryPlanDataModel.$$$reportNull$$$0(7);
        }
        return queryPlanNode;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/diagram/plan/QueryPlanDataModel";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/diagram/plan/QueryPlanDataModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "newChildNodes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "newNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "newChildNodes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "newNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

