/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagram.plan;

import com.intellij.database.diagram.plan.QueryPlanField;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.ui.PlanTreeNode;
import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import icons.DatabaseIcons;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueryPlanElementManager
extends AbstractDiagramElementManager<PlanModel.GenericNode> {
    @Nullable
    public PlanModel.GenericNode findInDataContext(@NotNull DataContext context) {
        PlanTreeNode node;
        TreeTableView c;
        if (context == null) {
            QueryPlanElementManager.$$$reportNull$$$0(0);
        }
        Object item = ContainerUtil.getFirstItem((List)((c = (TreeTableView)ObjectUtils.tryCast((Object)PlatformDataKeys.CONTEXT_COMPONENT.getData(context), TreeTableView.class)) == null ? null : c.getSelection()));
        if (c != null && item == null) {
            TreeTableTree tree = c.getTree();
            item = tree.getRowCount() > 0 ? tree.getPathForRow(0).getLastPathComponent() : null;
        }
        return (node = (PlanTreeNode)ObjectUtils.tryCast((Object)item, PlanTreeNode.class)) == null ? null : node.getNode();
    }

    @NotNull
    public Collection<PlanModel.GenericNode> findElementsInDataContext(@NotNull DataContext context) {
        if (context == null) {
            QueryPlanElementManager.$$$reportNull$$$0(1);
        }
        List<PlanModel.GenericNode> list = Collections.emptyList();
        if (list == null) {
            QueryPlanElementManager.$$$reportNull$$$0(2);
        }
        return list;
    }

    public boolean isAcceptableAsNode(Object element) {
        return QueryPlanElementManager.isAcceptedAsNodeImpl(element);
    }

    public static boolean isAcceptedAsNodeImpl(Object element) {
        return element instanceof PlanModel.GenericNode;
    }

    @NotNull
    public Object[] getNodeItems(@NotNull PlanModel.GenericNode node) {
        BigDecimal rows;
        String index2;
        if (node == null) {
            QueryPlanElementManager.$$$reportNull$$$0(3);
        }
        ArrayList items = ContainerUtil.newArrayList();
        if (node instanceof PlanModel.IndexScanNode && (index2 = ((PlanModel.IndexScanNode)node).getIndex()) != null) {
            items.add(new QueryPlanField(node, "Index", index2, DatabaseIcons.Index));
        }
        if ((rows = node.getPlanNumRows()) != null) {
            items.add(new QueryPlanField(node, "Rows", rows.toString(), DatabaseIcons.SqlOtherStatement));
        }
        Double startup = node.getStartupCost();
        Double total = node.getTotalCost();
        if (startup != null || total != null) {
            items.add(new QueryPlanField(node, "Cost", (startup == null ? "" : startup.toString()) + ".." + (total == null ? "" : total.toString()), DatabaseIcons.Dbms));
        }
        Object[] objectArray = items.toArray();
        if (objectArray == null) {
            QueryPlanElementManager.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    public Icon getItemIcon(Object element, DiagramState presentation) {
        return element instanceof QueryPlanField ? ((QueryPlanField)element).icon : super.getItemIcon(element, presentation);
    }

    public boolean canCollapse(PlanModel.GenericNode element) {
        return false;
    }

    public boolean isContainerFor(PlanModel.GenericNode parent, PlanModel.GenericNode child) {
        return false;
    }

    public String getElementTitle(PlanModel.GenericNode element) {
        return element.getFullTitle();
    }

    public SimpleColoredText getItemName(Object element, DiagramState presentation) {
        if (element instanceof PlanModel.GenericNode) {
            return new SimpleColoredText(((PlanModel.GenericNode)element).getFullTitle(), DEFAULT_TITLE_ATTR);
        }
        if (element instanceof QueryPlanField) {
            return new SimpleColoredText(((QueryPlanField)element).title, DEFAULT_TEXT_ATTR);
        }
        return null;
    }

    public SimpleColoredText getItemType(Object element) {
        if (element instanceof QueryPlanField) {
            String typeName = ((QueryPlanField)element).value;
            return new SimpleColoredText(StringUtil.toLowerCase((String)typeName), DEFAULT_TEXT_ATTR);
        }
        return null;
    }

    public String getNodeTooltip(PlanModel.GenericNode element) {
        return element.getRawDescription();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/diagram/plan/QueryPlanElementManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/diagram/plan/QueryPlanElementManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsInDataContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findInDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findElementsInDataContext";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNodeItems";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

