/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.AbstractDatabaseDialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.BasicMetaModel;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.clickhouse.CHouseMetaModel;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CHouseDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    @NotNull
    public static final CHouseDialect INSTANCE = new CHouseDialect();

    public CHouseDialect() {
        super(new TypeHelper.CHouseTypeHelper(), new KeywordHelper.CHouseKeywords(), Casing.create((Case)Case.EXACT, (Case)Case.EXACT));
    }

    @Override
    @NotNull
    public MetaModel getMetaModel() {
        BasicMetaModel basicMetaModel = CHouseMetaModel.MODEL;
        if (basicMetaModel == null) {
            CHouseDialect.$$$reportNull$$$0(0);
        }
        return basicMetaModel;
    }

    @NotNull
    public String getDisplayName() {
        if ("ClickHouse" == null) {
            CHouseDialect.$$$reportNull$$$0(1);
        }
        return "ClickHouse";
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.CLICKHOUSE;
        if (databaseFamilyId == null) {
            CHouseDialect.$$$reportNull$$$0(2);
        }
        return databaseFamilyId;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.ClickHouse;
        if (icon == null) {
            CHouseDialect.$$$reportNull$$$0(3);
        }
        return icon;
    }

    @Override
    public char closeQuote() {
        return '`';
    }

    @Override
    public char openQuote() {
        return '`';
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            CHouseDialect.$$$reportNull$$$0(4);
        }
        if (identifier.isEmpty() || !Character.isLetter(identifier.charAt(0)) && identifier.charAt(0) != '_') {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(5);
        }
        if (view == null) {
            CHouseDialect.$$$reportNull$$$0(6);
        }
        if (definition == null) {
            CHouseDialect.$$$reportNull$$$0(7);
        }
        if (checkOption == null) {
            CHouseDialect.$$$reportNull$$$0(8);
        }
        builder.keywords("CREATE", "VIEW").space();
        builder.qualifiedRef((DasObject)view).space();
        builder.keyword("AS").space();
        builder.plain(definition).space();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            CHouseDialect.$$$reportNull$$$0(9);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(10);
        }
        if (view == null) {
            CHouseDialect.$$$reportNull$$$0(11);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL(builder, view, cascade);
        if (ddlBuilder == null) {
            CHouseDialect.$$$reportNull$$$0(12);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String newName) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(13);
        }
        if (view == null) {
            CHouseDialect.$$$reportNull$$$0(14);
        }
        if (newName == null) {
            CHouseDialect.$$$reportNull$$$0(15);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            CHouseDialect.$$$reportNull$$$0(16);
        }
        String schema = DasUtil.getSchema((DasObject)element);
        return Pair.create((Object)("SHOW CREATE TABLE " + (schema.isEmpty() ? "" : this.quoteIdentifier(schema, false, false) + ".") + this.quoteIdentifier(element.getName(), false, false)), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return false;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            CHouseDialect.$$$reportNull$$$0(17);
        }
        throw new UnsupportedOperationException();
    }

    public boolean supportsCreateView() {
        return true;
    }

    public boolean supportsDropView() {
        return true;
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            CHouseDialect.$$$reportNull$$$0(18);
        }
        return true;
    }

    public boolean supportsRenameView() {
        return false;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    public boolean supportsAlterColumnDefault() {
        return false;
    }

    @NotNull
    public DdlBuilder sqlAppendColumnDefinition(@NotNull DdlBuilder builder, @NotNull DasColumn to) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(19);
        }
        if (to == null) {
            CHouseDialect.$$$reportNull$$$0(20);
        }
        builder.type((DasTypedObject)to);
        DialectUtils.addDefaultClauseIfNeeded(builder, to, "DEFAULT");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            CHouseDialect.$$$reportNull$$$0(21);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefinition(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to, boolean forceOutput) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(22);
        }
        if (from == null) {
            CHouseDialect.$$$reportNull$$$0(23);
        }
        if (to == null) {
            CHouseDialect.$$$reportNull$$$0(24);
        }
        boolean changedName = !CHouseDialect.isSameName(from, to);
        boolean changedDefault = !CHouseDialect.isSameDefault(from, to);
        boolean changeOther = !this.isSameType(from, to);
        changeOther |= !CHouseDialect.isSameNullability(from, to);
        changeOther |= !CHouseDialect.isSameComment(from, to);
        if (!((changeOther |= !CHouseDialect.isSameAutoInc(from, to)) || changedDefault || changedName || forceOutput)) {
            DdlBuilder ddlBuilder = builder;
            if (ddlBuilder == null) {
                CHouseDialect.$$$reportNull$$$0(25);
            }
            return ddlBuilder;
        }
        if (changedDefault && !changeOther && !changedName) {
            DdlBuilder ddlBuilder = DialectUtils.getColumnDefaultAlterOrDropSQL(builder, to);
            if (ddlBuilder == null) {
                CHouseDialect.$$$reportNull$$$0(26);
            }
            return ddlBuilder;
        }
        builder.keywords("ALTER", "TABLE").space().qualifiedRef((DasObject)from.getTable()).space();
        builder.keyword("MODIFY").space().columnRef((DasObject)from);
        this.sqlAppendColumnDefinition(builder.space(), to);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            CHouseDialect.$$$reportNull$$$0(27);
        }
        return ddlBuilder;
    }

    public boolean supportsColumnComment() {
        return false;
    }

    @Override
    public boolean supportsTableComment() {
        return false;
    }

    @Override
    public boolean supportsDropColumn() {
        return false;
    }

    public boolean supportsAlterColumnNull() {
        return false;
    }

    public boolean supportsRenameColumn() {
        return false;
    }

    public boolean supportsAlterColumnType() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropForeignKey(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasForeignKey fk, @NotNull String fkName) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(28);
        }
        if (table == null) {
            CHouseDialect.$$$reportNull$$$0(29);
        }
        if (fkName == null) {
            CHouseDialect.$$$reportNull$$$0(30);
        }
        throw new UnsupportedOperationException();
    }

    public String[] getIndexAccessMethodsTypes() {
        return null;
    }

    public String[] getIndexStorageOptions() {
        return null;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(31);
        }
        if (column2 == null) {
            CHouseDialect.$$$reportNull$$$0(32);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column2, @NotNull Set<DasColumn.Attribute> attrs) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(33);
        }
        if (column2 == null) {
            CHouseDialect.$$$reportNull$$$0(34);
        }
        if (attrs == null) {
            CHouseDialect.$$$reportNull$$$0(35);
        }
        builder.suppressQuoteConstraints(true);
        DialectUtils.getAddColumnSQL(builder, column2, true, true, true).suppressQuoteConstraints(false);
        DialectUtils.addCommentClauseIfNeeded(builder, column2, DbSqlUtil.getSqlDialect(this));
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            CHouseDialect.$$$reportNull$$$0(36);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsSystemViewDefinition() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine procedure) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(37);
        }
        if (procedure == null) {
            CHouseDialect.$$$reportNull$$$0(38);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddForeignKey(@NotNull DdlBuilder builder, @NotNull DasForeignKey keyInfo, boolean matchFull, boolean autoFKIndex) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(39);
        }
        if (keyInfo == null) {
            CHouseDialect.$$$reportNull$$$0(40);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineForeignKey(@NotNull DdlBuilder builder, DasForeignKey info, boolean matchFull) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(41);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineColumn(@NotNull DdlBuilder builder, DasColumn column2, boolean singlePk) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(42);
        }
        builder.columnRef((DasObject)column2);
        builder.space();
        builder.type((DasTypedObject)column2);
        DialectUtils.addDefaultClauseIfNeeded(builder, column2, "DEFAULT");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            CHouseDialect.$$$reportNull$$$0(43);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    protected DatabaseEditorCapabilities.TableEditorCaps getTableEditorCaps(boolean existing) {
        DatabaseEditorCapabilities.TableEditorCaps tableEditorCaps = new DatabaseEditorCapabilities.TableEditorCaps(DatabaseEditorCapabilities.Capability.UNSUPPORTED, DatabaseEditorCapabilities.Capability.UNSUPPORTED, DatabaseEditorCapabilities.ListCapability.unsupported(), DatabaseEditorCapabilities.ListCapability.unsupported(), DatabaseEditorCapabilities.ListCapability.unsupported(), DatabaseEditorCapabilities.ListCapability.unsupported(), DatabaseEditorCapabilities.ListCapability.unsupported(), DatabaseEditorCapabilities.ListCapability.unsupported(), this.getColumnEditorCaps(false), this.getColumnEditorCaps(existing), this.getKeyEditorCaps(false), this.getKeyEditorCaps(existing), this.getIndexEditorCaps(false), this.getIndexEditorCaps(existing), this.getForeignKeyEditorCaps(false), this.getForeignKeyEditorCaps(existing));
        if (tableEditorCaps == null) {
            CHouseDialect.$$$reportNull$$$0(44);
        }
        return tableEditorCaps;
    }

    @Override
    @NotNull
    protected DdlOperations getDdlOperations() {
        DdlOperations ddlOperations = new DdlOperations();
        if (ddlOperations == null) {
            CHouseDialect.$$$reportNull$$$0(45);
        }
        return ddlOperations;
    }

    @Override
    @NotNull
    protected DatabaseEditorCapabilities.ColumnEditorCaps getColumnEditorCaps(boolean existing) {
        DatabaseEditorCapabilities.ColumnEditorCaps columnEditorCaps = new DatabaseEditorCapabilities.ColumnEditorCaps(DatabaseEditorCapabilities.Capability.UNSUPPORTED, DatabaseEditorCapabilities.Capability.UNSUPPORTED, DatabaseEditorCapabilities.Capability.UNSUPPORTED, DatabaseEditorCapabilities.Capability.UNSUPPORTED, DatabaseEditorCapabilities.Capability.UNSUPPORTED, DatabaseEditorCapabilities.Capability.UNSUPPORTED);
        if (columnEditorCaps == null) {
            CHouseDialect.$$$reportNull$$$0(46);
        }
        return columnEditorCaps;
    }

    @Override
    @NotNull
    protected DatabaseEditorCapabilities.KeyEditorCaps getKeyEditorCaps(boolean existing) {
        DatabaseEditorCapabilities.KeyEditorCaps keyEditorCaps = new DatabaseEditorCapabilities.KeyEditorCaps(DatabaseEditorCapabilities.Capability.UNAVAILABLE, DatabaseEditorCapabilities.Capability.UNAVAILABLE, this.getTableKeyColumnEditorCaps());
        if (keyEditorCaps == null) {
            CHouseDialect.$$$reportNull$$$0(47);
        }
        return keyEditorCaps;
    }

    @Override
    @NotNull
    protected DatabaseEditorCapabilities.IndexEditorCaps getIndexEditorCaps(boolean existing) {
        DatabaseEditorCapabilities.IndexEditorCaps indexEditorCaps = new DatabaseEditorCapabilities.IndexEditorCaps(DatabaseEditorCapabilities.Capability.UNAVAILABLE, DatabaseEditorCapabilities.Capability.UNAVAILABLE, DatabaseEditorCapabilities.Capability.UNAVAILABLE, this.getIndexColumnEditorCaps(existing));
        if (indexEditorCaps == null) {
            CHouseDialect.$$$reportNull$$$0(48);
        }
        return indexEditorCaps;
    }

    @Override
    protected  @NotNull DatabaseEditorCapabilities.IndexColumnEditorCaps getIndexColumnEditorCaps(boolean existing) {
        DatabaseEditorCapabilities.IndexColumnEditorCaps indexColumnEditorCaps = new DatabaseEditorCapabilities.IndexColumnEditorCaps(DatabaseEditorCapabilities.Capability.UNSUPPORTED);
        if (indexColumnEditorCaps == null) {
            CHouseDialect.$$$reportNull$$$0(49);
        }
        return indexColumnEditorCaps;
    }

    @Override
    @NotNull
    protected DatabaseEditorCapabilities.ForeignKeyEditorCaps getForeignKeyEditorCaps(boolean existing) {
        DatabaseEditorCapabilities.ForeignKeyEditorCaps foreignKeyEditorCaps = new DatabaseEditorCapabilities.ForeignKeyEditorCaps(DatabaseEditorCapabilities.Capability.UNAVAILABLE, DatabaseEditorCapabilities.Capability.UNAVAILABLE, DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.Deferrability.class), DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.RuleAction.class), DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.RuleAction.class));
        if (foreignKeyEditorCaps == null) {
            CHouseDialect.$$$reportNull$$$0(50);
        }
        return foreignKeyEditorCaps;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddUniqueConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName, @NotNull List<DasColumn> columns2) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(51);
        }
        if (table == null) {
            CHouseDialect.$$$reportNull$$$0(52);
        }
        if (constraintName == null) {
            CHouseDialect.$$$reportNull$$$0(53);
        }
        if (columns2 == null) {
            CHouseDialect.$$$reportNull$$$0(54);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String restart, @NotNull String cache2, boolean cycle) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(55);
        }
        if (sequence == null) {
            CHouseDialect.$$$reportNull$$$0(56);
        }
        if (increment == null) {
            CHouseDialect.$$$reportNull$$$0(57);
        }
        if (minimum == null) {
            CHouseDialect.$$$reportNull$$$0(58);
        }
        if (maximum == null) {
            CHouseDialect.$$$reportNull$$$0(59);
        }
        if (restart == null) {
            CHouseDialect.$$$reportNull$$$0(60);
        }
        if (cache2 == null) {
            CHouseDialect.$$$reportNull$$$0(61);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateIndex(@NotNull DdlBuilder builder, @NotNull DasIndex index2, @NotNull String accessMethod, @NotNull String tablespace, @NotNull String constraints) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(62);
        }
        if (index2 == null) {
            CHouseDialect.$$$reportNull$$$0(63);
        }
        if (accessMethod == null) {
            CHouseDialect.$$$reportNull$$$0(64);
        }
        if (tablespace == null) {
            CHouseDialect.$$$reportNull$$$0(65);
        }
        if (constraints == null) {
            CHouseDialect.$$$reportNull$$$0(66);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            CHouseDialect.$$$reportNull$$$0(67);
        }
        if (dataType.jdbcType == 0) {
            String string = dataType.getSpecification();
            if (string == null) {
                CHouseDialect.$$$reportNull$$$0(68);
            }
            return string;
        }
        String typeName = dataType.typeName;
        int jdbcType = dataType.jdbcType;
        int precision = dataType.getPrecision();
        int scale = dataType.getScale();
        if ("DOUBLE".equals(typeName) && jdbcType == 8 && precision == 22 && scale == 0) {
            if ("double" == null) {
                CHouseDialect.$$$reportNull$$$0(69);
            }
            return "double";
        }
        if ("MEDIUMINT".equals(typeName) && jdbcType == 4 && precision == 7 && scale == 0) {
            if ("mediumint" == null) {
                CHouseDialect.$$$reportNull$$$0(70);
            }
            return "mediumint";
        }
        if ("MEDIUMINT UNSIGNED".equals(typeName) && jdbcType == 4 && precision == 7 && scale == 0) {
            if ("mediumint unsigned" == null) {
                CHouseDialect.$$$reportNull$$$0(71);
            }
            return "mediumint unsigned";
        }
        if ("MEDIUMBLOB".equals(typeName) && jdbcType == -4 && precision == 0xFFFFFF && scale == 0) {
            if ("mediumblob" == null) {
                CHouseDialect.$$$reportNull$$$0(72);
            }
            return "mediumblob";
        }
        if ("TINYBLOB".equals(typeName) && jdbcType == -2 && precision == 255 && scale == 0) {
            if ("tinyblob" == null) {
                CHouseDialect.$$$reportNull$$$0(73);
            }
            return "tinyblob";
        }
        if ("DATETIME".equals(typeName) && jdbcType == 93 && precision == 19 && scale == 0) {
            if ("datetime" == null) {
                CHouseDialect.$$$reportNull$$$0(74);
            }
            return "datetime";
        }
        String name = super.getTypeName(dataType);
        String unsigned = "unsigned";
        String string = StringUtil.endsWithIgnoreCase((String)typeName, (String)unsigned) && !StringUtil.endsWithIgnoreCase((String)name, (String)unsigned) ? name + " " + unsigned : name;
        if (string == null) {
            CHouseDialect.$$$reportNull$$$0(75);
        }
        return string;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String start, @NotNull String cache2, boolean cycle) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(76);
        }
        if (sequence == null) {
            CHouseDialect.$$$reportNull$$$0(77);
        }
        if (increment == null) {
            CHouseDialect.$$$reportNull$$$0(78);
        }
        if (minimum == null) {
            CHouseDialect.$$$reportNull$$$0(79);
        }
        if (maximum == null) {
            CHouseDialect.$$$reportNull$$$0(80);
        }
        if (start == null) {
            CHouseDialect.$$$reportNull$$$0(81);
        }
        if (cache2 == null) {
            CHouseDialect.$$$reportNull$$$0(82);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.create.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(83);
        }
        if (table == null) {
            CHouseDialect.$$$reportNull$$$0(84);
        }
        if (constraintName == null) {
            CHouseDialect.$$$reportNull$$$0(85);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropIndex(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasIndex index2, @NotNull String indexName, boolean cascade) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(86);
        }
        if (table == null) {
            CHouseDialect.$$$reportNull$$$0(87);
        }
        if (indexName == null) {
            CHouseDialect.$$$reportNull$$$0(88);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(89);
        }
        if (sequence == null) {
            CHouseDialect.$$$reportNull$$$0(90);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.drop.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameTable(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull String newName) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(91);
        }
        if (table == null) {
            CHouseDialect.$$$reportNull$$$0(92);
        }
        if (newName == null) {
            CHouseDialect.$$$reportNull$$$0(93);
        }
        DialectUtils.getRenameTableSQL(builder, table, newName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            CHouseDialect.$$$reportNull$$$0(94);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlSequenceInformation(@NotNull DdlBuilder builder, @NotNull DasTable sequence) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(95);
        }
        if (sequence == null) {
            CHouseDialect.$$$reportNull$$$0(96);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.sequence.information", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    public boolean supportsTableDefinition() {
        return false;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlTableDefinition(@NotNull DasObject element) {
        if (element == null) {
            CHouseDialect.$$$reportNull$$$0(97);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsTableInfo() {
        return false;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnection connection) throws Exception {
        if (element == null) {
            CHouseDialect.$$$reportNull$$$0(98);
        }
        if (connection == null) {
            CHouseDialect.$$$reportNull$$$0(99);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection) throws Exception {
        if (table == null) {
            CHouseDialect.$$$reportNull$$$0(100);
        }
        if (connection == null) {
            CHouseDialect.$$$reportNull$$$0(101);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection) throws SQLException {
        String s;
        if (system == null) {
            CHouseDialect.$$$reportNull$$$0(102);
        }
        if (connection == null) {
            CHouseDialect.$$$reportNull$$$0(103);
        }
        return StringUtil.isEmpty((String)(s = DbImplUtil.concatStringResults(connection, this, "select currentDatabase()", 1, DbImplUtil.ConcatenationProps.NO_CONCAT))) ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)s, (ObjectKind)ObjectKind.SCHEMA));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            CHouseDialect.$$$reportNull$$$0(104);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("use %s", this.quoteIdentifier(current.getDisplayName(), false, false));
    }

    public boolean supportsAccessMethods() {
        return false;
    }

    public boolean supportsAddForeignKey() {
        return false;
    }

    public boolean supportsAddUniqueConstraint() {
        return false;
    }

    public boolean supportsAlterSequence() {
        return false;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return false;
    }

    @Override
    public boolean supportsInlineAddPrimaryKey() {
        return false;
    }

    public boolean supportsCreateIndex() {
        return false;
    }

    public boolean supportsCreateSequence() {
        return false;
    }

    @Override
    public boolean supportsCreateTable() {
        return true;
    }

    @Override
    public boolean supportsDropSchema() {
        return true;
    }

    public boolean supportsDropConstraint() {
        return false;
    }

    public boolean supportsDropIndex() {
        return false;
    }

    public boolean supportsDropSequence() {
        return false;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    public boolean supportsIndexes() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    public boolean supportsMultipleRowInserts() {
        return true;
    }

    public boolean supportsRenameTable() {
        return true;
    }

    public boolean supportsSequence() {
        return false;
    }

    public boolean supportsSequenceInformation() {
        return false;
    }

    public boolean supportsTablespace() {
        return false;
    }

    public boolean supportsAddColumn() {
        return true;
    }

    @Nullable
    private static DasObject getDB(@NotNull DasObject qualifier) {
        DasObject schema;
        if (qualifier == null) {
            CHouseDialect.$$$reportNull$$$0(105);
        }
        return (schema = DasUtil.getSchemaObject((DasObject)qualifier)) != null && !StringUtil.isEmpty((String)schema.getName()) ? schema : DasUtil.getCatalogObject((DasObject)qualifier);
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            CHouseDialect.$$$reportNull$$$0(106);
        }
        if (qualifier == null) {
            CHouseDialect.$$$reportNull$$$0(107);
        }
        DasObject db = CHouseDialect.getDB(qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, db, DasUtil.getName((DasObject)db), null, null, null, null);
        if (ddlBuilder == null) {
            CHouseDialect.$$$reportNull$$$0(108);
        }
        return ddlBuilder;
    }

    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    @Override
    public boolean supportsSubSecondTimestamps() {
        return false;
    }

    @Override
    public boolean supportsRenameRoutine() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column2) throws UnsupportedOperationException {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(109);
        }
        if (column2 == null) {
            CHouseDialect.$$$reportNull$$$0(110);
        }
        builder.suppressQuoteConstraints(true);
        DdlBuilder ddlBuilder = super.sqlDropColumn(builder, column2).suppressQuoteConstraints(false);
        if (ddlBuilder == null) {
            CHouseDialect.$$$reportNull$$$0(111);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(112);
        }
        if (pk == null) {
            CHouseDialect.$$$reportNull$$$0(113);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public String getBinaryLiteralString(@NotNull byte[] binaryData) {
        if (binaryData == null) {
            CHouseDialect.$$$reportNull$$$0(114);
        }
        String string = "0x" + DialectUtils.toHexString(binaryData);
        if (string == null) {
            CHouseDialect.$$$reportNull$$$0(115);
        }
        return string;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze2) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(116);
        }
        if (statement == null) {
            CHouseDialect.$$$reportNull$$$0(117);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return true;
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnection connection) throws SQLException {
        if (connection == null) {
            CHouseDialect.$$$reportNull$$$0(118);
        }
        List<String> list = DbImplUtil.executeAndGetResult(connection, "SHOW DATABASES", DbImplUtil.RS_AS_STRING_LIST);
        if (list == null) {
            CHouseDialect.$$$reportNull$$$0(119);
        }
        return list;
    }

    @Override
    public DdlBuilder sqlAlterObjectComment(@NotNull DdlBuilder builder, @NotNull DasObject object) {
        if (builder == null) {
            CHouseDialect.$$$reportNull$$$0(120);
        }
        if (object == null) {
            CHouseDialect.$$$reportNull$$$0(121);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsCreateSchema() {
        return false;
    }

    @Override
    public boolean supportsRenameSchema() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 112: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 120: 
            case 121: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 112: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 120: 
            case 121: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/CHouseDialect";
                break;
            }
            case 4: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 5: 
            case 10: 
            case 13: 
            case 19: 
            case 22: 
            case 28: 
            case 31: 
            case 33: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 51: 
            case 55: 
            case 62: 
            case 76: 
            case 83: 
            case 86: 
            case 89: 
            case 91: 
            case 95: 
            case 109: 
            case 112: 
            case 116: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkOption";
                break;
            }
            case 15: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 16: 
            case 17: 
            case 97: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseProductVersion";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 29: 
            case 52: 
            case 84: 
            case 87: 
            case 92: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fkName";
                break;
            }
            case 32: 
            case 34: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procedure";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyInfo";
                break;
            }
            case 53: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintName";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 56: 
            case 77: 
            case 90: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 57: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "increment";
                break;
            }
            case 58: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimum";
                break;
            }
            case 59: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maximum";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restart";
                break;
            }
            case 61: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessMethod";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tablespace";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 99: 
            case 101: 
            case 103: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 105: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pk";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 112: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 120: 
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/CHouseDialect";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateView";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAppendColumnDefinition";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnDefinition";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddColumn";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineColumn";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableEditorCaps";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getDdlOperations";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnEditorCaps";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyEditorCaps";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexEditorCaps";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexColumnEditorCaps";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getForeignKeyEditorCaps";
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameTable";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropColumn";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryLiteralString";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameView";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "supportsProduct";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "sqlAppendColumnDefinition";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnDefinition";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropForeignKey";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumn";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropProcedure";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddForeignKey";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineForeignKey";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineColumn";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddUniqueConstraint";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterSequence";
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateIndex";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateSequence";
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropConstraint";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropIndex";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameTable";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceInformation";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "sqlTableDefinition";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "getDB";
                break;
            }
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropColumn";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddPrimaryKey";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterObjectComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 112: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 120: 
            case 121: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

