/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.sql.dialects.DatabaseFamilyBean;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

public class DatabaseDialects {
    @NotNull
    public static Collection<DatabaseDialectEx> getSupportedDialects() {
        TreeSet res = ContainerUtil.newTreeSet(Comparator.comparing(d -> d.getFamilyId()));
        JBIterable.of((Object[])DatabaseFamilyBean.getExtensions()).transform(b -> (DatabaseDialectEx)b.dialect.getValue()).addAllTo((Collection)res);
        TreeSet treeSet = res;
        if (treeSet == null) {
            DatabaseDialects.$$$reportNull$$$0(0);
        }
        return treeSet;
    }

    @Nullable
    public static DatabaseDialectEx findByFamily(@Nullable DatabaseFamilyId familyId) {
        DatabaseFamilyBean familyBean = DatabaseFamilyBean.findByFamilyId((DatabaseFamilyId)familyId);
        return familyBean == null ? null : (DatabaseDialectEx)familyBean.dialect.getValue();
    }

    @Nullable
    public static DatabaseDialectEx findByRdbms(@Nullable Rdbms rdbms) {
        DatabaseFamilyBean familyBean = DatabaseFamilyBean.findByRdbms((String)(rdbms == null ? null : rdbms.code));
        return familyBean == null ? null : (DatabaseDialectEx)familyBean.dialect.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/DatabaseDialects", "getSupportedDialects"));
    }
}

