/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.statements.CallableSmartStatement;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.AbstractDb2Dialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.BasicMetaModel;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.db2.Db2MetaModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.operations.db2.Db2DdlOperationsBuilder;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Db2Dialect
extends AbstractDb2Dialect
implements DatabaseDialect {
    public static final Db2Dialect INSTANCE = new Db2Dialect();
    private String myExplainPlanQuery;

    public Db2Dialect() {
        super(new TypeHelper.DB2TypeHelper(), new KeywordHelper.Db2Keywords(), Casing.create((Case)Case.UPPER, (Case)Case.EXACT));
    }

    @Override
    @NotNull
    public MetaModel getMetaModel() {
        BasicMetaModel basicMetaModel = Db2MetaModel.MODEL;
        if (basicMetaModel == null) {
            Db2Dialect.$$$reportNull$$$0(0);
        }
        return basicMetaModel;
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.DB2;
        if (databaseFamilyId == null) {
            Db2Dialect.$$$reportNull$$$0(1);
        }
        return databaseFamilyId;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.DB2;
        if (icon == null) {
            Db2Dialect.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("DB2" == null) {
            Db2Dialect.$$$reportNull$$$0(3);
        }
        return "DB2";
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            Db2Dialect.$$$reportNull$$$0(4);
        }
        return databaseProductName != null && databaseProductName.trim().startsWith("DB2");
    }

    @NotNull
    private static String sysCat(@NotNull DasObject element) {
        if (element == null) {
            Db2Dialect.$$$reportNull$$$0(5);
        }
        Object dataSource = element instanceof DbElement ? ((DbElement)element).getDataSource() : (element instanceof BasicElement ? Db2Dialect.findDataSource(element) : null);
        LocalDataSource localDataSource = dataSource == null ? null : DbImplUtil.getLocalDataSource((DasDataSource)dataSource);
        String url = localDataSource == null ? null : localDataSource.getUrl();
        boolean as400 = url != null && url.contains(":as400:");
        String string = as400 ? "SYSIBM" : "SYSCAT";
        if (string == null) {
            Db2Dialect.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static DbDataSource findDataSource(@NotNull DasObject element) {
        if (element == null) {
            Db2Dialect.$$$reportNull$$$0(7);
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            DbDataSource dataSource;
            if (project.isDefault() || !project.isOpen() || (dataSource = DbPsiFacade.getInstance((Project)project).findDataSource(element)) == null) continue;
            return dataSource;
        }
        return null;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column2, @NotNull Set<DasColumn.Attribute> attrs) throws UnsupportedOperationException {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(8);
        }
        if (column2 == null) {
            Db2Dialect.$$$reportNull$$$0(9);
        }
        if (attrs == null) {
            Db2Dialect.$$$reportNull$$$0(10);
        }
        boolean autoInc = DasUtil.isAutoGenerated((DasColumn)column2);
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)column2.getTable()).space();
        builder.keywords("ADD", "COLUMN").space();
        builder.columnRef((DasObject)column2).space();
        if (autoInc) {
            builder.type("INTEGER");
        } else {
            builder.type((DasTypedObject)column2);
        }
        DialectUtils.addDefaultClauseIfNeeded(builder, (autoInc ? "NOT NULL " : "") + "WITH DEFAULT", autoInc ? "0" : column2.getDefault());
        builder.newStatement();
        if (autoInc) {
            builder.keywords("ALTER", "TABLE").space();
            builder.qualifiedRef((DasObject)column2.getTable()).space();
            builder.keywords("ALTER", "COLUMN").space().columnRef((DasObject)column2).space().keywords("DROP", "DEFAULT").newStatement();
            builder.keywords("ALTER", "TABLE").space();
            builder.qualifiedRef((DasObject)column2.getTable()).space();
            builder.keywords("ALTER", "COLUMN").space().columnRef((DasObject)column2).space().keywords("SET");
            this.generated(builder).newStatement();
        }
        if (column2.isNotNull() && !autoInc) {
            builder.keywords("ALTER", "TABLE").space();
            builder.qualifiedRef((DasObject)column2.getTable()).space();
            builder.keywords("ADD", "CONSTRAINT").space();
            builder.columnRef((DasObject)column2).space();
            builder.keyword("CHECK").space().symbol("(");
            builder.columnRef((DasObject)column2).space();
            builder.keyword("IS NOT NULL").symbol(")");
            builder.newStatement();
        }
        if (StringUtil.isNotEmpty((String)column2.getComment())) {
            this.sqlAlterColumnComment(builder, column2);
            builder.newStatement();
        }
        Db2Dialect.reorgTable(builder, column2.getTable());
        if (autoInc) {
            builder.keyword("UPDATE").space();
            builder.qualifiedRef((DasObject)column2.getTable()).space();
            builder.keyword("SET").space();
            builder.columnRef((DasObject)column2).space().plain("=").space().keyword("DEFAULT").newStatement();
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(11);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsRenameSchema() {
        return false;
    }

    @Override
    public boolean supportsRenameDatabase() {
        return false;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection) throws SQLException {
        String s;
        if (system == null) {
            Db2Dialect.$$$reportNull$$$0(12);
        }
        if (connection == null) {
            Db2Dialect.$$$reportNull$$$0(13);
        }
        return StringUtil.isEmpty((String)(s = DbImplUtil.concatStringResults(connection, this, "values (current_schema)", 1, DbImplUtil.ConcatenationProps.LINES))) ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)s, (ObjectKind)ObjectKind.SCHEMA));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            Db2Dialect.$$$reportNull$$$0(14);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("set schema %s", current.getName());
    }

    @Override
    public boolean supportsDropType() {
        return true;
    }

    @Override
    public boolean supportsDropSchema() {
        return true;
    }

    @Override
    @Nullable
    public String getNameForKind(@NotNull ObjectKind kind) {
        if (kind == null) {
            Db2Dialect.$$$reportNull$$$0(15);
        }
        return kind == ObjectKind.PACKAGE ? "MODULE" : super.getNameForKind(kind);
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(16);
        }
        if (pk == null) {
            Db2Dialect.$$$reportNull$$$0(17);
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddPrimaryKeySQL(builder, pk, false);
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(18);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineColumn(@NotNull DdlBuilder builder, DasColumn column2, boolean singlePk) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(19);
        }
        super.sqlDefineColumn(builder, column2, singlePk);
        DdlBuilder ddlBuilder = DasUtil.isAutoGenerated((DasColumn)column2) ? this.generated(builder) : builder;
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(20);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsDropSynonym() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSchema(@NotNull DdlBuilder builder, @NotNull DasNamespace namespace) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(21);
        }
        if (namespace == null) {
            Db2Dialect.$$$reportNull$$$0(22);
        }
        DdlBuilder ddlBuilder = super.sqlDropSchema(builder, namespace).space().keyword("RESTRICT");
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(23);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder generated(@NotNull DdlBuilder builder) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(24);
        }
        DdlBuilder ddlBuilder = builder.space().keywords("GENERATED", "ALWAYS", "AS", "IDENTITY").plain("(").keywords("START", "WITH").space().literal("1").space().keywords("INCREMENT", "BY").space().literal("1").plain(")");
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(25);
        }
        return ddlBuilder;
    }

    public boolean supportsColumnComment() {
        return true;
    }

    @Override
    @NotNull
    protected DdlOperations getDdlOperations() {
        DdlOperations ddlOperations = new Db2DdlOperationsBuilder(this).build();
        if (ddlOperations == null) {
            Db2Dialect.$$$reportNull$$$0(26);
        }
        return ddlOperations;
    }

    @Override
    public boolean supportsTableComment() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnComment(@NotNull DdlBuilder builder, @NotNull DasColumn column2) throws UnsupportedOperationException {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(27);
        }
        if (column2 == null) {
            Db2Dialect.$$$reportNull$$$0(28);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnCommentAlterSQL(builder, column2, this.isCommentDroppedByNull(), DbSqlUtil.getSqlDialect(this));
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(29);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnNullable(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(30);
        }
        if (column2 == null) {
            Db2Dialect.$$$reportNull$$$0(31);
        }
        Db2Dialect.getColumnNullableAlterSQL(builder, column2, !column2.isNotNull());
        builder.newStatement();
        DdlBuilder ddlBuilder = Db2Dialect.reorgTable(builder, column2.getTable());
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(32);
        }
        return ddlBuilder;
    }

    private static DdlBuilder reorgTable(DdlBuilder builder, DasTable table) {
        builder.keyword("CALL SYSPROC").symbol(".").keyword("ADMIN_CMD").symbol("(");
        String stmt = builder.copied().plain("REORG TABLE ").qualifiedRef((DasObject)table).getStatement();
        builder.literal(DbSqlUtil.getSqlDialect(INSTANCE).asStringLiteral(stmt)).symbol(")");
        builder.newStatement();
        return builder;
    }

    @NotNull
    private static DdlBuilder getColumnNullableAlterSQL(@NotNull DdlBuilder builder, @NotNull DasColumn column2, boolean nullable) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(33);
        }
        if (column2 == null) {
            Db2Dialect.$$$reportNull$$$0(34);
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)column2.getTable()).space();
        builder.keyword("ALTER COLUMN").space();
        builder.columnRef((DasObject)column2).space();
        if (nullable) {
            builder.keywords("DROP", "NOT", "NULL");
        } else {
            builder.keywords("SET", "NOT", "NULL");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(35);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsRenameColumn() {
        return true;
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnType(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to) throws UnsupportedOperationException {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(36);
        }
        if (from == null) {
            Db2Dialect.$$$reportNull$$$0(37);
        }
        if (to == null) {
            Db2Dialect.$$$reportNull$$$0(38);
        }
        super.sqlAlterColumnType(builder, from, to);
        DdlBuilder ddlBuilder = Db2Dialect.reorgTable(builder, from.getTable());
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(39);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefault(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(40);
        }
        if (column2 == null) {
            Db2Dialect.$$$reportNull$$$0(41);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDefaultAlterOrDropSQL(builder, column2);
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(42);
        }
        return ddlBuilder;
    }

    @Override
    public String[] getIndexAccessMethodsTypes() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public String[] getIndexStorageOptions() {
        return null;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(43);
        }
        if (column2 == null) {
            Db2Dialect.$$$reportNull$$$0(44);
        }
        String tableName = column2.getTable().getName();
        String columnName = column2.getName();
        String sequenceName = tableName.toUpperCase(Locale.ENGLISH) + "_" + columnName.toUpperCase(Locale.ENGLISH) + "_SEQ";
        DdlBuilder ddlBuilder = this.sqlAddColumnAutoIncrement(builder, column2, sequenceName);
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(45);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddUniqueConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName, @NotNull List<DasColumn> columns2) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(46);
        }
        if (table == null) {
            Db2Dialect.$$$reportNull$$$0(47);
        }
        if (constraintName == null) {
            Db2Dialect.$$$reportNull$$$0(48);
        }
        if (columns2 == null) {
            Db2Dialect.$$$reportNull$$$0(49);
        }
        for (DasColumn column2 : columns2) {
            if (column2.isNotNull()) continue;
            Db2Dialect.getColumnNullableAlterSQL(builder, column2, false).newStatement();
            Db2Dialect.reorgTable(builder, table);
        }
        DialectUtils.getAddUniqueConstraintSQL(builder, table, constraint, constraintName, columns2);
        builder.newStatement();
        DdlBuilder ddlBuilder = Db2Dialect.reorgTable(builder, table);
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(50);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String restart, @NotNull String cache2, boolean cycle) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(51);
        }
        if (sequence == null) {
            Db2Dialect.$$$reportNull$$$0(52);
        }
        if (increment == null) {
            Db2Dialect.$$$reportNull$$$0(53);
        }
        if (minimum == null) {
            Db2Dialect.$$$reportNull$$$0(54);
        }
        if (maximum == null) {
            Db2Dialect.$$$reportNull$$$0(55);
        }
        if (restart == null) {
            Db2Dialect.$$$reportNull$$$0(56);
        }
        if (cache2 == null) {
            Db2Dialect.$$$reportNull$$$0(57);
        }
        DdlBuilder ddlBuilder = DialectUtils.getAlterSequenceSQL(builder, sequence, increment, minimum, maximum, restart, cache2, cycle ? "CYCLE" : "NO CYCLE");
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(58);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(59);
        }
        if (sequence == null) {
            Db2Dialect.$$$reportNull$$$0(60);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropSequenceSQL(builder, sequence, false);
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(61);
        }
        return ddlBuilder;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            Db2Dialect.$$$reportNull$$$0(62);
        }
        return Pair.create((Object)("SELECT TEXT FROM " + Db2Dialect.sysCat(element) + ".VIEWS WHERE VIEWSCHEMA = '" + DasUtil.getSchema((DasObject)element) + "' AND UPPER(VIEWNAME) = '" + element.getName().toUpperCase(Locale.ENGLISH) + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            Db2Dialect.$$$reportNull$$$0(63);
        }
        StringBuilder createViewSql = new StringBuilder();
        DasRoutine.Kind type = element.getRoutineKind();
        createViewSql.append("SELECT TEXT FROM ").append(Db2Dialect.sysCat((DasObject)element)).append(".ROUTINES").append(" WHERE ROUTINESCHEMA='");
        createViewSql.append(DasUtil.getSchema((DasObject)element));
        createViewSql.append("' AND UPPER(ROUTINENAME) = '");
        createViewSql.append(element.getName().toUpperCase(Locale.ENGLISH));
        createViewSql.append("' AND ROUTINETYPE = '");
        createViewSql.append(type == DasRoutine.Kind.FUNCTION ? "F" : "P");
        createViewSql.append("'");
        Pair pair = Pair.create((Object)createViewSql.toString(), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            Db2Dialect.$$$reportNull$$$0(64);
        }
        return pair;
    }

    @Override
    @NotNull
    public DdlBuilder sqlSequenceInformation(@NotNull DdlBuilder builder, @NotNull DasTable sequence) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(65);
        }
        if (sequence == null) {
            Db2Dialect.$$$reportNull$$$0(66);
        }
        SqlLanguageDialect language = DbSqlUtil.getSqlDialect(this);
        String schema = DasUtil.getSchema((DasObject)sequence);
        builder.keyword("SELECT").space();
        boolean first = true;
        for (String part : new String[]{"NEXTCACHEFIRSTVALUE", "MAXVALUE", "MINVALUE", "CACHE", "INCREMENT", "CYCLE"}) {
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            builder.ref(null, part);
        }
        builder.space();
        builder.keyword("FROM").space().ref(null, Db2Dialect.sysCat((DasObject)sequence) + ".SEQUENCES").space();
        builder.keyword("WHERE").space();
        if (StringUtil.isNotEmpty((String)schema)) {
            builder.ref(null, "SEQSCHEMA").space().symbol("=").space().plain("upper").symbol("(").literal(language.asStringLiteral(schema)).symbol(")").space().keyword("AND").space();
        }
        String seq = builder.copied().ref((DasObject)sequence, sequence.getName()).getStatement();
        builder.ref(null, "SEQNAME").symbol("=").space().literal(language.asStringLiteral(seq));
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(67);
        }
        return ddlBuilder;
    }

    public boolean supportsAlterSequence() {
        return true;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    public boolean supportsCreateSequence() {
        return true;
    }

    public boolean supportsDropSequence() {
        return true;
    }

    public boolean supportsSequence() {
        return true;
    }

    public boolean supportsSequenceInformation() {
        return true;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public boolean supportsInsertDefaultIntoAutoVal() {
        return true;
    }

    @Override
    public boolean supportsCreateDatabase() {
        return true;
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection) throws Exception {
        CallableStatementData data;
        CallableSmartStatement statement;
        Either token;
        if (table == null) {
            Db2Dialect.$$$reportNull$$$0(68);
        }
        if (connection == null) {
            Db2Dialect.$$$reportNull$$$0(69);
        }
        String string = (token = (statement = SmartStatements.poweredBy(connection).call()).execute(data = new StatementParameters().text(QNameUtil.getQualifiedName((DasObject)table)).parameter(2, 4).asCallData("CALL SYSPROC.DB2LK_GENERATE_DDL('-e -td ; -t ' || ?, ?)"), (ExecutionMode)StandardExecutionMode.UPDATE, StandardResultsProcessors.parameterRetriever(2))).isLeft() ? "Failed to load table definition" : StringUtil.trimEnd((String)DbImplUtil.concatStringResults(connection, this, "SELECT SQL_STMT FROM SYSTOOLS.DB2LOOK_INFO WHERE OP_TOKEN = " + token.tryGet(), 1, DbImplUtil.ConcatenationProps.NO_CONCAT), (String)";");
        if (string == null) {
            Db2Dialect.$$$reportNull$$$0(70);
        }
        return string;
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            Db2Dialect.$$$reportNull$$$0(71);
        }
        if (!Character.isLetter(identifier.charAt(0))) {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 1; i2 < len; ++i2) {
            char c = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '$' || c == '#') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    private void ensureScriptLoaded() {
        if (this.myExplainPlanQuery == null) {
            try (InputStream stream = Db2Dialect.class.getClassLoader().getResourceAsStream("resources/db2.explain_last.sql");){
                this.myExplainPlanQuery = new String(FileUtil.adaptiveLoadText((Reader)new InputStreamReader(stream, CharsetToolkit.UTF8_CHARSET)));
                return;
            }
            catch (IOException iOException) {
                this.myExplainPlanQuery = "";
            }
        }
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze2) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(72);
        }
        if (statement == null) {
            Db2Dialect.$$$reportNull$$$0(73);
        }
        this.ensureScriptLoaded();
        if (this.myExplainPlanQuery.isEmpty()) {
            throw new UnsupportedOperationException("explain_last script not found");
        }
        builder.keywords("explain", "plan").space().keyword("for").space().plain(statement).newStatement().plain(this.myExplainPlanQuery);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(74);
        }
        return ddlBuilder;
    }

    @Override
    public boolean hasRowId(@Nullable DasDataSource system) {
        String version = system == null ? null : system.getDatabaseVersion().version;
        DatabaseDialectEx.VersionParser parser = this.getVersionParser();
        Version parsed = version == null || parser == null ? null : parser.parseVersion(version);
        return parsed == null || parsed.major > 9 || parsed.major == 9 && parsed.minor > 4;
    }

    @Override
    @NotNull
    protected DdlBuilder appendRowId(@NotNull DdlBuilder builder, @Nullable DasDataSource system) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(75);
        }
        String ridCall = String.format("RID(%s) as \"RID(%s)\"", "t", "t");
        DdlBuilder ddlBuilder = builder.symbol(",").space().literal(ridCall);
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(76);
        }
        return ddlBuilder;
    }

    @Override
    @Nullable
    public DatabaseDialectEx.VersionParser getVersionParser() {
        return MyVersionParser.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 75: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 75: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/Db2Dialect";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseProductVersion";
                break;
            }
            case 5: 
            case 7: 
            case 62: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 16: 
            case 19: 
            case 21: 
            case 24: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 40: 
            case 43: 
            case 46: 
            case 51: 
            case 59: 
            case 65: 
            case 72: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: 
            case 28: 
            case 31: 
            case 34: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 13: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pk";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 47: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintName";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 52: 
            case 60: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "increment";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimum";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maximum";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restart";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/Db2Dialect";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "sysCat";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddColumn";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddPrimaryKey";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineColumn";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropSchema";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "generated";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDdlOperations";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnComment";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnNullable";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnNullableAlterSQL";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnType";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnDefault";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddUniqueConstraint";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterSequence";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropSequence";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlSequenceInformation";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlExplainPlan";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "appendRowId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "supportsProduct";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sysCat";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findDataSource";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumn";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNameForKind";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddPrimaryKey";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineColumn";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSchema";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "generated";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnComment";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnNullable";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getColumnNullableAlterSQL";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnType";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnDefault";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddUniqueConstraint";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterSequence";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceInformation";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "appendRowId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 75: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyVersionParser
    implements DatabaseDialectEx.VersionParser {
        private static final DatabaseDialectEx.VersionParser INSTANCE = new MyVersionParser();

        private MyVersionParser() {
        }

        @Override
        @Nullable
        public Version parseVersion(@NotNull String version) {
            if (version == null) {
                MyVersionParser.$$$reportNull$$$0(0);
            }
            return StringUtil.startsWith((CharSequence)version, (CharSequence)"SQL") ? MyVersionParser.parseInternal(StringUtil.replace((String)version, (String)"SQL", (String)"")) : null;
        }

        @Nullable
        private static Version parseInternal(@NotNull String version) {
            if (version == null) {
                MyVersionParser.$$$reportNull$$$0(1);
            }
            if (version.length() != 5) {
                return null;
            }
            Integer major = MyVersionParser.parseInt(version, 0);
            Integer minor = MyVersionParser.parseInt(version, 2);
            Integer bugfix = MyVersionParser.parseInt(version, 4);
            return major == null || minor == null || bugfix == null ? null : new Version(major.intValue(), minor.intValue(), bugfix.intValue());
        }

        @Nullable
        private static Integer parseInt(@NotNull String s, int begin) {
            if (s == null) {
                MyVersionParser.$$$reportNull$$$0(2);
            }
            try {
                return Integer.parseInt(s.substring(begin, Math.min(s.length(), begin + 2)));
            }
            catch (Exception exception) {
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/Db2Dialect$MyVersionParser";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseVersion";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseInternal";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseInt";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

