/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.AbstractTransactSqlDialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.BasicMetaModel;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.mssql.MsMetaModel;
import com.intellij.database.model.mssql.MsStoredColumn;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.operations.mssql.MssqlDdlOperationsBuilder;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MssqlDialect
extends AbstractTransactSqlDialect
implements DatabaseDialect {
    public static final MssqlDialect INSTANCE = new MssqlDialect();

    public MssqlDialect() {
        super(new TypeHelper.MssqlTypeHelper(), new KeywordHelper.MssqlKeywords(), Casing.create((Case)Case.MIXED, (Case)Case.MIXED));
    }

    @Override
    @NotNull
    public MetaModel getMetaModel() {
        BasicMetaModel basicMetaModel = MsMetaModel.MODEL;
        if (basicMetaModel == null) {
            MssqlDialect.$$$reportNull$$$0(0);
        }
        return basicMetaModel;
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.MSSQL;
        if (databaseFamilyId == null) {
            MssqlDialect.$$$reportNull$$$0(1);
        }
        return databaseFamilyId;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.SqlServer;
        if (icon == null) {
            MssqlDialect.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("SQL Server" == null) {
            MssqlDialect.$$$reportNull$$$0(3);
        }
        return "SQL Server";
    }

    @Override
    @NotNull
    public String getLengthFunction() {
        if ("len" == null) {
            MssqlDialect.$$$reportNull$$$0(4);
        }
        return "len";
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            MssqlDialect.$$$reportNull$$$0(5);
        }
        if (databaseProductName == null) {
            return false;
        }
        String lname = StringUtil.toLowerCase((String)databaseProductName.trim());
        return lname.startsWith("microsoft") || lname.startsWith("sql server");
    }

    @Override
    public boolean supportsInsertDefaultValues() {
        return true;
    }

    @Override
    public DdlBuilder sqlAlterObjectComment(@NotNull DdlBuilder builder, @NotNull DasObject object) {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(6);
        }
        if (object == null) {
            MssqlDialect.$$$reportNull$$$0(7);
        }
        DasObject prevObject = null;
        if (object instanceof DeObject) {
            prevObject = ((DeObject)object).editedObject;
        }
        return MssqlDialect.sqlAlterObjectComment(builder, object, prevObject, true);
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnComment(@NotNull DdlBuilder builder, @NotNull DasColumn column2) throws UnsupportedOperationException {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(8);
        }
        if (column2 == null) {
            MssqlDialect.$$$reportNull$$$0(9);
        }
        DdlBuilder ddlBuilder = this.sqlAlterObjectComment(builder, (DasObject)column2);
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(10);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column2, @NotNull Set<DasColumn.Attribute> attrs) {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(11);
        }
        if (column2 == null) {
            MssqlDialect.$$$reportNull$$$0(12);
        }
        if (attrs == null) {
            MssqlDialect.$$$reportNull$$$0(13);
        }
        super.sqlAddColumn(builder, column2, attrs).newStatement();
        if (column2.getComment() != null) {
            MssqlDialect.sqlAlterObjectComment(builder, (DasObject)column2, null, false);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(14);
        }
        return ddlBuilder;
    }

    public static DdlBuilder sqlAlterObjectComment(@NotNull DdlBuilder builder, @NotNull DasObject object, @Nullable DasObject prevObject, boolean dropFirst) {
        String comment;
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(15);
        }
        if (object == null) {
            MssqlDialect.$$$reportNull$$$0(16);
        }
        SqlLanguageDialect language = DbSqlUtil.getSqlDialect(INSTANCE);
        JBIterable<Pair<String, DasObject>> path = MssqlDialect.getExtendedPropertyPath(object);
        if (path.isEmpty() && object.getKind() != ObjectKind.DATABASE) {
            throw new UnsupportedOperationException("Comment on " + object.getKind() + " is not supported");
        }
        String prevComment = prevObject == null ? null : prevObject.getComment();
        if (Comparing.equal((String)prevComment, (String)(comment = object.getComment()))) {
            return builder;
        }
        boolean dropComment = prevComment != null && comment == null || dropFirst;
        boolean addComment = (dropComment || prevComment == null) && comment != null;
        String DESC = "'MS_Description'";
        if (dropComment) {
            if (dropFirst) {
                builder.keyword("IF").space().plain("exists").symbol("(").keyword("SELECT").space().number(1).space().keyword("FROM").space().plain("fn_listextendedproperty").symbol("(").literal(DESC);
                MssqlDialect.appendExtenderPropertyPath(builder, path);
                for (int i2 = path.size() * 2; i2 < 6; ++i2) {
                    builder.symbol(", ").literal("NULL");
                }
                builder.symbol(")").space().keyword("WHERE").space().identifier("name").symbol(" = ").literal(DESC).symbol(")").space();
            }
            builder.keyword("EXEC").space().plain("sp_dropextendedproperty").space().literal(DESC);
            MssqlDialect.appendExtenderPropertyPath(builder, path);
        }
        if (addComment) {
            if (dropComment) {
                builder.newStatement();
            }
            builder.keyword("EXEC").space().plain("sp_addextendedproperty").space().literal(DESC).symbol(", ").literal(language.asStringLiteral(comment));
            MssqlDialect.appendExtenderPropertyPath(builder, path);
        }
        if (!addComment && !dropComment) {
            builder.keyword("EXEC").space().plain("sp_updateextendedproperty").space().literal(DESC).symbol(", ").literal(language.asStringLiteral(comment));
            MssqlDialect.appendExtenderPropertyPath(builder, path);
        }
        return builder.newStatement();
    }

    @NotNull
    public static DdlBuilder appendExtenderPropertyPath(@NotNull DdlBuilder builder, @NotNull Iterable<Pair<String, DasObject>> path) {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(17);
        }
        if (path == null) {
            MssqlDialect.$$$reportNull$$$0(18);
        }
        for (Pair<String, DasObject> pair : path) {
            builder.symbol(", ").literal("'" + (String)pair.first + "'").symbol(", ").literal("'" + ((DasObject)pair.second).getName().replace("'", "''") + "'");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(19);
        }
        return ddlBuilder;
    }

    @NotNull
    public static JBIterable<Pair<String, DasObject>> getExtendedPropertyPath(@Nullable DasObject obj) {
        String type = MssqlDialect.getObjectType(obj);
        if (type == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                MssqlDialect.$$$reportNull$$$0(20);
            }
            return jBIterable;
        }
        JBIterable jBIterable = MssqlDialect.getExtendedPropertyPath(obj.getDasParent()).append((Object)Pair.create((Object)type, (Object)obj));
        if (jBIterable == null) {
            MssqlDialect.$$$reportNull$$$0(21);
        }
        return jBIterable;
    }

    @Nullable
    public static String getObjectType(@Nullable DasObject obj) {
        if (obj == null || obj.getKind() == ObjectKind.NONE) {
            return null;
        }
        if (obj.getKind() == ObjectKind.SCHEMA) {
            return "SCHEMA";
        }
        if (obj.getKind() == ObjectKind.TABLE) {
            return "TABLE";
        }
        if (obj.getKind() == ObjectKind.SYNONYM) {
            return "SYNONYM";
        }
        if (obj.getKind() == ObjectKind.ROUTINE && obj instanceof DasRoutine) {
            return ((DasRoutine)obj).getRoutineKind() == DasRoutine.Kind.FUNCTION ? "FUNCTION" : "PROCEDURE";
        }
        if (obj.getKind() == ObjectKind.VIEW) {
            return "VIEW";
        }
        if (obj.getKind() == ObjectKind.TABLE_TYPE) {
            return "TABLE_TYPE";
        }
        if (obj.getKind() == ObjectKind.COLUMN) {
            return "COLUMN";
        }
        if (obj.getKind() == ObjectKind.INDEX) {
            return "INDEX";
        }
        if (obj.getKind() == ObjectKind.TRIGGER) {
            return "TRIGGER";
        }
        if (obj.getKind() == ObjectKind.ARGUMENT) {
            return "PARAMETER";
        }
        if (obj.getKind() == ObjectKind.FOREIGN_KEY || obj.getKind() == ObjectKind.KEY || obj.getKind() == ObjectKind.CHECK) {
            return "CONSTRAINT";
        }
        return null;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(22);
        }
        if (column2 == null) {
            MssqlDialect.$$$reportNull$$$0(23);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDropSQL(builder, column2, "DROP COLUMN", false, "");
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(24);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameDatabase(@NotNull DdlBuilder builder, @NotNull DasNamespace database, @NotNull String name) {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(25);
        }
        if (database == null) {
            MssqlDialect.$$$reportNull$$$0(26);
        }
        if (name == null) {
            MssqlDialect.$$$reportNull$$$0(27);
        }
        if (!this.supportsRenameDatabase()) {
            throw new UnsupportedOperationException("Rename database is not supported");
        }
        DdlBuilder ddlBuilder = builder.keywords("ALTER", "DATABASE").space().qualifiedRef((DasObject)database).space().keywords("MODIFY", "NAME").space().symbol("=").space().identifier((DasObject)database, name);
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(28);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsDropSynonym() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTable(@NotNull DdlBuilder builder, @NotNull DasTable table, boolean cascadeConstraints, boolean isMaterializedView, @NotNull DasModel model) {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(29);
        }
        if (table == null) {
            MssqlDialect.$$$reportNull$$$0(30);
        }
        if (model == null) {
            MssqlDialect.$$$reportNull$$$0(31);
        }
        DdlBuilder ddlBuilder = DialectUtils.getTableDropSQL(builder, table, false, cascadeConstraints, false, "CASCADE", false);
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(32);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        String sqlType;
        if (dataType == null) {
            MssqlDialect.$$$reportNull$$$0(33);
        }
        if ("money".equals(sqlType = dataType.getSpecification())) {
            if ("money" == null) {
                MssqlDialect.$$$reportNull$$$0(34);
            }
            return "money";
        }
        String string = super.getTypeName(dataType);
        if (string == null) {
            MssqlDialect.$$$reportNull$$$0(35);
        }
        return string;
    }

    @Override
    @NotNull
    protected DdlOperations getDdlOperations() {
        DdlOperations ddlOperations = new MssqlDdlOperationsBuilder(this).build();
        if (ddlOperations == null) {
            MssqlDialect.$$$reportNull$$$0(36);
        }
        return ddlOperations;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(37);
        }
        if (pk == null) {
            MssqlDialect.$$$reportNull$$$0(38);
        }
        DdlBuilder typeBuilder = builder.copied();
        for (DasTypedObject column2 : pk.getColumnsRef().resolveObjects()) {
            if (column2.isNotNull()) continue;
            builder.keyword("ALTER TABLE").space().qualifiedRef((DasObject)pk.getTable()).space().keyword("ALTER COLUMN").space().columnRef((DasObject)column2).space().type(typeBuilder.clear().type(column2).getStatement()).space().keyword("NOT NULL").newStatement();
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddPrimaryKeySQL(builder, pk, false).newStatement();
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(39);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnTypeAndNullable(@NotNull DdlBuilder builder, @NotNull DasColumn column2, boolean typeChanged) {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(40);
        }
        if (column2 == null) {
            MssqlDialect.$$$reportNull$$$0(41);
        }
        if (column2.isNotNull()) {
            DdlBuilder ddlBuilder = DialectUtils.getColumnNullableAlterSQL(builder, column2, "ALTER COLUMN", true);
            if (ddlBuilder == null) {
                MssqlDialect.$$$reportNull$$$0(42);
            }
            return ddlBuilder;
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnTypeAlterSQL(builder.suppressQuoteConstraints(true), "ALTER COLUMN", "", false, column2).suppressQuoteConstraints(false);
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(43);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsTableComment() {
        return true;
    }

    @Override
    public boolean supportsColumnComment() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnName(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull String toName) {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(44);
        }
        if (from == null) {
            MssqlDialect.$$$reportNull$$$0(45);
        }
        if (toName == null) {
            MssqlDialect.$$$reportNull$$$0(46);
        }
        super.sqlAlterColumnName(builder, from, toName).symbol(",").space().literal("'COLUMN'");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(47);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefault(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(48);
        }
        if (column2 == null) {
            MssqlDialect.$$$reportNull$$$0(49);
        }
        String defaultName = MssqlDialect.getDefaultName(column2);
        if (column2.getDefault() != null) {
            if (defaultName != null) {
                MssqlDialect.dropDefault(builder, column2, defaultName).newStatement();
            }
            builder.keywords("ALTER", "TABLE").space();
            builder.qualifiedRef((DasObject)column2.getTable()).space();
            builder.keywords("ADD", "CONSTRAINT").space();
            builder.constraintRef(null, column2.getTable().getName() + "_" + column2.getName() + "_default");
            DialectUtils.addDefaultClauseIfNeeded(builder, column2, "DEFAULT");
            builder.space().keyword("FOR").space().columnRef((DasObject)column2);
        } else {
            MssqlDialect.dropDefault(builder, column2, defaultName);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(50);
        }
        return ddlBuilder;
    }

    @NotNull
    private static DdlBuilder dropDefault(@NotNull DdlBuilder builder, @NotNull DasColumn column2, String defaultName) {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(51);
        }
        if (column2 == null) {
            MssqlDialect.$$$reportNull$$$0(52);
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)column2.getTable()).space();
        builder.keywords("DROP", "CONSTRAINT").space();
        if (defaultName != null) {
            builder.identifier(defaultName);
        } else {
            builder.identifier("???");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(53);
        }
        return ddlBuilder;
    }

    @Nullable
    private static String getDefaultName(@NotNull DasColumn column2) {
        if (column2 == null) {
            MssqlDialect.$$$reportNull$$$0(54);
        }
        DasColumn tmp = column2;
        while (tmp != null) {
            if (tmp instanceof DbElement) {
                tmp = (DasObject)ObjectUtils.tryCast((Object)((DbElement)tmp).getDelegate(), DasObject.class);
                continue;
            }
            if (!(tmp instanceof DeObject)) break;
            tmp = ((DeObject)tmp).editedObject;
        }
        return tmp instanceof MsStoredColumn ? ((MsStoredColumn)tmp).getDefaultConstraintName() : null;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            MssqlDialect.$$$reportNull$$$0(55);
        }
        Pair pair = Pair.create((Object)("use [" + DasUtil.getCatalog((DasObject)element) + "]\nexec sp_helptext '" + QNameUtil.getQualifiedName(element, this) + "'"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            MssqlDialect.$$$reportNull$$$0(56);
        }
        return pair;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            MssqlDialect.$$$reportNull$$$0(57);
        }
        Pair pair = Pair.create((Object)("use [" + DasUtil.getCatalog((DasObject)element) + "]\nexec sp_helptext '" + QNameUtil.getQualifiedName((DasObject)element, this) + "'"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            MssqlDialect.$$$reportNull$$$0(58);
        }
        return pair;
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            MssqlDialect.$$$reportNull$$$0(59);
        }
        if (qualifier == null) {
            MssqlDialect.$$$reportNull$$$0(60);
        }
        boolean needQualify = this.qualify(qualifier);
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        DasObject catalog = DasUtil.getCatalogObject((DasObject)qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), (DasObject)(needQualify ? catalog : null), needQualify ? DasUtil.getName((DasObject)catalog) : null, null, null);
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(61);
        }
        return ddlBuilder;
    }

    public boolean qualify(DasObject qualifier) {
        if (!(qualifier instanceof DasTable)) {
            return false;
        }
        ObjectKind kind = qualifier.getKind();
        return kind == ObjectKind.TABLE;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnection connection) throws Exception {
        if (element == null) {
            MssqlDialect.$$$reportNull$$$0(62);
        }
        if (connection == null) {
            MssqlDialect.$$$reportNull$$$0(63);
        }
        DdlBuilder builder = new DdlBuilder().configureFor((DbElement)element);
        Map<String, Object> map = DbImplUtil.resultRowAsMap(connection, String.format("EXEC sp_spaceused '%s'", DbImplUtil.escapeStr(builder.qualifiedRef((DasObject)element).getStatement())), "rows", "rows");
        if (map == null) {
            MssqlDialect.$$$reportNull$$$0(64);
        }
        return map;
    }

    @Override
    public boolean supportsDropSchema() {
        return true;
    }

    @Override
    public boolean supportsSubSecondTimestamps() {
        return false;
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection) throws Exception {
        Serializable toCols;
        if (table == null) {
            MssqlDialect.$$$reportNull$$$0(65);
        }
        if (connection == null) {
            MssqlDialect.$$$reportNull$$$0(66);
        }
        String tableName = table.getName().replace("'", "''");
        String tableSchema = DasUtil.getSchema((DasObject)table).replace("'", "''");
        String tableCatalog = DasUtil.getCatalog((DasObject)table).replace("'", "''");
        String columns2 = String.format("SELECT * FROM INFORMATION_SCHEMA.TABLES AS T INNER JOIN     INFORMATION_SCHEMA.COLUMNS AS C ON \n                                    T.TABLE_NAME = C.TABLE_NAME                                    AND T.TABLE_SCHEMA = C.TABLE_SCHEMA                                    AND T.TABLE_CATALOG = C.TABLE_CATALOG  WHERE      T.TABLE_NAME = N'%s'  AND T.TABLE_SCHEMA = N'%s'  AND T.TABLE_CATALOG = N'%s'", tableName, tableSchema, tableCatalog);
        String pkColumnsQuery = String.format("SELECT U.COLUMN_NAME FROM  INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS C  INNER JOIN  INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE AS U ON U.CONSTRAINT_NAME = C.CONSTRAINT_NAME  WHERE C.CONSTRAINT_TYPE = 'PRIMARY KEY'  AND C.TABLE_NAME = N'%s'  AND C.TABLE_SCHEMA = N'%s'  AND C.TABLE_CATALOG = N'%s'", tableName, tableSchema, tableCatalog);
        SmartStatements statements2 = SmartStatements.poweredBy(connection);
        List<String> pkColumns = statements2.simple().noisy().execute(pkColumnsQuery, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.listOfStrings("column_name"));
        boolean isSinglePk = pkColumns.size() == 1;
        int spaces = 2;
        DdlBuilder ddl = table instanceof DbElement ? DatabaseDialogsHelper.createDdlBuilder((DbElement)table, false) : new DdlBuilder().withDialect(this);
        ddl.keywords("create", "table").space().qualifiedRef((DasObject)table).space().symbol("(");
        statements2.simple().noisy().execute(columns2, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.results((ThrowableConsumer<ResultSet, Exception>)((ThrowableConsumer)rs -> {
            boolean first = true;
            while (rs.next()) {
                if (first) {
                    first = false;
                } else {
                    ddl.symbol(",");
                }
                String name = JdbcUtil.getStringSafe((ResultSet)rs, (String)"column_name", null);
                String defaults = JdbcUtil.getStringSafe((ResultSet)rs, (String)"column_default", null);
                String type = JdbcUtil.getStringSafe((ResultSet)rs, (String)"data_type", null);
                String length = JdbcUtil.getStringSafe((ResultSet)rs, (String)"character_maximum_length", null);
                String precision = JdbcUtil.getStringSafe((ResultSet)rs, (String)"numeric_precision", null);
                String scale = JdbcUtil.getStringSafe((ResultSet)rs, (String)"numeric_scale", null);
                String isNullableStr = JdbcUtil.getStringSafe((ResultSet)rs, (String)"is_nullable", null);
                boolean isNotNull = "NO".equals(isNullableStr);
                length = MssqlDialect.isMax(type, length) ? String.valueOf(Integer.MAX_VALUE) : length;
                String substitution = this.getTypeWithSubstitution(type != null ? type : "<type>", StringUtil.parseInt((String)length, (int)-1), StringUtil.parseInt((String)precision, (int)-1), StringUtil.parseInt((String)scale, (int)-1));
                ddl.newLine().space(spaces).columnRef(name != null ? name : "<name>").space().type(substitution);
                if (isSinglePk && ((String)pkColumns.iterator().next()).equals(name)) {
                    ddl.space().keywords("primary", "key");
                }
                if (defaults != null) {
                    ddl.space().keywords("default").space().literal(defaults);
                }
                if (!isNotNull) continue;
                ddl.space().keywords("not", "null");
            }
        })));
        if (pkColumns.size() > 1) {
            ddl.symbol(",").newLine().space(spaces).keywords("primary", "key").space().symbol("(");
            boolean f = true;
            for (String string : pkColumns) {
                if (f) {
                    f = false;
                } else {
                    ddl.symbol(",").space();
                }
                ddl.identifier(string);
            }
            ddl.symbol(")");
        }
        String fkQuery = String.format("SELECT C.CONSTRAINT_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS C WHERE      C.CONSTRAINT_TYPE = 'FOREIGN KEY'  AND C.TABLE_NAME = N'%s'  AND C.TABLE_SCHEMA = N'%s'  AND C.TABLE_CATALOG = N'%s'", tableName, tableSchema, tableCatalog);
        List fkNames = statements2.simple().noisy().execute(fkQuery, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.resultsTransformer(rs -> {
            List result2 = ContainerUtil.newSmartList();
            while (rs.next()) {
                result2.add(rs.getString("constraint_name"));
            }
            return result2;
        }, ContainerUtil.emptyList()));
        for (String fkName : fkNames) {
            String fkCols = String.format("SELECT\n    U.COLUMN_NAME AS FROM_COL,    K.TABLE_NAME,    K.COLUMN_NAME  FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS C   INNER JOIN INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE AS U ON U.CONSTRAINT_NAME = C.CONSTRAINT_NAME  INNER JOIN INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS R ON R.CONSTRAINT_NAME = C.CONSTRAINT_NAME  INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE K ON K.CONSTRAINT_NAME = R.UNIQUE_CONSTRAINT_NAME  WHERE C.CONSTRAINT_NAME = '%s'", fkName);
            LinkedHashSet fromCols = ContainerUtil.newLinkedHashSet();
            toCols = ContainerUtil.newLinkedHashSet();
            String refTableName = "<ref_table>";
            try (ClosableResultsProducer producer = statements2.simple().noisy().execute(fkCols, StandardExecutionMode.QUERY);){
                ResultSet rs2;
                ResultSet resultSet = rs2 = producer.advance() ? producer.processCurrent(StandardResultsProcessors.RESULT_SET) : null;
                if (rs2 != null) {
                    while (rs2.next()) {
                        refTableName = rs2.getString("table_name");
                        ContainerUtil.addIfNotNull((Collection)fromCols, (Object)rs2.getString("from_col"));
                        ContainerUtil.addIfNotNull((Collection)((Object)toCols), (Object)rs2.getString("column_name"));
                    }
                }
            }
            ddl.symbol(",").newLine().space(spaces).keywords("foreign", "key").space().symbol("(");
            DialectUtils.appendStringList(ddl, fromCols);
            ddl.symbol(")");
            ddl.space().keyword("references").space().identifier(refTableName).space().symbol("(");
            DialectUtils.appendStringList(ddl, (Iterable<String>)((Object)toCols));
            ddl.symbol(")");
        }
        ddl.newLine().symbol(")").symbol(";");
        String string = String.format("select  ind.name as index_name,  t.name as table_name,  col.name as col_name,  ind.is_unique from sys.indexes ind  inner join sys.index_columns ic on ind.object_id = ic.object_id and ind.index_id = ic.index_id  inner join sys.columns col on ic.object_id = col.object_id and ic.column_id = col.column_id  inner join sys.tables t on ind.object_id = t.object_id where ind.is_primary_key = 0 and t.is_ms_shipped = 0  and t.name = N'%s'", tableName);
        MultiMap indexColumns = new MultiMap();
        HashMap<String, Boolean> indexUnique = new HashMap<String, Boolean>();
        ClosableResultsProducer producer = statements2.simple().noisy().execute(string, StandardExecutionMode.QUERY);
        toCols = null;
        try {
            ResultSet rs3;
            ResultSet resultSet = rs3 = producer.advance() ? producer.processCurrent(StandardResultsProcessors.RESULT_SET) : null;
            if (rs3 != null) {
                while (rs3.next()) {
                    String indexName = rs3.getString("index_name");
                    String columnName = rs3.getString("col_name");
                    boolean isUnique = rs3.getBoolean("is_unique");
                    indexColumns.putValue((Object)indexName, (Object)columnName);
                    indexUnique.put(indexName, isUnique);
                }
            }
        }
        catch (Throwable rs3) {
            toCols = rs3;
            throw rs3;
        }
        finally {
            if (producer != null) {
                if (toCols != null) {
                    try {
                        producer.close();
                    }
                    catch (Throwable rs3) {
                        ((Throwable)toCols).addSuppressed(rs3);
                    }
                } else {
                    producer.close();
                }
            }
        }
        for (String i2 : indexColumns.keySet()) {
            Collection colNames = indexColumns.get((Object)i2);
            Boolean isUnique = (Boolean)indexUnique.get(i2);
            ddl.newLine().keywords("create").space();
            if (isUnique.booleanValue()) {
                ddl.keyword("unique").space();
            }
            ddl.keyword("index").space().identifier(i2).space().keyword("on").space().identifier(tableName).space().symbol("(");
            boolean first = true;
            for (String col : colNames) {
                if (first) {
                    first = false;
                } else {
                    ddl.symbol(",").space();
                }
                ddl.identifier(col);
            }
            ddl.symbol(")").symbol(";");
        }
        String string2 = ddl.getStatement();
        if (string2 == null) {
            MssqlDialect.$$$reportNull$$$0(67);
        }
        return string2;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze2) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(68);
        }
        if (statement == null) {
            MssqlDialect.$$$reportNull$$$0(69);
        }
        builder.keywords("set", "showplan_text", "on").newStatement();
        builder.keywords("go").newLine();
        if (!analyze2) {
            builder.keywords("set", "noexec", "on").newStatement();
        }
        builder.plain(statement).newStatement();
        if (!analyze2) {
            builder.keywords("set", "noexec", "off").newStatement();
        }
        builder.keywords("go").newLine();
        builder.keywords("set", "showplan_text", "off").newStatement();
        builder.keywords("go").newLine();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(70);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlPostExplainPlan(@NotNull DdlBuilder builder, boolean analyze2) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(71);
        }
        if (!analyze2) {
            builder.keywords("set", "noexec", "off").newStatement();
        }
        builder.keywords("go").newLine();
        builder.keywords("set", "showplan_text", "off").newStatement();
        builder.keywords("go").newLine();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(72);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnection connection) throws SQLException {
        if (connection == null) {
            MssqlDialect.$$$reportNull$$$0(73);
        }
        List<String> list = DbImplUtil.executeAndGetResult(connection, "SELECT [name] FROM sys.databases d WHERE d.database_id > 4", DbImplUtil.RS_AS_STRING_LIST);
        if (list == null) {
            MssqlDialect.$$$reportNull$$$0(74);
        }
        return list;
    }

    private static boolean isMax(@Nullable String type, @Nullable String length) {
        return type != null && length != null && StringUtil.equals((CharSequence)"-1", (CharSequence)length) && !MssqlDialect.isLargeType(type);
    }

    private static boolean isLargeType(@Nullable String type) {
        return StringUtil.findIgnoreCase((String)type, (String[])new String[]{"xml", "image", "text", "ntext"});
    }

    @Override
    public boolean hasRowId(@Nullable DasDataSource system) {
        if (system == null) {
            return false;
        }
        String productVersion = system.getDatabaseVersion().version;
        return productVersion != null && DataSourceUiUtil.isMsSql2008(productVersion);
    }

    @Override
    @NotNull
    protected DdlBuilder appendRowId(@NotNull DdlBuilder builder, @Nullable DasDataSource system) {
        if (builder == null) {
            MssqlDialect.$$$reportNull$$$0(75);
        }
        DdlBuilder ddlBuilder = builder.symbol(",").space().literal("%%physloc%% as \"%%physloc%%\"");
        if (ddlBuilder == null) {
            MssqlDialect.$$$reportNull$$$0(76);
        }
        return ddlBuilder;
    }

    @Override
    @Nullable
    public DatabaseDialectEx.VersionParser getVersionParser() {
        return Version::parseVersion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 73: 
            case 75: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 73: 
            case 75: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/MssqlDialect";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseProductVersion";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 17: 
            case 22: 
            case 25: 
            case 29: 
            case 37: 
            case 40: 
            case 44: 
            case 48: 
            case 51: 
            case 68: 
            case 71: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 9: 
            case 12: 
            case 23: 
            case 41: 
            case 49: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "database";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 30: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pk";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toName";
                break;
            }
            case 55: 
            case 57: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 63: 
            case 66: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLengthFunction";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 73: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/MssqlDialect";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnComment";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddColumn";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "appendExtenderPropertyPath";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendedPropertyPath";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropColumn";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameDatabase";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropTable";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getDdlOperations";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddPrimaryKey";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnTypeAndNullable";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnName";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnDefault";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "dropDefault";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlViewDefinition";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlExplainPlan";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlPostExplainPlan";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "appendRowId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "supportsProduct";
                break;
            }
            case 6: 
            case 7: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterObjectComment";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnComment";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumn";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "appendExtenderPropertyPath";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropColumn";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameDatabase";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropTable";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddPrimaryKey";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnTypeAndNullable";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnName";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnDefault";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "dropDefault";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultName";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "sqlPostExplainPlan";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "appendRowId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 73: 
            case 75: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

