/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.AbstractDatabaseDialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.BasicMetaModel;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.mysql.MysqlMetaModel;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.operations.mysql.MysqlDdlOperationsBuilder;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.containers.ContainerUtil;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysqlDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    @NotNull
    public static final MysqlDialect INSTANCE = new MysqlDialect();

    public MysqlDialect() {
        super(new TypeHelper.MySQLTypeHelper(), new KeywordHelper.MysqlKeywords(), Casing.create((Case)Case.LOWER, (Case)Case.LOWER));
    }

    @Override
    @NotNull
    public MetaModel getMetaModel() {
        BasicMetaModel basicMetaModel = MysqlMetaModel.MODEL;
        if (basicMetaModel == null) {
            MysqlDialect.$$$reportNull$$$0(0);
        }
        return basicMetaModel;
    }

    @NotNull
    public String getDisplayName() {
        if ("MySQL" == null) {
            MysqlDialect.$$$reportNull$$$0(1);
        }
        return "MySQL";
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.MYSQL;
        if (databaseFamilyId == null) {
            MysqlDialect.$$$reportNull$$$0(2);
        }
        return databaseFamilyId;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.Mysql;
        if (icon == null) {
            MysqlDialect.$$$reportNull$$$0(3);
        }
        return icon;
    }

    @Override
    public char closeQuote() {
        return '`';
    }

    @Override
    public char openQuote() {
        return '`';
    }

    @Override
    @Nullable
    public String getNameForKind(@NotNull ObjectKind kind) {
        if (kind == null) {
            MysqlDialect.$$$reportNull$$$0(4);
        }
        return kind == ObjectKind.SCHEDULED_EVENT ? "EVENT" : super.getNameForKind(kind);
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            MysqlDialect.$$$reportNull$$$0(5);
        }
        if (identifier.isEmpty() || !Character.isLetter(identifier.charAt(0))) {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '$' || i2 > 0 && c == '#') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(6);
        }
        if (view == null) {
            MysqlDialect.$$$reportNull$$$0(7);
        }
        if (definition == null) {
            MysqlDialect.$$$reportNull$$$0(8);
        }
        if (checkOption == null) {
            MysqlDialect.$$$reportNull$$$0(9);
        }
        builder.keywords("CREATE", "OR", "REPLACE", "VIEW").space();
        builder.qualifiedRef((DasObject)view).space();
        builder.keyword("AS").space();
        builder.plain(definition).space();
        if (!"".isEmpty()) {
            builder.keyword("WITH").space();
            builder.keyword("CHECK OPTION");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(10);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(11);
        }
        if (view == null) {
            MysqlDialect.$$$reportNull$$$0(12);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL(builder, view, cascade);
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(13);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String newName) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(14);
        }
        if (view == null) {
            MysqlDialect.$$$reportNull$$$0(15);
        }
        if (newName == null) {
            MysqlDialect.$$$reportNull$$$0(16);
        }
        DdlBuilder.Marker mark2 = builder.mark();
        builder.keywords("RENAME", "TABLE").space().qualifiedRef((DasObject)view).space().keyword("TO").space().qualifiedRefOpt((DasObject)view, newName);
        mark2.replace(DialectUtils.stripQuotesFromIdentifier(this, newName, mark2.extract()));
        mark2.finish();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(17);
        }
        return ddlBuilder;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            MysqlDialect.$$$reportNull$$$0(18);
        }
        return Pair.create((Object)("SELECT view_definition FROM information_schema.views WHERE table_name = '" + element.getName() + "' AND table_schema = '" + MysqlDialect.getDBName(element) + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            MysqlDialect.$$$reportNull$$$0(19);
        }
        Pair pair = Pair.create((Object)("SELECT routine_definition FROM information_schema.routines WHERE routine_name = '" + element.getName() + "' AND routine_schema = '" + MysqlDialect.getDBName((DasObject)element) + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            MysqlDialect.$$$reportNull$$$0(20);
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadProcedureDefinition(@NotNull DasRoutine procedure, @NotNull DatabaseConnection connection) throws Exception {
        if (procedure == null) {
            MysqlDialect.$$$reportNull$$$0(21);
        }
        if (connection == null) {
            MysqlDialect.$$$reportNull$$$0(22);
        }
        String type = procedure.getRoutineKind().name();
        String query = new DdlBuilder().withDialect(this).qualifyReferences(true).keywords("SHOW", "CREATE", type).space().qualifiedRef((DasObject)procedure).getStatement();
        String string = SmartStatements.poweredBy(connection).simple().noisy().execute(query, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.resultsTransformer(rs -> {
            if (procedure == null) {
                MysqlDialect.$$$reportNull$$$0(144);
            }
            if (!rs.next()) {
                return "-- failed to load definition";
            }
            DdlBuilder builder = new DdlBuilder().withDialect(this).qualifyReferences(true).splitStatements(true);
            this.sqlDropProcedure(builder, procedure).newStatement().plain(rs.getString(3));
            return DialectUtils.sqlConcat(builder.getStatements());
        }, ""));
        if (string == null) {
            MysqlDialect.$$$reportNull$$$0(23);
        }
        return string;
    }

    public boolean supportsCreateView() {
        return true;
    }

    public boolean supportsDropView() {
        return true;
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            MysqlDialect.$$$reportNull$$$0(24);
        }
        if (databaseProductName == null || !databaseProductName.trim().toLowerCase(Locale.ENGLISH).startsWith("mysql")) {
            return false;
        }
        return databaseProductVersion.startsWith("5");
    }

    public boolean supportsRenameView() {
        return true;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    public boolean supportsCheckOptionsForViews() {
        return true;
    }

    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @NotNull
    public DdlBuilder sqlAppendColumnDefinition(@NotNull DdlBuilder builder, @NotNull DasColumn to) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(25);
        }
        if (to == null) {
            MysqlDialect.$$$reportNull$$$0(26);
        }
        builder.type((DasTypedObject)to);
        DialectUtils.addNullabilityClause(builder, to, false);
        Set attr = ContainerUtil.notNullize(to.getTable() == null ? null : to.getTable().getColumnAttrs(to));
        if (attr.contains(DasColumn.Attribute.AUTO_GENERATED)) {
            builder.space().keyword("auto_increment");
        }
        DialectUtils.addDefaultClauseIfNeeded(builder, to, "DEFAULT");
        DialectUtils.addCommentClauseIfNeeded(builder, to, DbSqlUtil.getSqlDialect(this));
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(27);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefinition(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to, boolean forceOutput) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(28);
        }
        if (from == null) {
            MysqlDialect.$$$reportNull$$$0(29);
        }
        if (to == null) {
            MysqlDialect.$$$reportNull$$$0(30);
        }
        boolean changedName = !MysqlDialect.isSameName(from, to);
        boolean changedDefault = !MysqlDialect.isSameDefault(from, to);
        boolean changeOther = !this.isSameType(from, to);
        changeOther |= !MysqlDialect.isSameNullability(from, to);
        changeOther |= !MysqlDialect.isSameComment(from, to);
        if (!((changeOther |= !MysqlDialect.isSameAutoInc(from, to)) || changedDefault || changedName || forceOutput)) {
            DdlBuilder ddlBuilder = builder;
            if (ddlBuilder == null) {
                MysqlDialect.$$$reportNull$$$0(31);
            }
            return ddlBuilder;
        }
        if (changedDefault && !changeOther && !changedName) {
            DdlBuilder ddlBuilder = DialectUtils.getColumnDefaultAlterOrDropSQL(builder, to);
            if (ddlBuilder == null) {
                MysqlDialect.$$$reportNull$$$0(32);
            }
            return ddlBuilder;
        }
        builder.keywords("ALTER", "TABLE").space().qualifiedRef((DasObject)from.getTable()).space();
        if (!changedName) {
            builder.keyword("MODIFY").space().columnRef((DasObject)from);
        } else {
            builder.keyword("CHANGE").space().columnRef((DasObject)from).space().columnRef((DasObject)to);
        }
        this.sqlAppendColumnDefinition(builder.space(), to);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(33);
        }
        return ddlBuilder;
    }

    public boolean supportsColumnComment() {
        return true;
    }

    @Override
    public boolean supportsTableComment() {
        return true;
    }

    @Override
    public boolean supportsDropColumn() {
        return true;
    }

    public boolean supportsAlterColumnNull() {
        return true;
    }

    public boolean supportsRenameColumn() {
        return true;
    }

    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropForeignKey(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasForeignKey fk, @NotNull String fkName) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(34);
        }
        if (table == null) {
            MysqlDialect.$$$reportNull$$$0(35);
        }
        if (fkName == null) {
            MysqlDialect.$$$reportNull$$$0(36);
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)table).space();
        builder.keywords("DROP", "FOREIGN", "KEY").space();
        builder.constraintRef((DasObject)fk, fkName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(37);
        }
        return ddlBuilder;
    }

    public String[] getIndexAccessMethodsTypes() {
        return new String[]{"UNIQUE", "FULLTEXT", "SPATIAL"};
    }

    public String[] getIndexStorageOptions() {
        return new String[]{"BTREE", "HASH"};
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(38);
        }
        if (column2 == null) {
            MysqlDialect.$$$reportNull$$$0(39);
        }
        DdlBuilder.Marker m = builder.mark();
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)column2.getTable());
        builder.space().keyword("MODIFY").space();
        builder.columnRef((DasObject)column2).space();
        builder.keywords("BIGINT", "NOT", "NULL", "AUTO_INCREMENT", "PRIMARY", "KEY");
        m.replace(DialectUtils.stripQuotesFromIdentifier(this, column2.getName(), m.extract()));
        m.finish();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(40);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column2, @NotNull Set<DasColumn.Attribute> attrs) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(41);
        }
        if (column2 == null) {
            MysqlDialect.$$$reportNull$$$0(42);
        }
        if (attrs == null) {
            MysqlDialect.$$$reportNull$$$0(43);
        }
        builder.suppressQuoteConstraints(true);
        DialectUtils.getAddColumnSQL(builder, column2, true, true, true).suppressQuoteConstraints(false);
        DialectUtils.addCommentClauseIfNeeded(builder, column2, DbSqlUtil.getSqlDialect(this));
        if (attrs.contains(DasColumn.Attribute.AUTO_GENERATED)) {
            builder.space().keywords("PRIMARY", "KEY", "AUTO_INCREMENT");
        } else if (attrs.contains(DasColumn.Attribute.PRIMARY_KEY)) {
            builder.space().keywords("PRIMARY", "KEY");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(44);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineColumn(@NotNull DdlBuilder builder, DasColumn column2, boolean singlePk) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(45);
        }
        super.sqlDefineColumn(builder, column2, singlePk);
        DialectUtils.addCommentClauseIfNeeded(builder, column2, DbSqlUtil.getSqlDialect(this));
        DdlBuilder ddlBuilder = DasUtil.isAutoGenerated((DasColumn)column2) ? builder.space().keyword("AUTO_INCREMENT") : builder;
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(46);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsSystemViewDefinition() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine procedure) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(47);
        }
        if (procedure == null) {
            MysqlDialect.$$$reportNull$$$0(48);
        }
        DdlBuilder ddlBuilder = DialectUtils.sqlDropProcedure(builder, procedure, true);
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(49);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddForeignKey(@NotNull DdlBuilder builder, @NotNull DasForeignKey keyInfo, boolean matchFull, boolean autoFKIndex) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(50);
        }
        if (keyInfo == null) {
            MysqlDialect.$$$reportNull$$$0(51);
        }
        builder.suppressQuoteConstraints(true);
        DdlBuilder ddlBuilder = DialectUtils.getAddForeignKeyConstraintSQL(builder, keyInfo, false, autoFKIndex, this).suppressQuoteConstraints(false);
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(52);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineForeignKey(@NotNull DdlBuilder builder, DasForeignKey info, boolean matchFull) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(53);
        }
        DdlBuilder ddlBuilder = DialectUtils.foreignKeyTail(builder, info, DasForeignKey.Deferrability.NOT_DEFERRABLE, false, null, null);
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(54);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    protected DdlOperations getDdlOperations() {
        DdlOperations ddlOperations = new MysqlDdlOperationsBuilder(this).build();
        if (ddlOperations == null) {
            MysqlDialect.$$$reportNull$$$0(55);
        }
        return ddlOperations;
    }

    @Override
    @NotNull
    protected DatabaseEditorCapabilities.TableEditorCaps getTableEditorCaps(boolean existing) {
        DatabaseEditorCapabilities.TableEditorCaps tableEditorCaps = new DatabaseEditorCapabilities.TableEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || this.supportsRenameTable()), DatabaseEditorCapabilities.Capability.supported(this.supportsTableComment()), DatabaseEditorCapabilities.ListCapability.get(true, true, !existing || this.supportsAddColumn(), !existing || this.supportsDropColumn()), DatabaseEditorCapabilities.ListCapability.get(this.supportsIndexes(), false, !existing || this.supportsCreateIndex(), !existing || this.supportsDropIndex()), DatabaseEditorCapabilities.ListCapability.get(true, false, !existing || this.supportsAddForeignKey(), !existing || this.supportsDropForeignKey()), DatabaseEditorCapabilities.ListCapability.get(true, false, !existing || this.supportsAddPrimaryKey(), !existing || this.supportsDropPrimaryKey()), DatabaseEditorCapabilities.ListCapability.get(true, false, !existing || this.supportsAddUniqueConstraint(), !existing || this.supportsDropConstraint()), DatabaseEditorCapabilities.ListCapability.get(true, false, !existing || this.supportsAddUniqueConstraint(), !existing || this.supportsDropConstraint()), this.getColumnEditorCaps(false), this.getColumnEditorCaps(existing), this.getKeyEditorCaps(false), this.getKeyEditorCaps(existing), this.getIndexEditorCaps(false), this.getIndexEditorCaps(existing), this.getForeignKeyEditorCaps(false), this.getForeignKeyEditorCaps(existing));
        if (tableEditorCaps == null) {
            MysqlDialect.$$$reportNull$$$0(56);
        }
        return tableEditorCaps;
    }

    @Override
    @NotNull
    protected DatabaseEditorCapabilities.ForeignKeyEditorCaps getForeignKeyEditorCaps(boolean existing) {
        boolean fkRecreateable = this.supportsAddForeignKey() && this.supportsDropForeignKey();
        DatabaseEditorCapabilities.ForeignKeyEditorCaps foreignKeyEditorCaps = new DatabaseEditorCapabilities.ForeignKeyEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || fkRecreateable), DatabaseEditorCapabilities.Capability.UNAVAILABLE, DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.Deferrability.class), DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.RuleAction.values()), DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.RuleAction.values()));
        if (foreignKeyEditorCaps == null) {
            MysqlDialect.$$$reportNull$$$0(57);
        }
        return foreignKeyEditorCaps;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddUniqueConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName, @NotNull List<DasColumn> columns2) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(58);
        }
        if (table == null) {
            MysqlDialect.$$$reportNull$$$0(59);
        }
        if (constraintName == null) {
            MysqlDialect.$$$reportNull$$$0(60);
        }
        if (columns2 == null) {
            MysqlDialect.$$$reportNull$$$0(61);
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)table);
        builder.space().keyword("ADD").space();
        if (!constraintName.isEmpty()) {
            builder.keyword("CONSTRAINT").space().constraintRef(constraint, constraintName).space();
        }
        builder.keyword("UNIQUE").space();
        builder.symbol("(");
        DialectUtils.appendColumnList(builder, columns2);
        builder.symbol(")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(62);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String restart, @NotNull String cache2, boolean cycle) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(63);
        }
        if (sequence == null) {
            MysqlDialect.$$$reportNull$$$0(64);
        }
        if (increment == null) {
            MysqlDialect.$$$reportNull$$$0(65);
        }
        if (minimum == null) {
            MysqlDialect.$$$reportNull$$$0(66);
        }
        if (maximum == null) {
            MysqlDialect.$$$reportNull$$$0(67);
        }
        if (restart == null) {
            MysqlDialect.$$$reportNull$$$0(68);
        }
        if (cache2 == null) {
            MysqlDialect.$$$reportNull$$$0(69);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.alter.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateIndex(@NotNull DdlBuilder builder, @NotNull DasIndex index2, @NotNull String accessMethod, @NotNull String tablespace, @NotNull String constraints) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(70);
        }
        if (index2 == null) {
            MysqlDialect.$$$reportNull$$$0(71);
        }
        if (accessMethod == null) {
            MysqlDialect.$$$reportNull$$$0(72);
        }
        if (tablespace == null) {
            MysqlDialect.$$$reportNull$$$0(73);
        }
        if (constraints == null) {
            MysqlDialect.$$$reportNull$$$0(74);
        }
        builder.keyword("CREATE").space();
        if (!accessMethod.isEmpty() && !accessMethod.toLowerCase(Locale.ENGLISH).equals("default")) {
            builder.keyword(accessMethod).space();
        } else if (index2.isUnique()) {
            builder.keyword("UNIQUE").space();
        }
        builder.keyword("INDEX").space();
        builder.identifier(index2.getName()).space();
        builder.keyword("ON").space();
        builder.qualifiedRef((DasObject)index2.getTable()).space();
        DialectUtils.columnList(builder, index2);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(75);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            MysqlDialect.$$$reportNull$$$0(76);
        }
        if (dataType.jdbcType == 0) {
            String string = dataType.getSpecification();
            if (string == null) {
                MysqlDialect.$$$reportNull$$$0(77);
            }
            return string;
        }
        String typeName = dataType.typeName;
        int jdbcType = dataType.jdbcType;
        int precision = dataType.getPrecision();
        int scale = dataType.getScale();
        if ("DOUBLE".equals(typeName) && jdbcType == 8 && precision == 22 && scale == 0) {
            if ("double" == null) {
                MysqlDialect.$$$reportNull$$$0(78);
            }
            return "double";
        }
        if ("MEDIUMINT".equals(typeName) && jdbcType == 4 && precision == 7 && scale == 0) {
            if ("mediumint" == null) {
                MysqlDialect.$$$reportNull$$$0(79);
            }
            return "mediumint";
        }
        if ("MEDIUMINT UNSIGNED".equals(typeName) && jdbcType == 4 && precision == 7 && scale == 0) {
            if ("mediumint unsigned" == null) {
                MysqlDialect.$$$reportNull$$$0(80);
            }
            return "mediumint unsigned";
        }
        if ("MEDIUMBLOB".equals(typeName) && jdbcType == -4 && precision == 0xFFFFFF && scale == 0) {
            if ("mediumblob" == null) {
                MysqlDialect.$$$reportNull$$$0(81);
            }
            return "mediumblob";
        }
        if ("TINYBLOB".equals(typeName) && jdbcType == -2 && precision == 255 && scale == 0) {
            if ("tinyblob" == null) {
                MysqlDialect.$$$reportNull$$$0(82);
            }
            return "tinyblob";
        }
        if ("DATETIME".equals(typeName) && jdbcType == 93 && precision == 19 && scale == 0) {
            if ("datetime" == null) {
                MysqlDialect.$$$reportNull$$$0(83);
            }
            return "datetime";
        }
        String name = super.getTypeName(dataType);
        String unsigned = "unsigned";
        String string = StringUtil.endsWithIgnoreCase((String)typeName, (String)unsigned) && !StringUtil.endsWithIgnoreCase((String)name, (String)unsigned) ? name + " " + unsigned : name;
        if (string == null) {
            MysqlDialect.$$$reportNull$$$0(84);
        }
        return string;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String start, @NotNull String cache2, boolean cycle) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(85);
        }
        if (sequence == null) {
            MysqlDialect.$$$reportNull$$$0(86);
        }
        if (increment == null) {
            MysqlDialect.$$$reportNull$$$0(87);
        }
        if (minimum == null) {
            MysqlDialect.$$$reportNull$$$0(88);
        }
        if (maximum == null) {
            MysqlDialect.$$$reportNull$$$0(89);
        }
        if (start == null) {
            MysqlDialect.$$$reportNull$$$0(90);
        }
        if (cache2 == null) {
            MysqlDialect.$$$reportNull$$$0(91);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.create.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(92);
        }
        if (table == null) {
            MysqlDialect.$$$reportNull$$$0(93);
        }
        if (constraintName == null) {
            MysqlDialect.$$$reportNull$$$0(94);
        }
        DdlBuilder ddlBuilder = MysqlDialect.sqlDropIndexImpl(builder, table, constraint, constraintName, false);
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(95);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropIndex(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasIndex index2, @NotNull String indexName, boolean cascade) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(96);
        }
        if (table == null) {
            MysqlDialect.$$$reportNull$$$0(97);
        }
        if (indexName == null) {
            MysqlDialect.$$$reportNull$$$0(98);
        }
        DdlBuilder ddlBuilder = MysqlDialect.sqlDropIndexImpl(builder, table, (DasObject)index2, indexName, cascade);
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(99);
        }
        return ddlBuilder;
    }

    @NotNull
    private static DdlBuilder sqlDropIndexImpl(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject index2, @NotNull String indexName, boolean cascade) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(100);
        }
        if (table == null) {
            MysqlDialect.$$$reportNull$$$0(101);
        }
        if (indexName == null) {
            MysqlDialect.$$$reportNull$$$0(102);
        }
        builder.keyword("DROP").space().keyword("INDEX");
        builder.space();
        builder.pushDefaultSchema(ObjectPaths.of((DasObject)DasUtil.getNamespace((DasObject)table)));
        builder.qualifiedRefOpt(index2, (DasObject)table, indexName).popDefaultSchema();
        builder.space().keyword("ON").space().qualifiedRef((DasObject)table);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(103);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(104);
        }
        if (sequence == null) {
            MysqlDialect.$$$reportNull$$$0(105);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.drop.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameTable(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull String newName) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(106);
        }
        if (table == null) {
            MysqlDialect.$$$reportNull$$$0(107);
        }
        if (newName == null) {
            MysqlDialect.$$$reportNull$$$0(108);
        }
        DialectUtils.getRenameTableSQL(builder, table, newName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(109);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlSequenceInformation(@NotNull DdlBuilder builder, @NotNull DasTable sequence) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(110);
        }
        if (sequence == null) {
            MysqlDialect.$$$reportNull$$$0(111);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.sequence.information", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlTableDefinition(@NotNull DasObject element) {
        if (element == null) {
            MysqlDialect.$$$reportNull$$$0(112);
        }
        DdlBuilder builder = new DdlBuilder().withDialect(this).qualifyReferences(true);
        Pair pair = Pair.create((Object)("SHOW CREATE TABLE " + builder.qualifiedRef(element).getStatement()), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            MysqlDialect.$$$reportNull$$$0(113);
        }
        return pair;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnection connection) throws Exception {
        if (element == null) {
            MysqlDialect.$$$reportNull$$$0(114);
        }
        if (connection == null) {
            MysqlDialect.$$$reportNull$$$0(115);
        }
        Map<String, Object> map = DbImplUtil.resultRowAsMap(connection, String.format("show table status from `%s` like '%s'", MysqlDialect.getDBName((DasObject)element), DbImplUtil.escapeStr(element.getName())), "TABLE_ROWS", "rows", "ENGINE", "engine", "TABLE_COLLATION", "collation", "CREATE_TIME", "created");
        if (map == null) {
            MysqlDialect.$$$reportNull$$$0(116);
        }
        return map;
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection) throws Exception {
        if (table == null) {
            MysqlDialect.$$$reportNull$$$0(117);
        }
        if (connection == null) {
            MysqlDialect.$$$reportNull$$$0(118);
        }
        Pair<String, DbImplUtil.ConcatenationProps> pair = this.sqlTableDefinition((DasObject)table);
        String string = DbImplUtil.concatStringResults(connection, this, (String)pair.first, 2, (DbImplUtil.ConcatenationProps)pair.second);
        if (string == null) {
            MysqlDialect.$$$reportNull$$$0(119);
        }
        return string;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection) throws SQLException {
        String s;
        if (system == null) {
            MysqlDialect.$$$reportNull$$$0(120);
        }
        if (connection == null) {
            MysqlDialect.$$$reportNull$$$0(121);
        }
        return StringUtil.isEmpty((String)(s = DbImplUtil.concatStringResults(connection, this, "select database()", 1, DbImplUtil.ConcatenationProps.NO_CONCAT))) ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)s, (ObjectKind)ObjectKind.SCHEMA));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            MysqlDialect.$$$reportNull$$$0(122);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("use %s", this.quoteIdentifier(current.getDisplayName(), false, false));
    }

    public boolean supportsAccessMethods() {
        return true;
    }

    public boolean supportsAddForeignKey() {
        return true;
    }

    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    public boolean supportsAlterSequence() {
        return false;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    @Override
    public boolean supportsInlineAddPrimaryKey() {
        return true;
    }

    public boolean supportsCreateIndex() {
        return true;
    }

    public boolean supportsCreateSequence() {
        return false;
    }

    @Override
    public boolean supportsCreateTable() {
        return true;
    }

    @Override
    public boolean supportsDropSchema() {
        return true;
    }

    public boolean supportsDropConstraint() {
        return true;
    }

    public boolean supportsDropIndex() {
        return true;
    }

    public boolean supportsDropSequence() {
        return false;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    public boolean supportsIndexes() {
        return true;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    public boolean supportsMultipleRowInserts() {
        return true;
    }

    public boolean supportsRenameTable() {
        return true;
    }

    public boolean supportsSequence() {
        return false;
    }

    public boolean supportsSequenceInformation() {
        return false;
    }

    public boolean supportsTablespace() {
        return true;
    }

    public boolean supportsAddColumn() {
        return true;
    }

    @NotNull
    private static String getDBName(@NotNull DasObject qualifier) {
        if (qualifier == null) {
            MysqlDialect.$$$reportNull$$$0(123);
        }
        String string = DasUtil.getName((DasObject)MysqlDialect.getDB(qualifier));
        if (string == null) {
            MysqlDialect.$$$reportNull$$$0(124);
        }
        return string;
    }

    @Nullable
    private static DasObject getDB(@NotNull DasObject qualifier) {
        DasObject schema;
        if (qualifier == null) {
            MysqlDialect.$$$reportNull$$$0(125);
        }
        return (schema = DasUtil.getSchemaObject((DasObject)qualifier)) != null && !StringUtil.isEmpty((String)schema.getName()) ? schema : DasUtil.getCatalogObject((DasObject)qualifier);
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            MysqlDialect.$$$reportNull$$$0(126);
        }
        if (qualifier == null) {
            MysqlDialect.$$$reportNull$$$0(127);
        }
        DasObject db = MysqlDialect.getDB(qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, db, DasUtil.getName((DasObject)db), null, null, null, null);
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(128);
        }
        return ddlBuilder;
    }

    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    @Override
    public boolean supportsSubSecondTimestamps() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column2) throws UnsupportedOperationException {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(129);
        }
        if (column2 == null) {
            MysqlDialect.$$$reportNull$$$0(130);
        }
        builder.suppressQuoteConstraints(true);
        DdlBuilder ddlBuilder = super.sqlDropColumn(builder, column2).suppressQuoteConstraints(false);
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(131);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(132);
        }
        if (pk == null) {
            MysqlDialect.$$$reportNull$$$0(133);
        }
        builder.suppressQuoteConstraints(true);
        builder.keyword("ALTER").space().keyword("TABLE").space();
        builder.qualifiedRef((DasObject)pk.getTable());
        builder.space().keywords("ADD", "PRIMARY", "KEY").space();
        DialectUtils.columnList(builder, (DasConstraint)pk);
        DdlBuilder ddlBuilder = builder.suppressQuoteConstraints(false);
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(134);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String getBinaryLiteralString(@NotNull byte[] binaryData) {
        if (binaryData == null) {
            MysqlDialect.$$$reportNull$$$0(135);
        }
        String string = "0x" + DialectUtils.toHexString(binaryData);
        if (string == null) {
            MysqlDialect.$$$reportNull$$$0(136);
        }
        return string;
    }

    public boolean supportsCommonTableExpression() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze2) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(137);
        }
        if (statement == null) {
            MysqlDialect.$$$reportNull$$$0(138);
        }
        if (analyze2) {
            throw new UnsupportedOperationException("MYSQL does not support EXPLAIN ANALYZE");
        }
        builder.keywords("explain", "extended").space();
        builder.plain(statement);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            MysqlDialect.$$$reportNull$$$0(139);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return true;
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnection connection) throws SQLException {
        if (connection == null) {
            MysqlDialect.$$$reportNull$$$0(140);
        }
        List<String> list = DbImplUtil.executeAndGetResult(connection, "SHOW DATABASES", DbImplUtil.RS_AS_STRING_LIST);
        if (list == null) {
            MysqlDialect.$$$reportNull$$$0(141);
        }
        return list;
    }

    @Override
    public DdlBuilder sqlAlterObjectComment(@NotNull DdlBuilder builder, @NotNull DasObject object) {
        if (builder == null) {
            MysqlDialect.$$$reportNull$$$0(142);
        }
        if (object == null) {
            MysqlDialect.$$$reportNull$$$0(143);
        }
        if (object.getKind() == ObjectKind.TABLE) {
            SqlLanguageDialect language = DbSqlUtil.getSqlDialect(this);
            builder.keywords("ALTER", "TABLE").space().qualifiedRef(object).space().keyword("COMMENT").space().symbol("=").space().literal(language.asStringLiteral(StringUtil.notNullize((String)object.getComment())));
            return builder;
        }
        return super.sqlAlterObjectComment(builder, object);
    }

    @Override
    public boolean supportsRenameSchema() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 127: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 137: 
            case 138: 
            case 140: 
            case 142: 
            case 143: 
            case 144: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 127: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 137: 
            case 138: 
            case 140: 
            case 142: 
            case 143: 
            case 144: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/MysqlDialect";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 5: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 6: 
            case 11: 
            case 14: 
            case 25: 
            case 28: 
            case 34: 
            case 38: 
            case 41: 
            case 45: 
            case 47: 
            case 50: 
            case 53: 
            case 58: 
            case 63: 
            case 70: 
            case 85: 
            case 92: 
            case 96: 
            case 100: 
            case 104: 
            case 106: 
            case 110: 
            case 129: 
            case 132: 
            case 137: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkOption";
                break;
            }
            case 16: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 18: 
            case 19: 
            case 112: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: 
            case 48: 
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procedure";
                break;
            }
            case 22: 
            case 115: 
            case 118: 
            case 121: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseProductVersion";
                break;
            }
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 35: 
            case 59: 
            case 93: 
            case 97: 
            case 101: 
            case 107: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fkName";
                break;
            }
            case 39: 
            case 42: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyInfo";
                break;
            }
            case 60: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintName";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 64: 
            case 86: 
            case 105: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 65: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "increment";
                break;
            }
            case 66: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimum";
                break;
            }
            case 67: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maximum";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restart";
                break;
            }
            case 69: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessMethod";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tablespace";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 98: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 123: 
            case 125: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pk";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 127: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 137: 
            case 138: 
            case 140: 
            case 142: 
            case 143: 
            case 144: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/MysqlDialect";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateView";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameView";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadProcedureDefinition";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAppendColumnDefinition";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnDefinition";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropForeignKey";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddColumn";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineColumn";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropProcedure";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddForeignKey";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineForeignKey";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getDdlOperations";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableEditorCaps";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getForeignKeyEditorCaps";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddUniqueConstraint";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateIndex";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropConstraint";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropIndex";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropIndexImpl";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameTable";
                break;
            }
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlTableDefinition";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "getDBName";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropColumn";
                break;
            }
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddPrimaryKey";
                break;
            }
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryLiteralString";
                break;
            }
            case 139: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlExplainPlan";
                break;
            }
            case 141: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNameForKind";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameView";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadProcedureDefinition";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "supportsProduct";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "sqlAppendColumnDefinition";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnDefinition";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropForeignKey";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumn";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineColumn";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropProcedure";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddForeignKey";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineForeignKey";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddUniqueConstraint";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterSequence";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateIndex";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateSequence";
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropConstraint";
                break;
            }
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropIndex";
                break;
            }
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropIndexImpl";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameTable";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceInformation";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "sqlTableDefinition";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "getDBName";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "getDB";
                break;
            }
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropColumn";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddPrimaryKey";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 137: 
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
            case 142: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterObjectComment";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "lambda$tryToLoadProcedureDefinition$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 127: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 137: 
            case 138: 
            case 140: 
            case 142: 
            case 143: 
            case 144: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

