/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.AbstractDatabaseDialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasCluster;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.MetaModelImpl;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.oracle.OraMetaModel;
import com.intellij.database.model.oracle.OraModModel;
import com.intellij.database.model.oracle.OraModRoot;
import com.intellij.database.model.oracle.OraModSchema;
import com.intellij.database.model.oracle.OraModTable;
import com.intellij.database.model.oracle.OraModTableColumn;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.operations.oracle.OracleDdlOperationsBuilder;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.swing.Icon;
import javax.xml.bind.DatatypeConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Oracle;

public class OracleDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    public static final OracleDialect INSTANCE = new OracleDialect();

    protected OracleDialect() {
        super(new TypeHelper.OracleTypeHelper(), new KeywordHelper.OracleKeywords(), Casing.create((Case)Case.UPPER, (Case)Case.EXACT));
    }

    @Override
    @NotNull
    public MetaModel getMetaModel() {
        MetaModel metaModel = OraMetaModelExt.META_MODEL;
        if (metaModel == null) {
            OracleDialect.$$$reportNull$$$0(0);
        }
        return metaModel;
    }

    @Override
    public boolean supportsColumnCommentsInTableDefinition() {
        return false;
    }

    @Override
    @NotNull
    protected DdlOperations getDdlOperations() {
        DdlOperations ddlOperations = new OracleDdlOperationsBuilder(this).build();
        if (ddlOperations == null) {
            OracleDialect.$$$reportNull$$$0(1);
        }
        return ddlOperations;
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.ORACLE;
        if (databaseFamilyId == null) {
            OracleDialect.$$$reportNull$$$0(2);
        }
        return databaseFamilyId;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.Oracle;
        if (icon == null) {
            OracleDialect.$$$reportNull$$$0(3);
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("Oracle" == null) {
            OracleDialect.$$$reportNull$$$0(4);
        }
        return "Oracle";
    }

    @Override
    public int getJavaTypeForNativeType(@NotNull String nativeColumnTypeName) {
        if (nativeColumnTypeName == null) {
            OracleDialect.$$$reportNull$$$0(5);
        }
        if (nativeColumnTypeName.toLowerCase(Locale.ENGLISH).equals("nvarchar2")) {
            return -9;
        }
        if (nativeColumnTypeName.toLowerCase(Locale.ENGLISH).equals("nchar")) {
            return -15;
        }
        if (nativeColumnTypeName.toLowerCase(Locale.ENGLISH).equals("nclob")) {
            return 2011;
        }
        if (nativeColumnTypeName.toLowerCase(Locale.ENGLISH).startsWith("TIMESTAMP")) {
            return 93;
        }
        return super.getJavaTypeForNativeType(nativeColumnTypeName);
    }

    @Override
    public boolean supportsSynonymDefinition() {
        return true;
    }

    @Override
    protected void sqlParameter(@NotNull DdlBuilder builder, DasArgument parameter, boolean longMode) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(6);
        }
        DialectUtils.sqlParameter(builder, parameter, longMode, 1, true);
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSynonymDefinition(@NotNull DasObject element) {
        if (element == null) {
            OracleDialect.$$$reportNull$$$0(7);
        }
        Pair pair = Pair.create((Object)("select dbms_metadata.get_ddl('SYNONYM', '" + element.getName() + "', '" + DasUtil.getSchema((DasObject)element) + "') from dual"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            OracleDialect.$$$reportNull$$$0(8);
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadSynonymDefinition(DasTable table, DatabaseConnection connection) throws Exception {
        Pair<String, DbImplUtil.ConcatenationProps> pair = this.sqlSynonymDefinition((DasObject)table);
        String string = DbImplUtil.concatStringResults(connection, this, (String)pair.first, 1, (DbImplUtil.ConcatenationProps)pair.second);
        if (string == null) {
            OracleDialect.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlTableDefinition(@NotNull DasObject element) {
        if (element == null) {
            OracleDialect.$$$reportNull$$$0(10);
        }
        Pair pair = Pair.create((Object)("select dbms_metadata.get_ddl('TABLE', '" + element.getName() + "', '" + DasUtil.getSchema((DasObject)element) + "') from dual"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            OracleDialect.$$$reportNull$$$0(11);
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection) throws Exception {
        if (table == null) {
            OracleDialect.$$$reportNull$$$0(12);
        }
        if (connection == null) {
            OracleDialect.$$$reportNull$$$0(13);
        }
        Pair<String, DbImplUtil.ConcatenationProps> pair = this.sqlTableDefinition((DasObject)table);
        String string = DbImplUtil.concatStringResults(connection, this, (String)pair.first, 1, (DbImplUtil.ConcatenationProps)pair.second);
        if (string == null) {
            OracleDialect.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnection connection) throws Exception {
        if (element == null) {
            OracleDialect.$$$reportNull$$$0(15);
        }
        if (connection == null) {
            OracleDialect.$$$reportNull$$$0(16);
        }
        Map<String, Object> map = DbImplUtil.resultRowAsMap(connection, String.format("SELECT NUM_ROWS as \"rows\",  TABLESPACE_NAME as \"tablespace\",  LAST_ANALYZED as \"analyzed on\" FROM SYS.all_tables WHERE owner LIKE '%s' ESCAPE '#' AND table_name LIKE '%s' ESCAPE '#'", DbImplUtil.escapeSql(DasUtil.getSchema((DasObject)element), true, this), DbImplUtil.escapeSql(element.getName(), true, this)), new String[0]);
        if (map == null) {
            OracleDialect.$$$reportNull$$$0(17);
        }
        return map;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection) throws SQLException {
        String s;
        if (system == null) {
            OracleDialect.$$$reportNull$$$0(18);
        }
        if (connection == null) {
            OracleDialect.$$$reportNull$$$0(19);
        }
        return StringUtil.isEmpty((String)(s = DbImplUtil.concatStringResults(connection, this, "select sys_context('userenv', 'current_schema') x from dual", 1, DbImplUtil.ConcatenationProps.NO_CONCAT))) ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)s, (ObjectKind)ObjectKind.SCHEMA));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            OracleDialect.$$$reportNull$$$0(20);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("alter session set current_schema = %s", this.quoteIdentifier(current.getName(), false, false));
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            OracleDialect.$$$reportNull$$$0(21);
        }
        if (databaseProductName == null) {
            return false;
        }
        return databaseProductName.trim().toLowerCase(Locale.ENGLISH).startsWith("oracle");
    }

    public boolean supportsColumnComment() {
        return true;
    }

    @Override
    public boolean supportsTableComment() {
        return true;
    }

    @NotNull
    public DdlBuilder sqlAlterColumnComment(@NotNull DdlBuilder builder, @NotNull DasColumn column2) throws UnsupportedOperationException {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(22);
        }
        if (column2 == null) {
            OracleDialect.$$$reportNull$$$0(23);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnCommentAlterSQL(builder, column2, this.isCommentDroppedByNull(), DbSqlUtil.getSqlDialect(this));
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(24);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsDropColumn() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(25);
        }
        if (column2 == null) {
            OracleDialect.$$$reportNull$$$0(26);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDropSQL(builder, column2, "DROP COLUMN", false, "");
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(27);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTable(@NotNull DdlBuilder builder, @NotNull DasTable table, boolean cascadeConstraints, boolean isMaterializedView, @NotNull DasModel model) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(28);
        }
        if (table == null) {
            OracleDialect.$$$reportNull$$$0(29);
        }
        if (model == null) {
            OracleDialect.$$$reportNull$$$0(30);
        }
        String cascadeClause = "";
        if (!isMaterializedView) {
            cascadeClause = "CASCADE CONSTRAINTS";
        }
        DdlBuilder ddlBuilder = DialectUtils.getTableDropSQL(builder, table, true, cascadeConstraints, true, cascadeClause, isMaterializedView);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(31);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            OracleDialect.$$$reportNull$$$0(32);
        }
        if (dataType.jdbcType == 0) {
            String string = dataType.getSpecification();
            if (string == null) {
                OracleDialect.$$$reportNull$$$0(33);
            }
            return string;
        }
        String typeName = dataType.typeName;
        int jdbcType = dataType.jdbcType;
        int precision = dataType.getPrecision();
        int scale = dataType.getScale();
        if ("NUMBER".equals(typeName)) {
            String string = "number" + (precision == 0 && scale == -127 ? "" : "(" + precision + (scale == 0 ? "" : ", " + scale) + ")");
            if (string == null) {
                OracleDialect.$$$reportNull$$$0(34);
            }
            return string;
        }
        if ("LONG".equals(typeName) && jdbcType == -1 && precision == 0 && scale == 0) {
            if ("long" == null) {
                OracleDialect.$$$reportNull$$$0(35);
            }
            return "long";
        }
        if ("DATE".equals(typeName) && jdbcType == 93 && precision == 7 && scale == 0) {
            if ("date" == null) {
                OracleDialect.$$$reportNull$$$0(36);
            }
            return "date";
        }
        if ("ROWID".equals(typeName) && jdbcType == 1111 && precision == 10 && scale == 0) {
            if ("rowid" == null) {
                OracleDialect.$$$reportNull$$$0(37);
            }
            return "rowid";
        }
        if ("UROWID".equals(typeName) && jdbcType == 1111 && precision == 4000 && scale == 0) {
            if ("urowid" == null) {
                OracleDialect.$$$reportNull$$$0(38);
            }
            return "urowid";
        }
        String string = super.getTypeName(dataType);
        if (string == null) {
            OracleDialect.$$$reportNull$$$0(39);
        }
        return string;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(40);
        }
        if (pk == null) {
            OracleDialect.$$$reportNull$$$0(41);
        }
        builder.keyword("ALTER TABLE").space();
        DasTable table = pk.getTable();
        builder.qualifiedRef((DasObject)table).space();
        builder.keyword("ADD").space();
        String pkName = pk.getName();
        if (StringUtil.isNotEmpty((String)pkName) && !"PRIMARY".equalsIgnoreCase(pkName)) {
            builder.keyword("CONSTRAINT").space().constraintRef((DasObject)pk).space();
        }
        builder.keywords("PRIMARY", "KEY").space();
        DialectUtils.columnList(builder, (MultiRef<? extends DasTypedObject>)pk.getColumnsRef());
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(42);
        }
        return ddlBuilder;
    }

    public boolean supportsRenameColumn() {
        return true;
    }

    @NotNull
    public DdlBuilder sqlAlterColumnName(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull String toName) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(43);
        }
        if (from == null) {
            OracleDialect.$$$reportNull$$$0(44);
        }
        if (toName == null) {
            OracleDialect.$$$reportNull$$$0(45);
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)from.getTable()).space();
        builder.keywords("RENAME", "COLUMN").space();
        builder.columnRef((DasObject)from).space();
        builder.keyword("TO").space();
        builder.newName(toName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(46);
        }
        return ddlBuilder;
    }

    public boolean supportsAlterColumnType() {
        return true;
    }

    @NotNull
    public DdlBuilder sqlAlterColumnTypeNullabilityDefault(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to) throws UnsupportedOperationException {
        boolean modifyDefault;
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(47);
        }
        if (from == null) {
            OracleDialect.$$$reportNull$$$0(48);
        }
        if (to == null) {
            OracleDialect.$$$reportNull$$$0(49);
        }
        boolean modifyType = false;
        boolean modifyNullability = false;
        if (from.getDataType().jdbcType == 12 && to.getDataType().jdbcType == 2005 || from.getDataType().jdbcType == 2005 && to.getDataType().jdbcType == 12) {
            DasColumn newInfo = (DasColumn)DialectUtils.withNewModel(Oracle.RDBMS, OraModModel.class, OraModRoot.class, root2 -> {
                if (from == null) {
                    OracleDialect.$$$reportNull$$$0(159);
                }
                if (to == null) {
                    OracleDialect.$$$reportNull$$$0(160);
                }
                OraModTableColumn o = (OraModTableColumn)DialectUtils.create(((OraModTable)DialectUtils.create(((OraModSchema)DialectUtils.create(root2.getSchemas(), DasUtil.getSchemaObject((DasObject)from))).getTables(), (DasObject)from.getTable())).getColumns(), to.getName() + "_2");
                o.setDataType(to.getDataType());
                o.setNotNull(to.isNotNull());
                return o;
            });
            this.sqlAddColumn(builder, newInfo, DasUtil.NO_ATTRS);
            builder.newStatement();
            builder.keyword("UPDATE").space();
            builder.qualifiedRef((DasObject)from.getTable());
            builder.space().keyword("SET").space();
            builder.columnRef((DasObject)newInfo);
            builder.space().symbol("=").space();
            builder.columnRef((DasObject)from);
            builder.newStatement();
            this.sqlDropColumn(builder, from).newStatement();
            this.sqlAlterColumnName(builder, newInfo, to.getName()).newStatement();
            if (!StringUtil.isEmpty((String)to.getComment()) && OracleDialect.isSameComment(from, to)) {
                this.sqlAlterColumnComment(builder, to).newStatement();
            }
            modifyDefault = !StringUtil.isEmpty((String)to.getDefault());
        } else {
            modifyType = !this.isSameType(from, to);
            modifyNullability = !OracleDialect.isSameNullability(from, to);
            boolean bl = modifyDefault = !OracleDialect.isSameDefault(from, to);
        }
        if (modifyDefault || modifyNullability || modifyType) {
            DialectUtils.getColumnDefaultAlterSQL(builder, to, "MODIFY", modifyType, "DEFAULT");
            if (modifyNullability) {
                DialectUtils.addNullabilityClause(builder, to, true);
            }
        }
        builder.newStatement();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(50);
        }
        return ddlBuilder;
    }

    public boolean supportsAlterColumnNull() {
        return true;
    }

    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateTable(@NotNull DdlBuilder builder, @NotNull List<? extends DasTable> tables, boolean constraintsAtEnd, @Nullable Set<? extends DasForeignKey> ignoreFks) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(51);
        }
        if (tables == null) {
            OracleDialect.$$$reportNull$$$0(52);
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateTableSQL(builder, tables, constraintsAtEnd, this, ignoreFks);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(53);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSchema(@NotNull DdlBuilder builder, @NotNull DasNamespace schema) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(54);
        }
        if (schema == null) {
            OracleDialect.$$$reportNull$$$0(55);
        }
        DdlBuilder ddlBuilder = builder.keywords("CREATE", "SCHEMA", "AUTHORIZATION").space().qualifiedRef((DasObject)schema);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(56);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefinition(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to, boolean forceOutput) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(57);
        }
        if (from == null) {
            OracleDialect.$$$reportNull$$$0(58);
        }
        if (to == null) {
            OracleDialect.$$$reportNull$$$0(59);
        }
        int before2 = builder.getStatements().size();
        if (!OracleDialect.isSameName(from, to)) {
            this.sqlAlterColumnName(builder, from, to.getName()).newStatement();
        }
        if (!(this.isSameType(from, to) && OracleDialect.isSameDefault(from, to) && OracleDialect.isSameNullability(from, to))) {
            this.sqlAlterColumnTypeNullabilityDefault(builder, from, to).newStatement();
        }
        if (!OracleDialect.isSameComment(from, to)) {
            this.sqlAlterColumnComment(builder, to).newStatement();
        }
        if (!OracleDialect.isSameAutoInc(from, to)) {
            this.sqlAddColumnAutoIncrement(builder, to).newStatement();
        }
        if (builder.getStatements().size() == before2 && forceOutput) {
            this.sqlAlterColumnName(builder, from, to.getName()).newStatement();
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(60);
        }
        return ddlBuilder;
    }

    public String[] getIndexAccessMethodsTypes() {
        return new String[]{"default", "unique", "bitmap"};
    }

    public String[] getIndexStorageOptions() {
        return null;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(61);
        }
        if (column2 == null) {
            OracleDialect.$$$reportNull$$$0(62);
        }
        DasTable table = column2.getTable();
        String seqName = column2.getName() + "_AUTOINC_SEQ";
        DasTable sequence = (DasTable)DialectUtils.withNewModel(Oracle.RDBMS, OraModModel.class, OraModRoot.class, root2 -> (OraModTable)DialectUtils.create(((OraModSchema)DialectUtils.create(root2.getSchemas(), DasUtil.getSchemaObject((DasObject)table))).getTables(), seqName));
        this.sqlCreateSequence(builder, sequence, "1", "1", "", "1", "", false);
        builder.newStatement();
        String trigName = column2.getName() + "_AUTOINC_TRIG";
        builder.keyword("CREATE OR REPLACE TRIGGER").space().identifier(trigName).newLine();
        builder.keyword("BEFORE INSERT ON").space().qualifiedRef((DasObject)table).newLine();
        builder.keyword("FOR EACH ROW").newLine();
        builder.keyword("DECLARE").newLine();
        builder.tab().ref(null, "nextid").space().ref(null, "number").symbol("(").literal("8").symbol(")").space().symbol(":=").space().literal("0").symbol(";").newLine();
        builder.keyword("BEGIN").newLine();
        builder.tab().keyword("SELECT").space().ref((DasObject)sequence, sequence.getName()).symbol(".").ref(null, "nextval").space().keyword("into").space().ref(null, "nextid").space().keyword("from").space().ref(null, "dual").symbol(";").newLine();
        builder.tab().keyword(":new").symbol(".").columnRef((DasObject)column2).space().symbol(":=").space().ref(null, "nextid").symbol(";").newLine();
        builder.keyword("END").symbol(";").space();
        builder.newStatement();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(63);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column2, @NotNull Set<DasColumn.Attribute> attrs) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(64);
        }
        if (column2 == null) {
            OracleDialect.$$$reportNull$$$0(65);
        }
        if (attrs == null) {
            OracleDialect.$$$reportNull$$$0(66);
        }
        builder.suppressQuoteConstraints(true);
        DialectUtils.getAddColumnSQL(builder, column2, true, true, true);
        if (StringUtil.isNotEmpty((String)column2.getComment())) {
            builder.newStatement();
            DialectUtils.getColumnCommentAlterSQL(builder, column2, this.isCommentDroppedByNull(), DbSqlUtil.getSqlDialect(this));
        }
        DdlBuilder ddlBuilder = builder.suppressQuoteConstraints(false);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(67);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddForeignKey(@NotNull DdlBuilder builder, @NotNull DasForeignKey keyInfo, boolean matchFull, boolean autoFKIndex) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(68);
        }
        if (keyInfo == null) {
            OracleDialect.$$$reportNull$$$0(69);
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddForeignKeyConstraintSQL(builder, keyInfo, false, autoFKIndex, this);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(70);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineForeignKey(@NotNull DdlBuilder builder, DasForeignKey info, boolean matchFull) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(71);
        }
        DdlBuilder ddlBuilder = DialectUtils.foreignKeyTail(builder, info, null, false, info.getDeleteRule() == DasForeignKey.RuleAction.CASCADE ? DasForeignKey.RuleAction.CASCADE : DasForeignKey.RuleAction.NO_ACTION, DasForeignKey.RuleAction.NO_ACTION);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(72);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsDropPackage() {
        return true;
    }

    @Override
    public boolean supportsDropCluster() {
        return true;
    }

    @Override
    public boolean supportsDropSynonym() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropPackage(@NotNull DdlBuilder builder, @NotNull DasSchemaChild pkg) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(73);
        }
        if (pkg == null) {
            OracleDialect.$$$reportNull$$$0(74);
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "PACKAGE").space().qualifiedRef((DasObject)pkg);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(75);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropCluster(@NotNull DdlBuilder builder, @NotNull DasCluster cluster) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(76);
        }
        if (cluster == null) {
            OracleDialect.$$$reportNull$$$0(77);
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "CLUSTER").space().qualifiedRef((DasObject)cluster);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(78);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsRenameSchema() {
        return false;
    }

    @Override
    @NotNull
    protected DatabaseEditorCapabilities.ForeignKeyEditorCaps getForeignKeyEditorCaps(boolean existing) {
        boolean fkRecreateable = this.supportsAddForeignKey() && this.supportsDropForeignKey();
        DatabaseEditorCapabilities.ForeignKeyEditorCaps foreignKeyEditorCaps = new DatabaseEditorCapabilities.ForeignKeyEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || fkRecreateable), DatabaseEditorCapabilities.Capability.UNAVAILABLE, DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.Deferrability.values()), DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.RuleAction.class), DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.RuleAction.SET_NULL, DasForeignKey.RuleAction.CASCADE));
        if (foreignKeyEditorCaps == null) {
            OracleDialect.$$$reportNull$$$0(79);
        }
        return foreignKeyEditorCaps;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddUniqueConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName, @NotNull List<DasColumn> columns2) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(80);
        }
        if (table == null) {
            OracleDialect.$$$reportNull$$$0(81);
        }
        if (constraintName == null) {
            OracleDialect.$$$reportNull$$$0(82);
        }
        if (columns2 == null) {
            OracleDialect.$$$reportNull$$$0(83);
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddUniqueConstraintSQL(builder, table, constraint, constraintName, columns2);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(84);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String restart, @NotNull String cache2, boolean cycle) {
        String cycleClause;
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(85);
        }
        if (sequence == null) {
            OracleDialect.$$$reportNull$$$0(86);
        }
        if (increment == null) {
            OracleDialect.$$$reportNull$$$0(87);
        }
        if (minimum == null) {
            OracleDialect.$$$reportNull$$$0(88);
        }
        if (maximum == null) {
            OracleDialect.$$$reportNull$$$0(89);
        }
        if (restart == null) {
            OracleDialect.$$$reportNull$$$0(90);
        }
        if (cache2 == null) {
            OracleDialect.$$$reportNull$$$0(91);
        }
        String string = cycleClause = cycle ? "CYCLE" : "NOCYCLE";
        if (!restart.isEmpty()) {
            builder.comment("Oracle cannot change the start value of a sequence.");
            builder.newStatement();
            builder.comment("Must drop and re-create.");
            builder.newStatement();
            DialectUtils.getDropSequenceSQL(builder, (DasObject)sequence, null);
            builder.newStatement();
            DialectUtils.getCreateSequenceSQL(builder, sequence, increment, minimum, maximum, restart, cache2, cycleClause);
            builder.newStatement();
            DdlBuilder ddlBuilder = builder;
            if (ddlBuilder == null) {
                OracleDialect.$$$reportNull$$$0(92);
            }
            return ddlBuilder;
        }
        DialectUtils.getAlterSequenceSQL(builder, sequence, increment, minimum, maximum, "", cache2, cycleClause);
        builder.newStatement();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(93);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateIndex(@NotNull DdlBuilder builder, @NotNull DasIndex index2, @NotNull String accessMethod, @NotNull String tablespace, @NotNull String constraints) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(94);
        }
        if (index2 == null) {
            OracleDialect.$$$reportNull$$$0(95);
        }
        if (accessMethod == null) {
            OracleDialect.$$$reportNull$$$0(96);
        }
        if (tablespace == null) {
            OracleDialect.$$$reportNull$$$0(97);
        }
        if (constraints == null) {
            OracleDialect.$$$reportNull$$$0(98);
        }
        builder.keyword("CREATE").space();
        if (index2.isUnique() && !accessMethod.equalsIgnoreCase("bitmap")) {
            builder.keyword("UNIQUE").space();
        }
        if (!accessMethod.isEmpty() && accessMethod.equalsIgnoreCase("bitmap")) {
            builder.keyword(accessMethod);
            builder.space();
        }
        builder.keyword("INDEX").space();
        builder.qualifiedRefOpt((DasObject)index2, index2.getName());
        builder.space().keyword("ON").space();
        builder.qualifiedRef((DasObject)index2.getTable());
        DialectUtils.columnList(builder, index2);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(99);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String start, @NotNull String cache2, boolean cycle) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(100);
        }
        if (sequence == null) {
            OracleDialect.$$$reportNull$$$0(101);
        }
        if (increment == null) {
            OracleDialect.$$$reportNull$$$0(102);
        }
        if (minimum == null) {
            OracleDialect.$$$reportNull$$$0(103);
        }
        if (maximum == null) {
            OracleDialect.$$$reportNull$$$0(104);
        }
        if (start == null) {
            OracleDialect.$$$reportNull$$$0(105);
        }
        if (cache2 == null) {
            OracleDialect.$$$reportNull$$$0(106);
        }
        String minValue = minimum;
        String minClause = "MINVALUE";
        if (minValue.isEmpty()) {
            minValue = "";
            minClause = "NOMINVALUE";
        }
        String maxValue = maximum;
        String maxClause = "MAXVALUE";
        if (maxValue.isEmpty()) {
            maxValue = "";
            maxClause = "NOMAXVALUE";
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateSequenceSQL(builder, sequence, increment, minClause, minValue, maxClause, maxValue, start, cache2, "");
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(107);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(108);
        }
        if (view == null) {
            OracleDialect.$$$reportNull$$$0(109);
        }
        if (definition == null) {
            OracleDialect.$$$reportNull$$$0(110);
        }
        if (checkOption == null) {
            OracleDialect.$$$reportNull$$$0(111);
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateViewSQL(builder, view, definition, checkOption, this);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(112);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(113);
        }
        if (table == null) {
            OracleDialect.$$$reportNull$$$0(114);
        }
        if (constraintName == null) {
            OracleDialect.$$$reportNull$$$0(115);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropConstraintSQL(builder, table, constraint, constraintName);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(116);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropIndex(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasIndex index2, @NotNull String indexName, boolean cascade) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(117);
        }
        if (table == null) {
            OracleDialect.$$$reportNull$$$0(118);
        }
        if (indexName == null) {
            OracleDialect.$$$reportNull$$$0(119);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropIndexSQL(builder, table, index2, indexName, null, false);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(120);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(121);
        }
        if (sequence == null) {
            OracleDialect.$$$reportNull$$$0(122);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropSequenceSQL(builder, sequence, null);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(123);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(124);
        }
        if (view == null) {
            OracleDialect.$$$reportNull$$$0(125);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL(builder, view, null);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(126);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameTable(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull String newName) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(127);
        }
        if (table == null) {
            OracleDialect.$$$reportNull$$$0(128);
        }
        if (newName == null) {
            OracleDialect.$$$reportNull$$$0(129);
        }
        builder.keyword("ALTER").space().keyword("TABLE").space();
        builder.qualifiedRef((DasObject)table);
        builder.space().keyword("RENAME").space().keyword("TO").space();
        builder.newName(newName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(130);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String newName) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(131);
        }
        if (view == null) {
            OracleDialect.$$$reportNull$$$0(132);
        }
        if (newName == null) {
            OracleDialect.$$$reportNull$$$0(133);
        }
        DdlBuilder ddlBuilder = builder.keywords("RENAME").space().identifier(view.getName()).space().keyword("TO").space().newName(newName);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(134);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlSequenceInformation(@NotNull DdlBuilder builder, @NotNull DasTable sequence) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(135);
        }
        if (sequence == null) {
            OracleDialect.$$$reportNull$$$0(136);
        }
        SqlLanguageDialect language = DbSqlUtil.getSqlDialect(this);
        builder.keyword("SELECT").space();
        builder.ref(null, "last_number").symbol(",").space();
        builder.ref(null, "max_value").symbol(",").space();
        builder.ref(null, "min_value").symbol(",").space();
        builder.ref(null, "cache_size").symbol(",").space();
        builder.ref(null, "increment_by").symbol(",").space();
        builder.keyword("case").space().ref(null, "cycle_flag").space().keyword("when").space().literal("'N'").space().keyword("then").space().literal("0").space().keyword("else").space().literal("1").space().keyword("end").space().keyword("as").space().plain("cycle_flag").space();
        builder.keyword("FROM").space().ref(null, "USER_SEQUENCES").space();
        String seq = builder.copied().qualifiedRef((DasObject)sequence).getStatement();
        builder.keyword("WHERE").space().ref(null, "sequence_name").space().symbol("=").space().plain("upper").symbol("(").literal(language.asStringLiteral(seq)).symbol(")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(137);
        }
        return ddlBuilder;
    }

    public boolean supportsAccessMethods() {
        return true;
    }

    public boolean supportsAddForeignKey() {
        return true;
    }

    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    public boolean supportsAlterSequence() {
        return true;
    }

    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    public boolean supportsCreateIndex() {
        return true;
    }

    public boolean supportsCreateSequence() {
        return true;
    }

    @Override
    public boolean supportsCreateTable() {
        return true;
    }

    @Override
    public boolean supportsDropMaterializedView() {
        return true;
    }

    @Override
    public boolean supportsDropType() {
        return true;
    }

    public boolean supportsCreateView() {
        return true;
    }

    public boolean supportsDropConstraint() {
        return true;
    }

    public boolean supportsDropIndex() {
        return true;
    }

    public boolean supportsDropSequence() {
        return true;
    }

    public boolean supportsDropView() {
        return true;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    public boolean supportsIndexes() {
        return true;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlPackageBodyDefinition(@NotNull DasObject element) {
        if (element == null) {
            OracleDialect.$$$reportNull$$$0(138);
        }
        Pair pair = Pair.create((Object)OracleDialect.getPackageDefinitionQuery(element, "PACKAGE BODY"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            OracleDialect.$$$reportNull$$$0(139);
        }
        return pair;
    }

    @Override
    public boolean supportsPackageDefinition() {
        return true;
    }

    private static String getPackageDefinitionQuery(DasObject element, String type) {
        return "select TEXT FROM SYS.ALL_SOURCE WHERE OWNER = '" + DasUtil.getSchema((DasObject)element) + "' AND NAME = '" + element.getName() + "' AND TYPE = '" + type + "' ORDER BY LINE";
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlPackageDefinition(@NotNull DasObject element) {
        if (element == null) {
            OracleDialect.$$$reportNull$$$0(140);
        }
        Pair pair = Pair.create((Object)OracleDialect.getPackageDefinitionQuery(element, "PACKAGE"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            OracleDialect.$$$reportNull$$$0(141);
        }
        return pair;
    }

    @Override
    public boolean supportsSequenceDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSequenceDefinition(@NotNull DasObject element) {
        if (element == null) {
            OracleDialect.$$$reportNull$$$0(142);
        }
        Pair pair = Pair.create((Object)("select dbms_metadata.get_ddl('SEQUENCE', '" + element.getName() + "', '" + DasUtil.getSchema((DasObject)element) + "') from dual"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            OracleDialect.$$$reportNull$$$0(143);
        }
        return pair;
    }

    public boolean supportsMultipleRowInserts() {
        return false;
    }

    public boolean supportsRenameTable() {
        return true;
    }

    public boolean supportsRenameView() {
        return true;
    }

    public boolean supportsSequence() {
        return true;
    }

    public boolean supportsSequenceInformation() {
        return true;
    }

    public boolean supportsTablespace() {
        return true;
    }

    public boolean supportsAddColumn() {
        return true;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            OracleDialect.$$$reportNull$$$0(144);
        }
        return Pair.create((Object)("select TEXT FROM SYS.ALL_VIEWS WHERE OWNER = '" + DasUtil.getSchema((DasObject)element) + "' AND VIEW_NAME = '" + element.getName() + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            OracleDialect.$$$reportNull$$$0(145);
        }
        StringBuilder result2 = new StringBuilder();
        result2.append("select TEXT ");
        result2.append("FROM SYS.ALL_SOURCE ");
        result2.append("WHERE OWNER = ");
        result2.append("'");
        result2.append(DasUtil.getSchema((DasObject)element));
        result2.append("'");
        result2.append(" AND NAME = ");
        result2.append("'");
        result2.append(element.getName());
        result2.append("'");
        String type = StringUtil.toUpperCase((String)element.getRoutineKind().name());
        result2.append(" AND TYPE = ");
        result2.append("'");
        result2.append(StringUtil.toUpperCase((String)type));
        result2.append("'");
        result2.append(" ORDER BY LINE");
        Pair pair = Pair.create((Object)result2.toString(), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            OracleDialect.$$$reportNull$$$0(146);
        }
        return pair;
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            OracleDialect.$$$reportNull$$$0(147);
        }
        if (!Character.isLetter(identifier.charAt(0))) {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 1; i2 < len; ++i2) {
            char c = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '$' || c == '#') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            OracleDialect.$$$reportNull$$$0(148);
        }
        if (qualifier == null) {
            OracleDialect.$$$reportNull$$$0(149);
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        String pkgName = qualifier instanceof DasRoutine ? ((DasRoutine)qualifier).getPackageName() : null;
        DasObject pkg = pkgName == null ? null : qualifier.getDasParent();
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), null, null, pkg, pkgName);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(150);
        }
        return ddlBuilder;
    }

    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    protected String randomShorterUUID() {
        UUID uuid = UUID.randomUUID();
        return DatatypeConverter.printBase64Binary((byte[])ByteBuffer.allocate(16).putLong(uuid.getLeastSignificantBits()).putLong(uuid.getMostSignificantBits()).array());
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze2) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(151);
        }
        if (statement == null) {
            OracleDialect.$$$reportNull$$$0(152);
        }
        if (analyze2) {
            throw new UnsupportedOperationException("Oracle does not support EXPLAIN ANALYZE");
        }
        String uid = this.randomShorterUUID();
        builder.keywords("explain", "plan").space().keyword("set").space().plain("statement_id").symbol("=").symbol("'").plain(uid).symbol("'").space().keyword("for").space().plain(statement).newStatement();
        builder.keyword("select").space().symbol("*").space().keyword("from").space().keyword("table").symbol("(").plain("DBMS_XPLAN.DISPLAY").symbol("(").symbol("'").plain("PLAN_TABLE").symbol("'").symbol(",").symbol("'").plain(uid).symbol("'").symbol(")").symbol(")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(153);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    protected AbstractDatabaseDialect.LimitPlace getPlaceForLimit(@Nullable DasDataSource system) {
        AbstractDatabaseDialect.LimitPlace limitPlace = AbstractDatabaseDialect.LimitPlace.BOTH;
        if (limitPlace == null) {
            OracleDialect.$$$reportNull$$$0(154);
        }
        return limitPlace;
    }

    @Override
    @NotNull
    protected DdlBuilder appendLimit(@NotNull DdlBuilder builder, @Nullable DasDataSource system, int rows) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(155);
        }
        DdlBuilder ddlBuilder = OracleDialect.rowNumLimit(builder, rows);
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(156);
        }
        return ddlBuilder;
    }

    @Override
    public boolean hasRowId(@Nullable DasDataSource system) {
        return true;
    }

    @Override
    @NotNull
    protected DdlBuilder appendRowId(@NotNull DdlBuilder builder, @Nullable DasDataSource system) {
        if (builder == null) {
            OracleDialect.$$$reportNull$$$0(157);
        }
        DdlBuilder ddlBuilder = builder.symbol(",").space().literal("ROWID");
        if (ddlBuilder == null) {
            OracleDialect.$$$reportNull$$$0(158);
        }
        return ddlBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 127: 
            case 128: 
            case 129: 
            case 131: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 140: 
            case 142: 
            case 144: 
            case 145: 
            case 147: 
            case 148: 
            case 149: 
            case 151: 
            case 152: 
            case 155: 
            case 157: 
            case 159: 
            case 160: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 127: 
            case 128: 
            case 129: 
            case 131: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 140: 
            case 142: 
            case 144: 
            case 145: 
            case 147: 
            case 148: 
            case 149: 
            case 151: 
            case 152: 
            case 155: 
            case 157: 
            case 159: 
            case 160: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/OracleDialect";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeColumnTypeName";
                break;
            }
            case 6: 
            case 22: 
            case 25: 
            case 28: 
            case 40: 
            case 43: 
            case 47: 
            case 51: 
            case 54: 
            case 57: 
            case 61: 
            case 64: 
            case 68: 
            case 71: 
            case 73: 
            case 76: 
            case 80: 
            case 85: 
            case 94: 
            case 100: 
            case 108: 
            case 113: 
            case 117: 
            case 121: 
            case 124: 
            case 127: 
            case 131: 
            case 135: 
            case 151: 
            case 155: 
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: 
            case 10: 
            case 15: 
            case 138: 
            case 140: 
            case 142: 
            case 144: 
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: 
            case 29: 
            case 81: 
            case 114: 
            case 118: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseProductVersion";
                break;
            }
            case 23: 
            case 26: 
            case 62: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pk";
                break;
            }
            case 44: 
            case 48: 
            case 58: 
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toName";
                break;
            }
            case 49: 
            case 59: 
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tables";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyInfo";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cluster";
                break;
            }
            case 82: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintName";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 86: 
            case 101: 
            case 122: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 87: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "increment";
                break;
            }
            case 88: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimum";
                break;
            }
            case 89: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maximum";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restart";
                break;
            }
            case 91: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessMethod";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tablespace";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 109: 
            case 125: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkOption";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 129: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 147: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDdlOperations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 127: 
            case 128: 
            case 129: 
            case 131: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 140: 
            case 142: 
            case 144: 
            case 145: 
            case 147: 
            case 148: 
            case 149: 
            case 151: 
            case 152: 
            case 155: 
            case 157: 
            case 159: 
            case 160: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/OracleDialect";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlSynonymDefinition";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadSynonymDefinition";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlTableDefinition";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnComment";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropColumn";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropTable";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddPrimaryKey";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnName";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnTypeNullabilityDefault";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateTable";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateSchema";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnDefinition";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddColumn";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddForeignKey";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineForeignKey";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropPackage";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropCluster";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getForeignKeyEditorCaps";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddUniqueConstraint";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterSequence";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateIndex";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateSequence";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateView";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropConstraint";
                break;
            }
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropIndex";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropSequence";
                break;
            }
            case 126: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameTable";
                break;
            }
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameView";
                break;
            }
            case 137: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlSequenceInformation";
                break;
            }
            case 139: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlPackageBodyDefinition";
                break;
            }
            case 141: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlPackageDefinition";
                break;
            }
            case 143: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlSequenceDefinition";
                break;
            }
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 150: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 153: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlExplainPlan";
                break;
            }
            case 154: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceForLimit";
                break;
            }
            case 156: {
                objectArray = objectArray2;
                objectArray2[1] = "appendLimit";
                break;
            }
            case 158: {
                objectArray = objectArray2;
                objectArray2[1] = "appendRowId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getJavaTypeForNativeType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sqlParameter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sqlSynonymDefinition";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sqlTableDefinition";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "supportsProduct";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnComment";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropColumn";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropTable";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddPrimaryKey";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnName";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnTypeNullabilityDefault";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateTable";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateSchema";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnDefinition";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumn";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddForeignKey";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineForeignKey";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropPackage";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropCluster";
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddUniqueConstraint";
                break;
            }
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterSequence";
                break;
            }
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateIndex";
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateSequence";
                break;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropConstraint";
                break;
            }
            case 117: 
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropIndex";
                break;
            }
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 127: 
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameTable";
                break;
            }
            case 131: 
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameView";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceInformation";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "sqlPackageBodyDefinition";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "sqlPackageDefinition";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceDefinition";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 148: 
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "appendLimit";
                break;
            }
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "appendRowId";
                break;
            }
            case 159: 
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "lambda$sqlAlterColumnTypeNullabilityDefault$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 127: 
            case 128: 
            case 129: 
            case 131: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 140: 
            case 142: 
            case 144: 
            case 145: 
            case 147: 
            case 148: 
            case 149: 
            case 151: 
            case 152: 
            case 155: 
            case 157: 
            case 159: 
            case 160: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class OraMetaModelExt {
        public static final MetaModel META_MODEL = MetaModelImpl.builder(OraMetaModel.MODEL).put(ObjectKind.SCHEMA, ObjectKind.OPERATOR).put(ObjectKind.BODY, ObjectKind.ROUTINE).build();

        private OraMetaModelExt() {
        }
    }
}

