/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.google.common.collect.Iterables;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.AbstractDatabaseDialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.BasicMetaModel;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasOperator;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.postgres.PostgresForeignServer;
import com.intellij.database.model.postgres.PostgresMetaModel;
import com.intellij.database.model.postgres.PostgresModDatabase;
import com.intellij.database.model.postgres.PostgresModLocalTable;
import com.intellij.database.model.postgres.PostgresModModel;
import com.intellij.database.model.postgres.PostgresModRoot;
import com.intellij.database.model.postgres.PostgresModSchema;
import com.intellij.database.model.postgres.PostgresUserMapping;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.operations.postgres.PgDdlOperationsBuilder;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.vendors.postgres.PostgresDialectHelper;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.util.Version;

public class PostgresDialect
extends AbstractDatabaseDialect
implements DatabaseDialect,
AbstractDatabaseDialect.SplitAlterColumnSupport {
    public static final Pattern SERIAL_PATTERN = Pattern.compile("(?i)(?:big|small)?serial|serial[248]");
    private static final int FRACTIONAL_SECONDS_PRECISION_MAX = 6;
    public static final PostgresDialect INSTANCE = new PostgresDialect();

    protected PostgresDialect() {
        super(new TypeHelper.PostgresTypeHelper(), new KeywordHelper.PostgresKeywords(), Casing.create((Case)Case.LOWER, (Case)Case.EXACT));
    }

    @Override
    @NotNull
    public MetaModel getMetaModel() {
        BasicMetaModel basicMetaModel = PostgresMetaModel.MODEL;
        if (basicMetaModel == null) {
            PostgresDialect.$$$reportNull$$$0(0);
        }
        return basicMetaModel;
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.POSTGRES;
        if (databaseFamilyId == null) {
            PostgresDialect.$$$reportNull$$$0(1);
        }
        return databaseFamilyId;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.Postgresql;
        if (icon == null) {
            PostgresDialect.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("PostgreSQL" == null) {
            PostgresDialect.$$$reportNull$$$0(3);
        }
        return "PostgreSQL";
    }

    @Override
    public boolean supportsSchemasInTableDefinition() {
        return true;
    }

    @Override
    public boolean supportsColumnCommentsInTableDefinition() {
        return false;
    }

    @Override
    protected boolean isNameFriendlyCharacter(char ch) {
        return ch == '_' || ch == '$';
    }

    @Override
    @NotNull
    protected DdlOperations getDdlOperations() {
        DdlOperations ddlOperations = new PgDdlOperationsBuilder(this).build();
        if (ddlOperations == null) {
            PostgresDialect.$$$reportNull$$$0(4);
        }
        return ddlOperations;
    }

    @Override
    public boolean supportsTableComment() {
        return true;
    }

    @Override
    public String getBinaryLiteralString(@NotNull byte[] binaryData) {
        if (binaryData == null) {
            PostgresDialect.$$$reportNull$$$0(5);
        }
        return "E'\\\\x" + DialectUtils.toHexString(binaryData) + "'";
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            PostgresDialect.$$$reportNull$$$0(6);
        }
        if (databaseProductName == null) {
            return false;
        }
        return databaseProductName.trim().toLowerCase(Locale.ENGLISH).startsWith("postgresql");
    }

    public boolean supportsColumnComment() {
        return true;
    }

    @Override
    public boolean supportsDropColumn() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(7);
        }
        if (column2 == null) {
            PostgresDialect.$$$reportNull$$$0(8);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDropSQL(builder, column2);
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(9);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineColumn(@NotNull DdlBuilder builder, DasColumn column2, boolean singlePk) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(10);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDefinitionSQL(builder, column2, singlePk, DasUtil.isAutoGenerated((DasColumn)column2) ? PostgresDialect.getSerialType(column2, builder) : null);
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(11);
        }
        return ddlBuilder;
    }

    @Nullable
    private static String getSerialType(@NotNull DasColumn column2, @NotNull DdlBuilder builder) {
        if (column2 == null) {
            PostgresDialect.$$$reportNull$$$0(12);
        }
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(13);
        }
        DataType type = column2.getDataType();
        if (SERIAL_PATTERN.matcher(type.typeName).matches()) {
            return null;
        }
        if (type.typeName.equalsIgnoreCase("int2")) {
            return "serial2";
        }
        if (type.typeName.equalsIgnoreCase("int4")) {
            return "serial4";
        }
        if (type.typeName.equalsIgnoreCase("int8")) {
            return "serial8";
        }
        if (type.typeName.equalsIgnoreCase("smallint")) {
            return "smallserial";
        }
        if (type.typeName.equalsIgnoreCase("int") || type.typeName.equalsIgnoreCase("integer")) {
            return "serial";
        }
        if (type.typeName.equalsIgnoreCase("bigint")) {
            return "bigserial";
        }
        builder.comment("only integer type can be autoincremented, got " + type.getSpecification() + "\n");
        return null;
    }

    @Override
    public boolean supportsDropRule() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTable(@NotNull DdlBuilder builder, @NotNull DasTable table, boolean cascadeConstraints, boolean isMaterializedView, @NotNull DasModel model) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(14);
        }
        if (table == null) {
            PostgresDialect.$$$reportNull$$$0(15);
        }
        if (model == null) {
            PostgresDialect.$$$reportNull$$$0(16);
        }
        DdlBuilder ddlBuilder = DialectUtils.getTableDropSQL(builder, table, true, cascadeConstraints, false, "CASCADE", false, table.getKind() == ObjectKind.FOREIGN_TABLE);
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(17);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            PostgresDialect.$$$reportNull$$$0(18);
        }
        if (dataType.jdbcType == 0) {
            String string = dataType.getSpecification();
            if (string == null) {
                PostgresDialect.$$$reportNull$$$0(19);
            }
            return string;
        }
        String typeName = dataType.typeName;
        int jdbcType = dataType.jdbcType;
        if (jdbcType == -7 && "bool".equals(typeName)) {
            if ("bool" == null) {
                PostgresDialect.$$$reportNull$$$0(20);
            }
            return "bool";
        }
        if (jdbcType == -5 && "oid".equals(typeName)) {
            if ("oid" == null) {
                PostgresDialect.$$$reportNull$$$0(21);
            }
            return "oid";
        }
        if (jdbcType == 93 || jdbcType == 92) {
            int fractionalSecondsPrecision = dataType.getScale();
            String string = JdbcUtil.getJdbcTypeName((DataType)dataType, (boolean)false) + (fractionalSecondsPrecision != 6 ? "(" + fractionalSecondsPrecision + ")" : "");
            if (string == null) {
                PostgresDialect.$$$reportNull$$$0(22);
            }
            return string;
        }
        if (jdbcType == 2) {
            String string = "numeric" + (dataType.getLength() == 131089 ? "" : "(" + dataType.getPrecision() + (dataType.getScale() == 0 ? "" : ", " + dataType.getScale()) + ")");
            if (string == null) {
                PostgresDialect.$$$reportNull$$$0(23);
            }
            return string;
        }
        String string = super.getTypeName(dataType);
        if (string == null) {
            PostgresDialect.$$$reportNull$$$0(24);
        }
        return string;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(25);
        }
        if (pk == null) {
            PostgresDialect.$$$reportNull$$$0(26);
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddPrimaryKeySQL(builder, pk, false);
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(27);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnComment(@NotNull DdlBuilder builder, @NotNull DasColumn column2) throws UnsupportedOperationException {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(28);
        }
        if (column2 == null) {
            PostgresDialect.$$$reportNull$$$0(29);
        }
        builder.suppressQuoteConstraints(true);
        DdlBuilder ddlBuilder = DialectUtils.getColumnCommentAlterSQL(builder, column2, this.isCommentDroppedByNull(), DbSqlUtil.getSqlDialect(this)).suppressQuoteConstraints(false);
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(30);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnNullable(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(31);
        }
        if (column2 == null) {
            PostgresDialect.$$$reportNull$$$0(32);
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)column2.getTable());
        builder.space().keywords("ALTER", "COLUMN").space();
        builder.columnRef((DasObject)column2).space();
        builder.keyword(!column2.isNotNull() ? "DROP" : "SET").space().keyword("NOT").space().keyword("NULL");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(33);
        }
        return ddlBuilder;
    }

    public boolean supportsRenameColumn() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnName(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull String toName) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(34);
        }
        if (from == null) {
            PostgresDialect.$$$reportNull$$$0(35);
        }
        if (toName == null) {
            PostgresDialect.$$$reportNull$$$0(36);
        }
        String alterClause = "RENAME COLUMN";
        String toClause = "TO";
        DdlBuilder ddlBuilder = DialectUtils.getColumnNameAlterSQL(builder, from, toName, alterClause, toClause);
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(37);
        }
        return ddlBuilder;
    }

    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnType(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to) throws UnsupportedOperationException {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(38);
        }
        if (from == null) {
            PostgresDialect.$$$reportNull$$$0(39);
        }
        if (to == null) {
            PostgresDialect.$$$reportNull$$$0(40);
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)to.getTable());
        builder.space().keywords("ALTER", "COLUMN").space();
        builder.columnRef((DasObject)to).space();
        builder.keyword("TYPE").space();
        builder.type((DasTypedObject)to);
        builder.space().keyword("USING").space().columnRef((DasObject)to).symbol("::").type((DasTypedObject)to);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(41);
        }
        return ddlBuilder;
    }

    public boolean supportsAlterColumnNull() {
        return true;
    }

    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefault(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(42);
        }
        if (column2 == null) {
            PostgresDialect.$$$reportNull$$$0(43);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDefaultAlterOrDropSQL(builder, column2);
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(44);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(45);
        }
        if (pk == null) {
            PostgresDialect.$$$reportNull$$$0(46);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropPrimaryKeySQL(builder, pk, true, false);
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(47);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine procedure) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(48);
        }
        if (procedure == null) {
            PostgresDialect.$$$reportNull$$$0(49);
        }
        String type = procedure.getRoutineKind().name();
        builder.keyword("DROP").space().keyword(type);
        builder.space();
        builder.qualifiedRef((DasObject)procedure).symbol("(");
        boolean first = true;
        for (DasArgument arg : DasUtil.getParameters((DasRoutine)procedure)) {
            DasArgument.Direction direction = arg.getArgumentDirection();
            if (direction != DasArgument.Direction.IN && direction != DasArgument.Direction.INOUT) continue;
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            builder.type((DasTypedObject)arg);
        }
        builder.symbol(")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(50);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTrigger(@NotNull DdlBuilder builder, @NotNull DasTrigger trigger) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(51);
        }
        if (trigger == null) {
            PostgresDialect.$$$reportNull$$$0(52);
        }
        builder.keywords("DROP", "TRIGGER").space().identifier((DasObject)trigger, trigger.getName()).space().keyword("ON").space().qualifiedRef((DasObject)trigger.getTable());
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(53);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropRule(@NotNull DdlBuilder builder, @NotNull DasTableChild rule) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(54);
        }
        if (rule == null) {
            PostgresDialect.$$$reportNull$$$0(55);
        }
        builder.keywords("DROP", "RULE").space().identifier((DasObject)rule, rule.getName()).space().keyword("ON").space().qualifiedRef((DasObject)rule.getTable());
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(56);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropOperator(@NotNull DdlBuilder builder, @NotNull DasOperator operator) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(57);
        }
        if (operator == null) {
            PostgresDialect.$$$reportNull$$$0(58);
        }
        builder.keywords("DROP", "OPERATOR").space().ref((DasObject)operator, operator.getName()).symbol("(");
        DasOperator.OperatorNotation notation = operator.getOperatorNotation();
        List types = operator.getArgumentTypes();
        if (notation == DasOperator.OperatorNotation.PREFIX && types.size() == 1) {
            builder.keyword("NONE").symbol(", ").type((DataType)types.get(0));
        } else if (notation == DasOperator.OperatorNotation.POSTFIX && types.size() == 1) {
            builder.type((DataType)types.get(0)).symbol(", ").keyword("NONE");
        } else if (notation == DasOperator.OperatorNotation.INFIX && types.size() == 2) {
            builder.type((DataType)types.get(0)).symbol(", ").type((DataType)types.get(1));
        } else {
            builder.keyword("NONE").symbol(", ").keyword("NONE");
        }
        DdlBuilder ddlBuilder = builder.symbol(")");
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(59);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsCreateDatabase() {
        return true;
    }

    public boolean supportsSequence() {
        return false;
    }

    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    public boolean supportsIndexes() {
        return true;
    }

    public boolean supportsTablespace() {
        return true;
    }

    public boolean supportsAccessMethods() {
        return true;
    }

    public boolean supportsDropView() {
        return true;
    }

    @Override
    public boolean supportsDropCollation() {
        return true;
    }

    @Override
    public boolean supportsDropForeignDataWrapper() {
        return true;
    }

    @Override
    public boolean supportsDropForeignServer() {
        return true;
    }

    @Override
    public boolean supportsDropUserMapping() {
        return true;
    }

    public boolean supportsRenameView() {
        return true;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    public boolean supportsEmptyTables() {
        return true;
    }

    public boolean supportsMultipleRowInserts() {
        return true;
    }

    public boolean supportsAddForeignKey() {
        return true;
    }

    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    public boolean supportsAlterSequence() {
        return true;
    }

    public boolean supportsCreateIndex() {
        return true;
    }

    public boolean supportsCreateSequence() {
        return true;
    }

    @Override
    public boolean supportsCreateTable() {
        return true;
    }

    @Override
    public boolean supportsDropMaterializedView() {
        return true;
    }

    @Override
    public boolean supportsDropOperator() {
        return true;
    }

    @Override
    public boolean supportsDropType() {
        return true;
    }

    @Override
    public boolean supportsDropSchema() {
        return true;
    }

    public boolean supportsCreateView() {
        return true;
    }

    public boolean supportsDropConstraint() {
        return true;
    }

    public boolean supportsDropIndex() {
        return true;
    }

    public boolean supportsDropSequence() {
        return true;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    public boolean supportsRenameTable() {
        return true;
    }

    public boolean supportsSequenceInformation() {
        return true;
    }

    public String[] getIndexAccessMethodsTypes() {
        return new String[]{"btree", "hash", "gist", "gin"};
    }

    public String[] getIndexStorageOptions() {
        return null;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameTable(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull String newName) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(60);
        }
        if (table == null) {
            PostgresDialect.$$$reportNull$$$0(61);
        }
        if (newName == null) {
            PostgresDialect.$$$reportNull$$$0(62);
        }
        builder.keyword("ALTER TABLE").space();
        builder.qualifiedRef((DasObject)table);
        builder.space().keywords("RENAME", "TO").space();
        builder.newName(newName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(63);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(64);
        }
        if (view == null) {
            PostgresDialect.$$$reportNull$$$0(65);
        }
        if (definition == null) {
            PostgresDialect.$$$reportNull$$$0(66);
        }
        if (checkOption == null) {
            PostgresDialect.$$$reportNull$$$0(67);
        }
        builder.keywords("CREATE", "OR", "REPLACE", "VIEW").space().qualifiedRef((DasObject)view).space().keyword("AS").space().plain(definition);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(68);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String newName) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(69);
        }
        if (view == null) {
            PostgresDialect.$$$reportNull$$$0(70);
        }
        if (newName == null) {
            PostgresDialect.$$$reportNull$$$0(71);
        }
        DdlBuilder ddlBuilder = this.sqlRenameTable(builder, view, newName);
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(72);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(73);
        }
        if (view == null) {
            PostgresDialect.$$$reportNull$$$0(74);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL(builder, view, cascade);
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(75);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropCollation(@NotNull DdlBuilder builder, @NotNull DasObject collation) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(76);
        }
        if (collation == null) {
            PostgresDialect.$$$reportNull$$$0(77);
        }
        DdlBuilder ddlBuilder = DialectUtils.getCollationDropSql(builder, collation);
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(78);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropForeignDataWrapper(@NotNull DdlBuilder builder, @NotNull DasObject object) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(79);
        }
        if (object == null) {
            PostgresDialect.$$$reportNull$$$0(80);
        }
        DdlBuilder ddlBuilder = builder.keyword("DROP").space().keyword("FOREIGN").space().keyword("DATA").space().keyword("WRAPPER").space().qualifiedRef(object);
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(81);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropForeignServer(@NotNull DdlBuilder builder, @NotNull DasObject object) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(82);
        }
        if (object == null) {
            PostgresDialect.$$$reportNull$$$0(83);
        }
        DdlBuilder ddlBuilder = builder.keyword("DROP").space().keyword("SERVER").space().qualifiedRef(object);
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(84);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropUserMapping(@NotNull DdlBuilder builder, @NotNull DasObject object) {
        PostgresUserMapping mapping;
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(85);
        }
        if (object == null) {
            PostgresDialect.$$$reportNull$$$0(86);
        }
        if ((mapping = PostgresDialect.castToUserMapping(object)) == null) {
            DdlBuilder ddlBuilder = builder;
            if (ddlBuilder == null) {
                PostgresDialect.$$$reportNull$$$0(87);
            }
            return ddlBuilder;
        }
        PostgresForeignServer server = mapping.getForeignServer();
        if (server == null || mapping.getUser() == null) {
            DdlBuilder ddlBuilder = builder;
            if (ddlBuilder == null) {
                PostgresDialect.$$$reportNull$$$0(88);
            }
            return ddlBuilder;
        }
        DdlBuilder ddlBuilder = builder.keyword("DROP").space().keyword("USER").space().keyword("MAPPING").space().keyword("FOR").space().identifier(null, mapping.getUser()).space().keyword("SERVER").space().identifier(server, server.getName());
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(89);
        }
        return ddlBuilder;
    }

    @Nullable
    private static PostgresUserMapping castToUserMapping(@NotNull DasObject object) {
        if (object == null) {
            PostgresDialect.$$$reportNull$$$0(90);
        }
        return (PostgresUserMapping)ObjectUtils.tryCast((Object)(object instanceof DbElement ? ((DbElement)object).getDelegate() : object), PostgresUserMapping.class);
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateIndex(@NotNull DdlBuilder builder, @NotNull DasIndex index2, @NotNull String accessMethod, @NotNull String tablespace, @NotNull String constraints) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(91);
        }
        if (index2 == null) {
            PostgresDialect.$$$reportNull$$$0(92);
        }
        if (accessMethod == null) {
            PostgresDialect.$$$reportNull$$$0(93);
        }
        if (tablespace == null) {
            PostgresDialect.$$$reportNull$$$0(94);
        }
        if (constraints == null) {
            PostgresDialect.$$$reportNull$$$0(95);
        }
        if (index2.isUnique() && accessMethod.equalsIgnoreCase("hash")) {
            DdlBuilder ddlBuilder = DialectUtils.getAddIndexSQL(builder, (DasTableChild)index2, "", tablespace, constraints);
            if (ddlBuilder == null) {
                PostgresDialect.$$$reportNull$$$0(96);
            }
            return ddlBuilder;
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddIndexSQL(builder, (DasTableChild)index2, accessMethod, tablespace, constraints);
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(97);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropIndex(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasIndex index2, @NotNull String indexName, boolean cascade) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(98);
        }
        if (table == null) {
            PostgresDialect.$$$reportNull$$$0(99);
        }
        if (indexName == null) {
            PostgresDialect.$$$reportNull$$$0(100);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropIndexSQL(builder, table, index2, indexName, cascade, false);
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(101);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String start, @NotNull String cache2, boolean cycle) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(102);
        }
        if (sequence == null) {
            PostgresDialect.$$$reportNull$$$0(103);
        }
        if (increment == null) {
            PostgresDialect.$$$reportNull$$$0(104);
        }
        if (minimum == null) {
            PostgresDialect.$$$reportNull$$$0(105);
        }
        if (maximum == null) {
            PostgresDialect.$$$reportNull$$$0(106);
        }
        if (start == null) {
            PostgresDialect.$$$reportNull$$$0(107);
        }
        if (cache2 == null) {
            PostgresDialect.$$$reportNull$$$0(108);
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateSequenceSQL(builder, sequence, increment, minimum, maximum, start, cache2, cycle ? "CYCLE" : "NO CYCLE");
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(109);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String restart, @NotNull String cache2, boolean cycle) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(110);
        }
        if (sequence == null) {
            PostgresDialect.$$$reportNull$$$0(111);
        }
        if (increment == null) {
            PostgresDialect.$$$reportNull$$$0(112);
        }
        if (minimum == null) {
            PostgresDialect.$$$reportNull$$$0(113);
        }
        if (maximum == null) {
            PostgresDialect.$$$reportNull$$$0(114);
        }
        if (restart == null) {
            PostgresDialect.$$$reportNull$$$0(115);
        }
        if (cache2 == null) {
            PostgresDialect.$$$reportNull$$$0(116);
        }
        DdlBuilder ddlBuilder = DialectUtils.getAlterSequenceSQL(builder, sequence, increment, minimum, maximum, restart, cache2, cycle ? "CYCLE" : "NO CYCLE");
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(117);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlSequenceInformation(@NotNull DdlBuilder builder, @NotNull DasTable sequence) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(118);
        }
        if (sequence == null) {
            PostgresDialect.$$$reportNull$$$0(119);
        }
        builder.keyword("SELECT").space();
        boolean first = true;
        for (String part : new String[]{"last_value", "max_value", "min_value", "cache_value", "increment_by", "is_cycled"}) {
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            builder.ref(null, part);
        }
        builder.space();
        builder.keyword("FROM").space().qualifiedRef((DasObject)sequence);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(120);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(121);
        }
        if (sequence == null) {
            PostgresDialect.$$$reportNull$$$0(122);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropSequenceSQL(builder, sequence, cascade);
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(123);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddForeignKey(@NotNull DdlBuilder builder, @NotNull DasForeignKey keyInfo, boolean matchFull, boolean autoFKIndex) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(124);
        }
        if (keyInfo == null) {
            PostgresDialect.$$$reportNull$$$0(125);
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddForeignKeyConstraintSQL(builder, keyInfo, matchFull, autoFKIndex, this);
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(126);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddUniqueConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName, @NotNull List<DasColumn> columns2) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(127);
        }
        if (table == null) {
            PostgresDialect.$$$reportNull$$$0(128);
        }
        if (constraintName == null) {
            PostgresDialect.$$$reportNull$$$0(129);
        }
        if (columns2 == null) {
            PostgresDialect.$$$reportNull$$$0(130);
        }
        DialectUtils.getAddUniqueConstraintSQL(builder, table, constraint, constraintName, columns2);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(131);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(132);
        }
        if (column2 == null) {
            PostgresDialect.$$$reportNull$$$0(133);
        }
        SqlLanguageDialect language = DbSqlUtil.getSqlDialect(this);
        DasTable table = column2.getTable();
        String sequenceName = table.getName() + "_" + column2.getName() + "_seq";
        DasTable sequence = (DasTable)DialectUtils.withNewModel(Postgres.RDBMS, PostgresModModel.class, PostgresModRoot.class, root2 -> (PostgresModLocalTable)DialectUtils.create(((PostgresModSchema)DialectUtils.create(((PostgresModDatabase)DialectUtils.create(root2.getDatabases(), DasUtil.getCatalogObject((DasObject)table))).getSchemas(), DasUtil.getSchemaObject((DasObject)table))).getTables(), sequenceName));
        this.sqlCreateSequence(builder, sequence, "", "", "", "", "", false);
        builder.newStatement();
        builder.keyword("ALTER TABLE").space().qualifiedRef((DasObject)table).space();
        builder.keyword("ALTER COLUMN").space();
        builder.columnRef((DasObject)column2).space();
        String seq = builder.copied().qualifiedRef((DasObject)sequence).getStatement();
        builder.keyword("SET DEFAULT").space().ref(null, "nextval").symbol("(").literal(language.asStringLiteral(seq)).symbol(")");
        builder.newStatement();
        builder.keyword("ALTER SEQUENCE").space();
        builder.qualifiedRef((DasObject)sequence).space();
        builder.keywords("OWNED", "BY").space();
        builder.qualifiedRef((DasObject)table);
        builder.symbol(".");
        builder.columnRef((DasObject)column2);
        builder.newStatement();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(134);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(135);
        }
        if (table == null) {
            PostgresDialect.$$$reportNull$$$0(136);
        }
        if (constraintName == null) {
            PostgresDialect.$$$reportNull$$$0(137);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropConstraintSQL(builder, table, constraint, constraintName);
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(138);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection) throws Exception {
        if (table == null) {
            PostgresDialect.$$$reportNull$$$0(139);
        }
        if (connection == null) {
            PostgresDialect.$$$reportNull$$$0(140);
        }
        String string = PostgresDialectHelper.getTableDefinition(table, connection);
        if (string == null) {
            PostgresDialect.$$$reportNull$$$0(141);
        }
        return string;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnection connection) throws Exception {
        if (element == null) {
            PostgresDialect.$$$reportNull$$$0(142);
        }
        if (connection == null) {
            PostgresDialect.$$$reportNull$$$0(143);
        }
        Map<String, Object> map = DbImplUtil.resultRowAsMap(connection, String.format("SELECT CAST(reltuples as INT) as rows FROM pg_catalog.pg_class C\n  LEFT JOIN pg_catalog.pg_namespace N ON (N.oid = C.relnamespace)\nWHERE (relkind = 'r' OR relkind = 'v') AND nspname LIKE '%s' ESCAPE '#' AND relname LIKE '%s' ESCAPE '#'", DbImplUtil.escapeSql(DasUtil.getSchema((DasObject)element), true, this), DbImplUtil.escapeSql(element.getName(), true, this)), new String[0]);
        if (map == null) {
            PostgresDialect.$$$reportNull$$$0(144);
        }
        return map;
    }

    @Override
    public boolean supportsSearchPath() {
        return true;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection) throws SQLException {
        if (system == null) {
            PostgresDialect.$$$reportNull$$$0(145);
        }
        if (connection == null) {
            PostgresDialect.$$$reportNull$$$0(146);
        }
        Map<String, Object> map = DbImplUtil.resultRowAsMap(connection, "select current_database() as a, current_schemas(false) as b", new String[0]);
        String db = String.valueOf(map.get("a"));
        Object[] schemas = (Object[])ObjectUtils.tryCast((Object)map.get("b"), Object[].class);
        if (StringUtil.isEmpty((String)db) || schemas == null || schemas.length == 0) {
            return null;
        }
        ObjectPath dbPath = ObjectPath.create((String)db, (ObjectKind)ObjectKind.DATABASE);
        return SearchPath.of((List)JBIterable.of((Object[])schemas).filter(String.class).transform(s -> dbPath.append(s, ObjectKind.SCHEMA)).toList());
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            PostgresDialect.$$$reportNull$$$0(147);
        }
        if (path.getCurrent().kind != ObjectKind.SCHEMA) {
            return null;
        }
        DdlBuilder builder = new DdlBuilder().plain("set search_path = ").quoteIdentifiers(true);
        boolean first = true;
        for (ObjectPath e : path.elements) {
            if (!first) {
                builder.plain(", ");
            }
            first = false;
            builder.identifier(e.getName());
        }
        return builder.getStatement();
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column2, @NotNull Set<DasColumn.Attribute> attrs) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(148);
        }
        if (column2 == null) {
            PostgresDialect.$$$reportNull$$$0(149);
        }
        if (attrs == null) {
            PostgresDialect.$$$reportNull$$$0(150);
        }
        DialectUtils.getAddColumnSQL(builder, column2, true, true, true, DasUtil.isAutoGenerated((DasColumn)column2) ? PostgresDialect.getSerialType(column2, builder) : null);
        builder.newStatement();
        if (StringUtil.isNotEmpty((String)column2.getComment())) {
            this.sqlAlterColumnComment(builder, column2);
            builder.newStatement();
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(151);
        }
        return ddlBuilder;
    }

    public boolean supportsAddColumn() {
        return true;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            PostgresDialect.$$$reportNull$$$0(152);
        }
        return Pair.create((Object)("select view_definition from information_schema.views where table_schema = '" + DasUtil.getSchema((DasObject)element) + "' and table_name = '" + element.getName() + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            PostgresDialect.$$$reportNull$$$0(153);
        }
        Pair pair = Pair.create((Object)("select routine_definition from information_schema.routines where routine_schema = '" + DasUtil.getSchema((DasObject)element) + "' and routine_name = '" + element.getName() + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            PostgresDialect.$$$reportNull$$$0(154);
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadProcedureDefinition(@NotNull DasRoutine proc, @NotNull DatabaseConnection connection) throws Exception {
        Version curVersion;
        DdlBuilder builder;
        block27: {
            String string;
            if (proc == null) {
                PostgresDialect.$$$reportNull$$$0(155);
            }
            if (connection == null) {
                PostgresDialect.$$$reportNull$$$0(156);
            }
            DatabaseMetaData md = (DatabaseMetaData)ObjectUtils.assertNotNull((Object)connection.getMetaData());
            builder = new DdlBuilder().withDialect(this).qualifyReferences(true);
            curVersion = Version.of((int[])new int[]{md.getDatabaseMajorVersion(), md.getDatabaseMinorVersion()});
            try {
                if (!curVersion.isOrGreater(new int[]{8, 4})) break block27;
                string = DbImplUtil.concatStringResults(connection, this, "SELECT pg_get_functiondef(p.oid) FROM pg_proc p JOIN pg_namespace n ON n.oid=pronamespace WHERE proname = " + PostgresDialectHelper.str(proc.getName()) + " AND nspname = " + PostgresDialectHelper.str(DasUtil.getSchema((DasObject)proc)), 0, DbImplUtil.ConcatenationProps.LINES);
            }
            catch (Exception e) {
                Logger.getInstance(this.getClass()).info((Throwable)e);
            }
            if (string == null) {
                PostgresDialect.$$$reportNull$$$0(157);
            }
            return string;
        }
        boolean isPre81 = Version.of((int[])new int[]{8, 0}).isOrGreater(curVersion);
        int limit = Math.max(10, Iterables.size((Iterable)proc.getArguments())) + 5;
        String s = "SELECT proname, proisagg, prosecdef, proisstrict, proretset, provolatile, pronargs, prosrc, probin,\n       lanname, \n" + PostgresDialectHelper.typeArg("tr", "rettype", "prorettype", isPre81) + ",\n" + PostgresDialectHelper.select(limit, isPre81) + "\n       " + (isPre81 ? "null dummy" : "proargmodes, pg_catalog.pg_get_expr(proargdefaults, 0) as proargdefaults") + "\n  FROM pg_proc\n  JOIN pg_namespace nsp ON nsp.oid=pronamespace\n  JOIN pg_language l ON l.oid=prolang\n" + PostgresDialectHelper.joinType("tr", "prorettype", isPre81) + "\n" + PostgresDialectHelper.join(limit, isPre81) + "  WHERE proname = " + PostgresDialectHelper.str(proc.getName()) + " AND nsp.nspname = " + PostgresDialectHelper.str(DasUtil.getSchema((DasObject)proc)) + "\n";
        try (ClosableResultsProducer producer = SmartStatements.poweredBy(connection).simple().noisy().execute(s, StandardExecutionMode.QUERY);){
            ResultSet rs;
            ResultSet resultSet = rs = producer.advance() ? producer.processCurrent(StandardResultsProcessors.RESULT_SET) : null;
            while (rs != null && rs.next()) {
                builder.keywords("CREATE", "OR", "REPLACE", "FUNCTION").space().qualifiedRef((DasObject)proc).symbol("(");
                PostgresDialectHelper.SignatureBuilder signatureBuilder = new PostgresDialectHelper.SignatureBuilder(isPre81, rs);
                signatureBuilder.buildArguments(builder);
                builder.symbol(")").newLine().space(2).keyword("RETURNS").space();
                signatureBuilder.buildReturn(builder);
                String language = rs.getString("lanname");
                String src = ((String)ObjectUtils.notNull((Object)rs.getString("prosrc"), (Object)"")).trim();
                if ("c".equals(language)) {
                    builder.newLine().keyword("AS").newLine().symbol("'").plain(rs.getString("probin")).symbol("'").symbol(",").space().symbol("'").plain(src).symbol("'");
                } else {
                    builder.newLine().keyword("AS").newLine().plain("$BODY$").newLine().plain(src).newLine().plain("$BODY$").newLine().keyword("LANGUAGE").space().plain(language).space();
                }
                String provolatile = rs.getString("provolatile");
                if ("v".equals(provolatile)) {
                    builder.keyword("VOLATILE");
                } else if ("i".equals(provolatile)) {
                    builder.keyword("IMMUTABLE");
                } else {
                    builder.keyword("STABLE");
                }
                if (rs.getBoolean("proisstrict")) {
                    builder.space().keyword("STRICT");
                }
                if (rs.getBoolean("prosecdef")) {
                    builder.space().keyword("SECURITY DEFINER");
                }
                builder.newStatement();
            }
        }
        String string = builder.getStatement();
        if (string == null) {
            PostgresDialect.$$$reportNull$$$0(158);
        }
        return string;
    }

    @Override
    public boolean supportsSequenceDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSequenceDefinition(@NotNull DasObject element) {
        if (element == null) {
            PostgresDialect.$$$reportNull$$$0(159);
        }
        DdlBuilder builder = new DdlBuilder().withDialect(this).qualifyReferences(true);
        Pair pair = Pair.create((Object)("select\n  'CREATE SEQUENCE ' || '" + DasUtil.getSchema((DasObject)element) + "' || '.'   || sequence_name\n  || ' INCREMENT BY ' || increment_by\n  || ' MINVALUE ' || min_value\n  || ' MAXVALUE ' || max_value\n  || ' START ' || start_value\n  || ' CACHE ' || cache_value\n  || case when is_cycled then ' CYCLE' else '' end\n  || ';'\nfrom " + builder.qualifiedRef(element).getStatement()), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            PostgresDialect.$$$reportNull$$$0(160);
        }
        return pair;
    }

    @Override
    public boolean supportsQualifiedAsteriskInCalls() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefinePrototype(@NotNull DdlBuilder builder, @NotNull DasRoutine routine, boolean longMode, boolean withReturn) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(161);
        }
        if (routine == null) {
            PostgresDialect.$$$reportNull$$$0(162);
        }
        JBIterable parameters = DasUtil.getParameters((DasRoutine)routine);
        boolean returnsTypeExplicit = false;
        String returnsTypeSpec = null;
        DasArgument returnArg = routine.getReturnArgument();
        if (returnArg != null) {
            returnsTypeExplicit = true;
            returnsTypeSpec = returnArg.getDataType().getSpecification();
        }
        int outs2 = 0;
        for (DasArgument parameter : parameters) {
            if (!parameter.getArgumentDirection().isOut()) continue;
            ++outs2;
        }
        builder.symbol("(");
        boolean first = true;
        for (DasArgument parameter : parameters) {
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            DasArgument.Direction argumentDirection = parameter.getArgumentDirection();
            if (longMode || !argumentDirection.isIn()) {
                if (StringUtil.isNotEmpty((String)parameter.getName())) {
                    builder.identifier((DasObject)parameter, parameter.getName()).space();
                }
                if (argumentDirection.isOut()) {
                    if (argumentDirection.isIn()) {
                        builder.keyword("in").space();
                    }
                    builder.keyword("out").space();
                }
            }
            builder.type((DasTypedObject)parameter);
        }
        builder.symbol(")");
        if (!returnsTypeExplicit) {
            if (outs2 == 1) {
                for (DasArgument parameter : parameters) {
                    if (!parameter.getArgumentDirection().isOut()) continue;
                    returnsTypeSpec = parameter.getDataType().getSpecification();
                }
            } else {
                returnsTypeSpec = "record";
            }
        }
        if (returnsTypeExplicit && withReturn && StringUtil.isNotEmpty((String)returnsTypeSpec)) {
            if (longMode) {
                builder.space().keyword("returns").space();
            } else {
                builder.plain(": ");
            }
            builder.type(returnsTypeSpec);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(163);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine routine) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(164);
        }
        if (routine == null) {
            PostgresDialect.$$$reportNull$$$0(165);
        }
        builder.keywords("create", "function").space().qualifiedRef((DasObject)routine);
        DdlBuilder ddlBuilder = this.sqlDefinePrototype(builder, routine, true, true);
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(166);
        }
        return ddlBuilder;
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        char c0;
        if (identifier == null) {
            PostgresDialect.$$$reportNull$$$0(167);
        }
        if (!Character.isLetter(c0 = identifier.charAt(0)) && c0 != '_') {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 1; i2 < len; ++i2) {
            char c = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '$' || c == '#') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            PostgresDialect.$$$reportNull$$$0(168);
        }
        if (qualifier == null) {
            PostgresDialect.$$$reportNull$$$0(169);
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), null, null, null, null);
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(170);
        }
        return ddlBuilder;
    }

    public boolean supportsCorrelatedSubQuery() {
        return false;
    }

    @Override
    public int getJavaTypeForNativeType(@NotNull String nativeColumnTypeName) {
        if (nativeColumnTypeName == null) {
            PostgresDialect.$$$reportNull$$$0(171);
        }
        if ("character_data".equalsIgnoreCase(nativeColumnTypeName)) {
            return 1;
        }
        if ("cardinal_number".equalsIgnoreCase(nativeColumnTypeName)) {
            return 4;
        }
        if ("xml".equalsIgnoreCase(nativeColumnTypeName)) {
            return 12;
        }
        return super.getJavaTypeForNativeType(nativeColumnTypeName);
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze2) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(172);
        }
        if (statement == null) {
            PostgresDialect.$$$reportNull$$$0(173);
        }
        builder.keywords("explain").space();
        if (analyze2) {
            builder.keyword("analyze").space();
        }
        builder.plain(statement);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(174);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return true;
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnection connection) throws SQLException {
        if (connection == null) {
            PostgresDialect.$$$reportNull$$$0(175);
        }
        List<String> list = DbImplUtil.executeAndGetResult(connection, "SELECT datname as name FROM pg_database WHERE datistemplate = false", DbImplUtil.RS_AS_STRING_LIST);
        if (list == null) {
            PostgresDialect.$$$reportNull$$$0(176);
        }
        return list;
    }

    @Override
    public boolean hasRowId(@Nullable DasDataSource system) {
        return system != null && system.getFamilyId() != DatabaseFamilyId.REDSHIFT;
    }

    @Override
    @NotNull
    protected DdlBuilder appendRowId(@NotNull DdlBuilder builder, @Nullable DasDataSource system) {
        if (builder == null) {
            PostgresDialect.$$$reportNull$$$0(177);
        }
        DdlBuilder ddlBuilder = builder.symbol(",").space().literal("CTID");
        if (ddlBuilder == null) {
            PostgresDialect.$$$reportNull$$$0(178);
        }
        return ddlBuilder;
    }

    @Override
    @Nullable
    public DatabaseDialectEx.VersionParser getVersionParser() {
        return com.intellij.openapi.util.Version::parseVersion;
    }

    @Override
    @Nullable
    public String sqlResetSearchPath() {
        return "set search_path to default";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 119: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 137: 
            case 139: 
            case 140: 
            case 142: 
            case 143: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 152: 
            case 153: 
            case 155: 
            case 156: 
            case 159: 
            case 161: 
            case 162: 
            case 164: 
            case 165: 
            case 167: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 173: 
            case 175: 
            case 177: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 119: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 137: 
            case 139: 
            case 140: 
            case 142: 
            case 143: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 152: 
            case 153: 
            case 155: 
            case 156: 
            case 159: 
            case 161: 
            case 162: 
            case 164: 
            case 165: 
            case 167: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 173: 
            case 175: 
            case 177: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/PostgresDialect";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseProductVersion";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 25: 
            case 28: 
            case 31: 
            case 34: 
            case 38: 
            case 42: 
            case 45: 
            case 48: 
            case 51: 
            case 54: 
            case 57: 
            case 60: 
            case 64: 
            case 69: 
            case 73: 
            case 76: 
            case 79: 
            case 82: 
            case 85: 
            case 91: 
            case 98: 
            case 102: 
            case 110: 
            case 118: 
            case 121: 
            case 124: 
            case 127: 
            case 132: 
            case 135: 
            case 148: 
            case 161: 
            case 164: 
            case 172: 
            case 177: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: 
            case 12: 
            case 29: 
            case 32: 
            case 43: 
            case 133: 
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 15: 
            case 61: 
            case 99: 
            case 128: 
            case 136: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 26: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pk";
                break;
            }
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toName";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procedure";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trigger";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
            case 62: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 65: 
            case 70: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkOption";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collation";
                break;
            }
            case 80: 
            case 83: 
            case 86: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessMethod";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tablespace";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 103: 
            case 111: 
            case 119: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 104: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "increment";
                break;
            }
            case 105: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimum";
                break;
            }
            case 106: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maximum";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 108: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restart";
                break;
            }
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyInfo";
                break;
            }
            case 129: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintName";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 140: 
            case 143: 
            case 146: 
            case 156: 
            case 175: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 142: 
            case 152: 
            case 153: 
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proc";
                break;
            }
            case 162: 
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 167: 
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 171: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeColumnTypeName";
                break;
            }
            case 173: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDdlOperations";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 119: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 137: 
            case 139: 
            case 140: 
            case 142: 
            case 143: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 152: 
            case 153: 
            case 155: 
            case 156: 
            case 159: 
            case 161: 
            case 162: 
            case 164: 
            case 165: 
            case 167: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 173: 
            case 175: 
            case 177: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/PostgresDialect";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropColumn";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineColumn";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropTable";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddPrimaryKey";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnComment";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnNullable";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnName";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnType";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnDefault";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropPrimaryKey";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropProcedure";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropTrigger";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropRule";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropOperator";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameTable";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateView";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameView";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropCollation";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropForeignDataWrapper";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropForeignServer";
                break;
            }
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropUserMapping";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateIndex";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropIndex";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateSequence";
                break;
            }
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterSequence";
                break;
            }
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlSequenceInformation";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropSequence";
                break;
            }
            case 126: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddForeignKey";
                break;
            }
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddUniqueConstraint";
                break;
            }
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 138: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropConstraint";
                break;
            }
            case 141: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 144: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 151: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddColumn";
                break;
            }
            case 154: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 157: 
            case 158: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadProcedureDefinition";
                break;
            }
            case 160: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlSequenceDefinition";
                break;
            }
            case 163: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefinePrototype";
                break;
            }
            case 166: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineProcedure";
                break;
            }
            case 170: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 174: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlExplainPlan";
                break;
            }
            case 176: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
            case 178: {
                objectArray = objectArray2;
                objectArray2[1] = "appendRowId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "supportsProduct";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropColumn";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineColumn";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSerialType";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropTable";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddPrimaryKey";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnComment";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnNullable";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnName";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnType";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnDefault";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropPrimaryKey";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropProcedure";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropTrigger";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropRule";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropOperator";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameTable";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameView";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropCollation";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropForeignDataWrapper";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropForeignServer";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropUserMapping";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "castToUserMapping";
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateIndex";
                break;
            }
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropIndex";
                break;
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateSequence";
                break;
            }
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterSequence";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceInformation";
                break;
            }
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddForeignKey";
                break;
            }
            case 127: 
            case 128: 
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddUniqueConstraint";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 135: 
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropConstraint";
                break;
            }
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 142: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 145: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 148: 
            case 149: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumn";
                break;
            }
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 155: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadProcedureDefinition";
                break;
            }
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceDefinition";
                break;
            }
            case 161: 
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefinePrototype";
                break;
            }
            case 164: 
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineProcedure";
                break;
            }
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 168: 
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "getJavaTypeForNativeType";
                break;
            }
            case 172: 
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "appendRowId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 119: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 137: 
            case 139: 
            case 140: 
            case 142: 
            case 143: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 152: 
            case 153: 
            case 155: 
            case 156: 
            case 159: 
            case 161: 
            case 162: 
            case 164: 
            case 165: 
            case 167: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 173: 
            case 175: 
            case 177: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

