/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.google.common.collect.Iterables;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.AbstractDatabaseDialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.BasicMetaModel;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasOperator;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.redshift.RedshiftMetaModel;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.vendors.postgres.PostgresDialectHelper;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.JBIterable;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.util.Version;

public class RedshiftDialect
extends AbstractDatabaseDialect
implements DatabaseDialect,
AbstractDatabaseDialect.SplitAlterColumnSupport {
    private static final int FRACTIONAL_SECONDS_PRECISION_MAX = 6;
    public static final RedshiftDialect INSTANCE = new RedshiftDialect();

    protected RedshiftDialect() {
        super(new TypeHelper.PostgresTypeHelper(), new KeywordHelper.PostgresKeywords(), BasicNamespace.LOWER_CASING);
    }

    @Override
    @NotNull
    public MetaModel getMetaModel() {
        BasicMetaModel basicMetaModel = RedshiftMetaModel.MODEL;
        if (basicMetaModel == null) {
            RedshiftDialect.$$$reportNull$$$0(0);
        }
        return basicMetaModel;
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.REDSHIFT;
        if (databaseFamilyId == null) {
            RedshiftDialect.$$$reportNull$$$0(1);
        }
        return databaseFamilyId;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.Redshift;
        if (icon == null) {
            RedshiftDialect.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("Redshift" == null) {
            RedshiftDialect.$$$reportNull$$$0(3);
        }
        return "Redshift";
    }

    @Override
    public boolean supportsSchemasInTableDefinition() {
        return true;
    }

    @Override
    public boolean supportsColumnCommentsInTableDefinition() {
        return false;
    }

    @Override
    protected boolean isNameFriendlyCharacter(char ch) {
        return ch == '_' || ch == '$';
    }

    @Override
    @Nullable
    public String getNameForKind(@NotNull ObjectKind kind) {
        if (kind == null) {
            RedshiftDialect.$$$reportNull$$$0(4);
        }
        return kind == ObjectKind.FOREIGN_TABLE ? "EXTERNAL TABLE" : super.getNameForKind(kind);
    }

    @Override
    @NotNull
    protected DdlOperations getDdlOperations() {
        DdlOperations ddlOperations = new DasDdlOperations.DefaultDdlOperationsBuilder(this).build();
        if (ddlOperations == null) {
            RedshiftDialect.$$$reportNull$$$0(5);
        }
        return ddlOperations;
    }

    @Override
    public boolean supportsTableComment() {
        return true;
    }

    @Override
    public String getBinaryLiteralString(@NotNull byte[] binaryData) {
        if (binaryData == null) {
            RedshiftDialect.$$$reportNull$$$0(6);
        }
        return "E'\\\\x" + DialectUtils.toHexString(binaryData) + "'";
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            RedshiftDialect.$$$reportNull$$$0(7);
        }
        if (databaseProductName == null) {
            return false;
        }
        return databaseProductName.trim().toLowerCase(Locale.ENGLISH).startsWith("postgresql");
    }

    public boolean supportsColumnComment() {
        return true;
    }

    @Override
    public boolean supportsDropColumn() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(8);
        }
        if (column2 == null) {
            RedshiftDialect.$$$reportNull$$$0(9);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDropSQL(builder, column2);
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(10);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineColumn(@NotNull DdlBuilder builder, DasColumn column2, boolean singlePk) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(11);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDefinitionSQL(builder, column2, singlePk);
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(12);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsDropRule() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTable(@NotNull DdlBuilder builder, @NotNull DasTable table, boolean cascadeConstraints, boolean isMaterializedView, @NotNull DasModel model) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(13);
        }
        if (table == null) {
            RedshiftDialect.$$$reportNull$$$0(14);
        }
        if (model == null) {
            RedshiftDialect.$$$reportNull$$$0(15);
        }
        DdlBuilder ddlBuilder = DialectUtils.getTableDropSQL(builder, table, true, cascadeConstraints, false, "CASCADE", false);
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(16);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            RedshiftDialect.$$$reportNull$$$0(17);
        }
        if (dataType.jdbcType == 0) {
            String string = dataType.getSpecification();
            if (string == null) {
                RedshiftDialect.$$$reportNull$$$0(18);
            }
            return string;
        }
        String typeName = dataType.typeName;
        int jdbcType = dataType.jdbcType;
        if (jdbcType == -7 && "bool".equals(typeName)) {
            if ("bool" == null) {
                RedshiftDialect.$$$reportNull$$$0(19);
            }
            return "bool";
        }
        if (jdbcType == -5 && "oid".equals(typeName)) {
            if ("oid" == null) {
                RedshiftDialect.$$$reportNull$$$0(20);
            }
            return "oid";
        }
        if (jdbcType == 93 || jdbcType == 92) {
            int fractionalSecondsPrecision = dataType.getScale();
            String string = JdbcUtil.getJdbcTypeName((DataType)dataType, (boolean)false) + (fractionalSecondsPrecision != 6 ? "(" + fractionalSecondsPrecision + ")" : "");
            if (string == null) {
                RedshiftDialect.$$$reportNull$$$0(21);
            }
            return string;
        }
        if (jdbcType == 2) {
            String string = "numeric" + (dataType.getLength() == 131089 ? "" : "(" + dataType.getPrecision() + (dataType.getScale() == 0 ? "" : ", " + dataType.getScale()) + ")");
            if (string == null) {
                RedshiftDialect.$$$reportNull$$$0(22);
            }
            return string;
        }
        String string = super.getTypeName(dataType);
        if (string == null) {
            RedshiftDialect.$$$reportNull$$$0(23);
        }
        return string;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(24);
        }
        if (pk == null) {
            RedshiftDialect.$$$reportNull$$$0(25);
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddPrimaryKeySQL(builder, pk, false);
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(26);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnComment(@NotNull DdlBuilder builder, @NotNull DasColumn column2) throws UnsupportedOperationException {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(27);
        }
        if (column2 == null) {
            RedshiftDialect.$$$reportNull$$$0(28);
        }
        builder.suppressQuoteConstraints(true);
        DdlBuilder ddlBuilder = DialectUtils.getColumnCommentAlterSQL(builder, column2, this.isCommentDroppedByNull(), DbSqlUtil.getSqlDialect(this)).suppressQuoteConstraints(false);
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(29);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnNullable(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(30);
        }
        if (column2 == null) {
            RedshiftDialect.$$$reportNull$$$0(31);
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)column2.getTable());
        builder.space().keywords("ALTER", "COLUMN").space();
        builder.columnRef((DasObject)column2).space();
        builder.keyword(!column2.isNotNull() ? "DROP" : "SET").space().keyword("NOT").space().keyword("NULL");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(32);
        }
        return ddlBuilder;
    }

    public boolean supportsRenameColumn() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnName(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull String toName) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(33);
        }
        if (from == null) {
            RedshiftDialect.$$$reportNull$$$0(34);
        }
        if (toName == null) {
            RedshiftDialect.$$$reportNull$$$0(35);
        }
        String alterClause = "RENAME COLUMN";
        String toClause = "TO";
        DdlBuilder ddlBuilder = DialectUtils.getColumnNameAlterSQL(builder, from, toName, alterClause, toClause);
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(36);
        }
        return ddlBuilder;
    }

    public boolean supportsAlterColumnType() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnType(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to) throws UnsupportedOperationException {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(37);
        }
        if (from == null) {
            RedshiftDialect.$$$reportNull$$$0(38);
        }
        if (to == null) {
            RedshiftDialect.$$$reportNull$$$0(39);
        }
        throw new UnsupportedOperationException("Alter column type is not supported by Redshift");
    }

    public boolean supportsAlterColumnNull() {
        return true;
    }

    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefault(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(40);
        }
        if (column2 == null) {
            RedshiftDialect.$$$reportNull$$$0(41);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDefaultAlterOrDropSQL(builder, column2);
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(42);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(43);
        }
        if (pk == null) {
            RedshiftDialect.$$$reportNull$$$0(44);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropPrimaryKeySQL(builder, pk, true, false);
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(45);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine procedure) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(46);
        }
        if (procedure == null) {
            RedshiftDialect.$$$reportNull$$$0(47);
        }
        String type = procedure.getRoutineKind().name();
        builder.keyword("DROP").space().keyword(type);
        builder.space();
        builder.qualifiedRef((DasObject)procedure).symbol("(");
        boolean first = true;
        for (DasArgument arg : DasUtil.getParameters((DasRoutine)procedure)) {
            DasArgument.Direction direction = arg.getArgumentDirection();
            if (direction != DasArgument.Direction.IN && direction != DasArgument.Direction.INOUT) continue;
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            builder.type((DasTypedObject)arg);
        }
        builder.symbol(")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(48);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTrigger(@NotNull DdlBuilder builder, @NotNull DasTrigger trigger) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(49);
        }
        if (trigger == null) {
            RedshiftDialect.$$$reportNull$$$0(50);
        }
        throw new UnsupportedOperationException("Drop trigger is not supported by Redshift");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropRule(@NotNull DdlBuilder builder, @NotNull DasTableChild rule) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(51);
        }
        if (rule == null) {
            RedshiftDialect.$$$reportNull$$$0(52);
        }
        throw new UnsupportedOperationException("Drop rule is not supported by Redshift");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropOperator(@NotNull DdlBuilder builder, @NotNull DasOperator operator) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(53);
        }
        if (operator == null) {
            RedshiftDialect.$$$reportNull$$$0(54);
        }
        throw new UnsupportedOperationException("Drop operator is not supported by Redshift");
    }

    @Override
    public boolean supportsCreateDatabase() {
        return true;
    }

    public boolean supportsSequence() {
        return false;
    }

    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    public boolean supportsIndexes() {
        return false;
    }

    public boolean supportsTablespace() {
        return false;
    }

    public boolean supportsAccessMethods() {
        return true;
    }

    public boolean supportsDropView() {
        return true;
    }

    public boolean supportsRenameView() {
        return true;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return false;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    public boolean supportsMultipleRowInserts() {
        return true;
    }

    public boolean supportsAddForeignKey() {
        return true;
    }

    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    public boolean supportsAlterSequence() {
        return false;
    }

    public boolean supportsCreateIndex() {
        return false;
    }

    public boolean supportsCreateSequence() {
        return false;
    }

    @Override
    public boolean supportsCreateTable() {
        return true;
    }

    @Override
    public boolean supportsDropMaterializedView() {
        return false;
    }

    @Override
    public boolean supportsDropOperator() {
        return false;
    }

    @Override
    public boolean supportsDropType() {
        return true;
    }

    @Override
    public boolean supportsDropSchema() {
        return true;
    }

    public boolean supportsCreateView() {
        return true;
    }

    public boolean supportsDropConstraint() {
        return true;
    }

    public boolean supportsDropIndex() {
        return false;
    }

    public boolean supportsDropSequence() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    public boolean supportsRenameTable() {
        return true;
    }

    public boolean supportsSequenceInformation() {
        return false;
    }

    public String[] getIndexAccessMethodsTypes() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public String[] getIndexStorageOptions() {
        return null;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameTable(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull String newName) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(55);
        }
        if (table == null) {
            RedshiftDialect.$$$reportNull$$$0(56);
        }
        if (newName == null) {
            RedshiftDialect.$$$reportNull$$$0(57);
        }
        builder.keyword("ALTER TABLE").space();
        builder.qualifiedRef((DasObject)table);
        builder.space().keywords("RENAME", "TO").space();
        builder.newName(newName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(58);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(59);
        }
        if (view == null) {
            RedshiftDialect.$$$reportNull$$$0(60);
        }
        if (definition == null) {
            RedshiftDialect.$$$reportNull$$$0(61);
        }
        if (checkOption == null) {
            RedshiftDialect.$$$reportNull$$$0(62);
        }
        builder.keywords("CREATE", "OR", "REPLACE", "VIEW").space().qualifiedRef((DasObject)view).space().keyword("AS").space().plain(definition);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(63);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String newName) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(64);
        }
        if (view == null) {
            RedshiftDialect.$$$reportNull$$$0(65);
        }
        if (newName == null) {
            RedshiftDialect.$$$reportNull$$$0(66);
        }
        DdlBuilder ddlBuilder = this.sqlRenameTable(builder, view, newName);
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(67);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(68);
        }
        if (view == null) {
            RedshiftDialect.$$$reportNull$$$0(69);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL(builder, view, cascade);
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(70);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateIndex(@NotNull DdlBuilder builder, @NotNull DasIndex index2, @NotNull String accessMethod, @NotNull String tablespace, @NotNull String constraints) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(71);
        }
        if (index2 == null) {
            RedshiftDialect.$$$reportNull$$$0(72);
        }
        if (accessMethod == null) {
            RedshiftDialect.$$$reportNull$$$0(73);
        }
        if (tablespace == null) {
            RedshiftDialect.$$$reportNull$$$0(74);
        }
        if (constraints == null) {
            RedshiftDialect.$$$reportNull$$$0(75);
        }
        throw new UnsupportedOperationException("Create index is not supported by Redshift");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropIndex(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasIndex index2, @NotNull String indexName, boolean cascade) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(76);
        }
        if (table == null) {
            RedshiftDialect.$$$reportNull$$$0(77);
        }
        if (indexName == null) {
            RedshiftDialect.$$$reportNull$$$0(78);
        }
        throw new UnsupportedOperationException("Drop index is not supported by Redshift");
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String start, @NotNull String cache2, boolean cycle) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(79);
        }
        if (sequence == null) {
            RedshiftDialect.$$$reportNull$$$0(80);
        }
        if (increment == null) {
            RedshiftDialect.$$$reportNull$$$0(81);
        }
        if (minimum == null) {
            RedshiftDialect.$$$reportNull$$$0(82);
        }
        if (maximum == null) {
            RedshiftDialect.$$$reportNull$$$0(83);
        }
        if (start == null) {
            RedshiftDialect.$$$reportNull$$$0(84);
        }
        if (cache2 == null) {
            RedshiftDialect.$$$reportNull$$$0(85);
        }
        throw new UnsupportedOperationException("Create sequence is not supported by Redshift");
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String restart, @NotNull String cache2, boolean cycle) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(86);
        }
        if (sequence == null) {
            RedshiftDialect.$$$reportNull$$$0(87);
        }
        if (increment == null) {
            RedshiftDialect.$$$reportNull$$$0(88);
        }
        if (minimum == null) {
            RedshiftDialect.$$$reportNull$$$0(89);
        }
        if (maximum == null) {
            RedshiftDialect.$$$reportNull$$$0(90);
        }
        if (restart == null) {
            RedshiftDialect.$$$reportNull$$$0(91);
        }
        if (cache2 == null) {
            RedshiftDialect.$$$reportNull$$$0(92);
        }
        throw new UnsupportedOperationException("Alter sequence is not supported by Redshift");
    }

    @Override
    @NotNull
    public DdlBuilder sqlSequenceInformation(@NotNull DdlBuilder builder, @NotNull DasTable sequence) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(93);
        }
        if (sequence == null) {
            RedshiftDialect.$$$reportNull$$$0(94);
        }
        throw new UnsupportedOperationException("Sequence information is not supported by Redshift");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(95);
        }
        if (sequence == null) {
            RedshiftDialect.$$$reportNull$$$0(96);
        }
        throw new UnsupportedOperationException("Drop sequence is not supported by Redshift");
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddForeignKey(@NotNull DdlBuilder builder, @NotNull DasForeignKey keyInfo, boolean matchFull, boolean autoFKIndex) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(97);
        }
        if (keyInfo == null) {
            RedshiftDialect.$$$reportNull$$$0(98);
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddForeignKeyConstraintSQL(builder, keyInfo, matchFull, autoFKIndex, this);
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(99);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddUniqueConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName, @NotNull List<DasColumn> columns2) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(100);
        }
        if (table == null) {
            RedshiftDialect.$$$reportNull$$$0(101);
        }
        if (constraintName == null) {
            RedshiftDialect.$$$reportNull$$$0(102);
        }
        if (columns2 == null) {
            RedshiftDialect.$$$reportNull$$$0(103);
        }
        DialectUtils.getAddUniqueConstraintSQL(builder, table, constraint, constraintName, columns2);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(104);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(105);
        }
        if (column2 == null) {
            RedshiftDialect.$$$reportNull$$$0(106);
        }
        throw new UnsupportedOperationException("Add autoincrement is not supported by Redshift");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(107);
        }
        if (table == null) {
            RedshiftDialect.$$$reportNull$$$0(108);
        }
        if (constraintName == null) {
            RedshiftDialect.$$$reportNull$$$0(109);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropConstraintSQL(builder, table, constraint, constraintName);
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(110);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection) throws Exception {
        if (table == null) {
            RedshiftDialect.$$$reportNull$$$0(111);
        }
        if (connection == null) {
            RedshiftDialect.$$$reportNull$$$0(112);
        }
        String string = PostgresDialectHelper.getTableDefinition(table, connection);
        if (string == null) {
            RedshiftDialect.$$$reportNull$$$0(113);
        }
        return string;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnection connection) throws Exception {
        if (element == null) {
            RedshiftDialect.$$$reportNull$$$0(114);
        }
        if (connection == null) {
            RedshiftDialect.$$$reportNull$$$0(115);
        }
        Map<String, Object> map = DbImplUtil.resultRowAsMap(connection, String.format("SELECT CAST(reltuples as INT) as rows FROM pg_catalog.pg_class C\n  LEFT JOIN pg_catalog.pg_namespace N ON (N.oid = C.relnamespace)\nWHERE (relkind = 'r' OR relkind = 'v') AND nspname LIKE '%s' ESCAPE '#' AND relname LIKE '%s' ESCAPE '#'", DbImplUtil.escapeSql(DasUtil.getSchema((DasObject)element), true, this), DbImplUtil.escapeSql(element.getName(), true, this)), new String[0]);
        if (map == null) {
            RedshiftDialect.$$$reportNull$$$0(116);
        }
        return map;
    }

    @Override
    public boolean supportsSearchPath() {
        return true;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection) throws SQLException {
        if (system == null) {
            RedshiftDialect.$$$reportNull$$$0(117);
        }
        if (connection == null) {
            RedshiftDialect.$$$reportNull$$$0(118);
        }
        Map<String, Object> map = DbImplUtil.resultRowAsMap(connection, "select current_database() as a, current_schemas(false) as b", new String[0]);
        String db = String.valueOf(map.get("a"));
        Object[] schemas = (Object[])ObjectUtils.tryCast((Object)map.get("b"), Object[].class);
        if (StringUtil.isEmpty((String)db) || schemas == null || schemas.length == 0) {
            return null;
        }
        ObjectPath dbPath = ObjectPath.create((String)db, (ObjectKind)ObjectKind.DATABASE);
        return SearchPath.of((List)JBIterable.of((Object[])schemas).filter(String.class).transform(s -> dbPath.append(s, ObjectKind.SCHEMA)).toList());
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            RedshiftDialect.$$$reportNull$$$0(119);
        }
        if (path.getCurrent().kind != ObjectKind.SCHEMA) {
            return null;
        }
        DdlBuilder builder = new DdlBuilder().plain("set search_path = ").quoteIdentifiers(true);
        boolean first = true;
        for (ObjectPath e : path.elements) {
            if (!first) {
                builder.plain(", ");
            }
            first = false;
            builder.identifier(e.getName());
        }
        return builder.getStatement();
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column2, @NotNull Set<DasColumn.Attribute> attrs) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(120);
        }
        if (column2 == null) {
            RedshiftDialect.$$$reportNull$$$0(121);
        }
        if (attrs == null) {
            RedshiftDialect.$$$reportNull$$$0(122);
        }
        DialectUtils.getAddColumnSQL(builder, column2, true, true, true, DasUtil.isAutoGenerated((DasColumn)column2) ? "serial" : null);
        builder.newStatement();
        if (StringUtil.isNotEmpty((String)column2.getComment())) {
            this.sqlAlterColumnComment(builder, column2);
            builder.newStatement();
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(123);
        }
        return ddlBuilder;
    }

    public boolean supportsAddColumn() {
        return true;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            RedshiftDialect.$$$reportNull$$$0(124);
        }
        return Pair.create((Object)("select view_definition from information_schema.views where table_schema = '" + DasUtil.getSchema((DasObject)element) + "' and table_name = '" + element.getName() + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            RedshiftDialect.$$$reportNull$$$0(125);
        }
        Pair pair = Pair.create((Object)("select routine_definition from information_schema.routines where routine_schema = '" + DasUtil.getSchema((DasObject)element) + "' and routine_name = '" + element.getName() + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            RedshiftDialect.$$$reportNull$$$0(126);
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadProcedureDefinition(@NotNull DasRoutine proc, @NotNull DatabaseConnection connection) throws Exception {
        Version curVersion;
        DdlBuilder builder;
        block6: {
            String string;
            if (proc == null) {
                RedshiftDialect.$$$reportNull$$$0(127);
            }
            if (connection == null) {
                RedshiftDialect.$$$reportNull$$$0(128);
            }
            DatabaseMetaData md = (DatabaseMetaData)ObjectUtils.assertNotNull((Object)connection.getMetaData());
            builder = new DdlBuilder().withDialect(this).qualifyReferences(true);
            curVersion = Version.of((int[])new int[]{md.getDatabaseMajorVersion(), md.getDatabaseMinorVersion()});
            try {
                if (!curVersion.isOrGreater(new int[]{8, 4})) break block6;
                string = DbImplUtil.concatStringResults(connection, this, "SELECT pg_get_functiondef(p.oid) FROM pg_proc p JOIN pg_namespace n ON n.oid=pronamespace WHERE proname = " + PostgresDialectHelper.str(proc.getName()) + " AND nspname = " + PostgresDialectHelper.str(DasUtil.getSchema((DasObject)proc)), 0, DbImplUtil.ConcatenationProps.LINES);
            }
            catch (Exception e) {
                Logger.getInstance(this.getClass()).info((Throwable)e);
            }
            if (string == null) {
                RedshiftDialect.$$$reportNull$$$0(129);
            }
            return string;
        }
        boolean isPre81 = Version.of((int[])new int[]{8, 0}).isOrGreater(curVersion);
        int limit = Math.max(10, Iterables.size((Iterable)proc.getArguments())) + 5;
        String s = "SELECT proname, proisagg, prosecdef, proisstrict, proretset, provolatile, pronargs, prosrc, probin,\n       lanname, \n" + PostgresDialectHelper.typeArg("tr", "rettype", "prorettype", isPre81) + ",\n" + PostgresDialectHelper.select(limit, isPre81) + "\n       " + (isPre81 ? "null dummy" : "proargmodes, pg_catalog.pg_get_expr(proargdefaults, 0) as proargdefaults") + "\n  FROM pg_proc\n  JOIN pg_namespace nsp ON nsp.oid=pronamespace\n  JOIN pg_language l ON l.oid=prolang\n" + PostgresDialectHelper.joinType("tr", "prorettype", isPre81) + "\n" + PostgresDialectHelper.join(limit, isPre81) + "  WHERE proname = " + PostgresDialectHelper.str(proc.getName()) + " AND nsp.nspname = " + PostgresDialectHelper.str(DasUtil.getSchema((DasObject)proc)) + "\n";
        SmartStatements.poweredBy(connection).simple().noisy().execute(s, (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.results((ThrowableConsumer<ResultSet, Exception>)((ThrowableConsumer)rs -> {
            if (proc == null) {
                RedshiftDialect.$$$reportNull$$$0(148);
            }
            while (rs.next()) {
                builder.keywords("CREATE", "OR", "REPLACE", "FUNCTION").space().qualifiedRef((DasObject)proc).symbol("(");
                PostgresDialectHelper.SignatureBuilder signatureBuilder = new PostgresDialectHelper.SignatureBuilder(isPre81, (ResultSet)rs);
                signatureBuilder.buildArguments(builder);
                builder.symbol(")").newLine().space(2).keyword("RETURNS").space();
                signatureBuilder.buildReturn(builder);
                String language = rs.getString("lanname");
                String src = ((String)ObjectUtils.notNull((Object)rs.getString("prosrc"), (Object)"")).trim();
                if ("c".equals(language)) {
                    builder.newLine().keyword("AS").newLine().symbol("'").plain(rs.getString("probin")).symbol("'").symbol(",").space().symbol("'").plain(src).symbol("'");
                } else {
                    builder.newLine().keyword("AS").newLine().plain("$BODY$").newLine().plain(src).newLine().plain("$BODY$").newLine().keyword("LANGUAGE").space().plain(language).space();
                }
                String provolatile = rs.getString("provolatile");
                if ("v".equals(provolatile)) {
                    builder.keyword("VOLATILE");
                } else if ("i".equals(provolatile)) {
                    builder.keyword("IMMUTABLE");
                } else {
                    builder.keyword("STABLE");
                }
                if (rs.getBoolean("proisstrict")) {
                    builder.space().keyword("STRICT");
                }
                if (rs.getBoolean("prosecdef")) {
                    builder.space().keyword("SECURITY DEFINER");
                }
                builder.newStatement();
            }
        })));
        String string = builder.getStatement();
        if (string == null) {
            RedshiftDialect.$$$reportNull$$$0(130);
        }
        return string;
    }

    @Override
    public boolean supportsSequenceDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSequenceDefinition(@NotNull DasObject element) {
        if (element == null) {
            RedshiftDialect.$$$reportNull$$$0(131);
        }
        throw new UnsupportedOperationException("Sequence definition is not supported by Redshift");
    }

    @Override
    public boolean supportsQualifiedAsteriskInCalls() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefinePrototype(@NotNull DdlBuilder builder, @NotNull DasRoutine routine, boolean longMode, boolean withReturn) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(132);
        }
        if (routine == null) {
            RedshiftDialect.$$$reportNull$$$0(133);
        }
        JBIterable parameters = DasUtil.getParameters((DasRoutine)routine);
        boolean returnsTypeExplicit = false;
        String returnsTypeSpec = null;
        DasArgument returnArg = routine.getReturnArgument();
        if (returnArg != null) {
            returnsTypeExplicit = true;
            returnsTypeSpec = returnArg.getDataType().getSpecification();
        }
        int outs2 = 0;
        for (DasArgument parameter : parameters) {
            if (!parameter.getArgumentDirection().isOut()) continue;
            ++outs2;
        }
        builder.symbol("(");
        boolean first = true;
        for (DasArgument parameter : parameters) {
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            DasArgument.Direction argumentDirection = parameter.getArgumentDirection();
            if (longMode || !argumentDirection.isIn()) {
                if (StringUtil.isNotEmpty((String)parameter.getName())) {
                    builder.identifier((DasObject)parameter, parameter.getName()).space();
                }
                if (argumentDirection.isOut()) {
                    if (argumentDirection.isIn()) {
                        builder.keyword("in").space();
                    }
                    builder.keyword("out").space();
                }
            }
            builder.type((DasTypedObject)parameter);
        }
        builder.symbol(")");
        if (!returnsTypeExplicit) {
            if (outs2 == 1) {
                for (DasArgument parameter : parameters) {
                    if (!parameter.getArgumentDirection().isOut()) continue;
                    returnsTypeSpec = parameter.getDataType().getSpecification();
                }
            } else {
                returnsTypeSpec = "record";
            }
        }
        if (returnsTypeExplicit && withReturn && StringUtil.isNotEmpty((String)returnsTypeSpec)) {
            if (longMode) {
                builder.space().keyword("returns").space();
            } else {
                builder.plain(": ");
            }
            builder.type(returnsTypeSpec);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(134);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine routine) {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(135);
        }
        if (routine == null) {
            RedshiftDialect.$$$reportNull$$$0(136);
        }
        builder.keywords("create", "function").space().qualifiedRef((DasObject)routine);
        DdlBuilder ddlBuilder = this.sqlDefinePrototype(builder, routine, true, true);
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(137);
        }
        return ddlBuilder;
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        char c0;
        if (identifier == null) {
            RedshiftDialect.$$$reportNull$$$0(138);
        }
        if (!Character.isLetter(c0 = identifier.charAt(0)) && c0 != '_') {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 1; i2 < len; ++i2) {
            char c = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '$' || c == '#') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        DasObject schema;
        if (identifier == null) {
            RedshiftDialect.$$$reportNull$$$0(139);
        }
        if (qualifier == null) {
            RedshiftDialect.$$$reportNull$$$0(140);
        }
        DasObject schemaOrExternal = (schema = DasUtil.getSchemaObject((DasObject)qualifier)) == null ? DasUtil.getParentOfKind((DasObject)qualifier, (ObjectKind)ObjectKind.EXTERNAL_SCHEMA, (boolean)false) : schema;
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schemaOrExternal, DasUtil.getName((DasObject)schemaOrExternal), null, null, null, null);
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(141);
        }
        return ddlBuilder;
    }

    public boolean supportsCorrelatedSubQuery() {
        return false;
    }

    @Override
    public int getJavaTypeForNativeType(@NotNull String nativeColumnTypeName) {
        if (nativeColumnTypeName == null) {
            RedshiftDialect.$$$reportNull$$$0(142);
        }
        if ("character_data".equalsIgnoreCase(nativeColumnTypeName)) {
            return 1;
        }
        if ("cardinal_number".equalsIgnoreCase(nativeColumnTypeName)) {
            return 4;
        }
        if ("xml".equalsIgnoreCase(nativeColumnTypeName)) {
            return 12;
        }
        return super.getJavaTypeForNativeType(nativeColumnTypeName);
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze2) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            RedshiftDialect.$$$reportNull$$$0(143);
        }
        if (statement == null) {
            RedshiftDialect.$$$reportNull$$$0(144);
        }
        builder.keywords("explain").space();
        if (analyze2) {
            throw new UnsupportedOperationException("EXPLAIN ANALYZE is not supported by Redshift");
        }
        builder.plain(statement);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            RedshiftDialect.$$$reportNull$$$0(145);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return true;
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnection connection) throws SQLException {
        if (connection == null) {
            RedshiftDialect.$$$reportNull$$$0(146);
        }
        List<String> list = DbImplUtil.executeAndGetResult(connection, "SELECT datname as name FROM pg_database WHERE datistemplate = false", DbImplUtil.RS_AS_STRING_LIST);
        if (list == null) {
            RedshiftDialect.$$$reportNull$$$0(147);
        }
        return list;
    }

    @Override
    public boolean hasRowId(@Nullable DasDataSource system) {
        return false;
    }

    @Override
    @Nullable
    public DatabaseDialectEx.VersionParser getVersionParser() {
        return com.intellij.openapi.util.Version::parseVersion;
    }

    @Override
    @Nullable
    public String sqlResetSearchPath() {
        return "set search_path to default";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 127: 
            case 128: 
            case 131: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 140: 
            case 142: 
            case 143: 
            case 144: 
            case 146: 
            case 148: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 127: 
            case 128: 
            case 131: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 140: 
            case 142: 
            case 143: 
            case 144: 
            case 146: 
            case 148: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/RedshiftDialect";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseProductVersion";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 24: 
            case 27: 
            case 30: 
            case 33: 
            case 37: 
            case 40: 
            case 43: 
            case 46: 
            case 49: 
            case 51: 
            case 53: 
            case 55: 
            case 59: 
            case 64: 
            case 68: 
            case 71: 
            case 76: 
            case 79: 
            case 86: 
            case 93: 
            case 95: 
            case 97: 
            case 100: 
            case 105: 
            case 107: 
            case 120: 
            case 132: 
            case 135: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: 
            case 28: 
            case 31: 
            case 41: 
            case 106: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 14: 
            case 56: 
            case 77: 
            case 101: 
            case 108: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 25: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pk";
                break;
            }
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toName";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procedure";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trigger";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
            case 57: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 60: 
            case 65: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkOption";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessMethod";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tablespace";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 80: 
            case 87: 
            case 94: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 81: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "increment";
                break;
            }
            case 82: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimum";
                break;
            }
            case 83: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maximum";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 85: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restart";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyInfo";
                break;
            }
            case 102: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintName";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 112: 
            case 115: 
            case 118: 
            case 128: 
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 114: 
            case 124: 
            case 125: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 127: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proc";
                break;
            }
            case 133: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 138: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeColumnTypeName";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 127: 
            case 128: 
            case 131: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 140: 
            case 142: 
            case 143: 
            case 144: 
            case 146: 
            case 148: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/RedshiftDialect";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDdlOperations";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropColumn";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineColumn";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropTable";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddPrimaryKey";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnComment";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnNullable";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnName";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnDefault";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropPrimaryKey";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropProcedure";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameTable";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateView";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameView";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddForeignKey";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddUniqueConstraint";
                break;
            }
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropConstraint";
                break;
            }
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddColumn";
                break;
            }
            case 126: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadProcedureDefinition";
                break;
            }
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefinePrototype";
                break;
            }
            case 137: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineProcedure";
                break;
            }
            case 141: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 145: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlExplainPlan";
                break;
            }
            case 147: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNameForKind";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "supportsProduct";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropColumn";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineColumn";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropTable";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddPrimaryKey";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnComment";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnNullable";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnName";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnType";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnDefault";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropPrimaryKey";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropProcedure";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropTrigger";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropRule";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropOperator";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameTable";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameView";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateIndex";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropIndex";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateSequence";
                break;
            }
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterSequence";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceInformation";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddForeignKey";
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddUniqueConstraint";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropConstraint";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 120: 
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumn";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadProcedureDefinition";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceDefinition";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefinePrototype";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineProcedure";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "getJavaTypeForNativeType";
                break;
            }
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "lambda$tryToLoadProcedureDefinition$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 127: 
            case 128: 
            case 131: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 140: 
            case 142: 
            case 143: 
            case 144: 
            case 146: 
            case 148: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

