/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.AbstractDatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.BasicMetaModel;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicScriptable;
import com.intellij.database.model.sqlite.SqliteMetaModel;
import com.intellij.database.model.sqlite.SqliteModForeignKey;
import com.intellij.database.model.sqlite.SqliteModIndex;
import com.intellij.database.model.sqlite.SqliteModKey;
import com.intellij.database.model.sqlite.SqliteModModel;
import com.intellij.database.model.sqlite.SqliteModRoot;
import com.intellij.database.model.sqlite.SqliteModSchema;
import com.intellij.database.model.sqlite.SqliteModTable;
import com.intellij.database.model.sqlite.SqliteModTableColumn;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.operations.sqlite.SqliteDdlOperationsBuilder;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Sqlite;

public class SqliteDialect
extends AbstractDatabaseDialect
implements AbstractDatabaseDialect.SplitAlterColumnSupport {
    public static final SqliteDialect INSTANCE = new SqliteDialect();

    public SqliteDialect() {
        super(new TypeHelper.SQLiteTypeHelper(), new KeywordHelper.SqliteKeywords(), Casing.create((Case)Case.MIXED, (Case)Case.MIXED));
    }

    @Override
    @NotNull
    public MetaModel getMetaModel() {
        BasicMetaModel basicMetaModel = SqliteMetaModel.MODEL;
        if (basicMetaModel == null) {
            SqliteDialect.$$$reportNull$$$0(0);
        }
        return basicMetaModel;
    }

    @Override
    public boolean supportsColumnCommentsInTableDefinition() {
        return false;
    }

    @Override
    @NotNull
    protected DdlOperations getDdlOperations() {
        DdlOperations ddlOperations = new SqliteDdlOperationsBuilder(this).build();
        if (ddlOperations == null) {
            SqliteDialect.$$$reportNull$$$0(1);
        }
        return ddlOperations;
    }

    @Override
    @NotNull
    protected DatabaseEditorCapabilities.ColumnEditorCaps getColumnEditorCaps(boolean existing) {
        DatabaseEditorCapabilities.ColumnEditorCaps columnEditorCaps = new DatabaseEditorCapabilities.ColumnEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || this.supportsRenameColumn()), DatabaseEditorCapabilities.Capability.supported(this.supportsColumnComment()), DatabaseEditorCapabilities.Capability.available(!existing || this.supportsAlterColumnType()), DatabaseEditorCapabilities.Capability.AVAILABLE, DatabaseEditorCapabilities.Capability.available(!existing || this.supportsAlterColumnDefault()), DatabaseEditorCapabilities.Capability.available(!existing || this.supportsAlterColumnNull()));
        if (columnEditorCaps == null) {
            SqliteDialect.$$$reportNull$$$0(2);
        }
        return columnEditorCaps;
    }

    @NotNull
    public String getDisplayName() {
        if ("SQLite" == null) {
            SqliteDialect.$$$reportNull$$$0(3);
        }
        return "SQLite";
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.SQLITE;
        if (databaseFamilyId == null) {
            SqliteDialect.$$$reportNull$$$0(4);
        }
        return databaseFamilyId;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.Sqlite;
        if (icon == null) {
            SqliteDialect.$$$reportNull$$$0(5);
        }
        return icon;
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            SqliteDialect.$$$reportNull$$$0(6);
        }
        return databaseProductName != null && databaseProductName.toLowerCase(Locale.ENGLISH).contains("sqlite");
    }

    public boolean supportsColumnComment() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnComment(@NotNull DdlBuilder builder, @NotNull DasColumn column2) throws UnsupportedOperationException {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(7);
        }
        if (column2 == null) {
            SqliteDialect.$$$reportNull$$$0(8);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.column.comment.alter", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsAlterColumnNull() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnNullable(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(9);
        }
        if (column2 == null) {
            SqliteDialect.$$$reportNull$$$0(10);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.column.null.alter", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsRenameColumn() {
        return true;
    }

    @Override
    public boolean supportsModifyColumn() {
        return false;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection) throws SQLException {
        if (system == null) {
            SqliteDialect.$$$reportNull$$$0(11);
        }
        if (connection == null) {
            SqliteDialect.$$$reportNull$$$0(12);
        }
        return SearchPath.of((ObjectPath)ObjectPath.create((String)"main", (ObjectKind)ObjectKind.SCHEMA));
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnName(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull String toName) {
        BasicScriptable t;
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(13);
        }
        if (from == null) {
            SqliteDialect.$$$reportNull$$$0(14);
        }
        if (toName == null) {
            SqliteDialect.$$$reportNull$$$0(15);
        }
        builder.keywords("begin", "transaction").newStatement();
        DasTable tableOrig = from.getTable();
        Application application = ApplicationManager.getApplication();
        String uuid = application == null || application.isUnitTestMode() ? "_tmp" : UUID.randomUUID().toString().substring(0, 4);
        String tableName = tableOrig.getName();
        String newTableName = tableName + uuid;
        SqliteModTable table = (SqliteModTable)DialectUtils.withNewModel(Sqlite.RDBMS, SqliteModModel.class, SqliteModRoot.class, root2 -> (SqliteModTable)DialectUtils.create(((SqliteModSchema)DialectUtils.create(root2.getSchemas(), DasUtil.getSchemaObject((DasObject)tableOrig))).getTables(), tableOrig.getName()));
        DialectUtils.getRenameTableSQL(builder, table, newTableName).newStatement();
        for (DasColumn o : DasUtil.getColumns((DasObject)tableOrig)) {
            t = o == from ? (SqliteModTableColumn)DialectUtils.create(table.getColumns(), toName) : (SqliteModTableColumn)DialectUtils.create(table.getColumns(), (DasObject)o);
            t.setDataType(o.getDataType());
            t.setNotNull(o.isNotNull());
            t.setComment(o.getComment());
            t.setDefaultExpression(o.getDefault());
        }
        for (DasColumn o : DasUtil.getTableKeys((DasTable)tableOrig)) {
            t = (SqliteModKey)DialectUtils.create(table.getKeys(), (DasObject)o);
            t.setPrimary(o.isPrimary());
            t.setColNames(this.newKeyColumns(o.getColumnsRef().names(), from, toName));
        }
        for (DasColumn o : DasUtil.getForeignKeys((DasTable)tableOrig)) {
            t = (SqliteModForeignKey)DialectUtils.create(table.getForeignKeys(), (DasObject)o);
            t.setColNames(this.newKeyColumns(o.getColumnsRef().names(), from, toName));
            t.setRefTableName(o.getRefTableName());
            t.setRefSchemaName(o.getRefTableSchema());
            t.setRefColNames(JBIterable.from((Iterable)o.getRefColumns().names()).toList());
        }
        this.sqlCreateTable(builder, ContainerUtil.newSmartList((Object)table), true, null).newStatement();
        builder.keywords("insert", "into").space().identifier(tableName).space().keyword("select").space().plain("*").space().keyword("from").space().identifier(newTableName).newStatement();
        DasTable tmpTable = (DasTable)DialectUtils.withNewModel(Sqlite.RDBMS, SqliteModModel.class, SqliteModRoot.class, root2 -> (SqliteModTable)DialectUtils.create(((SqliteModSchema)DialectUtils.create(root2.getSchemas(), DasUtil.getSchemaObject((DasObject)tableOrig))).getTables(), newTableName));
        this.sqlDropTable(builder, tmpTable, true, false, DasUtil.emptyModel()).newStatement();
        for (DasIndex o : DasUtil.getIndices((DasTable)tableOrig)) {
            SqliteModIndex t2 = (SqliteModIndex)DialectUtils.create(table.getIndices(), (DasObject)o);
            t2.setUnique(o.isUnique());
            t2.setColNames(this.newKeyColumns(o.getColumnsRef().names(), from, toName));
            this.sqlCreateIndex(builder, t2, "", "", "").newStatement();
        }
        DdlBuilder ddlBuilder = builder.keyword("commit").newStatement();
        if (ddlBuilder == null) {
            SqliteDialect.$$$reportNull$$$0(16);
        }
        return ddlBuilder;
    }

    protected List<String> newKeyColumns(Iterable<String> names, @NotNull DasColumn from, @NotNull String toName) {
        if (from == null) {
            SqliteDialect.$$$reportNull$$$0(17);
        }
        if (toName == null) {
            SqliteDialect.$$$reportNull$$$0(18);
        }
        return JBIterable.from(names).transform(o -> {
            if (from == null) {
                SqliteDialect.$$$reportNull$$$0(116);
            }
            if (toName == null) {
                SqliteDialect.$$$reportNull$$$0(117);
            }
            return Comparing.equal((String)o, (String)from.getName()) ? toName : o;
        }).toList();
    }

    public boolean supportsAlterColumnType() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnType(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to) throws UnsupportedOperationException {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(19);
        }
        if (from == null) {
            SqliteDialect.$$$reportNull$$$0(20);
        }
        if (to == null) {
            SqliteDialect.$$$reportNull$$$0(21);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.column.type.alter", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsAlterColumnDefault() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefault(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(22);
        }
        if (column2 == null) {
            SqliteDialect.$$$reportNull$$$0(23);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.column.default.alter", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(24);
        }
        if (pk == null) {
            SqliteDialect.$$$reportNull$$$0(25);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.drop.primary.key", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsSequence() {
        return false;
    }

    public boolean supportsTablespace() {
        return false;
    }

    public boolean supportsIndexes() {
        return true;
    }

    public boolean supportsAccessMethods() {
        return false;
    }

    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    public boolean supportsMultipleRowInserts() {
        return false;
    }

    public boolean supportsAddColumn() {
        return true;
    }

    public boolean supportsAddForeignKey() {
        return false;
    }

    public boolean supportsAddUniqueConstraint() {
        return false;
    }

    public boolean supportsAlterSequence() {
        return false;
    }

    public boolean supportsCreateIndex() {
        return true;
    }

    public boolean supportsCreateSequence() {
        return false;
    }

    public boolean supportsCreateView() {
        return true;
    }

    public boolean supportsDropConstraint() {
        return false;
    }

    public boolean supportsDropIndex() {
        return true;
    }

    public boolean supportsDropSequence() {
        return false;
    }

    public boolean supportsDropView() {
        return true;
    }

    public boolean supportsRenameTable() {
        return true;
    }

    public boolean supportsRenameView() {
        return false;
    }

    public boolean supportsSequenceInformation() {
        return false;
    }

    public String[] getIndexAccessMethodsTypes() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public String[] getIndexStorageOptions() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameTable(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull String newName) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(26);
        }
        if (table == null) {
            SqliteDialect.$$$reportNull$$$0(27);
        }
        if (newName == null) {
            SqliteDialect.$$$reportNull$$$0(28);
        }
        DdlBuilder ddlBuilder = DialectUtils.getRenameTableSQL(builder, table, newName);
        if (ddlBuilder == null) {
            SqliteDialect.$$$reportNull$$$0(29);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(30);
        }
        if (view == null) {
            SqliteDialect.$$$reportNull$$$0(31);
        }
        if (definition == null) {
            SqliteDialect.$$$reportNull$$$0(32);
        }
        if (checkOption == null) {
            SqliteDialect.$$$reportNull$$$0(33);
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateViewSQL(builder, view, definition, "", this);
        if (ddlBuilder == null) {
            SqliteDialect.$$$reportNull$$$0(34);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String newName) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(35);
        }
        if (view == null) {
            SqliteDialect.$$$reportNull$$$0(36);
        }
        if (newName == null) {
            SqliteDialect.$$$reportNull$$$0(37);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.rename.view", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(38);
        }
        if (view == null) {
            SqliteDialect.$$$reportNull$$$0(39);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL(builder, view, null);
        if (ddlBuilder == null) {
            SqliteDialect.$$$reportNull$$$0(40);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateIndex(@NotNull DdlBuilder builder, @NotNull DasIndex index2, @NotNull String accessMethod, @NotNull String tablespace, @NotNull String constraints) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(41);
        }
        if (index2 == null) {
            SqliteDialect.$$$reportNull$$$0(42);
        }
        if (accessMethod == null) {
            SqliteDialect.$$$reportNull$$$0(43);
        }
        if (tablespace == null) {
            SqliteDialect.$$$reportNull$$$0(44);
        }
        if (constraints == null) {
            SqliteDialect.$$$reportNull$$$0(45);
        }
        DdlBuilder ddlBuilder = DialectUtils.createIndex(builder, index2, accessMethod);
        if (ddlBuilder == null) {
            SqliteDialect.$$$reportNull$$$0(46);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropIndex(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasIndex index2, @NotNull String indexName, boolean cascade) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(47);
        }
        if (table == null) {
            SqliteDialect.$$$reportNull$$$0(48);
        }
        if (indexName == null) {
            SqliteDialect.$$$reportNull$$$0(49);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropIndexSQL(builder, table, index2, indexName, null, false);
        if (ddlBuilder == null) {
            SqliteDialect.$$$reportNull$$$0(50);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTable(@NotNull DdlBuilder builder, @NotNull DasTable table, boolean cascadeConstraints, boolean isMaterializedView, @NotNull DasModel model) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(51);
        }
        if (table == null) {
            SqliteDialect.$$$reportNull$$$0(52);
        }
        if (model == null) {
            SqliteDialect.$$$reportNull$$$0(53);
        }
        DdlBuilder ddlBuilder = DialectUtils.getTableDropSQL(builder, table, false, false, false, "", false);
        if (ddlBuilder == null) {
            SqliteDialect.$$$reportNull$$$0(54);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlTableDefinition(@NotNull DasObject element) {
        if (element == null) {
            SqliteDialect.$$$reportNull$$$0(55);
        }
        Pair pair = Pair.create((Object)("select GROUP_CONCAT(s, ';\n') from (select sql as s from sqlite_master where tbl_name = '" + StringUtil.toLowerCase((String)element.getName()).replace("'", "''") + "' and (type = 'table' or type = 'index') order by type desc)"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            SqliteDialect.$$$reportNull$$$0(56);
        }
        return pair;
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection) throws Exception {
        if (table == null) {
            SqliteDialect.$$$reportNull$$$0(57);
        }
        if (connection == null) {
            SqliteDialect.$$$reportNull$$$0(58);
        }
        Pair<String, DbImplUtil.ConcatenationProps> pair = this.sqlTableDefinition((DasObject)table);
        String string = DbImplUtil.concatStringResults(connection, this, (String)pair.first, 1, (DbImplUtil.ConcatenationProps)pair.second);
        if (string == null) {
            SqliteDialect.$$$reportNull$$$0(59);
        }
        return string;
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    public boolean supportsDropPrimaryKey() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String start, @NotNull String cache2, boolean cycle) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(60);
        }
        if (sequence == null) {
            SqliteDialect.$$$reportNull$$$0(61);
        }
        if (increment == null) {
            SqliteDialect.$$$reportNull$$$0(62);
        }
        if (minimum == null) {
            SqliteDialect.$$$reportNull$$$0(63);
        }
        if (maximum == null) {
            SqliteDialect.$$$reportNull$$$0(64);
        }
        if (start == null) {
            SqliteDialect.$$$reportNull$$$0(65);
        }
        if (cache2 == null) {
            SqliteDialect.$$$reportNull$$$0(66);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.create.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    public boolean supportsDropColumn() {
        return false;
    }

    @Override
    public boolean supportsAddPrimaryKey() {
        return false;
    }

    @Override
    public boolean supportsRenameRoutine() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String restart, @NotNull String cache2, boolean cycle) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(67);
        }
        if (sequence == null) {
            SqliteDialect.$$$reportNull$$$0(68);
        }
        if (increment == null) {
            SqliteDialect.$$$reportNull$$$0(69);
        }
        if (minimum == null) {
            SqliteDialect.$$$reportNull$$$0(70);
        }
        if (maximum == null) {
            SqliteDialect.$$$reportNull$$$0(71);
        }
        if (restart == null) {
            SqliteDialect.$$$reportNull$$$0(72);
        }
        if (cache2 == null) {
            SqliteDialect.$$$reportNull$$$0(73);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.alter.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlSequenceInformation(@NotNull DdlBuilder builder, @NotNull DasTable sequence) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(74);
        }
        if (sequence == null) {
            SqliteDialect.$$$reportNull$$$0(75);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.sequence.information", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(76);
        }
        if (sequence == null) {
            SqliteDialect.$$$reportNull$$$0(77);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.drop.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddForeignKey(@NotNull DdlBuilder builder, @NotNull DasForeignKey keyInfo, boolean matchFull, boolean autoFKIndex) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(78);
        }
        if (keyInfo == null) {
            SqliteDialect.$$$reportNull$$$0(79);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.add.foreign.key", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddUniqueConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName, @NotNull List<DasColumn> columns2) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(80);
        }
        if (table == null) {
            SqliteDialect.$$$reportNull$$$0(81);
        }
        if (constraintName == null) {
            SqliteDialect.$$$reportNull$$$0(82);
        }
        if (columns2 == null) {
            SqliteDialect.$$$reportNull$$$0(83);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.add.unique", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(84);
        }
        if (column2 == null) {
            SqliteDialect.$$$reportNull$$$0(85);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.add.auto.increment", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column2, @NotNull String sequenceName) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(86);
        }
        if (column2 == null) {
            SqliteDialect.$$$reportNull$$$0(87);
        }
        if (sequenceName == null) {
            SqliteDialect.$$$reportNull$$$0(88);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.add.auto.increment", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column2) throws UnsupportedOperationException {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(89);
        }
        if (column2 == null) {
            SqliteDialect.$$$reportNull$$$0(90);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.column.drop", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineColumn(@NotNull DdlBuilder builder, DasColumn column2, boolean singlePk) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(91);
        }
        builder.columnRef((DasObject)column2).space().type((DasTypedObject)column2);
        Set attrs = column2.getTable().getColumnAttrs(column2);
        if (singlePk) {
            builder.space().keywords("PRIMARY", "KEY");
            if (attrs.contains(DasColumn.Attribute.AUTO_GENERATED)) {
                builder.space().keyword("AUTOINCREMENT");
            }
        } else if (attrs.contains(DasColumn.Attribute.AUTO_GENERATED)) {
            builder.space().inlineComment("AUTOINCREMENT works only on one-column PRIMARY KEY");
        }
        DialectUtils.addDefaultClauseIfNeeded(builder, column2, "DEFAULT");
        DialectUtils.addNullabilityClause(builder, column2, false);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            SqliteDialect.$$$reportNull$$$0(92);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropForeignKey(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasForeignKey fk, @NotNull String fkName) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(93);
        }
        if (table == null) {
            SqliteDialect.$$$reportNull$$$0(94);
        }
        if (fkName == null) {
            SqliteDialect.$$$reportNull$$$0(95);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.drop.foreign.key", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    public boolean supportsCreateSchema() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(96);
        }
        if (table == null) {
            SqliteDialect.$$$reportNull$$$0(97);
        }
        if (constraintName == null) {
            SqliteDialect.$$$reportNull$$$0(98);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.drop.constraint", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column2, @NotNull Set<DasColumn.Attribute> attrs) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(99);
        }
        if (column2 == null) {
            SqliteDialect.$$$reportNull$$$0(100);
        }
        if (attrs == null) {
            SqliteDialect.$$$reportNull$$$0(101);
        }
        boolean addDefaultClause = true;
        boolean supportsNullQualifier = true;
        boolean addNullClause = true;
        builder.suppressQuoteConstraints(true);
        DdlBuilder ddlBuilder = DialectUtils.getAddColumnSQL(builder, column2, true, true, true).suppressQuoteConstraints(false);
        if (ddlBuilder == null) {
            SqliteDialect.$$$reportNull$$$0(102);
        }
        return ddlBuilder;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            SqliteDialect.$$$reportNull$$$0(103);
        }
        Pair pair = Pair.create((Object)("select sql as s from sqlite_master where tbl_name = '" + StringUtil.toLowerCase((String)element.getName()).replace("'", "''") + "' and type = 'view'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            SqliteDialect.$$$reportNull$$$0(104);
        }
        return pair;
    }

    public boolean supportsProcedureDefinition() {
        return false;
    }

    @Override
    public boolean supportsInsertDefaultValues() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            SqliteDialect.$$$reportNull$$$0(105);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.procedure.definition", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        char c0;
        if (identifier == null) {
            SqliteDialect.$$$reportNull$$$0(106);
        }
        if ((c0 = identifier.charAt(0)) != '_' && !Character.isLetter(c0)) {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 1; i2 < len; ++i2) {
            char c = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '$') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(@NotNull DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(107);
        }
        if (identifier == null) {
            SqliteDialect.$$$reportNull$$$0(108);
        }
        if (qualifier == null) {
            SqliteDialect.$$$reportNull$$$0(109);
        }
        DdlBuilder ddlBuilder = builder.identifier(object, identifier);
        if (ddlBuilder == null) {
            SqliteDialect.$$$reportNull$$$0(110);
        }
        return ddlBuilder;
    }

    public boolean supportsCorrelatedSubQuery() {
        return false;
    }

    @Override
    public boolean supportsDropForeignKey() {
        return false;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze2) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            SqliteDialect.$$$reportNull$$$0(111);
        }
        if (statement == null) {
            SqliteDialect.$$$reportNull$$$0(112);
        }
        if (analyze2) {
            throw new UnsupportedOperationException("SQLite does not support EXPLAIN ANALYZE");
        }
        builder.keyword("explain").space().plain(statement);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            SqliteDialect.$$$reportNull$$$0(113);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    protected DatabaseEditorCapabilities.ForeignKeyEditorCaps getForeignKeyEditorCaps(boolean existing) {
        DatabaseEditorCapabilities.ForeignKeyEditorCaps foreignKeyEditorCaps = new DatabaseEditorCapabilities.ForeignKeyEditorCaps(DatabaseEditorCapabilities.Capability.available(true), DatabaseEditorCapabilities.Capability.UNAVAILABLE, DatabaseEditorCapabilities.ValuesCapability.supported(true, DasForeignKey.Deferrability.values()), DatabaseEditorCapabilities.ValuesCapability.supported(true, DasForeignKey.RuleAction.values()), DatabaseEditorCapabilities.ValuesCapability.supported(true, DasForeignKey.RuleAction.values()));
        if (foreignKeyEditorCaps == null) {
            SqliteDialect.$$$reportNull$$$0(114);
        }
        return foreignKeyEditorCaps;
    }

    @Override
    @NotNull
    protected DatabaseEditorCapabilities.TableEditorCaps getTableEditorCaps(boolean existing) {
        DatabaseEditorCapabilities.TableEditorCaps tableEditorCaps = new DatabaseEditorCapabilities.TableEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || this.supportsRenameTable()), DatabaseEditorCapabilities.Capability.supported(this.supportsTableComment()), DatabaseEditorCapabilities.ListCapability.get(true, !existing, true, true), DatabaseEditorCapabilities.ListCapability.get(this.supportsIndexes(), false, !existing || this.supportsCreateIndex(), !existing || this.supportsDropIndex()), DatabaseEditorCapabilities.ListCapability.get(true, false, true, true), DatabaseEditorCapabilities.ListCapability.get(true, false, true, true), DatabaseEditorCapabilities.ListCapability.get(true, false, true, true), DatabaseEditorCapabilities.ListCapability.get(true, false, !existing || this.supportsAddUniqueConstraint(), !existing || this.supportsDropConstraint()), this.getColumnEditorCaps(false), this.getColumnEditorCaps(existing), this.getKeyEditorCaps(false), this.getKeyEditorCaps(existing), this.getIndexEditorCaps(false), this.getIndexEditorCaps(existing), this.getForeignKeyEditorCaps(false), this.getForeignKeyEditorCaps(existing));
        if (tableEditorCaps == null) {
            SqliteDialect.$$$reportNull$$$0(115);
        }
        return tableEditorCaps;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 116: 
            case 117: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 116: 
            case 117: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/SqliteDialect";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseProductVersion";
                break;
            }
            case 7: 
            case 9: 
            case 13: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 30: 
            case 35: 
            case 38: 
            case 41: 
            case 47: 
            case 51: 
            case 60: 
            case 67: 
            case 74: 
            case 76: 
            case 78: 
            case 80: 
            case 84: 
            case 86: 
            case 89: 
            case 91: 
            case 93: 
            case 96: 
            case 99: 
            case 107: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: 
            case 10: 
            case 23: 
            case 85: 
            case 87: 
            case 90: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 12: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 14: 
            case 17: 
            case 20: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 15: 
            case 18: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pk";
                break;
            }
            case 27: 
            case 48: 
            case 52: 
            case 57: 
            case 81: 
            case 94: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 28: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 31: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkOption";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessMethod";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tablespace";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 55: 
            case 103: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 61: 
            case 68: 
            case 75: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 62: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "increment";
                break;
            }
            case 63: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimum";
                break;
            }
            case 64: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maximum";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 66: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restart";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyInfo";
                break;
            }
            case 82: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintName";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequenceName";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fkName";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 106: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDdlOperations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnEditorCaps";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 116: 
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/SqliteDialect";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnName";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameTable";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateView";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateIndex";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropIndex";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropTable";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlTableDefinition";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineColumn";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddColumn";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlViewDefinition";
                break;
            }
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlExplainPlan";
                break;
            }
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "getForeignKeyEditorCaps";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableEditorCaps";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "supportsProduct";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnComment";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnNullable";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "newKeyColumns";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnDefault";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropPrimaryKey";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameTable";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameView";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateIndex";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropIndex";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropTable";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "sqlTableDefinition";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateSequence";
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterSequence";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceInformation";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddForeignKey";
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddUniqueConstraint";
                break;
            }
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropColumn";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineColumn";
                break;
            }
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropForeignKey";
                break;
            }
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropConstraint";
                break;
            }
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumn";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "lambda$newKeyColumns$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 116: 
            case 117: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

