/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.AbstractTransactSqlDialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.BasicMetaModel;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.sybase.SybaseMetaModel;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.operations.sybase.SybaseDdlOperationsBuilder;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SybaseDialect
extends AbstractTransactSqlDialect
implements DatabaseDialect {
    public static final SybaseDialect INSTANCE = new SybaseDialect();

    public SybaseDialect() {
        super(new TypeHelper.SybaseTypeHelper(), new KeywordHelper.SybaseKeywords(), Casing.create((Case)Case.EXACT, (Case)Case.EXACT));
    }

    @Override
    @NotNull
    public MetaModel getMetaModel() {
        BasicMetaModel basicMetaModel = SybaseMetaModel.MODEL;
        if (basicMetaModel == null) {
            SybaseDialect.$$$reportNull$$$0(0);
        }
        return basicMetaModel;
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.SYBASE;
        if (databaseFamilyId == null) {
            SybaseDialect.$$$reportNull$$$0(1);
        }
        return databaseFamilyId;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.Sybase;
        if (icon == null) {
            SybaseDialect.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("Sybase" == null) {
            SybaseDialect.$$$reportNull$$$0(3);
        }
        return "Sybase";
    }

    @Override
    @Nullable
    public String getNameForKind(@NotNull ObjectKind kind) {
        if (kind == null) {
            SybaseDialect.$$$reportNull$$$0(4);
        }
        return kind == ObjectKind.PACKAGE ? "PROCEDURE GROUP" : (kind == ObjectKind.ROUTINE ? "FUNCTION" : super.getNameForKind(kind));
    }

    @Override
    @NotNull
    public String getLengthFunction() {
        if ("datalength" == null) {
            SybaseDialect.$$$reportNull$$$0(5);
        }
        return "datalength";
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            SybaseDialect.$$$reportNull$$$0(6);
        }
        if (databaseProductName == null) {
            return false;
        }
        String lname = databaseProductName.trim().toLowerCase(Locale.ENGLISH);
        return lname.startsWith("sybase") || lname.startsWith("adaptive");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(7);
        }
        if (column2 == null) {
            SybaseDialect.$$$reportNull$$$0(8);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDropSQL(builder, column2);
        if (ddlBuilder == null) {
            SybaseDialect.$$$reportNull$$$0(9);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameDatabase(@NotNull DdlBuilder builder, @NotNull DasNamespace database, @NotNull String name) {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(10);
        }
        if (database == null) {
            SybaseDialect.$$$reportNull$$$0(11);
        }
        if (name == null) {
            SybaseDialect.$$$reportNull$$$0(12);
        }
        if (!this.supportsRenameDatabase()) {
            throw new UnsupportedOperationException("Rename database is not supported");
        }
        DdlBuilder ddlBuilder = builder.keyword("USE").space().ref(null, "master").newStatement().keyword("EXEC").space().ref(null, "sp_dboption").space().identifier((DasObject)database, database.getName()).symbol(",").space().literal("single").symbol(",").space().literal("true").newStatement().keyword("USE").space().identifier((DasObject)database, database.getName()).newStatement().keyword("EXEC").space().ref(null, "sp_renamedb").space().identifier((DasObject)database, database.getName()).symbol(",").space().identifier((DasObject)database, name).newStatement().keyword("USE").space().ref(null, "master").newStatement().keyword("EXEC").space().ref(null, "sp_dboption").space().identifier((DasObject)database, name).symbol(",").space().literal("single").symbol(",").space().literal("false").newStatement().keyword("USE").space().identifier((DasObject)database, name).newStatement();
        if (ddlBuilder == null) {
            SybaseDialect.$$$reportNull$$$0(13);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTable(@NotNull DdlBuilder builder, @NotNull DasTable table, boolean cascadeConstraints, boolean isMaterializedView, @NotNull DasModel model) {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(14);
        }
        if (table == null) {
            SybaseDialect.$$$reportNull$$$0(15);
        }
        if (model == null) {
            SybaseDialect.$$$reportNull$$$0(16);
        }
        if (cascadeConstraints) {
            for (DasConstraint keyInfo : model.getExportedKeys(table)) {
                builder.keywords("ALTER", "TABLE").space();
                builder.qualifiedRef((DasObject)keyInfo.getTable());
                builder.keywords("DROP", "CONSTRAINT").space();
                builder.constraintRef((DasObject)keyInfo, keyInfo.getName());
                builder.newStatement();
            }
        }
        DdlBuilder ddlBuilder = DialectUtils.getTableDropSQL(builder, table, false, cascadeConstraints, false, "CASCADE", false);
        if (ddlBuilder == null) {
            SybaseDialect.$$$reportNull$$$0(17);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    protected DdlOperations getDdlOperations() {
        DdlOperations ddlOperations = new SybaseDdlOperationsBuilder(this).build();
        if (ddlOperations == null) {
            SybaseDialect.$$$reportNull$$$0(18);
        }
        return ddlOperations;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(19);
        }
        if (pk == null) {
            SybaseDialect.$$$reportNull$$$0(20);
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddPrimaryKeySQL(builder, pk, false);
        if (ddlBuilder == null) {
            SybaseDialect.$$$reportNull$$$0(21);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnTypeAndNullable(@NotNull DdlBuilder builder, @NotNull DasColumn column2, boolean typeChanged) {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(22);
        }
        if (column2 == null) {
            SybaseDialect.$$$reportNull$$$0(23);
        }
        if (column2.isNotNull() || !typeChanged) {
            DdlBuilder ddlBuilder = DialectUtils.getColumnNullableAlterSQL(builder, column2, "MODIFY", typeChanged);
            if (ddlBuilder == null) {
                SybaseDialect.$$$reportNull$$$0(24);
            }
            return ddlBuilder;
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnTypeAlterSQL(builder, "MODIFY", "", false, column2);
        if (ddlBuilder == null) {
            SybaseDialect.$$$reportNull$$$0(25);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefault(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(26);
        }
        if (column2 == null) {
            SybaseDialect.$$$reportNull$$$0(27);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.column.default.alter", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column2) {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(28);
        }
        if (column2 == null) {
            SybaseDialect.$$$reportNull$$$0(29);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.add.auto.increment", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineColumn(@NotNull DdlBuilder builder, DasColumn column2, boolean singlePk) {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(30);
        }
        builder.columnRef((DasObject)column2);
        builder.space();
        builder.type((DasTypedObject)column2);
        if (DasUtil.isAutoGenerated((DasColumn)column2)) {
            builder.space().keyword("IDENTITY");
        }
        DialectUtils.addDefaultClauseIfNeeded(builder, column2, "DEFAULT");
        if (singlePk) {
            builder.space().keywords("PRIMARY", "KEY");
        }
        if (column2.isNotNull()) {
            builder.space().keywords("NOT", "NULL");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            SybaseDialect.$$$reportNull$$$0(31);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsDropPackage() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropPackage(@NotNull DdlBuilder builder, @NotNull DasSchemaChild pkg) {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(32);
        }
        if (pkg == null) {
            SybaseDialect.$$$reportNull$$$0(33);
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "PROCEDURE").space().qualifiedRef((DasObject)pkg);
        if (ddlBuilder == null) {
            SybaseDialect.$$$reportNull$$$0(34);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropIndex(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasIndex index2, @NotNull String indexName, boolean cascade) {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(35);
        }
        if (table == null) {
            SybaseDialect.$$$reportNull$$$0(36);
        }
        if (indexName == null) {
            SybaseDialect.$$$reportNull$$$0(37);
        }
        builder.keywords("DROP", "INDEX").space();
        builder.qualifiedRef((DasObject)table).symbol(".").identifier((DasObject)index2, indexName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            SybaseDialect.$$$reportNull$$$0(38);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlSequenceInformation(@NotNull DdlBuilder builder, @NotNull DasTable sequence) {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(39);
        }
        if (sequence == null) {
            SybaseDialect.$$$reportNull$$$0(40);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.sequence.information", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropType(@NotNull DdlBuilder builder, @NotNull DasUserDefinedType type) {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(41);
        }
        if (type == null) {
            SybaseDialect.$$$reportNull$$$0(42);
        }
        builder.keyword("EXEC").space().plain("sp_droptype").space().symbol("'");
        DdlBuilder.Marker mark2 = builder.mark();
        builder.qualifiedRef((DasObject)type);
        mark2.replace(DbImplUtil.escapeStr(mark2.extract()));
        mark2.finish();
        DdlBuilder ddlBuilder = builder.symbol("'");
        if (ddlBuilder == null) {
            SybaseDialect.$$$reportNull$$$0(43);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnection connection) throws Exception {
        if (element == null) {
            SybaseDialect.$$$reportNull$$$0(44);
        }
        if (connection == null) {
            SybaseDialect.$$$reportNull$$$0(45);
        }
        Map<String, Object> map = DbImplUtil.resultRowAsMap(connection, String.format("EXEC sp_spaceused '%s'", DbImplUtil.escapeStr(QNameUtil.getQualifiedName((DbElement)element))), "rowtotal", "rows");
        if (map == null) {
            SybaseDialect.$$$reportNull$$$0(46);
        }
        return map;
    }

    @Override
    public boolean supportsPackageDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlPackageBodyDefinition(@NotNull DasObject element) {
        if (element == null) {
            SybaseDialect.$$$reportNull$$$0(47);
        }
        Pair<String, DbImplUtil.ConcatenationProps> pair = this.sqlPackageDefinition(element);
        if (pair == null) {
            SybaseDialect.$$$reportNull$$$0(48);
        }
        return pair;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlPackageDefinition(@NotNull DasObject element) {
        if (element == null) {
            SybaseDialect.$$$reportNull$$$0(49);
        }
        Pair pair = Pair.create((Object)("use [" + DasUtil.getCatalog((DasObject)element) + "]\nexec sp_helptext '" + QNameUtil.getQualifiedName(element, this) + "'"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            SybaseDialect.$$$reportNull$$$0(50);
        }
        return pair;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine routine) {
        DasObject parent;
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(51);
        }
        if (routine == null) {
            SybaseDialect.$$$reportNull$$$0(52);
        }
        boolean inPackage = (parent = routine.getDasParent()) != null && parent.getKind() == ObjectKind.PACKAGE;
        DasRoutine.Kind kind = inPackage ? DasRoutine.Kind.PROCEDURE : routine.getRoutineKind();
        String type = kind.name();
        builder.keyword("create").space();
        builder.keyword(type).space().qualifiedRef((DasObject)(inPackage ? parent : routine));
        if (inPackage) {
            builder.plain(";");
            Object base = DbImplUtil.unwrap((DasObject)routine);
            if (base instanceof DasPositioned) {
                builder.plain(String.valueOf(((DasPositioned)base).getPosition()));
            } else {
                builder.plain(routine.getName());
            }
        }
        this.sqlDefinePrototype(builder, routine, true, true);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            SybaseDialect.$$$reportNull$$$0(53);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            SybaseDialect.$$$reportNull$$$0(54);
        }
        Pair pair = Pair.create((Object)("use [" + DasUtil.getCatalog((DasObject)element) + "]\nexec sp_helptext '" + QNameUtil.getQualifiedName(element, this) + "'"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            SybaseDialect.$$$reportNull$$$0(55);
        }
        return pair;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        DasObject parent;
        if (element == null) {
            SybaseDialect.$$$reportNull$$$0(56);
        }
        ObjectKind pkind = (parent = element.getDasParent()) == null ? null : parent.getKind();
        Pair pair = Pair.create((Object)("use [" + DasUtil.getCatalog((DasObject)element) + "]\nexec sp_helptext '" + QNameUtil.getQualifiedName((DasObject)(pkind == ObjectKind.PACKAGE ? parent : element), this).replace("'", "''") + "'"), (Object)DbImplUtil.ConcatenationProps.TIGHT);
        if (pair == null) {
            SybaseDialect.$$$reportNull$$$0(57);
        }
        return pair;
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            SybaseDialect.$$$reportNull$$$0(58);
        }
        if (qualifier == null) {
            SybaseDialect.$$$reportNull$$$0(59);
        }
        DdlBuilder ddlBuilder = builder.identifier(object, identifier);
        if (ddlBuilder == null) {
            SybaseDialect.$$$reportNull$$$0(60);
        }
        return ddlBuilder;
    }

    public boolean supportsCommonTableExpression() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze2) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(61);
        }
        if (statement == null) {
            SybaseDialect.$$$reportNull$$$0(62);
        }
        builder.keywords("set", "statement_cache", "off").newLine();
        builder.keywords("set", "showplan", "on").newLine();
        if (!analyze2) {
            builder.keywords("set", "noexec", "on").newLine();
        }
        builder.keywords("go").newLine();
        builder.plain(statement).newLine();
        builder.keywords("go").newLine();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            SybaseDialect.$$$reportNull$$$0(63);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlPostExplainPlan(@NotNull DdlBuilder builder, boolean analyze2) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            SybaseDialect.$$$reportNull$$$0(64);
        }
        if (!analyze2) {
            builder.keywords("set", "noexec", "off").newLine();
        }
        builder.keywords("set", "showplan", "off").newLine();
        builder.keywords("set", "statement_cache", "on").newLine();
        builder.keywords("go").newLine();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            SybaseDialect.$$$reportNull$$$0(65);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnection connection) throws SQLException {
        if (connection == null) {
            SybaseDialect.$$$reportNull$$$0(66);
        }
        List<String> list = DbImplUtil.executeAndGetResult(connection, "EXEC sp_helpdb", DbImplUtil.RS_AS_STRING_LIST);
        if (list == null) {
            SybaseDialect.$$$reportNull$$$0(67);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 66: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 66: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/SybaseDialect";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseProductVersion";
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 19: 
            case 22: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 39: 
            case 41: 
            case 51: 
            case 61: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: 
            case 23: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "database";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pk";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 44: 
            case 47: 
            case 49: 
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 45: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/SybaseDialect";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLengthFunction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropColumn";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameDatabase";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropTable";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDdlOperations";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddPrimaryKey";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnTypeAndNullable";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineColumn";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropPackage";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropIndex";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropType";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlPackageBodyDefinition";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlPackageDefinition";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineProcedure";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlViewDefinition";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlExplainPlan";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlPostExplainPlan";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNameForKind";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "supportsProduct";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropColumn";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameDatabase";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropTable";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddPrimaryKey";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnTypeAndNullable";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnDefault";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineColumn";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropPackage";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropIndex";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceInformation";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropType";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "sqlPackageBodyDefinition";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "sqlPackageDefinition";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineProcedure";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "sqlPostExplainPlan";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 66: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

