/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.database.DataBus;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.actions.SynchronizeSchemaAction;
import com.intellij.database.console.BaseJdbcSession;
import com.intellij.database.console.BaseJdbcSessionView;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesTracker;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.ExecuteRoutineFromFileAction;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicScriptable;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.oracle.OraSourceAware;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPackage;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.actions.ChooseSchemaAction;
import com.intellij.database.scripting.Chunk;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.DbSrcMigration;
import com.intellij.database.scripting.ScriptCategory;
import com.intellij.database.scripting.ScriptingFactory;
import com.intellij.database.scripting.ScriptingResult;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.ScriptingSingleModelTaskBuilder;
import com.intellij.database.scripting.UtilKt;
import com.intellij.database.scripting.base.AbstractScriptingServiceKt;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.TextWithRanges;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import icons.DatabaseIcons;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.dekaf.Rdbms;

public class DatabaseEditorHelper
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(DatabaseEditorHelper.class);
    private static final String DDL_EDITOR_DISPLAY_NAME = "DDL";
    private static final Key<Object> DB_EDITOR_LISTENER_INSTALLED = Key.create((String)"DB_EDITOR_LISTENER_INSTALLED");
    private static final Key<Boolean> FILE_CONTENT_LOADED = Key.create((String)"DBE_CONTENT_LOADED");

    public static void installEditorFactoryListener(final @NotNull Project project) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(0);
        }
        if (project.getUserData(DB_EDITOR_LISTENER_INSTALLED) != null) {
            return;
        }
        project.putUserData(DB_EDITOR_LISTENER_INSTALLED, (Object)Boolean.TRUE);
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        FileEditorManagerListener listener = new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (DbImplUtil.isDatabaseVirtualFile(file)) {
                    DatabaseEditorHelper.configureToolbar(file, source);
                    DatabaseEditorHelper.setDdlEditorsDisplayName(file, source);
                } else {
                    DatabaseEditorHelper.restoreAttachedConsole(source.getProject(), file);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/editor/DatabaseEditorHelper$1";
                objectArray[2] = "fileOpened";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)listener);
        connection.subscribe(DatabaseSettings.TOPIC, (Object)new DatabaseSettings.Listener(){
            private boolean myShowToolbar;
            {
                this.myShowToolbar = DatabaseSettings.getSettings().alwaysShowConsoleToolbar;
            }

            @Override
            public void settingsChanged() {
                boolean settingsValue = DatabaseSettings.getSettings().alwaysShowConsoleToolbar;
                if (this.myShowToolbar == settingsValue) {
                    return;
                }
                this.myShowToolbar = settingsValue;
                DatabaseEditorHelper.getAllOpenedEditors(project).filter(e -> {
                    if (project == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    VirtualFile file = e.getVirtualFile();
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                    return psiFile != null && DbSqlUtil.isSqlFile(psiFile) && JdbcConsoleProvider.isItPossibleToAttachConsoleTo(file) && !DbImplUtil.isDatabaseVirtualFile(file) && JdbcConsole.findConsole(project, file) == null;
                }).forEach(e -> {
                    if (project == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (this.myShowToolbar) {
                        DatabaseEditorHelper.configureConsoleToolbar(project, null, e.getVirtualFile());
                        return;
                    }
                    DatabaseEditorHelper.removeConsoleToolbar(project, e.getVirtualFile());
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/database/editor/DatabaseEditorHelper$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$settingsChanged$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$settingsChanged$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        for (VirtualFile virtualFile : fileEditorManager.getOpenFiles()) {
            listener.fileOpened(fileEditorManager, virtualFile);
        }
        DataBus.addRootAuditor(project, new DataAuditor.Adapter(){
            final ConcurrentMap<DataRequest.Context, String> myReportedQueries = ContainerUtil.createConcurrentWeakMap();

            @Override
            public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
                if (request == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (producer == null) {
                    3.$$$reportNull$$$0(1);
                }
                this.updateToolbars(request);
            }

            @Override
            public void jobFinished(@NotNull DataRequest request, @NotNull DataProducer producer) {
                if (request == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (producer == null) {
                    3.$$$reportNull$$$0(3);
                }
                this.updateToolbars(request);
            }

            void updateToolbars(@NotNull DataRequest request) {
                if (request == null) {
                    3.$$$reportNull$$$0(4);
                }
                if (request.owner instanceof DataGrid || request.owner instanceof AbstractQueryLanguageConsole) {
                    UIUtil.invokeLaterIfNeeded(() -> ActionToolbarImpl.updateAllToolbarsImmediately());
                }
            }

            @Override
            public void print(@NotNull DataRequest.Context context, @Nullable String message) {
                if (context == null) {
                    3.$$$reportNull$$$0(5);
                }
                if (context.request.owner instanceof JdbcConsole) {
                    return;
                }
                if (StringUtil.isEmptyOrSpaces((String)message)) {
                    return;
                }
                DatabaseNotifications.DATABASE_EXECUTION_GROUP.createNotification(message, MessageType.INFO).notify(project);
            }

            @Override
            public void warn(@NotNull DataRequest.Context context, @Nullable String message) {
                if (context == null) {
                    3.$$$reportNull$$$0(6);
                }
                if (context.request.owner instanceof JdbcConsole) {
                    return;
                }
                if (StringUtil.isEmptyOrSpaces((String)message)) {
                    return;
                }
                DatabaseNotifications.DATABASE_EXECUTION_GROUP.createNotification(message, MessageType.WARNING).notify(project);
            }

            @Override
            public void error(@NotNull DataRequest.Context context, @Nullable String message, @Nullable Throwable th) {
                String content;
                if (context == null) {
                    3.$$$reportNull$$$0(7);
                }
                if (context.request.owner instanceof JdbcConsole) {
                    return;
                }
                String query = StringUtil.nullize((String)StringUtil.trim((String)context.getQuery()));
                if (query != null && Comparing.equal((String)query, (String)this.myReportedQueries.put(context, query))) {
                    query = null;
                }
                if (StringUtil.isEmptyOrSpaces((String)(content = (query == null ? "" : query + "\n") + (message == null ? "" : message) + (th == null ? "" : ExceptionUtil.getUserStackTrace((Throwable)th, (Logger)LOG))))) {
                    content = "<missing error message>";
                }
                DatabaseNotifications.DATABASE_EXECUTION_GROUP.createNotification(content, MessageType.ERROR).notify(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "request";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "producer";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/editor/DatabaseEditorHelper$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jobSubmitted";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jobFinished";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateToolbars";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "print";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "warn";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "error";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)project);
    }

    @NotNull
    public static JBIterable<EditorEx> getAllOpenedEditors(@NotNull Project project) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(1);
        }
        JBIterable jBIterable = JBIterable.of((Object[])FileEditorManager.getInstance((Project)project).getAllEditors()).filter(TextEditor.class).map(TextEditor::getEditor).filter(EditorEx.class).filter(e -> e.getVirtualFile() != null);
        if (jBIterable == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    private static void restoreAttachedConsole(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(3);
        }
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(4);
        }
        if (!JdbcConsoleProvider.isItPossibleToAttachConsoleTo(file)) {
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return;
        }
        JdbcConsole existing = JdbcConsoleProvider.getAttachedConsole(project, file);
        if (existing != null) {
            DatabaseEditorHelper.configureConsoleToolbar(project, existing, file);
            return;
        }
        JdbcConsole attached = JdbcConsoleProvider.findAttachedConsole(project, file);
        if (attached != null) {
            JdbcConsoleProvider.attachConsole(project, attached, file);
            return;
        }
        if (DbSqlUtil.isSqlFile(psiFile)) {
            DatabaseEditorHelper.configureConsoleToolbar(project, null, file);
        }
    }

    public static void removeConsoleToolbar(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(5);
        }
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(6);
        }
        DatabaseSettings settings = DatabaseSettings.getSettings();
        for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getAllEditors(file)) {
            EditorEx editor = EditorUtil.getEditorEx((FileEditor)fileEditor);
            if (editor == null) continue;
            if (settings.alwaysShowConsoleToolbar) {
                JComponent headerComponent = editor.getPermanentHeaderComponent();
                headerComponent.setBackground(null);
                for (Component c2 : (JBTreeTraverser)UIUtil.uiTraverser((Component)headerComponent).filter(c -> c instanceof ActionToolbar)) {
                    c2.setBackground(null);
                }
            } else {
                editor.setPermanentHeaderComponent(null);
                editor.setHeaderComponent(null);
            }
            editor.setBackgroundColor(null);
            editor.getColorsScheme().setColor(EditorColors.GUTTER_BACKGROUND, AbstractColorsScheme.INHERITED_COLOR_MARKER);
        }
    }

    public static void configureConsoleToolbar(@NotNull Project project, @Nullable JdbcConsole console, @NotNull VirtualFile file) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(7);
        }
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(8);
        }
        if (console == null && !DatabaseSettings.getSettings().alwaysShowConsoleToolbar) {
            return;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        for (FileEditor fileEditor : fileEditorManager.getAllEditors(file)) {
            EditorEx editor = EditorUtil.getEditorEx((FileEditor)fileEditor);
            if (editor == null) continue;
            JdbcConsole.buildHeaderComponent((Editor)editor, console);
        }
    }

    public static void configureConsole(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        JdbcConsole console;
        LocalDataSource dataSource;
        Project project;
        DbDataSource dbDataSource;
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(9);
        }
        if (source == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(10);
        }
        DatabaseSystem delegate = (dbDataSource = DbConsoleRootType.getDataSource(project = source.getProject(), file)) == null ? null : dbDataSource.getDelegate();
        LocalDataSource localDataSource = dataSource = delegate instanceof LocalDataSource ? (LocalDataSource)delegate : null;
        if (dataSource == null) {
            return;
        }
        if (FileIndexFacade.getInstance((Project)project).isUnderIgnored(file)) {
            LOG.warn(file.getPresentableUrl() + " is under ignored root, console not initialized");
            return;
        }
        JdbcConsole existing = JdbcConsole.getConsole(source.getProject(), file);
        if (existing != null) {
            console = existing;
        } else {
            console = JdbcConsole.newConsole(project).forFile(file).fromDataSource(dataSource).buildAndShow(false);
            ChooseSchemaAction.scheduleSavedSchemaSwitch(console);
        }
        for (FileEditor fileEditor : source.getAllEditors(file)) {
            EditorEx editor = EditorUtil.getEditorEx((FileEditor)fileEditor);
            if (editor == null || editor.getPermanentHeaderComponent() != null) continue;
            JdbcConsole.buildHeaderComponent((Editor)editor, console);
        }
    }

    @Nullable
    public static BaseJdbcSession<?> getDeadSession(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(11);
        }
        if (source == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(12);
        }
        if (!source.getProject().isOpen()) {
            return null;
        }
        if (source.getAllEditors(file).length > 0) {
            return null;
        }
        BaseJdbcSession<?> session = DatabaseEditorHelper.getSession(file, source);
        if (session == null) {
            return null;
        }
        if (((BaseJdbcSessionView)session.getView()).isToolWindowContentPresent()) {
            return null;
        }
        for (VirtualFile openFile : source.getOpenFiles()) {
            if (JdbcConsoleProvider.getAttachedConsole(source.getProject(), openFile) != session) continue;
            return null;
        }
        return session;
    }

    public static void disposeConsoleIfSafe(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        BaseJdbcSession<?> session;
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(13);
        }
        if (source == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(14);
        }
        if ((session = DatabaseEditorHelper.getDeadSession(file, source)) != null) {
            Disposer.dispose(session);
        }
    }

    @Nullable
    public static BaseJdbcSession<?> getSession(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(15);
        }
        if (source == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(16);
        }
        return JdbcConsole.ScriptingJdbcSessionHolder.INSTANCE.getSession(source.getProject(), file);
    }

    @Nullable
    public static BaseJdbcSession<?> findSession(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        JdbcConsole session;
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(17);
        }
        if (source == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(18);
        }
        return (session = JdbcConsole.ScriptingJdbcSessionHolder.INSTANCE.getMaybeAttachedSession(source.getProject(), file)) == null ? GridDataHookUpManager.getInstance(source.getProject()).getSession(source.getProject(), file) : session;
    }

    @Nullable
    public static BaseJdbcSession<?> findSession(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(19);
        }
        if ((project = e.getProject()) == null) {
            return null;
        }
        JdbcConsole session = JdbcConsole.ScriptingJdbcSessionHolder.INSTANCE.getMaybeAttachedSession(e);
        return session == null ? GridDataHookUpManager.getInstance(project).getSession(e) : session;
    }

    private static void configureToolbar(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(20);
        }
        if (source == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(21);
        }
        for (FileEditor fileEditor : source.getAllEditors(file)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            Editor editor = ((TextEditor)fileEditor).getEditor();
            DatabaseEditorHelper.configureToolbar(source.getProject(), file, editor);
            if (!(file instanceof DatabaseElementVirtualFileImpl)) continue;
            DatabaseEditorHelper.processLoading(source.getProject(), fileEditor, (DatabaseElementVirtualFileImpl)file);
        }
    }

    private static void processLoading(final Project project, FileEditor fileEditor, final DatabaseElementVirtualFileImpl vf) {
        boolean fileContentLoaded;
        JComponent editorComponent = fileEditor.getComponent();
        if (editorComponent instanceof JBLoadingPanel && vf.isBusy()) {
            ((JBLoadingPanel)editorComponent).startLoading();
        }
        if (!(fileContentLoaded = Boolean.TRUE.equals(FILE_CONTENT_LOADED.get((UserDataHolder)vf))) && !vf.isBusy()) {
            new UiNotifyConnector.Once((Component)editorComponent, (Activatable)new Activatable.Adapter(){

                public void showNotify() {
                    DatabaseEditorHelper.reloadIfNeeded(project, vf);
                }
            });
        }
    }

    @NotNull
    public static Promise<Void> reloadIfNeeded(@NotNull Project project, DatabaseElementVirtualFileImpl vf) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(22);
        }
        if (!vf.isBusy() && !Boolean.TRUE.equals(FILE_CONTENT_LOADED.get((UserDataHolder)vf))) {
            FILE_CONTENT_LOADED.set((UserDataHolder)vf, (Object)Boolean.TRUE);
            Promise<Void> promise = DatabaseEditorHelper.scheduleReload(project, vf);
            if (promise == null) {
                DatabaseEditorHelper.$$$reportNull$$$0(23);
            }
            return promise;
        }
        Promise promise = Promises.resolvedPromise();
        if (promise == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(24);
        }
        return promise;
    }

    private static void setDdlEditorsDisplayName(@NotNull VirtualFile file, @NotNull FileEditorManager fem) {
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(25);
        }
        if (fem == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(26);
        }
        for (EditorWithProviderComposite composite : ((FileEditorManagerEx)fem).getSplitters().findEditorComposites(file)) {
            for (FileEditor editor : composite.getEditors()) {
                if (!(editor instanceof TextEditor)) continue;
                composite.setDisplayName(editor, DDL_EDITOR_DISPLAY_NAME);
            }
        }
    }

    public static boolean isTableDataAvailable(@Nullable DbElement element) {
        return element != null && DbImplUtil.isDataTable(element.getKind()) && DbImplUtil.isInLocalDataSource(element);
    }

    public static boolean isDefinitionAvailable(@Nullable DbElement element) {
        return element instanceof DbTable && element.getKind() == ObjectKind.TABLE ? DbImplUtil.isInLocalDataSource(element) : DatabaseEditorHelper.hasNewCodegen(element) || DatabaseEditorHelper.isRawDefinitionAvailable(element);
    }

    public static boolean isRawDefinitionAvailable(@Nullable DbElement element) {
        if (element == null || !DbImplUtil.canConnectTo(element)) {
            return false;
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(element);
        ObjectKind kind = element.getKind();
        if (kind == ObjectKind.PACKAGE || kind == ObjectKind.BODY || element.getParent() instanceof DbPackage) {
            return dialect.supportsPackageDefinition();
        }
        if (kind == ObjectKind.ROUTINE) {
            return dialect.supportsProcedureDefinition();
        }
        if (element instanceof DbTable) {
            boolean system = ((DbTable)element).isSystem();
            if (kind == ObjectKind.VIEW) {
                return system ? dialect.supportsSystemViewDefinition() : dialect.supportsViewDefinition();
            }
            if (kind == ObjectKind.SEQUENCE) {
                return dialect.supportsSequenceDefinition();
            }
            if (kind == ObjectKind.SYNONYM) {
                return dialect.supportsSynonymDefinition();
            }
            if (kind == ObjectKind.TABLE) {
                return dialect.supportsTableDefinition();
            }
        }
        return false;
    }

    @NotNull
    public static StringBuilder generateDefinition(@NotNull DbElement element, @NotNull StringBuilder sb) {
        if (element == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(27);
        }
        if (sb == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(28);
        }
        Project project = element.getProject();
        SqlLanguageDialect dialect = DbSqlUtil.getSqlDialect(element);
        if (element.getDelegate() instanceof BasicElement) {
            BasicElement e = (BasicElement)element.getDelegate();
            CharSequence def2 = DatabaseEditorHelper.generateDefinitionUsingScriptingService(project, dialect, e);
            sb.append(def2);
        } else {
            DdlBuilder builder = new DdlBuilder().configureFor(element);
            builder.element((DasObject)element);
            CharSequence text2 = builder.getStatement();
            text2 = (CharSequence)ObjectUtils.chooseNotNull((Object)DatabaseEditorHelper.tryFormat(project, dialect, UtilKt.text(text2.toString(), false)), (Object)text2);
            sb.append(text2);
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(29);
        }
        return stringBuilder;
    }

    public static boolean hasNewCodegen(@Nullable DbElement element) {
        if (element == null) {
            return false;
        }
        return element.getDelegate() instanceof BasicScriptable;
    }

    @NotNull
    public static CharSequence generateDefinitionUsingScriptingService(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @NotNull BasicElement element) {
        CharSequence src;
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(30);
        }
        if (dialect == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(31);
        }
        if (element == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(32);
        }
        if (element instanceof OraSourceAware && ((OraSourceAware)element).isObfuscated()) {
            if ("-- The source text is obfuscated\n" == null) {
                DatabaseEditorHelper.$$$reportNull$$$0(33);
            }
            return "-- The source text is obfuscated\n";
        }
        if (element instanceof BasicScriptable) {
            BasicMultiDatabaseRoot root2;
            BasicModel model = element.getModel();
            BasicDatabase database = element.getDatabase();
            BasicMultiDatabaseRoot basicMultiDatabaseRoot = root2 = database == null ? (BasicMultiDatabaseRoot)ObjectUtils.tryCast((Object)element.getParent(), BasicMultiDatabaseRoot.class) : null;
            if (root2 != null) {
                database = root2.getCurrentDatabase();
            }
            if (model == null) {
                if ("-- no model\n" == null) {
                    DatabaseEditorHelper.$$$reportNull$$$0(34);
                }
                return "-- no model\n";
            }
            if (database == null) {
                if ("-- no database\n" == null) {
                    DatabaseEditorHelper.$$$reportNull$$$0(35);
                }
                return "-- no database\n";
            }
            ScriptingFactory scriptingFactory = (ScriptingFactory)ServiceManager.getService(ScriptingFactory.class);
            ScriptingService scriptingService = scriptingFactory.getScriptingService(model.getRdbms());
            ScriptingSingleModelTaskBuilder task = new ScriptingSingleModelTaskBuilder(model, ScriptCategory.CREATE_DEFINITION);
            if (element instanceof BasicSchema) {
                ContainerUtil.addAll(task.getElements(), AbstractScriptingServiceKt.getScriptableMajorObjects((BasicSchema)element));
            } else {
                task.getElements().add(element);
            }
            task.setCurrentNamespace((BasicNamespace)ObjectUtils.chooseNotNull((Object)element.getSchema(), (Object)element.getDatabase()));
            ScriptingResult result2 = scriptingService.makeScript(task.build());
            src = DatabaseEditorHelper.tryFormat(project, dialect, result2.getScript());
        } else {
            src = "-- No script for element: " + element.toString() + "\n";
        }
        if (src.length() == 0) {
            src = "-- No source text available\n";
        }
        String string = src;
        if (string == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    private static CharSequence tryFormat(@NotNull Project project, @NotNull SqlLanguageDialect dialect, final @NotNull CompositeText script) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(37);
        }
        if (dialect == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(38);
        }
        if (script == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(39);
        }
        final ArrayList chunks = ContainerUtil.newArrayList();
        for (CompositeText.Fragment fragment : script.getFragments()) {
            chunks.add(new Chunk(fragment.getText(), !fragment.getKind().getReformattable()));
        }
        if (chunks.isEmpty()) {
            CharSequence charSequence = script.getText();
            if (charSequence == null) {
                DatabaseEditorHelper.$$$reportNull$$$0(40);
            }
            return charSequence;
        }
        TextWithRanges textWithRanges = new TextWithRanges(){

            @NotNull
            public List<TextWithRanges.Chunk> getChunks() {
                List list = chunks;
                if (list == null) {
                    5.$$$reportNull$$$0(0);
                }
                return list;
            }

            public String toString() {
                return script.getText().toString();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseEditorHelper$5", "getChunks"));
            }
        };
        CharSequence src = DatabaseEditorHelper.tryFormat(project, dialect, textWithRanges);
        CharSequence charSequence = src == null ? script.getText() : src;
        if (charSequence == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(41);
        }
        return charSequence;
    }

    @Nullable
    private static CharSequence tryFormat(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @NotNull TextWithRanges text2) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(42);
        }
        if (dialect == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(43);
        }
        if (text2 == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(44);
        }
        try {
            return SqlPsiFacade.getInstance((Project)project).format(project, dialect, text2);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable th) {
            LOG.warn(th);
            return null;
        }
    }

    @NotNull
    public static StringBuilder loadOrGenerateDefinition(@NotNull DbElement element, @NotNull StringBuilder sb) {
        DdlBuilder builder;
        block7: {
            if (element == null) {
                DatabaseEditorHelper.$$$reportNull$$$0(45);
            }
            if (sb == null) {
                DatabaseEditorHelper.$$$reportNull$$$0(46);
            }
            int length = sb.length();
            DatabaseEditorHelper.loadDefinition(element, sb);
            if (length == sb.length()) break block7;
            StringBuilder stringBuilder = sb;
            if (stringBuilder == null) {
                DatabaseEditorHelper.$$$reportNull$$$0(47);
            }
            return stringBuilder;
        }
        try {
            builder = new DdlBuilder(sb).configureFor(element).comment("definition is not available or empty\n");
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            builder = new DdlBuilder(sb).configureFor(element).comment("Failed to load definition\n").comment(ExceptionUtil.getNonEmptyMessage((Throwable)e, (String)"") + "\n\n");
        }
        builder.comment("auto-generated definition\n\n");
        StringBuilder stringBuilder = DatabaseEditorHelper.generateDefinition(element, sb);
        if (stringBuilder == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(48);
        }
        return stringBuilder;
    }

    @NotNull
    public static StringBuilder loadDefinition(@NotNull DbElement element, @NotNull StringBuilder sb) throws Exception {
        if (element == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(49);
        }
        if (sb == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(50);
        }
        StringBuilder stringBuilder = DatabaseEditorHelper.loadDefinition(ConnectionProvider.forElement(element, DGDepartment.INTROSPECTION), element, sb);
        if (stringBuilder == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(51);
        }
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static StringBuilder loadDefinition(@NotNull ConnectionProvider provider, @NotNull DbElement element, @NotNull StringBuilder sb) throws Exception {
        if (provider == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(52);
        }
        if (element == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(53);
        }
        if (sb == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(54);
        }
        if (!provider.acquire()) {
            Exception exception = provider.getLastException();
            if (exception != null) {
                throw exception;
            }
            StringBuilder stringBuilder = sb;
            StringBuilder stringBuilder2 = stringBuilder;
            if (stringBuilder2 == null) {
                DatabaseEditorHelper.$$$reportNull$$$0(55);
            }
            return stringBuilder2;
        }
        StringBuilder stringBuilder = DatabaseEditorHelper.loadDefinitionImpl(provider, element, sb);
        StringBuilder stringBuilder3 = stringBuilder;
        if (stringBuilder3 == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(56);
        }
        return stringBuilder3;
        finally {
            provider.release();
        }
    }

    public static void setCurrentSchemaSafe(@NotNull DatabaseDialectEx dialect, @Nullable ObjectPath path, @NotNull DatabaseConnection connection) {
        SearchPath searchPath;
        String statement;
        if (dialect == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(57);
        }
        if (connection == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(58);
        }
        String string = statement = (searchPath = SearchPath.of((ObjectPath)path)) == null ? null : dialect.sqlSetSearchPath(searchPath);
        if (statement == null) {
            return;
        }
        try {
            SmartStatements.poweredBy(connection).simple().barren().execute(statement);
        }
        catch (Exception e) {
            DataSourceUiUtil.LOG.warn(statement, (Throwable)e);
        }
    }

    @NotNull
    private static StringBuilder loadDefinitionImpl(@NotNull ConnectionProvider provider, DbElement element, @NotNull StringBuilder sb) throws Exception {
        ObjectKind kind;
        DbPackage pkg;
        if (provider == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(59);
        }
        if (sb == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(60);
        }
        Object object = pkg = (kind = element.getKind()) == ObjectKind.PACKAGE || kind == ObjectKind.BODY || element.getParent() instanceof DbPackage ? (DbPackage)DasUtil.getParentOfClass((DasObject)element, DbPackage.class, (boolean)false) : null;
        if (pkg != null) {
            DbImplUtil.tryLoadPackageDefinition(provider, pkg, kind == ObjectKind.PACKAGE, sb);
        } else if (element instanceof DbRoutine) {
            DbImplUtil.tryLoadProcedureDefinition(provider, (DbRoutine)element, sb);
        } else if (element instanceof DbTable) {
            if (kind == ObjectKind.TABLE) {
                DbImplUtil.tryLoadTableDefinition(provider, (DbTable)element, sb);
            } else if (kind == ObjectKind.VIEW) {
                DbImplUtil.tryLoadViewDefinition(provider, (DbTable)element, sb);
            } else if (kind == ObjectKind.SEQUENCE) {
                DbImplUtil.tryLoadSequenceDefinition(provider, (DbTable)element, sb);
            } else if (kind == ObjectKind.SYNONYM) {
                DbImplUtil.tryLoadSynonymDefinition(provider, (DbTable)element, sb);
            }
        } else {
            throw new IllegalArgumentException("unknown element: " + element);
        }
        if (sb.length() != 0 && sb.charAt(sb.length() - 1) != '\n') {
            sb.append('\n');
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(61);
        }
        return stringBuilder;
    }

    @NotNull
    public static Promise<Void> scheduleReload(final @NotNull Project project, final @NotNull DatabaseElementVirtualFileImpl virtualFile) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(62);
        }
        if (virtualFile == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(63);
        }
        Promise<Void> promise = new Computable<Promise<Void>>(){

            public Promise<Void> compute() {
                virtualFile.setBusy(true);
                return AsyncUtil.runAsync(() -> this.onReady(), DataSourceStorage.getProjectStorage(project)::doWhenInitialized);
            }

            public Promise<Void> onReady() {
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (project == null) {
                        6.$$$reportNull$$$0(3);
                    }
                    if (virtualFile == null) {
                        6.$$$reportNull$$$0(4);
                    }
                    if (!project.isDisposed()) {
                        DatabaseEditorHelper.setVisualProgress(project, virtualFile, true);
                    }
                });
                return AsyncUtil.runAsync(() -> this.loadContent(), arg_0 -> ((Application)ApplicationManager.getApplication()).executeOnPooledThread(arg_0)).thenAsync(ignored -> AsyncUtil.runAsync(() -> this.finish(), arg_0 -> ((Application)ApplicationManager.getApplication()).invokeLater(arg_0)));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Promise<Void> loadContent() {
                if (project.isDisposed()) {
                    return Promises.cancelledPromise();
                }
                StringBuilder sb = new StringBuilder();
                try {
                    DbElement element = virtualFile.findElement(project);
                    if (element == null) {
                        sb.append("-- invalid target");
                    } else {
                        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(element);
                        Rdbms rdbms = DbImplUtil.getRdbms(dialect);
                        if (!DBIntrospectorFactory.hasNativeIntrospector(rdbms) && DatabaseEditorHelper.isRawDefinitionAvailable(element)) {
                            DatabaseEditorHelper.loadOrGenerateDefinition(element, sb);
                        } else {
                            sb.append("-- auto-generated definition\n");
                            DatabaseEditorHelper.generateDefinition(element, sb);
                        }
                        if (sb.length() == 0) {
                            sb.append("-- definition is not available or empty");
                        }
                    }
                }
                catch (Exception e) {
                    String trace = ExceptionUtil.getUserStackTrace((Throwable)e, (Logger)DataSourceUiUtil.LOG);
                    for (String s : trace.split("\n")) {
                        sb.append("-- ").append(s).append("\n");
                    }
                }
                finally {
                    String content = StringUtil.convertLineSeparators((String)sb.toString());
                    virtualFile.setContent(content);
                    virtualFile.setBusy(false);
                }
                return Promises.resolvedPromise();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Promise<Void> finish() {
                if (project.isDisposed() || !virtualFile.isValid()) {
                    return Promises.cancelledPromise();
                }
                DatabaseEditorHelper.setVisualProgress(project, virtualFile, false);
                Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)virtualFile);
                if (document == null) {
                    return Promises.cancelledPromise();
                }
                Runnable docUpdateRunnable = () -> {
                    boolean reformatOnPaste;
                    if (project == null) {
                        6.$$$reportNull$$$0(1);
                    }
                    if (virtualFile == null) {
                        6.$$$reportNull$$$0(2);
                    }
                    PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
                    DbElement element = virtualFile.findElement(project);
                    DasNamespace object = element == null ? null : DbImplUtil.getSearchPathObject(element);
                    DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)file, (Object)ObjectPaths.searchPathOf((DasObject)object));
                    document.setText((CharSequence)virtualFile.getContent());
                    boolean bl = reformatOnPaste = CodeInsightSettings.getInstance().REFORMAT_ON_PASTE == 4;
                    if (file != null && reformatOnPaste) {
                        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file);
                    }
                };
                boolean writable = virtualFile.isWritable();
                try {
                    virtualFile.setWritableInner(true);
                    document.setReadOnly(false);
                    WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                        if (project == null) {
                            6.$$$reportNull$$$0(0);
                        }
                        if (document.getTextLength() == 0) {
                            DocumentReference reference = DocumentReferenceManager.getInstance().create(document);
                            UndoManager.getInstance((Project)project).nonundoableActionPerformed(reference, false);
                        }
                        docUpdateRunnable.run();
                    });
                    virtualFile.setWritableInner(writable);
                    document.setReadOnly(!writable);
                }
                catch (Throwable throwable) {
                    virtualFile.setWritableInner(writable);
                    document.setReadOnly(!writable);
                    throw throwable;
                }
                return Promises.resolvedPromise();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "virtualFile";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/editor/DatabaseEditorHelper$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$finish$6";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$finish$5";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$onReady$1";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.compute();
        if (promise == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(64);
        }
        return promise;
    }

    private static void setVisualProgress(@NotNull Project project, @NotNull VirtualFile file, boolean flag) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(65);
        }
        if (file == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(66);
        }
        for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getAllEditors(file)) {
            JComponent editorComponent;
            if (!(fileEditor instanceof TextEditor) || !((editorComponent = fileEditor.getComponent()) instanceof JBLoadingPanel)) continue;
            JBLoadingPanel component = (JBLoadingPanel)editorComponent;
            if (flag) {
                component.startLoading();
                continue;
            }
            component.stopLoading();
        }
    }

    private static void configureToolbar(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull Editor editor) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(67);
        }
        if (virtualFile == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(68);
        }
        if (editor == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(69);
        }
        if (((EditorEx)editor).getPermanentHeaderComponent() != null) {
            return;
        }
        DefaultActionGroup group2 = new DefaultActionGroup();
        boolean isDbSrc = DbSrcUtils.isDbSrcFile(virtualFile);
        if (isDbSrc) {
            group2.add((AnAction)new ExecuteRoutineFromFileAction());
        }
        DumbAwareAction dataAction = new DumbAwareAction(){

            public void update(@NotNull AnActionEvent e) {
                VirtualFile file;
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                ObjectKind kind = DbSrcUtils.isDbSrcFile(file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) ? DbImplUtil.getKind(file) : (file instanceof DatabaseElementVirtualFileImpl && ((DatabaseElementVirtualFileImpl)file).isSource() ? ((DatabaseElementVirtualFileImpl)file).getObjectKind() : null);
                boolean enabled = DbImplUtil.isDataTable(kind);
                e.getPresentation().setEnabledAndVisible(enabled);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Project project;
                if (e == null) {
                    7.$$$reportNull$$$0(1);
                }
                if ((project = e.getProject()) == null) {
                    return;
                }
                VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
                DbElement element = DbImplUtil.findElement(project, file);
                PsiNavigateUtil.navigate((PsiElement)element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/editor/DatabaseEditorHelper$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ActionUtil.copyFrom((AnAction)dataAction, (String)"Jdbc.OpenEditor.Data");
        dataAction.registerCustomShortcutSet(editor.getComponent(), null);
        if (virtualFile instanceof DatabaseElementVirtualFileImpl) {
            DatabaseEditorHelper.addSpecificActions(editor, group2, (DatabaseElementVirtualFileImpl)virtualFile);
        } else if (isDbSrc) {
            DatabaseEditorHelper.addSpecificActions(editor, group2, virtualFile);
        }
        group2.add((AnAction)dataAction);
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar leftToolbar = actionManager.createActionToolbar("EditorToolbar", (ActionGroup)group2, true);
        leftToolbar.setTargetComponent(editor.getContentComponent());
        JComponent component = leftToolbar.getComponent();
        EditorHeaderComponent headerComponent = new EditorHeaderComponent();
        headerComponent.add((Component)component, "West");
        if (isDbSrc) {
            AnAction action = actionManager.getAction("Console.Jdbc.ChooseOneDataSourceConsole");
            ActionToolbar rightToolbar = actionManager.createActionToolbar("EditorToolbar", (ActionGroup)new DefaultActionGroup(new AnAction[]{action}), true);
            rightToolbar.setTargetComponent(editor.getContentComponent());
            headerComponent.add((Component)rightToolbar.getComponent(), "East");
        }
        ((EditorEx)editor).setPermanentHeaderComponent((JComponent)headerComponent);
        editor.setHeaderComponent((JComponent)headerComponent);
        DatabaseEditorHelper.configureEditorHeader(project, virtualFile, (JComponent)headerComponent);
    }

    private static void addSpecificActions(@NotNull Editor editor, DefaultActionGroup group2, final DatabaseElementVirtualFileImpl file) {
        if (editor == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(70);
        }
        group2.addSeparator();
        RefreshAction reloadAction = new RefreshAction("Reload", "", PlatformIcons.SYNCHRONIZE_ICON){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(e.getProject() != null && !file.isBusy());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Project project;
                if (e == null) {
                    8.$$$reportNull$$$0(1);
                }
                if ((project = e.getProject()) == null) {
                    return;
                }
                DatabaseEditorHelper.scheduleReload(project, file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/editor/DatabaseEditorHelper$8";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        reloadAction.registerShortcutOn(editor.getComponent());
        group2.add((AnAction)reloadAction);
    }

    private static void addSpecificActions(@NotNull Editor editor, DefaultActionGroup group2, final VirtualFile file) {
        if (editor == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(71);
        }
        RefreshAction reloadAction = new RefreshAction("Reload", "", PlatformIcons.SYNCHRONIZE_ICON){

            public void update(@NotNull AnActionEvent e) {
                DbElement element;
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                LocalDataSource dataSource = (element = this.getElement(e)) == null ? null : (LocalDataSource)ObjectUtils.tryCast((Object)element.getDataSource().getDelegate(), LocalDataSource.class);
                e.getPresentation().setEnabled(e.getProject() != null && dataSource != null && !dataSource.isInBatch());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                DbElement element;
                if (e == null) {
                    9.$$$reportNull$$$0(1);
                }
                if ((element = this.getElement(e)) == null) {
                    return;
                }
                SynchronizeSchemaAction.refresh(e.getProject(), (JBIterable<DbElement>)JBIterable.of((Object)element));
            }

            @Nullable
            private DbElement getElement(@NotNull AnActionEvent e) {
                Project project;
                if (e == null) {
                    9.$$$reportNull$$$0(2);
                }
                return (project = e.getProject()) == null ? null : DbSrcUtils.findDbElement(project, file.getPath(), DbElement.class);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/editor/DatabaseEditorHelper$9";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        reloadAction.registerShortcutOn(editor.getComponent());
        DumbAwareAction revertAction = new DumbAwareAction(){

            public void update(AnActionEvent e) {
                FileStatus status = DbSrcChangesTracker.getInstance(null).getFileStatus().getStatus(file).getStatus();
                e.getPresentation().setEnabled(status != null && status != FileStatus.NOT_CHANGED);
            }

            public void actionPerformed(AnActionEvent e) {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    try {
                        DbSrcUtils.revert((Iterable<VirtualFile>)JBIterable.of((Object)file));
                    }
                    catch (IOException ex) {
                        DatabaseNotifications.REFACTORING_GROUP.createNotification("Failed to revert " + file.getUrl(), MessageType.INFO).notify(e.getProject());
                    }
                });
            }
        };
        ActionUtil.copyFrom((AnAction)revertAction, (String)"ChangesView.Revert");
        DumbAwareAction diffAction = new DumbAwareAction(){

            public void update(AnActionEvent e) {
                FileStatus status = DbSrcChangesTracker.getInstance(null).getFileStatus().getStatus(file).getStatus();
                e.getPresentation().setEnabled(status != null && status != FileStatus.NOT_CHANGED);
            }

            public void actionPerformed(AnActionEvent e) {
                DbSrcChangesTracker.flushAndUpdateFiles(Collections.singletonList(file));
                Change change = DbSrcChangesTracker.getChange(file);
                if (change == null) {
                    return;
                }
                ShowDiffAction.showDiffForChange((Project)e.getProject(), (Iterable)JBIterable.of((Object)change));
            }

            protected void setShortcutSet(@NotNull ShortcutSet shortcutSet) {
                if (shortcutSet == null) {
                    11.$$$reportNull$$$0(0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortcutSet", "com/intellij/database/editor/DatabaseEditorHelper$11", "setShortcutSet"));
            }
        };
        ActionUtil.copyFrom((AnAction)diffAction, (String)"Diff.ShowDiff");
        DumbAwareAction commitAction = new DumbAwareAction("Submit", null, DatabaseIcons.SubmitDB){

            public void update(AnActionEvent e) {
                boolean visible = e.getProject() != null && DbSrcMigration.isSupported(file);
                e.getPresentation().setVisible(visible);
                boolean enabled = visible;
                if (enabled) {
                    FileStatus status = DbSrcChangesTracker.getInstance(null).getFileStatus().getStatus(file).getStatus();
                    enabled = status != null && status != FileStatus.NOT_CHANGED;
                }
                e.getPresentation().setEnabled(enabled);
            }

            public void actionPerformed(AnActionEvent e) {
                Project project = (Project)ObjectUtils.assertNotNull((Object)e.getProject());
                DbDataSource dataSource = DbImplUtil.findDataSource(project, file);
                if (dataSource != null) {
                    DbSrcMigration.showMigrationDialog(dataSource, Collections.singletonList(file));
                }
            }
        };
        group2.add((AnAction)commitAction);
        group2.add((AnAction)reloadAction);
        group2.add((AnAction)revertAction);
        group2.add((AnAction)diffAction);
    }

    public static void openConsoleFile(@Nullable DbElement element) {
        DatabaseEditorHelper.openConsoleFile(element, false);
    }

    public static void openConsoleFile(@Nullable DbElement element, boolean newInstance) {
        LocalDataSource dataSource;
        LocalDataSource localDataSource = dataSource = element == null ? null : DbImplUtil.getMaybeLocalDataSource((DasDataSource)element.getDataSource());
        if (dataSource == null) {
            return;
        }
        DasNamespace context = element instanceof DbDataSource ? ((DbDataSource)element).getModel().getCurrentRootNamespace() : (DasNamespace)DasUtil.getParentOfClass((DasObject)element, DasNamespace.class, (boolean)false);
        DatabaseEditorHelper.openConsoleFile(element.getProject(), dataSource, context, newInstance);
    }

    public static void openConsoleFile(@NotNull Project project, @NotNull DasDataSource dataSource, @Nullable DasNamespace schema, boolean newInstance) {
        VirtualFile file;
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(72);
        }
        if (dataSource == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(73);
        }
        VirtualFile virtualFile = file = newInstance ? DatabaseEditorHelper.createNewConsoleVirtualFile(dataSource) : DatabaseEditorHelper.getConsoleVirtualFile(dataSource);
        if (file == null) {
            return;
        }
        DatabaseEditorHelper.openConsoleForFile(project, schema, file);
    }

    public static void openConsoleForFile(@NotNull Project project, @Nullable DasNamespace schema, VirtualFile file) {
        List<DasNamespace> namespaces;
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(74);
        }
        FileEditorManager.getInstance((Project)project).openFile(file, true);
        if (schema == null) {
            return;
        }
        JdbcConsole console = JdbcConsole.getConsole(project, file);
        DatabaseDialectEx dialect = console == null ? null : DbImplUtil.getDatabaseDialect(console);
        SearchPath searchPath = DbImplUtil.getAutoSwitchPath(console == null ? null : console.getDataSource(), ObjectPaths.of(namespaces = Collections.singletonList(schema = console == null ? schema : DbImplUtil.getSearchPathObject(dialect, (DasObject)schema))));
        if (searchPath != null) {
            if (console != null) {
                console.switchSchema(searchPath, false);
            } else {
                ChooseSchemaAction.setSelectedSearchPath(file, searchPath);
            }
        }
        DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)PsiManager.getInstance((Project)project).findFile(file), (Object)searchPath);
    }

    @Nullable
    public static VirtualFile getConsoleRootDir(@NotNull DasDataSource dataSource) {
        if (dataSource == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(75);
        }
        String rootPath = DbConsoleRootType.getInstance().getContentRootPath(dataSource.getUniqueId());
        return LocalFileSystem.getInstance().refreshAndFindFileByPath(rootPath);
    }

    @Nullable
    public static VirtualFile getConsoleVirtualFile(@NotNull DasDataSource dataSource) {
        if (dataSource == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(76);
        }
        return ConsoleHistoryController.getContentFile((ConsoleRootType)DbConsoleRootType.getInstance(), (String)dataSource.getUniqueId(), (ScratchFileService.Option)ScratchFileService.Option.create_if_missing);
    }

    @Nullable
    public static VirtualFile findExistingConsoleVirtualFile(@NotNull DasDataSource dataSource) {
        if (dataSource == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(77);
        }
        return ConsoleHistoryController.getContentFile((ConsoleRootType)DbConsoleRootType.getInstance(), (String)dataSource.getUniqueId(), (ScratchFileService.Option)ScratchFileService.Option.existing_only);
    }

    @Nullable
    public static VirtualFile createNewConsoleVirtualFile(@NotNull DasDataSource dataSource) {
        if (dataSource == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(78);
        }
        return ConsoleHistoryController.getContentFile((ConsoleRootType)DbConsoleRootType.getInstance(), (String)dataSource.getUniqueId(), (ScratchFileService.Option)ScratchFileService.Option.create_new_always);
    }

    public static void configureEditorHeader(@Nullable Project project, @Nullable VirtualFile virtualFile, @Nullable JComponent headerComponent) {
        if (headerComponent == null) {
            return;
        }
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(DataManager.getInstance().getDataContext((Component)headerComponent));
        DatabaseGridDataHookUp hookup = DbConsoleRootType.isConsoleFile(virtualFile) ? DataGridUtil.getDatabaseHookUp(dataGrid) : null;
        DasTable table = hookup == null ? null : hookup.getDatabaseTable();
        VirtualFile adjustedFile = table instanceof DbElement ? ((DbElement)table).getVirtualFile() : virtualFile;
        DatabaseColorManager.LocalColors state = project == null ? null : (DatabaseColorManager.LocalColors)DatabaseColorManager.getLocalColorManager(project).getState();
        Color color = state != null && state.useColors ? DatabaseColorManager.getColor(project, adjustedFile, true) : null;
        Color toolbarColor = state != null && state.useInToolbars ? color : null;
        headerComponent.setBackground(toolbarColor);
        for (Component c2 : (JBTreeTraverser)UIUtil.uiTraverser((Component)headerComponent).filter(c -> c instanceof ActionToolbar)) {
            c2.setBackground(toolbarColor);
            ((JComponent)c2).setBorder((Border)JBUI.Borders.empty());
        }
        Color editorColor = state != null && state.useInEditor ? color : null;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext((Component)headerComponent));
        if (editor instanceof EditorEx) {
            Language lang;
            Language language = lang = project == null ? null : LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)((EditorEx)editor).getVirtualFile());
            if (lang != null && lang.getAssociatedFileType() == SqlFileType.INSTANCE) {
                ((EditorEx)editor).setBackgroundColor(editorColor);
                editor.getColorsScheme().setColor(EditorColors.GUTTER_BACKGROUND, (Color)ObjectUtils.notNull((Object)editorColor, (Object)AbstractColorsScheme.INHERITED_COLOR_MARKER));
            }
        } else if (dataGrid != null) {
            dataGrid.getScrollPane().setBackground(editorColor);
            dataGrid.getColorsScheme().setDefaultBackground(editorColor);
        }
    }

    @Nullable
    public static SearchPath getSearchPath(@NotNull PsiFile psiFile) {
        SearchPath res;
        if (psiFile == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(79);
        }
        return (res = (SearchPath)DatabaseDataKeys.SEARCH_PATH_KEY.get((UserDataHolder)psiFile)) != null ? res : DatabaseEditorHelper.initSearchPath(psiFile);
    }

    @Nullable
    public static SearchPath dbSrcSearchPath(@NotNull Project project, @Nullable VirtualFile vfile, boolean schema) {
        ObjectPath path;
        DbDataSource dataSource;
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(80);
        }
        String dataSourceId = vfile == null ? null : DbSrcUtils.getDataSource(vfile);
        DbDataSource dbDataSource = dataSource = dataSourceId == null ? null : DbPsiFacade.getInstance((Project)project).findDataSource(dataSourceId);
        if (dataSource != null && (path = DbSrcUtils.getFullPath(vfile.getPath())) != null) {
            ObjectKind spKind = DbImplUtil.getDatabaseDialect((DbElement)dataSource).getSearchPathObjectKind();
            if (spKind == null) {
                return null;
            }
            ObjectPath spPath = path.findParent(spKind, false);
            if (spPath != null) {
                return SearchPath.of((ObjectPath)spPath);
            }
        }
        return null;
    }

    @Nullable
    public static SearchPath initSearchPath(@NotNull PsiFile psiFile) {
        DbDataSource forcedDataSource;
        if (psiFile == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(81);
        }
        VirtualFile vfile = psiFile.getVirtualFile();
        Project project = psiFile.getProject();
        if (DbSrcUtils.isDbSrcFile(vfile)) {
            SearchPath path = DatabaseEditorHelper.dbSrcSearchPath(project, vfile, false);
            DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)psiFile, (Object)path);
            return path;
        }
        JdbcConsole console = JdbcConsole.findConsole(project, vfile);
        DbDataSource dbDataSource = forcedDataSource = console != null ? DbImplUtil.getDbDataSource(project, (DasDataSource)console.getTarget()) : null;
        if (forcedDataSource != null) {
            SearchPath path = console.getSearchPath();
            DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)psiFile, (Object)path);
            return path;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            SearchPath path = (SearchPath)DatabaseDataKeys.SEARCH_PATH_KEY.get((UserDataHolder)vfile);
            DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)psiFile, (Object)path);
            return path;
        }
        DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)psiFile, null);
        return null;
    }

    @Nullable
    private static BasicNamedElement getNamed(@Nullable BasicElement element, @NotNull ObjectKind kind, @NotNull String name) {
        if (kind == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(82);
        }
        if (name == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(83);
        }
        NamingFamily family = element == null ? null : (NamingFamily)element.familyOf(kind);
        return family == null ? null : (BasicNamedElement)family.get(name);
    }

    @Nullable
    public static DasNamespace findNamespace(@NotNull Project project, @NotNull DasDataSource dataSource, @Nullable ObjectPath objectPath) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(84);
        }
        if (dataSource == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(85);
        }
        if (objectPath == null) {
            return null;
        }
        dataSource = dataSource instanceof DbDataSource ? ((DbDataSource)dataSource).getDelegate() : dataSource;
        BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)dataSource.getModel(), BasicModel.class);
        ObjectKind k = objectPath.kind;
        if (model == null || k != ObjectKind.SCHEMA && k != ObjectKind.DATABASE) {
            return null;
        }
        BasicRoot root2 = model.getRoot();
        if (root2 instanceof BasicModMultiDatabaseRoot) {
            if (k == ObjectKind.DATABASE) {
                return (DasNamespace)DatabaseEditorHelper.getNamed(root2, ObjectKind.DATABASE, objectPath.getName());
            }
            ObjectPath parent = objectPath.parent;
            if (parent != null) {
                return (DasNamespace)DatabaseEditorHelper.getNamed(DatabaseEditorHelper.getNamed(root2, ObjectKind.DATABASE, parent.getName()), ObjectKind.SCHEMA, objectPath.getName());
            }
        }
        if (k != ObjectKind.SCHEMA) {
            return null;
        }
        for (BasicSchema basicSchema : root2.getAllSchemas()) {
            if (!basicSchema.getName().equals(objectPath.getName())) continue;
            return basicSchema;
        }
        return null;
    }

    @Nullable
    public static List<DasNamespace> findNamespaces(@NotNull Project project, @NotNull DasDataSource dataSource, @Nullable SearchPath searchPath) {
        if (project == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(86);
        }
        if (dataSource == null) {
            DatabaseEditorHelper.$$$reportNull$$$0(87);
        }
        if (searchPath == null) {
            return null;
        }
        List sp = JBIterable.from((Iterable)searchPath.elements).transform(p -> {
            if (project == null) {
                DatabaseEditorHelper.$$$reportNull$$$0(88);
            }
            if (dataSource == null) {
                DatabaseEditorHelper.$$$reportNull$$$0(89);
            }
            return DatabaseEditorHelper.findNamespace(project, dataSource, p);
        }).toList();
        return sp.isEmpty() ? null : sp;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 23: 
            case 24: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 47: 
            case 48: 
            case 51: 
            case 55: 
            case 56: 
            case 61: 
            case 64: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 23: 
            case 24: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 47: 
            case 48: 
            case 51: 
            case 55: 
            case 56: 
            case 61: 
            case 64: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 23: 
            case 24: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 47: 
            case 48: 
            case 51: 
            case 55: 
            case 56: 
            case 61: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/editor/DatabaseEditorHelper";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 25: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fem";
                break;
            }
            case 27: 
            case 32: 
            case 45: 
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 28: 
            case 46: 
            case 50: 
            case 54: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 31: 
            case 38: 
            case 43: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 52: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 63: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 85: 
            case 87: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 79: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/editor/DatabaseEditorHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllOpenedEditors";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "reloadIfNeeded";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "generateDefinition";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "generateDefinitionUsingScriptingService";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "tryFormat";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "loadOrGenerateDefinition";
                break;
            }
            case 51: 
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDefinition";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDefinitionImpl";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "scheduleReload";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installEditorFactoryListener";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAllOpenedEditors";
                break;
            }
            case 2: 
            case 23: 
            case 24: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 47: 
            case 48: 
            case 51: 
            case 55: 
            case 56: 
            case 61: 
            case 64: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "restoreAttachedConsole";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeConsoleToolbar";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configureConsoleToolbar";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "configureConsole";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDeadSession";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "disposeConsoleIfSafe";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSession";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findSession";
                break;
            }
            case 20: 
            case 21: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "configureToolbar";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "reloadIfNeeded";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setDdlEditorsDisplayName";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "generateDefinition";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "generateDefinitionUsingScriptingService";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "tryFormat";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "loadOrGenerateDefinition";
                break;
            }
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "loadDefinition";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentSchemaSafe";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "loadDefinitionImpl";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "scheduleReload";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "setVisualProgress";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "addSpecificActions";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "openConsoleFile";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "openConsoleForFile";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleRootDir";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleVirtualFile";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "findExistingConsoleVirtualFile";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "createNewConsoleVirtualFile";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getSearchPath";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "dbSrcSearchPath";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "initSearchPath";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getNamed";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "findNamespace";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "findNamespaces";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findNamespaces$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 23: 
            case 24: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 47: 
            case 48: 
            case 51: 
            case 55: 
            case 56: 
            case 61: 
            case 64: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

