/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridSession;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseTableGridDataHookUp;
import com.intellij.database.datagrid.Grid;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.EditorTableResultPanel;
import com.intellij.database.editor.OpenDataFileDescriptor;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.SearchPath;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.DocumentReferenceProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.NavigatableFileEditor;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.WeakList;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import gnu.trove.TObjectHashingStrategy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableFileEditor
extends TableEditorBase
implements NavigatableFileEditor,
DataProvider,
DocumentReferenceProvider {
    private final VirtualFile myFile;
    private final EditorTableResultPanel myResultPanel;
    private final JPanel myRootPanel;

    public DatabaseTableFileEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(1);
        }
        super(project);
        this.myRootPanel = new JPanel(new BorderLayout());
        this.myFile = file;
        DataGridSession hookUp = GridDataHookUpManager.getInstance(project).getHookUp(file, (Disposable)this);
        this.myResultPanel = new EditorTableResultPanel(project, hookUp){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = "editor:" + DatabaseTableFileEditor.this.getFile().getPresentableName();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseTableFileEditor$1", "getDisplayName"));
            }
        };
        Disposer.register((Disposable)this, (Disposable)this.myResultPanel);
        DataGridUtil.setupProgressIndicatingAuditor(this.myResultPanel);
        if (UnattendedTableLoadingGuard.isSafeToLoadData(project)) {
            DeferredLoader.installOn(this.myResultPanel);
        } else {
            UnattendedTableLoadingGuard.delayLoading(this.myResultPanel);
        }
        DataManager.registerDataProvider((JComponent)this.myRootPanel, (DataProvider)this);
        DataGridUtil.addGridHeaderComponent(this.myResultPanel, this.myFile);
        this.myRootPanel.add((Component)this.myResultPanel.getComponent(), "Center");
        FeatureUsageTracker.getInstance().triggerFeatureUsed("db.table.editor");
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public DataGrid getDataGrid() {
        EditorTableResultPanel editorTableResultPanel = this.myResultPanel;
        if (editorTableResultPanel == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(3);
        }
        return editorTableResultPanel;
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @Override
    public void dispose() {
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.table.editor";
        }
        return null;
    }

    public Collection<DocumentReference> getDocumentReferences() {
        return Collections.singletonList(DocumentReferenceManager.getInstance().create(this.myFile));
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(5);
        }
        return navigatable instanceof OpenDataFileDescriptor;
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(6);
        }
        if (!(navigatable instanceof OpenDataFileDescriptor)) {
            return;
        }
        DeferredLoader.doWhenLoaded(this.myResultPanel, () -> {
            if (navigatable == null) {
                DatabaseTableFileEditor.$$$reportNull$$$0(13);
            }
            ((OpenDataFileDescriptor)navigatable).navigateTo(this.myResultPanel);
        });
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(7);
        }
        if (level == FileEditorStateLevel.FULL) {
            State state = new State();
            this.updateColumnAttributes(state.columnAttributes);
            this.updateFilterState(state.filter);
            State state2 = state;
            if (state2 == null) {
                DatabaseTableFileEditor.$$$reportNull$$$0(8);
            }
            return state2;
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(9);
        }
        return fileEditorState;
    }

    private void updateFilterState(@NotNull State.Filter filterState) {
        if (filterState == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(10);
        }
        filterState.enabled = this.myResultPanel.isFilteringEnabled();
        GridFilteringModel model = this.myResultPanel.getDataHookup().getFilteringModel();
        filterState.applied = this.isDragging() && model != null && model.isFilterApplied();
        filterState.text = model == null ? "" : model.getFilterText();
        filterState.history.clear();
        filterState.history.addAll(this.myResultPanel.getFiltersHistory());
    }

    private void updateColumnAttributes(@NotNull List<State.Column> columnAttributes) {
        if (columnAttributes == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(11);
        }
        columnAttributes.clear();
        GridModel<DataConsumer.Row, DataConsumer.Column> model = this.myResultPanel.getDataModel(DataAccessType.DATABASE_DATA);
        for (ModelIndex columnIdx : model.getColumnIndices().asIterable()) {
            DataConsumer.Column column2 = model.getColumn(columnIdx);
            String columnName = column2 != null ? column2.name : null;
            boolean enabled = this.myResultPanel.isColumnEnabled(columnIdx);
            Language contentLanguage = this.myResultPanel.getContentLanguage(columnIdx);
            if (columnName == null || enabled && contentLanguage == Language.ANY) continue;
            State.Column attributes = new State.Column();
            attributes.name = columnName;
            attributes.enabled = enabled;
            attributes.languageId = contentLanguage.getID();
            columnAttributes.add(attributes);
        }
    }

    @Override
    public void setState(@NotNull FileEditorState state) {
        State s;
        if (state == null) {
            DatabaseTableFileEditor.$$$reportNull$$$0(12);
        }
        if ((s = (State)ObjectUtils.tryCast((Object)state, State.class)) != null) {
            this.applyColumnAttributes(s.columnAttributes);
            this.applyFilterState(s.filter);
        }
    }

    private void applyColumnAttributes(@Nullable List<State.Column> columnAttributes) {
        if (ContainerUtil.isEmpty(columnAttributes)) {
            return;
        }
        Map props = ContainerUtilRt.newHashMap((int)columnAttributes.size());
        for (State.Column attributes : columnAttributes) {
            Language contentLanguage = (Language)ObjectUtils.notNull((Object)Language.findLanguageByID((String)attributes.languageId), (Object)Language.ANY);
            props.put(attributes.name, new EditorTableResultPanel.InitialColumnProperties(attributes.enabled, contentLanguage));
        }
        if (!props.isEmpty()) {
            this.myResultPanel.setInitialColumnProperties(props);
        }
    }

    private void applyFilterState(@Nullable State.Filter filterState) {
        if (filterState == null) {
            return;
        }
        List<Object> filterHistory = filterState.history != null ? filterState.history : ContainerUtil.newArrayList();
        this.myResultPanel.setFiltersHistory(filterHistory);
        if (this.myResultPanel.isFilteringEnabled() != filterState.enabled) {
            this.myResultPanel.toggleFiltering();
        }
        if (!this.isDragging()) {
            return;
        }
        if (filterState.applied) {
            String item = (String)ContainerUtil.getFirstItem((List)filterHistory);
            this.myResultPanel.setFilterText(item == null ? "" : item, -1);
            this.myResultPanel.applyFilter();
            return;
        }
        this.myResultPanel.setFilterText(filterState.text, -1);
    }

    private boolean isDragging() {
        return Boolean.TRUE.equals(FileEditorManagerImpl.CLOSING_TO_REOPEN.get((UserDataHolder)this.myFile));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/editor/DatabaseTableFileEditor";
                break;
            }
            case 5: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterState";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnAttributes";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/editor/DatabaseTableFileEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataGrid";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canNavigateTo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "navigateTo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateFilterState";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateColumnAttributes";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$navigateTo$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class UnattendedTableLoadingGuard
    implements StartupActivity,
    DumbAware {
        private static final Key<Boolean> SAFE_LOADING_KEY = Key.create((String)"DATA_GRID_SAFE_LOADING_KEY");

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                UnattendedTableLoadingGuard.$$$reportNull$$$0(0);
            }
            SAFE_LOADING_KEY.set((UserDataHolder)project, (Object)true);
        }

        public static boolean isSafeToLoadData(@NotNull Project project) {
            if (project == null) {
                UnattendedTableLoadingGuard.$$$reportNull$$$0(1);
            }
            return Boolean.TRUE.equals(SAFE_LOADING_KEY.get((UserDataHolder)project));
        }

        public static boolean isSafeToLoadData(@NotNull DataGrid grid) {
            if (grid == null) {
                UnattendedTableLoadingGuard.$$$reportNull$$$0(2);
            }
            return !Boolean.FALSE.equals(SAFE_LOADING_KEY.get((UserDataHolder)grid));
        }

        public static void delayLoading(@NotNull DataGrid grid) {
            if (grid == null) {
                UnattendedTableLoadingGuard.$$$reportNull$$$0(3);
            }
            SAFE_LOADING_KEY.set((UserDataHolder)grid, (Object)false);
        }

        public static void disable(@NotNull DataGrid grid) {
            if (grid == null) {
                UnattendedTableLoadingGuard.$$$reportNull$$$0(4);
            }
            SAFE_LOADING_KEY.set((UserDataHolder)grid, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/editor/DatabaseTableFileEditor$UnattendedTableLoadingGuard";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runActivity";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSafeToLoadData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "delayLoading";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "disable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DeferredLoader
    extends Activatable.Adapter
    implements ModificationTrackerListener<DbPsiFacade>,
    Disposable {
        private static final Map<DatabaseTableGridDataHookUp, DeferredLoader> LOADERS = ConcurrentCollectionFactory.createMap((TObjectHashingStrategy)TObjectHashingStrategy.IDENTITY);
        private final DataGridSession mySession;
        private final Collection<DataGrid> myGrids;
        private final ActionCallback myInitialLoadCallback;
        private LoadingState myState;

        private DeferredLoader(@NotNull DataGridSession session) {
            if (session == null) {
                DeferredLoader.$$$reportNull$$$0(0);
            }
            this.myGrids = new WeakList();
            this.myInitialLoadCallback = new ActionCallback();
            this.myState = LoadingState.NONE;
            this.mySession = session;
            Disposer.register((Disposable)this.mySession, (Disposable)this);
        }

        public static void installOn(@NotNull DataGrid grid) {
            DataGridSession session;
            DeferredLoader loader;
            if (grid == null) {
                DeferredLoader.$$$reportNull$$$0(1);
            }
            if ((loader = LOADERS.get(session = DeferredLoader.getTableHookUp(grid))) == null) {
                loader = new DeferredLoader(session);
                LOADERS.put(session, loader);
            }
            loader.addGrid(grid);
        }

        public static void doWhenLoaded(@NotNull DataGrid grid, @NotNull Runnable action) {
            DeferredLoader loader;
            if (grid == null) {
                DeferredLoader.$$$reportNull$$$0(2);
            }
            if (action == null) {
                DeferredLoader.$$$reportNull$$$0(3);
            }
            ActionCallback callback = (loader = LOADERS.get(DeferredLoader.getTableHookUp(grid))) == null ? ActionCallback.DONE : loader.myInitialLoadCallback;
            callback.doWhenDone((Runnable)new DoWhenLoadedActionWrapper(grid, action));
        }

        @NotNull
        private static DataGridSession getTableHookUp(@NotNull DataGrid grid) {
            if (grid == null) {
                DeferredLoader.$$$reportNull$$$0(4);
            }
            DataGridSession dataGridSession = (DataGridSession)grid.getDataHookup();
            if (dataGridSession == null) {
                DeferredLoader.$$$reportNull$$$0(5);
            }
            return dataGridSession;
        }

        private void addGrid(@NotNull DataGrid grid) {
            if (grid == null) {
                DeferredLoader.$$$reportNull$$$0(6);
            }
            this.myGrids.add(grid);
            if (this.myState == LoadingState.NONE) {
                Disposer.register((Disposable)grid, (Disposable)new UiNotifyConnector.Once((Component)grid.getComponent(), (Activatable)this));
            }
        }

        public void showNotify() {
            if (this.myState != LoadingState.NONE) {
                return;
            }
            this.myState = LoadingState.INITIATED;
            for (DataGrid grid : this.myGrids) {
                DataGridUtil.setProgressMessage(grid, "Connecting...");
            }
            DbPsiFacade psiFacade = DbPsiFacade.getInstance((Project)this.mySession.getProject());
            psiFacade.addModificationTrackerListener((ModificationTrackerListener)this, (Disposable)this);
            this.modificationCountChanged(psiFacade);
        }

        public void modificationCountChanged(DbPsiFacade source) {
            DbElement element;
            VirtualFile file = this.mySession.getVirtualFile();
            DbElement dbElement = element = file.isValid() ? DbImplUtil.findElement(this.mySession.getProject(), file) : null;
            if (element == null) {
                return;
            }
            if (this.myState != LoadingState.COMPLETED && DatabaseEditorHelper.isTableDataAvailable(element)) {
                this.myState = LoadingState.COMPLETED;
                this.loadTable();
            }
        }

        private void loadTable() {
            final GridRequestSource<DataConsumer.Row, DataConsumer.Column> initialLoadSource = GridRequestSource.create((Grid)JBIterable.from(this.myGrids).first(), null);
            Disposable initialLoadDisposable = Disposer.newDisposable();
            Disposer.register((Disposable)this, (Disposable)initialLoadDisposable);
            this.mySession.addRequestListener(new GridDataHookUp.RequestListener<DataConsumer.Row, DataConsumer.Column>(){
                private String myErrorMessage;

                @Override
                public void error(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @Nullable String message, @Nullable Throwable th) {
                    if (source == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (initialLoadSource == source) {
                        this.myErrorMessage = message;
                    }
                }

                @Override
                public void updateCountReceived(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int updateCount2) {
                    if (source == null) {
                        1.$$$reportNull$$$0(1);
                    }
                }

                @Override
                public void requestFinished(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, boolean success) {
                    if (source == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (initialLoadSource == source) {
                        if (!success) {
                            myInitialLoadCallback.reject(this.myErrorMessage);
                        } else {
                            myInitialLoadCallback.setDone();
                        }
                        Disposer.dispose((Disposable)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "source";
                    objectArray2[1] = "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "error";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "updateCountReceived";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "requestFinished";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, initialLoadDisposable);
            this.tweakSearchPath();
            this.mySession.getLoader().loadFirstPage(initialLoadSource);
        }

        private void tweakSearchPath() {
            DatabaseDialectEx dialect = this.mySession.getDatabaseDialect();
            DasNamespace object = DbImplUtil.getSearchPathObject(dialect, (DasObject)this.mySession.getDatabaseTable());
            if (object == null) {
                return;
            }
            LocalDataSource dataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)this.mySession.getDataSource());
            SearchPath path = DbImplUtil.getAutoSwitchPath(dataSource, ObjectPaths.searchPathOf((DasObject)object));
            if (path == null) {
                return;
            }
            this.mySession.getMessageBus().getDataProducer().processRequest(DataRequest.newSchemaSwitchRequest(this.mySession, path, false));
        }

        public void dispose() {
            LOADERS.remove(this.mySession);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTableHookUp";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "installOn";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "doWhenLoaded";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getTableHookUp";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addGrid";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class DoWhenLoadedActionWrapper
        implements Runnable,
        Disposable {
            private Runnable myAction;

            public DoWhenLoadedActionWrapper(@NotNull DataGrid grid, @NotNull Runnable action) {
                if (grid == null) {
                    DoWhenLoadedActionWrapper.$$$reportNull$$$0(0);
                }
                if (action == null) {
                    DoWhenLoadedActionWrapper.$$$reportNull$$$0(1);
                }
                this.myAction = action;
                Disposer.register((Disposable)grid, (Disposable)this);
            }

            public void dispose() {
                this.myAction = null;
            }

            @Override
            public void run() {
                try {
                    if (this.myAction != null) {
                        this.myAction.run();
                    }
                }
                finally {
                    this.myAction = null;
                    Disposer.dispose((Disposable)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "grid";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "action";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/editor/DatabaseTableFileEditor$DeferredLoader$DoWhenLoadedActionWrapper";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        static enum LoadingState {
            NONE,
            INITIATED,
            COMPLETED;

        }
    }

    static class State
    implements FileEditorState,
    Serializable {
        @Property(surroundWithTag=false)
        public Filter filter = new Filter();
        @XCollection(propertyElementName="column-attributes", elementTypes={Column.class})
        public List<Column> columnAttributes = ContainerUtil.newArrayList();

        State() {
        }

        public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
            return false;
        }

        @Tag(value="column")
        static class Column
        implements Serializable {
            @Attribute(value="name")
            public String name = "";
            @Attribute(value="enabled")
            public boolean enabled = true;
            @Attribute(value="languageId")
            public String languageId = Language.ANY.getID();

            Column() {
            }
        }

        @Tag(value="filtering")
        static class Filter
        implements Serializable {
            @Attribute(value="enabled")
            public boolean enabled = false;
            @Attribute(value="applied")
            public boolean applied = false;
            @Attribute(value="text")
            public String text = "";
            @Property(surroundWithTag=false)
            @XCollection(elementName="filter", valueAttributeName="text")
            public List<String> history = ContainerUtil.newArrayList();

            Filter() {
            }
        }
    }
}

