/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.CustomSeparatedExtractor;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractorsUtil {
    private ExtractorsUtil() {
    }

    @NotNull
    public static String getPresentableSize(long length) {
        String string = StringUtil.formatFileSize((long)length);
        if (string == null) {
            ExtractorsUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    public static int guessJdbcType(@NotNull DataConsumer.Column column2) {
        if (column2 == null) {
            ExtractorsUtil.$$$reportNull$$$0(1);
        }
        if (column2.type != 1111) {
            return column2.type;
        }
        int byType = JdbcUtil.guessJdbcTypeByName((String)column2.typeName);
        if (byType == -6 && column2.clazz.equals("java.lang.Boolean")) {
            return 16;
        }
        if (byType != 0 || column2.clazz == null) {
            return byType;
        }
        if (column2.clazz.equals("java.lang.Boolean")) {
            return 16;
        }
        if (column2.clazz.equals("java.lang.String")) {
            return 12;
        }
        if (column2.clazz.equals("java.lang.Integer")) {
            return 4;
        }
        if (column2.clazz.equals("java.lang.Double")) {
            return 8;
        }
        if (column2.clazz.equals("java.lang.Float")) {
            return 6;
        }
        if (column2.clazz.endsWith(".Date")) {
            return 91;
        }
        if (column2.clazz.endsWith(".Time")) {
            return 92;
        }
        if (column2.clazz.endsWith(".Timestamp")) {
            return 93;
        }
        if (column2.clazz.endsWith(".UUID")) {
            return 12;
        }
        return byType;
    }

    @NotNull
    public static CharOut extract(@NotNull CharOut out, DatabaseDialectEx dialect, boolean forceSkipHeader, List<DataConsumer.Column> allColumns, DataExtractor extractor, List<DataConsumer.Row> rows, int ... selectedColumns) {
        if (out == null) {
            ExtractorsUtil.$$$reportNull$$$0(2);
        }
        DataExtractor.Extraction e = extractor.startExtraction(out, dialect, forceSkipHeader, allColumns, selectedColumns);
        e.addData(rows);
        e.complete();
        CharOut charOut = out;
        if (charOut == null) {
            ExtractorsUtil.$$$reportNull$$$0(3);
        }
        return charOut;
    }

    public static DataExtractor getSingleValueExtractor(@NotNull ObjectFormatter converter) {
        if (converter == null) {
            ExtractorsUtil.$$$reportNull$$$0(4);
        }
        return new CustomSeparatedExtractor(converter){

            @Override
            protected boolean isStringLiteral(@NotNull DatabaseDialect dialect, @NotNull String value, @Nullable DataConsumer.Row row, @Nullable DataConsumer.Column column2) {
                if (dialect == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value == null) {
                    1.$$$reportNull$$$0(1);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dialect";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "value";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/extractors/ExtractorsUtil$1";
                objectArray[2] = "isStringLiteral";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    static TIntObjectHashMap<DataConsumer.Column> getColumnNumsToColumnsMapping(@NotNull List<DataConsumer.Column> columns2) {
        if (columns2 == null) {
            ExtractorsUtil.$$$reportNull$$$0(5);
        }
        TIntObjectHashMap m = new TIntObjectHashMap(columns2.size());
        for (DataConsumer.Column column2 : columns2) {
            m.put(column2.columnNum, (Object)column2);
        }
        return m;
    }

    static int[] getNonEmptySelection(@NotNull List<DataConsumer.Column> allColumns, int[] providedSelection) {
        if (allColumns == null) {
            ExtractorsUtil.$$$reportNull$$$0(6);
        }
        if (providedSelection.length != 0) {
            return providedSelection;
        }
        int[] selection = new int[allColumns.size()];
        for (int i2 = 0; i2 < allColumns.size(); ++i2) {
            selection[i2] = allColumns.get((int)i2).columnNum;
        }
        return selection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/ExtractorsUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableSize";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/ExtractorsUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "extract";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "guessJdbcType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSingleValueExtractor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getColumnNumsToColumnsMapping";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNonEmptySelection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

