/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.TranspositionAwareDefaultExtractor;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.CharOut;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlValuesExtractor
extends TranspositionAwareDefaultExtractor<DatabaseSettings.StdState> {
    public HtmlValuesExtractor(ObjectFormatter converter) {
        this(new DatabaseSettings.StdState(), converter);
    }

    public HtmlValuesExtractor(DatabaseSettings.StdState state, ObjectFormatter converter) {
        super(state, converter);
    }

    @NotNull
    public String getDataPrefix() {
        if ("<table border=\"1\" style=\"border-collapse:collapse\">" == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(0);
        }
        return "<table border=\"1\" style=\"border-collapse:collapse\">";
    }

    @NotNull
    public String getDataSuffix() {
        if ("</table>" == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(1);
        }
        return "</table>";
    }

    @Override
    @NotNull
    public String getLinePrefix() {
        if ("<tr>" == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(2);
        }
        return "<tr>";
    }

    @Override
    @NotNull
    public String getLineSuffix() {
        if ("</tr>" == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(3);
        }
        return "</tr>";
    }

    @Override
    @NotNull
    public String getValuePrefix() {
        if ("<td>" == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(4);
        }
        return "<td>";
    }

    @Override
    @NotNull
    public String getValueSuffix() {
        if ("</td>" == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(5);
        }
        return "</td>";
    }

    @Override
    public String getColumnName(DataConsumer.Column column2) {
        return "<th>" + column2.name + "</th>";
    }

    @Override
    public String getValueSeparator() {
        return "";
    }

    @Override
    @Nullable
    protected String getValueAsString(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column2, @NotNull DatabaseDialect dialect, boolean forDisplay) {
        if (row == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(6);
        }
        if (column2 == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(7);
        }
        if (dialect == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(8);
        }
        return this.getValueAsString(row, column2, dialect, forDisplay, true);
    }

    @Nullable
    protected String getValueAsString(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column2, @NotNull DatabaseDialect dialect, boolean forDisplay, boolean escape) {
        if (row == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(9);
        }
        if (column2 == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(10);
        }
        if (dialect == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(11);
        }
        String repr = super.getValueAsString(row, column2, dialect, forDisplay);
        return escape ? this.escapeChars(repr) : repr;
    }

    @Nullable
    protected String escapeChars(@Nullable String s) {
        return s != null ? StringUtil.escapeXml((String)s.replaceAll("\t|\b|\\f", "")).replaceAll("\\r|\\n|\\r\\n", "<br/>") : null;
    }

    @Override
    @NotNull
    public String getFileExtension() {
        if ("html" == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(12);
        }
        return "html";
    }

    @Override
    protected TranspositionAwareDefaultExtractor.TranspositionAwareExtractionBase startExtraction(CharOut out, DatabaseDialectEx dialect, boolean forceSkipHeader, boolean transposedMode, List<DataConsumer.Column> allColumns, int ... selectedColumns) {
        return new HtmlExtraction(out, dialect, forceSkipHeader, transposedMode, allColumns, selectedColumns);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/HtmlValuesExtractor";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataPrefix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSuffix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinePrefix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineSuffix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValuePrefix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueSuffix";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/HtmlValuesExtractor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileExtension";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getValueAsString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class HtmlExtraction
    extends TranspositionAwareDefaultExtractor.TranspositionAwareExtractionBase {
        public HtmlExtraction(CharOut output, DatabaseDialectEx dialect, boolean forceSkipHeader, boolean transpose, List<DataConsumer.Column> allColumns, int[] selectedColumnIndices) {
            super(HtmlValuesExtractor.this, output, dialect, forceSkipHeader, transpose, allColumns, selectedColumnIndices);
        }

        @Override
        protected void doAppendHeader(boolean appendNewLine) {
            this.myOutput.append("<!DOCTYPE html>\n<html>\n<head>\n  <title></title>\n</head>\n<body>\n").append(HtmlValuesExtractor.this.getDataPrefix()).append("\n");
            super.doAppendHeader(appendNewLine);
        }

        @Override
        protected void doAppendFooter() {
            this.myOutput.append(HtmlValuesExtractor.this.getDataSuffix()).append("\n</body>\n</html>");
        }
    }
}

