/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors.tz;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.extractors.tz.TimeZonedValue;
import com.intellij.database.remote.jdbc.JdbcInjection;
import com.intellij.database.run.ui.grid.editors.DataGridFormattersUtil;
import com.intellij.openapi.util.Comparing;
import java.sql.Time;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.util.Calendar;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;

public class TimeZonedTime
extends TimeZonedValue<OffsetTime> {
    public TimeZonedTime(@NotNull OffsetTime time) {
        if (time == null) {
            TimeZonedTime.$$$reportNull$$$0(0);
        }
        super(time);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TimeZonedTime)) {
            return false;
        }
        TimeZonedTime ttz = (TimeZonedTime)obj;
        return Comparing.equal(ttz.getValue(), this.getValue());
    }

    @Override
    @NotNull
    public JdbcInjection injection(@NotNull DatabaseFamilyId family) {
        if (family == null) {
            TimeZonedTime.$$$reportNull$$$0(1);
        }
        OffsetTime value = (OffsetTime)this.getValue();
        TimeZone zone = TimeZone.getTimeZone(value.getOffset());
        LocalTime time = value.withOffsetSameInstant(DataGridFormattersUtil.getLocalTimeOffset()).toLocalTime();
        JdbcInjection.TimeInjection timeInjection = new JdbcInjection.TimeInjection(family.isClickHouse() ? null : Calendar.getInstance(zone), Time.valueOf(time));
        if (timeInjection == null) {
            TimeZonedTime.$$$reportNull$$$0(2);
        }
        return timeInjection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "time";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/tz/TimeZonedTime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/tz/TimeZonedTime";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "injection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "injection";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

