/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.BaseIntrospectionFunctions;
import com.intellij.database.introspection.BaseIntrospector;
import com.intellij.database.introspection.BaseSingleDatabaseIntrospector;
import com.intellij.database.introspection.CHouseIntroQueries;
import com.intellij.database.introspection.CHouseIntrospector;
import com.intellij.database.introspection.CHouseIntrospector$CHouseSchemaRetriever$process$;
import com.intellij.database.introspection.CHouseIntrospectorKt;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.clickhouse.CHouseLikeTable;
import com.intellij.database.model.clickhouse.CHouseModLikeColumn;
import com.intellij.database.model.clickhouse.CHouseModLikeTable;
import com.intellij.database.model.clickhouse.CHouseModMatView;
import com.intellij.database.model.clickhouse.CHouseModModel;
import com.intellij.database.model.clickhouse.CHouseModRoot;
import com.intellij.database.model.clickhouse.CHouseModRoutine;
import com.intellij.database.model.clickhouse.CHouseModSchema;
import com.intellij.database.model.clickhouse.CHouseModTable;
import com.intellij.database.model.clickhouse.CHouseModTableColumn;
import com.intellij.database.model.clickhouse.CHouseModView;
import com.intellij.database.model.clickhouse.CHouseRoot;
import com.intellij.database.model.clickhouse.CHouseSchema;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.MysqlColumnKind;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.clickhouse.CHouseNamingService;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.database.SqlLanguageObjectBuilder;
import com.intellij.sql.database.SqlObjectBuilder;
import com.intellij.sql.dialects.DatabaseFamilyBean;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.text.StringKt;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.ClickHouse;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBQueryRunner;
import org.jetbrains.dekaf.core.DBSession;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.InSession;
import org.jetbrains.dekaf.core.InTransaction;
import org.jetbrains.dekaf.exceptions.DBException;
import org.jetbrains.dekaf.sql.SqlQuery;
import org.jetbrains.dekaf.util.StringOperator;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0001:\u0003678B\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002JF\u0010\u001a\u001a00\u001bR,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0003H\u0014JF\u0010 \u001a00!R,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0005H\u0014J\b\u0010#\u001a\u00020\u0016H\u0014J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u001eH\u0014J\u0018\u0010&\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0005H\u0002J\u001e\u0010'\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u001e2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018H\u0014J\b\u0010)\u001a\u00020\u0016H\u0016J\u0018\u0010*\u001a\u00020+2\u0006\u0010%\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0005H\u0014J\b\u0010,\u001a\u00020\u0016H\u0016J\u0010\u0010-\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u001eH\u0002J\u0010\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u000200H\u0002J\u001f\u00101\u001a\u00020\u00162\u0014\b\u0004\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001603H\u0082\bJB\u00104\u001a\u00020\u0016*005R,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u001c2\u0006\u0010/\u001a\u000200H\u0002R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/database/introspection/CHouseIntrospector;", "Lcom/intellij/database/introspection/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/model/clickhouse/CHouseModModel;", "Lcom/intellij/database/model/clickhouse/CHouseRoot;", "Lcom/intellij/database/model/clickhouse/CHouseModRoot;", "Lcom/intellij/database/model/clickhouse/CHouseSchema;", "Lcom/intellij/database/model/clickhouse/CHouseModSchema;", "()V", "builder", "Lcom/intellij/sql/database/SqlObjectBuilder;", "kotlin.jvm.PlatformType", "packLimit", "", "getPackLimit", "()I", "setPackLimit", "(I)V", "sqlFacade", "Lcom/intellij/sql/psi/SqlPsiFacade;", "sqlLanguage", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "applySchemas", "", "newSchemas", "", "", "createDatabaseRetriever", "Lcom/intellij/database/introspection/BaseIntrospector$AbstractDatabaseRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/introspection/BaseIntrospector$AbstractSchemaRetriever;", "schema", "initConnectionRelatedState", "introspectNamespacesInTran", "tran", "introspectOneSchema", "introspectSchemasAuto", "schemas", "introspectServerObjects", "isPossibleToIntrospectSchemaIncrementally", "", "retrieveAndApplySchemas", "retrieveFunctions", "scriptName", "o", "Lcom/intellij/database/model/basic/BasicNamedElement;", "workWithModel", "modifier", "Lkotlin/Function1;", "setFqn", "Lcom/intellij/database/introspection/BaseIntrospector$AbstractRetriever;", "CHouseDatabaseRetriever", "CHouseSchemaRetriever", "VERSION", "intellij.database.introspection"})
public final class CHouseIntrospector
extends BaseSingleDatabaseIntrospector<CHouseModModel, CHouseRoot, CHouseModRoot, CHouseSchema, CHouseModSchema> {
    private final SqlPsiFacade sqlFacade;
    private final SqlLanguageDialect sqlLanguage;
    private final SqlObjectBuilder builder;
    private int packLimit;

    public final int getPackLimit() {
        return this.packLimit;
    }

    public final void setPackLimit(int n) {
        this.packLimit = n;
    }

    @Override
    protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull CHouseSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        return false;
    }

    private final void workWithModel(Function1<? super CHouseModRoot, Unit> modifier) {
        ((CHouseModModel)this.getModel()).modify(CHouseModRoot.class, new ModelModifier<CHouseModRoot>(modifier){
            final /* synthetic */ Function1 $modifier;

            public final void perform(CHouseModRoot it) {
                CHouseModRoot cHouseModRoot = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)cHouseModRoot, (String)"it");
                this.$modifier.invoke((Object)cHouseModRoot);
            }
            {
                this.$modifier = function1;
            }
        });
    }

    @Override
    protected void initConnectionRelatedState() {
        super.initConnectionRelatedState();
        Map map = this.queryParameters;
        String string = "TMPTAB";
        Boolean bl = this.getServerVersion().isOrGreater(new int[]{1, 1, 54356});
        map.put(string, bl);
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        List<String> schemaNames;
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        SqlQuery<List<String>> sqlQuery = CHouseIntroQueries.QUERIES.retrieveSchemas;
        Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"QUERIES.retrieveSchemas");
        List<String> list = schemaNames = this.performQuery(tran, sqlQuery);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"schemaNames");
        this.applySchemas(list);
    }

    @Override
    public void retrieveAndApplySchemas() {
        CHouseIntrospector this_$iv = this;
        DBFacade dBFacade = BaseIntrospector.access$getDbFacade$p(this_$iv);
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf$iv = dBFacade;
        CHouseIntrospector this_$iv$iv = this_$iv;
        List schemaNames = (List)(BaseIntrospector.access$getSingleTransaction$p(this_$iv$iv) ? dbf$iv.inTransaction((InTransaction)new InTransaction<List<? extends String>>(){

            public final List<? extends String> run(@NotNull DBTransaction tran) {
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                DBTransaction tran2 = tran;
                Object object = tran2.query(CHouseIntroQueries.QUERIES.retrieveSchemas).run();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"tran.query(QUERIES.retrieveSchemas).run()");
                return (List)object;
            }
        }) : dbf$iv.inSession((InSession)new InSession<List<? extends String>>(){

            public final List<? extends String> run(@NotNull DBSession session) {
                Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
                DBTransaction tran = (DBTransaction)session;
                Object object = tran.query(CHouseIntroQueries.QUERIES.retrieveSchemas).run();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"tran.query(QUERIES.retrieveSchemas).run()");
                return (List)object;
            }
        }));
        this.applySchemas(schemaNames);
    }

    private final void applySchemas(List<String> newSchemas) {
        CHouseIntrospector this_$iv = this;
        ((CHouseModModel)this_$iv.getModel()).modify(CHouseModRoot.class, new ModelModifier<CHouseModRoot>(newSchemas){
            final /* synthetic */ List $newSchemas$inlined;
            {
                this.$newSchemas$inlined = list;
            }

            public final void perform(CHouseModRoot it) {
                CHouseModRoot cHouseModRoot = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)cHouseModRoot, (String)"it");
                CHouseModRoot root2 = cHouseModRoot;
                NamingFamily schemas = root2.getSchemas();
                Function1 it2 = BaseIntrospectionFunctions.cleanupFamilies.1.INSTANCE;
                NamingFamily namingFamily = schemas;
                Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily, (String)"schemas");
                it2.invoke((Object)namingFamily);
                boolean empty = schemas.isEmpty();
                boolean first = true;
                for (String s : this.$newSchemas$inlined) {
                    CHouseModSchema schema = (CHouseModSchema)schemas.createOrGet(s);
                    if (!first) continue;
                    CHouseModSchema cHouseModSchema = schema;
                    Intrinsics.checkExpressionValueIsNotNull((Object)cHouseModSchema, (String)"schema");
                    cHouseModSchema.setCurrent(true);
                    if (empty) {
                        schema.setVisible(true);
                    }
                    first = false;
                }
                it = BaseIntrospectionFunctions.cleanupFamilies.2.INSTANCE;
                it.invoke((Object)schemas);
            }
        });
    }

    @Override
    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends CHouseSchema> schemas) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Intrinsics.checkParameterIsNotNull(schemas, (String)"schemas");
        for (CHouseSchema cHouseSchema : schemas) {
            this.introspectOneSchema(tran, cHouseSchema);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void introspectOneSchema(DBTransaction tran, CHouseSchema schema) {
        void this_$iv;
        CHouseIntrospector cHouseIntrospector = this;
        String operationName$iv = "Introspect schema " + schema.getName();
        try {
            BaseIntrospector.AbstractSchemaRetriever retriever = this.createSchemaRetriever(tran, schema);
            retriever.process();
        }
        catch (InterruptedException ie$iv) {
            throw (Throwable)ie$iv;
        }
        catch (DBException d$iv) {
            String message$iv = "Error encountered when performing " + operationName$iv + ": " + d$iv.getMessage();
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)d$iv);
        }
        catch (NullPointerException npe$iv) {
            String message$iv = "NPE encountered when performing " + operationName$iv;
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)npe$iv);
            BaseIntrospector.access$getLog$p((BaseIntrospector)this_$iv).error(message$iv, (Throwable)npe$iv);
        }
        catch (Exception e$iv) {
            String message$iv = "Unexpected error (" + e$iv.getClass().getSimpleName() + ") encountered when performing " + operationName$iv + ": " + e$iv.getMessage();
            this_$iv.getErrorSink().consume((Object)message$iv, (Object)e$iv);
        }
    }

    @Override
    public void introspectServerObjects() {
        CHouseIntrospector this_$iv = this;
        DBFacade dBFacade = BaseIntrospector.access$getDbFacade$p(this_$iv);
        if (dBFacade == null) {
            throw (Throwable)new IllegalStateException("Not attached to DB facade");
        }
        DBFacade dbf$iv = dBFacade;
        CHouseIntrospector this_$iv$iv = this_$iv;
        Object object = BaseIntrospector.access$getSingleTransaction$p(this_$iv$iv) ? dbf$iv.inTransaction(new InTransaction<T>(this){
            final /* synthetic */ CHouseIntrospector this$0;
            {
                this.this$0 = cHouseIntrospector;
            }

            public final T run(@NotNull DBTransaction tran) {
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                DBTransaction it = tran;
                CHouseIntrospector.access$retrieveFunctions(this.this$0, it);
                return (T)Unit.INSTANCE;
            }
        }) : dbf$iv.inSession(new InSession<T>(this){
            final /* synthetic */ CHouseIntrospector this$0;
            {
                this.this$0 = cHouseIntrospector;
            }

            public final T run(@NotNull DBSession session) {
                Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
                DBTransaction it = (DBTransaction)session;
                CHouseIntrospector.access$retrieveFunctions(this.this$0, it);
                return (T)Unit.INSTANCE;
            }
        });
    }

    private final void retrieveFunctions(DBTransaction tran) {
        this.updateStatus("Introspecting server objects", "routines");
        CHouseIntrospector this_$iv = this;
        ((CHouseModModel)this_$iv.getModel()).modify(CHouseModRoot.class, new ModelModifier<CHouseModRoot>(tran){
            final /* synthetic */ DBTransaction $tran$inlined;
            {
                this.$tran$inlined = dBTransaction;
            }

            public final void perform(CHouseModRoot it) {
                CHouseModRoot cHouseModRoot = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)cHouseModRoot, (String)"it");
                CHouseModRoot root2 = cHouseModRoot;
                Object it2 = BaseIntrospectionFunctions.cleanupFamilies.1.INSTANCE;
                NamingFamily namingFamily = root2.getRoutines();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily, (String)"root.routines");
                it2.invoke((Object)namingFamily);
                for (CHouseIntroQueries.FunctionInfo r : (List)this.$tran$inlined.query(CHouseIntroQueries.QUERIES.retrieveFunctions).run()) {
                    CHouseModRoutine routine;
                    CHouseModRoutine cHouseModRoutine = routine = (CHouseModRoutine)root2.getRoutines().createOrGet(r.name);
                    Intrinsics.checkExpressionValueIsNotNull((Object)cHouseModRoutine, (String)"routine");
                    cHouseModRoutine.setAggregate(r.is_aggregate);
                    routine.getArguments().clear();
                }
                it2 = BaseIntrospectionFunctions.cleanupFamilies.2.INSTANCE;
                NamingFamily namingFamily2 = root2.getRoutines();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily2, (String)"root.routines");
                it2.invoke((Object)namingFamily2);
            }
        });
    }

    private final String scriptName(BasicNamedElement o) {
        String string = o.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"o.name");
        return CHouseNamingService.INSTANCE.nameToScript(string, o.isNameScripted() && !o.isNameQuoted());
    }

    @Override
    @NotNull
    protected BaseIntrospector.AbstractDatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull CHouseRoot database) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        return new CHouseDatabaseRetriever(transaction);
    }

    @Override
    @NotNull
    protected BaseIntrospector.AbstractSchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull CHouseSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        return new CHouseSchemaRetriever(transaction, schema);
    }

    private final void setFqn(@NotNull BaseIntrospector.AbstractRetriever $receiver, BasicNamedElement o) {
        StringBuilder stringBuilder = new StringBuilder();
        BasicSchema basicSchema = o.getSchema();
        if (basicSchema == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)basicSchema, (String)"o.schema!!");
        $receiver.setQueryParameter$intellij_database_introspection("FQN", stringBuilder.append(this.scriptName(basicSchema)).append('.').append(this.scriptName(o)).toString());
    }

    public CHouseIntrospector() {
        Rdbms rdbms = ClickHouse.RDBMS;
        Intrinsics.checkExpressionValueIsNotNull((Object)rdbms, (String)"ClickHouse.RDBMS");
        super(rdbms, CHouseModModel.class, CHouseModRoot.class, CHouseModSchema.class);
        ProjectManager projectManager = ProjectManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
        this.sqlFacade = SqlPsiFacade.getInstance((Project)projectManager.getDefaultProject());
        DatabaseFamilyBean databaseFamilyBean = DatabaseFamilyBean.findByRdbms((String)ClickHouse.RDBMS.code);
        if (databaseFamilyBean == null) {
            Intrinsics.throwNpe();
        }
        NotNullLazyValue notNullLazyValue = databaseFamilyBean.language;
        Intrinsics.checkExpressionValueIsNotNull((Object)notNullLazyValue, (String)"DatabaseFamilyBean.findB\u2026se.RDBMS.code)!!.language");
        this.sqlLanguage = (SqlLanguageDialect)notNullLazyValue.getValue();
        this.builder = (SqlObjectBuilder)SqlLanguageObjectBuilder.INSTANCE.forLanguage((Language)this.sqlLanguage);
        this.packLimit = 1000;
    }

    public static final /* synthetic */ void access$retrieveFunctions(CHouseIntrospector $this, @NotNull DBTransaction tran) {
        $this.retrieveFunctions(tran);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002$0\u0001R \u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0002B\r\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J8\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0014H\u0014\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/introspection/CHouseIntrospector$CHouseDatabaseRetriever;", "Lcom/intellij/database/introspection/BaseSingleDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/introspection/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/model/clickhouse/CHouseModModel;", "Lcom/intellij/database/model/clickhouse/CHouseRoot;", "Lcom/intellij/database/model/clickhouse/CHouseModRoot;", "Lcom/intellij/database/model/clickhouse/CHouseSchema;", "Lcom/intellij/database/model/clickhouse/CHouseModSchema;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "(Lcom/intellij/database/introspection/CHouseIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;)V", "process", "", "retrieveNativeDefinitionsFor", "kind", "Lcom/intellij/database/model/ObjectKind;", "elements", "", "Lcom/intellij/database/model/basic/BasicElement;", "result", "", "", "", "intellij.database.introspection"})
    private final class CHouseDatabaseRetriever
    extends BaseSingleDatabaseIntrospector.BaseDatabaseRetriever {
        @Override
        public void process() {
        }

        @Override
        protected void retrieveNativeDefinitionsFor(@NotNull ObjectKind kind, @NotNull Iterable<? extends BasicElement> elements, @NotNull Map<BasicElement, String[]> result2) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            Intrinsics.checkParameterIsNotNull(result2, (String)"result");
            if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.TABLE) ^ true && Intrinsics.areEqual((Object)kind, (Object)ObjectKind.VIEW) ^ true && Intrinsics.areEqual((Object)kind, (Object)ObjectKind.MAT_VIEW) ^ true) {
                return;
            }
            Iterator<? extends BasicElement> iterator2 = elements.iterator();
            while (iterator2.hasNext()) {
                BasicElement element;
                BasicElement basicElement = element = iterator2.next();
                if (basicElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicNamedElement");
                }
                CHouseIntrospector.this.setFqn(this, (BasicNamedElement)basicElement);
                Map<BasicElement, String[]> map = result2;
                String[] stringArray = new String[1];
                SqlQuery<String> sqlQuery = CHouseIntroQueries.QUERIES.retrieveTableSource;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"QUERIES.retrieveTableSource");
                String string = this.performQuery(sqlQuery);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"performQuery(QUERIES.retrieveTableSource)");
                stringArray[0] = string;
                String[] stringArray2 = stringArray;
                map.put(element, stringArray2);
            }
        }

        public CHouseDatabaseRetriever(DBTransaction transaction) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            super(transaction);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u0000200\u0001R,\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0002B\u0015\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0007H\u0002\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/introspection/CHouseIntrospector$CHouseSchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector;", "Lcom/intellij/database/model/clickhouse/CHouseModModel;", "Lcom/intellij/database/model/clickhouse/CHouseRoot;", "Lcom/intellij/database/model/clickhouse/CHouseModRoot;", "Lcom/intellij/database/model/clickhouse/CHouseSchema;", "Lcom/intellij/database/model/clickhouse/CHouseModSchema;", "tran", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schema", "(Lcom/intellij/database/introspection/CHouseIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/clickhouse/CHouseSchema;)V", "getColumnKind", "Lcom/intellij/database/model/properties/MysqlColumnKind;", "extra", "", "getCreate", "Lcom/intellij/sql/psi/SqlCreateStatement;", "src", "process", "", "progress", "what", "retrieveColumns", "retrieveMatViewSources", "retrieveTableSource", "table", "Lcom/intellij/database/model/clickhouse/CHouseLikeTable;", "retrieveTableSources", "retrieveTables", "retrieveViewSources", "intellij.database.introspection"})
    private final class CHouseSchemaRetriever
    extends BaseIntrospector.AbstractSchemaRetriever {
        private final void progress(String what) {
            String mode = "completely";
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Introspecting schema %s (%s)";
            Object[] objectArray = new Object[]{((CHouseSchema)this.getSchema()).getName(), mode};
            CHouseIntrospector cHouseIntrospector = CHouseIntrospector.this;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            cHouseIntrospector.updateStatus(string3, what);
        }

        @Override
        public void process() {
            this.prepareParameters();
            CHouseSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ CHouseSchemaRetriever this$0;
                {
                    this.this$0 = cHouseSchemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    CHouseModSchema schema2 = (CHouseModSchema)MS;
                    CHouseSchemaRetriever.access$retrieveTables(this.this$0, schema2);
                }
            });
            this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ CHouseSchemaRetriever this$0;
                {
                    this.this$0 = cHouseSchemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    CHouseModSchema schema2 = (CHouseModSchema)MS;
                    CHouseSchemaRetriever.access$retrieveColumns(this.this$0, schema2);
                }
            });
            this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ CHouseSchemaRetriever this$0;
                {
                    this.this$0 = cHouseSchemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    CHouseModSchema schema2 = (CHouseModSchema)MS;
                    CHouseIntrospector this_$iv = this.this$0.CHouseIntrospector.this;
                    this_$iv.getModel().writeSources(new Runnable(schema2, this){
                        final /* synthetic */ CHouseModSchema $schema$inlined;
                        final /* synthetic */ CHouseSchemaRetriever$process$$inlined$inSchema$3 this$0;
                        {
                            this.$schema$inlined = cHouseModSchema;
                            this.this$0 = var2_2;
                        }

                        public final void run() {
                            CHouseSchemaRetriever.access$retrieveViewSources(this.this$0.this$0, this.$schema$inlined);
                            CHouseSchemaRetriever.access$retrieveMatViewSources(this.this$0.this$0, this.$schema$inlined);
                            CHouseSchemaRetriever.access$retrieveTableSources(this.this$0.this$0, this.$schema$inlined);
                        }
                    });
                }
            });
        }

        /*
         * Unable to fully structure code
         */
        private final void retrieveTables(CHouseModSchema schema) {
            this.progress("tables and views");
            this.getPreprocessor().setFreeParameters(new Object[]{schema.getName()});
            it = BaseIntrospectionFunctions.cleanupFamilies.1.INSTANCE;
            v0 = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"schema.tables");
            it.invoke((Object)v0);
            v1 = schema.getViews();
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"schema.views");
            it.invoke((Object)v1);
            v2 = schema.getMatViews();
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"schema.matViews");
            it.invoke((Object)v2);
            ts = (List)this.getTransaction().query(CHouseIntroQueries.QUERIES.retrieveTables.rewrite((StringOperator)this.getPreprocessor())).withParams(new Object[]{schema.getName()}).run();
            for (CHouseIntroQueries.TableInfo t : ts) {
                block7: {
                    block6: {
                        v3 = t.name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"t.name");
                        if (StringsKt.startsWith$default((String)v3, (String)CHouseIntrospectorKt.getInner_prefix(), (boolean)false, (int)2, null)) {
                            v4 = mv = (CHouseModMatView)schema.getMatViews().createOrGet(StringUtil.trimStart((String)t.name, (String)CHouseIntrospectorKt.getInner_prefix()));
                            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"mv");
                            v4.setEngine(t.engine);
                            continue;
                        }
                        v5 = var6_6 = t.engine;
                        if (v5 == null) break block6;
                        switch (v5.hashCode()) {
                            case 1978043036: {
                                if (!var6_6.equals("MaterializedView")) ** break;
                                break;
                            }
                            case 2666181: {
                                if (!var6_6.equals("View")) ** break;
                                v6 = schema.getViews();
                                v7 = v6;
                                Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"schema.views");
                                break block7;
                            }
                        }
                        v8 = schema.getMatViews();
                        v7 = v8;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"schema.matViews");
                        break block7;
                    }
                    v9 = schema.getTables();
                    v7 = v9;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"schema.tables");
                }
                v10 = o = (CHouseModLikeTable)v7.createOrGet(t.name);
                Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"o");
                v10.setTemporary(t.is_temporary);
                if (!(o instanceof CHouseModTable)) continue;
                ((CHouseModTable)o).setEngine(t.engine);
            }
            it = BaseIntrospectionFunctions.cleanupFamilies.2.INSTANCE;
            v11 = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"schema.tables");
            it.invoke((Object)v11);
            v12 = schema.getViews();
            Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"schema.views");
            it.invoke((Object)v12);
            v13 = schema.getMatViews();
            Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"schema.matViews");
            it.invoke((Object)v13);
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveColumns(CHouseModSchema schema) {
            void $receiver$iv;
            CHouseModLikeTable v;
            CHouseModTable t;
            Object element$iv;
            this.progress("table columns");
            this.getPreprocessor().setFreeParameters(schema.getName());
            int pos = 1;
            String tableName = "";
            Function1 it = BaseIntrospectionFunctions.cleanupFamilies.1.INSTANCE;
            NamingFamily namingFamily = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily, (String)"schema.tables");
            Object $receiver$iv2 = namingFamily;
            Iterator iterator2 = $receiver$iv2.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                CHouseModTable cHouseModTable = t = (CHouseModTable)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)cHouseModTable, (String)"t");
                PositioningNamingFamily positioningNamingFamily = cHouseModTable.getColumns();
                Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"t.columns");
                it.invoke((Object)positioningNamingFamily);
            }
            NamingFamily namingFamily2 = schema.getViews();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily2, (String)"schema.views");
            $receiver$iv2 = namingFamily2;
            iterator2 = $receiver$iv2.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                v = (CHouseModView)element$iv;
                CHouseModView cHouseModView = v;
                Intrinsics.checkExpressionValueIsNotNull((Object)cHouseModView, (String)"v");
                PositioningNamingFamily positioningNamingFamily = cHouseModView.getColumns();
                Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"v.columns");
                it.invoke((Object)positioningNamingFamily);
            }
            NamingFamily namingFamily3 = schema.getMatViews();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily3, (String)"schema.matViews");
            $receiver$iv2 = namingFamily3;
            iterator2 = $receiver$iv2.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                CHouseModLikeTable cHouseModLikeTable = v = (CHouseModMatView)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)cHouseModLikeTable, (String)"v");
                PositioningNamingFamily positioningNamingFamily = cHouseModLikeTable.getColumns();
                Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"v.columns");
                it.invoke((Object)positioningNamingFamily);
            }
            DBQueryRunner dBQueryRunner = this.getTransaction().query(CHouseIntroQueries.QUERIES.retrieveColumns.rewrite((StringOperator)this.getPreprocessor())).withParams(new Object[]{schema.getName()});
            Intrinsics.checkExpressionValueIsNotNull((Object)dBQueryRunner, (String)"transaction.query(QUERIE\u2026).withParams(schema.name)");
            it = dBQueryRunner;
            $receiver$iv2 = CHouseIntrospector.this;
            int limit$iv = CHouseIntrospector.this.getPackLimit();
            DBQueryRunner r$iv = $receiver$iv.packBy(limit$iv);
            Iterable pack$iv = (Iterable)r$iv.run();
            while (pack$iv != null) {
                Iterable $receiver$iv$iv = pack$iv;
                for (Object element$iv$iv : $receiver$iv$iv) {
                    CHouseModLikeColumn column2;
                    CHouseIntroQueries.ColumnInfo c = (CHouseIntroQueries.ColumnInfo)element$iv$iv;
                    String string = c.table;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"c.table");
                    if (StringsKt.startsWith$default((String)string, (String)CHouseIntrospectorKt.getInner_prefix(), (boolean)false, (int)2, null)) continue;
                    if (Intrinsics.areEqual((Object)tableName, (Object)c.table)) {
                        ++pos;
                    } else {
                        Intrinsics.checkExpressionValueIsNotNull((Object)c.table, (String)"c.table");
                        pos = 1;
                    }
                    CHouseModTable cHouseModTable = (CHouseModTable)schema.getTables().get(tableName);
                    CHouseModLikeTable cHouseModLikeTable = cHouseModTable != null ? (CHouseModLikeTable)cHouseModTable : (CHouseModLikeTable)schema.getViews().get(tableName);
                    if (cHouseModLikeTable == null) {
                        cHouseModLikeTable = (CHouseModLikeTable)schema.getMatViews().get(tableName);
                    }
                    if (cHouseModLikeTable == null) {
                        continue;
                    }
                    CHouseModLikeTable table = cHouseModLikeTable;
                    CHouseModLikeColumn cHouseModLikeColumn = column2 = (CHouseModLikeColumn)table.getColumns().createOrGet(c.name);
                    Intrinsics.checkExpressionValueIsNotNull((Object)cHouseModLikeColumn, (String)"column");
                    cHouseModLikeColumn.setPosition((short)pos);
                    column2.setDataType(DataTypeFactory.of(c.type));
                    if (!(column2 instanceof CHouseModTableColumn)) continue;
                    String string2 = c.default_expression;
                    ((CHouseModTableColumn)column2).setDefaultExpression(string2 != null ? StringKt.nullize$default((String)string2, (boolean)false, (int)1, null) : null);
                    ((CHouseModTableColumn)column2).setColumnKind(this.getColumnKind(c.default_kind));
                }
                pack$iv = (Iterable)r$iv.nextPack();
            }
            it = BaseIntrospectionFunctions.cleanupFamilies.2.INSTANCE;
            NamingFamily namingFamily4 = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily4, (String)"schema.tables");
            $receiver$iv2 = namingFamily4;
            Iterator iterator3 = $receiver$iv2.iterator();
            while (iterator3.hasNext()) {
                element$iv = iterator3.next();
                CHouseModTable cHouseModTable = t = (CHouseModTable)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)cHouseModTable, (String)"t");
                PositioningNamingFamily positioningNamingFamily = cHouseModTable.getColumns();
                Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"t.columns");
                it.invoke((Object)positioningNamingFamily);
            }
            NamingFamily namingFamily5 = schema.getViews();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily5, (String)"schema.views");
            $receiver$iv2 = namingFamily5;
            iterator3 = $receiver$iv2.iterator();
            while (iterator3.hasNext()) {
                element$iv = iterator3.next();
                CHouseModLikeTable cHouseModLikeTable = v = (CHouseModView)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)cHouseModLikeTable, (String)"v");
                PositioningNamingFamily positioningNamingFamily = cHouseModLikeTable.getColumns();
                Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"v.columns");
                it.invoke((Object)positioningNamingFamily);
            }
            NamingFamily namingFamily6 = schema.getMatViews();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingFamily6, (String)"schema.matViews");
            $receiver$iv2 = namingFamily6;
            iterator3 = $receiver$iv2.iterator();
            while (iterator3.hasNext()) {
                element$iv = iterator3.next();
                CHouseModLikeTable cHouseModLikeTable = v = (CHouseModMatView)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)cHouseModLikeTable, (String)"v");
                PositioningNamingFamily positioningNamingFamily = cHouseModLikeTable.getColumns();
                Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"v.columns");
                it.invoke((Object)positioningNamingFamily);
            }
        }

        private final MysqlColumnKind getColumnKind(String extra) {
            if (extra == null) {
                return MysqlColumnKind.NORMAL;
            }
            if (StringsKt.contains$default((CharSequence)extra, (CharSequence)"ALIAS", (boolean)false, (int)2, null)) {
                return MysqlColumnKind.GENERATED_VIRTUAL;
            }
            if (StringsKt.contains$default((CharSequence)extra, (CharSequence)"MATERIALIZED", (boolean)false, (int)2, null)) {
                return MysqlColumnKind.GENERATED_STORED;
            }
            return MysqlColumnKind.NORMAL;
        }

        private final String retrieveTableSource(CHouseLikeTable table) {
            CHouseIntrospector.this.setFqn(this, table);
            try {
                SqlQuery<String> sqlQuery = CHouseIntroQueries.QUERIES.retrieveTableSource;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"QUERIES.retrieveTableSource");
                return this.performQuery(sqlQuery);
            }
            catch (DBException e) {
                CHouseIntrospector.this.getErrorSink().consume((Object)e.getMessage(), (Object)e);
                return null;
            }
        }

        private final SqlCreateStatement getCreate(String src) {
            try {
                SqlCreateStatement createStatement2 = (SqlCreateStatement)((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)CHouseIntrospector.this.sqlFacade.createROFile(CHouseIntrospector.this.sqlLanguage, (CharSequence)src))).expandAndSkip((Condition)getCreate.createStatement.1.INSTANCE)).filter(SqlCreateStatement.class).first();
                if (createStatement2 == null) {
                    CHouseIntrospector.this.getLog().warn("No create found in\n" + src);
                    return null;
                }
                return createStatement2;
            }
            catch (RuntimeException e) {
                CHouseIntrospector.this.getLog().warn("Failed to parse sources", (Throwable)e);
                return null;
            }
        }

        private final void retrieveViewSources(CHouseModSchema schema) {
            this.progress("view sources");
            Iterator iterator2 = schema.getViews().iterator();
            while (iterator2.hasNext()) {
                CHouseModView view;
                CHouseModView cHouseModView = view = (CHouseModView)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)cHouseModView, (String)"view");
                String string = this.retrieveTableSource(view);
                cHouseModView.setSourceText(string != null ? BaseIntrospectionFunctions.toCompositeText(string, CompositeText.Kind.DECOMPILED_TEXT) : null);
            }
        }

        private final void retrieveMatViewSources(CHouseModSchema schema) {
            this.progress("materialized view sources");
            Iterator iterator2 = schema.getMatViews().iterator();
            while (iterator2.hasNext()) {
                String string;
                String it;
                String src;
                CHouseModMatView view;
                CHouseModMatView cHouseModMatView = view = (CHouseModMatView)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)cHouseModMatView, (String)"view");
                String string2 = src = this.retrieveTableSource(cHouseModMatView);
                view.setSourceText(string2 != null ? BaseIntrospectionFunctions.toCompositeText(string2, CompositeText.Kind.DECOMPILED_TEXT) : null);
                String string3 = src;
                if (string3 == null || (string3 = this.getCreate(it = (string = string3))) == null) {
                    continue;
                }
                String stmt = string3;
                CHouseIntrospector.this.builder.partialBuild((DasObject)view, (DasObject)stmt);
            }
        }

        private final void retrieveTableSources(CHouseModSchema schema) {
            this.progress("table sources");
            Iterator iterator2 = schema.getTables().iterator();
            while (iterator2.hasNext()) {
                String string;
                String it;
                String string2;
                CHouseModTable table;
                CHouseModTable cHouseModTable = table = (CHouseModTable)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)cHouseModTable, (String)"table");
                String string3 = cHouseModTable.getEngine();
                if (string3 != null) {
                    if (StringsKt.startsWith$default((String)string3, (String)"System", (boolean)false, (int)2, null)) {
                        table.setEngineParams(null);
                        continue;
                    }
                }
                if ((string2 = this.retrieveTableSource(table)) == null || (string2 = this.getCreate(it = (string = string2))) == null) {
                    continue;
                }
                String stmt = string2;
                CHouseIntrospector.this.builder.partialBuild((DasObject)table, (DasObject)stmt);
            }
        }

        public CHouseSchemaRetriever(@NotNull DBTransaction tran, CHouseSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            super((BaseIntrospector)CHouseIntrospector.this, tran, (BasicSchema)schema);
        }

        public static final /* synthetic */ void access$retrieveTables(CHouseSchemaRetriever $this, @NotNull CHouseModSchema schema) {
            $this.retrieveTables(schema);
        }

        public static final /* synthetic */ void access$retrieveColumns(CHouseSchemaRetriever $this, @NotNull CHouseModSchema schema) {
            $this.retrieveColumns(schema);
        }

        public static final /* synthetic */ void access$retrieveViewSources(CHouseSchemaRetriever $this, @NotNull CHouseModSchema schema) {
            $this.retrieveViewSources(schema);
        }

        public static final /* synthetic */ void access$retrieveMatViewSources(CHouseSchemaRetriever $this, @NotNull CHouseModSchema schema) {
            $this.retrieveMatViewSources(schema);
        }

        public static final /* synthetic */ void access$retrieveTableSources(CHouseSchemaRetriever $this, @NotNull CHouseModSchema schema) {
            $this.retrieveTableSources(schema);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/introspection/CHouseIntrospector$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.introspection"})
    public static final class VERSION
    extends PerObjectVersion {
        public static final VERSION INSTANCE;

        private VERSION() {
        }

        static {
            VERSION vERSION;
            INSTANCE = vERSION = new VERSION();
        }
    }
}

