/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.BaseIntrospector;
import com.intellij.database.introspection.CHouseIntrospector;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.ExasolIntrospector;
import com.intellij.database.introspection.GenericIntrospector;
import com.intellij.database.introspection.MsIntrospector;
import com.intellij.database.introspection.MysqlIntrospector;
import com.intellij.database.introspection.OraIntrospector;
import com.intellij.database.introspection.PostgresIntrospector;
import com.intellij.database.introspection.RedshiftIntrospector;
import com.intellij.database.introspection.SqliteIntrospector;
import com.intellij.database.introspection.SybaseIntrospector;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.ClickHouse;
import org.jetbrains.dekaf.Exasol;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Redshift;
import org.jetbrains.dekaf.Sqlite;
import org.jetbrains.dekaf.Sybase;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.util.Version;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002\u001a\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u001e\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\"\u0010\u0010\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u0010\u0010\u001b\u001a\u00020\u00162\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002\u001a\u000e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014\"T\u0010\u0000\u001aB\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u0002\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00040\u0004 \u0003* \u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u0002\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\u00050\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u001c\u0010\b\u001a\n \u0003*\u0004\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"SUPPORTED_VERSIONS", "", "Lorg/jetbrains/dekaf/Rdbms;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/dekaf/util/Version;", "", "getSUPPORTED_VERSIONS", "()Ljava/util/Map;", "UNATTAINABLE_FUTURE", "getUNATTAINABLE_FUTURE", "()Lorg/jetbrains/dekaf/util/Version;", "createGenericIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "modelFactory", "Lcom/intellij/database/model/impl/ModelFactory;", "rdbms", "createIntrospector", "model", "Lcom/intellij/database/model/basic/BasicModel;", "db", "Lorg/jetbrains/dekaf/core/DBFacade;", "generic", "", "getCurrentSrcIntrospectionVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "hasNativeIntrospector", "supportedByNativeIntrospector", "intellij.database.introspection"})
@JvmName(name="DBIntrospectorFactory")
public final class DBIntrospectorFactory {
    private static final Map<Rdbms, Version> SUPPORTED_VERSIONS = ContainerUtil.immutableMapBuilder().put((Object)Postgres.RDBMS, (Object)Version.of((int[])new int[]{9})).put((Object)Redshift.RDBMS, (Object)Version.of((int[])new int[]{8})).put((Object)Oracle.RDBMS, (Object)Version.of((int[])new int[]{9})).put((Object)Mssql.RDBMS, (Object)Version.of((int[])new int[]{9})).put((Object)Sybase.RDBMS, (Object)Version.of((int[])new int[]{15})).put((Object)Mysql.RDBMS, (Object)Version.of((int[])new int[]{5, 1})).put((Object)Sqlite.RDBMS, (Object)Version.ZERO).put((Object)Exasol.RDBMS, (Object)Version.of((int[])new int[]{5, 0})).put((Object)ClickHouse.RDBMS, (Object)Version.of((int[])new int[]{0, 0})).build();
    private static final Version UNATTAINABLE_FUTURE = Version.of((int[])new int[]{Integer.MAX_VALUE});

    public static final Map<Rdbms, Version> getSUPPORTED_VERSIONS() {
        return SUPPORTED_VERSIONS;
    }

    public static final Version getUNATTAINABLE_FUTURE() {
        return UNATTAINABLE_FUTURE;
    }

    public static final boolean supportedByNativeIntrospector(@NotNull DBFacade db) {
        ConnectionInfo connectionInfo;
        Version supportedVersion;
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        Version version = SUPPORTED_VERSIONS.get(db.rdbms());
        if (version == null) {
            version = supportedVersion = UNATTAINABLE_FUTURE;
        }
        if ((connectionInfo = db.getConnectionInfo()) == null || (connectionInfo = connectionInfo.serverVersion) == null) {
            return false;
        }
        ConnectionInfo serverVersion = connectionInfo;
        return serverVersion.compareTo(supportedVersion) >= 0;
    }

    public static final boolean hasNativeIntrospector(@Nullable Rdbms rdbms) {
        return SUPPORTED_VERSIONS.containsKey(rdbms);
    }

    @NotNull
    public static final DBIntrospector createIntrospector(@NotNull ModelFactory modelFactory, @NotNull DBFacade db, boolean generic) {
        Intrinsics.checkParameterIsNotNull((Object)modelFactory, (String)"modelFactory");
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        Rdbms rdbms = db.rdbms();
        Intrinsics.checkExpressionValueIsNotNull((Object)rdbms, (String)"db.rdbms()");
        DBIntrospector introspector = DBIntrospectorFactory.createIntrospector(modelFactory, rdbms, generic);
        introspector.attachToDB(db);
        return introspector;
    }

    @NotNull
    public static final DBIntrospector createIntrospector(@NotNull BasicModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Rdbms rdbms = model.getRdbms();
        Intrinsics.checkExpressionValueIsNotNull((Object)rdbms, (String)"model.rdbms");
        DBIntrospector introspector = DBIntrospectorFactory.createIntrospector(null, rdbms, false);
        introspector.init((BasicModModel)model);
        return introspector;
    }

    private static final DBIntrospector createIntrospector(ModelFactory modelFactory, Rdbms rdbms, boolean generic) {
        BaseIntrospector baseIntrospector;
        if (generic) {
            return DBIntrospectorFactory.createGenericIntrospector(modelFactory, rdbms);
        }
        Rdbms rdbms2 = rdbms;
        if (Intrinsics.areEqual((Object)rdbms2, (Object)Postgres.RDBMS)) {
            baseIntrospector = new PostgresIntrospector();
        } else if (Intrinsics.areEqual((Object)rdbms2, (Object)Redshift.RDBMS)) {
            baseIntrospector = new RedshiftIntrospector();
        } else if (Intrinsics.areEqual((Object)rdbms2, (Object)Oracle.RDBMS)) {
            baseIntrospector = new OraIntrospector();
        } else if (Intrinsics.areEqual((Object)rdbms2, (Object)Mssql.RDBMS)) {
            baseIntrospector = new MsIntrospector();
        } else if (Intrinsics.areEqual((Object)rdbms2, (Object)Sybase.RDBMS)) {
            baseIntrospector = new SybaseIntrospector();
        } else if (Intrinsics.areEqual((Object)rdbms2, (Object)Mysql.RDBMS)) {
            baseIntrospector = new MysqlIntrospector();
        } else if (Intrinsics.areEqual((Object)rdbms2, (Object)Sqlite.RDBMS)) {
            baseIntrospector = new SqliteIntrospector();
        } else if (Intrinsics.areEqual((Object)rdbms2, (Object)Exasol.RDBMS)) {
            baseIntrospector = new ExasolIntrospector();
        } else if (Intrinsics.areEqual((Object)rdbms2, (Object)ClickHouse.RDBMS)) {
            baseIntrospector = new CHouseIntrospector();
        } else {
            return DBIntrospectorFactory.createGenericIntrospector(modelFactory, rdbms);
        }
        BaseIntrospector introspector = baseIntrospector;
        if (modelFactory != null) {
            introspector.setModelFactory$intellij_database_introspection(modelFactory);
        }
        return introspector;
    }

    public static final int getCurrentSrcIntrospectionVersion(@NotNull Rdbms rdbms, @NotNull ObjectKind kind) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)rdbms, (String)"rdbms");
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        Rdbms rdbms2 = rdbms;
        if (Intrinsics.areEqual((Object)rdbms2, (Object)Postgres.RDBMS)) {
            n = PostgresIntrospector.VERSION.INSTANCE.get(kind);
        } else if (Intrinsics.areEqual((Object)rdbms2, (Object)Redshift.RDBMS)) {
            n = RedshiftIntrospector.VERSION.INSTANCE.get(kind);
        } else if (Intrinsics.areEqual((Object)rdbms2, (Object)Oracle.RDBMS)) {
            n = OraIntrospector.VERSION.INSTANCE.get(kind);
        } else if (Intrinsics.areEqual((Object)rdbms2, (Object)Mssql.RDBMS)) {
            n = MsIntrospector.VERSION.INSTANCE.get(kind);
        } else if (Intrinsics.areEqual((Object)rdbms2, (Object)Sybase.RDBMS)) {
            n = SybaseIntrospector.VERSION.INSTANCE.get(kind);
        } else if (Intrinsics.areEqual((Object)rdbms2, (Object)Mysql.RDBMS)) {
            n = MysqlIntrospector.VERSION.INSTANCE.get(kind);
        } else if (Intrinsics.areEqual((Object)rdbms2, (Object)Sqlite.RDBMS)) {
            n = SqliteIntrospector.VERSION.get(kind);
        } else if (Intrinsics.areEqual((Object)rdbms2, (Object)Exasol.RDBMS)) {
            n = ExasolIntrospector.VERSION.INSTANCE.get(kind);
        } else if (Intrinsics.areEqual((Object)rdbms2, (Object)ClickHouse.RDBMS)) {
            n = CHouseIntrospector.VERSION.INSTANCE.get(kind);
        } else {
            PerObjectVersion perObjectVersion = GenericIntrospector.VERSIONS.get(rdbms);
            n = perObjectVersion != null ? perObjectVersion.get(kind) : 0;
        }
        return n;
    }

    private static final DBIntrospector createGenericIntrospector(ModelFactory modelFactory, Rdbms rdbms) {
        GenericIntrospector introspector = new GenericIntrospector(rdbms);
        if (modelFactory != null) {
            introspector.setModelFactory(modelFactory);
        }
        return introspector;
    }
}

