/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.basic.BasicTypedElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.DatabaseFamilyBean;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Sqlite;

public class GenericIntrospectorLegacyModelUtils {
    public static final SequenceIdentity SEQUENCE_IDENTITY = SequenceIdentity.of(1L, null, 1L, null);

    @Nullable
    public static Rdbms findRdbms(DatabaseFamilyId familyId) {
        DatabaseFamilyBean familyBean = DatabaseFamilyBean.findByFamilyId((DatabaseFamilyId)familyId);
        return familyBean == null ? null : Rdbms.of((String)familyBean.rdbms);
    }

    @Nullable
    public static DatabaseFamilyId findFamily(Rdbms rdbms) {
        DatabaseFamilyBean familyBean = DatabaseFamilyBean.findByRdbms((String)rdbms.code);
        return familyBean == null ? null : (DatabaseFamilyId)familyBean.family.getValue();
    }

    @Nullable
    public static Pair<String, Short> fixProcedureName(@Nullable String schema, @NotNull DatabaseFamilyId familyId, @Nullable String name) {
        int tmpPos;
        int idx;
        if (familyId == null) {
            GenericIntrospectorLegacyModelUtils.$$$reportNull$$$0(0);
        }
        short pos = 1;
        if (familyId.isSybase() && name != null && schema != null && name.startsWith(schema) && name.length() > schema.length() + 1 && name.charAt(schema.length()) == '.') {
            name = name.substring(schema.length() + 1);
        }
        if (familyId.isTransactSql() && name != null && (idx = name.indexOf(59)) > -1 && (tmpPos = StringUtil.parseInt((String)name.substring(idx + 1), (int)-1)) >= 0) {
            name = name.substring(0, idx);
            pos = (short)tmpPos;
        }
        return name == null ? null : Pair.create((Object)name, (Object)pos);
    }

    @Nullable
    public static String fixDefaultValue(@NotNull DatabaseFamilyId familyId, @NotNull BasicTypedElement column2, @Nullable String defaultValue) {
        int jdbc;
        if (familyId == null) {
            GenericIntrospectorLegacyModelUtils.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            GenericIntrospectorLegacyModelUtils.$$$reportNull$$$0(2);
        }
        if (defaultValue == null) {
            return null;
        }
        int reportedJdbc = column2.getDataType().jdbcType;
        int n = jdbc = reportedJdbc == 1111 || reportedJdbc == 0 ? JdbcUtil.guessJdbcTypeByName((String)column2.getDataType().typeName) : reportedJdbc;
        if (jdbc == 1 || jdbc == 2005 || jdbc == 12 || jdbc == -15 || jdbc == 2011 || jdbc == -9 || jdbc == 91 || jdbc == 92 || jdbc == 93) {
            if (familyId.isOracle()) {
                return defaultValue;
            }
            if (familyId.isPostgres()) {
                int dotIndex = defaultValue.indexOf("::");
                if (dotIndex == -1) {
                    return defaultValue;
                }
                if (defaultValue.startsWith("('") && dotIndex > 4) {
                    return defaultValue;
                }
                if (defaultValue.startsWith("''") && defaultValue.endsWith("'")) {
                    return defaultValue.substring(1, dotIndex);
                }
                return defaultValue.substring(0, dotIndex);
            }
            if ((jdbc == 91 || jdbc == 92 || jdbc == 93) && defaultValue.length() > 0 && Character.isLetter(defaultValue.charAt(0))) {
                return defaultValue;
            }
            if (!StringUtil.startsWithChar((CharSequence)defaultValue, (char)'\'')) {
                return '\'' + defaultValue + '\'';
            }
        } else if (jdbc == -7) {
            if (defaultValue.contains("\u0000")) {
                return "0";
            }
            if (defaultValue.contains("\u0001")) {
                return "1";
            }
        }
        return defaultValue;
    }

    public static <T extends BasicModNamedElement> ModNamingFamily<T> familyOf(@Nullable BasicModElement element, @NotNull ObjectKind kind) {
        if (kind == null) {
            GenericIntrospectorLegacyModelUtils.$$$reportNull$$$0(3);
        }
        Family res = element == null ? null : element.familyOf(kind);
        return res instanceof ModNamingFamily ? (ModNamingFamily)res : null;
    }

    public static void resolveKey(@NotNull BasicModForeignKey fkey, @NotNull List<String> refColNames) {
        if (fkey == null) {
            GenericIntrospectorLegacyModelUtils.$$$reportNull$$$0(4);
        }
        if (refColNames == null) {
            GenericIntrospectorLegacyModelUtils.$$$reportNull$$$0(5);
        }
        if (refColNames.isEmpty()) {
            return;
        }
        BasicTableOrView table = fkey.getRefTable();
        if (table == null) {
            return;
        }
        for (BasicKey key2 : JBIterable.from(table.familyOf(ObjectKind.KEY)).filter(BasicKey.class)) {
            if (!refColNames.equals(key2.getColNames())) continue;
            fkey.setRefKeyName(key2.getName());
        }
    }

    public static CascadeRule asCascadeRule(DasForeignKey.RuleAction ac, Rdbms rdbms) {
        if (ac == DasForeignKey.RuleAction.CASCADE) {
            return CascadeRule.cascade;
        }
        if (ac == DasForeignKey.RuleAction.NO_ACTION) {
            return CascadeRule.no_action;
        }
        if (ac == DasForeignKey.RuleAction.RESTRICT) {
            return CascadeRule.restrict;
        }
        if (ac == DasForeignKey.RuleAction.SET_DEFAULT) {
            return CascadeRule.set_default;
        }
        if (ac == DasForeignKey.RuleAction.SET_NULL) {
            return CascadeRule.set_null;
        }
        return rdbms == Sqlite.RDBMS ? CascadeRule.no_action : CascadeRule.restrict;
    }

    public static boolean isSchemaDbMode(BasicModModel model, DatabaseFamilyId family) {
        return model.getRoot().familyOf(ObjectKind.DATABASE) == null && family.isMysql();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "familyId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fkey";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refColNames";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/introspection/GenericIntrospectorLegacyModelUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fixProcedureName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fixDefaultValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "familyOf";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveKey";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

