/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.google.common.collect.ImmutableList;
import com.intellij.database.introspection.BaseIntrospectionFunctions;
import com.intellij.database.introspection.BaseIntrospector;
import com.intellij.database.introspection.BaseMultiDatabaseIntrospector;
import com.intellij.database.introspection.CollectionAggregator;
import com.intellij.database.introspection.DescriptionId;
import com.intellij.database.introspection.ForeignKeyInfo;
import com.intellij.database.introspection.LongIdName;
import com.intellij.database.introspection.MsIntroQueries;
import com.intellij.database.introspection.MsIntrospectionException;
import com.intellij.database.introspection.MsIntrospector;
import com.intellij.database.introspection.MsIntrospector$MsSchemaRetriever$retrieveSources$;
import com.intellij.database.introspection.MsIntrospectorKt;
import com.intellij.database.introspection.MsMinorIdentity;
import com.intellij.database.introspection.MsRoutineTypes;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicMateDatabase;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.mssql.MsCustomType;
import com.intellij.database.model.mssql.MsDatabase;
import com.intellij.database.model.mssql.MsKey;
import com.intellij.database.model.mssql.MsLikeTable;
import com.intellij.database.model.mssql.MsModAliasType;
import com.intellij.database.model.mssql.MsModArgument;
import com.intellij.database.model.mssql.MsModCheck;
import com.intellij.database.model.mssql.MsModDatabase;
import com.intellij.database.model.mssql.MsModDefaultConstraint;
import com.intellij.database.model.mssql.MsModForeignKey;
import com.intellij.database.model.mssql.MsModIndex;
import com.intellij.database.model.mssql.MsModKey;
import com.intellij.database.model.mssql.MsModLikeColumn;
import com.intellij.database.model.mssql.MsModLikeTable;
import com.intellij.database.model.mssql.MsModModel;
import com.intellij.database.model.mssql.MsModRoot;
import com.intellij.database.model.mssql.MsModRoutine;
import com.intellij.database.model.mssql.MsModSchema;
import com.intellij.database.model.mssql.MsModSchemaObject;
import com.intellij.database.model.mssql.MsModSourceAware;
import com.intellij.database.model.mssql.MsModStoredColumn;
import com.intellij.database.model.mssql.MsModStoredTable;
import com.intellij.database.model.mssql.MsModSynonym;
import com.intellij.database.model.mssql.MsModTable;
import com.intellij.database.model.mssql.MsModTableOrView;
import com.intellij.database.model.mssql.MsModTableType;
import com.intellij.database.model.mssql.MsModTrigger;
import com.intellij.database.model.mssql.MsModView;
import com.intellij.database.model.mssql.MsRoot;
import com.intellij.database.model.mssql.MsRoutine;
import com.intellij.database.model.mssql.MsSchema;
import com.intellij.database.model.mssql.MsTable;
import com.intellij.database.model.mssql.MsTableType;
import com.intellij.database.model.mssql.MsView;
import com.intellij.database.model.properties.MsRoutineType;
import com.intellij.database.model.properties.MsServerType;
import com.intellij.database.scripting.CompositeText;
import gnu.trove.TIntHashSet;
import gnu.trove.TLongHashSet;
import gnu.trove.TLongObjectHashMap;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.Layouts;
import org.jetbrains.dekaf.sql.SqlQuery;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u00002,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0001:\u0003()*B\u0005\u00a2\u0006\u0002\u0010\tJ:\u0010\u0011\u001a4\u0012\u0002\b\u00030\u0012R,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0001H\u0014J\u001c\u0010\u0013\u001a\u00060\u0014R\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0014J\u001c\u0010\u0018\u001a\u00060\u0019R\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0007H\u0014J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0016H\u0002J\b\u0010\u001e\u001a\u00020\u001cH\u0014J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0016H\u0014J\u0018\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0014J)\u0010!\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00052\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#H\u0000\u00a2\u0006\u0002\b&J\u0010\u0010'\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0016H\u0014R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/database/introspection/MsIntrospector;", "Lcom/intellij/database/introspection/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/model/mssql/MsModModel;", "Lcom/intellij/database/model/mssql/MsRoot;", "Lcom/intellij/database/model/mssql/MsModRoot;", "Lcom/intellij/database/model/mssql/MsDatabase;", "Lcom/intellij/database/model/mssql/MsModDatabase;", "Lcom/intellij/database/model/mssql/MsSchema;", "Lcom/intellij/database/model/mssql/MsModSchema;", "()V", "databasesToReResolveForeignKeys", "Ljava/util/HashSet;", "Lcom/intellij/database/model/basic/BasicDatabase;", "myQueries", "Lcom/intellij/database/introspection/MsIntroQueries;", "myVer10", "", "createDatabaseLister", "Lcom/intellij/database/introspection/BaseMultiDatabaseIntrospector$DatabaseLister;", "createDatabaseRetriever", "Lcom/intellij/database/introspection/MsIntrospector$MsDatabaseRetriever;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/introspection/MsIntrospector$MsSchemaRetriever;", "schema", "getServerType", "", "tran", "initConnectionRelatedState", "introspectNamespacesInTran", "postProcessDatabase", "prepareQueryParameters", "parameters", "", "", "", "prepareQueryParameters$intellij_database_introspection", "retrieveSessionBriefInfo", "MsDatabaseRetriever", "MsSchemaRetriever", "VERSION", "intellij.database.introspection"})
public final class MsIntrospector
extends BaseMultiDatabaseIntrospector<MsModModel, MsRoot, MsModRoot, MsDatabase, MsModDatabase, MsSchema, MsModSchema> {
    private final MsIntroQueries myQueries;
    private boolean myVer10;
    private final HashSet<BasicDatabase> databasesToReResolveForeignKeys;

    @Override
    protected void initConnectionRelatedState() {
        super.initConnectionRelatedState();
        this.myVer10 = this.getServerVersion().isOrGreater(new int[]{10});
    }

    public final void prepareQueryParameters$intellij_database_introspection(@NotNull MsDatabase database, @NotNull Map<String, Object> parameters) {
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
        Map<String, Object> map = parameters;
        String string = "CAT";
        String string2 = MsIntrospectorKt.access$catalogPrefix(database);
        map.put(string, string2);
        map = parameters;
        string = "ISTABLETYPE";
        string2 = this.getServerVersion().isOrGreater(new int[]{10}) ? "is_table_type" : "0";
        map.put(string, string2);
        BaseIntrospectionFunctions.setMajorVersionParameters(this.getServerVersion(), 10, parameters);
    }

    @NotNull
    protected MsDatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull MsDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        return new MsDatabaseRetriever(transaction, database);
    }

    @NotNull
    protected MsSchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull MsSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        return new MsSchemaRetriever(this, transaction, schema);
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        MsRoot msRoot = ((MsModModel)this.getModel()).getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)msRoot, (String)"model.root");
        if (msRoot.getServerType() == MsServerType.UNKNOWN) {
            this.getServerType(tran);
        }
        super.introspectNamespacesInTran(tran);
    }

    private final void getServerType(DBTransaction tran) {
        String string;
        String info;
        String string2 = info = (String)tran.query(this.myQueries.queryServerInfo).run();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"info");
        String string3 = string = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        MsServerType serverType = StringsKt.contains$default((CharSequence)string4, (CharSequence)"azure", (boolean)false, (int)2, null) ? MsServerType.AZURE : MsServerType.STANDALONE;
        MsIntrospector this_$iv = this;
        this_$iv.getModel().modify(BaseMultiDatabaseIntrospector.access$getModRootClass$p(this_$iv), new ModelModifier<MR>(serverType){
            final /* synthetic */ MsServerType $serverType$inlined;
            {
                this.$serverType$inlined = msServerType;
            }

            public final void perform(MR root2) {
                MR MR = root2;
                Intrinsics.checkExpressionValueIsNotNull(MR, (String)"root");
                MsModRoot root3 = (MsModRoot)MR;
                root3.setServerType(this.$serverType$inlined);
            }
        });
    }

    @Override
    protected void retrieveSessionBriefInfo(@NotNull DBTransaction tran) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        MsIntroQueries.CurrentSessionInfo currentSessionInfo = (MsIntroQueries.CurrentSessionInfo)tran.query(this.myQueries.queryCurrentSessionInfo).run();
        if (currentSessionInfo == null) {
            throw (Throwable)new MsIntrospectionException("Failed to obtain session info");
        }
        MsIntroQueries.CurrentSessionInfo sessionInfo = currentSessionInfo;
        MsIntrospector this_$iv = this;
        this_$iv.getModel().modify(BaseMultiDatabaseIntrospector.access$getModRootClass$p(this_$iv), new ModelModifier<MR>(sessionInfo){
            final /* synthetic */ MsIntroQueries.CurrentSessionInfo $sessionInfo$inlined;
            {
                this.$sessionInfo$inlined = currentSessionInfo;
            }

            public final void perform(MR root2) {
                MsModDatabase currentDatabase;
                MR MR = root2;
                Intrinsics.checkExpressionValueIsNotNull(MR, (String)"root");
                MsModRoot root3 = (MsModRoot)MR;
                root3.setServerType(this.$sessionInfo$inlined.is_azure ? MsServerType.AZURE : MsServerType.STANDALONE);
                MsModDatabase msModDatabase = currentDatabase = (MsModDatabase)root3.getDatabases().renew(this.$sessionInfo$inlined.db_id, this.$sessionInfo$inlined.db_name);
                Intrinsics.checkExpressionValueIsNotNull((Object)msModDatabase, (String)"currentDatabase");
                msModDatabase.setCurrent(true);
                if (this.$sessionInfo$inlined.schema_name != null) {
                    MsModSchema currentSchema;
                    MsModSchema msModSchema = currentSchema = (MsModSchema)currentDatabase.getSchemas().renew(this.$sessionInfo$inlined.schema_id, this.$sessionInfo$inlined.schema_name);
                    Intrinsics.checkExpressionValueIsNotNull((Object)msModSchema, (String)"currentSchema");
                    msModSchema.setCurrent(true);
                }
            }
        });
    }

    @Override
    @NotNull
    protected BaseMultiDatabaseIntrospector.DatabaseLister<?> createDatabaseLister() {
        return new BaseMultiDatabaseIntrospector.DatabaseLister<MsIntroQueries.DbInfo>(this){
            final /* synthetic */ MsIntrospector this$0;

            @NotNull
            protected List<MsIntroQueries.DbInfo> listDatabases(@NotNull DBTransaction tran) {
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                Object object = tran.query(MsIntrospector.access$getMyQueries$p((MsIntrospector)this.this$0).listDatabases).run();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"tran.query(myQueries.listDatabases).run()");
                return (List)object;
            }

            @NotNull
            protected MsModDatabase applyDatabase(@NotNull ModNamingIdentifyingFamily<?> databases, @NotNull MsIntroQueries.DbInfo db) {
                String string;
                MsModDatabase $receiver;
                Intrinsics.checkParameterIsNotNull(databases, (String)"databases");
                Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
                MD MD = this.renew(databases, db.id, db.name);
                MsModDatabase msModDatabase = $receiver = (MsModDatabase)MD;
                String string2 = db.collation_name;
                if (string2 != null) {
                    String string3 = string2;
                    MsModDatabase msModDatabase2 = msModDatabase;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String string5 = ((Object)StringsKt.trimEnd((CharSequence)string4)).toString();
                    msModDatabase = msModDatabase2;
                    string = string5;
                } else {
                    string = null;
                }
                msModDatabase.setCollation(string);
                return (MsModDatabase)MD;
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @Override
    protected void postProcessDatabase(@NotNull DBTransaction tran, @NotNull MsDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        if (this.databasesToReResolveForeignKeys.contains(database)) {
            Collection collection = this.databasesToReResolveForeignKeys;
            collection.remove(database);
            ((MsModModel)this.getModel()).modify(database, MsModDatabase.class, postProcessDatabase.1.INSTANCE);
        }
    }

    public MsIntrospector() {
        Rdbms rdbms = Mssql.RDBMS;
        Intrinsics.checkExpressionValueIsNotNull((Object)rdbms, (String)"Mssql.RDBMS");
        super(rdbms, MsModModel.class, MsModRoot.class, MsModDatabase.class, MsModSchema.class);
        MsIntroQueries msIntroQueries = MsIntroQueries.QUERIES;
        Intrinsics.checkExpressionValueIsNotNull((Object)msIntroQueries, (String)"MsIntroQueries.QUERIES");
        this.myQueries = msIntroQueries;
        this.databasesToReResolveForeignKeys = new HashSet();
    }

    public static final /* synthetic */ void access$setMyVer10$p(MsIntrospector $this, boolean bl) {
        $this.myVer10 = bl;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u0000200\u0001R,\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0002B\u0017\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/introspection/MsIntrospector$MsDatabaseRetriever;", "Lcom/intellij/database/introspection/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/introspection/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/model/mssql/MsModModel;", "Lcom/intellij/database/model/mssql/MsRoot;", "Lcom/intellij/database/model/mssql/MsModRoot;", "Lcom/intellij/database/model/mssql/MsDatabase;", "Lcom/intellij/database/model/mssql/MsModDatabase;", "Lcom/intellij/database/model/mssql/MsSchema;", "Lcom/intellij/database/model/mssql/MsModSchema;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "database", "(Lcom/intellij/database/introspection/MsIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/mssql/MsDatabase;)V", "beforeSchemasRetrieval", "", "listSchemas", "", "Lcom/intellij/database/introspection/LongIdName;", "intellij.database.introspection"})
    protected final class MsDatabaseRetriever
    extends BaseMultiDatabaseIntrospector.BaseDatabaseRetriever {
        @Override
        protected void beforeSchemasRetrieval() {
            MsIntrospector.this.prepareQueryParameters$intellij_database_introspection((MsDatabase)this.getDatabase(), this.getQueryParameters());
        }

        @Override
        @NotNull
        protected List<LongIdName> listSchemas() {
            SqlQuery<List<LongIdName>> sqlQuery = ((MsIntrospector)MsIntrospector.this).myQueries.listSchemas;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.listSchemas");
            return this.performQuery(sqlQuery);
        }

        public MsDatabaseRetriever(@NotNull DBTransaction transaction, MsDatabase database) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
            super((BaseMultiDatabaseIntrospector)MsIntrospector.this, transaction, (BasicMateDatabase)database);
        }
    }

    /*
     * Exception performing whole class analysis.
     */
    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0084\u0004\u0018\u0000200\u0001R,\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0002B\u0017\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0016H\u0014J\b\u0010\u0018\u001a\u00020\u0016H\u0014J.\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001a0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0002J\u0016\u0010%\u001a\u00020\u00162\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002J\u0016\u0010)\u001a\u00020\u00162\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0'H\u0002J8\u0010,\u001a\u00020\u0016\"\f\b\u0000\u0010-*\u00020.*\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H-012\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001a0\u001cH\u0002J$\u00102\u001a\u00020\u00162\f\u00103\u001a\b\u0012\u0004\u0012\u0002040'2\f\u00105\u001a\b\u0012\u0004\u0012\u0002060'H\u0002J\u0016\u00107\u001a\u00020\u00162\f\u00108\u001a\b\u0012\u0004\u0012\u0002090'H\u0002J\u0010\u0010:\u001a\u00020\u00162\u0006\u0010;\u001a\u00020$H\u0002J\u0010\u0010<\u001a\u00020\u00162\u0006\u0010=\u001a\u00020\u001aH\u0002J\u0018\u0010>\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\t2\u0006\u0010?\u001a\u00020@H\u0002J\u0018\u0010>\u001a\u00020\u00162\u0006\u0010A\u001a\u00020B2\u0006\u0010?\u001a\u00020@H\u0002J\u0018\u0010C\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\t2\u0006\u0010D\u001a\u00020EH\u0002J\b\u0010F\u001a\u00020\u0016H\u0002J\b\u0010G\u001a\u00020\u0016H\u0002J\b\u0010H\u001a\u00020\u0016H\u0002J\b\u0010I\u001a\u00020\u0016H\u0002J\b\u0010J\u001a\u00020\u0016H\u0002J\b\u0010K\u001a\u00020\u0016H\u0002J\b\u0010L\u001a\u00020\u0016H\u0002J\b\u0010M\u001a\u00020\u0016H\u0002J\b\u0010N\u001a\u00020\u0016H\u0014J\b\u0010O\u001a\u00020\u0016H\u0014J\b\u0010P\u001a\u00020\u0016H\u0002J\b\u0010Q\u001a\u00020\u0016H\u0002J\b\u0010R\u001a\u00020\u0016H\u0002J\b\u0010S\u001a\u00020\u0016H\u0002J\b\u0010T\u001a\u00020\u0016H\u0002J\b\u0010U\u001a\u00020\u0016H\u0002J\b\u0010V\u001a\u00020\u0016H\u0002J\b\u0010W\u001a\u00020\u0016H\u0002R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lcom/intellij/database/introspection/MsIntrospector$MsSchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector;", "Lcom/intellij/database/model/mssql/MsModModel;", "Lcom/intellij/database/model/mssql/MsRoot;", "Lcom/intellij/database/model/mssql/MsModRoot;", "Lcom/intellij/database/model/mssql/MsDatabase;", "Lcom/intellij/database/model/mssql/MsModDatabase;", "Lcom/intellij/database/model/mssql/MsSchema;", "Lcom/intellij/database/model/mssql/MsModSchema;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schema", "(Lcom/intellij/database/introspection/MsIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/mssql/MsSchema;)V", "myTouchedRoutines", "Ljava/util/HashSet;", "Lcom/intellij/database/model/mssql/MsRoutine;", "myTouchedTables", "Ljava/util/ArrayList;", "Lcom/intellij/database/model/mssql/MsLikeTable;", "Lkotlin/collections/ArrayList;", "analyzeBriefInfo", "", "analyzeCurrentContent", "finishSchema", "getDescription", "", "descriptions", "", "Lcom/intellij/database/introspection/DescriptionId;", "obj", "Lcom/intellij/database/model/basic/BasicIdentifiedElement;", "position", "", "processAliasTypes", "aliasTypesCheckSum", "", "processCheckConstraints", "cs", "", "Lcom/intellij/database/introspection/MsIntroQueries$OneCheckConstraints;", "processColumns", "cols", "Lcom/intellij/database/introspection/MsIntroQueries$OneColumn;", "processDescriptions", "T", "Lcom/intellij/database/model/basic/BasicModIdentifiedElement;", "Lcom/intellij/database/model/basic/BasicModNamedElement;", "family", "Lcom/intellij/database/model/families/ModIdentifyingFamily;", "processIndices", "inds", "Lcom/intellij/database/introspection/MsIntroQueries$OneIndex;", "ics", "Lcom/intellij/database/introspection/MsIntroQueries$OneIndexColumn;", "processKeys", "ks", "Lcom/intellij/database/introspection/MsIntroQueries$OneKey;", "processTableTypes", "tableTypesCheckSum", "progress", "what", "removeUnexistentIndices", "existentIndicesCombies", "Lgnu/trove/TLongHashSet;", "table", "Lcom/intellij/database/model/mssql/MsModStoredTable;", "removeUnexistentSchemaObjects", "existentObjectIds", "Lgnu/trove/TIntHashSet;", "retrieveArguments", "retrieveCheckConstraints", "retrieveColumns", "retrieveCustomTypes", "retrieveDescription", "retrieveForeignKeys", "retrieveIndices", "retrieveKeys", "retrieveMainContent", "retrieveMajorNames", "retrieveMajorObjects", "retrieveSources", "retrieveSynonyms", "retrieveTriggers", "retrieveTypeCheckConstraints", "retrieveTypeColumns", "retrieveTypeIndices", "retrieveTypeKeys", "intellij.database.introspection"})
    protected final class MsSchemaRetriever
    extends BaseIntrospector.AbstractSchemaRetriever {
        private final ArrayList<MsLikeTable> myTouchedTables;
        private final HashSet<MsRoutine> myTouchedRoutines;
        final /* synthetic */ MsIntrospector this$0;

        @Override
        protected void analyzeBriefInfo() {
            this.setIntrospectionBeginTimestamp$intellij_database_introspection((Timestamp)this.getTransaction().query("select current_timestamp", Layouts.singleOf(Timestamp.class)).run());
        }

        @Override
        protected void analyzeCurrentContent() {
            this.progress("determining dropped objects");
            SqlQuery<int[]> sqlQuery = ((MsIntrospector)this.this$0).myQueries.listExistentObjects;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.listExistentObjects");
            int[] existentObjectsArray = this.performQuery(sqlQuery);
            TIntHashSet existentObjectIds = new TIntHashSet(existentObjectsArray);
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, existentObjectIds){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ TIntHashSet $existentObjectIds$inlined;
                {
                    this.this$0 = msSchemaRetriever;
                    this.$existentObjectIds$inlined = tIntHashSet;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema schema2 = (MsModSchema)MS;
                    MsSchemaRetriever.access$removeUnexistentSchemaObjects(this.this$0, schema2, this.$existentObjectIds$inlined);
                }
            });
            NamingIdentifyingFamily<? extends MsTableType> namingIdentifyingFamily = ((MsSchema)this.getSchema()).getTableTypes();
            Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily, (String)"schema.tableTypes");
            if (namingIdentifyingFamily.isEmpty()) {
                NamingIdentifyingFamily<? extends MsTable> namingIdentifyingFamily2 = ((MsSchema)this.getSchema()).getTables();
                Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily2, (String)"schema.tables");
                if (namingIdentifyingFamily2.isEmpty()) {
                    return;
                }
            }
            SqlQuery<long[]> sqlQuery2 = ((MsIntrospector)this.this$0).myQueries.listExistentIndices;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"myQueries.listExistentIndices");
            long[] existentIndicesArray = this.performQuery(sqlQuery2);
            TLongHashSet existentIndicesCombies = new TLongHashSet(existentIndicesArray);
            MsSchemaRetriever this_$iv2 = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv2).modify((BasicElement)this_$iv2.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv2).this$0), new ModelModifier<MS>(this, existentIndicesCombies){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ TLongHashSet $existentIndicesCombies$inlined;
                {
                    this.this$0 = msSchemaRetriever;
                    this.$existentIndicesCombies$inlined = tLongHashSet;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema schema2 = (MsModSchema)MS;
                    MsSchemaRetriever.access$removeUnexistentIndices(this.this$0, schema2, this.$existentIndicesCombies$inlined);
                }
            });
        }

        private final void removeUnexistentSchemaObjects(MsModSchema schema, TIntHashSet existentObjectIds) {
            NamingIdentifyingFamily namingIdentifyingFamily = schema.getSynonyms();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.synonyms");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily)), existentObjectIds);
            NamingIdentifyingFamily namingIdentifyingFamily2 = schema.getRoutines();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily2, (String)"schema.routines");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily2)), existentObjectIds);
            NamingIdentifyingFamily namingIdentifyingFamily3 = schema.getViews();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily3, (String)"schema.views");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily3)), existentObjectIds);
            NamingIdentifyingFamily namingIdentifyingFamily4 = schema.getTables();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily4, (String)"schema.tables");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily4)), existentObjectIds);
            Iterator iterator2 = schema.getTables().iterator();
            while (iterator2.hasNext()) {
                MsModTable table;
                MsModTable msModTable = table = (MsModTable)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)msModTable, (String)"table");
                NamingIdentifyingFamily namingIdentifyingFamily5 = msModTable.getKeys();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily5, (String)"table.keys");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily5)), existentObjectIds);
                NamingIdentifyingFamily namingIdentifyingFamily6 = table.getForeignKeys();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily6, (String)"table.foreignKeys");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily6)), existentObjectIds);
                NamingIdentifyingFamily namingIdentifyingFamily7 = table.getChecks();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily7, (String)"table.checks");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily7)), existentObjectIds);
                NamingIdentifyingFamily namingIdentifyingFamily8 = table.getDefaultConstraints();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily8, (String)"table.defaultConstraints");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily8)), existentObjectIds);
                NamingIdentifyingFamily namingIdentifyingFamily9 = table.getTriggers();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily9, (String)"table.triggers");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily9)), existentObjectIds);
            }
            iterator2 = schema.getViews().iterator();
            while (iterator2.hasNext()) {
                MsModView view;
                MsModView msModView = view = (MsModView)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)msModView, (String)"view");
                NamingIdentifyingFamily namingIdentifyingFamily10 = msModView.getTriggers();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily10, (String)"view.triggers");
                BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily10)), existentObjectIds);
            }
        }

        private final void removeUnexistentIndices(MsModSchema schema, TLongHashSet existentIndicesCombies) {
            Iterator iterator2 = schema.getTableTypes().iterator();
            while (iterator2.hasNext()) {
                MsModTableType tableType;
                MsModTableType msModTableType = tableType = (MsModTableType)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)msModTableType, (String)"tableType");
                this.removeUnexistentIndices(msModTableType, existentIndicesCombies);
            }
            iterator2 = schema.getTables().iterator();
            while (iterator2.hasNext()) {
                MsModTable table;
                MsModTable msModTable = table = (MsModTable)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)msModTable, (String)"table");
                this.removeUnexistentIndices(msModTable, existentIndicesCombies);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void removeUnexistentIndices(MsModStoredTable table, TLongHashSet existentIndicesCombies) {
            void $receiver$iv$iv;
            Iterable $receiver$iv22;
            PositioningNamingFamily positioningNamingFamily = table.getIndices();
            Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily, (String)"table.indices");
            Iterable iterable = $receiver$iv22 = (Iterable)positioningNamingFamily;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                MsModIndex it = (MsModIndex)element$iv$iv;
                long l = table.getObjectId() * 100000L;
                MsModIndex msModIndex = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)msModIndex, (String)"it");
                if (!(!existentIndicesCombies.contains(l + (long)msModIndex.getPosition()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List droppedIndices = (List)destination$iv$iv;
            int $receiver$iv22 = droppedIndices.size() - 1;
            boolean bl = false;
            while ($receiver$iv22 >= 0) {
                void i2;
                ((MsModIndex)droppedIndices.get((int)i2)).drop();
                --i2;
            }
        }

        @Override
        protected void retrieveMajorNames() {
        }

        @Override
        protected void retrieveMainContent() {
            this.retrieveCustomTypes();
            this.retrieveMajorObjects();
            this.retrieveColumns();
            this.retrieveIndices();
            this.retrieveKeys();
            this.retrieveForeignKeys();
            this.retrieveCheckConstraints();
            this.retrieveArguments();
            this.retrieveTriggers();
            this.retrieveSynonyms();
            this.retrieveDescription();
            this.retrieveSources();
        }

        private final void retrieveCustomTypes() {
            Object v2;
            List<MsIntroQueries.OneCustomTypesCheckSum> checkSums;
            block4: {
                if (Intrinsics.areEqual((Object)((MsSchema)this.getSchema()).getName(), (Object)"sys") && this.getMode$intellij_database_introspection().increment) {
                    return;
                }
                this.progress("retrieving user defined types");
                SqlQuery<List<MsIntroQueries.OneCustomTypesCheckSum>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.calculateCustomTypesCheckSums;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.calculateCustomTypesCheckSums");
                List<MsIntroQueries.OneCustomTypesCheckSum> list = checkSums = this.performQuery(sqlQuery);
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"checkSums");
                Iterable $receiver$iv = list;
                for (Object element$iv : $receiver$iv) {
                    MsIntroQueries.OneCustomTypesCheckSum it = (MsIntroQueries.OneCustomTypesCheckSum)element$iv;
                    if (!(it.type_kind == 1)) continue;
                    v2 = element$iv;
                    break block4;
                }
                v2 = null;
            }
            MsIntroQueries.OneCustomTypesCheckSum oneCustomTypesCheckSum = v2;
            long aliasTypesCheckSum = oneCustomTypesCheckSum != null ? oneCustomTypesCheckSum.check_sum : 0L;
            this.processAliasTypes(aliasTypesCheckSum);
            if (this.this$0.myVer10) {
                Object v4;
                block5: {
                    Iterable $receiver$iv = checkSums;
                    for (Object element$iv : $receiver$iv) {
                        MsIntroQueries.OneCustomTypesCheckSum it = (MsIntroQueries.OneCustomTypesCheckSum)element$iv;
                        if (!(it.type_kind == 2)) continue;
                        v4 = element$iv;
                        break block5;
                    }
                    v4 = null;
                }
                MsIntroQueries.OneCustomTypesCheckSum oneCustomTypesCheckSum2 = v4;
                long tableTypesCheckSum = oneCustomTypesCheckSum2 != null ? oneCustomTypesCheckSum2.check_sum : 0L;
                this.processTableTypes(tableTypesCheckSum);
            }
        }

        private final void processAliasTypes(long aliasTypesCheckSum) {
            if (aliasTypesCheckSum == 0L) {
                MsSchemaRetriever this_$iv = this;
                BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(){

                    public final void perform(MS schema) {
                        MS MS = schema;
                        Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                        MsModSchema schema2 = (MsModSchema)MS;
                        schema2.getAliasTypes().clear();
                        schema2.setAliasTypesCheckSum(0L);
                    }
                });
                return;
            }
            if (((MsSchema)this.getSchema()).getAliasTypesCheckSum() == aliasTypesCheckSum) {
                return;
            }
            SqlQuery<List<MsIntroQueries.OneAliasType>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveAliasTypes;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveAliasTypes");
            List<MsIntroQueries.OneAliasType> cas = this.performQuery(sqlQuery);
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(cas){
                final /* synthetic */ List $cas$inlined;
                {
                    this.$cas$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema schema2 = (MsModSchema)MS;
                    schema2.getAliasTypes().markChildrenAsSyncPending();
                    for (MsIntroQueries.OneAliasType at : this.$cas$inlined) {
                        MsModAliasType aliasType;
                        NamingIdentifyingFamily namingIdentifyingFamily = schema2.getAliasTypes();
                        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.aliasTypes");
                        ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)namingIdentifyingFamily);
                        int n = at.type_id;
                        String string = at.name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"at.name");
                        MsModAliasType msModAliasType = aliasType = (MsModAliasType)MsIntrospectorKt.access$renewType(modNamingFamily, n, string);
                        Intrinsics.checkExpressionValueIsNotNull((Object)msModAliasType, (String)"aliasType");
                        msModAliasType.setNotNull(!at.is_nullable);
                        if (at.base_name != null) {
                            DataType dt = MsIntrospectorKt.access$makeDataType(at.base_name, at.max_length, at.precision, at.scale);
                            aliasType.setDataType(dt);
                            continue;
                        }
                        aliasType.setDataType(DataType.UNKNOWN);
                    }
                    schema2.getAliasTypes().removeSyncPendingChildren();
                    schema2.getAliasTypes().sort();
                }
            });
        }

        private final void processTableTypes(long tableTypesCheckSum) {
            if (tableTypesCheckSum == 0L) {
                MsSchemaRetriever this_$iv = this;
                BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(){

                    public final void perform(MS schema) {
                        MS MS = schema;
                        Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                        MsModSchema schema2 = (MsModSchema)MS;
                        schema2.getTableTypes().clear();
                        schema2.setTableTypesCheckSum(0L);
                    }
                });
                return;
            }
            if (((MsSchema)this.getSchema()).getTableTypesCheckSum() == tableTypesCheckSum) {
                return;
            }
            SqlQuery<List<MsIntroQueries.OneTableType>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveTableTypes;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveTableTypes");
            List<MsIntroQueries.OneTableType> tts = this.performQuery(sqlQuery);
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(tts){
                final /* synthetic */ List $tts$inlined;
                {
                    this.$tts$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema schema2 = (MsModSchema)MS;
                    schema2.getTableTypes().markChildrenAsSyncPending();
                    for (MsIntroQueries.OneTableType tt : this.$tts$inlined) {
                        MsModTableType tableType;
                        NamingIdentifyingFamily namingIdentifyingFamily = schema2.getTableTypes();
                        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.tableTypes");
                        ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)namingIdentifyingFamily);
                        int n = tt.type_id;
                        String string = tt.name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tt.name");
                        MsModTableType msModTableType = tableType = (MsModTableType)MsIntrospectorKt.access$renewType(modNamingFamily, n, string);
                        Intrinsics.checkExpressionValueIsNotNull((Object)msModTableType, (String)"tableType");
                        msModTableType.setObjectId(tt.object_id);
                        MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(tableType, tt.create_date, tt.modify_date);
                    }
                    schema2.getTableTypes().removeSyncPendingChildren();
                    schema2.getTableTypes().sort();
                }
            });
            this.retrieveTypeColumns();
            this.retrieveTypeIndices();
            this.retrieveTypeKeys();
            this.retrieveTypeCheckConstraints();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveMajorObjects() {
            void tableTypesWereTouched;
            void viewsWereTouched;
            void tablesWereTouched;
            this.progress("retrieving tables, views, procedures and functions");
            SqlQuery<List<MsIntroQueries.OneObject>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveObjects;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveObjects");
            List<MsIntroQueries.OneObject> os = this.performQuery(sqlQuery);
            if (os.isEmpty()) {
                return;
            }
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            Ref.BooleanRef booleanRef2 = new Ref.BooleanRef();
            booleanRef2.element = false;
            Ref.BooleanRef booleanRef3 = new Ref.BooleanRef();
            booleanRef3.element = false;
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, os, (Ref.BooleanRef)tablesWereTouched, (Ref.BooleanRef)viewsWereTouched, (Ref.BooleanRef)tableTypesWereTouched){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ List $os$inlined;
                final /* synthetic */ Ref.BooleanRef $tablesWereTouched$inlined;
                final /* synthetic */ Ref.BooleanRef $viewsWereTouched$inlined;
                final /* synthetic */ Ref.BooleanRef $tableTypesWereTouched$inlined;
                {
                    this.this$0 = msSchemaRetriever;
                    this.$os$inlined = list;
                    this.$tablesWereTouched$inlined = booleanRef;
                    this.$viewsWereTouched$inlined = booleanRef2;
                    this.$tableTypesWereTouched$inlined = booleanRef3;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema schema2 = (MsModSchema)MS;
                    for (MsIntroQueries.OneObject o : this.$os$inlined) {
                        MsModSchemaObject obj;
                        if (o.type == null) continue;
                        if (Intrinsics.areEqual((Object)o.type, (Object)"U") || Intrinsics.areEqual((Object)o.type, (Object)"S") || Intrinsics.areEqual((Object)o.type, (Object)"IT")) {
                            E e = schema2.getTables().renew(o.object_id, o.name);
                            Intrinsics.checkExpressionValueIsNotNull(e, (String)"schema.tables.renew(o.object_id.toLong(), o.name)");
                            obj = (MsModSchemaObject)e;
                            this.$tablesWereTouched$inlined.element = true;
                        } else if (Intrinsics.areEqual((Object)o.type, (Object)"V")) {
                            E e = schema2.getViews().renew(o.object_id, o.name);
                            Intrinsics.checkExpressionValueIsNotNull(e, (String)"schema.views.renew(o.object_id.toLong(), o.name)");
                            obj = (MsModSchemaObject)e;
                            this.$viewsWereTouched$inlined.element = true;
                        } else if (Intrinsics.areEqual((Object)o.type, (Object)"TT")) {
                            E e = schema2.getTableTypes().renew(o.object_id, o.name);
                            Intrinsics.checkExpressionValueIsNotNull(e, (String)"schema.tableTypes.renew(\u2026ject_id.toLong(), o.name)");
                            obj = (MsModSchemaObject)e;
                            this.$tableTypesWereTouched$inlined.element = true;
                        } else {
                            if (!MsRoutineTypes.MS_ROUTINE_TYPES.keySet().contains(o.type)) continue;
                            MsModRoutine routine = (MsModRoutine)schema2.getRoutines().renew(o.object_id, o.name);
                            MsRoutineType routineType = MsRoutineTypes.MS_ROUTINE_TYPES.get(o.type);
                            MsModRoutine msModRoutine = routine;
                            Intrinsics.checkExpressionValueIsNotNull((Object)msModRoutine, (String)"routine");
                            msModRoutine.setRoutineType(routineType);
                            Object object = routineType;
                            routine.setRoutineKind(CollectionsKt.contains((Iterable)MsRoutineTypes.MS_FUNCTION_TYPES.values(), (Object)object) ? DasRoutine.Kind.FUNCTION : (CollectionsKt.contains((Iterable)MsRoutineTypes.MS_PROCEDURE_TYPES.values(), (Object)object) ? DasRoutine.Kind.PROCEDURE : DasRoutine.Kind.NONE));
                            obj = routine;
                            routine.getArguments().markChildrenAsSyncPending();
                            object = MsSchemaRetriever.access$getMyTouchedRoutines$p(this.this$0);
                            object.add(routine);
                        }
                        boolean nameIsSurrogate = MsIntrospectorKt.access$detectSurrogateName(o.name);
                        obj.setNameSurrogate(nameIsSurrogate);
                        MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(obj, o.create_date, o.modify_date);
                        if (!(obj instanceof MsModLikeTable)) continue;
                        MsSchemaRetriever.access$getMyTouchedTables$p(this.this$0).add(obj);
                        ((MsModLikeTable)((Object)obj)).getColumns().markChildrenAsSyncPending();
                    }
                    if (this.$tablesWereTouched$inlined.element) {
                        schema2.getTables().sort();
                    }
                    if (this.$viewsWereTouched$inlined.element) {
                        schema2.getViews().sort();
                    }
                    if (this.$tableTypesWereTouched$inlined.element) {
                        schema2.getTableTypes().sort();
                    }
                    if (!MsSchemaRetriever.access$getMyTouchedRoutines$p(this.this$0).isEmpty()) {
                        schema2.getRoutines().sort();
                    }
                }
            });
        }

        private final void retrieveColumns() {
            List<MsIntroQueries.OneColumn> cols;
            if (this.myTouchedTables.isEmpty() && this.myTouchedRoutines.isEmpty()) {
                return;
            }
            this.progress("retrieving columns of tables and views");
            SqlQuery<List<MsIntroQueries.OneColumn>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveColumns;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveColumns");
            List<MsIntroQueries.OneColumn> list = cols = this.performQuery(sqlQuery);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"cols");
            this.processColumns(list);
        }

        private final void retrieveTypeColumns() {
            List<MsIntroQueries.OneColumn> cols;
            this.progress("retrieving columns of custom table types");
            SqlQuery<List<MsIntroQueries.OneColumn>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveTypeColumns;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveTypeColumns");
            List<MsIntroQueries.OneColumn> list = cols = this.performQuery(sqlQuery);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"cols");
            this.processColumns(list);
        }

        private final void processColumns(List<MsIntroQueries.OneColumn> cols) {
            HashSet affectedCursors = new HashSet(cols.size() / 3);
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(cols, affectedCursors){
                final /* synthetic */ List $cols$inlined;
                final /* synthetic */ HashSet $affectedCursors$inlined;
                {
                    this.$cols$inlined = list;
                    this.$affectedCursors$inlined = hashSet;
                }

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public final void perform(MS schema) {
                    v0 = schema;
                    Intrinsics.checkExpressionValueIsNotNull(v0, (String)"schema");
                    schema = (MsModSchema)v0;
                    cursor = null;
                    object_id = 0;
                    for (MsIntroQueries.OneColumn col : this.$cols$inlined) {
                        block9: {
                            if (object_id == col.object_id && cursor != null) break block9;
                            object_id = col.object_id;
                            var7_7 = schema;
                            objectId$iv = object_id;
                            v1 /* !! */  = $receiver$iv.getDatabase();
                            if (v1 /* !! */  == null) ** GOTO lbl-1000
                            $receiver$iv$iv = v1 /* !! */ ;
                            v2 = $receiver$iv$iv.findIdentifiedElement(objectId$iv);
                            if (!(v2 instanceof MsModLikeTable)) {
                                v2 = null;
                            }
                            if ((v1 /* !! */  = (MsModLikeTable)v2) != null) {
                                $receiver$iv$iv = v1 /* !! */ ;
                                v3 = $receiver$iv$iv != null && Intrinsics.areEqual((Object)(it$iv = $receiver$iv$iv).getSchema(), (Object)$receiver$iv) ? $receiver$iv$iv : null;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v3 = null;
                            }
                            if ((cursor = v3) == null) continue;
                            if (col.column_position == 1) {
                                cursor.getColumns().markChildrenAsSyncPending();
                                if (cursor instanceof MsModStoredTable) {
                                    ((MsModStoredTable)cursor).getDefaultConstraints().markChildrenAsSyncPending();
                                }
                            }
                            this.$affectedCursors$inlined.add(cursor);
                        }
                        v4 = column = (MsModLikeColumn)cursor.getColumns().createOrGet(col.name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"column");
                        v4.setPosition(col.column_position);
                        column.setNotNull(col.is_nullable == false);
                        dt = MsIntrospectorKt.access$makeDataType(col.type_name, col.max_length, col.precision, col.scale);
                        column.setDataType(dt);
                        isTimestamp = Intrinsics.areEqual((Object)col.type_name, (Object)"timestamp");
                        defaultExpression = MsIntrospectorKt.access$normalizeExpression(col.default_expression);
                        column.setDefaultExpression(defaultExpression);
                        if (column instanceof MsModStoredColumn) {
                            ((MsModStoredColumn)column).setComputed(col.is_computed != false || isTimestamp != false);
                            if (col.identity_seed_value != null || col.identity_increment_value != null || col.identity_last_value != null) {
                                next = col.identity_last_value != null ? Long.valueOf(col.identity_last_value + 1L) : null;
                                ((MsModStoredColumn)column).setSequenceIdentity(SequenceIdentity.of(col.identity_seed_value, next, col.identity_increment_value, null));
                            }
                        }
                        defaultConstraintObjectId = col.default_constraint_object_id;
                        defaultConstraintName = col.default_constraint_name;
                        if (defaultConstraintName == null || defaultConstraintObjectId == 0L || !(cursor instanceof MsModStoredTable)) continue;
                        v5 = dc = (MsModDefaultConstraint)((MsModStoredTable)cursor).getDefaultConstraints().renew(defaultConstraintObjectId, defaultConstraintName);
                        Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"dc");
                        v5.setNameSurrogate(col.default_constraint_name_is_surrogate);
                        dc.setDefaultExpression(defaultExpression);
                        dc.setColNames(Collections.singletonList(column.getName()));
                        if (!(column instanceof MsModStoredColumn)) continue;
                        ((MsModStoredColumn)column).setDefaultConstraintName(defaultConstraintName);
                    }
                    var5_5 = this.$affectedCursors$inlined.iterator();
                    while (var5_5.hasNext()) {
                        v6 = t = (MsModLikeTable)var5_5.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"t");
                        v6.getColumns().removeSyncPendingChildren();
                        t.getColumns().sort();
                    }
                }
            });
        }

        private final void retrieveIndices() {
            this.progress("retrieving indices");
            SqlQuery<List<MsIntroQueries.OneIndex>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveIndices;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveIndices");
            List<MsIntroQueries.OneIndex> inds = this.performQuery(sqlQuery);
            SqlQuery<List<MsIntroQueries.OneIndexColumn>> sqlQuery2 = ((MsIntrospector)this.this$0).myQueries.retrieveIndexColumns;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"myQueries.retrieveIndexColumns");
            List<MsIntroQueries.OneIndexColumn> ics = this.performQuery(sqlQuery2);
            List<MsIntroQueries.OneIndex> list = inds;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"inds");
            List<MsIntroQueries.OneIndexColumn> list2 = ics;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ics");
            this.processIndices(list, list2);
        }

        private final void retrieveTypeIndices() {
            this.progress("retrieving indices of custom table types");
            SqlQuery<List<MsIntroQueries.OneIndex>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveTypeIndices;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveTypeIndices");
            List<MsIntroQueries.OneIndex> inds = this.performQuery(sqlQuery);
            SqlQuery<List<MsIntroQueries.OneIndexColumn>> sqlQuery2 = ((MsIntrospector)this.this$0).myQueries.retrieveTypeIndexColumns;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"myQueries.retrieveTypeIndexColumns");
            List<MsIntroQueries.OneIndexColumn> ics = this.performQuery(sqlQuery2);
            List<MsIntroQueries.OneIndex> list = inds;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"inds");
            List<MsIntroQueries.OneIndexColumn> list2 = ics;
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ics");
            this.processIndices(list, list2);
        }

        private final void processIndices(List<MsIntroQueries.OneIndex> inds, List<MsIntroQueries.OneIndexColumn> ics) {
            HashMap indices = new HashMap(inds.size());
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(inds, indices){
                final /* synthetic */ List $inds$inlined;
                final /* synthetic */ HashMap $indices$inlined;
                {
                    this.$inds$inlined = list;
                    this.$indices$inlined = hashMap;
                }

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public final void perform(MS schema) {
                    v0 = schema;
                    Intrinsics.checkExpressionValueIsNotNull(v0, (String)"schema");
                    schema = (MsModSchema)v0;
                    for (MsIntroQueries.OneIndex ind : this.$inds$inlined) {
                        var5_5 = schema;
                        objectId$iv = ind.object_id;
                        v1 /* !! */  = $receiver$iv.getDatabase();
                        if (v1 /* !! */  == null) ** GOTO lbl-1000
                        $receiver$iv$iv = v1 /* !! */ ;
                        v2 = $receiver$iv$iv.findIdentifiedElement(objectId$iv);
                        if (!(v2 instanceof MsModStoredTable)) {
                            v2 = null;
                        }
                        if ((v1 /* !! */  = (MsModStoredTable)v2) != null) {
                            $receiver$iv$iv = v1 /* !! */ ;
                            v3 /* !! */  = $receiver$iv$iv != null && Intrinsics.areEqual((Object)(it$iv = $receiver$iv$iv).getSchema(), (Object)$receiver$iv) ? $receiver$iv$iv : null;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v3 /* !! */  = null;
                        }
                        if (v3 /* !! */  == null) {
                            continue;
                        }
                        t = v3 /* !! */ ;
                        v4 = index = (MsModIndex)t.getIndices().createOrGetAt(ind.position);
                        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"index");
                        v4.setName(ind.name);
                        index.setNameSurrogate(MsIntrospectorKt.access$detectSurrogateName(ind.name));
                        index.setUnique(ind.is_unique);
                        index.setClustering(ind.type == 1);
                        index.setCondition(MsIntrospectorKt.access$normalizePredicateExpression(ind.filter_definition));
                        var11_10 = this.$indices$inlined;
                        var12_11 = new MsMinorIdentity(ind.object_id, ind.position);
                        var8_7 = index;
                        var11_10.put(var12_11, var8_7);
                    }
                }
            });
            CollectionAggregator colsA2 = new CollectionAggregator(processIndices.colsA.1.INSTANCE);
            CollectionAggregator colsI2 = new CollectionAggregator(processIndices.colsI.1.INSTANCE);
            CollectionAggregator colsR2 = new CollectionAggregator(processIndices.colsR.1.INSTANCE);
            for (MsIntroQueries.OneIndexColumn ic : ics) {
                MsMinorIdentity key2 = new MsMinorIdentity(ic.object_id, ic.index_position);
                if (!ic.is_included_column) {
                    String string = ic.name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ic.name");
                    colsA2.add(key2, string);
                    if (!ic.is_desc) continue;
                    String string2 = ic.name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ic.name");
                    colsR2.add(key2, string2);
                    continue;
                }
                String string = ic.name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ic.name");
                colsI2.add(key2, string);
            }
            MsSchemaRetriever this_$iv2 = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv2).modify((BasicElement)this_$iv2.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv2).this$0), new ModelModifier<MS>(colsA2, indices, colsI2, colsR2){
                final /* synthetic */ CollectionAggregator $colsA$inlined;
                final /* synthetic */ HashMap $indices$inlined;
                final /* synthetic */ CollectionAggregator $colsI$inlined;
                final /* synthetic */ CollectionAggregator $colsR$inlined;
                {
                    this.$colsA$inlined = collectionAggregator;
                    this.$indices$inlined = hashMap;
                    this.$colsI$inlined = collectionAggregator2;
                    this.$colsR$inlined = collectionAggregator3;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema it = (MsModSchema)MS;
                    Map<K, CV> map = this.$colsA$inlined.getResult();
                    Iterator<Map.Entry<K, CV>> iterator2 = map.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        MsModIndex index2;
                        Map.Entry<K, CV> entry;
                        Map.Entry<K, CV> entry2 = entry = iterator2.next();
                        MsMinorIdentity key2 = (MsMinorIdentity)entry2.getKey();
                        entry2 = entry;
                        List names = (List)entry2.getValue();
                        if ((MsModIndex)this.$indices$inlined.get(key2) == null) {
                            continue;
                        }
                        MsModIndex msModIndex = index2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)msModIndex, (String)"index");
                        msModIndex.setColNames(names);
                        List list = (List)this.$colsI$inlined.get(key2);
                        if (list == null) {
                            list = CollectionsKt.emptyList();
                        }
                        index2.setIncludeColNames(list);
                        Set set = (Set)this.$colsR$inlined.get(key2);
                        if (set == null) {
                            set = SetsKt.emptySet();
                        }
                        index2.setReverseColNames(set);
                    }
                }
            });
        }

        private final void retrieveKeys() {
            List<MsIntroQueries.OneKey> ks;
            this.progress("retrieving candidate keys");
            SqlQuery<List<MsIntroQueries.OneKey>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveKeys;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveKeys");
            List<MsIntroQueries.OneKey> list = ks = this.performQuery(sqlQuery);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"ks");
            this.processKeys(list);
            Collection collection = ks;
            if (!collection.isEmpty()) {
                collection = this.this$0.databasesToReResolveForeignKeys;
                Object d = this.getDatabase();
                collection.add(d);
            }
        }

        private final void retrieveTypeKeys() {
            List<MsIntroQueries.OneKey> ks;
            this.progress("retrieving keys of custom table types");
            SqlQuery<List<MsIntroQueries.OneKey>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveTypeKeys;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveTypeKeys");
            List<MsIntroQueries.OneKey> list = ks = this.performQuery(sqlQuery);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"ks");
            this.processKeys(list);
        }

        private final void processKeys(List<MsIntroQueries.OneKey> ks) {
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(ks){
                final /* synthetic */ List $ks$inlined;
                {
                    this.$ks$inlined = list;
                }

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public final void perform(MS schema) {
                    v0 = schema;
                    Intrinsics.checkExpressionValueIsNotNull(v0, (String)"schema");
                    schema = (MsModSchema)v0;
                    tables = new HashSet<MsModStoredTable>(this.$ks$inlined.size());
                    for (MsIntroQueries.OneKey k : this.$ks$inlined) {
                        block9: {
                            var6_6 = schema;
                            objectId$iv = k.table_id;
                            v1 /* !! */  = $receiver$iv.getDatabase();
                            if (v1 /* !! */  == null) ** GOTO lbl-1000
                            $receiver$iv$iv = v1 /* !! */ ;
                            v2 = $receiver$iv$iv.findIdentifiedElement(objectId$iv);
                            if (!(v2 instanceof MsModStoredTable)) {
                                v2 = null;
                            }
                            if ((v1 /* !! */  = (MsModStoredTable)v2) != null) {
                                $receiver$iv$iv = v1 /* !! */ ;
                                v3 /* !! */  = $receiver$iv$iv != null && Intrinsics.areEqual((Object)(it$iv = $receiver$iv$iv).getSchema(), (Object)$receiver$iv) ? $receiver$iv$iv : null;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v3 /* !! */  = null;
                            }
                            if (v3 /* !! */  == null) {
                                continue;
                            }
                            table = v3 /* !! */ ;
                            v4 = key = (MsModKey)table.getKeys().renew(k.key_id, k.name);
                            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"key");
                            v4.setNameSurrogate(k.is_system_named);
                            key.setPrimary(k.is_primary);
                            MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(key, k.create_date, k.modify_date);
                            v5 = table.getIndices();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"table.indices");
                            $receiver$iv = v5;
                            for (T element$iv : $receiver$iv) {
                                v6 = ind = (MsModIndex)element$iv;
                                Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"ind");
                                if (!(v6.getPosition() == k.index_position)) continue;
                                v7 = element$iv;
                                break block9;
                            }
                            v7 = null;
                        }
                        index = v7;
                        if (index != null) {
                            key.setUnderlyingIndexName(index.getRealName());
                            key.setColNames(index.getColNames());
                            index.setNameSurrogate(k.is_system_named);
                        } else {
                            key.setUnderlyingIndexName(null);
                            key.setColNames(CollectionsKt.emptyList());
                        }
                        tables.add(table);
                    }
                    var4_4 = tables.iterator();
                    while (var4_4.hasNext()) {
                        v8 = table = (MsModStoredTable)var4_4.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"table");
                        v8.getKeys().sort();
                    }
                }
            });
        }

        private final void retrieveForeignKeys() {
            if (this.myTouchedTables.isEmpty()) {
                return;
            }
            this.progress("retrieving foreign keys");
            SqlQuery<List<MsIntroQueries.OneForeignKey>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveForeignKeys;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveForeignKeys");
            List<MsIntroQueries.OneForeignKey> fks = this.performQuery(sqlQuery);
            if (fks.isEmpty()) {
                return;
            }
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, fks){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ List $fks$inlined;
                {
                    this.this$0 = msSchemaRetriever;
                    this.$fks$inlined = list;
                }

                public final void perform(MS schema) {
                    ForeignKeyInfo fki;
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema schema2 = (MsModSchema)MS;
                    HashSet<MsModTable> affectedTables = new HashSet<MsModTable>(this.$fks$inlined.size());
                    TLongObjectHashMap infos = new TLongObjectHashMap(this.$fks$inlined.size());
                    for (MsIntroQueries.OneForeignKey fk : this.$fks$inlined) {
                        MsModTable table;
                        if ((MsModTable)schema2.getTables().getByObjectId(fk.table_id) == null) {
                            continue;
                        }
                        MsModForeignKey fkey = (MsModForeignKey)table.getForeignKeys().renew(fk.constraint_id, fk.name);
                        MsSchema refSchema = (MsSchema)((MsDatabase)this.this$0.getDatabase()).getSchemas().getByObjectId(fk.referenced_schema_id);
                        MsModForeignKey msModForeignKey = fkey;
                        Intrinsics.checkExpressionValueIsNotNull((Object)msModForeignKey, (String)"fkey");
                        msModForeignKey.setNameSurrogate(fk.is_system_named);
                        fkey.setRefTableId(fk.referenced_object_id);
                        fkey.setRefTableName(fk.referenced_object_name);
                        MsSchema msSchema = refSchema;
                        fkey.setRefSchemaName(msSchema != null ? msSchema.getRealName() : null);
                        MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(fkey, fk.create_date, fk.modify_date);
                        fkey.setOnUpdate(MsIntrospectorKt.access$makeCascadeRule(fk.update_referential_action));
                        fkey.setOnDelete(MsIntrospectorKt.access$makeCascadeRule(fk.delete_referential_action));
                        fki = new ForeignKeyInfo(fkey, refSchema);
                        fki.setDomTableId(fk.table_id);
                        fki.setRefTableId(fk.referenced_object_id);
                        infos.put(fk.constraint_id, (Object)fki);
                        affectedTables.add(table);
                    }
                    SqlQuery<List<MsIntroQueries.OneForeignKeyColumn>> sqlQuery = MsIntrospector.access$getMyQueries$p((MsIntrospector)this.this$0.this$0).retrieveForeignKeyColumns;
                    Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveForeignKeyColumns");
                    List<MsIntroQueries.OneForeignKeyColumn> fcs = this.this$0.performQuery(sqlQuery);
                    for (MsIntroQueries.OneForeignKeyColumn fc : fcs) {
                        String referenceColumnName;
                        String domesticColumnName;
                        ForeignKeyInfo fki2 = (ForeignKeyInfo)infos.get(fc.constraint_id);
                        if (fc.domestic_column_name == null) {
                            continue;
                        }
                        if (fc.reference_column_name == null) {
                            continue;
                        }
                        if (fki2 == null) continue;
                        fki2.getDomColumnNames().add((Object)domesticColumnName);
                        fki2.getRefColumnNames().add((Object)referenceColumnName);
                    }
                    Object[] objectArray = infos.getValues();
                    int n = objectArray.length;
                    for (int j = 0; j < n; ++j) {
                        Object object;
                        MsTable refTable;
                        Object o;
                        Object object2 = o = objectArray[j];
                        if (object2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.introspection.ForeignKeyInfo");
                        }
                        fki = (ForeignKeyInfo)object2;
                        fki.getFkey().setColNames((List)ImmutableList.copyOf((Collection)((Collection)fki.getDomColumnNames())));
                        fki.getFkey().setRefColNames((List)ImmutableList.copyOf((Collection)((Collection)fki.getRefColumnNames())));
                        BasicNode basicNode = fki.getRefSchema();
                        MsTable msTable = basicNode != null && (basicNode = basicNode.getTables()) != null ? (MsTable)basicNode.getByObjectId(fki.getRefTableId()) : (refTable = null);
                        if (refTable != null) {
                            MsKey refKey = MsIntrospectorKt.access$findKeyByColumns(refTable, (List)fki.getRefColumnNames());
                            MsKey msKey = refKey;
                            fki.getFkey().setRefKeyName(msKey != null ? msKey.getRealName() : null);
                            if (refKey != null) continue;
                            object = MsIntrospector.access$getDatabasesToReResolveForeignKeys$p(this.this$0.this$0);
                            D d = this.this$0.getDatabase();
                            object.add(d);
                            continue;
                        }
                        Collection collection = MsIntrospector.access$getDatabasesToReResolveForeignKeys$p(this.this$0.this$0);
                        object = this.this$0.getDatabase();
                        collection.add(object);
                    }
                    Iterator<E> iterator2 = affectedTables.iterator();
                    while (iterator2.hasNext()) {
                        MsModTable table;
                        MsModTable msModTable = table = (MsModTable)iterator2.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)msModTable, (String)"table");
                        msModTable.getForeignKeys().sort();
                    }
                }
            });
        }

        private final void retrieveCheckConstraints() {
            List<MsIntroQueries.OneCheckConstraints> cs;
            if (this.myTouchedTables.isEmpty()) {
                return;
            }
            this.progress("retrieving check constraints");
            SqlQuery<List<MsIntroQueries.OneCheckConstraints>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveCheckConstraints;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveCheckConstraints");
            List<MsIntroQueries.OneCheckConstraints> list = cs = this.performQuery(sqlQuery);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"cs");
            this.processCheckConstraints(list);
        }

        private final void retrieveTypeCheckConstraints() {
            List<MsIntroQueries.OneCheckConstraints> cs;
            this.progress("retrieving check constraints of custom table types");
            SqlQuery<List<MsIntroQueries.OneCheckConstraints>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveTypeCheckConstraints;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveTypeCheckConstraints");
            List<MsIntroQueries.OneCheckConstraints> list = cs = this.performQuery(sqlQuery);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"cs");
            this.processCheckConstraints(list);
        }

        private final void processCheckConstraints(List<MsIntroQueries.OneCheckConstraints> cs) {
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(cs){
                final /* synthetic */ List $cs$inlined;
                {
                    this.$cs$inlined = list;
                }

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public final void perform(MS schema) {
                    v0 = schema;
                    Intrinsics.checkExpressionValueIsNotNull(v0, (String)"schema");
                    schema = (MsModSchema)v0;
                    affectedTables = new HashSet<MsModStoredTable>(this.$cs$inlined.size());
                    for (MsIntroQueries.OneCheckConstraints c : this.$cs$inlined) {
                        var6_6 = schema;
                        objectId$iv = c.table_id;
                        v1 /* !! */  = $receiver$iv.getDatabase();
                        if (v1 /* !! */  == null) ** GOTO lbl-1000
                        $receiver$iv$iv = v1 /* !! */ ;
                        v2 = $receiver$iv$iv.findIdentifiedElement(objectId$iv);
                        if (!(v2 instanceof MsModStoredTable)) {
                            v2 = null;
                        }
                        if ((v1 /* !! */  = (MsModStoredTable)v2) != null) {
                            $receiver$iv$iv = v1 /* !! */ ;
                            v3 /* !! */  = $receiver$iv$iv != null && Intrinsics.areEqual((Object)(it$iv = $receiver$iv$iv).getSchema(), (Object)$receiver$iv) ? $receiver$iv$iv : null;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v3 /* !! */  = null;
                        }
                        if (v3 /* !! */  == null) {
                            continue;
                        }
                        table = v3 /* !! */ ;
                        v4 = check = (MsModCheck)table.getChecks().renew(c.constraint_id, c.name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"check");
                        v4.setNameSurrogate(c.is_system_named);
                        MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(check, c.create_date, c.modify_date);
                        if (c.column_name != null) {
                            check.setColNames(Collections.singletonList(c.column_name));
                        } else {
                            check.setColNames(CollectionsKt.emptyList());
                        }
                        check.setPredicate(MsIntrospectorKt.access$normalizePredicateExpression(c.definition));
                        affectedTables.add(table);
                    }
                    var4_4 = affectedTables.iterator();
                    while (var4_4.hasNext()) {
                        v5 = table = (MsModStoredTable)var4_4.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"table");
                        v5.getChecks().sort();
                    }
                }
            });
        }

        private final void retrieveSynonyms() {
            this.progress("retrieving synonyms");
            SqlQuery<List<MsIntroQueries.OneSynonym>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveSynonyms;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveSynonyms");
            List<MsIntroQueries.OneSynonym> ss = this.performQuery(sqlQuery);
            if (ss.isEmpty()) {
                return;
            }
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(ss){
                final /* synthetic */ List $ss$inlined;
                {
                    this.$ss$inlined = list;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema schema2 = (MsModSchema)MS;
                    for (MsIntroQueries.OneSynonym s : this.$ss$inlined) {
                        MsModSynonym synonym;
                        MsModSynonym msModSynonym = synonym = (MsModSynonym)schema2.getSynonyms().renew(s.object_id, s.name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)msModSynonym, (String)"synonym");
                        msModSynonym.setTargetSchemaName(s.origin_schema_name);
                        synonym.setTargetObjectName(s.origin_object_name);
                        MsIntrospectorKt.access$setCreatedAndModifiedTimestamps(synonym, s.create_date, s.modify_date);
                    }
                    schema2.getSynonyms().sort();
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveArguments() {
            void wasDefaults;
            if (this.myTouchedRoutines.isEmpty()) {
                return;
            }
            this.progress("retrieving procedures' and functions' parameters");
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            SqlQuery<List<MsIntroQueries.OneArguments>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveArguments;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveArguments");
            List<MsIntroQueries.OneArguments> args2 = this.performQuery(sqlQuery);
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, args2, (Ref.BooleanRef)wasDefaults){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ List $args$inlined;
                final /* synthetic */ Ref.BooleanRef $wasDefaults$inlined;
                {
                    this.this$0 = msSchemaRetriever;
                    this.$args$inlined = list;
                    this.$wasDefaults$inlined = booleanRef;
                }

                public final void perform(MS schema) {
                    MsRoutine routine;
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema schema2 = (MsModSchema)MS;
                    Iterator<E> iterator2 = MsSchemaRetriever.access$getMyTouchedRoutines$p(this.this$0).iterator();
                    while (iterator2.hasNext()) {
                        MsRoutine msRoutine = routine = (MsRoutine)iterator2.next();
                        if (msRoutine == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.mssql.MsModRoutine");
                        }
                        ((MsModRoutine)msRoutine).getArguments().markChildrenAsSyncPending();
                    }
                    for (MsIntroQueries.OneArguments a : this.$args$inlined) {
                        DasArgument.Direction d;
                        MsModRoutine routine2;
                        MsModArgument argument;
                        block9: {
                            block10: {
                                if ((MsModRoutine)schema2.getRoutines().getByObjectId((long)a.object_id) == null) {
                                    continue;
                                }
                                MsModArgument msModArgument = argument = (MsModArgument)routine2.getArguments().createOrGet(a.name);
                                Intrinsics.checkExpressionValueIsNotNull((Object)msModArgument, (String)"argument");
                                msModArgument.setPosition(a.position);
                                DasArgument.Direction direction = a.is_cursor_ref ? DasArgument.Direction.RESULT : (d = a.is_output ? DasArgument.Direction.OUT : DasArgument.Direction.IN);
                                if (d != DasArgument.Direction.OUT) break block9;
                                if (a.name == null) break block10;
                                String string = a.name;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"a.name");
                                CharSequence charSequence = string;
                                if (!(charSequence.length() == 0)) break block9;
                            }
                            d = DasArgument.Direction.RETURN;
                        }
                        argument.setArgumentDirection(d);
                        DataType dt = MsIntrospectorKt.access$makeDataType(a.type_name, a.max_length, a.precision, a.scale);
                        argument.setDataType(dt);
                        argument.resetSyncPending();
                        this.$wasDefaults$inlined.element |= a.has_default_value;
                        Collection collection = MsSchemaRetriever.access$getMyTouchedRoutines$p(this.this$0);
                        collection.add(routine2);
                    }
                    iterator2 = MsSchemaRetriever.access$getMyTouchedRoutines$p(this.this$0).iterator();
                    while (iterator2.hasNext()) {
                        MsRoutine msRoutine = routine = (MsRoutine)iterator2.next();
                        if (msRoutine == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.mssql.MsModRoutine");
                        }
                        ((MsModRoutine)msRoutine).getArguments().removeSyncPendingChildren();
                    }
                }
            });
            boolean cfr_ignored_0 = wasDefaults.element;
        }

        private final void retrieveTriggers() {
            NamingIdentifyingFamily<? extends MsTable> namingIdentifyingFamily = ((MsSchema)this.getSchema()).getTables();
            Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily, (String)"schema.tables");
            boolean bl = namingIdentifyingFamily.isEmpty();
            NamingIdentifyingFamily<? extends MsView> namingIdentifyingFamily2 = ((MsSchema)this.getSchema()).getViews();
            Intrinsics.checkExpressionValueIsNotNull(namingIdentifyingFamily2, (String)"schema.views");
            if (bl & namingIdentifyingFamily2.isEmpty()) {
                return;
            }
            this.progress("retrieving triggers");
            SqlQuery<List<MsIntroQueries.OneTrigger>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveTriggers;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveTriggers");
            List<MsIntroQueries.OneTrigger> ts2 = this.performQuery(sqlQuery);
            if (ts2.isEmpty()) {
                return;
            }
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(ts2){
                final /* synthetic */ List $ts$inlined;
                {
                    this.$ts$inlined = list;
                }

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public final void perform(MS schema) {
                    v0 = schema;
                    Intrinsics.checkExpressionValueIsNotNull(v0, (String)"schema");
                    schema = (MsModSchema)v0;
                    affectedTables = new HashSet<MsModTableOrView>(this.$ts$inlined.size());
                    for (MsIntroQueries.OneTrigger t : this.$ts$inlined) {
                        var6_6 = schema;
                        objectId$iv = t.table_id;
                        v1 /* !! */  = $receiver$iv.getDatabase();
                        if (v1 /* !! */  == null) ** GOTO lbl-1000
                        $receiver$iv$iv = v1 /* !! */ ;
                        v2 = $receiver$iv$iv.findIdentifiedElement(objectId$iv);
                        if (!(v2 instanceof MsModTableOrView)) {
                            v2 = null;
                        }
                        if ((v1 /* !! */  = (MsModTableOrView)v2) != null) {
                            $receiver$iv$iv = v1 /* !! */ ;
                            v3 /* !! */  = $receiver$iv$iv != null && Intrinsics.areEqual((Object)(it$iv = $receiver$iv$iv).getSchema(), (Object)$receiver$iv) ? $receiver$iv$iv : null;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v3 /* !! */  = null;
                        }
                        if (v3 /* !! */  == null) {
                            continue;
                        }
                        table = v3 /* !! */ ;
                        v4 = trigger = (MsModTrigger)table.getTriggers().renew(t.trigger_id, t.name);
                        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"trigger");
                        v4.setEvents(MsIntrospectorKt.access$unpackEvents(t.events));
                        trigger.setFirstEvents(MsIntrospectorKt.access$unpackEvents(t.first_events));
                        trigger.setLastEvents(MsIntrospectorKt.access$unpackEvents(t.last_events));
                        trigger.setTurn(t.is_instead_of_trigger != false ? TrigTurn.INSTEAD_OF : TrigTurn.AFTER_STMT);
                        trigger.setNotForReplication(t.is_not_for_replication);
                        trigger.setDisabled(t.is_disabled);
                        trigger.setEncrypted(t.encrypted);
                        trigger.setCreatedTimestamp(t.create_date);
                        trigger.setModifiedTimestamp(t.modify_date);
                        affectedTables.add(table);
                    }
                    var4_4 = affectedTables.iterator();
                    while (var4_4.hasNext()) {
                        v5 = table = (MsModTableOrView)var4_4.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"table");
                        v5.getTriggers().sort();
                    }
                }
            });
        }

        private final void retrieveDescription() {
            long checksum;
            this.progress("retrieving tables' descriptions");
            try {
                Long checksumOrNull;
                SqlQuery<Long> sqlQuery = ((MsIntrospector)this.this$0).myQueries.calculateDescriptionsChecksum;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.calculateDescriptionsChecksum");
                Long l = checksumOrNull = this.performQuery(sqlQuery);
                checksum = l != null ? l : 0L;
            }
            catch (Exception e) {
                String message = "Failed to calculate checksum of descriptions in schema " + ((MsSchema)this.getSchema()).getName() + ": exception " + e.getClass().getSimpleName() + ": " + e.getMessage();
                if (this.this$0.getLog().isDebugEnabled()) {
                    this.this$0.getLog().warn(message, (Throwable)e);
                } else {
                    this.this$0.getLog().warn(message);
                }
                return;
            }
            if (checksum == ((MsSchema)this.getSchema()).getDescriptionsCheckSum()) {
                return;
            }
            SqlQuery<List<MsIntroQueries.OneDescription>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveDescriptions;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveDescriptions");
            List<MsIntroQueries.OneDescription> ds = this.performQuery(sqlQuery);
            HashMap descriptions = new HashMap();
            for (MsIntroQueries.OneDescription d : ds) {
                String string;
                if (d.description == null) continue;
                Map map = descriptions;
                DescriptionId descriptionId = new DescriptionId(d.object_id, d.position);
                Intrinsics.checkExpressionValueIsNotNull((Object)d.description, (String)"d.description");
                map.put(descriptionId, string);
            }
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, descriptions, checksum){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ HashMap $descriptions$inlined;
                final /* synthetic */ long $checksum$inlined;
                {
                    this.this$0 = msSchemaRetriever;
                    this.$descriptions$inlined = hashMap;
                    this.$checksum$inlined = l;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema schema2 = (MsModSchema)MS;
                    NamingIdentifyingFamily namingIdentifyingFamily = schema2.getSequences();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.sequences");
                    MsSchemaRetriever.access$processDescriptions(this.this$0, (ModIdentifyingFamily)((Object)namingIdentifyingFamily), this.$descriptions$inlined);
                    NamingIdentifyingFamily namingIdentifyingFamily2 = schema2.getAliasTypes();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily2, (String)"schema.aliasTypes");
                    MsSchemaRetriever.access$processDescriptions(this.this$0, (ModIdentifyingFamily)((Object)namingIdentifyingFamily2), this.$descriptions$inlined);
                    NamingIdentifyingFamily namingIdentifyingFamily3 = schema2.getTableTypes();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily3, (String)"schema.tableTypes");
                    MsSchemaRetriever.access$processDescriptions(this.this$0, (ModIdentifyingFamily)((Object)namingIdentifyingFamily3), this.$descriptions$inlined);
                    NamingIdentifyingFamily namingIdentifyingFamily4 = schema2.getRoutines();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily4, (String)"schema.routines");
                    MsSchemaRetriever.access$processDescriptions(this.this$0, (ModIdentifyingFamily)((Object)namingIdentifyingFamily4), this.$descriptions$inlined);
                    NamingIdentifyingFamily namingIdentifyingFamily5 = schema2.getSynonyms();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily5, (String)"schema.synonyms");
                    MsSchemaRetriever.access$processDescriptions(this.this$0, (ModIdentifyingFamily)((Object)namingIdentifyingFamily5), this.$descriptions$inlined);
                    NamingIdentifyingFamily namingIdentifyingFamily6 = schema2.getTables();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily6, (String)"schema.tables");
                    MsSchemaRetriever.access$processDescriptions(this.this$0, (ModIdentifyingFamily)((Object)namingIdentifyingFamily6), this.$descriptions$inlined);
                    NamingIdentifyingFamily namingIdentifyingFamily7 = schema2.getViews();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily7, (String)"schema.views");
                    MsSchemaRetriever.access$processDescriptions(this.this$0, (ModIdentifyingFamily)((Object)namingIdentifyingFamily7), this.$descriptions$inlined);
                    schema2.setComment((String)this.$descriptions$inlined.get(new DescriptionId(schema2.getObjectId(), 0)));
                    schema2.setDescriptionsCheckSum(this.$checksum$inlined);
                }
            });
        }

        private final <T extends BasicModIdentifiedElement & BasicModNamedElement> void processDescriptions(ModIdentifyingFamily<T> family, Map<DescriptionId, String> descriptions) {
            for (BasicModIdentifiedElement obj : family) {
                Iterator iterator2;
                long l;
                if (obj instanceof MsCustomType) {
                    l = ((MsCustomType)((Object)obj)).getTypeId();
                } else {
                    BasicModIdentifiedElement basicModIdentifiedElement = obj;
                    Intrinsics.checkExpressionValueIsNotNull((Object)basicModIdentifiedElement, (String)"obj");
                    l = basicModIdentifiedElement.getObjectId();
                }
                long objectId = l;
                ((BasicModNamedElement)((Object)obj)).setComment(descriptions.get(new DescriptionId(objectId, 0)));
                if (obj instanceof MsModLikeTable) {
                    iterator2 = ((MsModLikeTable)obj).getColumns().iterator();
                    while (iterator2.hasNext()) {
                        MsModLikeColumn column2;
                        MsModLikeColumn msModLikeColumn = column2 = (MsModLikeColumn)iterator2.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)msModLikeColumn, (String)"column");
                        msModLikeColumn.setComment(this.getDescription(descriptions, obj, column2.getPosition()));
                    }
                }
                if (obj instanceof MsModTable) {
                    iterator2 = ((MsModTable)obj).getIndices().iterator();
                    while (iterator2.hasNext()) {
                        MsModIndex index2;
                        MsModIndex msModIndex = index2 = (MsModIndex)iterator2.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)msModIndex, (String)"index");
                        msModIndex.setComment(this.getDescription(descriptions, obj, -index2.getPosition()));
                    }
                    NamingIdentifyingFamily namingIdentifyingFamily = ((MsModTable)obj).getChecks();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"obj.checks");
                    this.processDescriptions((ModIdentifyingFamily)((Object)namingIdentifyingFamily), descriptions);
                    NamingIdentifyingFamily namingIdentifyingFamily2 = ((MsModTable)obj).getKeys();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily2, (String)"obj.keys");
                    this.processDescriptions((ModIdentifyingFamily)((Object)namingIdentifyingFamily2), descriptions);
                    NamingIdentifyingFamily namingIdentifyingFamily3 = ((MsModTable)obj).getForeignKeys();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily3, (String)"obj.foreignKeys");
                    this.processDescriptions((ModIdentifyingFamily)((Object)namingIdentifyingFamily3), descriptions);
                    NamingIdentifyingFamily namingIdentifyingFamily4 = ((MsModTable)obj).getTriggers();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily4, (String)"obj.triggers");
                    this.processDescriptions((ModIdentifyingFamily)((Object)namingIdentifyingFamily4), descriptions);
                }
                if (!(obj instanceof MsModRoutine)) continue;
                iterator2 = ((MsModRoutine)obj).getArguments().iterator();
                while (iterator2.hasNext()) {
                    MsModArgument argument;
                    MsModArgument msModArgument = argument = (MsModArgument)iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)msModArgument, (String)"argument");
                    msModArgument.setComment(this.getDescription(descriptions, obj, argument.getPosition()));
                }
            }
        }

        private final String getDescription(Map<DescriptionId, String> descriptions, BasicIdentifiedElement obj, short position) {
            return position == 0 ? null : descriptions.get(new DescriptionId(obj.getObjectId(), position));
        }

        private final void retrieveSources() {
            if (!this.getWithSources$intellij_database_introspection()) {
                return;
            }
            this.progress("retrieving source texts");
            SqlQuery<List<MsIntroQueries.OneSource>> sqlQuery = ((MsIntrospector)this.this$0).myQueries.retrieveSources;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.retrieveSources");
            List<MsIntroQueries.OneSource> ss = this.performQuery(sqlQuery);
            if (ss.isEmpty()) {
                return;
            }
            MsIntrospector this_$iv = this.this$0;
            this_$iv.getModel().writeSources(new Runnable(this, ss){
                final /* synthetic */ MsSchemaRetriever this$0;
                final /* synthetic */ List $ss$inlined;
                {
                    this.this$0 = msSchemaRetriever;
                    this.$ss$inlined = list;
                }

                public final void run() {
                    MsSchemaRetriever this_$iv = this.this$0;
                    BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), (ModelModifier)new ModelModifier<MS>(this){
                        final /* synthetic */ MsSchemaRetriever$retrieveSources$$inlined$writeSources$1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        /*
                         * Unable to fully structure code
                         * Could not resolve type clashes
                         */
                        public final void perform(MS schema) {
                            v0 = schema;
                            Intrinsics.checkExpressionValueIsNotNull(v0, (String)"schema");
                            schema = (MsModSchema)v0;
                            for (MsIntroQueries.OneSource s : this.this$0.$ss$inlined) {
                                block9: {
                                    if (s.object_id == 0L || s.text == null) continue;
                                    if (s.is_trigger) break block9;
                                    var5_5 = schema;
                                    objectId$iv = s.object_id;
                                    v1 /* !! */  = $receiver$iv.getDatabase();
                                    if (v1 /* !! */  == null) ** GOTO lbl-1000
                                    $receiver$iv$iv = v1 /* !! */ ;
                                    v2 = $receiver$iv$iv.findIdentifiedElement(objectId$iv);
                                    if (!(v2 instanceof BasicModIdentifiedElement)) {
                                        v2 = null;
                                    }
                                    if ((v1 /* !! */  = (BasicModIdentifiedElement)v2) != null) {
                                        $receiver$iv$iv = v1 /* !! */ ;
                                        v3 = $receiver$iv$iv != null && Intrinsics.areEqual((Object)(it$iv = $receiver$iv$iv).getSchema(), (Object)$receiver$iv) ? $receiver$iv$iv : null;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        v3 = null;
                                    }
                                    if (!((element = v3) instanceof MsModSourceAware)) continue;
                                    v4 = s.text;
                                    ((MsModSourceAware)element).setSourceText(v4 != null ? BaseIntrospectionFunctions.toCompositeText(v4, CompositeText.Kind.ORIGINAL_TEXT) : null);
                                    continue;
                                }
                                $receiver$iv = schema;
                                objectId$iv = s.parent_id;
                                v5 /* !! */  = $receiver$iv.getDatabase();
                                if (v5 /* !! */  == null) ** GOTO lbl-1000
                                $receiver$iv$iv = v5 /* !! */ ;
                                v6 = $receiver$iv$iv.findIdentifiedElement(objectId$iv);
                                if (!(v6 instanceof MsModTableOrView)) {
                                    v6 = null;
                                }
                                if ((v5 /* !! */  = (MsModTableOrView)v6) != null) {
                                    $receiver$iv$iv = v5 /* !! */ ;
                                    v7 /* !! */  = $receiver$iv$iv != null && Intrinsics.areEqual((Object)(it$iv = $receiver$iv$iv).getSchema(), (Object)$receiver$iv) ? $receiver$iv$iv : null;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v7 /* !! */  = null;
                                }
                                if (v7 /* !! */  == null) {
                                    continue;
                                }
                                table = v7 /* !! */ ;
                                if ((MsModTrigger)table.getTriggers().getByObjectId(s.object_id) == null) {
                                    continue;
                                }
                                v8 = s.text;
                                Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"s.text");
                                trigger.setSourceText(BaseIntrospectionFunctions.toCompositeText(v8, CompositeText.Kind.ORIGINAL_TEXT));
                            }
                        }
                    });
                }
            });
        }

        @Override
        protected void finishSchema() {
            super.finishSchema();
            MsSchemaRetriever this_$iv = this;
            BaseIntrospector.AbstractSchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)this_$iv.getSchema(), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.AbstractSchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ MsSchemaRetriever this$0;
                {
                    this.this$0 = msSchemaRetriever;
                }

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    MsModSchema schema2 = (MsModSchema)MS;
                    schema2.setIntrospectionTimestamp(this.this$0.getIntrospectionBeginTimestamp$intellij_database_introspection());
                }
            });
        }

        private final void progress(String what) {
            String mode = this.getMode$intellij_database_introspection().increment ? "incrementally" : "completely";
            String string = String.format("Introspecting schema %s (%s)", ((MsSchema)this.getSchema()).getName(), mode);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"format(\"Introspecting sc\u2026(%s)\", schema.name, mode)");
            this.this$0.updateStatus(string, what);
        }

        /*
         * Unable to fully structure code
         */
        public MsSchemaRetriever(@NotNull MsIntrospector $outer, @NotNull DBTransaction transaction, MsSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            super((BaseIntrospector)$outer, transaction, (BasicSchema)schema);
            this.this$0 = $outer;
            this.myTouchedTables = new ArrayList<E>();
            this.myTouchedRoutines = new HashSet<E>();
            v0 = schema.getDatabase();
            if (v0 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"schema.database!!");
            $outer.prepareQueryParameters$intellij_database_introspection(v0, this.getQueryParameters());
            existentSourcesVersion = ((MsModModel)this.getModel()).getSchemaSourcesVersion(schema);
            if (!this.getMode$intellij_database_introspection().increment) ** GOTO lbl-1000
            v1 = existentSourcesVersion;
            if (v1 == null) {
                v1 = 0L;
            }
            if (v1 > 0L) {
                v2 = existentSourcesVersion;
                if (v2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"existentSourcesVersion!!");
                v3 = new Timestamp(v2);
            } else lbl-1000:
            // 2 sources

            {
                v3 = BaseIntrospectionFunctions.AGES_AGO;
            }
            sourcesSince = v3;
            this.setQueryParameter$intellij_database_introspection("schema_id", (int)schema.getObjectId());
            this.setQueryParameter$intellij_database_introspection("schema_name", schema.getRealName());
            this.setQueryParameter$intellij_database_introspection("since", this.getFromTimestamp$intellij_database_introspection());
            this.setQueryParameter$intellij_database_introspection("src_since", sourcesSince);
        }

        public static final /* synthetic */ void access$removeUnexistentSchemaObjects(MsSchemaRetriever $this, @NotNull MsModSchema schema, @NotNull TIntHashSet existentObjectIds) {
            $this.removeUnexistentSchemaObjects(schema, existentObjectIds);
        }

        public static final /* synthetic */ void access$removeUnexistentIndices(MsSchemaRetriever $this, @NotNull MsModSchema schema, @NotNull TLongHashSet existentIndicesCombies) {
            $this.removeUnexistentIndices(schema, existentIndicesCombies);
        }

        @NotNull
        public static final /* synthetic */ HashSet access$getMyTouchedRoutines$p(MsSchemaRetriever $this) {
            return $this.myTouchedRoutines;
        }

        @NotNull
        public static final /* synthetic */ ArrayList access$getMyTouchedTables$p(MsSchemaRetriever $this) {
            return $this.myTouchedTables;
        }

        public static final /* synthetic */ void access$processDescriptions(MsSchemaRetriever $this, @NotNull ModIdentifyingFamily family, @NotNull Map descriptions) {
            $this.processDescriptions(family, descriptions);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/introspection/MsIntrospector$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.introspection"})
    public static final class VERSION
    extends PerObjectVersion {
        public static final VERSION INSTANCE;

        private VERSION() {
        }

        static {
            VERSION vERSION;
            INSTANCE = vERSION = new VERSION();
        }
    }
}

