/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.BaseIntrospectionFunctions;
import com.intellij.database.introspection.OraIntroQueries;
import com.intellij.database.introspection.PortionType;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.SingletonFamily;
import com.intellij.database.model.oracle.OraModArgument;
import com.intellij.database.model.oracle.OraModCluster;
import com.intellij.database.model.oracle.OraModConstraint;
import com.intellij.database.model.oracle.OraModLikeTable;
import com.intellij.database.model.oracle.OraModMatView;
import com.intellij.database.model.oracle.OraModModule;
import com.intellij.database.model.oracle.OraModObjectType;
import com.intellij.database.model.oracle.OraModPackage;
import com.intellij.database.model.oracle.OraModRoot;
import com.intellij.database.model.oracle.OraModRoutine;
import com.intellij.database.model.oracle.OraModSchema;
import com.intellij.database.model.oracle.OraModSchemaObject;
import com.intellij.database.model.oracle.OraModSourceAware;
import com.intellij.database.model.oracle.OraModSynonym;
import com.intellij.database.model.oracle.OraModTable;
import com.intellij.database.model.oracle.OraModTrigger;
import com.intellij.database.model.oracle.OraModView;
import com.intellij.database.model.oracle.OraTable;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.SimpleCompositeText;
import gnu.trove.TLongHashSet;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u00be\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006H\u0002\u001a\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\u001a\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\u0018\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002\u001a \u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020%0$2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010&\u001a\u00020\u0005H\u0002\u001aN\u0010'\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u00052\u0006\u0010.\u001a\u00020\b2\b\u0010/\u001a\u0004\u0018\u00010\u00052\b\u00100\u001a\u0004\u0018\u00010\u00052\u0006\u00101\u001a\u00020\u0005H\u0002\u001aL\u00102\u001a\u0002032\u0006\u00104\u001a\u00020(2\b\u00105\u001a\u0004\u0018\u00010\u00052\b\u00106\u001a\u0004\u0018\u00010\u00052\b\u00107\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u00108\u001a\u00020\u00062\b\b\u0002\u00109\u001a\u00020\u00062\b\b\u0002\u0010:\u001a\u00020\bH\u0002\u001a\u001e\u0010;\u001a\u00020\u00172\f\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=2\u0006\u0010?\u001a\u00020@H\u0002\u001a\u0010\u0010A\u001a\u00020\u00052\u0006\u0010B\u001a\u00020\u0005H\u0003\u001a\f\u0010C\u001a\u00020\u0005*\u00020\u0005H\u0000\u001a\u0016\u0010D\u001a\u0004\u0018\u00010E*\u00020F2\u0006\u0010B\u001a\u00020\u0005H\u0002\u001a\u0016\u0010G\u001a\u0004\u0018\u00010H*\u00020 2\u0006\u0010B\u001a\u00020\u0005H\u0002\u001a\u0016\u0010I\u001a\u0004\u0018\u00010J*\u00020 2\u0006\u0010B\u001a\u00020\u0005H\u0002\u001a\u0016\u0010K\u001a\u0004\u0018\u00010L*\u00020 2\u0006\u0010M\u001a\u00020\u0005H\u0002\u001a\u0015\u0010N\u001a\u00020O*\u00020\b2\u0006\u0010P\u001a\u00020OH\u0082\b\u001a \u0010Q\u001a\u00020\u0017*\u00020%2\b\u0010R\u001a\u0004\u0018\u00010S2\b\u0010T\u001a\u0004\u0018\u00010SH\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u000b\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\f\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\r\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u000f\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0010\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"AUTO_NOT_NULL_CHECK_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "DATA_TYPE_STAR_SIZE", "", "", "", "DELIMITER", "", "EXPLICIT_UNIT_DATA_TYPES", "", "INDEX_EXPRESSION_STUB_PATTERN", "NATIVE_TRIGGER_DEFINITION_PATTERN", "SEQUENCE_SURROGATE_NAME_PATTERN", "SIMPLE_DATA_TYPES", "SIMPLE_QUOTED_NAME_PATTERN", "SURROGATE_NAME_PATTERN", "SYSTEM_SCHEMAS", "Ljava/util/TreeSet;", "applicablePortionTypeFor", "Lcom/intellij/database/introspection/PortionType;", "n", "applyStoredProgramSources", "", "obj", "Lcom/intellij/database/model/oracle/OraModSourceAware;", "text", "applyViewSources", "view", "Lcom/intellij/database/model/basic/BasicModSourceAware;", "dropUnexistentObjectsInSchema", "schema", "Lcom/intellij/database/model/oracle/OraModSchema;", "identifiers", "Lgnu/trove/TLongHashSet;", "majorFamilyOf", "Lcom/intellij/database/model/families/ModNamingIdentifyingFamily;", "Lcom/intellij/database/model/oracle/OraModSchemaObject;", "code", "makeArgument", "Lcom/intellij/database/model/basic/BasicSchema;", "routine", "Lcom/intellij/database/model/oracle/OraModRoutine;", "position", "", "argName", "argDirection", "dataTypeSchemaName", "dataTypePackageName", "dataTypeSpec", "makeDataType", "Lcom/intellij/database/model/DataType;", "thisSchema", "typeSchemaName", "typePackageName", "typeName", "precision", "scale", "unitsCode", "processSynonyms", "ss", "", "Lcom/intellij/database/introspection/OraIntroQueries$OneSynonym;", "root", "Lcom/intellij/database/model/oracle/OraModRoot;", "unquoteNameIfPossible", "name", "c2s", "findModConstraint", "Lcom/intellij/database/model/oracle/OraModConstraint;", "Lcom/intellij/database/model/oracle/OraTable;", "findModuleByName", "Lcom/intellij/database/model/oracle/OraModModule;", "findTableOrViewByName", "Lcom/intellij/database/model/oracle/OraModLikeTable;", "findTrigger", "Lcom/intellij/database/model/oracle/OraModTrigger;", "triggerName", "isSameForCatalogAndScript", "", "atBegin", "setCreatedAndModifiedTimestamps", "createdTimestamp", "Ljava/util/Date;", "modifiedTimestamp", "intellij.database.introspection"})
@JvmName(name="OraIntrospectorFunctions")
public final class OraIntrospectorFunctions {
    private static final TreeSet<String> SYSTEM_SCHEMAS = SetsKt.sortedSetOf((Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE), (Object[])new String[]{"SYS", "SYSTEM", "CTXSYS"});
    private static final Set<String> SIMPLE_DATA_TYPES = SetsKt.setOf((Object[])new String[]{"INTEGER", "BINARY_INTEGER", "BINARY_FLOAT", "BINARY_DOUBLE", "DATE", "TIME", "ROWID", "UROWID", "CLOB", "BLOB", "LONG", "LONG RAW", "BFILE"});
    private static final Set<String> EXPLICIT_UNIT_DATA_TYPES = SetsKt.setOf((Object[])new String[]{"CHAR", "VARCHAR", "VARCHAR2"});
    private static final Map<String, Integer> DATA_TYPE_STAR_SIZE = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"NUMBER", (Object)38), TuplesKt.to((Object)"FLOAT", (Object)126)});
    private static final Pattern NATIVE_TRIGGER_DEFINITION_PATTERN = Pattern.compile("^CREATE(\\s*OR\\s*REPLACE)?(\\s*[EN][A-Z]+)?\\s+TRIGGER.+$", 32);
    private static final Pattern SIMPLE_QUOTED_NAME_PATTERN = Pattern.compile("^\\s*\"([^\"]*)\"\\s*$");
    private static final Pattern AUTO_NOT_NULL_CHECK_PATTERN = Pattern.compile("\".+\" IS NOT NULL");
    private static final Pattern SURROGATE_NAME_PATTERN = Pattern.compile("^SYS_\\w*\\d+\\$*$");
    private static final Pattern INDEX_EXPRESSION_STUB_PATTERN = Pattern.compile("^SYS_NC\\d+.$");
    private static final Pattern SEQUENCE_SURROGATE_NAME_PATTERN = Pattern.compile("^ISEQ\\$+_\\d+$");
    public static final char DELIMITER = '\uffff';

    private static final PortionType applicablePortionTypeFor(int n) {
        return n <= 1 ? PortionType.ONE : (n <= PortionType.SMALL.getSize() ? PortionType.SMALL : (n <= PortionType.NORMAL.getSize() ? PortionType.NORMAL : PortionType.ALL));
    }

    private static final ModNamingIdentifyingFamily<? extends OraModSchemaObject> majorFamilyOf(OraModSchema schema, String code) {
        switch (code) {
            case "TA": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getTables();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.tables");
                return namingIdentifyingFamily;
            }
            case "CL": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getClusters();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.clusters");
                return namingIdentifyingFamily;
            }
            case "VI": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getViews();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.views");
                return namingIdentifyingFamily;
            }
            case "SY": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getSynonyms();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.synonyms");
                return namingIdentifyingFamily;
            }
            case "SE": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getSequences();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.sequences");
                return namingIdentifyingFamily;
            }
            case "PR": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getRoutines();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.routines");
                return namingIdentifyingFamily;
            }
            case "FU": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getRoutines();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.routines");
                return namingIdentifyingFamily;
            }
            case "PA": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getPackages();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.packages");
                return namingIdentifyingFamily;
            }
            case "MA": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getMatViews();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.matViews");
                return namingIdentifyingFamily;
            }
            case "YB": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getObjectTypes();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.objectTypes");
                return namingIdentifyingFamily;
            }
            case "YC": {
                NamingIdentifyingFamily namingIdentifyingFamily = schema.getCollectionTypes();
                Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.collectionTypes");
                return namingIdentifyingFamily;
            }
        }
        throw (Throwable)new IllegalArgumentException("Unknown object code: " + code);
    }

    private static final void processSynonyms(List<OraIntroQueries.OneSynonym> ss, OraModRoot root2) {
        Set affectedSchemas = new HashSet();
        for (OraIntroQueries.OneSynonym s : ss) {
            OraModSchema schema;
            OraModSynonym synonym;
            if ((OraModSchema)root2.getSchemas().get(s.synonym_schema_name) == null) {
                continue;
            }
            OraModSynonym oraModSynonym = synonym = (OraModSynonym)schema.getSynonyms().renew(s.synonym_id, s.synonym_name);
            Intrinsics.checkExpressionValueIsNotNull((Object)oraModSynonym, (String)"synonym");
            oraModSynonym.setCreatedTimestamp(s.created_timestamp);
            synonym.setModifiedTimestamp(s.modified_timestamp);
            synonym.setTargetSchemaName(s.origin_schema_name);
            synonym.setTargetObjectName(s.origin_object_name);
            affectedSchemas.add(schema);
        }
        for (OraModSchema schema : affectedSchemas) {
            schema.getSynonyms().sort();
        }
    }

    private static final void dropUnexistentObjectsInSchema(OraModSchema schema, TLongHashSet identifiers) {
        NamingIdentifyingFamily namingIdentifyingFamily = schema.getSequences();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"schema.sequences");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily2 = schema.getClusters();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily2, (String)"schema.clusters");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily2)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily3 = schema.getTables();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily3, (String)"schema.tables");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily3)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily4 = schema.getMatViews();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily4, (String)"schema.matViews");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily4)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily5 = schema.getViews();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily5, (String)"schema.views");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily5)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily6 = schema.getPackages();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily6, (String)"schema.packages");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily6)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily7 = schema.getObjectTypes();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily7, (String)"schema.objectTypes");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily7)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily8 = schema.getCollectionTypes();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily8, (String)"schema.collectionTypes");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily8)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily9 = schema.getRoutines();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily9, (String)"schema.routines");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily9)), identifiers);
        NamingIdentifyingFamily namingIdentifyingFamily10 = schema.getSynonyms();
        Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily10, (String)"schema.synonyms");
        BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily10)), identifiers);
        Iterator iterator2 = schema.getClusters().iterator();
        while (iterator2.hasNext()) {
            OraModCluster cluster;
            OraModCluster oraModCluster = cluster = (OraModCluster)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)oraModCluster, (String)"cluster");
            SingletonFamily singletonFamily = oraModCluster.getIndices();
            Intrinsics.checkExpressionValueIsNotNull((Object)singletonFamily, (String)"cluster.indices");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModSingletonFamily<? extends BasicModIdentifiedElement>)singletonFamily, identifiers);
        }
        for (OraModLikeTable table : schema.getTables()) {
            OraModTable oraModTable = table;
            Intrinsics.checkExpressionValueIsNotNull((Object)oraModTable, (String)"table");
            NamingIdentifyingFamily namingIdentifyingFamily11 = oraModTable.getIndices();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily11, (String)"table.indices");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily11)), identifiers);
            NamingIdentifyingFamily namingIdentifyingFamily12 = table.getTriggers();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily12, (String)"table.triggers");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily12)), identifiers);
        }
        for (OraModLikeTable table : schema.getMatViews()) {
        }
        iterator2 = schema.getViews().iterator();
        while (iterator2.hasNext()) {
            OraModView view;
            OraModView oraModView = view = (OraModView)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)oraModView, (String)"view");
            NamingIdentifyingFamily namingIdentifyingFamily13 = oraModView.getTriggers();
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily13, (String)"view.triggers");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModIdentifyingFamily<? extends BasicModIdentifiedElement>)((ModIdentifyingFamily)((Object)namingIdentifyingFamily13)), identifiers);
        }
        iterator2 = schema.getPackages().iterator();
        while (iterator2.hasNext()) {
            OraModPackage pack2;
            OraModPackage oraModPackage = pack2 = (OraModPackage)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)oraModPackage, (String)"pack");
            SingletonFamily singletonFamily = oraModPackage.getBodies();
            Intrinsics.checkExpressionValueIsNotNull((Object)singletonFamily, (String)"pack.bodies");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModSingletonFamily<? extends BasicModIdentifiedElement>)singletonFamily, identifiers);
        }
        iterator2 = schema.getObjectTypes().iterator();
        while (iterator2.hasNext()) {
            OraModObjectType ot;
            OraModObjectType oraModObjectType = ot = (OraModObjectType)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)oraModObjectType, (String)"ot");
            SingletonFamily singletonFamily = oraModObjectType.getBodies();
            Intrinsics.checkExpressionValueIsNotNull((Object)singletonFamily, (String)"ot.bodies");
            BaseIntrospectionFunctions.dropUnexistentObjects((ModSingletonFamily<? extends BasicModIdentifiedElement>)singletonFamily, identifiers);
        }
    }

    private static final void setCreatedAndModifiedTimestamps(@NotNull OraModSchemaObject $receiver, Date createdTimestamp, Date modifiedTimestamp) {
        $receiver.setCreatedTimestamp(createdTimestamp);
        $receiver.setModifiedTimestamp(modifiedTimestamp);
    }

    private static final OraModLikeTable findTableOrViewByName(@NotNull OraModSchema $receiver, String name) {
        OraModLikeTable oraModLikeTable;
        OraModLikeTable oraModLikeTable2 = (OraModLikeTable)$receiver.getTables().get(name);
        if (oraModLikeTable2 == null) {
            oraModLikeTable2 = oraModLikeTable = (OraModLikeTable)$receiver.getMatViews().get(name);
        }
        if (oraModLikeTable2 == null) {
            oraModLikeTable = (OraModLikeTable)$receiver.getViews().get(name);
        }
        return oraModLikeTable;
    }

    private static final OraModModule findModuleByName(@NotNull OraModSchema $receiver, String name) {
        OraModModule oraModModule = (OraModModule)$receiver.getObjectTypes().get(name);
        if (oraModModule == null) {
            oraModModule = (OraModModule)$receiver.getPackages().get(name);
        }
        return oraModModule;
    }

    private static final OraModConstraint findModConstraint(@NotNull OraTable $receiver, String name) {
        OraModConstraint oraModConstraint;
        OraModConstraint oraModConstraint2 = (OraModConstraint)$receiver.getKeys().get(name);
        if (oraModConstraint2 == null) {
            oraModConstraint2 = oraModConstraint = (OraModConstraint)$receiver.getForeignKeys().get(name);
        }
        if (oraModConstraint2 == null) {
            oraModConstraint = (OraModConstraint)$receiver.getChecks().get(name);
        }
        return oraModConstraint;
    }

    private static final OraModTrigger findTrigger(@NotNull OraModSchema $receiver, String triggerName) {
        OraModTrigger trigger;
        Iterator iterator2 = $receiver.getTables().iterator();
        while (iterator2.hasNext()) {
            OraModTable table;
            OraModTable oraModTable = table = (OraModTable)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)oraModTable, (String)"table");
            trigger = (OraModTrigger)oraModTable.getTriggers().get(triggerName);
            if (trigger == null) continue;
            return trigger;
        }
        for (OraModLikeTable view : $receiver.getViews()) {
            OraModView oraModView = view;
            Intrinsics.checkExpressionValueIsNotNull((Object)oraModView, (String)"view");
            trigger = (OraModTrigger)oraModView.getTriggers().get(triggerName);
            if (trigger == null) continue;
            return trigger;
        }
        iterator2 = $receiver.getMatViews().iterator();
        while (iterator2.hasNext()) {
            OraModLikeTable view;
            OraModLikeTable oraModLikeTable = view = (OraModMatView)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)oraModLikeTable, (String)"view");
            trigger = (OraModTrigger)oraModLikeTable.getTriggers().get(triggerName);
            if (trigger == null) continue;
            return trigger;
        }
        return null;
    }

    @Contract(pure=true)
    private static final String unquoteNameIfPossible(String name) {
        Matcher m = SIMPLE_QUOTED_NAME_PATTERN.matcher(name);
        if (m.matches()) {
            String string = m.group(1);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"m.group(1)");
            return string;
        }
        return name;
    }

    private static final void makeArgument(BasicSchema schema, OraModRoutine routine, short position, String argName, char argDirection, String dataTypeSchemaName, String dataTypePackageName, String dataTypeSpec) {
        OraModArgument argument;
        DasArgument.Direction dir = DasArgument.Direction.of((char)argDirection);
        if (dir == null && argName != null) {
            dir = DasArgument.Direction.IN;
        }
        if (dir == null) {
            dir = DasArgument.Direction.IN;
        }
        if (dir == DasArgument.Direction.RETURN) {
            BasicModArgument basicModArgument = routine.createOrGetReturnArgument();
            if (basicModArgument == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.oracle.OraModArgument");
            }
            argument = (OraModArgument)basicModArgument;
            argument.setRealName(argName);
        } else if (argName != null) {
            Object e = routine.getArguments().createOrGet(argName);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"routine.arguments.createOrGet(argName)");
            argument = (OraModArgument)e;
            argument.setPosition(position);
            argument.setArgumentDirection(dir);
        } else {
            return;
        }
        DataType dataType = OraIntrospectorFunctions.makeDataType$default(schema, dataTypeSchemaName, dataTypePackageName, dataTypeSpec, 0, 0, '\u0000', 112, null);
        argument.setDataType(dataType);
    }

    private static final DataType makeDataType(BasicSchema thisSchema, String typeSchemaName, String typePackageName, String typeName, int precision, int scale, char unitsCode) {
        DataType type;
        if (typeName == null) {
            DataType dataType = DataType.UNKNOWN;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataType.UNKNOWN");
            type = dataType;
        } else if (StringsKt.contains$default((CharSequence)typeName, (CharSequence)"(", (boolean)false, (int)2, null)) {
            DataType dataType = DataTypeFactory.of(typeName);
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(typeName)");
            type = dataType;
        } else {
            DataType dataType;
            int p;
            LengthUnit units;
            boolean customType = typeSchemaName != null;
            boolean simple = SIMPLE_DATA_TYPES.contains(typeName) && !customType;
            boolean explicitUnits = EXPLICIT_UNIT_DATA_TYPES.contains(typeName) && unitsCode == 'C' && !customType;
            switch (unitsCode) {
                case 'B': {
                    LengthUnit lengthUnit = LengthUnit.BYTE;
                    break;
                }
                case 'C': {
                    LengthUnit lengthUnit = LengthUnit.CHAR;
                    break;
                }
                case 'D': {
                    LengthUnit lengthUnit = LengthUnit.DIGIT;
                    break;
                }
                default: {
                    LengthUnit lengthUnit = units = null;
                }
            }
            String explicitSchemaName = customType ? (Intrinsics.areEqual((Object)thisSchema.getRealName(), (Object)typeSchemaName) || Intrinsics.areEqual((Object)typeSchemaName, (Object)"PUBLIC") ? null : typeSchemaName) : null;
            Integer starSize = DATA_TYPE_STAR_SIZE.get(typeName);
            int n = p = starSize != null && precision == starSize ? 0x7FFFFFFE : precision;
            if (customType) {
                DataType dataType2 = DataTypeFactory.of(explicitSchemaName, typePackageName, typeName, -1, 0, null, null, false, true);
                dataType = dataType2;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType2, (String)"DataTypeFactory.of(expli\u2026 null, null, false, true)");
            } else {
                DataType dataType3 = simple ? DataTypeFactory.of(null, typePackageName, typeName, -1, -1, units, null, false, false) : DataTypeFactory.of(null, typePackageName, typeName, p, scale, units, null, explicitUnits, false);
                dataType = dataType3;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType3, (String)"if (simple)\n          Da\u2026ll, explicitUnits, false)");
            }
            type = dataType;
        }
        return type;
    }

    static /* bridge */ /* synthetic */ DataType makeDataType$default(BasicSchema basicSchema, String string, String string2, String string3, int n, int n2, char c, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            n = -1;
        }
        if ((n3 & 0x20) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x40) != 0) {
            c = '\u0000';
        }
        return OraIntrospectorFunctions.makeDataType(basicSchema, string, string2, string3, n, n2, c);
    }

    private static final void applyStoredProgramSources(OraModSourceAware obj, String text2) {
        CharSequence charSequence;
        if (text2 != null && (charSequence = (CharSequence)text2).length() > 0) {
            obj.setSourceText(new SimpleCompositeText("CREATE ", CompositeText.Kind.PLAIN_TEXT, text2, CompositeText.Kind.ORIGINAL_TEXT));
        } else {
            obj.setSourceText(null);
        }
        obj.setObfuscated(false);
    }

    private static final void applyViewSources(BasicModSourceAware view, String text2) {
        CharSequence charSequence;
        if (text2 != null && (charSequence = (CharSequence)text2).length() > 0) {
            view.setSourceText(new SimpleCompositeText(text2, CompositeText.Kind.ORIGINAL_TEXT));
        } else {
            view.setSourceText(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String c2s(@NotNull String $receiver) {
        char c;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int n = $receiver.length();
        boolean ok = true;
        for (int p = 0; p < n; ++p) {
            void $receiver$iv;
            c = $receiver.charAt(p);
            boolean atBegin$iv = p == 0;
            boolean bl = ok = Character.isUpperCase((char)$receiver$iv) || $receiver$iv >= 48 && $receiver$iv <= 57 && !atBegin$iv || $receiver$iv == 95 || $receiver$iv == 35 || $receiver$iv == 36;
            if (!ok) break;
        }
        if (ok) {
            return $receiver;
        }
        c = '\"';
        String string = StringsKt.replace$default((String)$receiver, (String)"\"", (String)"\"\"", (boolean)false, (int)4, null);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = String.valueOf(c) + string;
        return stringBuilder.append(string2).append('\"').toString();
    }

    private static final boolean isSameForCatalogAndScript(char $receiver, boolean atBegin) {
        return Character.isUpperCase($receiver) || $receiver >= '0' && $receiver <= '9' && !atBegin || $receiver == '_' || $receiver == '#' || $receiver == '$';
    }

    @NotNull
    public static final /* synthetic */ PortionType access$applicablePortionTypeFor(int n) {
        return OraIntrospectorFunctions.applicablePortionTypeFor(n);
    }

    public static final /* synthetic */ Pattern access$getNATIVE_TRIGGER_DEFINITION_PATTERN$p() {
        return NATIVE_TRIGGER_DEFINITION_PATTERN;
    }

    public static final /* synthetic */ void access$processSynonyms(@NotNull List ss, @NotNull OraModRoot root2) {
        OraIntrospectorFunctions.processSynonyms(ss, root2);
    }

    public static final /* synthetic */ void access$dropUnexistentObjectsInSchema(@NotNull OraModSchema schema, @NotNull TLongHashSet identifiers) {
        OraIntrospectorFunctions.dropUnexistentObjectsInSchema(schema, identifiers);
    }

    @NotNull
    public static final /* synthetic */ TreeSet access$getSYSTEM_SCHEMAS$p() {
        return SYSTEM_SCHEMAS;
    }

    public static final /* synthetic */ Pattern access$getSEQUENCE_SURROGATE_NAME_PATTERN$p() {
        return SEQUENCE_SURROGATE_NAME_PATTERN;
    }

    public static final /* synthetic */ void access$setCreatedAndModifiedTimestamps(@NotNull OraModSchemaObject $receiver, @Nullable Date createdTimestamp, @Nullable Date modifiedTimestamp) {
        OraIntrospectorFunctions.setCreatedAndModifiedTimestamps($receiver, createdTimestamp, modifiedTimestamp);
    }

    @NotNull
    public static final /* synthetic */ DataType access$makeDataType(@NotNull BasicSchema thisSchema, @Nullable String typeSchemaName, @Nullable String typePackageName, @Nullable String typeName, int precision, int scale, char unitsCode) {
        return OraIntrospectorFunctions.makeDataType(thisSchema, typeSchemaName, typePackageName, typeName, precision, scale, unitsCode);
    }

    public static final /* synthetic */ Pattern access$getSURROGATE_NAME_PATTERN$p() {
        return SURROGATE_NAME_PATTERN;
    }

    public static final /* synthetic */ Pattern access$getINDEX_EXPRESSION_STUB_PATTERN$p() {
        return INDEX_EXPRESSION_STUB_PATTERN;
    }

    @NotNull
    public static final /* synthetic */ String access$unquoteNameIfPossible(@NotNull String name) {
        return OraIntrospectorFunctions.unquoteNameIfPossible(name);
    }

    public static final /* synthetic */ Pattern access$getAUTO_NOT_NULL_CHECK_PATTERN$p() {
        return AUTO_NOT_NULL_CHECK_PATTERN;
    }

    @Nullable
    public static final /* synthetic */ OraModConstraint access$findModConstraint(@NotNull OraTable $receiver, @NotNull String name) {
        return OraIntrospectorFunctions.findModConstraint($receiver, name);
    }

    @Nullable
    public static final /* synthetic */ OraModLikeTable access$findTableOrViewByName(@NotNull OraModSchema $receiver, @NotNull String name) {
        return OraIntrospectorFunctions.findTableOrViewByName($receiver, name);
    }

    @Nullable
    public static final /* synthetic */ OraModModule access$findModuleByName(@NotNull OraModSchema $receiver, @NotNull String name) {
        return OraIntrospectorFunctions.findModuleByName($receiver, name);
    }

    public static final /* synthetic */ void access$makeArgument(@NotNull BasicSchema schema, @NotNull OraModRoutine routine, short position, @Nullable String argName, char argDirection, @Nullable String dataTypeSchemaName, @Nullable String dataTypePackageName, @NotNull String dataTypeSpec) {
        OraIntrospectorFunctions.makeArgument(schema, routine, position, argName, argDirection, dataTypeSchemaName, dataTypePackageName, dataTypeSpec);
    }

    public static final /* synthetic */ void access$applyViewSources(@NotNull BasicModSourceAware view, @Nullable String text2) {
        OraIntrospectorFunctions.applyViewSources(view, text2);
    }

    public static final /* synthetic */ void access$applyStoredProgramSources(@NotNull OraModSourceAware obj, @Nullable String text2) {
        OraIntrospectorFunctions.applyStoredProgramSources(obj, text2);
    }

    @Nullable
    public static final /* synthetic */ OraModTrigger access$findTrigger(@NotNull OraModSchema $receiver, @NotNull String triggerName) {
        return OraIntrospectorFunctions.findTrigger($receiver, triggerName);
    }

    @NotNull
    public static final /* synthetic */ ModNamingIdentifyingFamily access$majorFamilyOf(@NotNull OraModSchema schema, @NotNull String code) {
        return OraIntrospectorFunctions.majorFamilyOf(schema, code);
    }
}

