/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.BaseIntrospectionFunctions;
import com.intellij.database.introspection.BaseIntrospector;
import com.intellij.database.introspection.BaseSingleDatabaseIntrospector;
import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.introspection.SqliteIntroQueries;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModTableOrView;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.sqlite.SqliteModCheck;
import com.intellij.database.model.sqlite.SqliteModForeignKey;
import com.intellij.database.model.sqlite.SqliteModIndex;
import com.intellij.database.model.sqlite.SqliteModKey;
import com.intellij.database.model.sqlite.SqliteModLikeColumn;
import com.intellij.database.model.sqlite.SqliteModLikeTable;
import com.intellij.database.model.sqlite.SqliteModModel;
import com.intellij.database.model.sqlite.SqliteModRoot;
import com.intellij.database.model.sqlite.SqliteModSchema;
import com.intellij.database.model.sqlite.SqliteModTable;
import com.intellij.database.model.sqlite.SqliteModTableColumn;
import com.intellij.database.model.sqlite.SqliteModTrigger;
import com.intellij.database.model.sqlite.SqliteModView;
import com.intellij.database.model.sqlite.SqliteModVirtualTable;
import com.intellij.database.model.sqlite.SqliteRoot;
import com.intellij.database.model.sqlite.SqliteSchema;
import com.intellij.database.model.sqlite.SqliteTableColumn;
import com.intellij.database.scripting.CompositeText;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.database.SqlLanguageObjectBuilder;
import com.intellij.sql.database.SqlObjectBuilder;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlForeignKeyDefinition;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableKeyDefinition;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Sqlite;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.exceptions.DBException;

public class SqliteIntrospector
extends BaseSingleDatabaseIntrospector<SqliteModModel, SqliteRoot, SqliteModRoot, SqliteSchema, SqliteModSchema> {
    private static final Logger LOG = Logger.getInstance(SqliteIntrospector.class);
    private final SqlPsiFacade mySqlFacade = SqlPsiFacade.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
    private final SqlLanguageDialect myLanguage = (SqlLanguageDialect)ObjectUtils.assertNotNull((Object)((SqlLanguageDialect)Language.findLanguageByID((String)"SQLite")));
    private final SqlObjectBuilder myBuilder = (SqlObjectBuilder)SqlLanguageObjectBuilder.INSTANCE.forLanguage((Language)this.myLanguage);
    public static final PerObjectVersion VERSION = new PerObjectVersion();

    protected SqliteIntrospector() {
        super(Sqlite.RDBMS, SqliteModModel.class, SqliteModRoot.class, SqliteModSchema.class);
    }

    @Override
    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends SqliteSchema> schemas) {
        if (tran == null) {
            SqliteIntrospector.$$$reportNull$$$0(0);
        }
        if (schemas == null) {
            SqliteIntrospector.$$$reportNull$$$0(1);
        }
        for (SqliteSchema sqliteSchema : schemas) {
            this.handleErrors("Introspect schema " + sqliteSchema.getName(), (Function0<Unit>)((Function0)() -> {
                if (tran == null) {
                    SqliteIntrospector.$$$reportNull$$$0(12);
                }
                BaseIntrospector.AbstractSchemaRetriever retriever = this.createSchemaRetriever(tran, schema);
                retriever.process();
                return null;
            }));
        }
    }

    @Override
    public void introspectServerObjects() {
        this.inTransaction(tran -> {
            this.retrieveCollations((DBTransaction)tran);
            return null;
        });
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        if (tran == null) {
            SqliteIntrospector.$$$reportNull$$$0(2);
        }
        List schemaInfos = (List)tran.query(SqliteIntroQueries.QUERIES.listSchemas).run();
        this.applySchemas(schemaInfos);
    }

    private void retrieveCollations(@NotNull DBTransaction tran) {
        if (tran == null) {
            SqliteIntrospector.$$$reportNull$$$0(3);
        }
        this.updateDetails("introspecting collations");
        List collationInfos = (List)tran.query(SqliteIntroQueries.QUERIES.listCollations).run();
        ((SqliteModModel)this.getModel()).modify(SqliteModRoot.class, r -> {
            NamingFamily collations = r.getCollations();
            collations.markChildrenAsSyncPending();
            for (SqliteIntroQueries.CollationInfo info : collationInfos) {
                collations.createOrGet(info.name);
            }
            collations.removeSyncPendingChildren();
            collations.sort();
        });
    }

    @Override
    public void retrieveAndApplySchemas() {
        List schemaInfos = (List)this.inTransaction(transaction -> (List)transaction.query(SqliteIntroQueries.QUERIES.listSchemas).run());
        this.applySchemas(schemaInfos);
    }

    private void applySchemas(List<SqliteIntroQueries.SchemaInfo> schemaInfos) {
        ((SqliteModModel)this.getModel()).modify(r -> {
            this.updateStatus("introspecting schemas", "");
            NamingFamily schemas = r.getSchemas();
            boolean wasEmpty = schemas.isEmpty();
            schemas.markChildrenAsSyncPending();
            for (SqliteIntroQueries.SchemaInfo schemaInfo : schemaInfos) {
                SqliteModSchema schema = (SqliteModSchema)schemas.createOrGet(schemaInfo.name);
                boolean main = SqliteIntrospector.isMain(schemaInfo.name);
                boolean temp = SqliteIntrospector.isTemp(schemaInfo.name);
                if (!wasEmpty || !main && !temp) continue;
                schema.setCurrent(main);
                schema.setVisible(true);
            }
            schemas.removeSyncPendingChildren();
        });
    }

    @Override
    @NotNull
    protected BaseIntrospector.AbstractDatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull SqliteRoot database) {
        if (transaction == null) {
            SqliteIntrospector.$$$reportNull$$$0(4);
        }
        if (database == null) {
            SqliteIntrospector.$$$reportNull$$$0(5);
        }
        throw new NotImplementedError();
    }

    @Override
    @NotNull
    protected BaseIntrospector.AbstractSchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull SqliteSchema schema) {
        if (transaction == null) {
            SqliteIntrospector.$$$reportNull$$$0(6);
        }
        if (schema == null) {
            SqliteIntrospector.$$$reportNull$$$0(7);
        }
        SqliteSchemaRetriever sqliteSchemaRetriever = new SqliteSchemaRetriever(transaction, schema);
        if (sqliteSchemaRetriever == null) {
            SqliteIntrospector.$$$reportNull$$$0(8);
        }
        return sqliteSchemaRetriever;
    }

    private static boolean isMain(String name) {
        return "main".equals(name);
    }

    private static boolean isTemp(String name) {
        return "temp".equals(name);
    }

    private static ObjectKind getKind(String type, Integer rootpage) {
        return "table".equals(type) ? (rootpage == 0 ? ObjectKind.VIRTUAL_TABLE : ObjectKind.TABLE) : ("view".equals(type) ? ObjectKind.VIEW : ("index".equals(type) ? ObjectKind.INDEX : ("trigger".equals(type) ? ObjectKind.TRIGGER : null)));
    }

    private static String fixName(String name, @NotNull Family<?> src) {
        Object object;
        if (src == null) {
            SqliteIntrospector.$$$reportNull$$$0(9);
        }
        return (object = SqliteIntrospector.findObject(name, src)) == null ? name : object.getName();
    }

    private static void fixNames(List<String> names, @NotNull Family<?> src) {
        if (src == null) {
            SqliteIntrospector.$$$reportNull$$$0(10);
        }
        for (int i2 = 0; i2 < names.size(); ++i2) {
            names.set(i2, SqliteIntrospector.fixName(names.get(i2), src));
        }
    }

    private static <T extends BasicElement> T findObject(String name, @NotNull Family<T> src) {
        if (src == null) {
            SqliteIntrospector.$$$reportNull$$$0(11);
        }
        if (name == null) {
            return null;
        }
        for (BasicElement element : src) {
            if (!name.equalsIgnoreCase(element.getName())) continue;
            return (T)element;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tran";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemas";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transaction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "database";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/introspection/SqliteIntrospector";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/introspection/SqliteIntrospector";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createSchemaRetriever";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "introspectSchemasAuto";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "introspectNamespacesInTran";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "retrieveCollations";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDatabaseRetriever";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createSchemaRetriever";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fixName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fixNames";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findObject";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$introspectSchemasAuto$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SqliteSchemaRetriever
    extends BaseIntrospector.AbstractSchemaRetriever {
        SqliteSchemaRetriever(@NotNull DBTransaction transaction, SqliteSchema schema) {
            if (SqliteIntrospector.this == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(0);
            }
            if (transaction == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(1);
            }
            if (schema == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(2);
            }
            super((BaseIntrospector)SqliteIntrospector.this, transaction, (BasicSchema)schema, IntrospectionMode.INCREMENT);
        }

        @Override
        protected void prepareParameters() {
            SqliteIntrospector.this.queryParameters.put("SCHEMA", SqliteIntroQueries.quote(((SqliteSchema)this.getSchema()).getName()));
            super.prepareParameters();
        }

        @Override
        protected void retrieveMainContent() {
            SqliteIntrospector.this.updateStatus(String.format("introspecting schema %s", ((SqliteSchema)this.getSchema()).getName()), "");
            this.retrieveTablesAndViews();
            this.retrieveColumns();
            this.retrieveIndicesAndForeignKeys();
            this.retrieveSourcesAndExtras();
        }

        private void retrieveTablesAndViews() {
            SqliteIntrospector.this.updateDetails("introspecting tables and views");
            boolean temp = SqliteIntrospector.isTemp(((SqliteSchema)this.getSchema()).getName());
            List<SqliteIntroQueries.MajorInfo> majorInfos = this.performQuery(temp ? SqliteIntroQueries.QUERIES.retrieveTempMajors : SqliteIntroQueries.QUERIES.retrieveMajors);
            ((SqliteModModel)this.getModel()).modify((BasicElement)this.getSchema(), SqliteModSchema.class, s -> s.getModel().writeSources(() -> {
                s.getTables().markChildrenAsSyncPending();
                s.getVirtualTables().markChildrenAsSyncPending();
                s.getViews().markChildrenAsSyncPending();
                SqliteModTable master = (SqliteModTable)s.getTables().createOrGet(temp ? "sqlite_temp_master" : "sqlite_master");
                master.setSystem(true);
                for (SqliteIntroQueries.MajorInfo majorInfo : majorInfos) {
                    BasicModTableOrView table;
                    ObjectKind kind = SqliteIntrospector.getKind(majorInfo.type, majorInfo.rootpage);
                    if (kind == ObjectKind.TABLE) {
                        table = (SqliteModTable)s.getTables().createOrGet(majorInfo.name);
                        String name = majorInfo.name;
                        table.setSystem(this.isSystem(name));
                        table.setTemporary(temp);
                        continue;
                    }
                    if (kind == ObjectKind.VIRTUAL_TABLE) {
                        table = (SqliteModVirtualTable)s.getVirtualTables().createOrGet(majorInfo.name);
                        table.setTemporary(temp);
                        continue;
                    }
                    if (kind != ObjectKind.VIEW) continue;
                    s.getViews().createOrGet(majorInfo.name);
                }
                s.getTables().removeSyncPendingChildren();
                s.getTables().sort();
                s.getVirtualTables().removeSyncPendingChildren();
                s.getVirtualTables().sort();
                s.getViews().removeSyncPendingChildren();
                s.getViews().sort();
            }));
        }

        private boolean isSystem(String name) {
            return "sqlite_sequence".equals(name);
        }

        private void retrieveColumns() {
            ((SqliteModModel)this.getModel()).modify((BasicElement)this.getSchema(), SqliteModSchema.class, s -> s.getModel().writeSources(() -> {
                for (SqliteModLikeTable table : s.getTables()) {
                    this.retrieveColumns(table);
                }
                for (SqliteModLikeTable table : s.getViews()) {
                    this.retrieveColumns(table);
                }
            }));
        }

        private void retrieveIndicesAndForeignKeys() {
            ((SqliteModModel)this.getModel()).modify((BasicElement)this.getSchema(), SqliteModSchema.class, s -> s.getModel().writeSources(() -> {
                for (SqliteModTable table : s.getTables()) {
                    this.retrieveIndicesAndForeignKeys(table);
                }
            }));
        }

        private void retrieveIndicesAndForeignKeys(@NotNull SqliteModTable table) {
            if (table == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(3);
            }
            this.getQueryParameters().put("TABLE", SqliteIntroQueries.quote(table.getName()));
            this.retrieveIndices(table);
            for (SqliteModIndex index2 : table.getIndices()) {
                this.retrieveIndexColumns(index2);
            }
            this.retrieveForeignKeys(table);
        }

        private void retrieveIndexColumns(@NotNull SqliteModIndex index2) {
            if (index2 == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(4);
            }
            SqliteIntrospector.this.updateDetails(String.format("introspecting columns of index %s", index2.getName()));
            this.getQueryParameters().put("INDEX", SqliteIntroQueries.quote(index2.getName()));
            try {
                List<SqliteIntroQueries.IndexColumnInfo> indexColumnInfos = this.performQuery(SqliteIntroQueries.QUERIES.listIndexColumns);
                indexColumnInfos.sort((o1, o2) -> Comparing.compare((Comparable)o1.seqno, (Comparable)o2.seqno));
                ArrayList cols = ContainerUtil.newArrayListWithCapacity((int)indexColumnInfos.size());
                ArrayList collations = ContainerUtil.newArrayListWithCapacity((int)indexColumnInfos.size());
                LinkedHashSet rev = ContainerUtil.newLinkedHashSet();
                int cnt = 1;
                String prefix = null;
                for (SqliteIntroQueries.IndexColumnInfo info : indexColumnInfos) {
                    String name;
                    if (info.key != 1) continue;
                    if (info.name != null) {
                        name = SqliteIntrospector.fixName(info.name, index2.getTable().getColumns());
                    } else {
                        if (prefix == null) {
                            prefix = this.findPlaceholderPrefix(indexColumnInfos);
                        }
                        name = prefix + cnt;
                        ++cnt;
                    }
                    cols.add(name);
                    if (info.desc == 1) {
                        rev.add(name);
                    }
                    collations.add(StringUtil.notNullize((String)SqliteIntrospector.fixName(info.coll, ((SqliteModModel)this.getModel()).getRoot().getCollations())));
                }
                index2.setColNames(cols);
                index2.setReverseColNames(rev);
                index2.setColumnCollations(collations);
            }
            catch (DBException e) {
                LOG.warn(String.format("Failed to retrieve columns of index %s", index2.getName()), (Throwable)e);
            }
        }

        private String findPlaceholderPrefix(List<SqliteIntroQueries.IndexColumnInfo> indexColumnInfos) {
            int num = 0;
            for (SqliteIntroQueries.IndexColumnInfo info : indexColumnInfos) {
                int cnt;
                if (info.name == null) continue;
                for (cnt = 0; cnt < info.name.length() && info.name.charAt(cnt) == '#'; ++cnt) {
                }
                if (num >= cnt) continue;
                num = cnt;
            }
            return StringUtil.repeat((String)"#", (int)(num + 1));
        }

        private void retrieveIndices(@NotNull SqliteModTable table) {
            if (table == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(5);
            }
            SqliteIntrospector.this.updateDetails(String.format("introspecting indices of %s", table.getName()));
            NamingFamily indices = table.getIndices();
            indices.markChildrenAsSyncPending();
            try {
                List<SqliteIntroQueries.IndexInfo> indexInfos = this.performQuery(SqliteIntroQueries.QUERIES.listIndices);
                for (SqliteIntroQueries.IndexInfo indexInfo : indexInfos) {
                    SqliteModIndex index2 = (SqliteModIndex)indices.createOrGet(indexInfo.name);
                    index2.setUnique(indexInfo.unique == 1);
                    index2.setNameSurrogate(index2.getName().startsWith("sqlite_autoindex_"));
                }
            }
            catch (DBException e) {
                LOG.warn(String.format("Failed to retrieve indices of %s", table.getName()), (Throwable)e);
            }
            indices.removeSyncPendingChildren();
            indices.sort();
        }

        private void retrieveForeignKeys(@NotNull SqliteModTable table) {
            if (table == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(6);
            }
            SqliteIntrospector.this.updateDetails(String.format("introspecting foreign keys of %s", table.getName()));
            NamingFamily foreignKeys = table.getForeignKeys();
            foreignKeys.markChildrenAsSyncPending();
            try {
                List<SqliteIntroQueries.ForeignKeyInfo> foreignKeyInfos = this.performQuery(SqliteIntroQueries.QUERIES.listForeignKeys);
                TIntObjectHashMap groups = new TIntObjectHashMap();
                for (SqliteIntroQueries.ForeignKeyInfo foreignKeyInfo : foreignKeyInfos) {
                    List list = (List)groups.get(foreignKeyInfo.id.intValue());
                    if (list == null) {
                        list = ContainerUtil.newArrayList();
                        groups.put(foreignKeyInfo.id.intValue(), (Object)list);
                    }
                    list.add(foreignKeyInfo);
                }
                HashSet visited = ContainerUtil.newHashSet();
                groups.forEachValue(arg_0 -> this.lambda$retrieveForeignKeys$8(table, (ModNamingFamily)foreignKeys, visited, arg_0));
            }
            catch (DBException e) {
                LOG.warn(String.format("Failed to retrieve foreign keys of %s", table.getName()), (Throwable)e);
            }
            foreignKeys.removeSyncPendingChildren();
        }

        private void retrieveColumns(@NotNull SqliteModLikeTable table) {
            if (table == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(7);
            }
            this.getQueryParameters().put("TABLE", SqliteIntroQueries.quote(table.getName()));
            SqliteIntrospector.this.updateDetails(String.format("introspecting columns of %s", table.getName()));
            PositioningNamingFamily columns2 = table.getColumns();
            columns2.markChildrenAsSyncPending();
            try {
                if (table instanceof SqliteModView) {
                    ((SqliteModView)table).setInvalid(false);
                }
                List<SqliteIntroQueries.ColumnInfo> columnInfos = this.performQuery(SqliteIntroQueries.QUERIES.listColumns);
                for (SqliteIntroQueries.ColumnInfo columnInfo : columnInfos) {
                    SqliteModLikeColumn column2 = (SqliteModLikeColumn)columns2.createOrGetAt((short)(columnInfo.cid.shortValue() + 1));
                    column2.setName(columnInfo.name);
                    column2.setDataType(StringUtil.isEmpty((String)columnInfo.type) ? DataType.UNKNOWN : DataTypeFactory.of(columnInfo.type));
                    column2.setNotNull(columnInfo.notnull == 1);
                    column2.setDefaultExpression(columnInfo.dflt_value);
                }
            }
            catch (DBException e) {
                String msg = e.getMessage();
                if (msg != null && msg.contains("no such table")) {
                    if (table instanceof SqliteModView) {
                        ((SqliteModView)table).setInvalid(true);
                    }
                }
                LOG.warn(String.format("Failed to retrieve columns of %s", table.getName()), (Throwable)e);
            }
            columns2.removeSyncPendingChildren();
        }

        private void retrieveSourcesAndExtras() {
            List<SqliteIntroQueries.SourceInfo> sourceInfos = this.performQuery(SqliteIntrospector.isTemp(((SqliteSchema)this.getSchema()).getName()) ? SqliteIntroQueries.QUERIES.retrieveTempSources : SqliteIntroQueries.QUERIES.retrieveSources);
            ((SqliteModModel)this.getModel()).modify((BasicElement)this.getSchema(), SqliteModSchema.class, s -> s.getModel().writeSources(() -> {
                for (SqliteModLikeTable t : s.getTables()) {
                    t.getTriggers().markChildrenAsSyncPending();
                }
                for (SqliteModLikeTable t : s.getViews()) {
                    t.getTriggers().markChildrenAsSyncPending();
                }
                for (SqliteIntroQueries.SourceInfo sourceInfo : sourceInfos) {
                    SqliteIntrospector.this.updateDetails(String.format("introspecting sources of %s %s", sourceInfo.type, sourceInfo.name));
                    BasicTableOrView table = s.getTableOrView(sourceInfo.tbl_name);
                    if (table == null) continue;
                    ObjectKind kind = SqliteIntrospector.getKind(sourceInfo.type, sourceInfo.rootpage);
                    if (kind == ObjectKind.TRIGGER) {
                        this.fillTrigger(sourceInfo, (BasicModTableOrView)table);
                        continue;
                    }
                    if (kind == ObjectKind.INDEX) {
                        this.fillIndex(sourceInfo, (BasicModTableOrView)table);
                        continue;
                    }
                    if (kind == ObjectKind.TABLE) {
                        this.fillTable(sourceInfo, (BasicModTableOrView)table);
                        continue;
                    }
                    if (kind == ObjectKind.VIRTUAL_TABLE) {
                        this.fillVirtualTable(sourceInfo, (BasicModTableOrView)table);
                        continue;
                    }
                    if (kind != ObjectKind.VIEW) continue;
                    this.fillView(sourceInfo, (BasicModTableOrView)table);
                }
                for (SqliteModLikeTable t : s.getTables()) {
                    t.getTriggers().removeSyncPendingChildren();
                    t.getTriggers().sort();
                    t.getForeignKeys().sort();
                    t.getIndices().sort();
                    this.cleanupIndices((SqliteModTable)t);
                    this.resolveForeignKeys((SqliteModTable)t);
                }
                for (SqliteModLikeTable t : s.getViews()) {
                    t.getTriggers().removeSyncPendingChildren();
                    t.getTriggers().sort();
                }
            }));
        }

        private void cleanupIndices(SqliteModTable t) {
            Iterator iterator2 = t.getKeys().iterator();
            while (iterator2.hasNext()) {
                SqliteModKey key2;
                List<String> cols = (key2 = (SqliteModKey)iterator2.next()).getColNames();
                SqliteModIndex index2 = this.findAutoIndexByCols(t, cols);
                key2.setUnderlyingIndexName(index2 == null ? null : index2.getName());
            }
            PositioningNamingFamily columns2 = t.getColumns();
            for (SqliteModIndex index3 : t.getIndices()) {
                List<String> cols = index3.getColNames();
                List<String> collations = index3.getColumnCollations();
                ArrayList newCollations = null;
                for (int i2 = 0; i2 < collations.size(); ++i2) {
                    String columnCollation;
                    String collation = collations.get(i2);
                    SqliteTableColumn column2 = i2 < cols.size() ? (SqliteModTableColumn)SqliteIntrospector.findObject(cols.get(i2), columns2) : null;
                    String string = columnCollation = column2 == null ? null : column2.getCollation();
                    if (columnCollation == null) {
                        columnCollation = "binary";
                    }
                    if (!columnCollation.equalsIgnoreCase(collation)) continue;
                    if (newCollations == null) {
                        newCollations = ContainerUtil.newArrayList(collations);
                    }
                    newCollations.set(i2, "");
                }
                if (newCollations == null) continue;
                index3.setColumnCollations(newCollations);
            }
        }

        private void resolveForeignKeys(SqliteModTable t) {
            for (SqliteModForeignKey fk : t.getForeignKeys()) {
                SqliteIntrospector.this.myBuilder.finalize((DasObject)fk);
            }
        }

        private void fillView(SqliteIntroQueries.SourceInfo info, BasicModTableOrView tbl) {
            SqliteModView view = (SqliteModView)ObjectUtils.tryCast((Object)tbl, SqliteModView.class);
            if (view == null) {
                return;
            }
            String text2 = info.sql;
            if (text2 != null) {
                view.setSourceText(BaseIntrospectionFunctions.toCompositeText(info.sql, CompositeText.Kind.ORIGINAL_TEXT));
            } else {
                view.setSourceText(null);
            }
        }

        private void fillTable(SqliteIntroQueries.SourceInfo info, BasicModTableOrView tbl) {
            SqliteModTable table = (SqliteModTable)ObjectUtils.tryCast((Object)tbl, SqliteModTable.class);
            if (table == null) {
                return;
            }
            SqlCreateTableStatement stmt = this.getStatement(info.sql, SqlCreateTableStatement.class);
            if (stmt != null) {
                SqliteIntrospector.this.myBuilder.partialBuild((DasObject)table, (DasObject)stmt);
            }
            this.fillTableChildren(table, stmt);
        }

        private void fillTableChildren(SqliteModTable table, @Nullable SqlCreateTableStatement stmt) {
            PsiElement def2;
            table.getKeys().markChildrenAsSyncPending();
            table.getChecks().markChildrenAsSyncPending();
            for (SqliteModTableColumn column2 : table.getColumns()) {
                column2.setSequenceIdentity(null);
            }
            ArrayList foreignKeys = ContainerUtil.newArrayList();
            PsiElement psiElement = def2 = stmt == null ? null : stmt.getFirstChild();
            while (def2 != null) {
                if (def2 instanceof SqlColumnDefinition) {
                    this.fillColumn(table, (SqlColumnDefinition)def2, foreignKeys);
                } else {
                    this.fillConstraints(table, def2, foreignKeys);
                }
                def2 = def2.getNextSibling();
            }
            this.fillForeignKeys(table, foreignKeys);
            table.getKeys().removeSyncPendingChildren();
            table.getKeys().sort();
            table.getChecks().removeSyncPendingChildren();
            table.getChecks().sort();
        }

        private void fillForeignKeys(SqliteModTable table, List<SqlForeignKeyDefinition> foreignKeys) {
            foreignKeys.sort((o1, o2) -> StringUtil.isEmpty((String)o1.getName()) ? (StringUtil.isEmpty((String)o2.getName()) ? 0 : 1) : (StringUtil.isEmpty((String)o2.getName()) ? -1 : 0));
            HashSet visited = ContainerUtil.newHashSet();
            for (SqlForeignKeyDefinition def2 : foreignKeys) {
                this.fillForeignKey(table, def2, visited);
            }
        }

        private void fillVirtualTable(SqliteIntroQueries.SourceInfo info, BasicModTableOrView tbl) {
            SqliteModVirtualTable table = (SqliteModVirtualTable)ObjectUtils.tryCast((Object)tbl, SqliteModVirtualTable.class);
            if (table == null) {
                return;
            }
            SqlCreateStatement stmt = this.getStatement(info.sql, SqlCreateStatement.class);
            if (stmt != null) {
                SqliteIntrospector.this.myBuilder.partialBuild((DasObject)table, (DasObject)stmt);
            }
        }

        private void fillConstraint(SqliteModTable table, SqlConstraintDefinition def2) {
            if (def2.getConstraintType() != SqlConstraintDefinition.Type.CHECK) {
                return;
            }
            String name = StringUtil.nullize((String)def2.getName());
            SqlExpression expr = (SqlExpression)def2.getConstraintParameter(SqlConstraintDefinition.EXPRESSION);
            String exprText = expr == null ? null : expr.getText();
            SqliteModCheck check = this.findOrCreateCheck((ModNamingFamily<? extends SqliteModCheck>)table.getChecks(), name, exprText);
            check.setPredicate(exprText);
            SqliteIntrospector.this.myBuilder.partialBuild((DasObject)check, (DasObject)def2);
        }

        private void fillTableKey(SqliteModTable table, SqlTableKeyDefinition def2) {
            String name = StringUtil.nullize((String)def2.getName());
            ArrayList cols = ContainerUtil.newArrayList((Iterable)def2.getColumnsRef().names());
            SqliteIntrospector.fixNames(cols, table.getColumns());
            SqliteModKey key2 = this.findOrCreateKey((ModNamingFamily<? extends SqliteModKey>)table.getKeys(), name, def2.isPrimary(), cols);
            key2.setColNames(cols);
            SqliteIntrospector.this.myBuilder.partialBuild((DasObject)key2, (DasObject)def2);
        }

        private <T extends BasicModNamedElement> T findOrCreate(ModNamingFamily<T> family, String name, Predicate<T> p) {
            if (name != null) {
                return family.createOrGet(name);
            }
            BasicModNamedElement obj = family.find(c -> c.isSyncPending() && p.test(c));
            if (obj == null) {
                return (T)((BasicModNamedElement)family.createNewOne());
            }
            obj.resetSyncPending();
            return (T)obj;
        }

        private SqliteModCheck findOrCreateCheck(ModNamingFamily<? extends SqliteModCheck> checks, String name, String expr) {
            return this.findOrCreate(checks, name, c -> c.getRealName() == null && Comparing.equal((String)expr, (String)c.getPredicate()));
        }

        private SqliteModKey findOrCreateKey(ModNamingFamily<? extends SqliteModKey> keys, String name, boolean primary2, List<String> cols) {
            return this.findOrCreate(keys, name, k -> k.getRealName() == null && this.keyMatches((SqliteModKey)k, cols, primary2));
        }

        private void fillForeignKey(SqliteModTable table, SqlForeignKeyDefinition def2, Set<SqliteModForeignKey> visited) {
            SqliteModForeignKey matchedByName;
            String name = StringUtil.nullize((String)def2.getName());
            SqliteModForeignKey sqliteModForeignKey = matchedByName = name != null ? (SqliteModForeignKey)table.getForeignKeys().get(name, false) : null;
            if (visited.contains(matchedByName)) {
                matchedByName = null;
            }
            SqliteModTable refTable = (SqliteModTable)SqliteIntrospector.findObject(def2.getRefTableName(), table.getParentFamily());
            ArrayList refCols = ContainerUtil.newArrayList((Iterable)def2.getRefColumns().names());
            ArrayList cols = ContainerUtil.newArrayList((Iterable)def2.getColumnsRef().names());
            if (refTable != null) {
                SqliteIntrospector.fixNames(refCols, refTable.getColumns());
            }
            SqliteIntrospector.fixNames(cols, table.getColumns());
            CascadeRule onUpdate = this.toCascadeRule(def2.getUpdateRule());
            CascadeRule onDelete = this.toCascadeRule(def2.getDeleteRule());
            DasForeignKey.Deferrability deferrability = def2.getDeferrability();
            SqliteModForeignKey target = null;
            for (int step = 0; step < 2 && target == null; ++step) {
                if (matchedByName != null && this.fkMatches(matchedByName, name, cols, refCols, onDelete, onUpdate, step == 0)) {
                    target = matchedByName;
                } else {
                    SqliteModForeignKey foreignKey = this.findFk(table.getForeignKeys(), refTable == null ? def2.getRefTableName() : refTable.getName(), cols, refCols, onDelete, onUpdate, visited, step == 0);
                    if (foreignKey != null) {
                        target = foreignKey;
                    }
                }
                if (step != 1 || target == null) continue;
                LOG.warn("Partial match: " + def2.getNameElement() + " sql: " + (Object)((Object)onUpdate) + ", " + (Object)((Object)onDelete) + " db: " + (Object)((Object)target.getOnUpdate()) + ", " + (Object)((Object)target.getOnDelete()));
            }
            if (target == null) {
                LOG.warn("Unmatched FK: " + def2.getName());
                return;
            }
            boolean deferred = deferrability == DasForeignKey.Deferrability.INITIALLY_DEFERRED;
            target.setDeferrable(deferred);
            target.setInitiallyDeferred(deferred);
            visited.add(target);
            target.setRealName(name);
        }

        private void fillColumn(SqliteModTable table, SqlColumnDefinition columnDef, List<SqlForeignKeyDefinition> foreignKeys) {
            String name = columnDef.getName();
            SqliteModTableColumn column2 = table.getColumns().find(c -> c.getName().equalsIgnoreCase(name));
            if (column2 != null) {
                SqliteIntrospector.this.myBuilder.partialBuild((DasObject)column2, (DasObject)columnDef);
            }
            for (PsiElement def2 = columnDef.getFirstChild(); def2 != null; def2 = def2.getNextSibling()) {
                this.fillConstraints(table, def2, foreignKeys);
            }
        }

        private void fillConstraints(SqliteModTable table, PsiElement def2, List<SqlForeignKeyDefinition> foreignKeys) {
            if (def2 instanceof SqlForeignKeyDefinition) {
                foreignKeys.add((SqlForeignKeyDefinition)def2);
            } else if (def2 instanceof SqlTableKeyDefinition) {
                this.fillTableKey(table, (SqlTableKeyDefinition)def2);
            } else if (def2 instanceof SqlConstraintDefinition) {
                this.fillConstraint(table, (SqlConstraintDefinition)def2);
            }
        }

        private void fillIndex(SqliteIntroQueries.SourceInfo info, BasicModTableOrView tbl) {
            SqliteModTable table = (SqliteModTable)ObjectUtils.tryCast((Object)tbl, SqliteModTable.class);
            if (table == null) {
                return;
            }
            SqliteModIndex index2 = (SqliteModIndex)table.getIndices().createOrGet(info.name);
            SqlCreateIndexStatement stmt = this.getStatement(info.sql, SqlCreateIndexStatement.class);
            if (stmt != null) {
                SqliteIntrospector.this.myBuilder.partialBuild((DasObject)index2, (DasObject)stmt);
            }
        }

        private void fillTrigger(@NotNull SqliteIntroQueries.SourceInfo info, BasicModTableOrView tbl) {
            SqliteModLikeTable table;
            if (info == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(8);
            }
            if ((table = (SqliteModLikeTable)ObjectUtils.tryCast((Object)tbl, SqliteModLikeTable.class)) == null) {
                return;
            }
            SqliteModTrigger trigger = (SqliteModTrigger)table.getTriggers().createOrGet(info.name);
            String sourceText = info.sql;
            if (sourceText != null) {
                trigger.setSourceText(BaseIntrospectionFunctions.toCompositeText(sourceText, CompositeText.Kind.ORIGINAL_TEXT));
            } else {
                trigger.setSourceText(null);
            }
            SqlCreateTriggerStatement stmt = this.getStatement(info.sql, SqlCreateTriggerStatement.class);
            if (stmt != null) {
                SqliteIntrospector.this.myBuilder.partialBuild((DasObject)trigger, (DasObject)stmt);
            }
        }

        @Nullable
        private <T extends SqlStatement> T getStatement(@Nullable String sql, @NotNull Class<T> clazz) {
            if (clazz == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(9);
            }
            if (sql == null) {
                return null;
            }
            try {
                return (T)((SqlStatement)((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)SqliteIntrospector.this.mySqlFacade.createROFile(SqliteIntrospector.this.myLanguage, (CharSequence)sql)).expandAndSkip(e -> !(e instanceof SqlStatement))).filter(clazz).first());
            }
            catch (Exception e2) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.error((Throwable)e2);
                }
                LOG.warn("Failed to parse sources", (Throwable)e2);
                return null;
            }
        }

        private SqliteModIndex findAutoIndexByCols(SqliteModTable t, List<String> cols) {
            SqliteModIndex res = null;
            int grade = 0;
            for (int i2 = 0; i2 < 2; ++i2) {
                Iterator iterator2 = t.getIndices().iterator();
                while (iterator2.hasNext()) {
                    int g;
                    SqliteModIndex index2;
                    if (i2 == 0 == !(index2 = (SqliteModIndex)iterator2.next()).getName().startsWith("sqlite_autoindex_") || (g = this.indexGrade(cols, index2.getColNames())) <= grade) continue;
                    grade = g;
                    res = index2;
                }
            }
            return res;
        }

        private SqliteModForeignKey findFk(Family<? extends SqliteModForeignKey> fks, @Nullable String refTable, @NotNull List<String> cols, @NotNull List<String> refCols, @NotNull CascadeRule onDelete, @NotNull CascadeRule onUpdate, @NotNull Set<SqliteModForeignKey> ignore, boolean full) {
            if (cols == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(10);
            }
            if (refCols == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(11);
            }
            if (onDelete == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(12);
            }
            if (onUpdate == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(13);
            }
            if (ignore == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(14);
            }
            return fks.find(fk -> {
                if (ignore == null) {
                    SqliteSchemaRetriever.$$$reportNull$$$0(30);
                }
                if (cols == null) {
                    SqliteSchemaRetriever.$$$reportNull$$$0(31);
                }
                if (refCols == null) {
                    SqliteSchemaRetriever.$$$reportNull$$$0(32);
                }
                if (onDelete == null) {
                    SqliteSchemaRetriever.$$$reportNull$$$0(33);
                }
                if (onUpdate == null) {
                    SqliteSchemaRetriever.$$$reportNull$$$0(34);
                }
                if (ignore.contains(fk)) {
                    return false;
                }
                return this.fkMatches((SqliteModForeignKey)fk, refTable, cols, refCols, onDelete, onUpdate, full);
            });
        }

        private boolean fkMatches(SqliteModForeignKey fk, @Nullable String refTable, @NotNull List<String> cols, @NotNull List<String> refCols, @NotNull CascadeRule onDelete, @NotNull CascadeRule onUpdate, boolean full) {
            if (cols == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(15);
            }
            if (refCols == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(16);
            }
            if (onDelete == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(17);
            }
            if (onUpdate == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(18);
            }
            if (!Comparing.strEqual((String)fk.getRefTableName(), (String)refTable, (boolean)false)) {
                return false;
            }
            if (!this.equalInsensitive(fk.getColNames(), cols)) {
                return false;
            }
            if (!this.equalInsensitive(fk.getRefColNames(), refCols)) {
                return false;
            }
            if (full && !Comparing.equal((Object)((Object)fk.getOnDelete()), (Object)((Object)onDelete))) {
                return false;
            }
            return !full || Comparing.equal((Object)((Object)fk.getOnUpdate()), (Object)((Object)onUpdate));
        }

        private boolean keyMatches(SqliteModKey key2, @NotNull List<String> cols, boolean primary2) {
            if (cols == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(19);
            }
            if (!this.equalInsensitive(key2.getColNames(), cols)) {
                return false;
            }
            return primary2 != key2.isPrimary();
        }

        private boolean equalInsensitive(@NotNull List<String> a, @NotNull List<String> b) {
            if (a == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(20);
            }
            if (b == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(21);
            }
            if (a.size() != b.size()) {
                return false;
            }
            for (int i2 = 0; i2 < a.size(); ++i2) {
                if (Comparing.strEqual((String)a.get(i2), (String)b.get(i2), (boolean)false)) continue;
                return false;
            }
            return true;
        }

        private int indexGrade(@NotNull List<String> keyCol, @NotNull List<String> idxCol) {
            if (keyCol == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(22);
            }
            if (idxCol == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(23);
            }
            if (keyCol.size() > idxCol.size()) {
                return 0;
            }
            for (int i2 = 0; i2 < keyCol.size(); ++i2) {
                if (Comparing.strEqual((String)keyCol.get(i2), (String)idxCol.get(i2), (boolean)false)) continue;
                return i2;
            }
            return keyCol.size();
        }

        private CascadeRule toCascadeRule(String rule) {
            if (rule == null || rule.equalsIgnoreCase("no action")) {
                return CascadeRule.no_action;
            }
            if (rule.equalsIgnoreCase("restrict")) {
                return CascadeRule.restrict;
            }
            if (rule.equalsIgnoreCase("set null")) {
                return CascadeRule.set_null;
            }
            if (rule.equalsIgnoreCase("set default")) {
                return CascadeRule.set_default;
            }
            if (rule.equalsIgnoreCase("cascade")) {
                return CascadeRule.cascade;
            }
            return CascadeRule.no_action;
        }

        @NotNull
        private CascadeRule toCascadeRule(@Nullable DasForeignKey.RuleAction rule) {
            if (rule == null) {
                CascadeRule cascadeRule = CascadeRule.no_action;
                if (cascadeRule == null) {
                    SqliteSchemaRetriever.$$$reportNull$$$0(24);
                }
                return cascadeRule;
            }
            switch (rule) {
                case RESTRICT: {
                    CascadeRule cascadeRule = CascadeRule.restrict;
                    if (cascadeRule == null) {
                        SqliteSchemaRetriever.$$$reportNull$$$0(25);
                    }
                    return cascadeRule;
                }
                case SET_NULL: {
                    CascadeRule cascadeRule = CascadeRule.set_null;
                    if (cascadeRule == null) {
                        SqliteSchemaRetriever.$$$reportNull$$$0(26);
                    }
                    return cascadeRule;
                }
                case SET_DEFAULT: {
                    CascadeRule cascadeRule = CascadeRule.set_default;
                    if (cascadeRule == null) {
                        SqliteSchemaRetriever.$$$reportNull$$$0(27);
                    }
                    return cascadeRule;
                }
                case CASCADE: {
                    CascadeRule cascadeRule = CascadeRule.cascade;
                    if (cascadeRule == null) {
                        SqliteSchemaRetriever.$$$reportNull$$$0(28);
                    }
                    return cascadeRule;
                }
            }
            CascadeRule cascadeRule = CascadeRule.no_action;
            if (cascadeRule == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(29);
            }
            return cascadeRule;
        }

        private /* synthetic */ boolean lambda$retrieveForeignKeys$8(@NotNull SqliteModTable table, ModNamingFamily foreignKeys, Set visited, List list) {
            if (table == null) {
                SqliteSchemaRetriever.$$$reportNull$$$0(35);
            }
            list.sort((o1, o2) -> Comparing.compare((Comparable)o1.seq, (Comparable)o2.seq));
            ArrayList from = ContainerUtil.newArrayListWithCapacity((int)list.size());
            ArrayList to = ContainerUtil.newArrayListWithCapacity((int)list.size());
            boolean onlyNulls = true;
            for (SqliteIntroQueries.ForeignKeyInfo aList : list) {
                onlyNulls &= aList.to == null;
                from.add(StringUtil.notNullize((String)aList.from));
                to.add(StringUtil.notNullize((String)aList.to));
            }
            if (onlyNulls) {
                to.clear();
            }
            SqliteIntroQueries.ForeignKeyInfo foreignKeyInfo = (SqliteIntroQueries.ForeignKeyInfo)list.get(0);
            CascadeRule onDelete = this.toCascadeRule(foreignKeyInfo.on_delete);
            CascadeRule onUpdate = this.toCascadeRule(foreignKeyInfo.on_update);
            String fixedRefName = SqliteIntrospector.fixName(foreignKeyInfo.table, table.getParentFamily());
            SqliteModForeignKey foreignKey = this.findFk(foreignKeys, fixedRefName, from, to, onDelete, onUpdate, visited, true);
            if (foreignKey == null) {
                foreignKey = (SqliteModForeignKey)foreignKeys.createNewOne();
                foreignKey.setRefTableName(fixedRefName);
                foreignKey.setColNames(from);
                foreignKey.setRefColNames(to);
                foreignKey.setOnDelete(onDelete);
                foreignKey.setOnUpdate(onUpdate);
            } else {
                foreignKey.resetSyncPending();
            }
            visited.add(foreignKey);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument %s for @NotNull parameter of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "0";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "transaction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "schema";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 35: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "index";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 10: 
                case 15: 
                case 19: 
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cols";
                    break;
                }
                case 11: 
                case 16: 
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refCols";
                    break;
                }
                case 12: 
                case 17: 
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onDelete";
                    break;
                }
                case 13: 
                case 18: 
                case 34: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "onUpdate";
                    break;
                }
                case 14: 
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ignore";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "a";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "b";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyCol";
                    break;
                }
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "idxCol";
                    break;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/introspection/SqliteIntrospector$SqliteSchemaRetriever";
                    break;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toCascadeRule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "retrieveIndicesAndForeignKeys";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "retrieveIndexColumns";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "retrieveIndices";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "retrieveForeignKeys";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "retrieveColumns";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "fillTrigger";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getStatement";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "findFk";
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "fkMatches";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "keyMatches";
                    break;
                }
                case 20: 
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "equalInsensitive";
                    break;
                }
                case 22: 
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "indexGrade";
                    break;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    break;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$findFk$17";
                    break;
                }
                case 35: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$retrieveForeignKeys$8";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

