/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.BaseIntrospectionFunctions;
import com.intellij.database.introspection.BaseMultiDatabaseIntrospector;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.sybase.SybaseDatabase;
import com.intellij.database.model.sybase.SybaseModArgument;
import com.intellij.database.model.sybase.SybaseModForeignKey;
import com.intellij.database.model.sybase.SybaseModLikeTable;
import com.intellij.database.model.sybase.SybaseModMajorObject;
import com.intellij.database.model.sybase.SybaseModSchema;
import com.intellij.database.model.sybase.SybaseModTable;
import com.intellij.database.model.sybase.SybaseModTableColumn;
import com.intellij.database.model.sybase.SybaseModTrigger;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.util.Version;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u00aa\u0001\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0017\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a\u0010\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0002\u001a\u001a\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u00022\u0006\u0010&\u001a\u00020\u0003H\u0002\u001a\u0018\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u0003H\u0002\u001a\u001e\u0010*\u001a\u0004\u0018\u00010\u00022\b\u0010+\u001a\u0004\u0018\u00010\u00022\b\u0010,\u001a\u0004\u0018\u00010\u0002H\u0002\u001a:\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010\u00022\u0006\u0010)\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020$2\u0006\u00103\u001a\u000204H\u0002\u001a\u0018\u00105\u001a\u00020\u00062\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u0003H\u0000\u001a\u0016\u00109\u001a\u00020\u001b*\u00020:2\b\u0010;\u001a\u0004\u0018\u00010<H\u0002\u001a\u001c\u0010=\u001a\u00020>*\n\u0012\u0006\b\u0001\u0012\u00020>0?2\u0006\u0010%\u001a\u00020\u0002H\u0002\u001a\u0016\u0010@\u001a\u0004\u0018\u00010\u001d*\u00020A2\u0006\u0010B\u001a\u00020\u0003H\u0002\u001a\u0016\u0010C\u001a\u0004\u0018\u00010D*\u00020A2\u0006\u0010B\u001a\u00020\u0003H\u0002\u001a\u001e\u0010E\u001a\u0004\u0018\u00010F*\u00020A2\u0006\u0010G\u001a\u00020H2\u0006\u0010&\u001a\u00020\u0003H\u0002\u001a\u0014\u0010I\u001a\u00020\u001b*\n\u0012\u0006\b\u0001\u0012\u00020J0?H\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0017\u001a\u00070\u0018\u00a2\u0006\u0002\b\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"CHARACTER_TYPES", "", "", "", "CHARACTER_TYPES_16", "COLUMN_BITS1_IDENTITY", "", "COLUMN_BITS1_NULLABLE", "COLUMN_BITS2_COMPUTED", "COLUMN_BITS2_OUTPUT", "EXACT_LENGTH_TYPES", "", "INDEX_BITS1_CLUSTERED", "INDEX_BITS1_PRIMARY", "INDEX_BITS1_UNIQUE", "INDEX_BITS2_KEY", "INDEX_BITS2_NAME_SURROGATE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "SYBASE_INTERNAL_REMARK_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "TYPE_SUBSTITUTION", "ourSybaseIdentity", "Lcom/intellij/database/model/SequenceIdentity;", "Lorg/jetbrains/annotations/NotNull;", "assignForeignKeyColumns", "", "foreignKey", "Lcom/intellij/database/model/sybase/SybaseModForeignKey;", "columnPositions", "", "catalogPrefix", "database", "Lcom/intellij/database/model/sybase/SybaseDatabase;", "detectSurrogateName", "", "name", "id", "fixFloatPrecision", "type_name", "length", "joinSourceTextParts", "text1", "text2", "makeDataType", "Lcom/intellij/database/model/DataType;", "typeName", "precision", "scale", "variable", "ver", "Lorg/jetbrains/dekaf/util/Version;", "peek16", "array", "", "offset", "addEvent", "Lcom/intellij/database/model/sybase/SybaseModTrigger;", "event", "Lcom/intellij/database/model/TrigEvent;", "createOrGetByName", "Lcom/intellij/database/model/sybase/SybaseModArgument;", "Lcom/intellij/database/model/families/ModFamily;", "findForeignKeyById", "Lcom/intellij/database/model/sybase/SybaseModSchema;", "objectId", "findObjectById", "Lcom/intellij/database/model/sybase/SybaseModMajorObject;", "findTableOrView", "Lcom/intellij/database/model/sybase/SybaseModLikeTable;", "code", "", "finish", "Lcom/intellij/database/model/basic/BasicModElement;", "intellij.database.introspection"})
public final class SybaseIntrospectorKt {
    private static final Logger LOG = Logger.getInstance(BaseMultiDatabaseIntrospector.class);
    private static final short COLUMN_BITS1_IDENTITY = 128;
    private static final short COLUMN_BITS1_NULLABLE = 8;
    private static final short COLUMN_BITS2_COMPUTED = 16;
    private static final short COLUMN_BITS2_OUTPUT = 2;
    private static final short INDEX_BITS1_PRIMARY = 2048;
    private static final short INDEX_BITS1_CLUSTERED = 16;
    private static final short INDEX_BITS1_UNIQUE = 2;
    private static final short INDEX_BITS2_NAME_SURROGATE = 8;
    private static final short INDEX_BITS2_KEY = 2;
    private static final Set<String> EXACT_LENGTH_TYPES = SetsKt.setOf((Object[])new String[]{"char", "nchar", "unichar", "varchar", "nvarchar", "univarchar", "binary", "float", "numeric", "decimal"});
    private static final Map<String, Integer> CHARACTER_TYPES = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"char", (Object)1), TuplesKt.to((Object)"varchar", (Object)1), TuplesKt.to((Object)"unichar", (Object)2), TuplesKt.to((Object)"univarchar", (Object)2), TuplesKt.to((Object)"nchar", (Object)3), TuplesKt.to((Object)"nvarchar", (Object)3), TuplesKt.to((Object)"sysname", (Object)1), TuplesKt.to((Object)"longsysname", (Object)1)});
    private static final Map<String, Integer> CHARACTER_TYPES_16 = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"unichar", (Object)2), TuplesKt.to((Object)"univarchar", (Object)2)});
    private static final Map<String, String> TYPE_SUBSTITUTION = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"usmallint", (Object)"unsigned smallint"), TuplesKt.to((Object)"uint", (Object)"unsigned int"), TuplesKt.to((Object)"ubigint", (Object)"unsigned bigint")});
    private static final SequenceIdentity ourSybaseIdentity = SequenceIdentity.of(1L, null, 1L, null);
    private static final Pattern SYBASE_INTERNAL_REMARK_PATTERN = Pattern.compile("^/\\*[^/]+?\\*/\\s*$");

    private static final String catalogPrefix(SybaseDatabase database) {
        String string;
        if (database.isCurrent()) {
            string = "dbo";
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            char c = '[';
            String string2 = database.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"database.name");
            String string3 = string2;
            StringBuilder stringBuilder2 = stringBuilder;
            String string4 = String.valueOf(c) + string3;
            string = stringBuilder2.append(string4).append("].dbo").toString();
        }
        return string;
    }

    private static final boolean detectSurrogateName(String name, int id) {
        if (name == null) {
            return false;
        }
        char c = '_';
        String string = Integer.toString(id);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Integer.toString(id)");
        String string2 = string;
        String idStr = String.valueOf(c) + string2;
        return name.length() > idStr.length() && StringsKt.endsWith$default((String)name, (String)idStr, (boolean)false, (int)2, null);
    }

    private static final int fixFloatPrecision(String type_name, int length) {
        if (Intrinsics.areEqual((Object)"float", (Object)type_name)) {
            if (length == 8) {
                return 22;
            }
            if (length == 4) {
                return 15;
            }
        }
        return length;
    }

    private static final DataType makeDataType(String typeName, int length, short precision, short scale, boolean variable, Version ver) {
        DataType dataType;
        LengthUnit u;
        short s;
        int p;
        Map<String, Integer> charTypes;
        if (typeName == null) {
            DataType dataType2 = DataType.UNKNOWN;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType2, (String)"DataType.UNKNOWN");
            return dataType2;
        }
        boolean exactLength = EXACT_LENGTH_TYPES.contains(typeName);
        Map<String, Integer> map = charTypes = ver.isOrGreater(new int[]{16}) ? CHARACTER_TYPES_16 : CHARACTER_TYPES;
        if (length == 0 && precision == 0 || !variable && !exactLength) {
            p = -1;
            s = 0;
            LengthUnit lengthUnit = LengthUnit.NONE;
            Intrinsics.checkExpressionValueIsNotNull((Object)lengthUnit, (String)"LengthUnit.NONE");
            u = lengthUnit;
        } else if (precision > 0) {
            p = precision;
            s = scale;
            LengthUnit lengthUnit = LengthUnit.DIGIT;
            Intrinsics.checkExpressionValueIsNotNull((Object)lengthUnit, (String)"LengthUnit.DIGIT");
            u = lengthUnit;
        } else if (exactLength) {
            s = 0;
            Integer lenFix = charTypes.get(typeName);
            if (lenFix != null) {
                p = length / lenFix;
                LengthUnit lengthUnit = LengthUnit.CHAR;
                Intrinsics.checkExpressionValueIsNotNull((Object)lengthUnit, (String)"LengthUnit.CHAR");
                u = lengthUnit;
            } else {
                LengthUnit lengthUnit;
                p = SybaseIntrospectorKt.fixFloatPrecision(typeName, length);
                if (length > 0) {
                    LengthUnit lengthUnit2 = LengthUnit.BYTE;
                    lengthUnit = lengthUnit2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)lengthUnit2, (String)"LengthUnit.BYTE");
                } else {
                    LengthUnit lengthUnit3 = LengthUnit.NONE;
                    lengthUnit = lengthUnit3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)lengthUnit3, (String)"LengthUnit.NONE");
                }
                u = lengthUnit;
            }
        } else {
            p = -1;
            s = 0;
            LengthUnit lengthUnit = LengthUnit.NONE;
            Intrinsics.checkExpressionValueIsNotNull((Object)lengthUnit, (String)"LengthUnit.NONE");
            u = lengthUnit;
        }
        try {
            String string = TYPE_SUBSTITUTION.get(typeName);
            if (string == null) {
                string = typeName;
            }
            DataType dataType3 = DataTypeFactory.of(null, string, p, s, u, null, false, false);
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType3, (String)"DataTypeFactory.of(null,\u2026s, u, null, false, false)");
            dataType = dataType3;
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = e.getClass().getName();
            }
            String exceptionMessage = string;
            LOG.warn("Failed to handle data type " + typeName + " with length " + length + " precision " + precision + " scale " + scale + ": " + exceptionMessage);
            DataType dataType4 = DataType.UNKNOWN;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType4, (String)"DataType.UNKNOWN");
            dataType = dataType4;
        }
        DataType dt = dataType;
        return dt;
    }

    /*
     * WARNING - void declaration
     */
    public static final short peek16(@NotNull byte[] array, int offset) {
        void that$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)array, (String)"array");
        byte b1 = array[offset];
        byte b2 = array[offset + 1];
        byte by = b1;
        int n = 255;
        int n2 = (b2 & 0xFF) << 8;
        void $receiver$iv$iv = $receiver$iv;
        byte by2 = (byte)(Byte.toUnsignedInt((byte)$receiver$iv$iv) & that$iv);
        return (short)(n2 | by2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void assignForeignKeyColumns(SybaseModForeignKey foreignKey, short[] columnPositions) {
        SybaseModTable table = foreignKey.getTable();
        int n = columnPositions.length;
        ArrayList<Object> names = new ArrayList<Object>(n);
        int n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            void i2;
            SybaseModTable sybaseModTable = table;
            Intrinsics.checkExpressionValueIsNotNull((Object)sybaseModTable, (String)"table");
            SybaseModTableColumn column2 = (SybaseModTableColumn)sybaseModTable.getColumns().getByNaturalPosition(columnPositions[i2]);
            Object object = column2;
            if (object == null || (object = object.getRealName()) == null) {
            } else {
                Object name = object;
                names.add(name);
            }
            ++i2;
        }
        foreignKey.setColNames((List<String>)names);
    }

    private static final SybaseModMajorObject findObjectById(@NotNull SybaseModSchema $receiver, int objectId) {
        SybaseModMajorObject sybaseModMajorObject;
        SybaseModMajorObject sybaseModMajorObject2;
        SybaseModMajorObject sybaseModMajorObject3 = (SybaseModMajorObject)$receiver.getTables().getByObjectId(objectId);
        if (sybaseModMajorObject3 == null) {
            sybaseModMajorObject3 = sybaseModMajorObject2 = (SybaseModMajorObject)$receiver.getViews().getByObjectId(objectId);
        }
        if (sybaseModMajorObject3 == null) {
            sybaseModMajorObject2 = sybaseModMajorObject = (SybaseModMajorObject)$receiver.getFunctions().getByObjectId(objectId);
        }
        if (sybaseModMajorObject2 == null) {
            sybaseModMajorObject = (SybaseModMajorObject)$receiver.getProcedureGroups().getByObjectId(objectId);
        }
        return sybaseModMajorObject;
    }

    private static final SybaseModForeignKey findForeignKeyById(@NotNull SybaseModSchema $receiver, int objectId) {
        long id = objectId;
        Iterator iterator2 = $receiver.getTables().iterator();
        while (iterator2.hasNext()) {
            SybaseModTable table;
            SybaseModTable sybaseModTable = table = (SybaseModTable)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)sybaseModTable, (String)"table");
            Iterator iterator3 = sybaseModTable.getForeignKeys().iterator();
            while (iterator3.hasNext()) {
                SybaseModForeignKey fk;
                SybaseModForeignKey sybaseModForeignKey = fk = (SybaseModForeignKey)iterator3.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)sybaseModForeignKey, (String)"fk");
                if (sybaseModForeignKey.getObjectId() != id) continue;
                return fk;
            }
        }
        return null;
    }

    private static final SybaseModArgument createOrGetByName(@NotNull ModFamily<? extends SybaseModArgument> $receiver, String name) {
        Object v1;
        block3: {
            Iterable $receiver$iv = $receiver;
            for (Object element$iv : $receiver$iv) {
                SybaseModArgument it;
                SybaseModArgument sybaseModArgument = it = (SybaseModArgument)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)sybaseModArgument, (String)"it");
                if (!Intrinsics.areEqual((Object)sybaseModArgument.getName(), (Object)name)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        SybaseModArgument a = v1;
        if (a == null) {
            a = $receiver.createNewOne();
            a.setName(name);
        } else {
            a.resetSyncPending();
        }
        return a;
    }

    private static final void finish(@NotNull ModFamily<? extends BasicModElement> $receiver) {
        $receiver.removeSyncPendingChildren();
        $receiver.sort();
    }

    private static final void addEvent(@NotNull SybaseModTrigger $receiver, TrigEvent event) {
        if (event == null) {
            return;
        }
        Set<TrigEvent> events = $receiver.getEvents();
        if (events.isEmpty()) {
            $receiver.setEvents(Collections.singleton(event));
        } else if (!events.contains(event)) {
            Set<TrigEvent> set = events;
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"events");
            $receiver.setEvents(SetsKt.plus(set, (Object)event));
        }
    }

    private static final SybaseModLikeTable findTableOrView(@NotNull SybaseModSchema $receiver, char code, int id) {
        SybaseModLikeTable sybaseModLikeTable;
        switch (code) {
            case 'T': {
                sybaseModLikeTable = (SybaseModLikeTable)$receiver.getTables().getByObjectId(id);
                break;
            }
            case 'V': {
                sybaseModLikeTable = (SybaseModLikeTable)$receiver.getViews().getByObjectId(id);
                break;
            }
            default: {
                sybaseModLikeTable = null;
            }
        }
        return sybaseModLikeTable;
    }

    private static final String joinSourceTextParts(String text1, String text2) {
        String string;
        if (text1 == null) {
            string = text2;
        } else if (text2 == null) {
            string = text1;
        } else {
            CharSequence charSequence = text1;
            Pattern pattern = SYBASE_INTERNAL_REMARK_PATTERN;
            Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"SYBASE_INTERNAL_REMARK_PATTERN");
            string = BaseIntrospectionFunctions.matches(charSequence, pattern) && StringsKt.startsWith$default((String)text2, (String)"CREATE", (boolean)false, (int)2, null) ? text1 + '\n' + text2 : text1 + text2;
        }
        return string;
    }

    @NotNull
    public static final /* synthetic */ String access$catalogPrefix(@NotNull SybaseDatabase database) {
        return SybaseIntrospectorKt.catalogPrefix(database);
    }

    public static final /* synthetic */ void access$finish(@NotNull ModFamily $receiver) {
        SybaseIntrospectorKt.finish($receiver);
    }

    @Nullable
    public static final /* synthetic */ SybaseModMajorObject access$findObjectById(@NotNull SybaseModSchema $receiver, int objectId) {
        return SybaseIntrospectorKt.findObjectById($receiver, objectId);
    }

    @NotNull
    public static final /* synthetic */ DataType access$makeDataType(@Nullable String typeName, int length, short precision, short scale, boolean variable, @NotNull Version ver) {
        return SybaseIntrospectorKt.makeDataType(typeName, length, precision, scale, variable, ver);
    }

    @NotNull
    public static final /* synthetic */ SequenceIdentity access$getOurSybaseIdentity$p() {
        return ourSybaseIdentity;
    }

    @NotNull
    public static final /* synthetic */ SybaseModArgument access$createOrGetByName(@NotNull ModFamily $receiver, @NotNull String name) {
        return SybaseIntrospectorKt.createOrGetByName($receiver, name);
    }

    public static final /* synthetic */ boolean access$detectSurrogateName(@Nullable String name, int id) {
        return SybaseIntrospectorKt.detectSurrogateName(name, id);
    }

    public static final /* synthetic */ void access$assignForeignKeyColumns(@NotNull SybaseModForeignKey foreignKey, @NotNull short[] columnPositions) {
        SybaseIntrospectorKt.assignForeignKeyColumns(foreignKey, columnPositions);
    }

    @Nullable
    public static final /* synthetic */ SybaseModForeignKey access$findForeignKeyById(@NotNull SybaseModSchema $receiver, int objectId) {
        return SybaseIntrospectorKt.findForeignKeyById($receiver, objectId);
    }

    public static final /* synthetic */ void access$addEvent(@NotNull SybaseModTrigger $receiver, @Nullable TrigEvent event) {
        SybaseIntrospectorKt.addEvent($receiver, event);
    }

    @Nullable
    public static final /* synthetic */ String access$joinSourceTextParts(@Nullable String text1, @Nullable String text2) {
        return SybaseIntrospectorKt.joinSourceTextParts(text1, text2);
    }

    @Nullable
    public static final /* synthetic */ SybaseModLikeTable access$findTableOrView(@NotNull SybaseModSchema $receiver, char code, int id) {
        return SybaseIntrospectorKt.findTableOrView($receiver, code, id);
    }
}

