/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection.jdbcMetadataWrappers;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.introspection.jdbcMetadataWrappers.ClosableIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.MetaDataUtil;
import com.intellij.database.introspection.jdbcMetadataWrappers.RoutineArgumentIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.RoutineIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.SchemaLoader;
import com.intellij.database.introspection.jdbcMetadataWrappers.SybaseRoutineArgumentIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.SybaseRoutineIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.TableColumnIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.TableFKeyColumnIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.TableIndexColumnIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.TableIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.TableKeyColumnIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.TableVersionColumnIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.TypeIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.UserDefinedTypeAttributeIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.UserDefinedTypeIt;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseMetaDataWrapper {
    private static final Logger LOG = Logger.getInstance(DatabaseMetaDataWrapper.class);
    private final Connection myConnection;
    private final DatabaseMetaData myMetaData;
    private final DatabaseFamilyId myFamilyId;
    private String myQuote;
    private PairConsumer<String, Throwable> myErrorSink;

    @NotNull
    public DatabaseMetaDataWrapper withErrorSink(PairConsumer<String, Throwable> errorSink2) {
        this.myErrorSink = errorSink2;
        DatabaseMetaDataWrapper databaseMetaDataWrapper = this;
        if (databaseMetaDataWrapper == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(0);
        }
        return databaseMetaDataWrapper;
    }

    @Nullable
    public PairConsumer<String, Throwable> getErrorSink() {
        return this.myErrorSink;
    }

    public void onError(String title, Throwable e) {
        this.myErrorSink.consume((Object)title, (Object)e);
    }

    public Connection getConnection() {
        return this.myConnection;
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = this.myFamilyId;
        if (databaseFamilyId == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(1);
        }
        return databaseFamilyId;
    }

    @NotNull
    public static DatabaseMetaDataWrapper create(@NotNull Connection connection, @NotNull DatabaseMetaData data, @NotNull DatabaseFamilyId familyId) {
        if (connection == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(2);
        }
        if (data == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(3);
        }
        if (familyId == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(4);
        }
        if (familyId.isSybase()) {
            SybaseMetadataWrapper sybaseMetadataWrapper = new SybaseMetadataWrapper(connection, data, familyId);
            if (sybaseMetadataWrapper == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(5);
            }
            return sybaseMetadataWrapper;
        }
        if (familyId.isPostgres()) {
            PostgresMetadataWrapper postgresMetadataWrapper = new PostgresMetadataWrapper(connection, data, familyId);
            if (postgresMetadataWrapper == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(6);
            }
            return postgresMetadataWrapper;
        }
        if (familyId.isOracle()) {
            OracleMetadataWrapper oracleMetadataWrapper = new OracleMetadataWrapper(connection, data, familyId);
            if (oracleMetadataWrapper == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(7);
            }
            return oracleMetadataWrapper;
        }
        DatabaseMetaDataWrapper databaseMetaDataWrapper = new DatabaseMetaDataWrapper(connection, data, familyId);
        if (databaseMetaDataWrapper == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(8);
        }
        return databaseMetaDataWrapper;
    }

    protected DatabaseMetaDataWrapper(@NotNull Connection connection, @NotNull DatabaseMetaData data, @NotNull DatabaseFamilyId familyId) {
        if (connection == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(9);
        }
        if (data == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(10);
        }
        if (familyId == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(11);
        }
        this.myConnection = connection;
        this.myMetaData = data;
        this.myFamilyId = familyId;
    }

    @NotNull
    public ClosableIt<String> databases() throws SQLException {
        ClosableIt<String> res = SchemaLoader.catalogs(this);
        res.map(StringUtil::notNullize);
        ClosableIt<String> closableIt = res;
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(12);
        }
        return closableIt;
    }

    @NotNull
    public ClosableIt<Schema> schemas(@NotNull JBIterable<String> databases) throws SQLException {
        if (databases == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(13);
        }
        final String current = this.myConnection.getCatalog();
        ClosableIt.DelegateIt<Schema, Schema> delegateIt = new ClosableIt.DelegateIt<Schema, Schema>(SchemaLoader.schemas(databases, current, this)){

            @Override
            public void close() {
                try {
                    super.close();
                }
                finally {
                    JdbcUtil.setCatalogSafe((Connection)DatabaseMetaDataWrapper.this.myConnection, (String)current);
                }
            }

            @Override
            protected Schema calcValue(Schema cur) {
                return cur;
            }
        };
        if (delegateIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(14);
        }
        return delegateIt;
    }

    @NotNull
    public ClosableIt<? extends Table> tables(@NotNull Schema schema, @Nullable String namePattern, @Nullable String[] types) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(15);
        }
        ClosableIt<? extends Table> tableIt = this.tablesInner(schema, namePattern, types);
        tableIt.filter(tab -> tab.type == null || !StringUtil.containsIgnoreCase((String)tab.type, (String)"TEMPORARY"));
        ClosableIt<? extends Table> closableIt = tableIt;
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(16);
        }
        return closableIt;
    }

    @NotNull
    public ClosableIt<Routine> routines(@NotNull Schema schema, @Nullable String pkg, @Nullable String namePattern) throws SQLException {
        boolean noCatalog;
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(17);
        }
        String requestCatalog = (noCatalog = StringUtil.isEmpty((String)this.myMetaData.getCatalogTerm())) ? pkg : StringUtil.notNullize((String)schema.database);
        ClosableIt<Routine> closableIt = this.append(this.getProceduresInner(requestCatalog, schema, namePattern, noCatalog), () -> {
            if (schema == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(69);
            }
            return this.getFunctionsInner(requestCatalog, schema, namePattern, noCatalog);
        });
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(18);
        }
        return closableIt;
    }

    @NotNull
    private ClosableIt<Routine> getProceduresInner(String requestCatalog, @NotNull Schema schema, @Nullable String namePattern, boolean noCatalog) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(19);
        }
        ClosableIt closableIt = new RoutineIt(this.myMetaData.getProcedures(requestCatalog, schema.schema, namePattern), this.myFamilyId, schema, noCatalog, true).withErrorSink((PairConsumer)this.myErrorSink);
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(20);
        }
        return closableIt;
    }

    @Nullable
    private ClosableIt<Routine> getFunctionsInner(String requestCatalog, @NotNull Schema schema, @Nullable String namePattern, boolean noCatalog) throws SQLException {
        ResultSet rs;
        block5: {
            if (schema == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(21);
            }
            rs = null;
            try {
                rs = this.myMetaData.getFunctions(requestCatalog, schema.schema, namePattern);
            }
            catch (AbstractMethodError abstractMethodError) {
            }
            catch (SQLException e) {
                if (this.isUnimplemented(e)) break block5;
                throw e;
            }
        }
        if (rs == null) {
            return null;
        }
        return new RoutineIt(rs, this.myFamilyId, schema, noCatalog, false).withErrorSink((PairConsumer)this.myErrorSink);
    }

    protected <T> ClosableIt<T> append(ClosableIt<T> head, ThrowableComputable<ClosableIt<T>, SQLException> ... tail) {
        ClosableIt<T> res = head;
        for (ThrowableComputable<ClosableIt<T>, SQLException> fac : tail) {
            if (fac == null) continue;
            res = ClosableIt.lazyAppend(res, this.handleExceptions(fac));
        }
        return res;
    }

    private <T> Factory<T> handleExceptions(ThrowableComputable<T, SQLException> fac) {
        return () -> {
            try {
                return fac.compute();
            }
            catch (SQLException e) {
                this.onError(null, e);
                return null;
            }
        };
    }

    @NotNull
    public ClosableIt.GroupingIt<TableKey, TableKeyColumn> tableKeys(@NotNull Table table) throws SQLException {
        if (table == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(22);
        }
        TableKeyColumnIt.Grouping grouping = new TableKeyColumnIt.Grouping(new TableKeyColumnIt(this.myMetaData.getPrimaryKeys(table.schema.database, table.schema.schema, table.name), table).withErrorSink((PairConsumer)this.myErrorSink));
        if (grouping == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(23);
        }
        return grouping;
    }

    @NotNull
    public ClosableIt.GroupingIt<Table, TableColumn> tableColumns(@NotNull Schema schema, @Nullable String namePattern, @Nullable Iterable<String> expectedTables) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(24);
        }
        TableColumnIt.Grouping grouping = new TableColumnIt.Grouping(this.getTableColumnsInner(schema, namePattern, expectedTables));
        if (grouping == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(25);
        }
        return grouping;
    }

    @NotNull
    protected ClosableIt<TableColumn> getTableColumnsInner(final @NotNull Schema schema, @Nullable String namePattern, final @Nullable Iterable<String> expectedTables) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(26);
        }
        if (namePattern != null || expectedTables == null) {
            assert (expectedTables == null);
            ClosableIt<TableColumn> closableIt = this.getTableColumnsInner2(schema, namePattern);
            if (closableIt == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(27);
            }
            return closableIt;
        }
        ClosableIt<TableColumn> it = null;
        try {
            it = this.getTableColumnsInner2(schema, null);
        }
        catch (SQLException e) {
            LOG.debug((Throwable)e);
        }
        ClosableIt.LazyAppendableClosableIt<TableColumn> lazyAppendableClosableIt = new ClosableIt.LazyAppendableClosableIt<TableColumn>(it){
            private Iterator<String> myTableIt;
            private String myCurrentTable;
            private boolean myExpectedMode;
            {
                super(init);
                this.myTableIt = expectedTables.iterator();
                this.myCurrentTable = null;
            }

            protected void currentChanged() {
                if (this.myTableIt != null && !this.myExpectedMode) {
                    String name;
                    TableColumn current = (TableColumn)this.current();
                    String string = name = current == null ? null : current.table.name;
                    if (!Comparing.equal((String)this.myCurrentTable, (String)name)) {
                        if (this.myCurrentTable == null) {
                            this.myCurrentTable = name;
                        } else {
                            this.myTableIt = null;
                            this.myCurrentTable = null;
                        }
                    }
                }
            }

            @Override
            @Nullable
            protected ClosableIt<? extends TableColumn> nextIt() {
                if (this.myTableIt != null) {
                    this.myExpectedMode = true;
                    while (this.myTableIt.hasNext()) {
                        String table = this.myTableIt.next();
                        if (Comparing.equal((String)table, (String)this.myCurrentTable)) continue;
                        try {
                            return DatabaseMetaDataWrapper.this.getTableColumnsInner2(schema, table);
                        }
                        catch (SQLException e) {
                            DatabaseMetaDataWrapper.this.onError("failed to retrieve columns for " + table, e);
                        }
                    }
                }
                return null;
            }
        };
        if (lazyAppendableClosableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(28);
        }
        return lazyAppendableClosableIt;
    }

    @NotNull
    private ClosableIt<TableColumn> getTableColumnsInner2(@NotNull Schema schema, @Nullable String namePattern) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(29);
        }
        ClosableIt closableIt = new TableColumnIt(this.myMetaData.getColumns(StringUtil.notNullize((String)schema.database), schema.schema, StringUtil.notNullize((String)namePattern, (String)"%"), "%"), this.myFamilyId, schema).withErrorSink((PairConsumer)this.myErrorSink);
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(30);
        }
        return closableIt;
    }

    @NotNull
    public ClosableIt.GroupingIt<Routine, RoutineArgument> routineArguments(@NotNull Schema schema, @Nullable String namePattern, @NotNull Function<Routine, DasRoutine.Kind> kindProvider) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(31);
        }
        if (kindProvider == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(32);
        }
        RoutineArgumentIt.Grouping grouping = new RoutineArgumentIt.Grouping(this.routineArgumentsInner(schema, namePattern, kindProvider));
        if (grouping == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(33);
        }
        return grouping;
    }

    @NotNull
    public ClosableIt<RoutineArgument> routineArgumentsInner(@NotNull Schema schema, @Nullable String namePattern, @NotNull Function<Routine, DasRoutine.Kind> kindProvider) throws SQLException {
        boolean noCatalog;
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(34);
        }
        if (kindProvider == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(35);
        }
        String requestCatalog = (noCatalog = StringUtil.isEmpty((String)this.myMetaData.getCatalogTerm())) ? schema.database : StringUtil.notNullize((String)schema.database);
        ClosableIt<RoutineArgument> closableIt = this.append(this.getProcedureArgumentsInner(requestCatalog, schema, namePattern, kindProvider, noCatalog), () -> {
            if (schema == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(67);
            }
            if (kindProvider == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(68);
            }
            return this.getFunctionArgumentsInner(requestCatalog, schema, namePattern, kindProvider, noCatalog);
        });
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(36);
        }
        return closableIt;
    }

    @NotNull
    private ClosableIt<RoutineArgument> getProcedureArgumentsInner(String requestCatalog, @NotNull Schema schema, @Nullable String namePattern, @NotNull Function<Routine, DasRoutine.Kind> kindProvider, boolean noCatalog) throws SQLException {
        ResultSet wrapper;
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(37);
        }
        if (kindProvider == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(38);
        }
        if ((wrapper = this.getRoutineArgumentsWrapper(new Schema(schema.schema, requestCatalog), namePattern)) == null) {
            ClosableIt<RoutineArgument> closableIt = ClosableIt.empty();
            if (closableIt == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(39);
            }
            return closableIt;
        }
        ClosableIt closableIt = new RoutineArgumentIt(wrapper, this.myFamilyId, schema, noCatalog, kindProvider, true).withErrorSink((PairConsumer)this.myErrorSink);
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(40);
        }
        return closableIt;
    }

    @Nullable
    private ClosableIt<RoutineArgument> getFunctionArgumentsInner(String requestCatalog, @NotNull Schema schema, @Nullable String namePattern, @NotNull Function<Routine, DasRoutine.Kind> kindProvider, boolean noCatalog) throws SQLException {
        ResultSet rs;
        block7: {
            if (schema == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(41);
            }
            if (kindProvider == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(42);
            }
            rs = null;
            try {
                rs = this.myMetaData.getFunctionColumns(requestCatalog, schema.schema, namePattern, null);
            }
            catch (AssertionError assertionError) {
            }
            catch (AbstractMethodError abstractMethodError) {
            }
            catch (SQLException e) {
                if (this.isUnimplemented(e)) break block7;
                throw e;
            }
        }
        if (rs == null) {
            return null;
        }
        return new RoutineArgumentIt(rs, this.myFamilyId, schema, noCatalog, kindProvider, false).withErrorSink((PairConsumer)this.myErrorSink);
    }

    private boolean isUnimplemented(SQLException e) {
        String message = e.getMessage();
        if (this.myFamilyId.isSqlite() && e.getMessage() == null && e.getCause() == null) {
            return true;
        }
        return message != null && (StringUtil.containsIgnoreCase((String)message, (String)"implemented") || StringUtil.containsIgnoreCase((String)message, (String)"unsupported") || StringUtil.containsIgnoreCase((String)message, (String)"not supported"));
    }

    @NotNull
    public ClosableIt.GroupingIt<TableFKey, TableFKeyColumn> tableFKeyColumns(@NotNull Table table) throws SQLException {
        if (table == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(43);
        }
        TableFKeyColumnIt.Grouping grouping = new TableFKeyColumnIt.Grouping(new TableFKeyColumnIt(this.myMetaData.getImportedKeys(table.schema.database, table.schema.schema, table.name), table).withErrorSink((PairConsumer)this.myErrorSink));
        if (grouping == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(44);
        }
        return grouping;
    }

    @NotNull
    public ClosableIt.GroupingIt<TableIndex, TableIndexColumn> tableIndexColumns(@NotNull Table table) throws SQLException {
        if (table == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(45);
        }
        TableIndexColumnIt.Grouping grouping = new TableIndexColumnIt.Grouping(new TableIndexColumnIt(this.getTableIndexColumnsWrapper(table), table).withErrorSink((PairConsumer)this.myErrorSink));
        if (grouping == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(46);
        }
        return grouping;
    }

    @NotNull
    public ClosableIt<TableColumn> tableVersionColumns(@NotNull Table table) throws SQLException {
        if (table == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(47);
        }
        ClosableIt closableIt = new TableVersionColumnIt(this.myMetaData.getVersionColumns(table.schema.database, table.schema.schema, table.name), table).withErrorSink((PairConsumer)this.myErrorSink);
        if (closableIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(48);
        }
        return closableIt;
    }

    @Nullable
    private ResultSet getRoutineArgumentsWrapper(@NotNull Schema schema, @Nullable String namePattern) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(49);
        }
        try {
            return this.myMetaData.getProcedureColumns(schema.database, schema.schema, StringUtil.notNullize((String)namePattern, (String)"%"), null);
        }
        catch (AssertionError e) {
            return null;
        }
        catch (NullPointerException e) {
            if (this.myFamilyId.isSqlite()) {
                LOG.debug((Throwable)e);
                return null;
            }
            throw e;
        }
        catch (SQLException e) {
            return this.myMetaData.getProcedureColumns(schema.database, schema.schema, "%", null);
        }
    }

    private ResultSet getTableIndexColumnsWrapper(@NotNull Table table) throws SQLException {
        if (table == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(50);
        }
        try {
            return this.myMetaData.getIndexInfo(table.schema.database, table.schema.schema, table.name, false, true);
        }
        catch (SQLException ex) {
            try {
                String q = this.getQuote();
                return this.myMetaData.getIndexInfo(q + table.schema.database + q, q + table.schema.schema + q, q + table.name + q, false, true);
            }
            catch (SQLException ex2) {
                throw ex;
            }
        }
    }

    public String getQuote() {
        if (this.myQuote == null) {
            try {
                this.myQuote = this.myMetaData.getIdentifierQuoteString();
            }
            catch (SQLException e) {
                this.myQuote = "\"";
                this.onError(null, e);
            }
        }
        return this.myQuote;
    }

    public String[] getAllTableTypes() throws SQLException {
        HashSet tableTypes = ContainerUtil.newHashSet();
        for (String type : JdbcUtil.resultSetToListSafe((ResultSet)this.myMetaData.getTableTypes(), (String)"TABLE_TYPE", this.myErrorSink)) {
            tableTypes.add(StringUtil.notNullize((String)type).trim());
        }
        return tableTypes.isEmpty() ? null : ArrayUtil.toStringArray((Collection)tableTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected ClosableIt<? extends Table> tablesInner(@NotNull Schema schema, @Nullable String namePattern, @Nullable String[] types) throws SQLException {
        boolean hasNext;
        MetaDataUtil.ResultSetWrapper rs;
        block10: {
            if (schema == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(51);
            }
            rs = null;
            try {
                try {
                    rs = MetaDataUtil.ResultSetWrapper.wrap(this.myMetaData.getTables(schema.database, schema.schema, StringUtil.notNullize((String)namePattern, (String)"%"), types));
                    hasNext = rs.next();
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                    ClosableIt closableIt = types == null ? ClosableIt.empty() : this.tablesInner(schema, namePattern, null);
                    MetaDataUtil.ResultSetWrapper.close(rs);
                    ClosableIt closableIt2 = closableIt;
                    if (closableIt2 == null) {
                        DatabaseMetaDataWrapper.$$$reportNull$$$0(52);
                    }
                    return closableIt2;
                }
            }
            catch (Throwable throwable) {
                MetaDataUtil.ResultSetWrapper.close(rs);
                throw throwable;
            }
            if (hasNext || types == null || types.length == 1) break block10;
            ClosableIt<? extends Table> e = this.tablesInner(schema, namePattern, null);
            MetaDataUtil.ResultSetWrapper.close(rs);
            ClosableIt<? extends Table> closableIt = e;
            if (closableIt == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(53);
            }
            return closableIt;
        }
        ClosableIt it = new TableIt(rs, hasNext, schema).withErrorSink((PairConsumer)this.myErrorSink);
        rs = null;
        ClosableIt closableIt = it;
        MetaDataUtil.ResultSetWrapper.close(rs);
        ClosableIt closableIt3 = closableIt;
        if (closableIt3 == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(54);
        }
        return closableIt3;
    }

    @NotNull
    public ClosableIt<? extends UserDefinedType> userDefinedTypes(@NotNull Schema schema, @Nullable String namePattern) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(55);
        }
        UserDefinedTypeIt userDefinedTypeIt = new UserDefinedTypeIt(this.myMetaData.getUDTs(schema.database, schema.schema, StringUtil.notNullize((String)namePattern, (String)"%"), null), schema);
        if (userDefinedTypeIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(56);
        }
        return userDefinedTypeIt;
    }

    @NotNull
    public ClosableIt<? extends Type> types() throws SQLException {
        TypeIt typeIt = new TypeIt(this.myMetaData.getTypeInfo());
        if (typeIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(57);
        }
        return typeIt;
    }

    @NotNull
    public ClosableIt.GroupingIt<UserDefinedType, UserDefinedTypeAttribute> userDefinedTypeAttributes(@NotNull Schema schema, @Nullable String namePattern, @Nullable Set<String> types) throws SQLException {
        if (schema == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(58);
        }
        UserDefinedTypeAttributeIt.Grouping res = new UserDefinedTypeAttributeIt.Grouping(this.userDefinedTypeAttributesInner(schema, namePattern));
        ClosableIt.GroupingIt groupingIt = types != null ? (ClosableIt.GroupingIt)res.filter(t -> types.contains(t.name)) : res;
        if (groupingIt == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(59);
        }
        return groupingIt;
    }

    @NotNull
    protected ClosableIt<UserDefinedTypeAttribute> userDefinedTypeAttributesInner(@NotNull @NotNull @NotNull Schema schema, @Nullable String namePattern) throws SQLException {
        UserDefinedTypeAttributeIt userDefinedTypeAttributeIt;
        block5: {
            if (schema == null) {
                DatabaseMetaDataWrapper.$$$reportNull$$$0(60);
            }
            try {
                userDefinedTypeAttributeIt = new UserDefinedTypeAttributeIt(this.myMetaData.getAttributes(schema.database, schema.schema, "%", StringUtil.notNullize((String)namePattern, (String)"%")), this.myFamilyId, schema);
                if (userDefinedTypeAttributeIt != null) break block5;
            }
            catch (SQLException e) {
                if (this.isUnimplemented(e)) {
                    ClosableIt<UserDefinedTypeAttribute> closableIt = ClosableIt.empty();
                    if (closableIt == null) {
                        DatabaseMetaDataWrapper.$$$reportNull$$$0(62);
                    }
                    return closableIt;
                }
                throw e;
            }
            DatabaseMetaDataWrapper.$$$reportNull$$$0(61);
        }
        return userDefinedTypeAttributeIt;
    }

    @NotNull
    public DatabaseMetaData getMetaData() {
        DatabaseMetaData databaseMetaData = this.myMetaData;
        if (databaseMetaData == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(63);
        }
        return databaseMetaData;
    }

    @Nullable
    public Casing getCasing() {
        try {
            return DatabaseMetaDataWrapper.getCasing(this.myFamilyId, this.myMetaData);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public static Casing getCasing(@NotNull DatabaseFamilyId familyId, @NotNull DatabaseMetaData metaData) throws SQLException {
        if (familyId == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(64);
        }
        if (metaData == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(65);
        }
        boolean supportsMixedCase = metaData.supportsMixedCaseIdentifiers();
        boolean storesUpperCase = metaData.storesUpperCaseIdentifiers();
        boolean storesLowerCase = metaData.storesLowerCaseIdentifiers();
        boolean storesMixedCase = metaData.storesMixedCaseIdentifiers();
        boolean supportsMixedCaseQuoted = metaData.supportsMixedCaseQuotedIdentifiers();
        boolean storesUpperCaseQuoted = metaData.storesUpperCaseQuotedIdentifiers();
        boolean storesLowerCaseQuoted = metaData.storesLowerCaseQuotedIdentifiers();
        boolean storesMixedCaseQuoted = metaData.storesMixedCaseQuotedIdentifiers();
        Case plain = DatabaseMetaDataWrapper.getCaseMode(familyId, supportsMixedCase, storesLowerCase, storesUpperCase, storesMixedCase);
        Case quoted = DatabaseMetaDataWrapper.getCaseMode(familyId, supportsMixedCaseQuoted, storesLowerCaseQuoted, storesUpperCaseQuoted, storesMixedCaseQuoted);
        return Casing.create((Case)plain, (Case)quoted);
    }

    private static Case getCaseMode(@NotNull DatabaseFamilyId familyId, boolean sensitive, boolean forceLower, boolean forceUpper, boolean asIs) {
        if (familyId == null) {
            DatabaseMetaDataWrapper.$$$reportNull$$$0(66);
        }
        if (sensitive && asIs) {
            return familyId.isSqlite() || familyId.isMicrosoft() ? Case.MIXED : Case.EXACT;
        }
        return asIs && familyId.isSybase() || sensitive ? Case.EXACT : (forceLower ? Case.LOWER : (forceUpper ? Case.UPPER : Case.MIXED));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 55: 
            case 58: 
            case 60: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 55: 
            case 58: 
            case 60: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/introspection/jdbcMetadataWrappers/DatabaseMetaDataWrapper";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: 
            case 11: 
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "familyId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databases";
                break;
            }
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 26: 
            case 29: 
            case 31: 
            case 34: 
            case 37: 
            case 41: 
            case 49: 
            case 51: 
            case 55: 
            case 58: 
            case 60: 
            case 67: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 22: 
            case 43: 
            case 45: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 32: 
            case 35: 
            case 38: 
            case 42: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kindProvider";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "withErrorSink";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyId";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 55: 
            case 58: 
            case 60: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/introspection/jdbcMetadataWrappers/DatabaseMetaDataWrapper";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "databases";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "schemas";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "tables";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "routines";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getProceduresInner";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "tableKeys";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "tableColumns";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableColumnsInner";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableColumnsInner2";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "routineArguments";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "routineArgumentsInner";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcedureArgumentsInner";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "tableFKeyColumns";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "tableIndexColumns";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "tableVersionColumns";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "tablesInner";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "userDefinedTypes";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "types";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "userDefinedTypeAttributes";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "userDefinedTypeAttributesInner";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaData";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "schemas";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tables";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "routines";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getProceduresInner";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionsInner";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "tableKeys";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "tableColumns";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getTableColumnsInner";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getTableColumnsInner2";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "routineArguments";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "routineArgumentsInner";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getProcedureArgumentsInner";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionArgumentsInner";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "tableFKeyColumns";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "tableIndexColumns";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "tableVersionColumns";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getRoutineArgumentsWrapper";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getTableIndexColumnsWrapper";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "tablesInner";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "userDefinedTypes";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "userDefinedTypeAttributes";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "userDefinedTypeAttributesInner";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getCasing";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getCaseMode";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "lambda$routineArgumentsInner$3";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "lambda$routines$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 55: 
            case 58: 
            case 60: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OracleMetadataWrapper
    extends DatabaseMetaDataWrapper {
        public static final List<String> BAD_PREFIXES = Arrays.asList("BIN$", "CREATE$", "JAVA$", "DR$", "XDB$", "DRV$", "RUPD$", "MLOG$");

        OracleMetadataWrapper(@NotNull Connection connection, @NotNull DatabaseMetaData data, @NotNull DatabaseFamilyId familyId) {
            if (connection == null) {
                OracleMetadataWrapper.$$$reportNull$$$0(0);
            }
            if (data == null) {
                OracleMetadataWrapper.$$$reportNull$$$0(1);
            }
            if (familyId == null) {
                OracleMetadataWrapper.$$$reportNull$$$0(2);
            }
            super(connection, data, familyId);
        }

        @Override
        @NotNull
        public ClosableIt<? extends Table> tables(@NotNull Schema schema, @Nullable String namePattern, @Nullable String[] types) throws SQLException {
            if (schema == null) {
                OracleMetadataWrapper.$$$reportNull$$$0(3);
            }
            ClosableIt<? extends Table> tableIt = super.tables(schema, namePattern, types);
            tableIt.filter(OracleMetadataWrapper::isValidTable);
            ClosableIt<? extends Table> closableIt = tableIt;
            if (closableIt == null) {
                OracleMetadataWrapper.$$$reportNull$$$0(4);
            }
            return closableIt;
        }

        @Override
        @NotNull
        public ClosableIt<Routine> routines(@NotNull Schema schema, @Nullable String pkg, @Nullable String namePattern) throws SQLException {
            if (schema == null) {
                OracleMetadataWrapper.$$$reportNull$$$0(5);
            }
            ClosableIt<Routine> routineIt = super.routines(schema, pkg, namePattern);
            routineIt.filter(OracleMetadataWrapper::isValidRoutine);
            ClosableIt<Routine> closableIt = routineIt;
            if (closableIt == null) {
                OracleMetadataWrapper.$$$reportNull$$$0(6);
            }
            return closableIt;
        }

        private static boolean startsWithBadPrefix(@Nullable String s) {
            if (s != null) {
                for (String prefix : BAD_PREFIXES) {
                    if (!StringUtil.startsWithIgnoreCase((String)s, (String)prefix)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean isSys(@NotNull Schema schema) {
            if (schema == null) {
                OracleMetadataWrapper.$$$reportNull$$$0(7);
            }
            return Comparing.equal((String)"sys", (String)schema.schema, (boolean)false) || Comparing.equal((String)"sys", (String)schema.schema, (boolean)true);
        }

        private static boolean isValidSysName(@Nullable String s) {
            return s == null || !s.contains("$");
        }

        private static boolean isValidRoutine(@NotNull Routine routine) {
            if (routine == null) {
                OracleMetadataWrapper.$$$reportNull$$$0(8);
            }
            if (OracleMetadataWrapper.isSys(routine.schema)) {
                return OracleMetadataWrapper.isValidSysName(routine.pkg) && OracleMetadataWrapper.isValidSysName(routine.name);
            }
            return !OracleMetadataWrapper.startsWithBadPrefix(routine.pkg) && !OracleMetadataWrapper.startsWithBadPrefix(routine.name);
        }

        private static boolean isValidTable(@NotNull Table table) {
            if (table == null) {
                OracleMetadataWrapper.$$$reportNull$$$0(9);
            }
            if (OracleMetadataWrapper.isSys(table.schema)) {
                return OracleMetadataWrapper.isValidSysName(table.name);
            }
            return !OracleMetadataWrapper.startsWithBadPrefix(table.name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "familyId";
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "schema";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/introspection/jdbcMetadataWrappers/DatabaseMetaDataWrapper$OracleMetadataWrapper";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "routine";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/introspection/jdbcMetadataWrappers/DatabaseMetaDataWrapper$OracleMetadataWrapper";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tables";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "routines";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "tables";
                    break;
                }
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "routines";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isSys";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isValidRoutine";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "isValidTable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SybaseMetadataWrapper
    extends DatabaseMetaDataWrapper {
        SybaseMetadataWrapper(@NotNull Connection connection, @NotNull DatabaseMetaData data, @NotNull DatabaseFamilyId familyId) {
            if (connection == null) {
                SybaseMetadataWrapper.$$$reportNull$$$0(0);
            }
            if (data == null) {
                SybaseMetadataWrapper.$$$reportNull$$$0(1);
            }
            if (familyId == null) {
                SybaseMetadataWrapper.$$$reportNull$$$0(2);
            }
            super(connection, data, familyId);
        }

        @Override
        @NotNull
        public ClosableIt<? extends Table> tables(@NotNull Schema schema, @Nullable String namePattern, @Nullable String[] types) throws SQLException {
            if (schema == null) {
                SybaseMetadataWrapper.$$$reportNull$$$0(3);
            }
            ClosableIt<? extends Table> tableIt = super.tables(schema, namePattern, types);
            tableIt.filter(tab -> SybaseRoutineIt.isSybTableName(tab.name, tab.type));
            ClosableIt<? extends Table> closableIt = tableIt;
            if (closableIt == null) {
                SybaseMetadataWrapper.$$$reportNull$$$0(4);
            }
            return closableIt;
        }

        @Override
        @NotNull
        public ClosableIt<Routine> routines(@NotNull Schema schema, @Nullable String pkg, @Nullable String namePattern) throws SQLException {
            if (schema == null) {
                SybaseMetadataWrapper.$$$reportNull$$$0(5);
            }
            ClosableIt<Routine> routineIt = super.routines(schema, pkg, namePattern);
            ClosableIt<Routine> closableIt = this.append(routineIt, () -> {
                if (schema == null) {
                    SybaseMetadataWrapper.$$$reportNull$$$0(13);
                }
                return this.sybaseTableRoutines(schema, namePattern);
            });
            if (closableIt == null) {
                SybaseMetadataWrapper.$$$reportNull$$$0(6);
            }
            return closableIt;
        }

        @Override
        @NotNull
        public ClosableIt<RoutineArgument> routineArgumentsInner(@NotNull Schema schema, @Nullable String namePattern, @NotNull Function<Routine, DasRoutine.Kind> kindProvider) throws SQLException {
            if (schema == null) {
                SybaseMetadataWrapper.$$$reportNull$$$0(7);
            }
            if (kindProvider == null) {
                SybaseMetadataWrapper.$$$reportNull$$$0(8);
            }
            ClosableIt<RoutineArgument> argumentIt = super.routineArgumentsInner(schema, namePattern, kindProvider);
            ClosableIt<RoutineArgument> closableIt = this.append(argumentIt, () -> {
                if (schema == null) {
                    SybaseMetadataWrapper.$$$reportNull$$$0(12);
                }
                return this.sybaseRoutineArguments(schema, namePattern);
            });
            if (closableIt == null) {
                SybaseMetadataWrapper.$$$reportNull$$$0(9);
            }
            return closableIt;
        }

        @Nullable
        private ClosableIt<Routine> sybaseTableRoutines(@NotNull Schema schema, @Nullable String namePattern) throws SQLException {
            if (schema == null) {
                SybaseMetadataWrapper.$$$reportNull$$$0(10);
            }
            ClosableIt<? extends Table> tables = this.tablesInner(schema, namePattern, new String[]{"SYSTEM TABLE"});
            tables.filter(tab -> !SybaseRoutineIt.isSybTableName(tab.name, tab.type));
            return new SybaseRoutineIt(schema, (Iterator<? extends Table>)((Object)tables));
        }

        @Nullable
        private ClosableIt<RoutineArgument> sybaseRoutineArguments(@NotNull Schema schema, @Nullable String namePattern) throws SQLException {
            if (schema == null) {
                SybaseMetadataWrapper.$$$reportNull$$$0(11);
            }
            return new SybaseRoutineArgumentIt(schema, (Iterator<? extends TableColumn>)((Object)this.getTableColumnsInner(schema, namePattern, null)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 6: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 6: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "familyId";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "schema";
                    break;
                }
                case 4: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/introspection/jdbcMetadataWrappers/DatabaseMetaDataWrapper$SybaseMetadataWrapper";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kindProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/introspection/jdbcMetadataWrappers/DatabaseMetaDataWrapper$SybaseMetadataWrapper";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tables";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "routines";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "routineArgumentsInner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "tables";
                    break;
                }
                case 4: 
                case 6: 
                case 9: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "routines";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "routineArgumentsInner";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "sybaseTableRoutines";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "sybaseRoutineArguments";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$routineArgumentsInner$2";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$routines$1";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 6: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PostgresMetadataWrapper
    extends DatabaseMetaDataWrapper {
        PostgresMetadataWrapper(@NotNull Connection connection, @NotNull DatabaseMetaData data, @NotNull DatabaseFamilyId familyId) {
            if (connection == null) {
                PostgresMetadataWrapper.$$$reportNull$$$0(0);
            }
            if (data == null) {
                PostgresMetadataWrapper.$$$reportNull$$$0(1);
            }
            if (familyId == null) {
                PostgresMetadataWrapper.$$$reportNull$$$0(2);
            }
            super(connection, data, familyId);
        }

        @Override
        @NotNull
        public ClosableIt<? extends Table> tables(@NotNull Schema schema, @Nullable String namePattern, @Nullable String[] types) throws SQLException {
            if (schema == null) {
                PostgresMetadataWrapper.$$$reportNull$$$0(3);
            }
            ClosableIt<? extends Table> tableIt = super.tables(schema, namePattern, types);
            tableIt.filter(tab -> !"INDEX".equals(tab.type));
            ClosableIt<? extends Table> closableIt = tableIt;
            if (closableIt == null) {
                PostgresMetadataWrapper.$$$reportNull$$$0(4);
            }
            return closableIt;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "familyId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "schema";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/introspection/jdbcMetadataWrappers/DatabaseMetaDataWrapper$PostgresMetadataWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/introspection/jdbcMetadataWrappers/DatabaseMetaDataWrapper$PostgresMetadataWrapper";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "tables";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class RoutineArgument
    extends TypedElement {
        public final Routine routine;
        public int position;
        @Nullable
        public String name;
        @Nullable
        public String def;
        public DasArgument.Direction direction;
        @Nullable
        public String comment;

        public RoutineArgument(@NotNull Routine routine) {
            if (routine == null) {
                RoutineArgument.$$$reportNull$$$0(0);
            }
            this.routine = routine;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/database/introspection/jdbcMetadataWrappers/DatabaseMetaDataWrapper$RoutineArgument", "<init>"));
        }
    }

    public static class Routine
    extends Assignable<Routine> {
        public final Schema schema;
        @Nullable
        public String pkg;
        @NotNull
        public String name;
        public short number;
        @NotNull
        public String specificName;
        @Nullable
        public String comment;
        @NotNull
        public DasRoutine.Kind kind;

        public Routine(@NotNull Schema schema, @Nullable String pkg, @NotNull String name) {
            if (schema == null) {
                Routine.$$$reportNull$$$0(0);
            }
            if (name == null) {
                Routine.$$$reportNull$$$0(1);
            }
            this.name = "";
            this.number = 0;
            this.specificName = "";
            this.kind = DasRoutine.Kind.NONE;
            this.schema = schema;
            this.pkg = pkg;
            this.name = name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "schema";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/introspection/jdbcMetadataWrappers/DatabaseMetaDataWrapper$Routine";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class UserDefinedTypeAttribute
    extends Assignable<UserDefinedTypeAttribute> {
        public final UserDefinedType userDefinedType;
        @Nullable
        public String name;
        public int type;
        @Nullable
        public String typeName;
        @Nullable
        public String comment;
        public int length;
        public int scale;
        public boolean nullable;
        @Nullable
        public String def;
        public int position;

        public UserDefinedTypeAttribute(@NotNull UserDefinedType userDefinedType) {
            if (userDefinedType == null) {
                UserDefinedTypeAttribute.$$$reportNull$$$0(0);
            }
            this.userDefinedType = userDefinedType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userDefinedType", "com/intellij/database/introspection/jdbcMetadataWrappers/DatabaseMetaDataWrapper$UserDefinedTypeAttribute", "<init>"));
        }
    }

    public static class UserDefinedType
    extends Assignable<UserDefinedType> {
        public final Schema schema;
        @Nullable
        public String name;
        @Nullable
        public String comment;

        public UserDefinedType(@NotNull Schema schema) {
            if (schema == null) {
                UserDefinedType.$$$reportNull$$$0(0);
            }
            this.schema = schema;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/introspection/jdbcMetadataWrappers/DatabaseMetaDataWrapper$UserDefinedType", "<init>"));
        }
    }

    public static class Type
    extends Assignable<Type> {
        @Nullable
        public String name;
    }

    public static class TableIndexColumn
    extends Assignable<TableIndexColumn> {
        public final TableIndex index;
        @Nullable
        public String name;
        public short position;
        public DasIndex.Sorting sorting;

        public TableIndexColumn(@NotNull TableIndex index2) {
            if (index2 == null) {
                TableIndexColumn.$$$reportNull$$$0(0);
            }
            this.index = index2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/database/introspection/jdbcMetadataWrappers/DatabaseMetaDataWrapper$TableIndexColumn", "<init>"));
        }
    }

    public static class TableFKeyColumn
    extends Assignable<TableFKeyColumn> {
        public final TableFKey fk;
        @Nullable
        public String name;
        @Nullable
        public String targetName;
        public short position;

        public TableFKeyColumn(@NotNull TableFKey fk) {
            if (fk == null) {
                TableFKeyColumn.$$$reportNull$$$0(0);
            }
            this.fk = fk;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fk", "com/intellij/database/introspection/jdbcMetadataWrappers/DatabaseMetaDataWrapper$TableFKeyColumn", "<init>"));
        }
    }

    public static class TableKeyColumn
    extends Assignable<TableKeyColumn> {
        public final TableKey key;
        @Nullable
        public String name;
        public short position;

        public TableKeyColumn(@NotNull TableKey key2) {
            if (key2 == null) {
                TableKeyColumn.$$$reportNull$$$0(0);
            }
            this.key = key2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/introspection/jdbcMetadataWrappers/DatabaseMetaDataWrapper$TableKeyColumn", "<init>"));
        }
    }

    public static class TableIndex
    extends Assignable<TableIndex> {
        public final Table table;
        @Nullable
        public String name;
        public boolean nonUnique;
        @Nullable
        public String qualifier;
        public short type;

        public TableIndex(@NotNull Table table, @Nullable String name) {
            if (table == null) {
                TableIndex.$$$reportNull$$$0(0);
            }
            this.table = table;
            this.name = name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/introspection/jdbcMetadataWrappers/DatabaseMetaDataWrapper$TableIndex", "<init>"));
        }
    }

    public static class TableFKey
    extends Assignable<TableFKey> {
        public final Table table;
        public final Table targetTable;
        @Nullable
        public String name;
        public boolean surrogateName;
        public short updateRule;
        public short deleteRule;
        public short deferrability;

        public TableFKey(@NotNull Table table, @NotNull Table targetTable, @Nullable String name) {
            if (table == null) {
                TableFKey.$$$reportNull$$$0(0);
            }
            if (targetTable == null) {
                TableFKey.$$$reportNull$$$0(1);
            }
            this.table = table;
            this.targetTable = targetTable;
            this.name = name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "table";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "targetTable";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/introspection/jdbcMetadataWrappers/DatabaseMetaDataWrapper$TableFKey";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TableKey
    extends Assignable<TableKey> {
        public final Table table;
        @Nullable
        public String name;
        public boolean primary;

        public TableKey(@NotNull Table table, @Nullable String name) {
            if (table == null) {
                TableKey.$$$reportNull$$$0(0);
            }
            this.table = table;
            this.name = name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/introspection/jdbcMetadataWrappers/DatabaseMetaDataWrapper$TableKey", "<init>"));
        }
    }

    public static class TableColumn
    extends TypedElement {
        public final Table table;
        public int position;
        @Nullable
        public String name;
        @Nullable
        public String def;
        public boolean autoIncrement;
        @Nullable
        public String comment;

        public TableColumn(@NotNull Table table) {
            if (table == null) {
                TableColumn.$$$reportNull$$$0(0);
            }
            this.table = table;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/introspection/jdbcMetadataWrappers/DatabaseMetaDataWrapper$TableColumn", "<init>"));
        }
    }

    public static class Table
    extends Assignable<Table> {
        public final Schema schema;
        @NotNull
        public String name;
        @Nullable
        public String type;
        @Nullable
        public String comment;

        public Table(@NotNull Schema schema, @NotNull String name) {
            if (schema == null) {
                Table.$$$reportNull$$$0(0);
            }
            if (name == null) {
                Table.$$$reportNull$$$0(1);
            }
            this.name = "";
            this.schema = schema;
            this.name = name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "schema";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/introspection/jdbcMetadataWrappers/DatabaseMetaDataWrapper$Table";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TypedElement
    extends Assignable<TypedElement> {
        @Nullable
        public String typeName;
        @Nullable
        public String typeSuffix;
        public int length;
        public int scale;
        public boolean nullable;
        public int type;
    }

    public static class Schema
    extends Assignable<Schema> {
        @NotNull
        public String schema;
        @Nullable
        public String database;

        public Schema(@NotNull String schema, @Nullable String database) {
            if (schema == null) {
                Schema.$$$reportNull$$$0(0);
            }
            this.schema = schema;
            this.database = database;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/introspection/jdbcMetadataWrappers/DatabaseMetaDataWrapper$Schema", "<init>"));
        }
    }

    public static class Assignable<T extends Assignable> {
        public void assign(T val) {
            try {
                for (Field field : this.getClass().getFields()) {
                    if (Assignable.class.isAssignableFrom(field.getType())) {
                        ((Assignable)field.get(this)).assign((Assignable)field.get(val));
                        continue;
                    }
                    if (Modifier.isFinal(field.getModifiers())) continue;
                    field.set(this, field.get(val));
                }
            }
            catch (IllegalAccessException e) {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)e);
            }
        }
    }
}

