/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.BasicMetaObject;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicMetaModel
implements MetaModel {
    public final BasicMetaObject root;
    public final Class<? extends BasicModel> apiClass;
    public final Class<? extends BasicModModel> modApiClass;
    private final MultiMap<ObjectKind, BasicMetaObject> myObjects = MultiMap.create();

    public BasicMetaModel(BasicMetaObject root2, Class<? extends BasicModel> apiClass, Class<? extends BasicModModel> modApiClass) {
        this.root = root2;
        this.apiClass = apiClass;
        this.modApiClass = modApiClass;
        root2.setModel(this);
        for (BasicMetaObject object : this.traverse().traverse(TreeTraversal.INTERLEAVED_DFS)) {
            this.myObjects.putValue((Object)object.kind, (Object)object);
        }
    }

    @Nullable
    public BasicMetaObject findBestMetaObject(@Nullable BasicMetaObject t) {
        Collection candidates;
        Collection collection = candidates = t == null ? null : this.myObjects.get((Object)t.kind);
        if (ContainerUtil.isEmpty(candidates)) {
            return null;
        }
        if (candidates.size() == 1) {
            return (BasicMetaObject)ContainerUtil.getFirstItem((Collection)candidates);
        }
        BasicMetaObject best = null;
        int bestGrade = -1;
        for (BasicMetaObject candidate : candidates) {
            int g = BasicMetaModel.grade(candidate, t);
            if (g <= bestGrade) continue;
            best = candidate;
            bestGrade = g;
        }
        return best;
    }

    private static int grade(@NotNull BasicMetaObject candidate, @NotNull BasicMetaObject t) {
        if (candidate == null) {
            BasicMetaModel.$$$reportNull$$$0(0);
        }
        if (t == null) {
            BasicMetaModel.$$$reportNull$$$0(1);
        }
        int res = -1;
        BasicMetaObject cp = candidate;
        for (BasicMetaObject tp = t; cp != null && tp != null && cp.kind == tp.kind; cp = cp.getParent(), tp = tp.getParent()) {
            ++res;
        }
        return res;
    }

    @NotNull
    public JBIterable<ObjectKind> getChildKinds(@NotNull ObjectKind kind) {
        if (kind == null) {
            BasicMetaModel.$$$reportNull$$$0(2);
        }
        JBIterable jBIterable = this.findKind(kind).flatten(o -> JBIterable.of((Object[])o.children)).map(o -> o.kind).unique();
        if (jBIterable == null) {
            BasicMetaModel.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<ObjectKind> getParentKinds(@NotNull ObjectKind kind) {
        if (kind == null) {
            BasicMetaModel.$$$reportNull$$$0(4);
        }
        JBIterable jBIterable = this.findKind(kind).filterMap(BasicMetaObject::getParent).map(o -> o.kind).unique();
        if (jBIterable == null) {
            BasicMetaModel.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<ObjectKind> getRootNamespaceKinds() {
        JBIterable jBIterable = JBIterable.of((Object[])this.root.children).transform(o -> o.kind);
        if (jBIterable == null) {
            BasicMetaModel.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    @NotNull
    public Set<ObjectKind> getNamespaces() {
        Set set = ((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.of(o -> o.children).withRoots((Iterable)JBIterable.of((Object[])this.root.children))).expandAndFilter(o -> BasicNamespace.class.isAssignableFrom(o.apiClass))).traverse().transform(o -> o.kind).filter(o -> o == ObjectKind.SCHEMA || o == ObjectKind.DATABASE).toSet();
        if (set == null) {
            BasicMetaModel.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    public JBIterable<List<ObjectKind>> getPathsToRoot(ObjectKind kind) {
        JBIterable jBIterable = this.findKind(kind).transform(o -> JBIterable.generate((Object)o, x -> x.getParent()).transform(x -> x.kind).toList());
        if (jBIterable == null) {
            BasicMetaModel.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<BasicMetaObject> findKind(ObjectKind kind) {
        JBIterable jBIterable = JBIterable.from((Iterable)this.myObjects.get((Object)kind));
        if (jBIterable == null) {
            BasicMetaModel.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @NotNull
    private JBTreeTraverser<BasicMetaObject> traverse() {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)JBTreeTraverser.of(o -> o.children).withRoot((Object)this.root);
        if (jBTreeTraverser == null) {
            BasicMetaModel.$$$reportNull$$$0(10);
        }
        return jBTreeTraverser;
    }

    @Nullable
    public ObjectKind findKind(@Nullable String code) {
        ObjectKind kind = (ObjectKind)ObjectKind.ourKinds.get(code);
        return this.myObjects.containsKey((Object)kind) ? kind : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/BasicMetaModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/BasicMetaModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildKinds";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentKinds";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootNamespaceKinds";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaces";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsToRoot";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findKind";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "traverse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "grade";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChildKinds";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getParentKinds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

