/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.BasicMetaModel;
import com.intellij.database.model.BasicMetaProperty;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicMetaObject {
    private static final BasicMetaObject[] EMPTY_ARRAY = new BasicMetaObject[0];
    private static final BasicMetaProperty[] EMPTY_PROPS_ARRAY = new BasicMetaProperty[0];
    public final ObjectKind kind;
    public final Class<? extends BasicElement> apiClass;
    public final Class<? extends BasicModElement> modApiClass;
    public final BasicMetaProperty[] properties;
    public final BasicMetaObject[] children;
    private Object myParent;

    public BasicMetaObject(ObjectKind kind, Class<? extends BasicElement> apiClass, Class<? extends BasicModElement> modApiClass, BasicMetaProperty[] properties, BasicMetaObject[] children2) {
        this.kind = kind;
        this.apiClass = apiClass;
        this.modApiClass = modApiClass;
        this.properties = properties == null ? EMPTY_PROPS_ARRAY : properties;
        for (BasicMetaObject child : this.children = children2 == null ? EMPTY_ARRAY : children2) {
            assert (child.myParent == null);
            child.myParent = this;
        }
    }

    @Nullable
    public BasicMetaObject getParent() {
        return (BasicMetaObject)ObjectUtils.tryCast((Object)this.myParent, BasicMetaObject.class);
    }

    @Nullable
    public BasicMetaModel getModel() {
        Object parent = this.myParent;
        while (parent instanceof BasicMetaObject) {
            parent = ((BasicMetaObject)parent).myParent;
        }
        return (BasicMetaModel)ObjectUtils.tryCast((Object)parent, BasicMetaModel.class);
    }

    void setModel(@NotNull BasicMetaModel model) {
        if (model == null) {
            BasicMetaObject.$$$reportNull$$$0(0);
        }
        assert (this.myParent == null);
        this.myParent = model;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/model/BasicMetaObject", "setModel"));
    }
}

