/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.util.Couple;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MetaModelImpl
implements MetaModel {
    private final MetaModel myDelegate;
    private final Set<Couple<ObjectKind>> myExtra;
    private final Map<String, ObjectKind> myExtraKinds;

    @NotNull
    public static MetaModelBuilder builder(@NotNull MetaModel model) {
        if (model == null) {
            MetaModelImpl.$$$reportNull$$$0(0);
        }
        MetaModelBuilder metaModelBuilder = new MetaModelBuilder(model);
        if (metaModelBuilder == null) {
            MetaModelImpl.$$$reportNull$$$0(1);
        }
        return metaModelBuilder;
    }

    private MetaModelImpl(@NotNull MetaModel delegate, @NotNull Set<Couple<ObjectKind>> extra, @NotNull Map<String, ObjectKind> extraKinds) {
        if (delegate == null) {
            MetaModelImpl.$$$reportNull$$$0(2);
        }
        if (extra == null) {
            MetaModelImpl.$$$reportNull$$$0(3);
        }
        if (extraKinds == null) {
            MetaModelImpl.$$$reportNull$$$0(4);
        }
        this.myDelegate = delegate;
        this.myExtra = extra;
        this.myExtraKinds = extraKinds;
    }

    @NotNull
    public JBIterable<ObjectKind> getRootNamespaceKinds() {
        JBIterable jBIterable = this.myDelegate.getRootNamespaceKinds();
        if (jBIterable == null) {
            MetaModelImpl.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<ObjectKind> getChildKinds(@NotNull ObjectKind kind) {
        if (kind == null) {
            MetaModelImpl.$$$reportNull$$$0(6);
        }
        JBIterable jBIterable = this.myDelegate.getChildKinds(kind).append((Iterable)JBIterable.from(this.myExtra).filterMap(p -> {
            if (kind == null) {
                MetaModelImpl.$$$reportNull$$$0(16);
            }
            return p.first == kind ? (ObjectKind)p.second : null;
        })).unique();
        if (jBIterable == null) {
            MetaModelImpl.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<ObjectKind> getParentKinds(@NotNull ObjectKind kind) {
        if (kind == null) {
            MetaModelImpl.$$$reportNull$$$0(8);
        }
        JBIterable jBIterable = this.myDelegate.getParentKinds(kind).append((Iterable)JBIterable.from(this.myExtra).filterMap(p -> {
            if (kind == null) {
                MetaModelImpl.$$$reportNull$$$0(15);
            }
            return p.second == kind ? (ObjectKind)p.first : null;
        })).unique();
        if (jBIterable == null) {
            MetaModelImpl.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @NotNull
    public Set<ObjectKind> getNamespaces() {
        Set set = this.myDelegate.getNamespaces();
        if (set == null) {
            MetaModelImpl.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    public JBIterable<List<ObjectKind>> getPathsToRoot(@NotNull ObjectKind kind) {
        if (kind == null) {
            MetaModelImpl.$$$reportNull$$$0(11);
        }
        JBIterable jBIterable = this.myDelegate.getPathsToRoot(kind).append((Iterable)JBIterable.from(this.myExtra).filterMap(p -> {
            if (kind == null) {
                MetaModelImpl.$$$reportNull$$$0(14);
            }
            return p.second == kind ? (ObjectKind)p.first : null;
        }).flatten(this::getPathsToRoot).transform(l -> {
            if (kind == null) {
                MetaModelImpl.$$$reportNull$$$0(13);
            }
            return ContainerUtil.prepend((List)l, (Object[])new ObjectKind[]{kind});
        }));
        if (jBIterable == null) {
            MetaModelImpl.$$$reportNull$$$0(12);
        }
        return jBIterable;
    }

    @Nullable
    public ObjectKind findKind(@Nullable String code) {
        return (ObjectKind)ObjectUtils.chooseNotNull((Object)this.myExtraKinds.get(code), (Object)this.myDelegate.findKind(code));
    }

    public String toString() {
        return this.myExtraKinds.values().toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/MetaModelImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extra";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraKinds";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/MetaModelImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "builder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootNamespaceKinds";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildKinds";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentKinds";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaces";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsToRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "builder";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChildKinds";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getParentKinds";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPathsToRoot";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getPathsToRoot$3";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getPathsToRoot$2";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getParentKinds$1";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getChildKinds$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class MetaModelBuilder {
        private final Set<Couple<ObjectKind>> a;
        private final Map<String, ObjectKind> b;
        private final MetaModel delegate;

        private MetaModelBuilder(@NotNull MetaModel delegate) {
            if (delegate == null) {
                MetaModelBuilder.$$$reportNull$$$0(0);
            }
            this.a = ContainerUtil.newLinkedHashSet();
            this.b = ContainerUtil.newLinkedHashMap();
            this.delegate = delegate;
        }

        public MetaModelBuilder put(ObjectKind parent, ObjectKind child) {
            this.a.add((Couple<ObjectKind>)Couple.of((Object)parent, (Object)child));
            this.b.put(child.code(), child);
            return this;
        }

        public MetaModelImpl build() {
            return new MetaModelImpl(this.delegate, Collections.unmodifiableSet(this.a), Collections.unmodifiableMap(this.b));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/model/MetaModelImpl$MetaModelBuilder", "<init>"));
        }
    }
}

