/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BasicElement
extends BasicNode,
DasObject {
    @NotNull
    public ObjectKind getKind();

    @Override
    @Nullable
    default public BasicModel getModel() {
        BasicElement parent = this.getParent();
        return parent != null ? parent.getModel() : null;
    }

    @NotNull
    default public <P extends BasicElement> P parent(@NotNull Class<P> parentClass) throws IllegalArgumentException {
        if (parentClass == null) {
            BasicElement.$$$reportNull$$$0(0);
        }
        for (BasicElement p = this.getParent(); p != null; p = p.getParent()) {
            if (parentClass.isAssignableFrom(p.getClass())) {
                BasicElement basicElement = p;
                if (basicElement == null) {
                    BasicElement.$$$reportNull$$$0(1);
                }
                return (P)basicElement;
            }
            if (p instanceof BasicRoot) break;
        }
        throw new IllegalArgumentException(String.format("Class %s has no parent of class %s", this.getClass().getSimpleName(), parentClass.getSimpleName()));
    }

    @Nullable
    default public BasicDatabase getDatabase() {
        BasicElement parent = this.getParent();
        return parent != null ? parent.getDatabase() : null;
    }

    @Nullable
    default public BasicSchema getSchema() {
        BasicElement parent = this.getParent();
        return parent != null ? parent.getSchema() : null;
    }

    default public @Nullable Family<@NotNull ? extends BasicElement> getParentFamily() {
        return null;
    }

    default public int getPositionInFamily() {
        Family<@NotNull ? extends BasicElement> f = this.getParentFamily();
        if (f != null) {
            int index2 = f.indexOf(this);
            return index2 >= 0 ? index2 + 1 : Integer.MAX_VALUE;
        }
        return 0;
    }

    @NotNull
    default public String getDisplayOrder() {
        String string = this.calculateDisplayOrder();
        if (string == null) {
            BasicElement.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    default public String calculateDisplayOrder() {
        String name = this.getName();
        String string = name.length() > 0 ? name : "\uffff";
        if (string == null) {
            BasicElement.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    default public String identity() {
        String string = this.identity(true);
        if (string == null) {
            BasicElement.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    default public String identity(boolean includingSurrogate) {
        if (this instanceof BasicNamedElement) {
            String name;
            BasicNamedElement e = (BasicNamedElement)this;
            String string = name = includingSurrogate ? e.getRealName() : e.getNaturalName();
            if (name != null) {
                String string2 = name;
                if (string2 == null) {
                    BasicElement.$$$reportNull$$$0(5);
                }
                return string2;
            }
        }
        String string = '#' + Integer.toString(this.getPositionInFamily());
        if (string == null) {
            BasicElement.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    default public @NotNull List<@NotNull String> getDbPath() {
        ArrayList<@NotNull String> path = new ArrayList<String>(this instanceof BasicNamespace ? 2 : 4);
        BasicElement e = this;
        while (e != null) {
            path.add(0, e.identity() + "{" + e.getKind().code() + "}");
            if (!((e = e.getParent()) instanceof BasicRoot)) continue;
            ArrayList<String> arrayList = path;
            if (arrayList == null) {
                BasicElement.$$$reportNull$$$0(7);
            }
            return arrayList;
        }
        throw new IllegalStateException("No path from the root found because no root");
    }

    @NotNull
    public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies();

    @NotNull
    public @NotNull List<@NotNull ObjectKind> getFamilyKinds();

    public @Nullable Family<@NotNull ? extends BasicElement> familyOf(@NotNull ObjectKind var1);

    @Nullable
    public BasicElement getParent();

    @Nullable
    default public BasicElement getDasParent() {
        return this.getParent();
    }

    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getChildren() {
        JBIterable jBIterable = JBIterable.from(this.getFamilies()).flatten((Function)Functions.id());
        if (jBIterable == null) {
            BasicElement.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDasChildren(@Nullable ObjectKind kind) {
        JBIterable jBIterable = kind == null || kind == ObjectKind.NONE ? this.getChildren() : JBIterable.from(this.familyOf(kind));
        if (jBIterable == null) {
            BasicElement.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    default public boolean hasChildren() {
        for (Family<? extends BasicElement> family : this.getFamilies()) {
            if (!family.hasChildren()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    default public <E extends BasicElement> E findChild(@NotNull ObjectKind kind, @NotNull String name, @NotNull Class<E> clazz) {
        Family<? extends BasicElement> elements;
        if (kind == null) {
            BasicElement.$$$reportNull$$$0(10);
        }
        if (name == null) {
            BasicElement.$$$reportNull$$$0(11);
        }
        if (clazz == null) {
            BasicElement.$$$reportNull$$$0(12);
        }
        if ((elements = this.familyOf(kind)) == null) {
            return null;
        }
        if (!1.$assertionsDisabled && !(elements instanceof NamingFamily)) {
            throw new AssertionError((Object)"Attempted to find an element by name when the family is not naming");
        }
        Object element = ((NamingFamily)elements).get(name);
        if (element != null && clazz.isAssignableFrom(element.getClass())) {
            return element;
        }
        return null;
    }

    @Nullable
    default public <E extends BasicElement> E findChild(@NotNull Collection<ObjectKind> kinds, @NotNull String name, @NotNull Class<E> clazz) {
        if (kinds == null) {
            BasicElement.$$$reportNull$$$0(13);
        }
        if (name == null) {
            BasicElement.$$$reportNull$$$0(14);
        }
        if (clazz == null) {
            BasicElement.$$$reportNull$$$0(15);
        }
        for (ObjectKind kind : kinds) {
            E result2 = this.findChild(kind, name, clazz);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            BasicElement.$$$reportNull$$$0(16);
        }
        return list;
    }

    default public void exportProperties(@NotNull NameValueConsumer<String> consumer2) {
        if (consumer2 == null) {
            BasicElement.$$$reportNull$$$0(17);
        }
    }

    default public boolean isElementSurrogate() {
        return false;
    }

    default public boolean isAutoCreated() {
        return this.isElementSurrogate();
    }

    @NotNull
    default public Iterable<? extends BasicElement> getPredecessors() {
        Set set = Collections.emptySet();
        if (set == null) {
            BasicElement.$$$reportNull$$$0(18);
        }
        return set;
    }

    @Nullable
    default public CasingProvider getCasingProvider() {
        if (this instanceof CasingProvider) {
            return (CasingProvider)this;
        }
        BasicElement parent = this.getParent();
        return parent != null ? parent.getCasingProvider() : null;
    }

    @Override
    @NotNull
    default public Iterable<? extends BasicNode> getChildNodes() {
        List<? extends Family<? extends BasicElement>> list = this.getFamilies();
        if (list == null) {
            BasicElement.$$$reportNull$$$0(19);
        }
        return list;
    }

    @Override
    @NotNull
    default public String getDisplayName() {
        String name = this.getName();
        String string = name == ModelConsts.NO_NAME ? this.getKind().code() + " " + this.identity() : name;
        if (string == null) {
            BasicElement.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    default public String getName() {
        String string = ModelConsts.NO_NAME;
        if (string == null) {
            BasicElement.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Nullable
    default public String getNaturalName() {
        return null;
    }

    @Nullable
    default public String getRealName() {
        return null;
    }

    @Nullable
    default public String getComment() {
        return null;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/basic/BasicElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/basic/BasicElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayOrder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateDisplayOrder";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "identity";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasChildren";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredecessors";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildNodes";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findChild";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

