/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.diff;

import com.intellij.database.model.BasicMetaObject;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.diff.DbDiffCheckOption;
import com.intellij.database.model.diff.DbDiffElement;
import com.intellij.database.model.diff.DbDiffRoot;
import com.intellij.database.model.diff.DbMigrationAction;
import com.intellij.database.model.diff.SchemaDiffRequest;
import com.intellij.database.model.families.Family;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.diff.DiffManager;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

public class SchemaDiffAction
extends DumbAwareAction {
    public void update(AnActionEvent e) {
        Project project = e.getProject();
        Pair<DbElement, DbElement> elements = SchemaDiffAction.getElements(e);
        e.getPresentation().setEnabled(project != null && elements != null);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Pair<DbElement, DbElement> pair = SchemaDiffAction.getElements(e);
        if (pair == null) {
            return;
        }
        DirDiffSettings settings = SchemaDiffAction.createSettings();
        SchemaDiffRequest request = new SchemaDiffRequest(SchemaDiffAction.createElement((DbElement)pair.first, settings, (DbElement)pair.second), SchemaDiffAction.createElement((DbElement)pair.second, settings, (DbElement)pair.first));
        DiffManager.getInstance().showDiff(project, (DiffRequest)request);
    }

    @NotNull
    private static DirDiffSettings createSettings() {
        DirDiffSettings settings = new DirDiffSettings();
        settings.showSize = false;
        settings.showDate = false;
        settings.showCompareModes = false;
        settings.customSettings.put("IGNORE_ORDER", true);
        settings.customSettings.put("IGNORE_CASE", true);
        settings.addExtraAction((AnAction)new DbDiffCheckOption("IGNORE_ORDER", "Ignore &order", "alt O"));
        settings.addExtraAction((AnAction)new DbDiffCheckOption("IGNORE_CASE", "Ignore &case", "alt C"));
        settings.addExtraAction((AnAction)Separator.getInstance());
        settings.addExtraAction((AnAction)new DbMigrationAction(DbMigrationAction.Direction.FORWARD));
        settings.addExtraAction((AnAction)new DbMigrationAction(DbMigrationAction.Direction.BACKWARD));
        DirDiffSettings dirDiffSettings = settings;
        if (dirDiffSettings == null) {
            SchemaDiffAction.$$$reportNull$$$0(0);
        }
        return dirDiffSettings;
    }

    @NotNull
    private static DbDiffElement createElement(DbElement element, DirDiffSettings settings, DbElement other) {
        Rdbms alt = ((BasicModel)ObjectUtils.notNull((Object)((BasicElement)other.getDelegate()).getModel())).getRdbms();
        DbDiffRoot root2 = new DbDiffRoot(element.getDataSource(), settings, alt);
        BasicElement e = (BasicElement)element.getDelegate();
        DbDiffElement dbDiffElement = new DbDiffElement(root2, e, SchemaDiffAction.createAltElement(root2.getAltModel(), e));
        if (dbDiffElement == null) {
            SchemaDiffAction.$$$reportNull$$$0(1);
        }
        return dbDiffElement;
    }

    private static BasicModElement createAltElement(@Nullable BasicModModel model, BasicElement e) {
        if (model == null) {
            return null;
        }
        BasicMetaObject meta = model.getMetaModel().findBestMetaObject(((BasicModElement)e).getMetaObject());
        if (meta == null) {
            return null;
        }
        Ref res = Ref.create();
        model.modify(BasicModRoot.class, r -> {
            res.set((Object)SchemaDiffAction.instantiate(r, meta));
            if (res.isNull()) {
                r.dropChildren();
            }
        });
        return (BasicModElement)res.get();
    }

    @Nullable
    private static BasicModElement instantiate(@NotNull BasicModElement o, @NotNull BasicMetaObject meta) {
        if (o == null) {
            SchemaDiffAction.$$$reportNull$$$0(2);
        }
        if (meta == null) {
            SchemaDiffAction.$$$reportNull$$$0(3);
        }
        if (meta.kind == o.getKind()) {
            return o;
        }
        BasicMetaObject p = meta.getParent();
        BasicModElement parent = p == null ? null : SchemaDiffAction.instantiate(o, p);
        Family family = parent == null ? null : parent.familyOf(meta.kind);
        return family == null ? null : (BasicModElement)family.createNewOne();
    }

    @Nullable
    private static Pair<DbElement, DbElement> getElements(AnActionEvent e) {
        DbElement e2;
        DbElement e1;
        block7: {
            DbElement same;
            PsiElement[] elements = (PsiElement[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY);
            if (elements == null || elements.length != 2 || !(elements[0] instanceof DbElement) || !(elements[1] instanceof DbElement)) {
                return null;
            }
            e1 = (DbElement)elements[0];
            e2 = (DbElement)elements[1];
            HashMap possible1 = ContainerUtil.newHashMap();
            HashMap possible2 = ContainerUtil.newHashMap();
            e1 = SchemaDiffAction.fillPossible(e1, possible1);
            e2 = SchemaDiffAction.fillPossible(e2, possible2);
            while ((same = (DbElement)possible2.get(e1.getKind())) == null) {
                DbElement p = e1.getParent();
                if (p != null && possible1.containsKey(p.getKind())) {
                    e1 = p;
                    continue;
                }
                break block7;
            }
            e2 = same;
        }
        if (e1.getKind() != e2.getKind()) {
            return null;
        }
        if (e1.getDelegate() instanceof DasTableChild) {
            return null;
        }
        if (!(e1.getDelegate() instanceof BasicElement)) {
            return null;
        }
        if (!(e2.getDelegate() instanceof BasicElement)) {
            return null;
        }
        return Pair.create((Object)e1, (Object)e2);
    }

    private static DbElement fillPossible(@NotNull DbElement el, @NotNull Map<ObjectKind, DbElement> pos) {
        if (el == null) {
            SchemaDiffAction.$$$reportNull$$$0(4);
        }
        if (pos == null) {
            SchemaDiffAction.$$$reportNull$$$0(5);
        }
        if (DasUtil.getParentOfKind((DasObject)el, (ObjectKind)ObjectKind.SCHEMA, (boolean)true) == null) {
            DbElement tmp = el;
            while (tmp != null) {
                pos.put(tmp.getKind(), tmp);
                el = tmp;
                tmp = tmp.getKind() == ObjectKind.SCHEMA ? null : (DbElement)tmp.getDasChildren(null).single();
            }
            return el;
        }
        pos.put(el.getKind(), el);
        return el;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/diff/SchemaDiffAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/diff/SchemaDiffAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "instantiate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fillPossible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

