/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLeaf;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.oracle.OraSchema;
import com.intellij.database.model.oracle.OraTrigger;
import com.intellij.database.model.oracle.OraView;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.SourceError;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraViewTrigger
extends OraTrigger,
BasicLeaf {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.TRIGGER;
        if (objectKind == null) {
            OraViewTrigger.$$$reportNull$$$0(0);
        }
        return objectKind;
    }

    @Nullable
    public OraView getView();

    @Override
    @Nullable
    default public OraView getParent() {
        return this.getView();
    }

    @Override
    @Nullable
    default public OraView getMajorObject() {
        return this.getView();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends OraViewTrigger> getParentFamily() {
        return null;
    }

    @Override
    @Nullable
    default public OraSchema getSchema() {
        OraView view = this.getView();
        return view != null ? view.getSchema() : null;
    }

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.emptyList();
        if (list == null) {
            OraViewTrigger.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            OraViewTrigger.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    default public int getSourceTextLength() {
        return 0;
    }

    @Override
    @NotNull
    default public List<SourceError> getErrors() {
        List<SourceError> list = Collections.emptyList();
        if (list == null) {
            OraViewTrigger.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    default public boolean isInvalid() {
        return false;
    }

    @Override
    default public boolean isObfuscated() {
        return false;
    }

    @Override
    @NotNull
    default public Set<Long> getDependsOnIds() {
        Set<Long> set = Collections.emptySet();
        if (set == null) {
            OraViewTrigger.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    @Nullable
    default public Date getCreatedTimestamp() {
        return null;
    }

    @Override
    @Nullable
    default public Date getModifiedTimestamp() {
        return null;
    }

    @Override
    @NotNull
    default public Set<TrigEvent> getEvents() {
        Set<TrigEvent> set = Collections.emptySet();
        if (set == null) {
            OraViewTrigger.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Override
    @Nullable
    default public TrigTurn getTurn() {
        return null;
    }

    @Override
    @NotNull
    default public List<String> getColNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            OraViewTrigger.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer2) {
        List<String> colNames;
        TrigTurn turn;
        Set<TrigEvent> events;
        Date modifiedTimestamp;
        Date createdTimestamp;
        Set<Long> dependsOnIds;
        boolean obfuscated;
        boolean invalid;
        int sourceTextLength;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        long objectId;
        if (consumer2 == null) {
            OraViewTrigger.$$$reportNull$$$0(7);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer2.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer2.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer2.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer2.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer2.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer2.accept("Comment", PropertyConverter.export(comment));
        }
        if ((sourceTextLength = this.getSourceTextLength()) != 0) {
            consumer2.accept("SourceTextLength", PropertyConverter.export(sourceTextLength));
        }
        if (invalid = this.isInvalid()) {
            consumer2.accept("Invalid", PropertyConverter.export(invalid));
        }
        if (obfuscated = this.isObfuscated()) {
            consumer2.accept("Obfuscated", PropertyConverter.export(obfuscated));
        }
        if (!(dependsOnIds = this.getDependsOnIds()).isEmpty()) {
            consumer2.accept("DependsOnIds", PropertyConverter.exportSetOfLong(dependsOnIds));
        }
        if ((createdTimestamp = this.getCreatedTimestamp()) != null) {
            consumer2.accept("CreatedTimestamp", PropertyConverter.export(createdTimestamp));
        }
        if ((modifiedTimestamp = this.getModifiedTimestamp()) != null) {
            consumer2.accept("ModifiedTimestamp", PropertyConverter.export(modifiedTimestamp));
        }
        if (!(events = this.getEvents()).isEmpty()) {
            consumer2.accept("Events", PropertyConverter.exportSetOfTrigEvent(events));
        }
        if ((turn = this.getTurn()) != null) {
            consumer2.accept("Turn", PropertyConverter.export((Enum)turn));
        }
        if (!(colNames = this.getColNames()).isEmpty()) {
            consumer2.accept("ColNames", PropertyConverter.exportListOfString(colNames));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "SourceTextLength", "Errors", "Invalid", "Obfuscated", "DependsOnIds", "CreatedTimestamp", "ModifiedTimestamp", "Events", "Turn", "ColNames");
        if (list == null) {
            OraViewTrigger.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/oracle/OraViewTrigger";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependsOnIds";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvents";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getColNames";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/oracle/OraViewTrigger";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

