/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.postgres.PostgresDefType;
import com.intellij.database.model.postgres.PostgresModDefTypeAttribute;
import com.intellij.database.model.postgres.PostgresModDefTypeCheck;
import com.intellij.database.model.postgres.PostgresModSchema;
import com.intellij.database.model.postgresbase.PostgresBaseModDefType;
import com.intellij.database.model.postgresbase.PostgresBaseModObjectWithOwner;
import com.intellij.database.model.properties.PostgresDataTypeSubCategory;
import com.intellij.database.model.properties.PostgresDataTypeSubKind;
import com.intellij.database.model.properties.PropertyConverter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresModDefType
extends PostgresDefType,
PostgresBaseModDefType,
PostgresBaseModObjectWithOwner,
BasicModIdentifiedElement,
BasicModNamedElement {
    @Override
    @NotNull
    public PostgresModSchema getSchema();

    @Override
    @NotNull
    default public PostgresModSchema getParent() {
        PostgresModSchema postgresModSchema = this.getSchema();
        if (postgresModSchema == null) {
            PostgresModDefType.$$$reportNull$$$0(0);
        }
        return postgresModSchema;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModDefType> getParentFamily();

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends PostgresModDefTypeAttribute> getAttributes();

    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModDefTypeCheck> getChecks();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getAttributes(), this.getChecks());
        if (list == null) {
            PostgresModDefType.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setOwner(@Nullable String var1);

    @Override
    public void setFaceless(boolean var1);

    @Override
    public void setStateNumber(long var1);

    @Override
    public void setSubKind(@NotNull PostgresDataTypeSubKind var1);

    public void setSubCategory(@NotNull PostgresDataTypeSubCategory var1);

    @Override
    public void setDefinition(@Nullable String var1);

    public void setLabels(@NotNull List<String> var1);

    default public void setLabels(String ... labels2) {
        this.setLabels(Arrays.asList(labels2));
    }

    @Override
    public void setDefaultExpression(@Nullable String var1);

    @Override
    public void setNotNull(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            PostgresModDefType.$$$reportNull$$$0(2);
        }
        String objectId = _properties.get("ObjectId");
        String name = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String comment = _properties.get("Comment");
        String owner = _properties.get("Owner");
        String faceless = _properties.get("Faceless");
        String stateNumber = _properties.get("StateNumber");
        String subKind = _properties.get("SubKind");
        String subCategory = _properties.get("SubCategory");
        String definition = _properties.get("Definition");
        String labels2 = _properties.get("Labels");
        String defaultExpression = _properties.get("DefaultExpression");
        String notNull = _properties.get("NotNull");
        this.setObjectId(objectId != null ? PropertyConverter.importLong(objectId) : Long.MIN_VALUE);
        this.setName(name != null ? PropertyConverter.importString(name) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean(nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean(nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean(nameQuoted) : false);
        this.setComment(comment != null ? PropertyConverter.importString(comment) : null);
        this.setOwner(owner != null ? PropertyConverter.importString(owner) : null);
        this.setFaceless(faceless != null ? PropertyConverter.importBoolean(faceless) : false);
        this.setStateNumber(stateNumber != null ? PropertyConverter.importLong(stateNumber) : 0L);
        this.setSubKind(subKind != null ? PropertyConverter.importPostgresDataTypeSubKind(subKind) : PostgresDataTypeSubKind.NONE);
        this.setSubCategory(subCategory != null ? PropertyConverter.importPostgresDataTypeSubCategory(subCategory) : PostgresDataTypeSubCategory.NONE);
        this.setDefinition(definition != null ? PropertyConverter.importString(definition) : null);
        this.setLabels(labels2 != null ? PropertyConverter.importListOfString(labels2) : Collections.emptyList());
        this.setDefaultExpression(defaultExpression != null ? PropertyConverter.importString(defaultExpression) : null);
        this.setNotNull(notNull != null ? PropertyConverter.importBoolean(notNull) : false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/postgres/PostgresModDefType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/postgres/PostgresModDefType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

