/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.postgres.PostgresModLikeStoredTable;
import com.intellij.database.model.postgres.PostgresModRule;
import com.intellij.database.model.postgres.PostgresModSchema;
import com.intellij.database.model.postgres.PostgresModTrigger;
import com.intellij.database.model.postgres.PostgresModViewColumn;
import com.intellij.database.model.postgres.PostgresView;
import com.intellij.database.model.postgresbase.PostgresBaseModView;
import com.intellij.database.model.properties.PostgresCheckOption;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.SourceError;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresModView
extends PostgresView,
PostgresModLikeStoredTable,
PostgresBaseModView {
    @Override
    @NotNull
    public PostgresModSchema getSchema();

    @Override
    @NotNull
    default public PostgresModSchema getParent() {
        PostgresModSchema postgresModSchema = this.getSchema();
        if (postgresModSchema == null) {
            PostgresModView.$$$reportNull$$$0(0);
        }
        return postgresModSchema;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModView> getParentFamily();

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends PostgresModViewColumn> getColumns();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModRule> getRules();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModTrigger> getTriggers();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getColumns(), this.getRules(), this.getTriggers());
        if (list == null) {
            PostgresModView.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setOwner(@Nullable String var1);

    @Override
    public void setFaceless(boolean var1);

    @Override
    public void setSystem(boolean var1);

    @Override
    public void setStateNumber(long var1);

    @Override
    public void setSourceTextLength(int var1);

    @Override
    public void setErrors(@NotNull List<SourceError> var1);

    @Override
    default public void setErrors(SourceError ... errors) {
        this.setErrors(Arrays.asList(errors));
    }

    @Override
    public void setInvalid(boolean var1);

    public void setCheckOption(@NotNull PostgresCheckOption var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            PostgresModView.$$$reportNull$$$0(2);
        }
        String objectId = _properties.get("ObjectId");
        String name = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String comment = _properties.get("Comment");
        String owner = _properties.get("Owner");
        String faceless = _properties.get("Faceless");
        String system = _properties.get("System");
        String stateNumber = _properties.get("StateNumber");
        String sourceTextLength = _properties.get("SourceTextLength");
        String invalid = _properties.get("Invalid");
        String checkOption = _properties.get("CheckOption");
        this.setObjectId(objectId != null ? PropertyConverter.importLong(objectId) : Long.MIN_VALUE);
        this.setName(name != null ? PropertyConverter.importString(name) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean(nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean(nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean(nameQuoted) : false);
        this.setComment(comment != null ? PropertyConverter.importString(comment) : null);
        this.setOwner(owner != null ? PropertyConverter.importString(owner) : null);
        this.setFaceless(faceless != null ? PropertyConverter.importBoolean(faceless) : false);
        this.setSystem(system != null ? PropertyConverter.importBoolean(system) : false);
        this.setStateNumber(stateNumber != null ? PropertyConverter.importLong(stateNumber) : 0L);
        this.setSourceTextLength(sourceTextLength != null ? PropertyConverter.importInt(sourceTextLength) : 0);
        this.setInvalid(invalid != null ? PropertyConverter.importBoolean(invalid) : false);
        this.setCheckOption(checkOption != null ? PropertyConverter.importPostgresCheckOption(checkOption) : PostgresCheckOption.NONE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/postgres/PostgresModView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/postgres/PostgresModView";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

