/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.postgres.PostgresDatabase;
import com.intellij.database.model.postgres.PostgresLocalTable;
import com.intellij.database.model.postgres.PostgresModelFun;
import com.intellij.database.model.postgres.PostgresRoutine;
import com.intellij.database.model.postgres.PostgresSchema;
import com.intellij.database.model.postgres.PostgresSequence;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.model.postgres.PostgresTrigger;
import com.intellij.database.model.postgresbase.PostgresBaseDatabase;
import com.intellij.database.model.postgresbase.PostgresBaseSchema;
import com.intellij.database.model.postgresbase.PostgresBaseTable;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\n\u0010\u0015\u001a\u00020\u000b*\u00020\u0006\u001a\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u0002*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019\u001a \u0010\u0016\u001a\u0004\u0018\u00010\u001a*\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u001a\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u001a*\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019\u001a\n\u0010\u001e\u001a\u00020\u001f*\u00020 \u001a\n\u0010!\u001a\u00020\u001f*\u00020 \u001a\n\u0010\"\u001a\u00020\u001f*\u00020\u0006\u001a\n\u0010#\u001a\u00020\u001f*\u00020\u0006\u001a\n\u0010$\u001a\u00020\u000b*\u00020\u0006\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u001b\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"ancestors", "", "Lcom/intellij/database/model/postgres/PostgresTable;", "getAncestors", "(Lcom/intellij/database/model/postgres/PostgresTable;)Ljava/util/List;", "callRoutine", "Lcom/intellij/database/model/postgres/PostgresRoutine;", "Lcom/intellij/database/model/postgres/PostgresTrigger;", "getCallRoutine", "(Lcom/intellij/database/model/postgres/PostgresTrigger;)Lcom/intellij/database/model/postgres/PostgresRoutine;", "callRoutineName", "", "getCallRoutineName", "(Lcom/intellij/database/model/postgres/PostgresTrigger;)Ljava/lang/String;", "successors", "", "getSuccessors", "(Lcom/intellij/database/model/postgres/PostgresTable;)Ljava/util/Set;", "floatToString", "f", "", "costAsString", "findTableByObjectId", "Lcom/intellij/database/model/postgres/PostgresSchema;", "id", "", "Lcom/intellij/database/model/postgresbase/PostgresBaseTable;", "Lcom/intellij/database/model/postgresbase/PostgresBaseDatabase;", "preferredSchema", "Lcom/intellij/database/model/postgresbase/PostgresBaseSchema;", "hasDefaultCacheSize", "", "Lcom/intellij/database/model/postgres/PostgresSequence;", "hasDefaultType", "isCostDefined", "isRowsDefined", "rowsAsString", "intellij.database.model"})
@JvmName(name="PostgresModelFun")
public final class PostgresModelFun {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PostgresTable> getAncestors(@NotNull PostgresTable $receiver) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        List<Long> ancestorIds = $receiver.getAncestorIds();
        if (ancestorIds.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        PostgresSchema postgresSchema = $receiver.getSchema();
        if (postgresSchema == null) {
            return CollectionsKt.emptyList();
        }
        PostgresSchema schema = postgresSchema;
        List<Long> list = ancestorIds;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"ancestorIds");
        Iterable $receiver$iv = list;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void id;
            Long l = (Long)item$iv$iv;
            Collection collection = destination$iv$iv;
            PostgresSchema postgresSchema2 = schema;
            Intrinsics.checkExpressionValueIsNotNull((Object)postgresSchema2, (String)"schema");
            void v3 = id;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"id");
            PostgresTable postgresTable = PostgresModelFun.findTableByObjectId(postgresSchema2, v3.longValue());
            collection.add(postgresTable);
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<PostgresTable> getSuccessors(@NotNull PostgresTable $receiver) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Set<Long> successorIds = $receiver.getSuccessorIds();
        if (successorIds.isEmpty()) {
            return SetsKt.emptySet();
        }
        PostgresSchema postgresSchema = $receiver.getSchema();
        if (postgresSchema == null) {
            return SetsKt.emptySet();
        }
        PostgresSchema schema = postgresSchema;
        Set<Long> set = successorIds;
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"successorIds");
        Iterable $receiver$iv = set;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void id;
            Long l = (Long)item$iv$iv;
            Collection collection = destination$iv$iv;
            PostgresSchema postgresSchema2 = schema;
            Intrinsics.checkExpressionValueIsNotNull((Object)postgresSchema2, (String)"schema");
            void v3 = id;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"id");
            PostgresTable postgresTable = PostgresModelFun.findTableByObjectId(postgresSchema2, v3.longValue());
            collection.add(postgresTable);
        }
        return CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
    }

    @Nullable
    public static final PostgresRoutine getCallRoutine(@NotNull PostgresTrigger $receiver) {
        PostgresDatabase database;
        PostgresSchema schema;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        long id = $receiver.getCallRoutineId();
        if (id == 0L) {
            return null;
        }
        PostgresSchema postgresSchema = $receiver.getSchema();
        if (postgresSchema == null) {
            return null;
        }
        PostgresSchema postgresSchema2 = schema = postgresSchema;
        Intrinsics.checkExpressionValueIsNotNull((Object)postgresSchema2, (String)"schema");
        PostgresRoutine routine = (PostgresRoutine)postgresSchema2.getRoutines().getByObjectId(id);
        if (routine == null && (database = schema.getDatabase()) != null) {
            for (PostgresSchema s : database.getSchemas()) {
                if (s == schema) continue;
                PostgresSchema postgresSchema3 = s;
                Intrinsics.checkExpressionValueIsNotNull((Object)postgresSchema3, (String)"s");
                routine = (PostgresRoutine)postgresSchema3.getRoutines().getByObjectId(id);
                if (routine == null) continue;
                break;
            }
        }
        return routine;
    }

    @Nullable
    public static final String getCallRoutineName(@NotNull PostgresTrigger $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PostgresRoutine postgresRoutine = PostgresModelFun.getCallRoutine($receiver);
        return postgresRoutine != null ? postgresRoutine.getName() : null;
    }

    @Nullable
    public static final PostgresBaseTable findTableByObjectId(@NotNull PostgresBaseDatabase $receiver, long id, @Nullable PostgresBaseSchema preferredSchema) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PostgresBaseTable table = null;
        if (preferredSchema != null) {
            table = PostgresModelFun.findTableByObjectId(preferredSchema, id);
        }
        if (table == null) {
            table = (PostgresBaseTable)$receiver.getSchemas().jbi().filter((Condition)new Condition<PostgresBaseSchema>(preferredSchema){
                final /* synthetic */ PostgresBaseSchema $preferredSchema;

                public final boolean value(PostgresBaseSchema s) {
                    return Intrinsics.areEqual((Object)s, (Object)this.$preferredSchema) ^ true;
                }
                {
                    this.$preferredSchema = postgresBaseSchema;
                }
            }).transform(new Function<E, T>(id){
                final /* synthetic */ long $id;

                @Nullable
                public final PostgresBaseTable fun(PostgresBaseSchema s) {
                    PostgresBaseSchema postgresBaseSchema = s;
                    Intrinsics.checkExpressionValueIsNotNull((Object)postgresBaseSchema, (String)"s");
                    return PostgresModelFun.findTableByObjectId(postgresBaseSchema, this.$id);
                }
                {
                    this.$id = l;
                }
            }).filter((Condition)findTableByObjectId.3.INSTANCE).first();
        }
        return table;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ PostgresBaseTable findTableByObjectId$default(PostgresBaseDatabase postgresBaseDatabase, long l, PostgresBaseSchema postgresBaseSchema, int n, Object object) {
        if ((n & 2) != 0) {
            postgresBaseSchema = null;
        }
        return PostgresModelFun.findTableByObjectId(postgresBaseDatabase, l, postgresBaseSchema);
    }

    @Nullable
    public static final PostgresTable findTableByObjectId(@NotNull PostgresSchema $receiver, long id) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PostgresLocalTable postgresLocalTable = (PostgresLocalTable)$receiver.getTables().getByObjectId(id);
        return postgresLocalTable != null ? (PostgresTable)postgresLocalTable : (PostgresTable)$receiver.getForeignTables().getByObjectId(id);
    }

    @Nullable
    public static final PostgresBaseTable findTableByObjectId(@NotNull PostgresBaseSchema $receiver, long id) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PostgresBaseSchema postgresBaseSchema = $receiver;
        return postgresBaseSchema instanceof PostgresSchema ? (PostgresBaseTable)PostgresModelFun.findTableByObjectId((PostgresSchema)$receiver, id) : (PostgresBaseTable)$receiver.getTables().getByObjectId(id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isCostDefined(@NotNull PostgresRoutine $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (Float.compare($receiver.getCost(), 0.0f) == 0) return false;
        if (StringsKt.equals((String)$receiver.getLanguageName(), (String)"c", (boolean)true)) {
            if (Float.compare($receiver.getCost(), 1.0f) == 0) return false;
            return true;
        }
        if (Float.compare($receiver.getCost(), 100) == 0) return false;
        return true;
    }

    @NotNull
    public static final String costAsString(@NotNull PostgresRoutine $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return PostgresModelFun.floatToString($receiver.getCost());
    }

    public static final boolean isRowsDefined(@NotNull PostgresRoutine $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Float.compare($receiver.getRows(), 0.0f) != 0 && Float.compare($receiver.getRows(), 1000) != 0;
    }

    @NotNull
    public static final String rowsAsString(@NotNull PostgresRoutine $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return PostgresModelFun.floatToString($receiver.getRows());
    }

    public static final boolean hasDefaultType(@NotNull PostgresSequence $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getDataType() == null || StringsKt.equals((String)$receiver.getDataType(), (String)"bigint", (boolean)true);
    }

    public static final boolean hasDefaultCacheSize(@NotNull PostgresSequence $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        long l = $receiver.getCacheSize();
        return 0L <= l && 1L >= l;
    }

    private static final String floatToString(float f) {
        float f2 = f;
        return Float.isInfinite(f2) ? "infinity" : String.valueOf((long)f);
    }
}

