/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.postgres.PostgresRoutineArgument;
import com.intellij.database.model.postgres.PostgresSchema;
import com.intellij.database.model.postgresbase.PostgresBaseObjectWithOwner;
import com.intellij.database.model.postgresbase.PostgresBaseRoutine;
import com.intellij.database.model.properties.PostgresRoutineConcurrencyKind;
import com.intellij.database.model.properties.PostgresVolatilityKind;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.SourceError;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresRoutine
extends PostgresBaseRoutine,
PostgresBaseObjectWithOwner,
BasicIdentifiedElement,
BasicNamedElement {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.ROUTINE;
        if (objectKind == null) {
            PostgresRoutine.$$$reportNull$$$0(0);
        }
        return objectKind;
    }

    @Override
    @Nullable
    public PostgresSchema getSchema();

    @Override
    @Nullable
    default public PostgresSchema getParent() {
        return this.getSchema();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends PostgresRoutine> getParentFamily() {
        return null;
    }

    @Override
    @NotNull
    public @NotNull PositioningNamingFamily<@NotNull ? extends PostgresRoutineArgument> getArguments();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.singletonList(ObjectKind.ARGUMENT);
        if (list == null) {
            PostgresRoutine.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<Iterable> list = Collections.singletonList(this.getArguments());
        if (list == null) {
            PostgresRoutine.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @Nullable
    default public String getOwner() {
        return null;
    }

    @Override
    default public boolean isFaceless() {
        return false;
    }

    @Override
    default public int getSourceTextLength() {
        return 0;
    }

    @Override
    @NotNull
    default public List<SourceError> getErrors() {
        List<SourceError> list = Collections.emptyList();
        if (list == null) {
            PostgresRoutine.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    default public boolean isInvalid() {
        return false;
    }

    @Override
    default public long getStateNumber() {
        return 0L;
    }

    @Override
    @Nullable
    default public PostgresVolatilityKind getVolatilityKind() {
        return null;
    }

    @Override
    @Nullable
    default public String getArgumentsDefinition() {
        return null;
    }

    @Override
    @Nullable
    default public String getResultsDefinition() {
        return null;
    }

    @Override
    @Nullable
    default public String getLanguageName() {
        return null;
    }

    @NotNull
    default public List<String> getConfigurationParameters() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            PostgresRoutine.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    default public DasRoutine.Kind getRoutineKind() {
        DasRoutine.Kind kind = DasRoutine.Kind.NONE;
        if (kind == null) {
            PostgresRoutine.$$$reportNull$$$0(5);
        }
        return kind;
    }

    @NotNull
    default public PostgresRoutineConcurrencyKind getConcurrencyKind() {
        PostgresRoutineConcurrencyKind postgresRoutineConcurrencyKind = PostgresRoutineConcurrencyKind.UNSAFE;
        if (postgresRoutineConcurrencyKind == null) {
            PostgresRoutine.$$$reportNull$$$0(6);
        }
        return postgresRoutineConcurrencyKind;
    }

    @Override
    default public boolean isReturnsSet() {
        return false;
    }

    default public boolean isStrict() {
        return false;
    }

    default public boolean isSecurityDefiner() {
        return false;
    }

    default public boolean isWindow() {
        return false;
    }

    default public boolean isLeakproof() {
        return false;
    }

    default public float getCost() {
        return 0.0f;
    }

    default public float getRows() {
        return 0.0f;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer2) {
        float rows;
        float cost;
        boolean leakproof;
        boolean window;
        boolean securityDefiner;
        boolean strict;
        boolean returnsSet;
        PostgresRoutineConcurrencyKind concurrencyKind;
        DasRoutine.Kind routineKind;
        List<String> configurationParameters;
        String languageName;
        String resultsDefinition;
        String argumentsDefinition;
        PostgresVolatilityKind volatilityKind;
        long stateNumber;
        boolean invalid;
        int sourceTextLength;
        boolean faceless;
        String owner;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        long objectId;
        if (consumer2 == null) {
            PostgresRoutine.$$$reportNull$$$0(7);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer2.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer2.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer2.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer2.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer2.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer2.accept("Comment", PropertyConverter.export(comment));
        }
        if ((owner = this.getOwner()) != null) {
            consumer2.accept("Owner", PropertyConverter.export(owner));
        }
        if (faceless = this.isFaceless()) {
            consumer2.accept("Faceless", PropertyConverter.export(faceless));
        }
        if ((sourceTextLength = this.getSourceTextLength()) != 0) {
            consumer2.accept("SourceTextLength", PropertyConverter.export(sourceTextLength));
        }
        if (invalid = this.isInvalid()) {
            consumer2.accept("Invalid", PropertyConverter.export(invalid));
        }
        if ((stateNumber = this.getStateNumber()) != 0L) {
            consumer2.accept("StateNumber", PropertyConverter.export(stateNumber));
        }
        if ((volatilityKind = this.getVolatilityKind()) != null) {
            consumer2.accept("VolatilityKind", PropertyConverter.export(volatilityKind));
        }
        if ((argumentsDefinition = this.getArgumentsDefinition()) != null) {
            consumer2.accept("ArgumentsDefinition", PropertyConverter.export(argumentsDefinition));
        }
        if ((resultsDefinition = this.getResultsDefinition()) != null) {
            consumer2.accept("ResultsDefinition", PropertyConverter.export(resultsDefinition));
        }
        if ((languageName = this.getLanguageName()) != null) {
            consumer2.accept("LanguageName", PropertyConverter.export(languageName));
        }
        if (!(configurationParameters = this.getConfigurationParameters()).isEmpty()) {
            consumer2.accept("ConfigurationParameters", PropertyConverter.exportListOfString(configurationParameters));
        }
        if ((routineKind = this.getRoutineKind()) != null && routineKind != DasRoutine.Kind.NONE) {
            consumer2.accept("RoutineKind", PropertyConverter.export((Enum)routineKind));
        }
        if ((concurrencyKind = this.getConcurrencyKind()) != null && concurrencyKind != PostgresRoutineConcurrencyKind.UNSAFE) {
            consumer2.accept("ConcurrencyKind", PropertyConverter.export(concurrencyKind));
        }
        if (returnsSet = this.isReturnsSet()) {
            consumer2.accept("ReturnsSet", PropertyConverter.export(returnsSet));
        }
        if (strict = this.isStrict()) {
            consumer2.accept("Strict", PropertyConverter.export(strict));
        }
        if (securityDefiner = this.isSecurityDefiner()) {
            consumer2.accept("SecurityDefiner", PropertyConverter.export(securityDefiner));
        }
        if (window = this.isWindow()) {
            consumer2.accept("Window", PropertyConverter.export(window));
        }
        if (leakproof = this.isLeakproof()) {
            consumer2.accept("Leakproof", PropertyConverter.export(leakproof));
        }
        if ((cost = this.getCost()) != 0.0f) {
            consumer2.accept("Cost", PropertyConverter.export(cost));
        }
        if ((rows = this.getRows()) != 0.0f) {
            consumer2.accept("Rows", PropertyConverter.export(rows));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "Owner", "Faceless", "SourceTextLength", "Errors", "Invalid", "StateNumber", "VolatilityKind", "ArgumentsDefinition", "ResultsDefinition", "LanguageName", "ConfigurationParameters", "RoutineKind", "ConcurrencyKind", "ReturnsSet", "Strict", "SecurityDefiner", "Window", "Leakproof", "Cost", "Rows");
        if (list == null) {
            PostgresRoutine.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/postgres/PostgresRoutine";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationParameters";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoutineKind";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConcurrencyKind";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/postgres/PostgresRoutine";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

