/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties;

import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataTypeFactory {
    private static final Pattern INNER_PATTERN = Pattern.compile("^\\s*(\\d+|\\*|max)\\s*(,\\s*(-?\\d+))?\\s*(chars?|bytes?|digits?)?\\s*$", 2);
    private static final ConcurrentMap<DataType, DataType> ourInterner = ContainerUtil.createConcurrentWeakKeyWeakValueMap();

    @NotNull
    public static DataType of(@NotNull String specification) {
        if (specification == null) {
            DataTypeFactory.$$$reportNull$$$0(0);
        }
        DataType dataType = DataTypeFactory.of(specification, 0, false, false, null, false);
        if (dataType == null) {
            DataTypeFactory.$$$reportNull$$$0(1);
        }
        return dataType;
    }

    @NotNull
    public static DataType of(@NotNull String specification, int jdbcType, boolean custom, boolean hasPackage, @Nullable Variant v, boolean explicitUnits) {
        if (specification == null) {
            DataTypeFactory.$$$reportNull$$$0(2);
        }
        Trio trio = DataTypeFactory.smartSplit(specification);
        if (trio.inner != null) {
            boolean isCustom;
            boolean ok;
            if (v == null && (trio.primary.equalsIgnoreCase("enum") || trio.primary.equalsIgnoreCase("set")) || v == Variant.ENUM) {
                DataType dataType = DataTypeFactory.createEnumOrRet(specification, custom, hasPackage, jdbcType);
                if (dataType == null) {
                    DataTypeFactory.$$$reportNull$$$0(3);
                }
                return dataType;
            }
            TypeAsParts packAndName = DataTypeFactory.splitPackAndName(trio.primary, hasPackage);
            Matcher m = v == Variant.VAGUE ? null : INNER_PATTERN.matcher(trio.inner);
            boolean bl = ok = m != null && m.matches();
            boolean bl2 = v == null ? packAndName.schemaName != null : (isCustom = custom);
            if (ok) {
                LengthUnit unit;
                String sizeStr = m.group(1);
                int size = sizeStr.equals("*") ? 0x7FFFFFFE : (sizeStr.equalsIgnoreCase("max") ? Integer.MAX_VALUE : Integer.parseInt(sizeStr));
                int scale = m.group(3) != null ? Integer.parseInt(m.group(3)) : 0;
                LengthUnit lengthUnit = unit = m.group(4) != null ? LengthUnit.of((String)m.group(4)) : null;
                if (v == null && unit == null && scale != 0) {
                    unit = LengthUnit.DIGIT;
                }
                if (v == null) {
                    explicitUnits = m.group(4) != null;
                }
                DataType dataType = DataTypeFactory.of(packAndName.schemaName, packAndName.packageName, packAndName.typeName, size, scale, unit, trio.suffix, explicitUnits, isCustom, jdbcType);
                if (dataType == null) {
                    DataTypeFactory.$$$reportNull$$$0(4);
                }
                return dataType;
            }
            if (!trio.inner.isEmpty()) {
                DataType dataType = DataTypeFactory.ofArgs(packAndName.schemaName, packAndName.packageName, packAndName.typeName, trio.inner, custom, jdbcType);
                if (dataType == null) {
                    DataTypeFactory.$$$reportNull$$$0(5);
                }
                return dataType;
            }
            DataType dataType = DataTypeFactory.of(packAndName.schemaName, packAndName.packageName, packAndName.typeName, -1, 0, null, trio.suffix, false, isCustom, jdbcType);
            if (dataType == null) {
                DataTypeFactory.$$$reportNull$$$0(6);
            }
            return dataType;
        }
        TypeAsParts packAndName = DataTypeFactory.splitPackAndName(trio.primary, hasPackage);
        DataType dataType = DataTypeFactory.of(packAndName.schemaName, packAndName.packageName, packAndName.typeName, -1, 0, LengthUnit.NONE, trio.suffix, explicitUnits, v == null ? packAndName.schemaName != null : custom, jdbcType);
        if (dataType == null) {
            DataTypeFactory.$$$reportNull$$$0(7);
        }
        return dataType;
    }

    @Contract(pure=true)
    private static Trio smartSplit(@NotNull String specification) {
        if (specification == null) {
            DataTypeFactory.$$$reportNull$$$0(8);
        }
        if (StringUtil.startsWithIgnoreCase((String)specification, (String)"setof ")) {
            Trio res = new Trio();
            res.primary = "setof";
            res.suffix = StringUtil.trim((String)specification.substring("setof ".length()));
            return res;
        }
        int n = specification.length();
        int p1 = Integer.MIN_VALUE;
        int p2 = Integer.MIN_VALUE;
        Stack<Character> stack = new Stack<Character>();
        block5: for (int i2 = 0; i2 < n; ++i2) {
            char x;
            char c = specification.charAt(i2);
            char c2 = x = stack.isEmpty() ? (char)'\u0000' : ((Character)stack.peek()).charValue();
            if (c == '(' && p1 < 0 && stack.isEmpty()) {
                p1 = i2;
            }
            if (c == ')' && p1 >= 0 && p2 < 0 && stack.size() == 1 && x == ')') {
                p2 = i2;
            }
            if (c == x) {
                stack.pop();
                if (!stack.isEmpty() || p2 <= 0) continue;
                break;
            }
            switch (c) {
                case '\"': 
                case '\'': {
                    stack.push(Character.valueOf(c));
                    continue block5;
                }
                case '[': {
                    stack.push(Character.valueOf(']'));
                    continue block5;
                }
                case '(': {
                    stack.push(Character.valueOf(')'));
                }
            }
        }
        Trio trio = new Trio();
        if (p2 > 0) {
            assert (p1 >= 0);
            trio.primary = specification.substring(0, p1).trim();
            trio.inner = specification.substring(p1 + 1, p2).trim();
            trio.suffix = specification.substring(p2 + 1).trim();
            if (trio.suffix.length() == 0) {
                trio.suffix = null;
            }
        } else {
            trio.primary = specification.trim();
        }
        return trio;
    }

    @NotNull
    private static DataType createEnumOrRet(@NotNull String specification, boolean custom, boolean hasPackage, int jdbcType) {
        if (specification == null) {
            DataTypeFactory.$$$reportNull$$$0(9);
        }
        ArrayList res = ContainerUtil.newArrayList();
        int start = specification.indexOf("(");
        int end = StringUtil.lastIndexOf((CharSequence)specification, (char)')', (int)start, (int)specification.length());
        if (end > start && start > 1) {
            String meat = specification.substring(start + 1, end);
            for (String s : StringUtil.split((String)meat, (String)",")) {
                res.add(StringUtil.trim((String)s));
            }
            TypeAsParts couple = DataTypeFactory.splitPackAndName(specification.substring(0, start), hasPackage);
            DataType dataType = DataTypeFactory.ofValues(couple.schemaName, couple.packageName, couple.typeName, (List<String>)ContainerUtil.immutableList((List)res), custom, jdbcType);
            if (dataType == null) {
                DataTypeFactory.$$$reportNull$$$0(10);
            }
            return dataType;
        }
        DataType dataType = DataType.UNKNOWN;
        if (dataType == null) {
            DataTypeFactory.$$$reportNull$$$0(11);
        }
        return dataType;
    }

    @NotNull
    public static DataType ofArgs(@Nullable String schemaName, @NotNull String typeName, @Nullable String vagueArg, boolean custom) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(12);
        }
        DataType dataType = DataTypeFactory.ofArgs(schemaName, null, typeName, vagueArg, custom, 0);
        if (dataType == null) {
            DataTypeFactory.$$$reportNull$$$0(13);
        }
        return dataType;
    }

    @NotNull
    public static DataType ofArgs(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName, @Nullable String vagueArg, boolean custom, int jdbcType) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(14);
        }
        DataType type = new DataType(schemaName, packageName, typeName, vagueArg, custom, jdbcType);
        DataType dataType = DataTypeFactory.intern(type);
        if (dataType == null) {
            DataTypeFactory.$$$reportNull$$$0(15);
        }
        return dataType;
    }

    @NotNull
    public static DataType of(@Nullable String schemaName, @NotNull String typeName, int size, int scale, @Nullable LengthUnit sizeUnit, @Nullable String suffix, boolean sizeUnitExplicit, boolean custom, int jdbcType) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(16);
        }
        DataType dataType = DataTypeFactory.of(schemaName, null, typeName, size, scale, sizeUnit, suffix, sizeUnitExplicit, custom, jdbcType);
        if (dataType == null) {
            DataTypeFactory.$$$reportNull$$$0(17);
        }
        return dataType;
    }

    @NotNull
    public static DataType of(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName, int size, int scale, @Nullable LengthUnit sizeUnit, @Nullable String suffix, boolean sizeUnitExplicit, boolean custom, int jdbcType) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(18);
        }
        DataType dataType = DataTypeFactory.intern(new DataType(schemaName, packageName, typeName, size, scale, sizeUnit, sizeUnitExplicit, suffix, custom, jdbcType));
        if (dataType == null) {
            DataTypeFactory.$$$reportNull$$$0(19);
        }
        return dataType;
    }

    @NotNull
    public static DataType of(@Nullable String schemaName, @NotNull String typeName, int size, int scale, @Nullable LengthUnit sizeUnit, @Nullable String suffix, boolean sizeUnitExplicit, boolean custom) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(20);
        }
        DataType dataType = DataTypeFactory.of(schemaName, typeName, size, scale, sizeUnit, suffix, sizeUnitExplicit, custom, 0);
        if (dataType == null) {
            DataTypeFactory.$$$reportNull$$$0(21);
        }
        return dataType;
    }

    @NotNull
    public static DataType of(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName, int size, int scale, @Nullable LengthUnit sizeUnit, @Nullable String suffix, boolean sizeUnitExplicit, boolean custom) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(22);
        }
        DataType dataType = DataTypeFactory.of(schemaName, packageName, typeName, size, scale, sizeUnit, suffix, sizeUnitExplicit, custom, 0);
        if (dataType == null) {
            DataTypeFactory.$$$reportNull$$$0(23);
        }
        return dataType;
    }

    @NotNull
    public static DataType ofValues(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName, @NotNull List<String> values2, boolean custom, int jdbcType) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(24);
        }
        if (values2 == null) {
            DataTypeFactory.$$$reportNull$$$0(25);
        }
        DataType type = new DataType(schemaName, packageName, typeName, custom, values2, jdbcType);
        DataType dataType = DataTypeFactory.intern(type);
        if (dataType == null) {
            DataTypeFactory.$$$reportNull$$$0(26);
        }
        return dataType;
    }

    @NotNull
    private static TypeAsParts splitPackAndName(@NotNull String string, boolean hasPackage) {
        int typeNameStartOffset;
        if (string == null) {
            DataTypeFactory.$$$reportNull$$$0(27);
        }
        if ((typeNameStartOffset = string.lastIndexOf(46)) < 0) {
            TypeAsParts typeAsParts = new TypeAsParts(null, null, string.trim());
            if (typeAsParts == null) {
                DataTypeFactory.$$$reportNull$$$0(28);
            }
            return typeAsParts;
        }
        String qualifier = string.substring(0, typeNameStartOffset);
        String typeName = string.substring(typeNameStartOffset + 1).trim();
        if (!hasPackage) {
            TypeAsParts typeAsParts = new TypeAsParts(qualifier, null, typeName);
            if (typeAsParts == null) {
                DataTypeFactory.$$$reportNull$$$0(29);
            }
            return typeAsParts;
        }
        int packageStartOffset = qualifier.lastIndexOf(46);
        if (packageStartOffset < 0) {
            TypeAsParts typeAsParts = new TypeAsParts(null, qualifier, typeName);
            if (typeAsParts == null) {
                DataTypeFactory.$$$reportNull$$$0(30);
            }
            return typeAsParts;
        }
        String schemaName = qualifier.substring(0, packageStartOffset);
        String packageName = qualifier.substring(packageStartOffset + 1);
        TypeAsParts typeAsParts = new TypeAsParts(schemaName, packageName, typeName);
        if (typeAsParts == null) {
            DataTypeFactory.$$$reportNull$$$0(31);
        }
        return typeAsParts;
    }

    @NotNull
    private static DataType intern(@NotNull DataType dataType) {
        if (dataType == null) {
            DataTypeFactory.$$$reportNull$$$0(32);
        }
        DataType dataType2 = (DataType)ConcurrencyUtil.cacheOrGet(ourInterner, (Object)dataType, (Object)dataType);
        if (dataType2 == null) {
            DataTypeFactory.$$$reportNull$$$0(33);
        }
        return dataType2;
    }

    @NotNull
    public static String serialize(@NotNull DataType value) {
        if (value == null) {
            DataTypeFactory.$$$reportNull$$$0(34);
        }
        StringBuilder res = new StringBuilder();
        res.append(value.getSpecification(true)).append("|").append(value.jdbcType);
        if (value.sizeUnitExplicit) {
            res.append("u");
        }
        if (value.custom) {
            res.append("c");
        }
        if (value.packageName != null) {
            res.append("p");
        }
        res.append(Variant.of(value).code);
        String string = res.toString();
        if (string == null) {
            DataTypeFactory.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    public static DataType deserialize(@NotNull String value) {
        int idx;
        if (value == null) {
            DataTypeFactory.$$$reportNull$$$0(36);
        }
        if ((idx = value.lastIndexOf("|")) != -1) {
            DataType dataType;
            try {
                boolean explicitUnit;
                boolean custom;
                boolean hasPackage;
                int e = value.length();
                Variant v = Variant.of(value.charAt(e - 1));
                if (v != null) {
                    --e;
                }
                boolean bl = hasPackage = value.charAt(e - 1) == 'p';
                if (hasPackage) {
                    --e;
                }
                boolean bl2 = custom = value.charAt(e - 1) == 'c';
                if (custom) {
                    --e;
                }
                boolean bl3 = explicitUnit = value.charAt(e - 1) == 'u';
                if (explicitUnit) {
                    --e;
                }
                dataType = DataTypeFactory.of(value.substring(0, idx), Integer.parseInt(value.substring(idx + 1, e)), custom, hasPackage, v, explicitUnit);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (dataType == null) {
                DataTypeFactory.$$$reportNull$$$0(37);
            }
            return dataType;
        }
        DataType dataType = DataTypeFactory.of(value);
        if (dataType == null) {
            DataTypeFactory.$$$reportNull$$$0(38);
        }
        return dataType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specification";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/properties/DataTypeFactory";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/properties/DataTypeFactory";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "of";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createEnumOrRet";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "ofArgs";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "ofValues";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "splitPackAndName";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "intern";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "serialize";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 38: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "smartSplit";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createEnumOrRet";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "ofArgs";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "ofValues";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "splitPackAndName";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "intern";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum Variant {
        SIZED('s'),
        VAGUE('v'),
        ENUM('e');

        private final char code;

        private Variant(char c) {
            this.code = c;
        }

        @Nullable
        static Variant of(char c) {
            for (Variant v : Variant.values()) {
                if (v.code != c) continue;
                return v;
            }
            return null;
        }

        @NotNull
        static Variant of(@NotNull DataType dt) {
            if (dt == null) {
                Variant.$$$reportNull$$$0(0);
            }
            if (dt.vagueArg != null) {
                Variant variant = VAGUE;
                if (variant == null) {
                    Variant.$$$reportNull$$$0(1);
                }
                return variant;
            }
            if (dt.enumValues != null) {
                Variant variant = ENUM;
                if (variant == null) {
                    Variant.$$$reportNull$$$0(2);
                }
                return variant;
            }
            Variant variant = SIZED;
            if (variant == null) {
                Variant.$$$reportNull$$$0(3);
            }
            return variant;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dt";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/properties/DataTypeFactory$Variant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/properties/DataTypeFactory$Variant";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "of";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "of";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TypeAsParts {
        final String schemaName;
        final String packageName;
        final String typeName;

        TypeAsParts(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName) {
            if (typeName == null) {
                TypeAsParts.$$$reportNull$$$0(0);
            }
            this.schemaName = schemaName;
            this.packageName = packageName;
            this.typeName = typeName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/database/model/properties/DataTypeFactory$TypeAsParts", "<init>"));
        }
    }

    private static class Trio {
        String primary;
        String inner;
        String suffix;

        private Trio() {
        }
    }
}

